/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateVersionDefault
extends EnrollExtDefault {
    public static final Logger logger = LoggerFactory.getLogger(CertificateVersionDefault.class);
    public static final String CONFIG_VERSION = "certVersionNum";
    public static final String VAL_VERSION = "certVersionNum";
    private static final String CMS_INVALID_PROPERTY = "CMS_INVALID_PROPERTY";

    public CertificateVersionDefault() {
        this.addValueName("certVersionNum");
        this.addConfigName("certVersionNum");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("certVersionNum")) {
            return new Descriptor("integer", null, "3", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VERSION", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals("certVersionNum")) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)CMS_INVALID_PROPERTY, (String[])new String[]{"certVersionNum"}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("certVersionNum")) {
            return new Descriptor("integer", null, "3", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VERSION", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        block10: {
            try {
                if (name == null) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
                }
                if (name.equals("certVersionNum")) {
                    if (value == null || value.equals("")) {
                        throw new EPropertyException(name + " cannot be empty");
                    }
                    int version = Integer.parseInt(value) - 1;
                    if (version == 0) {
                        info.set("version", (Object)new CertificateVersion(0));
                    } else if (version == 1) {
                        info.set("version", (Object)new CertificateVersion(1));
                    } else if (version == 2) {
                        info.set("version", (Object)new CertificateVersion(2));
                    }
                    break block10;
                }
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
            }
            catch (IOException | CertificateException e) {
                logger.warn("CertificateVersionDefault: setValue " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
        }
        if (name.equals("certVersionNum")) {
            CertificateVersion v = null;
            try {
                v = (CertificateVersion)info.get("version");
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
            }
            int version = v.compare(0);
            return "" + (version + 1);
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("certVersionNum")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_CERT_VERSION", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        block5: {
            String v = this.getConfig("certVersionNum");
            int version = Integer.parseInt(v) - 1;
            try {
                if (version == 0) {
                    info.set("version", (Object)new CertificateVersion(0));
                    break block5;
                }
                if (version == 1) {
                    info.set("version", (Object)new CertificateVersion(1));
                    break block5;
                }
                if (version == 2) {
                    info.set("version", (Object)new CertificateVersion(2));
                    break block5;
                }
                throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)CMS_INVALID_PROPERTY, (String[])new String[]{"certVersionNum"}));
            }
            catch (IOException | CertificateException exception) {
                // empty catch block
            }
        }
    }
}

