/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.EnrollProfile;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCUserSignedSubjectNameDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(CMCUserSignedSubjectNameDefault.class);
    public static final String VAL_NAME = "name";

    public CMCUserSignedSubjectNameDefault() {
        this.addValueName(VAL_NAME);
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            X500Name x500name = null;
            try {
                x500name = new X500Name(value);
            }
            catch (IOException e) {
                logger.warn("CMCUserSignedSubjectNameDefault: " + e.getMessage(), (Throwable)e);
            }
            logger.debug("SubjectNameDefault: setValue name=" + x500name);
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.error("CMCUserSignedSubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            CertificateSubjectName sn = null;
            try {
                sn = (CertificateSubjectName)info.get("subject");
                return sn.toString();
            }
            catch (Exception exception) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_CMC_USER_SIGNED_SUBJECT_NAME", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        String method = "CMCUserSignedSubjectNameDefault: populate: ";
        Object msg = "";
        logger.debug(method + "begins");
        if (info == null) {
            msg = method + "info null";
            logger.error((String)msg);
            throw new EProfileException((String)msg);
        }
        String signingUserSerial = request.getExtDataInString("cmcSigningCert");
        if (signingUserSerial == null) {
            msg = method + "signing user serial not found; request was unsigned?";
            logger.error((String)msg);
            throw new EProfileException((String)msg);
        }
        CertificateSubjectName certSN = null;
        try {
            certSN = EnrollProfile.getCMCSigningCertSNfromCertSerial(signingUserSerial);
            info.set("subject", (Object)certSN);
            logger.debug(method + "subjectDN set in X509CertInfo");
        }
        catch (Exception e) {
            msg = method + "exception thrown:" + e;
            throw new EProfileException(e.toString());
        }
        request.setExtData("req_x509info", info);
        logger.debug(method + "ends");
    }
}

