/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.security.cert.CertificateException;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CAEnrollDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(CAEnrollDefault.class);

    public KeyIdentifier getKeyIdentifier(X509CertInfo info) {
        String method = "CAEnrollDefault: getKeyIdentifier: ";
        try {
            CertificateX509Key ckey = (CertificateX509Key)info.get("key");
            X509Key key = (X509Key)ckey.get("value");
            byte[] hash = CryptoUtil.generateKeyIdentifier((byte[])key.getKey());
            if (hash == null) {
                logger.warn(method + "CryptoUtil.generateKeyIdentifier returns null");
                return null;
            }
            return new KeyIdentifier(hash);
        }
        catch (IOException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public KeyIdentifier getCAKeyIdentifier(X509CertImpl caCert) throws EBaseException {
        byte[] hash;
        String method = "CAEnrollDefault: getCAKeyIdentifier: ";
        if (caCert == null) {
            return null;
        }
        X509Key key = (X509Key)caCert.getPublicKey();
        SubjectKeyIdentifierExtension subjKeyIdExt = (SubjectKeyIdentifierExtension)caCert.getExtension(PKIXExtensions.SubjectKey_Id.toString());
        if (subjKeyIdExt != null) {
            try {
                KeyIdentifier keyId = (KeyIdentifier)subjKeyIdExt.get("key_id");
                return keyId;
            }
            catch (IOException keyId) {
                // empty catch block
            }
        }
        if ((hash = CryptoUtil.generateKeyIdentifier((byte[])key.getKey())) == null) {
            logger.warn(method + "CryptoUtil.generateKeyIdentifier returns null");
            return null;
        }
        return new KeyIdentifier(hash);
    }
}

