/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.CAValidityDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.RandomizedValidityDefault;
import com.netscape.cms.profile.def.UserValidityDefault;
import com.netscape.cms.profile.def.ValidityDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateValidity;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidityConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(ValidityConstraint.class);
    public static final String CONFIG_RANGE = "range";
    public static final String CONFIG_RANGE_UNIT = "rangeUnit";
    public static final String CONFIG_NOT_BEFORE_GRACE_PERIOD = "notBeforeGracePeriod";
    public static final String CONFIG_CHECK_NOT_BEFORE = "notBeforeCheck";
    public static final String CONFIG_CHECK_NOT_AFTER = "notAfterCheck";
    public static final long SECS_IN_MS = 1000L;

    public ValidityConstraint() {
        this.addConfigName(CONFIG_RANGE);
        this.addConfigName(CONFIG_RANGE_UNIT);
        this.addConfigName(CONFIG_NOT_BEFORE_GRACE_PERIOD);
        this.addConfigName(CONFIG_CHECK_NOT_BEFORE);
        this.addConfigName(CONFIG_CHECK_NOT_AFTER);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals(CONFIG_RANGE) || name.equals(CONFIG_NOT_BEFORE_GRACE_PERIOD)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_RANGE)) {
            return new Descriptor("integer", null, "365", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_RANGE_UNIT)) {
            return new Descriptor("string", null, "day", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_RANGE_UNIT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_NOT_BEFORE_GRACE_PERIOD)) {
            return new Descriptor("integer", null, "0", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_NOT_BEFORE_GRACE_PERIOD", (String[])new String[0]));
        }
        if (name.equals(CONFIG_CHECK_NOT_BEFORE)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_CHECK_NOT_BEFORE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_CHECK_NOT_AFTER)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_VALIDITY_CHECK_NOT_AFTER", (String[])new String[0]));
        }
        return null;
    }

    public int convertRangeUnit(String unit) throws Exception {
        if (unit.equals("year")) {
            return 1;
        }
        if (unit.equals("month")) {
            return 2;
        }
        if (unit.equals("day") || unit.equals("")) {
            return 6;
        }
        if (unit.equals("hour")) {
            return 11;
        }
        if (unit.equals("minute")) {
            return 12;
        }
        throw new Exception("Invalid range unit: " + unit);
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        int rangeUnit;
        Date notAfter;
        Date notBefore;
        CertificateValidity v;
        try {
            v = (CertificateValidity)info.get("validity");
        }
        catch (Exception e) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_VALIDITY_NOT_FOUND", (String[])new String[0]));
        }
        try {
            notBefore = (Date)v.get("notBefore");
            logger.debug("ValidityConstraint: not before: " + notBefore);
        }
        catch (IOException e) {
            logger.error("ValidityConstraint: not before not found: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_VALIDITY_NOT_FOUND", (String[])new String[0]));
        }
        try {
            notAfter = (Date)v.get("notAfter");
            logger.debug("ValidityConstraint: not after: " + notAfter);
        }
        catch (IOException e) {
            logger.error("ValidityConstraint: not after not found: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_VALIDITY_NOT_FOUND", (String[])new String[0]));
        }
        if (notAfter.getTime() < notBefore.getTime()) {
            logger.debug("ValidityConstraint: notAfter (" + notAfter + ") < notBefore (" + notBefore + ")");
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NOT_AFTER_BEFORE_NOT_BEFORE", (String[])new String[0]));
        }
        String rangeStr = this.getConfig(CONFIG_RANGE, "365");
        logger.debug("ValidityConstraint: range: " + rangeStr);
        int range = Integer.parseInt(rangeStr);
        String rangeUnitStr = this.getConfig(CONFIG_RANGE_UNIT, "day");
        logger.debug("ValidityConstraint: range unit: " + rangeUnitStr);
        try {
            rangeUnit = this.convertRangeUnit(rangeUnitStr);
        }
        catch (Exception e) {
            logger.error("ValidityConstraint: invalid range unit: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_VALIDITY_INVALID_RANGE_UNIT", (String[])new String[]{rangeUnitStr}));
        }
        Calendar date = Calendar.getInstance();
        date.setTime(notBefore);
        date.add(rangeUnit, range);
        Date limit = date.getTime();
        logger.debug("ValidityConstraint: limit: " + limit);
        if (notAfter.after(limit)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_VALIDITY_OUT_OF_RANGE", (String[])new String[]{notAfter.toString(), limit.toString()}));
        }
        String notBeforeCheckStr = this.getConfig(CONFIG_CHECK_NOT_BEFORE);
        if (notBeforeCheckStr == null || notBeforeCheckStr.equals("")) {
            notBeforeCheckStr = "false";
        }
        boolean notBeforeCheck = Boolean.valueOf(notBeforeCheckStr);
        String notAfterCheckStr = this.getConfig(CONFIG_CHECK_NOT_AFTER);
        if (notAfterCheckStr == null || notAfterCheckStr.equals("")) {
            notAfterCheckStr = "false";
        }
        boolean notAfterCheck = Boolean.valueOf(notAfterCheckStr);
        String notBeforeGracePeriodStr = this.getConfig(CONFIG_NOT_BEFORE_GRACE_PERIOD);
        if (notBeforeGracePeriodStr == null || notBeforeGracePeriodStr.equals("")) {
            notBeforeGracePeriodStr = "0";
        }
        long notBeforeGracePeriod = Long.parseLong(notBeforeGracePeriodStr) * 1000L;
        Date current = new Date();
        if (notBeforeCheck && notBefore.getTime() > current.getTime() + notBeforeGracePeriod) {
            logger.debug("ValidityConstraint: notBefore (" + notBefore + ") > current + gracePeriod (" + new Date(current.getTime() + notBeforeGracePeriod) + ")");
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NOT_BEFORE_AFTER_CURRENT", (String[])new String[0]));
        }
        if (notAfterCheck && notAfter.getTime() < current.getTime()) {
            logger.debug("ValidityConstraint: notAfter (" + notAfter + ") <  current + (" + current + ")");
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_NOT_AFTER_BEFORE_CURRENT", (String[])new String[0]));
        }
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_VALIDITY_TEXT", (String[])new String[]{this.getConfig(CONFIG_RANGE)});
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof UserValidityDefault) {
            return true;
        }
        if (def instanceof ValidityDefault) {
            return true;
        }
        if (def instanceof CAValidityDefault) {
            return true;
        }
        return def instanceof RandomizedValidityDefault;
    }
}

