/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewGracePeriodConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(RenewGracePeriodConstraint.class);
    public static final String CONFIG_RENEW_GRACE_BEFORE = "renewal.graceBefore";
    public static final String CONFIG_RENEW_GRACE_AFTER = "renewal.graceAfter";

    public RenewGracePeriodConstraint() {
        this.addConfigName(CONFIG_RENEW_GRACE_BEFORE);
        this.addConfigName(CONFIG_RENEW_GRACE_AFTER);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (name.equals(CONFIG_RENEW_GRACE_BEFORE) || name.equals(CONFIG_RENEW_GRACE_AFTER)) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new EPropertyException(CMS.getUserMessage((String)"CMS_INVALID_PROPERTY", (String[])new String[]{"renewal.graceBefore or renewal.graceAfter"}));
            }
        }
        super.setConfig(name, value);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_RENEW_GRACE_BEFORE)) {
            return new Descriptor("integer", null, "30", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_RENEW_GRACE_BEFORE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_RENEW_GRACE_AFTER)) {
            return new Descriptor("integer", null, "30", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_RENEW_GRACE_AFTER", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request req, X509CertInfo info) throws ERejectException {
        String method = "RenewGracePeriodConstraint: validate: ";
        Object msg = "";
        String origExpDate_s = req.getExtDataInString("origNotAfter");
        if (origExpDate_s == null) {
            logger.debug(method + " original cert expiration date not found...return without validation");
            return;
        }
        logger.debug(method + " original cert expiration date found... validating");
        BigInteger origExpDate_BI = new BigInteger(origExpDate_s);
        Date origExpDate = new Date(origExpDate_BI.longValue());
        String renew_grace_before_s = this.getConfig(CONFIG_RENEW_GRACE_BEFORE);
        String renew_grace_after_s = this.getConfig(CONFIG_RENEW_GRACE_AFTER);
        int renew_grace_before = 0;
        int renew_grace_after = 0;
        BigInteger renew_grace_before_BI = new BigInteger(renew_grace_before_s);
        BigInteger renew_grace_after_BI = new BigInteger(renew_grace_after_s);
        renew_grace_before = renew_grace_before_s == "" ? -1 : Integer.parseInt(renew_grace_before_s);
        renew_grace_after = renew_grace_after_s == "" ? -1 : Integer.parseInt(renew_grace_after_s);
        if (renew_grace_before > 0) {
            renew_grace_before_BI = renew_grace_before_BI.multiply(BigInteger.valueOf(86400000L));
        }
        if (renew_grace_after > 0) {
            renew_grace_after_BI = renew_grace_after_BI.multiply(BigInteger.valueOf(86400000L));
        }
        Date current = new Date();
        long millisDiff = origExpDate.getTime() - current.getTime();
        logger.debug(method + " millisDiff=" + millisDiff + " origExpDate=" + origExpDate.getTime() + " current=" + current.getTime());
        if (millisDiff >= 0L) {
            if (renew_grace_before > 0 && millisDiff > renew_grace_before_BI.longValue()) {
                msg = renew_grace_before + " days before and " + renew_grace_after + " days after original cert expiration date";
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_RENEW_OUTSIDE_GRACE_PERIOD", (String[])new String[]{msg}));
            }
        } else if (renew_grace_after > 0 && 0L - millisDiff > renew_grace_after_BI.longValue()) {
            msg = renew_grace_before + " days before and " + renew_grace_after + " days after original cert expiration date";
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_PROFILE_RENEW_OUTSIDE_GRACE_PERIOD", (String[])new String[]{msg}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String renew_grace_before_s = this.getConfig(CONFIG_RENEW_GRACE_BEFORE);
        String renew_grace_after_s = this.getConfig(CONFIG_RENEW_GRACE_AFTER);
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_VALIDITY_TEXT", (String[])new String[]{renew_grace_before_s + " days before and " + renew_grace_after_s + " days after original cert expiration date"});
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        return def instanceof NoDefault;
    }
}

