/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.NSCertTypeExtDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserExtensionDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;

public class NSCertTypeExtConstraint
extends EnrollConstraint {
    public static final String CONFIG_CRITICAL = "nsCertCritical";
    public static final String CONFIG_SSL_CLIENT = "nsCertSSLClient";
    public static final String CONFIG_SSL_SERVER = "nsCertSSLServer";
    public static final String CONFIG_EMAIL = "nsCertEmail";
    public static final String CONFIG_OBJECT_SIGNING = "nsCertObjectSigning";
    public static final String CONFIG_SSL_CA = "nsCertSSLCA";
    public static final String CONFIG_EMAIL_CA = "nsCertEmailCA";
    public static final String CONFIG_OBJECT_SIGNING_CA = "nsCertObjectSigningCA";

    public NSCertTypeExtConstraint() {
        this.addConfigName(CONFIG_CRITICAL);
        this.addConfigName(CONFIG_SSL_CLIENT);
        this.addConfigName(CONFIG_SSL_SERVER);
        this.addConfigName(CONFIG_EMAIL);
        this.addConfigName(CONFIG_OBJECT_SIGNING);
        this.addConfigName(CONFIG_SSL_CA);
        this.addConfigName(CONFIG_EMAIL_CA);
        this.addConfigName(CONFIG_OBJECT_SIGNING_CA);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_CRITICAL)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_SSL_CLIENT)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_CLIENT", (String[])new String[0]));
        }
        if (name.equals(CONFIG_SSL_SERVER)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_SERVER", (String[])new String[0]));
        }
        if (name.equals(CONFIG_EMAIL)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMAIL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_OBJECT_SIGNING)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OBJECT_SIGNING", (String[])new String[0]));
        }
        if (name.equals(CONFIG_SSL_CA)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SSL_CA", (String[])new String[0]));
        }
        if (name.equals(CONFIG_EMAIL_CA)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_EMAIL_CA", (String[])new String[0]));
        }
        if (name.equals(CONFIG_OBJECT_SIGNING_CA)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OBJECT_SIGNING_CA", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        boolean bit;
        boolean critical;
        NSCertTypeExtension ext = (NSCertTypeExtension)this.getExtension(NSCertTypeExtension.CertType_Id.toString(), info);
        if (ext == null) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EXTENSION_NOT_FOUND", (String[])new String[]{NSCertTypeExtension.CertType_Id.toString()}));
        }
        String value = this.getConfig(CONFIG_CRITICAL);
        if (!this.isOptional(value) && (critical = this.getBoolean(value)) != ext.isCritical()) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CRITICAL_NOT_MATCHED", (String[])new String[0]));
        }
        value = this.getConfig(CONFIG_SSL_CLIENT);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(0)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SSL_CLIENT_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_SSL_SERVER);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(1)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SSL_SERVER_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_EMAIL);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(2)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EMAIL_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_OBJECT_SIGNING);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(3)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_OBJECT_SIGNING_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_SSL_CA);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(4)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SSL_CA_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_EMAIL_CA);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(5)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EMAIL_CA_NOT_MATCHED", (String[])new String[]{value}));
        }
        value = this.getConfig(CONFIG_OBJECT_SIGNING_CA);
        if (!this.isOptional(value) && (bit = this.getBoolean(value)) != ext.isSet(6)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_OBJECT_SIGNING_CA_NOT_MATCHED", (String[])new String[]{value}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_CRITICAL), this.getConfig(CONFIG_SSL_CLIENT), this.getConfig(CONFIG_SSL_SERVER), this.getConfig(CONFIG_EMAIL), this.getConfig(CONFIG_OBJECT_SIGNING), this.getConfig(CONFIG_SSL_CA), this.getConfig(CONFIG_EMAIL_CA), this.getConfig(CONFIG_OBJECT_SIGNING_CA)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_NS_CERT_EXT_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof NSCertTypeExtDefault) {
            return true;
        }
        return def instanceof UserExtensionDefault;
    }
}

