/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserExtensionDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.request.Request;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(ExtensionConstraint.class);
    public static final String CONFIG_CRITICAL = "extCritical";
    public static final String CONFIG_OID = "extOID";

    public ExtensionConstraint() {
        this.addConfigName(CONFIG_CRITICAL);
        this.addConfigName(CONFIG_OID);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") == null) {
            logger.debug("ExtensionConstraint: mConfig.getSubStore is null");
        } else {
            logger.debug("ExtensionConstraint: setConfig name=" + name + " value=" + value);
            if (name.equals(CONFIG_OID)) {
                try {
                    CertUtils.checkOID((String)"", (String)value);
                }
                catch (Exception e) {
                    logger.error("ExtensionConstraint: Invalid OID: " + e.getMessage(), (Throwable)e);
                    throw new EPropertyException("Invalid OID: " + e.getMessage(), (Throwable)e);
                }
            }
            this.mConfig.getSubStore("params").putString(name, value);
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_CRITICAL)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_OID)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OID", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        boolean critical;
        Extension ext = this.getExtension(this.getConfig(CONFIG_OID), info);
        if (ext == null) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EXTENSION_NOT_FOUND", (String[])new String[]{this.getConfig(CONFIG_OID)}));
        }
        String value = this.getConfig(CONFIG_CRITICAL);
        if (!this.isOptional(value) && (critical = this.getBoolean(value)) != ext.isCritical()) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CRITICAL_NOT_MATCHED", (String[])new String[0]));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_CRITICAL), this.getConfig(CONFIG_OID)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_EXTENSION_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof UserExtensionDefault) {
            return true;
        }
        return def instanceof EnrollExtDefault;
    }
}

