/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnrollConstraint
extends PolicyConstraint {
    public static Logger logger = LoggerFactory.getLogger(EnrollConstraint.class);
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_PARAMS = "params";
    protected ConfigStore mConfig;
    protected Vector<String> mConfigNames = new Vector();

    public Enumeration<String> getConfigNames() {
        return this.mConfigNames.elements();
    }

    public void addConfigName(String name) {
        this.mConfigNames.addElement(name);
    }

    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        return null;
    }

    public IDescriptor getValueDescriptor(Locale locale, String name) {
        return null;
    }

    public Locale getLocale(Request request) {
        Locale locale = null;
        String language = request.getExtDataInString("req_locale");
        if (language != null) {
            locale = new Locale(language);
        }
        return locale;
    }

    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore(CONFIG_PARAMS) != null) {
            this.mConfig.getSubStore(CONFIG_PARAMS).putString(name, value);
        }
    }

    public String getConfig(String name) {
        return this.getConfig(name, "");
    }

    public String getConfig(String name, String defval) {
        if (this.mConfig == null) {
            logger.warn("Missing profile constraint configuration");
            return null;
        }
        ConfigStore params = this.mConfig.getSubStore(CONFIG_PARAMS, ConfigStore.class);
        if (params == null) {
            logger.warn("Error: Missing constraint parameters");
            return null;
        }
        try {
            return params.getString(name, defval);
        }
        catch (EBaseException e) {
            logger.warn("Unable to get profile constraint " + name + " parameter: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void init(ConfigStore config) throws EProfileException {
        this.mConfig = config;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public abstract void validate(Request var1, X509CertInfo var2) throws ERejectException;

    @Override
    public void validate(Request request) throws ERejectException {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        logger.debug(name + ": validate start");
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        this.validate(request, info);
        request.setExtData("req_x509info", info);
        logger.debug(name + ": validate end");
    }

    @Override
    public String getText(Locale locale) {
        return "Enroll Constraint";
    }

    @Override
    public String getName(Locale locale) {
        try {
            return this.mConfig.getString(CONFIG_NAME);
        }
        catch (EBaseException e) {
            return null;
        }
    }

    protected Extension getExtension(String name, X509CertInfo info) {
        CertificateExtensions exts = null;
        try {
            exts = (CertificateExtensions)info.get("extensions");
        }
        catch (Exception e) {
            logger.warn("EnrollConstraint: getExtension " + e.getMessage(), (Throwable)e);
        }
        if (exts == null) {
            return null;
        }
        Enumeration e = exts.getAttributes();
        while (e.hasMoreElements()) {
            Extension ext = (Extension)e.nextElement();
            if (!ext.getExtensionId().toString().equals(name)) continue;
            return ext;
        }
        return null;
    }

    protected boolean isOptional(String value) {
        return value.equals("") || value.equals("-");
    }

    protected boolean getBoolean(String value) {
        return Boolean.valueOf(value);
    }

    protected int getInt(String value) {
        return Integer.valueOf(value);
    }

    protected boolean getConfigBoolean(String value) {
        return this.getBoolean(this.getConfig(value));
    }

    protected int getConfigInt(String value) {
        return this.getInt(this.getConfig(value));
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        return true;
    }
}

