/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.AuthzRealmDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzRealmConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(AuthzRealmConstraint.class);
    public static final String CONFIG_REALMS_ALLOWED = "realmsAllowed";

    public AuthzRealmConstraint() {
        this.addConfigName(CONFIG_REALMS_ALLOWED);
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") == null) {
            logger.warn("AuthzRealmConstraint: mConfig.getSubStore is null");
            return;
        }
        logger.debug("AuthzRealmConstraint: setConfig name=" + name + " value=" + value);
        this.mConfig.getSubStore("params").putString(name, value);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_REALMS_ALLOWED)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_AUTHZ_REALMS_ALLOWED", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_REALM_TEXT", (String[])new String[]{this.getConfig(CONFIG_REALMS_ALLOWED)});
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        return def instanceof AuthzRealmDefault;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        String realm = request.getRealm();
        List<String> allowedRealms = Arrays.asList(this.getConfig(CONFIG_REALMS_ALLOWED).split("\\s*,\\s*"));
        if (!allowedRealms.contains(realm)) {
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_AUTHZ_REALM_NOT_MATCHED", (String[])new String[]{realm}));
        }
    }
}

