/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.common;

import com.netscape.ca.CAService;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ca.AuthorityID;
import com.netscape.certsrv.connector.Connector;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalRequestEvent;
import com.netscape.certsrv.logging.event.ServerSideKeygenEnrollKeyRetrievalEvent;
import com.netscape.certsrv.logging.event.ServerSideKeygenEnrollKeygenEvent;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cms.profile.common.EnrollProfile;
import com.netscape.cms.profile.updater.ProfileUpdater;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.cert.CertUtils;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAEnrollProfile
extends EnrollProfile {
    public static Logger logger = LoggerFactory.getLogger(CAEnrollProfile.class);

    public void populate() throws EBaseException {
    }

    @Override
    public void execute(Request request) throws EProfileException, ERejectException {
        X509CertImpl theCert;
        PKIArchiveOptions options;
        String method = "CAEnrollProfile: execute: ";
        long startTime = new Date().getTime();
        if (!this.isEnable()) {
            logger.error("CAEnrollProfile: Profile Not Enabled");
            throw new EProfileException("Profile Not Enabled");
        }
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID(request);
        RequestId requestId = request.getRequestId();
        logger.info("CAEnrollProfile: Processing enrollment request " + requestId.toHexString());
        CAService caService = engine.getCAService();
        if (caService == null) {
            throw new EProfileException("No CA Service");
        }
        boolean isSSKeygen = false;
        String isSSKeygenStr = request.getExtDataInString("isServerSideKeygen");
        if (isSSKeygenStr != null && isSSKeygenStr.equalsIgnoreCase("true")) {
            logger.debug(method + "isServerSideKeygen = true");
            isSSKeygen = true;
        } else {
            logger.debug(method + "isServerSideKeygen = false");
        }
        CertificateSubjectName reqSubj = request.getExtDataInCertSubjectName("req_subject_name");
        String clientId = "unknown serverKeyGenUser";
        if (reqSubj != null) {
            X500Name xN = reqSubj.getX500Name();
            clientId = xN.toString();
            logger.debug(method + "clientId = " + clientId);
        }
        byte[] optionsData = request.getExtDataInByteArray("req_archive_options");
        byte[] transWrappedSessionKey = null;
        byte[] sessionWrappedPassphrase = null;
        if (isSSKeygen) {
            logger.info("CAEnrollProfile: Processing server-side keygen enrollment");
            request.setExtData("serverSideKeygenStage", "serverSideKeygenStage_keygen");
            transWrappedSessionKey = request.getExtDataInByteArray("serverSideKeygenP12PasswdTransSession");
            sessionWrappedPassphrase = request.getExtDataInByteArray("serverSideKeygenP12PasswdEnc");
            request.setExtData("serverSideKeygenP12PasswdTransSession", "");
            request.deleteExtData("serverSideKeygenP12PasswdTransSession");
            request.setExtData("serverSideKeygenP12PasswdEnc", "");
            request.deleteExtData("serverSideKeygenP12PasswdEnc");
            try {
                Connector kraConnector = caService.getKRAConnector();
                if (kraConnector == null) {
                    String message = "KRA connector not configured";
                    logger.debug(method + message);
                    throw new EProfileException(message);
                }
                logger.info(method + "Sending key archival request");
                kraConnector.send(request);
                if (!request.isSuccess()) {
                    String message = "serverSide Keygen request failed";
                    logger.debug(method + message);
                    if (this.getLocale(request) == null || request.getError(this.getLocale(request)) == null) {
                        throw new ERejectException(CMS.getUserMessage((String)"CMS_CA_SEND_KRA_REQUEST", (String[])new String[0]) + " check KRA log for detail");
                    }
                    if (request.getError(this.getLocale(request)).equals(CMS.getUserMessage((String)"CMS_KRA_INVALID_TRANSPORT_CERT", (String[])new String[0]))) {
                        logger.debug(method + "set request status: REJECTED");
                        request.setRequestStatus(RequestStatus.REJECTED);
                        engine.getRequestRepository().updateRequest(request);
                    }
                    throw new ERejectException(request.getError(this.getLocale(request)));
                }
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenEvent(auditSubjectID, "Success", requestId, clientId));
            }
            catch (Exception e) {
                logger.debug(method + e);
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeygenEvent(auditSubjectID, "Failure", requestId, clientId));
                if (e instanceof ERejectException) {
                    throw (ERejectException)e;
                }
                throw new EProfileException((Throwable)e);
            }
        }
        if (optionsData != null && !request.getRequestType().equals("renewal") && (options = this.toPKIArchiveOptions(optionsData)) != null) {
            logger.info("CAEnrollProfile: Processing PKIArchiveOptions");
            try {
                Connector kraConnector = caService.getKRAConnector();
                if (kraConnector == null) {
                    String message = "KRA connector not configured";
                    logger.error("CAEnrollProfile: " + message);
                    auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (String)message));
                    throw new EProfileException(message);
                }
                logger.info("CAEnrollProfile: Sending key archival request");
                kraConnector.send(request);
                if (!request.isSuccess()) {
                    String message = "archival request failed";
                    logger.error("CAEnrollProfile: " + message);
                    auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (String)message));
                    if (this.getLocale(request) == null || request.getError(this.getLocale(request)) == null) {
                        throw new ERejectException(CMS.getUserMessage((String)"CMS_CA_SEND_KRA_REQUEST", (String[])new String[0]) + " check KRA log for detail");
                    }
                    if (request.getError(this.getLocale(request)).equals(CMS.getUserMessage((String)"CMS_KRA_INVALID_TRANSPORT_CERT", (String[])new String[0]))) {
                        logger.error("CAEnrollProfile: execute set request status: REJECTED");
                        request.setRequestStatus(RequestStatus.REJECTED);
                        engine.getRequestRepository().updateRequest(request);
                    }
                    throw new ERejectException(request.getError(this.getLocale(request)));
                }
                auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null));
            }
            catch (Exception e) {
                logger.error("CAEnrollProfile: " + e.getMessage(), (Throwable)e);
                auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)requestId, null, (Exception)e));
                if (e instanceof ERejectException) {
                    throw (ERejectException)e;
                }
                throw new EProfileException((Throwable)e);
            }
        }
        X509CertInfo info = request.getExtDataInCertInfo("req_x509info");
        if (isSSKeygen) {
            try {
                String pubKeyStr = request.getExtDataInString("public_key");
                if (pubKeyStr == null) {
                    throw new EProfileException("Server-Side Keygen enrollment failed to retrieve public_key from KRA");
                }
                byte[] pubKeyB = CryptoUtil.base64Decode((String)pubKeyStr);
                CertificateX509Key certKey = new CertificateX509Key((InputStream)new ByteArrayInputStream(pubKeyB));
                Object oj = info.get("key");
                if (oj != null) {
                    info.delete("key");
                }
                info.set("key", (Object)certKey);
            }
            catch (IOException e) {
                logger.error(method + e.getMessage(), (Throwable)e);
                throw new EProfileException((Throwable)e);
            }
            catch (CertificateException e) {
                logger.error(method + e.getMessage(), (Throwable)e);
                throw new EProfileException((Throwable)e);
            }
        }
        SessionContext sc = SessionContext.getExistingContext();
        sc.put((Object)"profileId", (Object)this.getId());
        String setId = request.getExtDataInString("profileSetId");
        if (setId != null) {
            sc.put((Object)"profileSetId", (Object)setId);
        }
        AuthorityID aid = null;
        String aidString = request.getExtDataInString("req_authority_id");
        if (aidString != null) {
            aid = new AuthorityID(aidString);
        }
        try {
            theCert = caService.issueX509Cert(aid, info, this.getId(), requestId.toString());
        }
        catch (EBaseException e) {
            logger.error("CAEnrollProfile: " + e.getMessage(), (Throwable)e);
            throw new EProfileException((Throwable)e);
        }
        request.setExtData("req_issued_cert", theCert);
        if (isSSKeygen) {
            logger.debug(method + "onto SSK_STAGE_KEY_RETRIEVE");
            request.setExtData("serverSideKeygenStage", "serverSideKeygenStage_key_retrieve");
            request.setExtData("requestStatus", "begin");
            request.setExtData("requestType", "recovery");
            request.setExtData("serverSideKeygenP12PasswdEnc", sessionWrappedPassphrase);
            request.setExtData("serverSideKeygenP12PasswdTransSession", transWrappedSessionKey);
            try {
                Connector kraConnector = caService.getKRAConnector();
                if (kraConnector == null) {
                    String message = "KRA connector not configured";
                    logger.debug(method + message);
                } else {
                    logger.info(method + "Sending key archival request");
                    kraConnector.send(request);
                    if (!request.isSuccess()) {
                        String message = "serverSide Keygen request failed";
                        logger.debug(method + message);
                        if (this.getLocale(request) == null || request.getError(this.getLocale(request)) == null) {
                            throw new ERejectException(CMS.getUserMessage((String)"CMS_CA_SEND_KRA_REQUEST", (String[])new String[0]) + " check KRA log for detail");
                        }
                        if (request.getError(this.getLocale(request)).equals(CMS.getUserMessage((String)"CMS_KRA_INVALID_TRANSPORT_CERT", (String[])new String[0]))) {
                            logger.debug(method + "set request status: REJECTED");
                            request.setRequestStatus(RequestStatus.REJECTED);
                            engine.getRequestRepository().updateRequest(request);
                        }
                        throw new ERejectException(request.getError(this.getLocale(request)));
                    }
                    auditor.log((LogEvent)new ServerSideKeygenEnrollKeyRetrievalEvent(auditSubjectID, "Success", requestId, clientId));
                }
            }
            catch (Exception e) {
                logger.debug(method + e);
                auditor.log((LogEvent)new ServerSideKeygenEnrollKeyRetrievalEvent(auditSubjectID, "Failure", requestId, clientId));
                if (e instanceof ERejectException) {
                    throw (ERejectException)e;
                }
                throw new EProfileException((Throwable)e);
            }
            finally {
                request.setExtData("serverSideKeygenP12PasswdTransSession", "");
                request.deleteExtData("serverSideKeygenP12PasswdTransSession");
                request.setExtData("serverSideKeygenP12PasswdEnc", "");
                request.deleteExtData("serverSideKeygenP12PasswdEnc");
            }
            logger.debug(method + "isSSKeygen: response received from KRA");
        }
        long endTime = new Date().getTime();
        String initiative = "fromAgent userID: " + (String)sc.get((Object)"userid");
        String authMgr = (String)sc.get((Object)"authManagerId");
        logger.info("{} reqID {} {} authenticated by {} is {} DN requested: {} {}", new Object[]{request.getRequestType(), request.getRequestId().toHexString(), initiative, authMgr, "completed", theCert.getSubjectName(), "cert issued serial number: 0x" + theCert.getSerialNumber().toString(16) + " time: " + (endTime - startTime)});
        request.setRequestStatus(RequestStatus.COMPLETE);
        Enumeration<String> updaterIds = this.getProfileUpdaterIds();
        while (updaterIds.hasMoreElements()) {
            String updaterId = updaterIds.nextElement();
            ProfileUpdater updater = this.getProfileUpdater(updaterId);
            updater.update(request, RequestStatus.COMPLETE);
        }
        if (CertUtils.isEncryptionCert((X509CertImpl)theCert)) {
            request.setExtData("isEncryptionCert", "true");
        } else {
            request.setExtData("isEncryptionCert", "false");
        }
    }
}

