/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.crl;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import java.io.IOException;
import org.dogtagpki.server.ca.CMSCRLExtension;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.URIName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSCertificateIssuerExtension
extends CMSCRLExtension
implements IExtendedPluginInfo {
    public static final Logger logger = LoggerFactory.getLogger(CMSCertificateIssuerExtension.class);

    @Override
    public Extension setCRLExtensionCriticality(Extension ext, boolean critical) {
        CertificateIssuerExtension certIssuerExt = null;
        GeneralNames names = null;
        try {
            names = (GeneralNames)((CertificateIssuerExtension)ext).get("value");
            certIssuerExt = new CertificateIssuerExtension(Boolean.valueOf(critical), names);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_CERT_ISSUER_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        return certIssuerExt;
    }

    @Override
    public Extension getCRLExtension(ConfigStore config, Object ip, boolean critical) {
        CertificateIssuerExtension certIssuerExt = null;
        int numNames = 0;
        try {
            numNames = config.getInteger("numNames", 0);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_NUM_NAMES", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (numNames > 0) {
            GeneralNames names = new GeneralNames();
            for (int i = 0; i < numNames; ++i) {
                String nameType = null;
                try {
                    nameType = config.getString("nameType" + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_UNDEFINED_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                if (nameType == null) continue;
                String name = null;
                try {
                    name = config.getString("name" + i);
                }
                catch (EPropertyNotFound e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_UNDEFINED_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
                }
                if (name == null || name.length() <= 0) continue;
                if (nameType.equalsIgnoreCase("DirectoryName")) {
                    try {
                        X500Name dirName = new X500Name(name);
                        names.addElement((Object)dirName);
                    }
                    catch (IOException e) {
                        logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_500NAME", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    }
                    continue;
                }
                if (nameType.equalsIgnoreCase("URI")) {
                    URIName uriName = new URIName(name);
                    names.addElement((Object)uriName);
                    continue;
                }
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_NAME_TYPE", (Object[])new Object[]{nameType}));
            }
            if (names.size() > 0) {
                try {
                    certIssuerExt = new CertificateIssuerExtension(Boolean.valueOf(critical), names);
                }
                catch (IOException e) {
                    logger.warn(CMS.getLogMessage((String)"CRL_CREATE_CERT_ISSUER_EXT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
            }
        }
        return certIssuerExt;
    }

    @Override
    public String getCRLExtOID() {
        return PKIXExtensions.CertificateIssuer_Id.toString();
    }

    @Override
    public void getConfigParams(ConfigStore config, NameValuePairs nvp) {
        int i;
        int numNames = 0;
        try {
            numNames = config.getInteger("numNames", 0);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_NUM_NAMES", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        nvp.put((Object)"numNames", (Object)String.valueOf(numNames));
        for (i = 0; i < numNames; ++i) {
            String nameType = null;
            try {
                nameType = config.getString("nameType" + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_UNDEFINED_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
            }
            if (nameType != null && nameType.length() > 0) {
                nvp.put((Object)("nameType" + i), (Object)nameType);
            } else {
                nvp.put((Object)("nameType" + i), (Object)"");
            }
            String name = null;
            try {
                name = config.getString("name" + i);
            }
            catch (EPropertyNotFound e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_UNDEFINED_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CRL_CREATE_INVALID_TYPE", (Object[])new Object[]{Integer.toString(i), e.toString()}), (Throwable)e);
            }
            if (name != null && name.length() > 0) {
                nvp.put((Object)("name" + i), (Object)name);
                continue;
            }
            nvp.put((Object)("name" + i), (Object)"");
        }
        if (numNames < 3) {
            for (i = numNames; i < 3; ++i) {
                nvp.put((Object)("nameType" + i), (Object)"");
                nvp.put((Object)("name" + i), (Object)"");
            }
        }
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"enable;boolean;Check to enable Certificate Issuer CRL entry extension.", "critical;boolean;Set criticality for Certificate Issuer CRL entry extension.", "numNames;number;Set number of certificate issuer names for the CRL entry.", "nameType0;choice(DirectoryName,URI);Select Certificate Issuer name type.", "name0;string;Enter Certificate Issuer name corresponding to the selected name type.", "nameType1;choice(DirectoryName,URI);Select Certificate Issuer name type.", "name1;string;Enter Certificate Issuer name corresponding to the selected name type.", "nameType2;choice(DirectoryName,URI);Select Certificate Issuer name type.", "name2;string;Enter Certificate Issuer name corresponding to the selected name type.", "HELP_TOKEN;configuration-ca-edit-crlextension-certificateissuer", "HELP_TEXT;This CRL entry extension identifies the certificate issuer associated with an entry in an indirect CRL."};
        return params;
    }
}

