/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceRevoke
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceRevoke.class);
    private CAService mService;

    public ServiceRevoke(CAService service) {
        this.mService = service;
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        boolean sendStatus = true;
        RevokedCertImpl[] crlentries = request.getExtDataInRevokedCertArray("CERT_INFO");
        if (crlentries == null || crlentries.length == 0 || crlentries[0] == null) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CRL_NOT_FOUND", (Object[])new Object[]{request.getRequestId().toString()}));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_MISSING_INFO_IN_REVREQ", (String[])new String[0]));
        }
        RevokedCertImpl[] revokedCerts = new RevokedCertImpl[crlentries.length];
        String[] svcerrors = null;
        for (int i = 0; i < crlentries.length; ++i) {
            try {
                this.mService.revokeCert(crlentries[i], request.getRequestId().toString());
                revokedCerts[i] = crlentries[i];
                continue;
            }
            catch (ECAException e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_CANNOT_REVOKE", (Object[])new Object[]{Integer.toString(i), request.getRequestId().toString(), e.toString()}), (Throwable)e);
                revokedCerts[i] = null;
                if (svcerrors == null) {
                    svcerrors = new String[revokedCerts.length];
                }
                svcerrors[i] = e.toString();
            }
        }
        if (CAService.mCLAConnector != null) {
            logger.debug(CMS.getLogMessage((String)"CMSCORE_CA_CLONE_READ_REVOKED", (Object[])new Object[0]));
            BigInteger[] revokedCertIds = new BigInteger[revokedCerts.length];
            for (int i = 0; i < revokedCerts.length; ++i) {
                revokedCertIds[i] = revokedCerts[i].getSerialNumber();
            }
            request.deleteExtData("CERT_INFO");
            request.deleteExtData("OLD_CERTS");
            request.setExtData("revokedCertRecs", revokedCertIds);
            logger.debug(CMS.getLogMessage((String)"CMSCORE_CA_CLONE_READ_REVOKED_CONNECTOR", (Object[])new Object[0]));
            request.setRequestType("cert4crl");
            sendStatus = CAService.mCLAConnector.send(request);
            if (!sendStatus || request.getExtDataInString("Error") == null) {
                request.setExtData("Result", Request.RES_ERROR);
                request.setExtData("Error", (Throwable)new ECAException(CMS.getUserMessage((String)"CMS_CA_SEND_CLA_REQUEST", (String[])new String[0])));
                return sendStatus;
            }
            request.setExtData("Result", Request.RES_SUCCESS);
            request.deleteExtData("Error");
            if (request.getExtDataInString("Error") != null) {
                return sendStatus;
            }
        }
        if (svcerrors != null) {
            request.setExtData("serviceErrors", svcerrors);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_REVOKE_FAILED", (String[])new String[0]));
        }
        logger.debug("serviceRevoke sendStatus=" + sendStatus);
        return sendStatus;
    }
}

