/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.certsrv.ldap.LdapConnFactory;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.LdapConnModule;
import com.netscape.cmscore.request.RequestNotifier;
import org.dogtagpki.server.ca.CAEngine;

public class CANotify
extends RequestNotifier {
    public boolean checkAvailablePublishingConnections() {
        CAEngine engine = CAEngine.getInstance();
        CAPublisherProcessor pp = engine.getPublisherProcessor();
        if (pp == null) {
            logger.warn("CANotify: Publisher processor is not accessible");
            return false;
        }
        if (!pp.isCertPublishingEnabled() && !pp.isCRLPublishingEnabled()) {
            logger.warn("CANotify: Publisher processor is not enabled");
            return false;
        }
        LdapConnModule ldapConnModule = pp.getLdapConnModule();
        if (ldapConnModule == null) {
            logger.warn("CANotify: LDAP connection module is not accessible");
            return false;
        }
        LdapConnFactory ldapConnFactory = ldapConnModule.getLdapConnFactory();
        if (ldapConnFactory == null) {
            logger.warn("CANotify: LDAP connection factory is not accessible");
            return false;
        }
        int maxConnection = ldapConnFactory.maxConn();
        logger.debug("CANotify: max connection: " + maxConnection);
        int totalConnection = ldapConnFactory.totalConn();
        logger.debug("CANotify: total connection: " + totalConnection);
        return maxConnection > totalConnection;
    }
}

