/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.dbs.ModificationSet;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.ocsp.CRLIPContainer;
import com.netscape.cms.ocsp.DefStoreCRLUpdater;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.DBSSession;
import com.netscape.cmscore.dbs.DBSearchResults;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.RepositoryRecord;
import com.netscape.cmsutil.ocsp.CertID;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.codec.binary.Hex;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefStore
implements IDefStore,
IExtendedPluginInfo {
    public static final Logger logger = LoggerFactory.getLogger(DefStore.class);
    private static final String PROP_USE_CACHE = "useCache";
    private static final String PROP_REFRESH_IN_SEC = "refreshInSec";
    private static final int DEF_REFRESH_IN_SEC = 0;
    public static final BigInteger BIG_ZERO = BigInteger.ZERO;
    public static final Long MINUS_ONE = -1L;
    private static final String PROP_BY_NAME = "byName";
    private static final String PROP_WAIT_ON_CRL_UPDATE = "waitOnCRLUpdate";
    private static final String PROP_NOT_FOUND_GOOD = "notFoundAsGood";
    private static final String PROP_INCLUDE_NEXT_UPDATE = "includeNextUpdate";
    protected Hashtable<String, Long> mReqCounts = new Hashtable();
    protected boolean mNotFoundGood = true;
    protected boolean mUseCache = true;
    protected boolean mByName = true;
    protected boolean mIncludeNextUpdate = false;
    protected Hashtable<String, CRLIPContainer> mCacheCRLIssuingPoints = new Hashtable();
    private ConfigStore mConfig;
    private String mId = null;
    private DBSubsystem dbSubsystem;
    private int mStateCount = 0;

    @Override
    public boolean isByName() {
        return this.mByName;
    }

    public String[] getExtendedPluginInfo() {
        return this.getExtendedPluginInfo(Locale.getDefault());
    }

    public String[] getExtendedPluginInfo(Locale locale) {
        Vector<Object> v = new Vector<Object>();
        v.addElement("notFoundAsGood;boolean; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_DEFSTORE_PROP_NOT_FOUND_GOOD", (String[])new String[0]));
        v.addElement("byName;boolean; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_DEFSTORE_PROP_BY_NAME", (String[])new String[0]));
        v.addElement("includeNextUpdate;boolean; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_DEFSTORE_PROP_INCLUDE_NEXT_UPDATE", (String[])new String[0]));
        v.addElement("HELP_TEXT; " + CMS.getUserMessage((Locale)locale, (String)"CMS_OCSP_DEFSTORE_DESC", (String[])new String[0]));
        v.addElement("HELP_TOKEN;configuration-ocspstores-defstore");
        return Utils.getStringArrayFromVector(v);
    }

    @Override
    public void init(ConfigStore config, DBSubsystem dbSubsystem) throws EBaseException {
        this.mConfig = config;
        this.dbSubsystem = dbSubsystem;
        this.mNotFoundGood = this.mConfig.getBoolean(PROP_NOT_FOUND_GOOD, true);
        this.mUseCache = this.mConfig.getBoolean(PROP_USE_CACHE, true);
        this.mByName = this.mConfig.getBoolean(PROP_BY_NAME, true);
        this.mIncludeNextUpdate = this.mConfig.getBoolean(PROP_INCLUDE_NEXT_UPDATE, false);
        this.initWebGateway();
    }

    private void initWebGateway() throws EBaseException {
    }

    @Override
    public RepositoryRecord createRepositoryRecord() {
        return new RepositoryRecord();
    }

    @Override
    public boolean waitOnCRLUpdate() {
        boolean defaultVal = true;
        try {
            return this.mConfig.getBoolean(PROP_WAIT_ON_CRL_UPDATE, defaultVal);
        }
        catch (EBaseException e) {
            return defaultVal;
        }
    }

    public boolean includeNextUpdate() {
        return this.mIncludeNextUpdate;
    }

    @Override
    public boolean isNotFoundGood() {
        return this.mNotFoundGood;
    }

    @Override
    public long getReqCount(String id) {
        Long c = this.mReqCounts.get(id);
        return c == null ? 0L : c;
    }

    public void incReqCount(String id) {
        this.mReqCounts.put(id, this.getReqCount(id) + 1L);
    }

    public void deleteOldCRLs() throws EBaseException {
        Enumeration<CRLIssuingPointRecord> recs = this.searchCRLIssuingPointRecord("objectclass=" + CRLIssuingPointRecord.class.getName(), 100);
        while (recs.hasMoreElements()) {
            CRLIssuingPointRecord rec = recs.nextElement();
            this.deleteOldCRLsInCA(rec.getId());
        }
    }

    public void deleteOldCRLsInCA(String caName) throws EBaseException {
        this.deleteCRLsInCA(caName, true);
    }

    public void deleteAllCRLsInCA(String caName) throws EBaseException {
        this.deleteCRLsInCA(caName, false);
    }

    public void deleteCRLsInCA(String caName, boolean oldCRLs) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            CRLIssuingPointRecord cp = this.readCRLIssuingPoint(caName);
            if (cp == null) {
                return;
            }
            if (cp.getThisUpdate() == null) {
                return;
            }
            String thisUpdate = Long.toString(cp.getThisUpdate().getTime());
            Object filter = oldCRLs ? "(!serialNo=" + thisUpdate + ")" : "ou=*";
            Enumeration<RepositoryRecord> e = this.searchRepository(caName, (String)filter);
            while (e != null && e.hasMoreElements()) {
                RepositoryRecord r = e.nextElement();
                Enumeration<CertRecord> recs = this.searchCertRecord(caName, r.getSerialNumber().toString(), "certRecordId=*");
                logger.info("remove CRL 0x" + r.getSerialNumber().toString(16) + " of " + caName);
                String rep_dn = "ou=" + r.getSerialNumber().toString() + ",cn=" + this.transformDN(caName) + "," + this.getBaseDN();
                while (recs != null && recs.hasMoreElements()) {
                    CertRecord rec = recs.nextElement();
                    String cert_dn = "cn=" + rec.getSerialNumber().toString() + "," + rep_dn;
                    s.delete(cert_dn);
                }
                s.delete(rep_dn);
            }
        }
    }

    @Override
    public void startup() throws EBaseException {
        int refresh = this.mConfig.getInteger(PROP_REFRESH_IN_SEC, 0);
        if (refresh > 0) {
            DefStoreCRLUpdater updater = new DefStoreCRLUpdater(this.mCacheCRLIssuingPoints, refresh);
            updater.start();
        }
    }

    @Override
    public void shutdown() {
    }

    public ConfigStore getConfigStore() {
        return this.mConfig;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public SingleResponse processRequest(Request req) throws Exception {
        Object certStatus;
        GeneralizedTime nextUpdate;
        GeneralizedTime thisUpdate;
        CertID cid = req.getCertID();
        INTEGER serialNo = cid.getSerialNumber();
        logger.info("DefStore: Processing request for cert 0x" + serialNo.toString(16));
        X509CertImpl theCert = null;
        X509CRLImpl theCRL = null;
        CRLIssuingPointRecord theRec = null;
        byte[] keyhsh = cid.getIssuerKeyHash().toByteArray();
        logger.info("DefStore: Issuer key hash: " + new String(Hex.encodeHex((byte[])keyhsh)));
        CRLIPContainer matched = this.mCacheCRLIssuingPoints.get(new String(keyhsh));
        logger.info("DefStore: CRL issuing point container: " + matched);
        if (matched == null) {
            logger.info("DefStore: Searching for objectclass=" + CRLIssuingPointRecord.class.getName());
            Enumeration<CRLIssuingPointRecord> recs = this.searchCRLIssuingPointRecord("objectclass=" + CRLIssuingPointRecord.class.getName(), 100);
            while (recs.hasMoreElements()) {
                CRLIssuingPointRecord rec = recs.nextElement();
                logger.info("DefStore: - ID: " + rec.getId());
                byte[] certdata = rec.getCACert();
                X509CertImpl cert = null;
                try {
                    cert = new X509CertImpl(certdata);
                }
                catch (Exception e) {
                    logger.error(CMS.getLogMessage((String)"OCSP_DECODE_CERT", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw e;
                }
                MessageDigest md = MessageDigest.getInstance(cid.getDigestName());
                X509Key key = (X509Key)cert.getPublicKey();
                byte[] digest = md.digest(key.getKey());
                logger.info("DefStore:   Digest: " + new String(Hex.encodeHex((byte[])digest)));
                if (!Arrays.equals(digest, keyhsh)) continue;
                logger.info("DefStore: Found issuer");
                theCert = cert;
                theRec = rec;
                this.incReqCount(theRec.getId());
                byte[] crldata = rec.getCRL();
                logger.info("DefStore: CRL: " + crldata);
                if (crldata == null) {
                    throw new Exception("Missing CRL data");
                }
                if (rec.getCRLCache() == null) {
                    logger.debug("DefStore: start building x509 crl impl");
                    try {
                        theCRL = new X509CRLImpl(crldata);
                    }
                    catch (Exception e) {
                        logger.error(CMS.getLogMessage((String)"OCSP_DECODE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        throw e;
                    }
                    logger.debug("DefStore: done building x509 crl impl");
                } else {
                    logger.debug("DefStore: using crl cache");
                }
                logger.info("DefStore: Adding CRL issuing point container for " + new String(Hex.encodeHex((byte[])digest)));
                this.mCacheCRLIssuingPoints.put(new String(digest), new CRLIPContainer(theRec, theCert, theCRL));
                break;
            }
        } else {
            theCert = matched.getX509CertImpl();
            theRec = matched.getCRLIssuingPointRecord();
            theCRL = matched.getX509CRLImpl();
            this.incReqCount(theRec.getId());
        }
        logger.info("DefStore: Issuer: " + theCert);
        if (theCert == null) {
            throw new Exception("Missing issuer certificate");
        }
        logger.info("DefStore: Issuer: " + theCert.getSubjectX500Principal());
        logger.info("Checked Status of certificate 0x" + serialNo.toString(16));
        if (theRec == null) {
            thisUpdate = new GeneralizedTime(new Date());
        } else {
            Date d = theRec.getThisUpdate();
            logger.debug("DefStore: CRL record this update: " + d);
            thisUpdate = new GeneralizedTime(d);
        }
        logger.debug("DefStore: this update: " + thisUpdate.toDate());
        if (!this.includeNextUpdate()) {
            nextUpdate = null;
        } else if (theRec == null) {
            nextUpdate = new GeneralizedTime(new Date());
        } else {
            Date d = theRec.getNextUpdate();
            logger.debug("DefStore: CRL record next update: " + d);
            nextUpdate = new GeneralizedTime(d);
        }
        logger.debug("DefStore: next update: " + (nextUpdate == null ? null : nextUpdate.toDate()));
        if (theCRL == null) {
            certStatus = new UnknownInfo();
            if (theRec == null) {
                return new SingleResponse(cid, (CertStatus)certStatus, thisUpdate, nextUpdate);
            }
            logger.debug("DefStore: evaluating crl cache");
            Hashtable cache = theRec.getCRLCacheNoClone();
            if (cache != null) {
                RevokedCertificate rc = (RevokedCertificate)cache.get(new BigInteger(serialNo.toString()));
                certStatus = rc == null ? (this.isNotFoundGood() ? new GoodInfo() : new UnknownInfo()) : new RevokedInfo(new GeneralizedTime(rc.getRevocationDate()));
            }
            return new SingleResponse(cid, (CertStatus)certStatus, thisUpdate, nextUpdate);
        }
        logger.debug("DefStore: evaluating x509 crl impl");
        X509CRLEntry crlentry = theCRL.getRevokedCertificate(new BigInteger(serialNo.toString()));
        certStatus = crlentry == null ? (this.isNotFoundGood() ? new GoodInfo() : new UnknownInfo()) : new RevokedInfo(new GeneralizedTime(crlentry.getRevocationDate()));
        return new SingleResponse(cid, (CertStatus)certStatus, thisUpdate, nextUpdate);
    }

    private String transformDN(String dn) {
        String newdn = dn;
        newdn = newdn.replace(',', '_');
        newdn = newdn.replace('=', '-');
        return newdn;
    }

    public String getBaseDN() {
        return this.dbSubsystem.getBaseDN();
    }

    @Override
    public Enumeration<CRLIssuingPointRecord> searchAllCRLIssuingPointRecord(int maxSize) throws EBaseException {
        return this.searchCRLIssuingPointRecord("objectclass=" + CRLIssuingPointRecord.class.getName(), maxSize);
    }

    @Override
    public Enumeration<CRLIssuingPointRecord> searchCRLIssuingPointRecord(String filter, int maxSize) throws EBaseException {
        Vector<CRLIssuingPointRecord> v = new Vector<CRLIssuingPointRecord>();
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search(this.getBaseDN(), filter, maxSize);
            while (sr.hasMoreElements()) {
                v.add((CRLIssuingPointRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    public synchronized void modifyCRLIssuingPointRecord(String name, ModificationSet mods) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "cn=" + this.transformDN(name) + "," + this.getBaseDN();
            s.modify(dn, mods);
        }
        catch (EBaseException e) {
            logger.error("modifyCRLIssuingPointRecord: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public CRLIssuingPointRecord readCRLIssuingPoint(String name) throws EBaseException {
        CRLIssuingPointRecord rec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "cn=" + this.transformDN(name) + "," + this.getBaseDN();
            if (s != null) {
                rec = (CRLIssuingPointRecord)s.read(dn);
            }
        }
        return rec;
    }

    @Override
    public CRLIssuingPointRecord createCRLIssuingPointRecord(String name, BigInteger crlNumber, Long crlSize, Date thisUpdate, Date nextUpdate) {
        return new CRLIssuingPointRecord(name, crlNumber, crlSize, thisUpdate, nextUpdate);
    }

    @Override
    public void deleteCRLIssuingPointRecord(String id) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String name = "cn=" + this.transformDN(id) + "," + this.getBaseDN();
            logger.debug("DefStore::deleteCRLIssuingPointRecord: Attempting to delete: " + name);
            if (s != null) {
                this.deleteAllCRLsInCA(id);
                s.delete(name);
            }
        }
    }

    @Override
    public void addCRLIssuingPoint(String name, CRLIssuingPointRecord rec) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "cn=" + this.transformDN(name) + "," + this.getBaseDN();
            s.add(dn, (IDBObj)rec);
        }
    }

    public Enumeration<RepositoryRecord> searchRepository(String name, String filter) throws EBaseException {
        Vector<RepositoryRecord> v = new Vector<RepositoryRecord>();
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search("cn=" + this.transformDN(name) + "," + this.getBaseDN(), filter);
            while (sr.hasMoreElements()) {
                v.add((RepositoryRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    @Override
    public void addRepository(String name, String thisUpdate, RepositoryRecord rec) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "ou=" + thisUpdate + ",cn=" + this.transformDN(name) + "," + this.getBaseDN();
            s.add(dn, (IDBObj)rec);
        }
    }

    public void modifyCertRecord(String name, String thisUpdate, String sno, ModificationSet mods) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "cn=" + sno + ",ou=" + thisUpdate + ",cn=" + this.transformDN(name) + "," + this.getBaseDN();
            if (s != null) {
                s.modify(dn, mods);
            }
        }
    }

    public Enumeration<CertRecord> searchCertRecord(String name, String thisUpdate, String filter) throws EBaseException {
        Vector<CertRecord> v = new Vector<CertRecord>();
        try (DBSSession s = this.dbSubsystem.createSession();){
            DBSearchResults sr = s.search("ou=" + thisUpdate + ",cn=" + this.transformDN(name) + "," + this.getBaseDN(), filter);
            while (sr.hasMoreElements()) {
                v.add((CertRecord)sr.nextElement());
            }
        }
        return v.elements();
    }

    public CertRecord readCertRecord(String name, String thisUpdate, String sno) throws EBaseException {
        CertRecord rec = null;
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "cn=" + sno + ",ou=" + thisUpdate + ",cn=" + this.transformDN(name) + "," + this.getBaseDN();
            if (s != null) {
                rec = (CertRecord)s.read(dn);
            }
        }
        return rec;
    }

    public void addCertRecord(String name, String thisUpdate, String sno, CertRecord rec) throws EBaseException {
        try (DBSSession s = this.dbSubsystem.createSession();){
            String dn = "cn=" + sno + ",ou=" + thisUpdate + ",cn=" + this.transformDN(name) + "," + this.getBaseDN();
            s.add(dn, (IDBObj)rec);
        }
    }

    @Override
    public NameValuePairs getConfigParameters() {
        try {
            NameValuePairs params = new NameValuePairs();
            params.put((Object)"implName", (Object)this.mConfig.getString("class"));
            params.put((Object)PROP_NOT_FOUND_GOOD, (Object)this.mConfig.getString(PROP_NOT_FOUND_GOOD, "true"));
            params.put((Object)PROP_BY_NAME, (Object)this.mConfig.getString(PROP_BY_NAME, "true"));
            params.put((Object)PROP_INCLUDE_NEXT_UPDATE, (Object)this.mConfig.getString(PROP_INCLUDE_NEXT_UPDATE, "false"));
            return params;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setConfigParameters(NameValuePairs pairs) throws EBaseException {
        for (String key : pairs.keySet()) {
            this.mConfig.put(key, (String)pairs.get((Object)key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCRL(X509CRL crl) throws EBaseException {
        try {
            ++this.mStateCount;
            logger.debug("DefStore: Ready to update Issuer");
            try {
                if (!((X509CRLImpl)crl).areEntriesIncluded()) {
                    crl = new X509CRLImpl(((X509CRLImpl)crl).getEncoded());
                }
            }
            catch (Exception e) {
                logger.warn("DefStore: " + e.getMessage(), (Throwable)e);
            }
            ModificationSet mods = new ModificationSet();
            if (crl.getThisUpdate() != null) {
                mods.add("thisUpdate", 2, (Object)crl.getThisUpdate());
            }
            if (crl.getNextUpdate() != null) {
                mods.add("nextUpdate", 2, (Object)crl.getNextUpdate());
            }
            if (this.mUseCache && ((X509CRLImpl)crl).getListOfRevokedCertificates() != null) {
                mods.add("crlCache", 2, (Object)((X509CRLImpl)crl).getListOfRevokedCertificates());
            }
            if (((X509CRLImpl)crl).getNumberOfRevokedCertificates() < 0) {
                mods.add("crlSize", 2, (Object)0L);
            } else {
                mods.add("crlSize", 2, (Object)((X509CRLImpl)crl).getNumberOfRevokedCertificates());
            }
            BigInteger crlNumber = ((X509CRLImpl)crl).getCRLNumber();
            if (crlNumber == null) {
                mods.add("crlNumber", 2, (Object)new BigInteger("-1"));
            } else {
                mods.add("crlNumber", 2, (Object)crlNumber);
            }
            try {
                mods.add("certificaterevocationlist", 2, (Object)crl.getEncoded());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.debug("DefStore: ready to CRL update " + crl.getIssuerDN().getName());
            this.modifyCRLIssuingPointRecord(crl.getIssuerDN().getName(), mods);
            logger.debug("DefStore: done CRL update " + crl.getIssuerDN().getName());
            this.mCacheCRLIssuingPoints.clear();
            logger.info("DefStore: Finish Committing CRL. thisUpdate=" + crl.getThisUpdate() + " nextUpdate=" + crl.getNextUpdate());
        }
        finally {
            --this.mStateCount;
        }
    }

    @Override
    public int getStateCount() {
        return this.mStateCount;
    }
}

