/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.msg;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dogtagpki.tps.main.Util;
import org.dogtagpki.tps.msg.TPSMessage;

public class ExtendedLoginRequestMsg
extends TPSMessage {
    private Set<String> params;

    public ExtendedLoginRequestMsg(int invalid_pw, int blocked, Set<String> params, String title, String description) throws UnsupportedEncodingException {
        this.put("invalid_pw", invalid_pw);
        this.put("blocked", blocked);
        this.put("msg_type", this.msgTypeToInt(TPSMessage.MsgType.MSG_EXTENDED_LOGIN_REQUEST));
        this.put("title", Util.uriEncode(title));
        this.put("description", Util.uriEncode(description));
        this.params = params;
    }

    @Override
    public String encode() {
        ArrayList<String> orderedParams = new ArrayList<String>();
        if (!this.params.isEmpty()) {
            String cur = null;
            Iterator<String> iter = this.params.iterator();
            while (iter.hasNext()) {
                try {
                    cur = Util.uriEncode(iter.next());
                }
                catch (UnsupportedEncodingException e) {
                    cur = null;
                }
                if (cur == null || cur.length() <= 0) continue;
                if (cur.contains("UID")) {
                    orderedParams.add(0, cur);
                    continue;
                }
                orderedParams.add(cur);
            }
            int i = 0;
            for (String curParam : orderedParams) {
                if (curParam == null || curParam.length() <= 0) continue;
                String name = "required_parameter" + Integer.toString(i++);
                String value = curParam;
                this.put(name, value);
            }
        }
        return super.encode();
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String title = "LDAP Authentication";
        String description = "This authenticates user against the LDAP directory.";
        HashSet<String> params = new HashSet<String>();
        params.add("id=UID&name=LDAP User ID&desc=LDAP User ID&type=string&option=");
        params.add("id=PASSWORD&name=LDAP Password&desc=LDAP Password&type=password&option=");
        ExtendedLoginRequestMsg ext_login_req = new ExtendedLoginRequestMsg(0, 0, params, "LDAP Authentication", "This authenticates user against the LDAP directory.");
        System.out.println(ext_login_req.encode());
    }
}

