/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.binary.Base64;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class JWS {
    @JsonProperty(value="protected")
    private String protectedHeader;
    private String payload;
    private String signature;

    public String getProtectedHeader() {
        return this.protectedHeader;
    }

    public byte[] getProtectedHeaderAsBytes() {
        return Base64.decodeBase64((String)this.protectedHeader);
    }

    public void setProtectedHeader(String protectedHeader) {
        this.protectedHeader = protectedHeader;
    }

    public String getPayload() {
        return this.payload;
    }

    public byte[] getPayloadAsBytes() {
        return Base64.decodeBase64((String)this.payload);
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte[] getSignatureAsBytes() {
        return Base64.decodeBase64((String)this.signature);
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String toJSON() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static JWS fromJSON(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (JWS)mapper.readValue(json, JWS.class);
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

