/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Date;
import org.dogtagpki.acme.ACME;
import org.dogtagpki.acme.ACMEIdentifier;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMEOrder {
    @JsonIgnore
    private String id;
    @JsonIgnore
    private String accountID;
    @JsonIgnore
    private Date creationTime;
    @JsonIgnore
    private Date expirationTime;
    @JsonIgnore
    private Date notBeforeTime;
    @JsonIgnore
    private Date notAfterTime;
    @JsonIgnore
    private String[] authzIDs;
    @JsonIgnore
    private String certID;
    private String status;
    private String expires;
    private ACMEIdentifier[] identifiers;
    private String notBefore;
    private String notAfter;
    private String error;
    private URI[] authorizations;
    private URI finalize;
    private String csr;
    private URI certificate;
    private URI resource;

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getAccountID() {
        return this.accountID;
    }

    public void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
        this.expires = expirationTime == null ? null : ACME.DATE_FORMAT.format(expirationTime);
    }

    public Date getNotBeforeTime() {
        return this.notBeforeTime;
    }

    public void setNotBeforeTime(Date notBeforeTime) {
        this.notBeforeTime = notBeforeTime;
        this.notBefore = notBeforeTime == null ? null : ACME.DATE_FORMAT.format(notBeforeTime);
    }

    public Date getNotAfterTime() {
        return this.notAfterTime;
    }

    public void setNotAfterTime(Date notAfterTime) {
        this.notAfterTime = notAfterTime;
        this.notAfter = notAfterTime == null ? null : ACME.DATE_FORMAT.format(notAfterTime);
    }

    public String[] getAuthzIDs() {
        return this.authzIDs;
    }

    public void setAuthzIDs(String[] authzIDs) {
        this.authzIDs = authzIDs;
    }

    public String getCertID() {
        return this.certID;
    }

    public void setCertID(String certID) {
        this.certID = certID;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String notBefore) {
        this.notBefore = notBefore;
    }

    public String getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(String notAfter) {
        this.notAfter = notAfter;
    }

    public ACMEIdentifier[] getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(ACMEIdentifier[] identifiers) {
        this.identifiers = identifiers;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public URI[] getAuthorizations() {
        return this.authorizations;
    }

    public void setAuthorizations(URI[] authorizations) {
        this.authorizations = authorizations;
    }

    public URI getFinalize() {
        return this.finalize;
    }

    public void setFinalize(URI finalize) {
        this.finalize = finalize;
    }

    public String getCSR() {
        return this.csr;
    }

    public void setCSR(String csr) {
        this.csr = csr;
    }

    public URI getCertificate() {
        return this.certificate;
    }

    public void setCertificate(URI certificate) {
        this.certificate = certificate;
    }

    public URI getResource() {
        return this.resource;
    }

    public void setResource(URI resource) {
        this.resource = resource;
    }

    public String toJSON() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)this);
    }

    public static ACMEOrder fromJSON(String json) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (ACMEOrder)mapper.readValue(json, ACMEOrder.class);
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

