/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme;

import com.netscape.certsrv.account.Account;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import java.net.URISyntaxException;
import org.dogtagpki.acme.ACMEDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACMEClient
extends Client {
    public static Logger logger = LoggerFactory.getLogger(ACMEClient.class);

    public ACMEClient(PKIClient client) throws URISyntaxException {
        super(client, "acme", null, null);
    }

    public Account login() throws Exception {
        Account account = this.post("login", Account.class);
        logger.info("Account: " + account.getID());
        logger.info("Roles:");
        for (String role : account.getRoles()) {
            logger.info("- " + role);
        }
        return account;
    }

    public void enable() throws Exception {
        this.post("enable", Void.class);
    }

    public void disable() throws Exception {
        this.post("disable", Void.class);
    }

    public void logout() throws Exception {
        this.post("logout", Void.class);
    }

    public ACMEDirectory getDirectory() throws Exception {
        return this.get("directory", ACMEDirectory.class);
    }
}

