/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.CertID;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;

public class SingleResponse
implements ASN1Value {
    private CertID mCID = null;
    private CertStatus mStatus = null;
    private GeneralizedTime mThisUpdate = null;
    private GeneralizedTime mNextUpdate = null;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public SingleResponse(CertID cid, CertStatus s, GeneralizedTime thisUpdate, GeneralizedTime nextUpdate) {
        this.mCID = cid;
        this.mStatus = s;
        this.mThisUpdate = thisUpdate;
        this.mNextUpdate = nextUpdate;
    }

    public CertID getCertID() {
        return this.mCID;
    }

    public Tag getTag() {
        return null;
    }

    public void encode(Tag t, OutputStream os) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.mCID);
        seq.addElement((ASN1Value)this.mStatus);
        seq.addElement((ASN1Value)this.mThisUpdate);
        if (this.mNextUpdate != null) {
            seq.addElement((ASN1Value)new EXPLICIT(Tag.get((long)0L), (ASN1Value)this.mNextUpdate));
        }
        if (t == null) {
            seq.encode(os);
        } else {
            seq.encode(t, os);
        }
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(null, os);
    }

    public CertStatus getCertStatus() {
        return this.mStatus;
    }

    public GeneralizedTime getThisUpdate() {
        return this.mThisUpdate;
    }

    public GeneralizedTime getNextUpdate() {
        return this.mNextUpdate;
    }

    public int getExtensionCount() {
        return 0;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)new CertID.Template());
            this.seqt.addElement((ASN1Template)new ANY.Template());
            this.seqt.addElement((ASN1Template)new GeneralizedTime.Template());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new GeneralizedTime.Template()));
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(1L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new Extension.Template())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            CertID cid = (CertID)seq.elementAt(0);
            CertStatus status = null;
            ANY e_status = (ANY)seq.elementAt(1);
            if (e_status.getTag().getNum() == 0L) {
                status = (GoodInfo)GoodInfo.getTemplate().decode(e_status.getTag(), new ByteArrayInputStream(e_status.getEncoded()));
            } else if (e_status.getTag().getNum() == 1L) {
                status = (RevokedInfo)RevokedInfo.getTemplate().decode(e_status.getTag(), new ByteArrayInputStream(e_status.getEncoded()));
            } else if (e_status.getTag().getNum() == 2L) {
                status = (UnknownInfo)UnknownInfo.getTemplate().decode(e_status.getTag(), new ByteArrayInputStream(e_status.getEncoded()));
            }
            GeneralizedTime thisUpdate = (GeneralizedTime)seq.elementAt(2);
            GeneralizedTime nextUpdate = null;
            return new SingleResponse(cid, status, thisUpdate, nextUpdate);
        }
    }
}

