/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.Response;
import com.netscape.cmsutil.ocsp.ResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class BasicOCSPResponse
implements Response {
    private byte[] mData = null;
    private ResponseData _rd = null;
    private AlgorithmIdentifier _signAlg = null;
    private BIT_STRING _signature = null;
    private Certificate[] _certs = null;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public BasicOCSPResponse(ResponseData rd, AlgorithmIdentifier signAlg, BIT_STRING signature, Certificate[] certs) {
        this._rd = rd;
        this._signAlg = signAlg;
        this._signature = signature;
        this._certs = certs;
    }

    public BasicOCSPResponse(OCTET_STRING os) throws InvalidBERException, IOException {
        this(os.toByteArray());
    }

    public BasicOCSPResponse(byte[] data) throws InvalidBERException, IOException {
        this.mData = data;
        BasicOCSPResponse resp = (BasicOCSPResponse)BasicOCSPResponse.getTemplate().decode(new ByteArrayInputStream(data));
        this._rd = resp.getResponseData();
        this._signAlg = resp.getSignatureAlgorithm();
        this._signature = resp.getSignature();
        this._certs = resp.getCerts();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(Tag t, OutputStream os) throws IOException {
        if (this.mData != null) {
            os.write(this.mData);
        } else {
            SEQUENCE seq = new SEQUENCE();
            seq.addElement((ASN1Value)this._rd);
            seq.addElement((ASN1Value)this._signAlg);
            seq.addElement((ASN1Value)this._signature);
            if (this._certs != null) {
                SEQUENCE certsSeq = new SEQUENCE();
                for (Certificate c : this._certs) {
                    certsSeq.addElement((ASN1Value)c);
                }
                EXPLICIT certsExplicit = new EXPLICIT(new Tag(0L), (ASN1Value)certsSeq);
                seq.addElement((ASN1Value)certsExplicit);
            }
            seq.encode(t, os);
        }
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(TAG, os);
    }

    @Override
    public OCTET_STRING getBytes() {
        return null;
    }

    public ResponseData getResponseData() {
        return this._rd;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this._signAlg;
    }

    public BIT_STRING getSignature() {
        return this._signature;
    }

    public int getCertsCount() {
        return this._certs != null ? this._certs.length : 0;
    }

    public Certificate[] getCerts() {
        return this._certs;
    }

    public Certificate getCertificateAt(int pos) {
        return this._certs != null ? this._certs[pos] : null;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)ResponseData.getTemplate());
            this.seqt.addElement((ASN1Template)AlgorithmIdentifier.getTemplate());
            this.seqt.addElement((ASN1Template)BIT_STRING.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)Certificate.getTemplate())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            EXPLICIT certSeqExplicit;
            SEQUENCE certSeq;
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            ResponseData rd = (ResponseData)seq.elementAt(0);
            AlgorithmIdentifier alg = (AlgorithmIdentifier)seq.elementAt(1);
            BIT_STRING bs = (BIT_STRING)seq.elementAt(2);
            Certificate[] certs = null;
            if (seq.size() == 4 && (certSeq = (SEQUENCE)(certSeqExplicit = (EXPLICIT)seq.elementAt(3)).getContent()) != null) {
                certs = new Certificate[certSeq.size()];
                for (int x = 0; x < certSeq.size(); ++x) {
                    certs[x] = (Certificate)certSeq.elementAt(x);
                }
            }
            return new BasicOCSPResponse(rd, alg, bs, certs);
        }
    }
}

