/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class JSONObject
extends ObjectMapper {
    private static final long serialVersionUID = 2L;
    private static ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).deactivateDefaultTyping().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
    private ObjectNode rootNode = mapper.createObjectNode();
    private transient JsonNode jsonNode = null;

    public JSONObject() {
    }

    public JSONObject(InputStream s) throws IOException {
        this();
        this.jsonNode = mapper.readTree(s);
    }

    public JSONObject(String s) throws IOException {
        this();
        this.jsonNode = mapper.readTree(s);
    }

    public ObjectMapper getMapper() {
        return mapper;
    }

    public ObjectNode getRootNode() {
        return this.rootNode;
    }

    protected void setRootNode(ObjectNode rootNode) {
        this.rootNode = rootNode;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    protected void setJsonNode(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        JsonFactory jfactory = new JsonFactory();
        try (JsonGenerator jGenerator = jfactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);){
            jGenerator.setCodec((ObjectCodec)this.getMapper());
            jGenerator.writeTree((TreeNode)this.getRootNode());
        }
        return stream.toByteArray();
    }

    public int hashCode() {
        return Objects.hash(this.rootNode, this.jsonNode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        JSONObject other = (JSONObject)((Object)obj);
        return Objects.equals(this.rootNode, other.rootNode) && Objects.equals(this.jsonNode, other.jsonNode);
    }

    public String toString() {
        return "JSONObject [mapper=" + mapper + ", rootNode=" + this.rootNode + ", jsonNode=" + this.jsonNode + ", getMapper()=" + this.getMapper() + ", getRootNode()=" + this.getRootNode() + ", getJsonNode()=" + this.getJsonNode() + ", hashCode()=" + this.hashCode() + "]";
    }
}

