/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.tps.profile;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.tps.profile.ProfileCollection;
import com.netscape.certsrv.tps.profile.ProfileData;
import java.util.HashMap;
import javax.ws.rs.client.Entity;

public class ProfileClient
extends Client {
    public ProfileClient(PKIClient client) throws Exception {
        this(client, client.getSubsystem());
    }

    public ProfileClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "profiles");
    }

    public ProfileCollection findProfiles(String filter, Integer start, Integer size) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (filter != null) {
            params.put("filter", filter);
        }
        if (start != null) {
            params.put("start", start);
        }
        if (size != null) {
            params.put("size", size);
        }
        return this.get(null, params, ProfileCollection.class);
    }

    public ProfileData getProfile(String profileID) throws Exception {
        return this.get(profileID, ProfileData.class);
    }

    public ProfileData addProfile(ProfileData profileData) throws Exception {
        Entity<ProfileData> entity = this.client.entity(profileData);
        return this.post(null, null, entity, ProfileData.class);
    }

    public ProfileData updateProfile(String profileID, ProfileData profileData) throws Exception {
        Entity<ProfileData> entity = this.client.entity(profileData);
        return this.patch(profileID, null, entity, ProfileData.class);
    }

    public ProfileData changeProfileStatus(String profileID, String action) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (action != null) {
            params.put("action", action);
        }
        return this.post(profileID, params, null, ProfileData.class);
    }

    public void removeProfile(String profileID) throws Exception {
        this.delete(profileID, Void.class);
    }
}

