/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.request;

import com.netscape.certsrv.request.AgentApproval;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentApprovals
implements Serializable {
    public static Logger logger = LoggerFactory.getLogger(AgentApprovals.class);
    private static final long serialVersionUID = -3827259076159153561L;
    protected Vector<AgentApproval> mVector = new Vector();

    public AgentApproval addApproval(String userName) {
        AgentApproval a = this.findApproval(userName);
        if (a != null) {
            logger.debug("Updating existing approval: " + userName);
            a.mDate = new Date();
            return a;
        }
        logger.debug("Adding new approval: " + userName);
        a = new AgentApproval(userName);
        this.mVector.addElement(a);
        return a;
    }

    public void removeApproval(String userName) {
        AgentApproval a = this.findApproval(userName);
        if (a != null) {
            this.mVector.removeElement(a);
        }
    }

    public AgentApproval findApproval(String userName) {
        for (int i = 0; i < this.mVector.size(); ++i) {
            AgentApproval a = this.mVector.elementAt(i);
            if (!a.mUserName.equals(userName)) continue;
            logger.debug("Found existing approval: " + userName);
            return a;
        }
        logger.debug("Existing approval not found: " + userName);
        return null;
    }

    public Enumeration<AgentApproval> elements() {
        return this.mVector.elements();
    }

    public Vector<String> toStringVector() {
        Vector<String> retval = new Vector<String>(this.mVector.size());
        for (int i = 0; i < this.mVector.size(); ++i) {
            AgentApproval a = this.mVector.elementAt(i);
            retval.add(a.getDate().getTime() + ";" + a.getUserName());
        }
        return retval;
    }

    public static AgentApprovals fromStringVector(Vector<String> stringVector) {
        if (stringVector == null) {
            return null;
        }
        AgentApprovals approvals = new AgentApprovals();
        for (int i = 0; i < stringVector.size(); ++i) {
            try {
                String approvalString = stringVector.get(i);
                String[] parts = approvalString.split(";", 2);
                if (parts.length != 2) {
                    return null;
                }
                Long epoch = Long.valueOf(parts[0]);
                Date date = new Date(epoch);
                AgentApproval approval = new AgentApproval(parts[1]);
                approval.mDate = date;
                approvals.mVector.add(approval);
                continue;
            }
            catch (ClassCastException e) {
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return approvals;
    }

    public int size() {
        return this.mVector.size();
    }

    public AgentApproval get(int i) {
        return this.mVector.get(i);
    }
}

