/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.logging;

import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.logging.AuditConfig;
import com.netscape.certsrv.logging.AuditFileCollection;
import java.util.HashMap;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

public class AuditClient
extends Client {
    public AuditClient(PKIClient client, String subsystem) throws Exception {
        super(client, subsystem, "audit");
    }

    public AuditConfig getAuditConfig() throws Exception {
        return this.get(AuditConfig.class);
    }

    public AuditConfig updateAuditConfig(AuditConfig auditConfig) throws Exception {
        Entity<AuditConfig> entity = this.client.entity(auditConfig);
        return this.patch(null, null, entity, AuditConfig.class);
    }

    public AuditConfig changeAuditStatus(String action) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", action);
        return this.post(null, params, null, AuditConfig.class);
    }

    public AuditFileCollection findAuditFiles() throws Exception {
        return this.get("files", AuditFileCollection.class);
    }

    public StreamingOutput getAuditFile(String filename) throws Exception {
        WebTarget target = this.target("files/" + filename, null);
        Response response = target.request(new String[]{"application/octet-stream"}).get();
        return this.client.getEntity(response, StreamingOutput.class);
    }
}

