/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.key;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netscape.certsrv.base.RESTMessage;
import com.netscape.certsrv.key.KeyGenerationRequest;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AsymKeyGenerationRequest
extends KeyGenerationRequest {
    public static final String ENCRYPT = "encrypt";
    public static final String DECRYPT = "decrypt";
    public static final String SIGN = "sign";
    public static final String SIGN_RECOVER = "sign_recover";
    public static final String VERIFY = "verify";
    public static final String VERIFY_RECOVER = "verify_recover";
    public static final String WRAP = "wrap";
    public static final String UNWRAP = "unwrap";
    public static final String DERIVE = "derive";

    public AsymKeyGenerationRequest() {
        this.setClassName(this.getClass().getName());
    }

    public AsymKeyGenerationRequest(MultivaluedMap<String, String> form) {
        this.attributes.put("clientKeyID", (String)form.getFirst((Object)"clientKeyID"));
        this.attributes.put("keySize", (String)form.getFirst((Object)"keySize"));
        this.attributes.put("keyAlgorithm", (String)form.getFirst((Object)"keyAlgorithm"));
        this.attributes.put("keyUsage", (String)form.getFirst((Object)"keyUsage"));
        this.attributes.put("transWrappedSessionKey", (String)form.getFirst((Object)"transWrappedSessionKey"));
        this.attributes.put("realm", (String)form.getFirst((Object)"realm"));
        String usageString = (String)this.attributes.get("keyUsage");
        if (!StringUtils.isBlank((CharSequence)usageString)) {
            this.setUsages(new ArrayList<String>(Arrays.asList(usageString.split(","))));
        }
        this.setClassName(this.getClass().getName());
    }

    public AsymKeyGenerationRequest(RESTMessage data) {
        this.attributes.putAll(data.getAttributes());
        this.setClassName(this.getClass().getName());
    }

    @Override
    public String toString() {
        try {
            return this.toXML();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getValidUsagesList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DERIVE);
        list.add(SIGN);
        list.add(DECRYPT);
        list.add(ENCRYPT);
        list.add(WRAP);
        list.add(UNWRAP);
        list.add(SIGN_RECOVER);
        list.add(VERIFY);
        list.add(VERIFY_RECOVER);
        return list;
    }

    @Override
    public Element toDOM(Document document) {
        Element element = document.createElement("AsymKeyGenerationRequest");
        this.toDOM(document, element);
        return element;
    }

    public static AsymKeyGenerationRequest fromDOM(Element element) {
        AsymKeyGenerationRequest request = new AsymKeyGenerationRequest();
        AsymKeyGenerationRequest.fromDOM(element, request);
        return request;
    }

    public static AsymKeyGenerationRequest fromXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element element = document.getDocumentElement();
        return AsymKeyGenerationRequest.fromDOM(element);
    }
}

