/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.ca;

import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.cert.CertRevokeRequest;
import com.netscape.certsrv.client.Client;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import javax.ws.rs.client.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAAgentCertClient
extends Client {
    public static final Logger logger = LoggerFactory.getLogger(CAAgentCertClient.class);

    public CAAgentCertClient(PKIClient client) throws Exception {
        super(client, "ca", "agent/certs");
    }

    public CertData reviewCert(CertId id) throws Exception {
        return this.get(id.toHexString(), CertData.class);
    }

    public CertRequestInfo revokeCert(CertId id, CertRevokeRequest request) throws Exception {
        Entity<CertRevokeRequest> entity = this.client.entity(request);
        return this.post(id.toHexString() + "/revoke", null, entity, CertRequestInfo.class);
    }

    public CertRequestInfo revokeCACert(CertId id, CertRevokeRequest request) throws Exception {
        Entity<CertRevokeRequest> entity = this.client.entity(request);
        return this.post(id.toHexString() + "/revoke-ca", null, entity, CertRequestInfo.class);
    }

    public CertRequestInfo unrevokeCert(CertId id) throws Exception {
        return this.post(id.toHexString() + "/unrevoke", CertRequestInfo.class);
    }
}

