/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.certsrv.authority;

import com.netscape.certsrv.acls.ACLMapping;
import com.netscape.certsrv.authentication.AuthMethodMapping;
import com.netscape.certsrv.authority.AuthorityData;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="authorities")
public interface AuthorityResource {
    public static final String HOST_AUTHORITY = "host-authority";

    @GET
    public Response findCAs(@QueryParam(value="id") String var1, @QueryParam(value="parentID") String var2, @QueryParam(value="dn") String var3, @QueryParam(value="issuerDN") String var4) throws Exception;

    @GET
    @Path(value="{id}")
    public Response getCA(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/cert")
    @Produces(value={"application/pkix-cert"})
    public Response getCert(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/cert")
    @Produces(value={"application/x-pem-file"})
    public Response getCertPEM(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/chain")
    @Produces(value={"application/pkcs7-mime"})
    public Response getChain(@PathParam(value="id") String var1);

    @GET
    @Path(value="{id}/chain")
    @Produces(value={"application/x-pem-file"})
    public Response getChainPEM(@PathParam(value="id") String var1);

    @POST
    @AuthMethodMapping(value="authorities")
    @ACLMapping(value="authorities.create")
    public Response createCA(AuthorityData var1);

    @PUT
    @Path(value="{id}")
    @AuthMethodMapping(value="authorities")
    @ACLMapping(value="authorities.modify")
    public Response modifyCA(@PathParam(value="id") String var1, AuthorityData var2);

    @POST
    @Path(value="{id}/enable")
    @AuthMethodMapping(value="authorities")
    @ACLMapping(value="authorities.modify")
    public Response enableCA(@PathParam(value="id") String var1);

    @POST
    @Path(value="{id}/disable")
    @AuthMethodMapping(value="authorities")
    @ACLMapping(value="authorities.modify")
    public Response disableCA(@PathParam(value="id") String var1);

    @POST
    @Path(value="{id}/renew")
    @AuthMethodMapping(value="authorities")
    @ACLMapping(value="authorities.modify")
    public Response renewCA(@PathParam(value="id") String var1);

    @DELETE
    @Path(value="{id}")
    @AuthMethodMapping(value="authorities")
    @ACLMapping(value="authorities.delete")
    public Response deleteCA(@PathParam(value="id") String var1);
}

