/*
 * Rekor
 *
 * Rekor is a cryptographically secure, immutable transparency log for signed software releases.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, PartialEq, Eq, Default, Serialize, Deserialize)]
pub struct SearchIndexPublicKey {
    #[serde(rename = "format")]
    pub format: Format,
    #[serde(rename = "content", skip_serializing_if = "Option::is_none")]
    pub content: Option<String>,
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
}

impl SearchIndexPublicKey {
    pub fn new(format: Format) -> SearchIndexPublicKey {
        SearchIndexPublicKey {
            format,
            content: None,
            url: None,
        }
    }
}

///  The supported pluggable types to sign and upload data
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Format {
    #[serde(rename = "pgp")]
    Pgp,
    #[serde(rename = "x509")]
    X509,
    #[serde(rename = "minisign")]
    Minisign,
    #[serde(rename = "ssh")]
    Ssh,
    #[serde(rename = "tuf")]
    Tuf,
}

impl Default for Format {
    fn default() -> Format {
        Self::Pgp
    }
}
