"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.promptConfirm = exports.promptList = exports.promptInput = exports.answerRequired = void 0;
const answerRequired = (question) => {
    return Object.assign(Object.assign({}, question), { validate: (answer) => answer.trim() !== '' || `${question.name} is required` });
};
exports.answerRequired = answerRequired;
const promptInput = (name, message, required = false, def = undefined, when = true) => {
    const model = {
        type: 'input',
        name,
        message,
        default: def,
        when,
    };
    return required ? (0, exports.answerRequired)(model) : model;
};
exports.promptInput = promptInput;
const promptList = (name, message, choices, def = undefined, when = true) => {
    const model = {
        type: 'list',
        name,
        message,
        choices,
        default: def,
        when,
    };
    return model;
};
exports.promptList = promptList;
const promptConfirm = (name, message, def = undefined, when = true) => {
    const model = {
        type: 'confirm',
        name,
        message,
        default: def,
        when,
    };
    return model;
};
exports.promptConfirm = promptConfirm;
//# sourceMappingURL=prompt.js.map