/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/// This implements the developer facing API for recording rate metrics.
///
/// Instances of this class type are automatically generated by the parsers at build time,
/// allowing developers to record values that were previously registered in the metrics.yaml file.
///
/// The rate API exposes the `RateMetricType.addToNumerator(_:)` and `RateMetricType.addToDenominator(_:)` method,
/// which takes care of validating the input data and making sure that limits are enforced.
public typealias RateMetricType = RateMetric

/// This implements the developer facing API for recording a denominator of a rate metric,
/// where the denominator is external.
/// It is essentially a wrapper around `CounterMetricType`.
///
/// Instances of this class type are automatically generated by the parsers at build time,
/// allowing developers to record values that were previously registered in the metrics.yaml file.
///
/// The denominator API exposes the `DenominatorMetricType.add(_:)` method,
/// which takes care of validating the input data and making sure that limits are enforced.
public typealias DenominatorMetricType = DenominatorMetric

/// This implements the developer facing API for recording the numerator of a rate metric
/// with an external denominator.
///
/// Instances of this class type are automatically generated by the parsers at build time,
/// allowing developers to record values that were previously registered in the metrics.yaml file.
///
/// The numerator API exposes the `NumeratorMetrictype.addToNumerator(_:)` method,
/// which takes care of validating the input data and making sure that limits are enforced.
public typealias NumeratorMetricType = NumeratorMetric
