; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv32 -mattr=+v,+f,+d,+zfh,+zvfh -riscv-v-vector-bits-min=-1 < %s | FileCheck %s --check-prefixes=RV32V
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh -riscv-v-vector-bits-min=-1 < %s | FileCheck %s --check-prefixes=RV64V
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv32 -mattr=+zve64x -riscv-v-vector-bits-min=-1 < %s | FileCheck %s --check-prefixes=RV32ZVE64X
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+zve64x -riscv-v-vector-bits-min=-1 < %s | FileCheck %s --check-prefixes=RV64ZVE64X
; Check that we don't crash querying costs when vectors are not enabled.
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64

define void @extractelement_int(i32 %x) {
; RV32V-LABEL: 'extractelement_int'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_0 = extractelement <2 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_0 = extractelement <4 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_0 = extractelement <8 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i1_0 = extractelement <16 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i1_0 = extractelement <32 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_0 = extractelement <vscale x 2 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_0 = extractelement <vscale x 4 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i1_0 = extractelement <vscale x 8 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i1_0 = extractelement <vscale x 16 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i1_0 = extractelement <vscale x 32 x i1> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = extractelement <2 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = extractelement <4 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = extractelement <8 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = extractelement <16 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = extractelement <32 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = extractelement <64 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = extractelement <128 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = extractelement <vscale x 2 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = extractelement <vscale x 4 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = extractelement <vscale x 8 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = extractelement <vscale x 16 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = extractelement <vscale x 32 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = extractelement <vscale x 64 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = extractelement <vscale x 128 x i8> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = extractelement <2 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = extractelement <4 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = extractelement <8 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = extractelement <16 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = extractelement <32 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = extractelement <64 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = extractelement <vscale x 2 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = extractelement <vscale x 4 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = extractelement <vscale x 8 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = extractelement <vscale x 16 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = extractelement <vscale x 32 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = extractelement <vscale x 64 x i16> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = extractelement <2 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = extractelement <4 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = extractelement <8 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = extractelement <16 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = extractelement <32 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = extractelement <vscale x 2 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = extractelement <vscale x 4 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = extractelement <vscale x 8 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = extractelement <vscale x 16 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = extractelement <vscale x 32 x i32> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i64_0 = extractelement <2 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i64_0 = extractelement <4 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64_0 = extractelement <8 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64_0 = extractelement <16 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i64_0 = extractelement <vscale x 2 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64_0 = extractelement <vscale x 4 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i64_0 = extractelement <vscale x 8 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_0 = extractelement <vscale x 16 x i64> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_1 = extractelement <2 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_1 = extractelement <4 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_1 = extractelement <8 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_1 = extractelement <16 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_1 = extractelement <32 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_1 = extractelement <vscale x 2 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_1 = extractelement <vscale x 4 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_1 = extractelement <vscale x 8 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_1 = extractelement <vscale x 16 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_1 = extractelement <vscale x 32 x i1> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = extractelement <2 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = extractelement <4 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = extractelement <8 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = extractelement <16 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = extractelement <32 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = extractelement <64 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_1 = extractelement <128 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = extractelement <vscale x 2 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = extractelement <vscale x 4 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = extractelement <vscale x 8 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = extractelement <vscale x 16 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = extractelement <vscale x 32 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = extractelement <vscale x 64 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_1 = extractelement <vscale x 128 x i8> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = extractelement <2 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = extractelement <4 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = extractelement <8 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = extractelement <16 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = extractelement <32 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_1 = extractelement <64 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = extractelement <vscale x 2 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = extractelement <vscale x 4 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = extractelement <vscale x 8 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = extractelement <vscale x 16 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = extractelement <vscale x 32 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_1 = extractelement <vscale x 64 x i16> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = extractelement <2 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = extractelement <4 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = extractelement <8 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = extractelement <16 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_1 = extractelement <32 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = extractelement <vscale x 2 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = extractelement <vscale x 4 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = extractelement <vscale x 8 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = extractelement <vscale x 16 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_1 = extractelement <vscale x 32 x i32> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i64_1 = extractelement <2 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i64_1 = extractelement <4 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i64_1 = extractelement <8 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i64_1 = extractelement <16 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i64_1 = extractelement <vscale x 2 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i64_1 = extractelement <vscale x 4 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i64_1 = extractelement <vscale x 8 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_1 = extractelement <vscale x 16 x i64> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_x = extractelement <2 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_x = extractelement <4 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_x = extractelement <8 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_x = extractelement <16 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_x = extractelement <32 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_x = extractelement <vscale x 2 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_x = extractelement <vscale x 4 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_x = extractelement <vscale x 8 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_x = extractelement <vscale x 16 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_x = extractelement <vscale x 32 x i1> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_x = extractelement <2 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_x = extractelement <4 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_x = extractelement <8 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_x = extractelement <16 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_x = extractelement <32 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_x = extractelement <64 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_x = extractelement <128 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_x = extractelement <vscale x 2 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_x = extractelement <vscale x 4 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_x = extractelement <vscale x 8 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_x = extractelement <vscale x 16 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_x = extractelement <vscale x 32 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_x = extractelement <vscale x 64 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_x = extractelement <vscale x 128 x i8> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_x = extractelement <2 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_x = extractelement <4 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_x = extractelement <8 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_x = extractelement <16 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_x = extractelement <32 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_x = extractelement <64 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_x = extractelement <vscale x 2 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_x = extractelement <vscale x 4 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_x = extractelement <vscale x 8 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_x = extractelement <vscale x 16 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_x = extractelement <vscale x 32 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_x = extractelement <vscale x 64 x i16> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_x = extractelement <2 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_x = extractelement <4 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_x = extractelement <8 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_x = extractelement <16 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_x = extractelement <32 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_x = extractelement <vscale x 2 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_x = extractelement <vscale x 4 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_x = extractelement <vscale x 8 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_x = extractelement <vscale x 16 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_x = extractelement <vscale x 32 x i32> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i64_x = extractelement <2 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i64_x = extractelement <4 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i64_x = extractelement <8 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i64_x = extractelement <16 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i64_x = extractelement <vscale x 2 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i64_x = extractelement <vscale x 4 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i64_x = extractelement <vscale x 8 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_x = extractelement <vscale x 16 x i64> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64V-LABEL: 'extractelement_int'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_0 = extractelement <2 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_0 = extractelement <4 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_0 = extractelement <8 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i1_0 = extractelement <16 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i1_0 = extractelement <32 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_0 = extractelement <vscale x 2 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_0 = extractelement <vscale x 4 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i1_0 = extractelement <vscale x 8 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i1_0 = extractelement <vscale x 16 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i1_0 = extractelement <vscale x 32 x i1> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = extractelement <2 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = extractelement <4 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = extractelement <8 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = extractelement <16 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = extractelement <32 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = extractelement <64 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = extractelement <128 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = extractelement <vscale x 2 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = extractelement <vscale x 4 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = extractelement <vscale x 8 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = extractelement <vscale x 16 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = extractelement <vscale x 32 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = extractelement <vscale x 64 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = extractelement <vscale x 128 x i8> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = extractelement <2 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = extractelement <4 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = extractelement <8 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = extractelement <16 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = extractelement <32 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = extractelement <64 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = extractelement <vscale x 2 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = extractelement <vscale x 4 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = extractelement <vscale x 8 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = extractelement <vscale x 16 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = extractelement <vscale x 32 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = extractelement <vscale x 64 x i16> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = extractelement <2 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = extractelement <4 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = extractelement <8 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = extractelement <16 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = extractelement <32 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = extractelement <vscale x 2 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = extractelement <vscale x 4 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = extractelement <vscale x 8 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = extractelement <vscale x 16 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = extractelement <vscale x 32 x i32> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64_0 = extractelement <2 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i64_0 = extractelement <4 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i64_0 = extractelement <8 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_0 = extractelement <16 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i64_0 = extractelement <vscale x 2 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i64_0 = extractelement <vscale x 4 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i64_0 = extractelement <vscale x 8 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_0 = extractelement <vscale x 16 x i64> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_1 = extractelement <2 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_1 = extractelement <4 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_1 = extractelement <8 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_1 = extractelement <16 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_1 = extractelement <32 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_1 = extractelement <vscale x 2 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_1 = extractelement <vscale x 4 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_1 = extractelement <vscale x 8 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_1 = extractelement <vscale x 16 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_1 = extractelement <vscale x 32 x i1> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = extractelement <2 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = extractelement <4 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = extractelement <8 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = extractelement <16 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = extractelement <32 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = extractelement <64 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_1 = extractelement <128 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = extractelement <vscale x 2 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = extractelement <vscale x 4 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = extractelement <vscale x 8 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = extractelement <vscale x 16 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = extractelement <vscale x 32 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = extractelement <vscale x 64 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_1 = extractelement <vscale x 128 x i8> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = extractelement <2 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = extractelement <4 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = extractelement <8 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = extractelement <16 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = extractelement <32 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_1 = extractelement <64 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = extractelement <vscale x 2 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = extractelement <vscale x 4 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = extractelement <vscale x 8 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = extractelement <vscale x 16 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = extractelement <vscale x 32 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_1 = extractelement <vscale x 64 x i16> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = extractelement <2 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = extractelement <4 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = extractelement <8 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = extractelement <16 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_1 = extractelement <32 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = extractelement <vscale x 2 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = extractelement <vscale x 4 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = extractelement <vscale x 8 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = extractelement <vscale x 16 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_1 = extractelement <vscale x 32 x i32> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_1 = extractelement <2 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_1 = extractelement <4 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_1 = extractelement <8 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_1 = extractelement <16 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_1 = extractelement <vscale x 2 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i64_1 = extractelement <vscale x 4 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i64_1 = extractelement <vscale x 8 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_1 = extractelement <vscale x 16 x i64> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_x = extractelement <2 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_x = extractelement <4 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_x = extractelement <8 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_x = extractelement <16 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_x = extractelement <32 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_x = extractelement <vscale x 2 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_x = extractelement <vscale x 4 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_x = extractelement <vscale x 8 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_x = extractelement <vscale x 16 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_x = extractelement <vscale x 32 x i1> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_x = extractelement <2 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_x = extractelement <4 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_x = extractelement <8 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_x = extractelement <16 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_x = extractelement <32 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_x = extractelement <64 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_x = extractelement <128 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_x = extractelement <vscale x 2 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_x = extractelement <vscale x 4 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_x = extractelement <vscale x 8 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_x = extractelement <vscale x 16 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_x = extractelement <vscale x 32 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_x = extractelement <vscale x 64 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_x = extractelement <vscale x 128 x i8> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_x = extractelement <2 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_x = extractelement <4 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_x = extractelement <8 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_x = extractelement <16 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_x = extractelement <32 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_x = extractelement <64 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_x = extractelement <vscale x 2 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_x = extractelement <vscale x 4 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_x = extractelement <vscale x 8 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_x = extractelement <vscale x 16 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_x = extractelement <vscale x 32 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_x = extractelement <vscale x 64 x i16> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_x = extractelement <2 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_x = extractelement <4 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_x = extractelement <8 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_x = extractelement <16 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_x = extractelement <32 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_x = extractelement <vscale x 2 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_x = extractelement <vscale x 4 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_x = extractelement <vscale x 8 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_x = extractelement <vscale x 16 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_x = extractelement <vscale x 32 x i32> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_x = extractelement <2 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_x = extractelement <4 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_x = extractelement <8 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_x = extractelement <16 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_x = extractelement <vscale x 2 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i64_x = extractelement <vscale x 4 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i64_x = extractelement <vscale x 8 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_x = extractelement <vscale x 16 x i64> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'extractelement_int'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_0 = extractelement <2 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_0 = extractelement <4 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_0 = extractelement <8 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i1_0 = extractelement <16 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i1_0 = extractelement <32 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_0 = extractelement <vscale x 2 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_0 = extractelement <vscale x 4 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i1_0 = extractelement <vscale x 8 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i1_0 = extractelement <vscale x 16 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i1_0 = extractelement <vscale x 32 x i1> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = extractelement <2 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = extractelement <4 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = extractelement <8 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = extractelement <16 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = extractelement <32 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = extractelement <64 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = extractelement <128 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = extractelement <vscale x 2 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = extractelement <vscale x 4 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = extractelement <vscale x 8 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = extractelement <vscale x 16 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = extractelement <vscale x 32 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = extractelement <vscale x 64 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = extractelement <vscale x 128 x i8> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = extractelement <2 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = extractelement <4 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = extractelement <8 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = extractelement <16 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = extractelement <32 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = extractelement <64 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = extractelement <vscale x 2 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = extractelement <vscale x 4 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = extractelement <vscale x 8 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = extractelement <vscale x 16 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = extractelement <vscale x 32 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = extractelement <vscale x 64 x i16> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = extractelement <2 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = extractelement <4 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = extractelement <8 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = extractelement <16 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = extractelement <32 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = extractelement <vscale x 2 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = extractelement <vscale x 4 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = extractelement <vscale x 8 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = extractelement <vscale x 16 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = extractelement <vscale x 32 x i32> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i64_0 = extractelement <2 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i64_0 = extractelement <4 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64_0 = extractelement <8 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_0 = extractelement <16 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i64_0 = extractelement <vscale x 2 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64_0 = extractelement <vscale x 4 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i64_0 = extractelement <vscale x 8 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_0 = extractelement <vscale x 16 x i64> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_1 = extractelement <2 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_1 = extractelement <4 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_1 = extractelement <8 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_1 = extractelement <16 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_1 = extractelement <32 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_1 = extractelement <vscale x 2 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_1 = extractelement <vscale x 4 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_1 = extractelement <vscale x 8 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_1 = extractelement <vscale x 16 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_1 = extractelement <vscale x 32 x i1> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = extractelement <2 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = extractelement <4 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = extractelement <8 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = extractelement <16 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = extractelement <32 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = extractelement <64 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_1 = extractelement <128 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = extractelement <vscale x 2 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = extractelement <vscale x 4 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = extractelement <vscale x 8 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = extractelement <vscale x 16 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = extractelement <vscale x 32 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = extractelement <vscale x 64 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_1 = extractelement <vscale x 128 x i8> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = extractelement <2 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = extractelement <4 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = extractelement <8 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = extractelement <16 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = extractelement <32 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_1 = extractelement <64 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = extractelement <vscale x 2 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = extractelement <vscale x 4 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = extractelement <vscale x 8 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = extractelement <vscale x 16 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = extractelement <vscale x 32 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_1 = extractelement <vscale x 64 x i16> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = extractelement <2 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = extractelement <4 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = extractelement <8 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = extractelement <16 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_1 = extractelement <32 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = extractelement <vscale x 2 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = extractelement <vscale x 4 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = extractelement <vscale x 8 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = extractelement <vscale x 16 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_1 = extractelement <vscale x 32 x i32> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i64_1 = extractelement <2 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i64_1 = extractelement <4 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i64_1 = extractelement <8 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_1 = extractelement <16 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i64_1 = extractelement <vscale x 2 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i64_1 = extractelement <vscale x 4 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i64_1 = extractelement <vscale x 8 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_1 = extractelement <vscale x 16 x i64> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_x = extractelement <2 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_x = extractelement <4 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_x = extractelement <8 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_x = extractelement <16 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_x = extractelement <32 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_x = extractelement <vscale x 2 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_x = extractelement <vscale x 4 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_x = extractelement <vscale x 8 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_x = extractelement <vscale x 16 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_x = extractelement <vscale x 32 x i1> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_x = extractelement <2 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_x = extractelement <4 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_x = extractelement <8 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_x = extractelement <16 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_x = extractelement <32 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_x = extractelement <64 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_x = extractelement <128 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_x = extractelement <vscale x 2 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_x = extractelement <vscale x 4 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_x = extractelement <vscale x 8 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_x = extractelement <vscale x 16 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_x = extractelement <vscale x 32 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_x = extractelement <vscale x 64 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_x = extractelement <vscale x 128 x i8> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_x = extractelement <2 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_x = extractelement <4 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_x = extractelement <8 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_x = extractelement <16 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_x = extractelement <32 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_x = extractelement <64 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_x = extractelement <vscale x 2 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_x = extractelement <vscale x 4 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_x = extractelement <vscale x 8 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_x = extractelement <vscale x 16 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_x = extractelement <vscale x 32 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_x = extractelement <vscale x 64 x i16> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_x = extractelement <2 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_x = extractelement <4 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_x = extractelement <8 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_x = extractelement <16 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_x = extractelement <32 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_x = extractelement <vscale x 2 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_x = extractelement <vscale x 4 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_x = extractelement <vscale x 8 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_x = extractelement <vscale x 16 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_x = extractelement <vscale x 32 x i32> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i64_x = extractelement <2 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i64_x = extractelement <4 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i64_x = extractelement <8 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_x = extractelement <16 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i64_x = extractelement <vscale x 2 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i64_x = extractelement <vscale x 4 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i64_x = extractelement <vscale x 8 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_x = extractelement <vscale x 16 x i64> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'extractelement_int'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i1_0 = extractelement <2 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i1_0 = extractelement <4 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i1_0 = extractelement <8 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i1_0 = extractelement <16 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i1_0 = extractelement <32 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i1_0 = extractelement <vscale x 2 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i1_0 = extractelement <vscale x 4 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i1_0 = extractelement <vscale x 8 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i1_0 = extractelement <vscale x 16 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i1_0 = extractelement <vscale x 32 x i1> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = extractelement <2 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = extractelement <4 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = extractelement <8 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = extractelement <16 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = extractelement <32 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = extractelement <64 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = extractelement <128 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = extractelement <vscale x 2 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = extractelement <vscale x 4 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = extractelement <vscale x 8 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = extractelement <vscale x 16 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = extractelement <vscale x 32 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = extractelement <vscale x 64 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = extractelement <vscale x 128 x i8> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = extractelement <2 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = extractelement <4 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = extractelement <8 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = extractelement <16 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = extractelement <32 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = extractelement <64 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = extractelement <vscale x 2 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = extractelement <vscale x 4 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = extractelement <vscale x 8 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = extractelement <vscale x 16 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = extractelement <vscale x 32 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = extractelement <vscale x 64 x i16> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = extractelement <2 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = extractelement <4 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = extractelement <8 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = extractelement <16 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = extractelement <32 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = extractelement <vscale x 2 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = extractelement <vscale x 4 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = extractelement <vscale x 8 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = extractelement <vscale x 16 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = extractelement <vscale x 32 x i32> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64_0 = extractelement <2 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i64_0 = extractelement <4 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i64_0 = extractelement <8 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_0 = extractelement <16 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i64_0 = extractelement <vscale x 2 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i64_0 = extractelement <vscale x 4 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i64_0 = extractelement <vscale x 8 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_0 = extractelement <vscale x 16 x i64> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_1 = extractelement <2 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_1 = extractelement <4 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_1 = extractelement <8 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_1 = extractelement <16 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_1 = extractelement <32 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_1 = extractelement <vscale x 2 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_1 = extractelement <vscale x 4 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_1 = extractelement <vscale x 8 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_1 = extractelement <vscale x 16 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_1 = extractelement <vscale x 32 x i1> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = extractelement <2 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = extractelement <4 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = extractelement <8 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = extractelement <16 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = extractelement <32 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = extractelement <64 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_1 = extractelement <128 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = extractelement <vscale x 2 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = extractelement <vscale x 4 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = extractelement <vscale x 8 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = extractelement <vscale x 16 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = extractelement <vscale x 32 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = extractelement <vscale x 64 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_1 = extractelement <vscale x 128 x i8> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = extractelement <2 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = extractelement <4 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = extractelement <8 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = extractelement <16 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = extractelement <32 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_1 = extractelement <64 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = extractelement <vscale x 2 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = extractelement <vscale x 4 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = extractelement <vscale x 8 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = extractelement <vscale x 16 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = extractelement <vscale x 32 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_1 = extractelement <vscale x 64 x i16> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = extractelement <2 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = extractelement <4 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = extractelement <8 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = extractelement <16 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_1 = extractelement <32 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = extractelement <vscale x 2 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = extractelement <vscale x 4 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = extractelement <vscale x 8 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = extractelement <vscale x 16 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_1 = extractelement <vscale x 32 x i32> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_1 = extractelement <2 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_1 = extractelement <4 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_1 = extractelement <8 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_1 = extractelement <16 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_1 = extractelement <vscale x 2 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i64_1 = extractelement <vscale x 4 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i64_1 = extractelement <vscale x 8 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_1 = extractelement <vscale x 16 x i64> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i1_x = extractelement <2 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i1_x = extractelement <4 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i1_x = extractelement <8 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i1_x = extractelement <16 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v32i1_x = extractelement <32 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i1_x = extractelement <vscale x 2 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i1_x = extractelement <vscale x 4 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i1_x = extractelement <vscale x 8 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i1_x = extractelement <vscale x 16 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv32i1_x = extractelement <vscale x 32 x i1> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_x = extractelement <2 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_x = extractelement <4 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_x = extractelement <8 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_x = extractelement <16 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_x = extractelement <32 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_x = extractelement <64 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_x = extractelement <128 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_x = extractelement <vscale x 2 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_x = extractelement <vscale x 4 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_x = extractelement <vscale x 8 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_x = extractelement <vscale x 16 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_x = extractelement <vscale x 32 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_x = extractelement <vscale x 64 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_x = extractelement <vscale x 128 x i8> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_x = extractelement <2 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_x = extractelement <4 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_x = extractelement <8 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_x = extractelement <16 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_x = extractelement <32 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_x = extractelement <64 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_x = extractelement <vscale x 2 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_x = extractelement <vscale x 4 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_x = extractelement <vscale x 8 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_x = extractelement <vscale x 16 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_x = extractelement <vscale x 32 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_x = extractelement <vscale x 64 x i16> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_x = extractelement <2 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_x = extractelement <4 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_x = extractelement <8 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_x = extractelement <16 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_x = extractelement <32 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_x = extractelement <vscale x 2 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_x = extractelement <vscale x 4 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_x = extractelement <vscale x 8 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_x = extractelement <vscale x 16 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_x = extractelement <vscale x 32 x i32> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_x = extractelement <2 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_x = extractelement <4 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_x = extractelement <8 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_x = extractelement <16 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_x = extractelement <vscale x 2 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i64_x = extractelement <vscale x 4 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i64_x = extractelement <vscale x 8 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_x = extractelement <vscale x 16 x i64> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2i1_0 = extractelement <2 x i1> undef, i32 0
  %v4i1_0 = extractelement <4 x i1> undef, i32 0
  %v8i1_0 = extractelement <8 x i1> undef, i32 0
  %v16i1_0 = extractelement <16 x i1> undef, i32 0
  %v32i1_0 = extractelement <32 x i1> undef, i32 0

  %nxv2i1_0 = extractelement <vscale x 2 x i1> undef, i32 0
  %nxv4i1_0 = extractelement <vscale x 4 x i1> undef, i32 0
  %nxv8i1_0 = extractelement <vscale x 8 x i1> undef, i32 0
  %nxv16i1_0 = extractelement <vscale x 16 x i1> undef, i32 0
  %nxv32i1_0 = extractelement <vscale x 32 x i1> undef, i32 0

  %v2i8_0 = extractelement <2 x i8> undef, i32 0
  %v4i8_0 = extractelement <4 x i8> undef, i32 0
  %v8i8_0 = extractelement <8 x i8> undef, i32 0
  %v16i8_0 = extractelement <16 x i8> undef, i32 0
  %v32i8_0 = extractelement <32 x i8> undef, i32 0
  %v64i8_0 = extractelement <64 x i8> undef, i32 0
  %v128i8_0 = extractelement <128 x i8> undef, i32 0

  %nxv2i8_0 = extractelement <vscale x 2 x i8> undef, i32 0
  %nxv4i8_0 = extractelement <vscale x 4 x i8> undef, i32 0
  %nxv8i8_0 = extractelement <vscale x 8 x i8> undef, i32 0
  %nxv16i8_0 = extractelement <vscale x 16 x i8> undef, i32 0
  %nxv32i8_0 = extractelement <vscale x 32 x i8> undef, i32 0
  %nxv64i8_0 = extractelement <vscale x 64 x i8> undef, i32 0
  %nxv128i8_0 = extractelement <vscale x 128 x i8> undef, i32 0

  %v2i16_0 = extractelement <2 x i16> undef, i32 0
  %v4i16_0 = extractelement <4 x i16> undef, i32 0
  %v8i16_0 = extractelement <8 x i16> undef, i32 0
  %v16i16_0 = extractelement <16 x i16> undef, i32 0
  %v32i16_0 = extractelement <32 x i16> undef, i32 0
  %v64i16_0 = extractelement <64 x i16> undef, i32 0

  %nxv2i16_0 = extractelement <vscale x 2 x i16> undef, i32 0
  %nxv4i16_0 = extractelement <vscale x 4 x i16> undef, i32 0
  %nxv8i16_0 = extractelement <vscale x 8 x i16> undef, i32 0
  %nxv16i16_0 = extractelement <vscale x 16 x i16> undef, i32 0
  %nxv32i16_0 = extractelement <vscale x 32 x i16> undef, i32 0
  %nxv64i16_0 = extractelement <vscale x 64 x i16> undef, i32 0

  %v2i32_0 = extractelement <2 x i32> undef, i32 0
  %v4i32_0 = extractelement <4 x i32> undef, i32 0
  %v8i32_0 = extractelement <8 x i32> undef, i32 0
  %v16i32_0 = extractelement <16 x i32> undef, i32 0
  %v32i32_0 = extractelement <32 x i32> undef, i32 0

  %nxv2i32_0 = extractelement <vscale x 2 x i32> undef, i32 0
  %nxv4i32_0 = extractelement <vscale x 4 x i32> undef, i32 0
  %nxv8i32_0 = extractelement <vscale x 8 x i32> undef, i32 0
  %nxv16i32_0 = extractelement <vscale x 16 x i32> undef, i32 0
  %nxv32i32_0 = extractelement <vscale x 32 x i32> undef, i32 0

  %v2i64_0 = extractelement <2 x i64> undef, i32 0
  %v4i64_0 = extractelement <4 x i64> undef, i32 0
  %v8i64_0 = extractelement <8 x i64> undef, i32 0
  %v16i64_0 = extractelement <16 x i64> undef, i32 0

  %nxv2i64_0 = extractelement <vscale x 2 x i64> undef, i32 0
  %nxv4i64_0 = extractelement <vscale x 4 x i64> undef, i32 0
  %nxv8i64_0 = extractelement <vscale x 8 x i64> undef, i32 0
  %nxv16i64_0 = extractelement <vscale x 16 x i64> undef, i32 0

  %v2i1_1 = extractelement <2 x i1> undef, i32 1
  %v4i1_1 = extractelement <4 x i1> undef, i32 1
  %v8i1_1 = extractelement <8 x i1> undef, i32 1
  %v16i1_1 = extractelement <16 x i1> undef, i32 1
  %v32i1_1 = extractelement <32 x i1> undef, i32 1

  %nxv2i1_1 = extractelement <vscale x 2 x i1> undef, i32 1
  %nxv4i1_1 = extractelement <vscale x 4 x i1> undef, i32 1
  %nxv8i1_1 = extractelement <vscale x 8 x i1> undef, i32 1
  %nxv16i1_1 = extractelement <vscale x 16 x i1> undef, i32 1
  %nxv32i1_1 = extractelement <vscale x 32 x i1> undef, i32 1

  %v2i8_1 = extractelement <2 x i8> undef, i32 1
  %v4i8_1 = extractelement <4 x i8> undef, i32 1
  %v8i8_1 = extractelement <8 x i8> undef, i32 1
  %v16i8_1 = extractelement <16 x i8> undef, i32 1
  %v32i8_1 = extractelement <32 x i8> undef, i32 1
  %v64i8_1 = extractelement <64 x i8> undef, i32 1
  %v128i8_1 = extractelement <128 x i8> undef, i32 1

  %nxv2i8_1 = extractelement <vscale x 2 x i8> undef, i32 1
  %nxv4i8_1 = extractelement <vscale x 4 x i8> undef, i32 1
  %nxv8i8_1 = extractelement <vscale x 8 x i8> undef, i32 1
  %nxv16i8_1 = extractelement <vscale x 16 x i8> undef, i32 1
  %nxv32i8_1 = extractelement <vscale x 32 x i8> undef, i32 1
  %nxv64i8_1 = extractelement <vscale x 64 x i8> undef, i32 1
  %nxv128i8_1 = extractelement <vscale x 128 x i8> undef, i32 1

  %v2i16_1 = extractelement <2 x i16> undef, i32 1
  %v4i16_1 = extractelement <4 x i16> undef, i32 1
  %v8i16_1 = extractelement <8 x i16> undef, i32 1
  %v16i16_1 = extractelement <16 x i16> undef, i32 1
  %v32i16_1 = extractelement <32 x i16> undef, i32 1
  %v64i16_1 = extractelement <64 x i16> undef, i32 1

  %nxv2i16_1 = extractelement <vscale x 2 x i16> undef, i32 1
  %nxv4i16_1 = extractelement <vscale x 4 x i16> undef, i32 1
  %nxv8i16_1 = extractelement <vscale x 8 x i16> undef, i32 1
  %nxv16i16_1 = extractelement <vscale x 16 x i16> undef, i32 1
  %nxv32i16_1 = extractelement <vscale x 32 x i16> undef, i32 1
  %nxv64i16_1 = extractelement <vscale x 64 x i16> undef, i32 1

  %v2i32_1 = extractelement <2 x i32> undef, i32 1
  %v4i32_1 = extractelement <4 x i32> undef, i32 1
  %v8i32_1 = extractelement <8 x i32> undef, i32 1
  %v16i32_1 = extractelement <16 x i32> undef, i32 1
  %v32i32_1 = extractelement <32 x i32> undef, i32 1

  %nxv2i32_1 = extractelement <vscale x 2 x i32> undef, i32 1
  %nxv4i32_1 = extractelement <vscale x 4 x i32> undef, i32 1
  %nxv8i32_1 = extractelement <vscale x 8 x i32> undef, i32 1
  %nxv16i32_1 = extractelement <vscale x 16 x i32> undef, i32 1
  %nxv32i32_1 = extractelement <vscale x 32 x i32> undef, i32 1

  %v2i64_1 = extractelement <2 x i64> undef, i32 1
  %v4i64_1 = extractelement <4 x i64> undef, i32 1
  %v8i64_1 = extractelement <8 x i64> undef, i32 1
  %v16i64_1 = extractelement <16 x i64> undef, i32 1

  %nxv2i64_1 = extractelement <vscale x 2 x i64> undef, i32 1
  %nxv4i64_1 = extractelement <vscale x 4 x i64> undef, i32 1
  %nxv8i64_1 = extractelement <vscale x 8 x i64> undef, i32 1
  %nxv16i64_1 = extractelement <vscale x 16 x i64> undef, i32 1

  %v2i1_x = extractelement <2 x i1> undef, i32 %x
  %v4i1_x = extractelement <4 x i1> undef, i32 %x
  %v8i1_x = extractelement <8 x i1> undef, i32 %x
  %v16i1_x = extractelement <16 x i1> undef, i32 %x
  %v32i1_x = extractelement <32 x i1> undef, i32 %x

  %nxv2i1_x = extractelement <vscale x 2 x i1> undef, i32 %x
  %nxv4i1_x = extractelement <vscale x 4 x i1> undef, i32 %x
  %nxv8i1_x = extractelement <vscale x 8 x i1> undef, i32 %x
  %nxv16i1_x = extractelement <vscale x 16 x i1> undef, i32 %x
  %nxv32i1_x = extractelement <vscale x 32 x i1> undef, i32 %x

  %v2i8_x = extractelement <2 x i8> undef, i32 %x
  %v4i8_x = extractelement <4 x i8> undef, i32 %x
  %v8i8_x = extractelement <8 x i8> undef, i32 %x
  %v16i8_x = extractelement <16 x i8> undef, i32 %x
  %v32i8_x = extractelement <32 x i8> undef, i32 %x
  %v64i8_x = extractelement <64 x i8> undef, i32 %x
  %v128i8_x = extractelement <128 x i8> undef, i32 %x

  %nxv2i8_x = extractelement <vscale x 2 x i8> undef, i32 %x
  %nxv4i8_x = extractelement <vscale x 4 x i8> undef, i32 %x
  %nxv8i8_x = extractelement <vscale x 8 x i8> undef, i32 %x
  %nxv16i8_x = extractelement <vscale x 16 x i8> undef, i32 %x
  %nxv32i8_x = extractelement <vscale x 32 x i8> undef, i32 %x
  %nxv64i8_x = extractelement <vscale x 64 x i8> undef, i32 %x
  %nxv128i8_x = extractelement <vscale x 128 x i8> undef, i32 %x

  %v2i16_x = extractelement <2 x i16> undef, i32 %x
  %v4i16_x = extractelement <4 x i16> undef, i32 %x
  %v8i16_x = extractelement <8 x i16> undef, i32 %x
  %v16i16_x = extractelement <16 x i16> undef, i32 %x
  %v32i16_x = extractelement <32 x i16> undef, i32 %x
  %v64i16_x = extractelement <64 x i16> undef, i32 %x

  %nxv2i16_x = extractelement <vscale x 2 x i16> undef, i32 %x
  %nxv4i16_x = extractelement <vscale x 4 x i16> undef, i32 %x
  %nxv8i16_x = extractelement <vscale x 8 x i16> undef, i32 %x
  %nxv16i16_x = extractelement <vscale x 16 x i16> undef, i32 %x
  %nxv32i16_x = extractelement <vscale x 32 x i16> undef, i32 %x
  %nxv64i16_x = extractelement <vscale x 64 x i16> undef, i32 %x

  %v2i32_x = extractelement <2 x i32> undef, i32 %x
  %v4i32_x = extractelement <4 x i32> undef, i32 %x
  %v8i32_x = extractelement <8 x i32> undef, i32 %x
  %v16i32_x = extractelement <16 x i32> undef, i32 %x
  %v32i32_x = extractelement <32 x i32> undef, i32 %x

  %nxv2i32_x = extractelement <vscale x 2 x i32> undef, i32 %x
  %nxv4i32_x = extractelement <vscale x 4 x i32> undef, i32 %x
  %nxv8i32_x = extractelement <vscale x 8 x i32> undef, i32 %x
  %nxv16i32_x = extractelement <vscale x 16 x i32> undef, i32 %x
  %nxv32i32_x = extractelement <vscale x 32 x i32> undef, i32 %x

  %v2i64_x = extractelement <2 x i64> undef, i32 %x
  %v4i64_x = extractelement <4 x i64> undef, i32 %x
  %v8i64_x = extractelement <8 x i64> undef, i32 %x
  %v16i64_x = extractelement <16 x i64> undef, i32 %x

  %nxv2i64_x = extractelement <vscale x 2 x i64> undef, i32 %x
  %nxv4i64_x = extractelement <vscale x 4 x i64> undef, i32 %x
  %nxv8i64_x = extractelement <vscale x 8 x i64> undef, i32 %x
  %nxv16i64_x = extractelement <vscale x 16 x i64> undef, i32 %x

  ret void
}

define void @extractelement_fp(i32 %x) {
; RV32V-LABEL: 'extractelement_fp'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_0 = extractelement <2 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_0 = extractelement <4 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_0 = extractelement <8 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_0 = extractelement <16 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f16_0 = extractelement <32 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64f16_0 = extractelement <64 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_0 = extractelement <vscale x 2 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_0 = extractelement <vscale x 4 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_0 = extractelement <vscale x 8 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f16_0 = extractelement <vscale x 16 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f16_0 = extractelement <vscale x 32 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_0 = extractelement <vscale x 64 x half> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32_0 = extractelement <2 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32_0 = extractelement <4 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32_0 = extractelement <8 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32_0 = extractelement <16 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f32_0 = extractelement <32 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32_0 = extractelement <vscale x 2 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32_0 = extractelement <vscale x 4 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32_0 = extractelement <vscale x 8 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32_0 = extractelement <vscale x 16 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_0 = extractelement <vscale x 32 x float> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64_0 = extractelement <2 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64_0 = extractelement <4 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64_0 = extractelement <8 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f64_0 = extractelement <16 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64_0 = extractelement <vscale x 2 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64_0 = extractelement <vscale x 4 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64_0 = extractelement <vscale x 8 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_0 = extractelement <vscale x 16 x double> undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_1 = extractelement <2 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_1 = extractelement <4 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_1 = extractelement <8 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_1 = extractelement <16 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_1 = extractelement <32 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_1 = extractelement <64 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_1 = extractelement <vscale x 2 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_1 = extractelement <vscale x 4 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_1 = extractelement <vscale x 8 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_1 = extractelement <vscale x 16 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_1 = extractelement <vscale x 32 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_1 = extractelement <vscale x 64 x half> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_1 = extractelement <2 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_1 = extractelement <4 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_1 = extractelement <8 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_1 = extractelement <16 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_1 = extractelement <32 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_1 = extractelement <vscale x 2 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_1 = extractelement <vscale x 4 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_1 = extractelement <vscale x 8 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_1 = extractelement <vscale x 16 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_1 = extractelement <vscale x 32 x float> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_1 = extractelement <2 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_1 = extractelement <4 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_1 = extractelement <8 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_1 = extractelement <16 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_1 = extractelement <vscale x 2 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_1 = extractelement <vscale x 4 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_1 = extractelement <vscale x 8 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_1 = extractelement <vscale x 16 x double> undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_x = extractelement <2 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_x = extractelement <4 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_x = extractelement <8 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_x = extractelement <16 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_x = extractelement <32 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_x = extractelement <64 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_x = extractelement <vscale x 2 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_x = extractelement <vscale x 4 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_x = extractelement <vscale x 8 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_x = extractelement <vscale x 16 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_x = extractelement <vscale x 32 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_x = extractelement <vscale x 64 x half> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_x = extractelement <2 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_x = extractelement <4 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_x = extractelement <8 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_x = extractelement <16 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_x = extractelement <32 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_x = extractelement <vscale x 2 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_x = extractelement <vscale x 4 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_x = extractelement <vscale x 8 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_x = extractelement <vscale x 16 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_x = extractelement <vscale x 32 x float> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_x = extractelement <2 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_x = extractelement <4 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_x = extractelement <8 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_x = extractelement <16 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_x = extractelement <vscale x 2 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_x = extractelement <vscale x 4 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_x = extractelement <vscale x 8 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_x = extractelement <vscale x 16 x double> undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64V-LABEL: 'extractelement_fp'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_0 = extractelement <2 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_0 = extractelement <4 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_0 = extractelement <8 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_0 = extractelement <16 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f16_0 = extractelement <32 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64f16_0 = extractelement <64 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_0 = extractelement <vscale x 2 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_0 = extractelement <vscale x 4 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_0 = extractelement <vscale x 8 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f16_0 = extractelement <vscale x 16 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f16_0 = extractelement <vscale x 32 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_0 = extractelement <vscale x 64 x half> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32_0 = extractelement <2 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32_0 = extractelement <4 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32_0 = extractelement <8 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32_0 = extractelement <16 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f32_0 = extractelement <32 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32_0 = extractelement <vscale x 2 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32_0 = extractelement <vscale x 4 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32_0 = extractelement <vscale x 8 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32_0 = extractelement <vscale x 16 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_0 = extractelement <vscale x 32 x float> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64_0 = extractelement <2 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64_0 = extractelement <4 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64_0 = extractelement <8 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f64_0 = extractelement <16 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64_0 = extractelement <vscale x 2 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64_0 = extractelement <vscale x 4 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64_0 = extractelement <vscale x 8 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_0 = extractelement <vscale x 16 x double> undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_1 = extractelement <2 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_1 = extractelement <4 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_1 = extractelement <8 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_1 = extractelement <16 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_1 = extractelement <32 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_1 = extractelement <64 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_1 = extractelement <vscale x 2 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_1 = extractelement <vscale x 4 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_1 = extractelement <vscale x 8 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_1 = extractelement <vscale x 16 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_1 = extractelement <vscale x 32 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_1 = extractelement <vscale x 64 x half> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_1 = extractelement <2 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_1 = extractelement <4 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_1 = extractelement <8 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_1 = extractelement <16 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_1 = extractelement <32 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_1 = extractelement <vscale x 2 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_1 = extractelement <vscale x 4 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_1 = extractelement <vscale x 8 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_1 = extractelement <vscale x 16 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_1 = extractelement <vscale x 32 x float> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_1 = extractelement <2 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_1 = extractelement <4 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_1 = extractelement <8 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_1 = extractelement <16 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_1 = extractelement <vscale x 2 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_1 = extractelement <vscale x 4 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_1 = extractelement <vscale x 8 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_1 = extractelement <vscale x 16 x double> undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_x = extractelement <2 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_x = extractelement <4 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_x = extractelement <8 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_x = extractelement <16 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_x = extractelement <32 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_x = extractelement <64 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_x = extractelement <vscale x 2 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_x = extractelement <vscale x 4 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_x = extractelement <vscale x 8 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_x = extractelement <vscale x 16 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_x = extractelement <vscale x 32 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_x = extractelement <vscale x 64 x half> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_x = extractelement <2 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_x = extractelement <4 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_x = extractelement <8 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_x = extractelement <16 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_x = extractelement <32 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_x = extractelement <vscale x 2 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_x = extractelement <vscale x 4 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_x = extractelement <vscale x 8 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_x = extractelement <vscale x 16 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_x = extractelement <vscale x 32 x float> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_x = extractelement <2 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_x = extractelement <4 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_x = extractelement <8 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_x = extractelement <16 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_x = extractelement <vscale x 2 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_x = extractelement <vscale x 4 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_x = extractelement <vscale x 8 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_x = extractelement <vscale x 16 x double> undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'extractelement_fp'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_0 = extractelement <2 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_0 = extractelement <4 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_0 = extractelement <8 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_0 = extractelement <16 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_0 = extractelement <32 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_0 = extractelement <64 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_0 = extractelement <vscale x 2 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_0 = extractelement <vscale x 4 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_0 = extractelement <vscale x 8 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_0 = extractelement <vscale x 16 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_0 = extractelement <vscale x 32 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_0 = extractelement <vscale x 64 x half> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_0 = extractelement <2 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_0 = extractelement <4 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_0 = extractelement <8 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_0 = extractelement <16 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_0 = extractelement <32 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_0 = extractelement <vscale x 2 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_0 = extractelement <vscale x 4 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_0 = extractelement <vscale x 8 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_0 = extractelement <vscale x 16 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_0 = extractelement <vscale x 32 x float> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_0 = extractelement <2 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_0 = extractelement <4 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_0 = extractelement <8 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_0 = extractelement <16 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_0 = extractelement <vscale x 2 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_0 = extractelement <vscale x 4 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_0 = extractelement <vscale x 8 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_0 = extractelement <vscale x 16 x double> undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_1 = extractelement <2 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_1 = extractelement <4 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_1 = extractelement <8 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_1 = extractelement <16 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_1 = extractelement <32 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_1 = extractelement <64 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_1 = extractelement <vscale x 2 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_1 = extractelement <vscale x 4 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_1 = extractelement <vscale x 8 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_1 = extractelement <vscale x 16 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_1 = extractelement <vscale x 32 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_1 = extractelement <vscale x 64 x half> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_1 = extractelement <2 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_1 = extractelement <4 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_1 = extractelement <8 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_1 = extractelement <16 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_1 = extractelement <32 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_1 = extractelement <vscale x 2 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_1 = extractelement <vscale x 4 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_1 = extractelement <vscale x 8 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_1 = extractelement <vscale x 16 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_1 = extractelement <vscale x 32 x float> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_1 = extractelement <2 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_1 = extractelement <4 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_1 = extractelement <8 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_1 = extractelement <16 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_1 = extractelement <vscale x 2 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_1 = extractelement <vscale x 4 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_1 = extractelement <vscale x 8 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_1 = extractelement <vscale x 16 x double> undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_x = extractelement <2 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_x = extractelement <4 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_x = extractelement <8 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_x = extractelement <16 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_x = extractelement <32 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_x = extractelement <64 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_x = extractelement <vscale x 2 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_x = extractelement <vscale x 4 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_x = extractelement <vscale x 8 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_x = extractelement <vscale x 16 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_x = extractelement <vscale x 32 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_x = extractelement <vscale x 64 x half> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_x = extractelement <2 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_x = extractelement <4 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_x = extractelement <8 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_x = extractelement <16 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_x = extractelement <32 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_x = extractelement <vscale x 2 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_x = extractelement <vscale x 4 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_x = extractelement <vscale x 8 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_x = extractelement <vscale x 16 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_x = extractelement <vscale x 32 x float> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_x = extractelement <2 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_x = extractelement <4 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_x = extractelement <8 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_x = extractelement <16 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_x = extractelement <vscale x 2 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_x = extractelement <vscale x 4 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_x = extractelement <vscale x 8 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_x = extractelement <vscale x 16 x double> undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'extractelement_fp'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_0 = extractelement <2 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_0 = extractelement <4 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_0 = extractelement <8 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_0 = extractelement <16 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_0 = extractelement <32 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_0 = extractelement <64 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_0 = extractelement <vscale x 2 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_0 = extractelement <vscale x 4 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_0 = extractelement <vscale x 8 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_0 = extractelement <vscale x 16 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_0 = extractelement <vscale x 32 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_0 = extractelement <vscale x 64 x half> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_0 = extractelement <2 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_0 = extractelement <4 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_0 = extractelement <8 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_0 = extractelement <16 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_0 = extractelement <32 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_0 = extractelement <vscale x 2 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_0 = extractelement <vscale x 4 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_0 = extractelement <vscale x 8 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_0 = extractelement <vscale x 16 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_0 = extractelement <vscale x 32 x float> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_0 = extractelement <2 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_0 = extractelement <4 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_0 = extractelement <8 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_0 = extractelement <16 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_0 = extractelement <vscale x 2 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_0 = extractelement <vscale x 4 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_0 = extractelement <vscale x 8 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_0 = extractelement <vscale x 16 x double> undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_1 = extractelement <2 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_1 = extractelement <4 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_1 = extractelement <8 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_1 = extractelement <16 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_1 = extractelement <32 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_1 = extractelement <64 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_1 = extractelement <vscale x 2 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_1 = extractelement <vscale x 4 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_1 = extractelement <vscale x 8 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_1 = extractelement <vscale x 16 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_1 = extractelement <vscale x 32 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_1 = extractelement <vscale x 64 x half> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_1 = extractelement <2 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_1 = extractelement <4 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_1 = extractelement <8 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_1 = extractelement <16 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_1 = extractelement <32 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_1 = extractelement <vscale x 2 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_1 = extractelement <vscale x 4 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_1 = extractelement <vscale x 8 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_1 = extractelement <vscale x 16 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_1 = extractelement <vscale x 32 x float> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_1 = extractelement <2 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_1 = extractelement <4 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_1 = extractelement <8 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_1 = extractelement <16 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_1 = extractelement <vscale x 2 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_1 = extractelement <vscale x 4 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_1 = extractelement <vscale x 8 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_1 = extractelement <vscale x 16 x double> undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_x = extractelement <2 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_x = extractelement <4 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_x = extractelement <8 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_x = extractelement <16 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_x = extractelement <32 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_x = extractelement <64 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_x = extractelement <vscale x 2 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_x = extractelement <vscale x 4 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_x = extractelement <vscale x 8 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_x = extractelement <vscale x 16 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_x = extractelement <vscale x 32 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_x = extractelement <vscale x 64 x half> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_x = extractelement <2 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_x = extractelement <4 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_x = extractelement <8 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_x = extractelement <16 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_x = extractelement <32 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_x = extractelement <vscale x 2 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_x = extractelement <vscale x 4 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_x = extractelement <vscale x 8 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_x = extractelement <vscale x 16 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_x = extractelement <vscale x 32 x float> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_x = extractelement <2 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_x = extractelement <4 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_x = extractelement <8 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_x = extractelement <16 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_x = extractelement <vscale x 2 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_x = extractelement <vscale x 4 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_x = extractelement <vscale x 8 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_x = extractelement <vscale x 16 x double> undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  %v2f16_0 = extractelement <2 x half> undef, i32 0
  %v4f16_0 = extractelement <4 x half> undef, i32 0
  %v8f16_0 = extractelement <8 x half> undef, i32 0
  %v16f16_0 = extractelement <16 x half> undef, i32 0
  %v32f16_0 = extractelement <32 x half> undef, i32 0
  %v64f16_0 = extractelement <64 x half> undef, i32 0

  %nxv2f16_0 = extractelement <vscale x 2 x half> undef, i32 0
  %nxv4f16_0 = extractelement <vscale x 4 x half> undef, i32 0
  %nxv8f16_0 = extractelement <vscale x 8 x half> undef, i32 0
  %nxv16f16_0 = extractelement <vscale x 16 x half> undef, i32 0
  %nxv32f16_0 = extractelement <vscale x 32 x half> undef, i32 0
  %nxv64f16_0 = extractelement <vscale x 64 x half> undef, i32 0

  %v2f32_0 = extractelement <2 x float> undef, i32 0
  %v4f32_0 = extractelement <4 x float> undef, i32 0
  %v8f32_0 = extractelement <8 x float> undef, i32 0
  %v16f32_0 = extractelement <16 x float> undef, i32 0
  %v32f32_0 = extractelement <32 x float> undef, i32 0

  %nxv2f32_0 = extractelement <vscale x 2 x float> undef, i32 0
  %nxv4f32_0 = extractelement <vscale x 4 x float> undef, i32 0
  %nxv8f32_0 = extractelement <vscale x 8 x float> undef, i32 0
  %nxv16f32_0 = extractelement <vscale x 16 x float> undef, i32 0
  %nxv32f32_0 = extractelement <vscale x 32 x float> undef, i32 0

  %v2f64_0 = extractelement <2 x double> undef, i32 0
  %v4f64_0 = extractelement <4 x double> undef, i32 0
  %v8f64_0 = extractelement <8 x double> undef, i32 0
  %v16f64_0 = extractelement <16 x double> undef, i32 0

  %nxv2f64_0 = extractelement <vscale x 2 x double> undef, i32 0
  %nxv4f64_0 = extractelement <vscale x 4 x double> undef, i32 0
  %nxv8f64_0 = extractelement <vscale x 8 x double> undef, i32 0
  %nxv16f64_0 = extractelement <vscale x 16 x double> undef, i32 0

  %v2f16_1 = extractelement <2 x half> undef, i32 1
  %v4f16_1 = extractelement <4 x half> undef, i32 1
  %v8f16_1 = extractelement <8 x half> undef, i32 1
  %v16f16_1 = extractelement <16 x half> undef, i32 1
  %v32f16_1 = extractelement <32 x half> undef, i32 1
  %v64f16_1 = extractelement <64 x half> undef, i32 1

  %nxv2f16_1 = extractelement <vscale x 2 x half> undef, i32 1
  %nxv4f16_1 = extractelement <vscale x 4 x half> undef, i32 1
  %nxv8f16_1 = extractelement <vscale x 8 x half> undef, i32 1
  %nxv16f16_1 = extractelement <vscale x 16 x half> undef, i32 1
  %nxv32f16_1 = extractelement <vscale x 32 x half> undef, i32 1
  %nxv64f16_1 = extractelement <vscale x 64 x half> undef, i32 1

  %v2f32_1 = extractelement <2 x float> undef, i32 1
  %v4f32_1 = extractelement <4 x float> undef, i32 1
  %v8f32_1 = extractelement <8 x float> undef, i32 1
  %v16f32_1 = extractelement <16 x float> undef, i32 1
  %v32f32_1 = extractelement <32 x float> undef, i32 1

  %nxv2f32_1 = extractelement <vscale x 2 x float> undef, i32 1
  %nxv4f32_1 = extractelement <vscale x 4 x float> undef, i32 1
  %nxv8f32_1 = extractelement <vscale x 8 x float> undef, i32 1
  %nxv16f32_1 = extractelement <vscale x 16 x float> undef, i32 1
  %nxv32f32_1 = extractelement <vscale x 32 x float> undef, i32 1

  %v2f64_1 = extractelement <2 x double> undef, i32 1
  %v4f64_1 = extractelement <4 x double> undef, i32 1
  %v8f64_1 = extractelement <8 x double> undef, i32 1
  %v16f64_1 = extractelement <16 x double> undef, i32 1

  %nxv2f64_1 = extractelement <vscale x 2 x double> undef, i32 1
  %nxv4f64_1 = extractelement <vscale x 4 x double> undef, i32 1
  %nxv8f64_1 = extractelement <vscale x 8 x double> undef, i32 1
  %nxv16f64_1 = extractelement <vscale x 16 x double> undef, i32 1

  %v2f16_x = extractelement <2 x half> undef, i32 %x
  %v4f16_x = extractelement <4 x half> undef, i32 %x
  %v8f16_x = extractelement <8 x half> undef, i32 %x
  %v16f16_x = extractelement <16 x half> undef, i32 %x
  %v32f16_x = extractelement <32 x half> undef, i32 %x
  %v64f16_x = extractelement <64 x half> undef, i32 %x

  %nxv2f16_x = extractelement <vscale x 2 x half> undef, i32 %x
  %nxv4f16_x = extractelement <vscale x 4 x half> undef, i32 %x
  %nxv8f16_x = extractelement <vscale x 8 x half> undef, i32 %x
  %nxv16f16_x = extractelement <vscale x 16 x half> undef, i32 %x
  %nxv32f16_x = extractelement <vscale x 32 x half> undef, i32 %x
  %nxv64f16_x = extractelement <vscale x 64 x half> undef, i32 %x

  %v2f32_x = extractelement <2 x float> undef, i32 %x
  %v4f32_x = extractelement <4 x float> undef, i32 %x
  %v8f32_x = extractelement <8 x float> undef, i32 %x
  %v16f32_x = extractelement <16 x float> undef, i32 %x
  %v32f32_x = extractelement <32 x float> undef, i32 %x

  %nxv2f32_x = extractelement <vscale x 2 x float> undef, i32 %x
  %nxv4f32_x = extractelement <vscale x 4 x float> undef, i32 %x
  %nxv8f32_x = extractelement <vscale x 8 x float> undef, i32 %x
  %nxv16f32_x = extractelement <vscale x 16 x float> undef, i32 %x
  %nxv32f32_x = extractelement <vscale x 32 x float> undef, i32 %x

  %v2f64_x = extractelement <2 x double> undef, i32 %x
  %v4f64_x = extractelement <4 x double> undef, i32 %x
  %v8f64_x = extractelement <8 x double> undef, i32 %x
  %v16f64_x = extractelement <16 x double> undef, i32 %x

  %nxv2f64_x = extractelement <vscale x 2 x double> undef, i32 %x
  %nxv4f64_x = extractelement <vscale x 4 x double> undef, i32 %x
  %nxv8f64_x = extractelement <vscale x 8 x double> undef, i32 %x
  %nxv16f64_x = extractelement <vscale x 16 x double> undef, i32 %x

  ret void
}
