import React from 'react';
import PropTypes from 'prop-types';

const UilCloudRedo = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M15,12.5a1,1,0,0,0-.91.6,4,4,0,1,0,.55,6.4A1,1,0,1,0,13.32,18a2,2,0,0,1-1.32.5,2,2,0,1,1,1-3.75h-.22a1,1,0,0,0,0,2H15a1,1,0,0,0,1-1V13.5A1,1,0,0,0,15,12.5Zm3.42-4.78A7,7,0,0,0,5.06,9.61a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,13.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12.5,5,5,0,0,0,18.42,7.72Z'
  }));
};

UilCloudRedo.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilCloudRedo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilCloudRedo;