"""Generated client library for categorymanager version v1alpha2."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.categorymanager.v1alpha2 import categorymanager_v1alpha2_messages as messages


class CategorymanagerV1alpha2(base_api.BaseApiClient):
  """Generated client library for service categorymanager version v1alpha2."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://categorymanager.googleapis.com/'

  _PACKAGE = u'categorymanager'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/xapi.zoo']
  _VERSION = u'v1alpha2'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'CategorymanagerV1alpha2'
  _URL_VERSION = u'v1alpha2'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new categorymanager handle."""
    url = url or self.BASE_URL
    super(CategorymanagerV1alpha2, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.assets_annotationTags = self.AssetsAnnotationTagsService(self)
    self.assets = self.AssetsService(self)
    self.operations = self.OperationsService(self)
    self.organizations = self.OrganizationsService(self)
    self.projects_taxonomies_annotations = self.ProjectsTaxonomiesAnnotationsService(self)
    self.projects_taxonomies = self.ProjectsTaxonomiesService(self)
    self.projects = self.ProjectsService(self)
    self.taxonomies = self.TaxonomiesService(self)
    self.taxonomyStores_taxonomies_annotations = self.TaxonomyStoresTaxonomiesAnnotationsService(self)
    self.taxonomyStores_taxonomies = self.TaxonomyStoresTaxonomiesService(self)
    self.taxonomyStores = self.TaxonomyStoresService(self)

  class AssetsAnnotationTagsService(base_api.BaseApiService):
    """Service class for the assets_annotationTags resource."""

    _NAME = u'assets_annotationTags'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.AssetsAnnotationTagsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists all annotation tags that are applied on an asset.

      Args:
        request: (CategorymanagerAssetsAnnotationTagsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationTagsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/assets/{assetsId}/annotationTags',
        http_method=u'GET',
        method_id=u'categorymanager.assets.annotationTags.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'pageSize', u'pageToken', u'subAsset'],
        relative_path=u'v1alpha2/{+name}/annotationTags',
        request_field='',
        request_type_name=u'CategorymanagerAssetsAnnotationTagsListRequest',
        response_type_name=u'ListAnnotationTagsResponse',
        supports_download=False,
    )

  class AssetsService(base_api.BaseApiService):
    """Service class for the assets resource."""

    _NAME = u'assets'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.AssetsService, self).__init__(client)
      self._upload_configs = {
          }

    def ApplyAnnotationTag(self, request, global_params=None):
      r"""Applies an annotation tag on an asset.

      Args:
        request: (CategorymanagerAssetsApplyAnnotationTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationTag) The response message.
      """
      config = self.GetMethodConfig('ApplyAnnotationTag')
      return self._RunMethod(
          config, request, global_params=global_params)

    ApplyAnnotationTag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/assets/{assetsId}:applyAnnotationTag',
        http_method=u'POST',
        method_id=u'categorymanager.assets.applyAnnotationTag',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}:applyAnnotationTag',
        request_field=u'applyAnnotationTagRequest',
        request_type_name=u'CategorymanagerAssetsApplyAnnotationTagRequest',
        response_type_name=u'AnnotationTag',
        supports_download=False,
    )

    def DeleteAnnotationTag(self, request, global_params=None):
      r"""Deletes an annotation tag from an asset.

      Args:
        request: (CategorymanagerAssetsDeleteAnnotationTagRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('DeleteAnnotationTag')
      return self._RunMethod(
          config, request, global_params=global_params)

    DeleteAnnotationTag.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/assets/{assetsId}/annotationTag',
        http_method=u'DELETE',
        method_id=u'categorymanager.assets.deleteAnnotationTag',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'annotation', u'subAsset'],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerAssetsDeleteAnnotationTagRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Search all assets with given predicates.

      Args:
        request: (CategorymanagerAssetsSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchAssetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'categorymanager.assets.search',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'query_annotatableOnly', u'query_annotations', u'query_createAgeFilter_maxAge', u'query_createAgeFilter_minAge', u'query_filter', u'query_includeAnnotatedByGroup', u'query_updateAgeFilter_maxAge', u'query_updateAgeFilter_minAge'],
        relative_path=u'v1alpha2/assets:search',
        request_field='',
        request_type_name=u'CategorymanagerAssetsSearchRequest',
        response_type_name=u'SearchAssetsResponse',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.

      Args:
        request: (CategorymanagerOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'categorymanager.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class OrganizationsService(base_api.BaseApiService):
    """Service class for the organizations resource."""

    _NAME = u'organizations'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.OrganizationsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetTaxonomyStore(self, request, global_params=None):
      r"""Get the organization level taxonomy store for an organization.

      Args:
        request: (CategorymanagerOrganizationsGetTaxonomyStoreRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TaxonomyStore) The response message.
      """
      config = self.GetMethodConfig('GetTaxonomyStore')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetTaxonomyStore.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/organizations/{organizationsId}/taxonomyStore',
        http_method=u'GET',
        method_id=u'categorymanager.organizations.getTaxonomyStore',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/taxonomyStore',
        request_field='',
        request_type_name=u'CategorymanagerOrganizationsGetTaxonomyStoreRequest',
        response_type_name=u'TaxonomyStore',
        supports_download=False,
    )

  class ProjectsTaxonomiesAnnotationsService(base_api.BaseApiService):
    """Service class for the projects_taxonomies_annotations resource."""

    _NAME = u'projects_taxonomies_annotations'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.ProjectsTaxonomiesAnnotationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an annotation in a taxonomy.

      Args:
        request: (CategorymanagerProjectsTaxonomiesAnnotationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}/annotations',
        http_method=u'POST',
        method_id=u'categorymanager.projects.taxonomies.annotations.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/annotations',
        request_field=u'annotation',
        request_type_name=u'CategorymanagerProjectsTaxonomiesAnnotationsCreateRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an annotation. Also deletes all member annotations if the given.
annotation is a group annotation.

      Args:
        request: (CategorymanagerProjectsTaxonomiesAnnotationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}/annotations/{annotationsId}',
        http_method=u'DELETE',
        method_id=u'categorymanager.projects.taxonomies.annotations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerProjectsTaxonomiesAnnotationsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets definition of an annotation.

      Args:
        request: (CategorymanagerProjectsTaxonomiesAnnotationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}/annotations/{annotationsId}',
        http_method=u'GET',
        method_id=u'categorymanager.projects.taxonomies.annotations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerProjectsTaxonomiesAnnotationsGetRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all annotations in a taxonomy.

      Args:
        request: (CategorymanagerProjectsTaxonomiesAnnotationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}/annotations',
        http_method=u'GET',
        method_id=u'categorymanager.projects.taxonomies.annotations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/annotations',
        request_field='',
        request_type_name=u'CategorymanagerProjectsTaxonomiesAnnotationsListRequest',
        response_type_name=u'ListAnnotationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an annotation. Currently only support updating descriptions.

      Args:
        request: (CategorymanagerProjectsTaxonomiesAnnotationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}/annotations/{annotationsId}',
        http_method=u'PATCH',
        method_id=u'categorymanager.projects.taxonomies.annotations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'annotation',
        request_type_name=u'CategorymanagerProjectsTaxonomiesAnnotationsPatchRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

  class ProjectsTaxonomiesService(base_api.BaseApiService):
    """Service class for the projects_taxonomies resource."""

    _NAME = u'projects_taxonomies'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.ProjectsTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Copy(self, request, global_params=None):
      r"""Copy an annotation to a given taxonomy. Copy will fail if there is an.
annotation with the same in the taxonomy.

      Args:
        request: (CategorymanagerProjectsTaxonomiesCopyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Copy')
      return self._RunMethod(
          config, request, global_params=global_params)

    Copy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}:copy',
        http_method=u'POST',
        method_id=u'categorymanager.projects.taxonomies.copy',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}:copy',
        request_field=u'copyAnnotationRequest',
        request_type_name=u'CategorymanagerProjectsTaxonomiesCopyRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new taxonomy in a given taxonomy store.

      Args:
        request: (CategorymanagerProjectsTaxonomiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies',
        http_method=u'POST',
        method_id=u'categorymanager.projects.taxonomies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/taxonomies',
        request_field=u'taxonomy',
        request_type_name=u'CategorymanagerProjectsTaxonomiesCreateRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a taxonomy from a taxonomy store. This operation will also delete.
all annotations in this taxonomy.

      Args:
        request: (CategorymanagerProjectsTaxonomiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}',
        http_method=u'DELETE',
        method_id=u'categorymanager.projects.taxonomies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerProjectsTaxonomiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the taxonomy referred by name. Size of a taxonomy is at most 100KB.

      Args:
        request: (CategorymanagerProjectsTaxonomiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}',
        http_method=u'GET',
        method_id=u'categorymanager.projects.taxonomies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerProjectsTaxonomiesGetRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""GetIamPolicy method for the projects_taxonomies service.

      Args:
        request: (CategorymanagerProjectsTaxonomiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'categorymanager.projects.taxonomies.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'CategorymanagerProjectsTaxonomiesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all taxonomies in a taxonomy store or a project.

      Args:
        request: (CategorymanagerProjectsTaxonomiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies',
        http_method=u'GET',
        method_id=u'categorymanager.projects.taxonomies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/taxonomies',
        request_field='',
        request_type_name=u'CategorymanagerProjectsTaxonomiesListRequest',
        response_type_name=u'ListTaxonomiesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a taxonomy. Currently only support updating descriptions.

      Args:
        request: (CategorymanagerProjectsTaxonomiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}',
        http_method=u'PATCH',
        method_id=u'categorymanager.projects.taxonomies.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'taxonomy',
        request_type_name=u'CategorymanagerProjectsTaxonomiesPatchRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""SetIamPolicy method for the projects_taxonomies service.

      Args:
        request: (CategorymanagerProjectsTaxonomiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'categorymanager.projects.taxonomies.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'CategorymanagerProjectsTaxonomiesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Return permissions that the caller has on the given taxonomy resource.

      Args:
        request: (CategorymanagerProjectsTaxonomiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}/taxonomies/{taxonomiesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'categorymanager.projects.taxonomies.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'CategorymanagerProjectsTaxonomiesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

    def Copy(self, request, global_params=None):
      r"""Copy a taxonomy to a given taxonomy store. Copy will fail if there is a.
taxonomy with the same display name in the taxonomy store.

      Args:
        request: (CategorymanagerProjectsCopyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Copy')
      return self._RunMethod(
          config, request, global_params=global_params)

    Copy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/projects/{projectsId}:copy',
        http_method=u'POST',
        method_id=u'categorymanager.projects.copy',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}:copy',
        request_field=u'copyTaxonomyRequest',
        request_type_name=u'CategorymanagerProjectsCopyRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

  class TaxonomiesService(base_api.BaseApiService):
    """Service class for the taxonomies resource."""

    _NAME = u'taxonomies'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.TaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      r"""Searches for taxonomies by display name in an organization, both in the.
organization-based taxonomy store and taxonomies in any project in the
organization.

      Args:
        request: (CategorymanagerTaxonomiesSearchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'categorymanager.taxonomies.search',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'parent', u'query'],
        relative_path=u'v1alpha2/taxonomies:search',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomiesSearchRequest',
        response_type_name=u'SearchTaxonomiesResponse',
        supports_download=False,
    )

  class TaxonomyStoresTaxonomiesAnnotationsService(base_api.BaseApiService):
    """Service class for the taxonomyStores_taxonomies_annotations resource."""

    _NAME = u'taxonomyStores_taxonomies_annotations'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.TaxonomyStoresTaxonomiesAnnotationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates an annotation in a taxonomy.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesAnnotationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}/annotations',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.taxonomies.annotations.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/annotations',
        request_field=u'annotation',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesAnnotationsCreateRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an annotation. Also deletes all member annotations if the given.
annotation is a group annotation.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesAnnotationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}/annotations/{annotationsId}',
        http_method=u'DELETE',
        method_id=u'categorymanager.taxonomyStores.taxonomies.annotations.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesAnnotationsDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets definition of an annotation.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesAnnotationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}/annotations/{annotationsId}',
        http_method=u'GET',
        method_id=u'categorymanager.taxonomyStores.taxonomies.annotations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesAnnotationsGetRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all annotations in a taxonomy.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesAnnotationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}/annotations',
        http_method=u'GET',
        method_id=u'categorymanager.taxonomyStores.taxonomies.annotations.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/annotations',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesAnnotationsListRequest',
        response_type_name=u'ListAnnotationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an annotation. Currently only support updating descriptions.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesAnnotationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}/annotations/{annotationsId}',
        http_method=u'PATCH',
        method_id=u'categorymanager.taxonomyStores.taxonomies.annotations.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'annotation',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesAnnotationsPatchRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

  class TaxonomyStoresTaxonomiesService(base_api.BaseApiService):
    """Service class for the taxonomyStores_taxonomies resource."""

    _NAME = u'taxonomyStores_taxonomies'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.TaxonomyStoresTaxonomiesService, self).__init__(client)
      self._upload_configs = {
          }

    def Copy(self, request, global_params=None):
      r"""Copy an annotation to a given taxonomy. Copy will fail if there is an.
annotation with the same in the taxonomy.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesCopyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Copy')
      return self._RunMethod(
          config, request, global_params=global_params)

    Copy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}:copy',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.taxonomies.copy',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}:copy',
        request_field=u'copyAnnotationRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesCopyRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new taxonomy in a given taxonomy store.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.taxonomies.create',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}/taxonomies',
        request_field=u'taxonomy',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesCreateRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a taxonomy from a taxonomy store. This operation will also delete.
all annotations in this taxonomy.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}',
        http_method=u'DELETE',
        method_id=u'categorymanager.taxonomyStores.taxonomies.delete',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesDeleteRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the taxonomy referred by name. Size of a taxonomy is at most 100KB.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}',
        http_method=u'GET',
        method_id=u'categorymanager.taxonomyStores.taxonomies.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1alpha2/{+name}',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesGetRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""GetIamPolicy method for the taxonomyStores_taxonomies service.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.taxonomies.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists all taxonomies in a taxonomy store or a project.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListTaxonomiesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies',
        http_method=u'GET',
        method_id=u'categorymanager.taxonomyStores.taxonomies.list',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[u'pageSize', u'pageToken'],
        relative_path=u'v1alpha2/{+parent}/taxonomies',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesListRequest',
        response_type_name=u'ListTaxonomiesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a taxonomy. Currently only support updating descriptions.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}',
        http_method=u'PATCH',
        method_id=u'categorymanager.taxonomyStores.taxonomies.patch',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'updateMask'],
        relative_path=u'v1alpha2/{+name}',
        request_field=u'taxonomy',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesPatchRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""SetIamPolicy method for the taxonomyStores_taxonomies service.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.taxonomies.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Return permissions that the caller has on the given taxonomy resource.

      Args:
        request: (CategorymanagerTaxonomyStoresTaxonomiesTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}/taxonomies/{taxonomiesId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.taxonomies.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresTaxonomiesTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

  class TaxonomyStoresService(base_api.BaseApiService):
    """Service class for the taxonomyStores resource."""

    _NAME = u'taxonomyStores'

    def __init__(self, client):
      super(CategorymanagerV1alpha2.TaxonomyStoresService, self).__init__(client)
      self._upload_configs = {
          }

    def Copy(self, request, global_params=None):
      r"""Copy a taxonomy to a given taxonomy store. Copy will fail if there is a.
taxonomy with the same display name in the taxonomy store.

      Args:
        request: (CategorymanagerTaxonomyStoresCopyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Taxonomy) The response message.
      """
      config = self.GetMethodConfig('Copy')
      return self._RunMethod(
          config, request, global_params=global_params)

    Copy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}:copy',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.copy',
        ordered_params=[u'parent'],
        path_params=[u'parent'],
        query_params=[],
        relative_path=u'v1alpha2/{+parent}:copy',
        request_field=u'copyTaxonomyRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresCopyRequest',
        response_type_name=u'Taxonomy',
        supports_download=False,
    )

    def GetCommon(self, request, global_params=None):
      r"""Get the read-only taxonomy store with predefined taxonomies. Taxonomies in.
this store can only be read or copied out.

      Args:
        request: (CategorymanagerTaxonomyStoresGetCommonRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TaxonomyStore) The response message.
      """
      config = self.GetMethodConfig('GetCommon')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetCommon.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'categorymanager.taxonomyStores.getCommon',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1alpha2/taxonomyStores:getCommon',
        request_field='',
        request_type_name=u'CategorymanagerTaxonomyStoresGetCommonRequest',
        response_type_name=u'TaxonomyStore',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""GetIamPolicy method for the taxonomyStores service.

      Args:
        request: (CategorymanagerTaxonomyStoresGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""SetIamPolicy method for the taxonomyStores service.

      Args:
        request: (CategorymanagerTaxonomyStoresSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Return permissions that the caller has on the given taxonomy resource.

      Args:
        request: (CategorymanagerTaxonomyStoresTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1alpha2/taxonomyStores/{taxonomyStoresId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'categorymanager.taxonomyStores.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1alpha2/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'CategorymanagerTaxonomyStoresTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )
