Name: cockpit-session-recording
Version: 13
Release: 1%{?dist}
Summary: Cockpit Session Recording
License: LGPL-2.0-or-later
URL:     https://github.com/Scribery/%{name}
Source:  https://github.com/Scribery/%{name}/releases/download/%{version}/%{name}-%{version}.tar.xz

BuildArch: noarch
BuildRequires: nodejs
BuildRequires: make
BuildRequires: libappstream-glib
BuildRequires: gettext
%if 0%{?rhel} && 0%{?rhel} <= 8
BuildRequires: libappstream-glib-devel
%endif

Requires: cockpit-system
Requires: tlog

Provides: bundled(npm(array-timsort)) = 1.0.3
Provides: bundled(npm(attr-accept)) = 1.1.3
Provides: bundled(npm(@babel/runtime)) = 7.21.5
Provides: bundled(npm(base64-js)) = 1.5.1
Provides: bundled(npm(buffer)) = 6.0.3
Provides: bundled(npm(comment-json)) = 4.2.3
Provides: bundled(npm(core-js)) = 2.6.12
Provides: bundled(npm(core-util-is)) = 1.0.3
Provides: bundled(npm(date-fns)) = 2.30.0
Provides: bundled(npm(esprima)) = 4.0.1
Provides: bundled(npm(file-selector)) = 0.1.19
Provides: bundled(npm(focus-trap)) = 6.9.2
Provides: bundled(npm(has-own-prop)) = 2.0.0
Provides: bundled(npm(ieee754)) = 1.2.1
Provides: bundled(npm(ini)) = 4.1.0
Provides: bundled(npm(jquery)) = 3.6.4
Provides: bundled(npm(js-tokens)) = 4.0.0
Provides: bundled(npm(lodash)) = 4.17.21
Provides: bundled(npm(loose-envify)) = 1.4.0
Provides: bundled(npm(object-assign)) = 4.1.1
Provides: bundled(npm(@patternfly/patternfly)) = 4.224.4
Provides: bundled(npm(@patternfly/react-core)) = 4.276.9
Provides: bundled(npm(@patternfly/react-icons)) = 4.93.6
Provides: bundled(npm(@patternfly/react-styles)) = 4.92.7
Provides: bundled(npm(@patternfly/react-table)) = 4.113.0
Provides: bundled(npm(@patternfly/react-tokens)) = 4.94.6
Provides: bundled(npm(popper.js)) = 1.16.1
Provides: bundled(npm(prop-types)) = 15.8.1
Provides: bundled(npm(prop-types-extra)) = 1.1.1
Provides: bundled(npm(react)) = 18.2.0
Provides: bundled(npm(react-dom)) = 18.2.0
Provides: bundled(npm(react-dropzone)) = 9.0.0
Provides: bundled(npm(react-is)) = 16.13.1
Provides: bundled(npm(regenerator-runtime)) = 0.13.11
Provides: bundled(npm(repeat-string)) = 1.6.1
Provides: bundled(npm(scheduler)) = 0.23.0
Provides: bundled(npm(tabbable)) = 5.3.3
Provides: bundled(npm(throttle-debounce)) = 5.0.0
Provides: bundled(npm(tippy.js)) = 5.1.2
Provides: bundled(npm(tslib)) = 2.5.0
Provides: bundled(npm(warning)) = 4.0.3
Provides: bundled(npm(xterm)) = 5.1.0

%description
Cockpit module providing session recording configuration and playback.
This module allows viewing and playback of journal-stored terminal session
recordings generated by the tlog component.

%prep
%setup -q -n %{name}

%build
# Nothing to build

%install
%make_install PREFIX=/usr
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/metainfo/*

%files
%{_datadir}/cockpit/*
%{_datadir}/metainfo/*

%changelog
* Wed Jan 13 2021 Justin Stephenson <jstephen@redhat.com> - 7-1
- Release v7
- Remove bots sudo rm from Makefile
- Use journalctl --utc for Logs view to handle DST
- Add Applications Menu test
- Install cockpit-packagekit in local VM
- Set timezone for Logs Correlation test

* Mon Oct 12 2020 Justin Stephenson <jstephen@redhat.com> - 6-1
- Release v6
- Bump testlib to 229
- Add binary recording test

* Wed May 20 2020 Justin Stephenson <jstephen@redhat.com> - 4-1
- Release v4
- Update parent id in metainfo file
- Update package manifest
- Fix rpmmacro to resolve correc    t path on CentOS7
- Handle byte-array encoded journal data
- Don't clobber cockpit bots directory
- Move code out of deprecated React lifecycle functions

* Mon Nov 25 2019 Justin Stephenson <jstephen@redhat.com> - 3-1
- Release v3
- Reset Logs View on Player Rewind
- Configuration page UI CSS Improvements

* Wed Sep 11 2019 Justin Stephenson <jstephen@redhat.com> - 2-1
- Release 2
- Optimize performance when playing back flooded output recordings.
- Make Logs View optional rendered with a toggle button.
- Make Logs component a child of Recording component.
- Fix Recording page column sorting in Google Chrome.
- CSS updates for Patternfly 4 compatibility.
- Replace term.js with maintained xterm.js library.
- Fix hostname and username filtering.

* Thu Apr 4 2019 Kirill Glebov <kgliebov@redhat.com> - 1-1
- Release 1
- First release. Includes logs correlation, player controls, journal remote support.
