﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/appsync/model/SourceApiAssociationConfig.h>
#include <utility>

namespace Aws
{
namespace AppSync
{
namespace Model
{

  /**
   */
  class UpdateSourceApiAssociationRequest : public AppSyncRequest
  {
  public:
    AWS_APPSYNC_API UpdateSourceApiAssociationRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "UpdateSourceApiAssociation"; }

    AWS_APPSYNC_API Aws::String SerializePayload() const override;


    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline const Aws::String& GetAssociationId() const{ return m_associationId; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(const Aws::String& value) { m_associationIdHasBeenSet = true; m_associationId = value; }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(Aws::String&& value) { m_associationIdHasBeenSet = true; m_associationId = std::move(value); }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline void SetAssociationId(const char* value) { m_associationIdHasBeenSet = true; m_associationId.assign(value); }

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithAssociationId(const Aws::String& value) { SetAssociationId(value); return *this;}

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithAssociationId(Aws::String&& value) { SetAssociationId(std::move(value)); return *this;}

    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithAssociationId(const char* value) { SetAssociationId(value); return *this;}


    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline const Aws::String& GetMergedApiIdentifier() const{ return m_mergedApiIdentifier; }

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline bool MergedApiIdentifierHasBeenSet() const { return m_mergedApiIdentifierHasBeenSet; }

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline void SetMergedApiIdentifier(const Aws::String& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = value; }

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline void SetMergedApiIdentifier(Aws::String&& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = std::move(value); }

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline void SetMergedApiIdentifier(const char* value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier.assign(value); }

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithMergedApiIdentifier(const Aws::String& value) { SetMergedApiIdentifier(value); return *this;}

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithMergedApiIdentifier(Aws::String&& value) { SetMergedApiIdentifier(std::move(value)); return *this;}

    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithMergedApiIdentifier(const char* value) { SetMergedApiIdentifier(value); return *this;}


    /**
     * <p>The description field.</p>
     */
    inline const Aws::String& GetDescription() const{ return m_description; }

    /**
     * <p>The description field.</p>
     */
    inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(const Aws::String& value) { m_descriptionHasBeenSet = true; m_description = value; }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(Aws::String&& value) { m_descriptionHasBeenSet = true; m_description = std::move(value); }

    /**
     * <p>The description field.</p>
     */
    inline void SetDescription(const char* value) { m_descriptionHasBeenSet = true; m_description.assign(value); }

    /**
     * <p>The description field.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithDescription(const Aws::String& value) { SetDescription(value); return *this;}

    /**
     * <p>The description field.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithDescription(Aws::String&& value) { SetDescription(std::move(value)); return *this;}

    /**
     * <p>The description field.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithDescription(const char* value) { SetDescription(value); return *this;}


    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline const SourceApiAssociationConfig& GetSourceApiAssociationConfig() const{ return m_sourceApiAssociationConfig; }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline bool SourceApiAssociationConfigHasBeenSet() const { return m_sourceApiAssociationConfigHasBeenSet; }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline void SetSourceApiAssociationConfig(const SourceApiAssociationConfig& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = value; }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline void SetSourceApiAssociationConfig(SourceApiAssociationConfig&& value) { m_sourceApiAssociationConfigHasBeenSet = true; m_sourceApiAssociationConfig = std::move(value); }

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithSourceApiAssociationConfig(const SourceApiAssociationConfig& value) { SetSourceApiAssociationConfig(value); return *this;}

    /**
     * <p>The <code>SourceApiAssociationConfig</code> object data.</p>
     */
    inline UpdateSourceApiAssociationRequest& WithSourceApiAssociationConfig(SourceApiAssociationConfig&& value) { SetSourceApiAssociationConfig(std::move(value)); return *this;}

  private:

    Aws::String m_associationId;
    bool m_associationIdHasBeenSet = false;

    Aws::String m_mergedApiIdentifier;
    bool m_mergedApiIdentifierHasBeenSet = false;

    Aws::String m_description;
    bool m_descriptionHasBeenSet = false;

    SourceApiAssociationConfig m_sourceApiAssociationConfig;
    bool m_sourceApiAssociationConfigHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
