/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the RpmModulemdObsoleteResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &RpmModulemdObsoleteResponse{}

// RpmModulemdObsoleteResponse ModulemdObsolete serializer.
type RpmModulemdObsoleteResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Obsolete modified time.
	Modified string `json:"modified"`
	// Modulemd name.
	ModuleName string `json:"module_name"`
	// Modulemd's stream.
	ModuleStream string `json:"module_stream"`
	// Obsolete description.
	Message string `json:"message"`
	// Reset previous obsoletes.
	OverridePrevious NullableString `json:"override_previous"`
	// Modulemd's context.
	ModuleContext NullableString `json:"module_context"`
	// End of Life date.
	EolDate NullableString `json:"eol_date"`
	// Obsolete by module name.
	ObsoletedByModuleName NullableString `json:"obsoleted_by_module_name"`
	// Obsolete by module stream.
	ObsoletedByModuleStream NullableString `json:"obsoleted_by_module_stream"`
	AdditionalProperties map[string]interface{}
}

type _RpmModulemdObsoleteResponse RpmModulemdObsoleteResponse

// NewRpmModulemdObsoleteResponse instantiates a new RpmModulemdObsoleteResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRpmModulemdObsoleteResponse(modified string, moduleName string, moduleStream string, message string, overridePrevious NullableString, moduleContext NullableString, eolDate NullableString, obsoletedByModuleName NullableString, obsoletedByModuleStream NullableString) *RpmModulemdObsoleteResponse {
	this := RpmModulemdObsoleteResponse{}
	this.Modified = modified
	this.ModuleName = moduleName
	this.ModuleStream = moduleStream
	this.Message = message
	this.OverridePrevious = overridePrevious
	this.ModuleContext = moduleContext
	this.EolDate = eolDate
	this.ObsoletedByModuleName = obsoletedByModuleName
	this.ObsoletedByModuleStream = obsoletedByModuleStream
	return &this
}

// NewRpmModulemdObsoleteResponseWithDefaults instantiates a new RpmModulemdObsoleteResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRpmModulemdObsoleteResponseWithDefaults() *RpmModulemdObsoleteResponse {
	this := RpmModulemdObsoleteResponse{}
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *RpmModulemdObsoleteResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmModulemdObsoleteResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *RpmModulemdObsoleteResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *RpmModulemdObsoleteResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *RpmModulemdObsoleteResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RpmModulemdObsoleteResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *RpmModulemdObsoleteResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *RpmModulemdObsoleteResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetModified returns the Modified field value
func (o *RpmModulemdObsoleteResponse) GetModified() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Modified
}

// GetModifiedOk returns a tuple with the Modified field value
// and a boolean to check if the value has been set.
func (o *RpmModulemdObsoleteResponse) GetModifiedOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Modified, true
}

// SetModified sets field value
func (o *RpmModulemdObsoleteResponse) SetModified(v string) {
	o.Modified = v
}

// GetModuleName returns the ModuleName field value
func (o *RpmModulemdObsoleteResponse) GetModuleName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ModuleName
}

// GetModuleNameOk returns a tuple with the ModuleName field value
// and a boolean to check if the value has been set.
func (o *RpmModulemdObsoleteResponse) GetModuleNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ModuleName, true
}

// SetModuleName sets field value
func (o *RpmModulemdObsoleteResponse) SetModuleName(v string) {
	o.ModuleName = v
}

// GetModuleStream returns the ModuleStream field value
func (o *RpmModulemdObsoleteResponse) GetModuleStream() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ModuleStream
}

// GetModuleStreamOk returns a tuple with the ModuleStream field value
// and a boolean to check if the value has been set.
func (o *RpmModulemdObsoleteResponse) GetModuleStreamOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ModuleStream, true
}

// SetModuleStream sets field value
func (o *RpmModulemdObsoleteResponse) SetModuleStream(v string) {
	o.ModuleStream = v
}

// GetMessage returns the Message field value
func (o *RpmModulemdObsoleteResponse) GetMessage() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Message
}

// GetMessageOk returns a tuple with the Message field value
// and a boolean to check if the value has been set.
func (o *RpmModulemdObsoleteResponse) GetMessageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Message, true
}

// SetMessage sets field value
func (o *RpmModulemdObsoleteResponse) SetMessage(v string) {
	o.Message = v
}

// GetOverridePrevious returns the OverridePrevious field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmModulemdObsoleteResponse) GetOverridePrevious() string {
	if o == nil || o.OverridePrevious.Get() == nil {
		var ret string
		return ret
	}

	return *o.OverridePrevious.Get()
}

// GetOverridePreviousOk returns a tuple with the OverridePrevious field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmModulemdObsoleteResponse) GetOverridePreviousOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.OverridePrevious.Get(), o.OverridePrevious.IsSet()
}

// SetOverridePrevious sets field value
func (o *RpmModulemdObsoleteResponse) SetOverridePrevious(v string) {
	o.OverridePrevious.Set(&v)
}

// GetModuleContext returns the ModuleContext field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmModulemdObsoleteResponse) GetModuleContext() string {
	if o == nil || o.ModuleContext.Get() == nil {
		var ret string
		return ret
	}

	return *o.ModuleContext.Get()
}

// GetModuleContextOk returns a tuple with the ModuleContext field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmModulemdObsoleteResponse) GetModuleContextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ModuleContext.Get(), o.ModuleContext.IsSet()
}

// SetModuleContext sets field value
func (o *RpmModulemdObsoleteResponse) SetModuleContext(v string) {
	o.ModuleContext.Set(&v)
}

// GetEolDate returns the EolDate field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmModulemdObsoleteResponse) GetEolDate() string {
	if o == nil || o.EolDate.Get() == nil {
		var ret string
		return ret
	}

	return *o.EolDate.Get()
}

// GetEolDateOk returns a tuple with the EolDate field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmModulemdObsoleteResponse) GetEolDateOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.EolDate.Get(), o.EolDate.IsSet()
}

// SetEolDate sets field value
func (o *RpmModulemdObsoleteResponse) SetEolDate(v string) {
	o.EolDate.Set(&v)
}

// GetObsoletedByModuleName returns the ObsoletedByModuleName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmModulemdObsoleteResponse) GetObsoletedByModuleName() string {
	if o == nil || o.ObsoletedByModuleName.Get() == nil {
		var ret string
		return ret
	}

	return *o.ObsoletedByModuleName.Get()
}

// GetObsoletedByModuleNameOk returns a tuple with the ObsoletedByModuleName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmModulemdObsoleteResponse) GetObsoletedByModuleNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ObsoletedByModuleName.Get(), o.ObsoletedByModuleName.IsSet()
}

// SetObsoletedByModuleName sets field value
func (o *RpmModulemdObsoleteResponse) SetObsoletedByModuleName(v string) {
	o.ObsoletedByModuleName.Set(&v)
}

// GetObsoletedByModuleStream returns the ObsoletedByModuleStream field value
// If the value is explicit nil, the zero value for string will be returned
func (o *RpmModulemdObsoleteResponse) GetObsoletedByModuleStream() string {
	if o == nil || o.ObsoletedByModuleStream.Get() == nil {
		var ret string
		return ret
	}

	return *o.ObsoletedByModuleStream.Get()
}

// GetObsoletedByModuleStreamOk returns a tuple with the ObsoletedByModuleStream field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *RpmModulemdObsoleteResponse) GetObsoletedByModuleStreamOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ObsoletedByModuleStream.Get(), o.ObsoletedByModuleStream.IsSet()
}

// SetObsoletedByModuleStream sets field value
func (o *RpmModulemdObsoleteResponse) SetObsoletedByModuleStream(v string) {
	o.ObsoletedByModuleStream.Set(&v)
}

func (o RpmModulemdObsoleteResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o RpmModulemdObsoleteResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	toSerialize["modified"] = o.Modified
	toSerialize["module_name"] = o.ModuleName
	toSerialize["module_stream"] = o.ModuleStream
	toSerialize["message"] = o.Message
	toSerialize["override_previous"] = o.OverridePrevious.Get()
	toSerialize["module_context"] = o.ModuleContext.Get()
	toSerialize["eol_date"] = o.EolDate.Get()
	toSerialize["obsoleted_by_module_name"] = o.ObsoletedByModuleName.Get()
	toSerialize["obsoleted_by_module_stream"] = o.ObsoletedByModuleStream.Get()

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *RpmModulemdObsoleteResponse) UnmarshalJSON(bytes []byte) (err error) {
	varRpmModulemdObsoleteResponse := _RpmModulemdObsoleteResponse{}

	if err = json.Unmarshal(bytes, &varRpmModulemdObsoleteResponse); err == nil {
		*o = RpmModulemdObsoleteResponse(varRpmModulemdObsoleteResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "modified")
		delete(additionalProperties, "module_name")
		delete(additionalProperties, "module_stream")
		delete(additionalProperties, "message")
		delete(additionalProperties, "override_previous")
		delete(additionalProperties, "module_context")
		delete(additionalProperties, "eol_date")
		delete(additionalProperties, "obsoleted_by_module_name")
		delete(additionalProperties, "obsoleted_by_module_stream")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableRpmModulemdObsoleteResponse struct {
	value *RpmModulemdObsoleteResponse
	isSet bool
}

func (v NullableRpmModulemdObsoleteResponse) Get() *RpmModulemdObsoleteResponse {
	return v.value
}

func (v *NullableRpmModulemdObsoleteResponse) Set(val *RpmModulemdObsoleteResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableRpmModulemdObsoleteResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableRpmModulemdObsoleteResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRpmModulemdObsoleteResponse(val *RpmModulemdObsoleteResponse) *NullableRpmModulemdObsoleteResponse {
	return &NullableRpmModulemdObsoleteResponse{value: val, isSet: true}
}

func (v NullableRpmModulemdObsoleteResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRpmModulemdObsoleteResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


