/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the PythonPythonPackageContentResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PythonPythonPackageContentResponse{}

// PythonPythonPackageContentResponse A Serializer for PythonPackageContent.
type PythonPythonPackageContentResponse struct {
	PulpHref *string `json:"pulp_href,omitempty"`
	// Timestamp of creation.
	PulpCreated *time.Time `json:"pulp_created,omitempty"`
	// Artifact file representing the physical content
	Artifact *string `json:"artifact,omitempty"`
	// The name of the distribution package, usually of the format: {distribution}-{version}(-{build tag})?-{python tag}-{abi tag}-{platform tag}.{packagetype}
	Filename *string `json:"filename,omitempty"`
	// The type of the distribution package (e.g. sdist, bdist_wheel, bdist_egg, etc)
	Packagetype *string `json:"packagetype,omitempty"`
	// The name of the python project.
	Name *string `json:"name,omitempty"`
	// The packages version number.
	Version *string `json:"version,omitempty"`
	// The SHA256 digest of this package.
	Sha256 *string `json:"sha256,omitempty"`
	// Version of the file format
	MetadataVersion *string `json:"metadata_version,omitempty"`
	// A one-line summary of what the package does.
	Summary *string `json:"summary,omitempty"`
	// A longer description of the package that can run to several paragraphs.
	Description *string `json:"description,omitempty"`
	// A string stating the markup syntax (if any) used in the distribution’s description, so that tools can intelligently render the description.
	DescriptionContentType *string `json:"description_content_type,omitempty"`
	// Additional keywords to be used to assist searching for the package in a larger catalog.
	Keywords *string `json:"keywords,omitempty"`
	// The URL for the package's home page.
	HomePage *string `json:"home_page,omitempty"`
	// Legacy field denoting the URL from which this package can be downloaded.
	DownloadUrl *string `json:"download_url,omitempty"`
	// Text containing the author's name. Contact information can also be added, separated with newlines.
	Author *string `json:"author,omitempty"`
	// The author's e-mail address. 
	AuthorEmail *string `json:"author_email,omitempty"`
	// The maintainer's name at a minimum; additional contact information may be provided.
	Maintainer *string `json:"maintainer,omitempty"`
	// The maintainer's e-mail address.
	MaintainerEmail *string `json:"maintainer_email,omitempty"`
	// Text indicating the license covering the distribution
	License *string `json:"license,omitempty"`
	// The Python version(s) that the distribution is guaranteed to be compatible with.
	RequiresPython *string `json:"requires_python,omitempty"`
	// A browsable URL for the project and a label for it, separated by a comma.
	ProjectUrl *string `json:"project_url,omitempty"`
	// A dictionary of labels and URLs for the project.
	ProjectUrls map[string]interface{} `json:"project_urls,omitempty"`
	// A comma-separated list of platform specifications, summarizing the operating systems supported by the package.
	Platform *string `json:"platform,omitempty"`
	// Field to specify the OS and CPU for which the binary package was compiled. 
	SupportedPlatform *string `json:"supported_platform,omitempty"`
	// A JSON list containing names of some other distutils project required by this distribution.
	RequiresDist map[string]interface{} `json:"requires_dist,omitempty"`
	// A JSON list containing names of a Distutils project which is contained within this distribution.
	ProvidesDist map[string]interface{} `json:"provides_dist,omitempty"`
	// A JSON list containing names of a distutils project's distribution which this distribution renders obsolete, meaning that the two projects should not be installed at the same time.
	ObsoletesDist map[string]interface{} `json:"obsoletes_dist,omitempty"`
	// A JSON list containing some dependency in the system that the distribution is to be used.
	RequiresExternal map[string]interface{} `json:"requires_external,omitempty"`
	// A JSON list containing classification values for a Python package.
	Classifiers map[string]interface{} `json:"classifiers,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _PythonPythonPackageContentResponse PythonPythonPackageContentResponse

// NewPythonPythonPackageContentResponse instantiates a new PythonPythonPackageContentResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPythonPythonPackageContentResponse() *PythonPythonPackageContentResponse {
	this := PythonPythonPackageContentResponse{}
	var sha256 string = ""
	this.Sha256 = &sha256
	return &this
}

// NewPythonPythonPackageContentResponseWithDefaults instantiates a new PythonPythonPackageContentResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPythonPythonPackageContentResponseWithDefaults() *PythonPythonPackageContentResponse {
	this := PythonPythonPackageContentResponse{}
	var sha256 string = ""
	this.Sha256 = &sha256
	return &this
}

// GetPulpHref returns the PulpHref field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetPulpHref() string {
	if o == nil || IsNil(o.PulpHref) {
		var ret string
		return ret
	}
	return *o.PulpHref
}

// GetPulpHrefOk returns a tuple with the PulpHref field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetPulpHrefOk() (*string, bool) {
	if o == nil || IsNil(o.PulpHref) {
		return nil, false
	}
	return o.PulpHref, true
}

// HasPulpHref returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasPulpHref() bool {
	if o != nil && !IsNil(o.PulpHref) {
		return true
	}

	return false
}

// SetPulpHref gets a reference to the given string and assigns it to the PulpHref field.
func (o *PythonPythonPackageContentResponse) SetPulpHref(v string) {
	o.PulpHref = &v
}

// GetPulpCreated returns the PulpCreated field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetPulpCreated() time.Time {
	if o == nil || IsNil(o.PulpCreated) {
		var ret time.Time
		return ret
	}
	return *o.PulpCreated
}

// GetPulpCreatedOk returns a tuple with the PulpCreated field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetPulpCreatedOk() (*time.Time, bool) {
	if o == nil || IsNil(o.PulpCreated) {
		return nil, false
	}
	return o.PulpCreated, true
}

// HasPulpCreated returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasPulpCreated() bool {
	if o != nil && !IsNil(o.PulpCreated) {
		return true
	}

	return false
}

// SetPulpCreated gets a reference to the given time.Time and assigns it to the PulpCreated field.
func (o *PythonPythonPackageContentResponse) SetPulpCreated(v time.Time) {
	o.PulpCreated = &v
}

// GetArtifact returns the Artifact field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetArtifact() string {
	if o == nil || IsNil(o.Artifact) {
		var ret string
		return ret
	}
	return *o.Artifact
}

// GetArtifactOk returns a tuple with the Artifact field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetArtifactOk() (*string, bool) {
	if o == nil || IsNil(o.Artifact) {
		return nil, false
	}
	return o.Artifact, true
}

// HasArtifact returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasArtifact() bool {
	if o != nil && !IsNil(o.Artifact) {
		return true
	}

	return false
}

// SetArtifact gets a reference to the given string and assigns it to the Artifact field.
func (o *PythonPythonPackageContentResponse) SetArtifact(v string) {
	o.Artifact = &v
}

// GetFilename returns the Filename field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetFilename() string {
	if o == nil || IsNil(o.Filename) {
		var ret string
		return ret
	}
	return *o.Filename
}

// GetFilenameOk returns a tuple with the Filename field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetFilenameOk() (*string, bool) {
	if o == nil || IsNil(o.Filename) {
		return nil, false
	}
	return o.Filename, true
}

// HasFilename returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasFilename() bool {
	if o != nil && !IsNil(o.Filename) {
		return true
	}

	return false
}

// SetFilename gets a reference to the given string and assigns it to the Filename field.
func (o *PythonPythonPackageContentResponse) SetFilename(v string) {
	o.Filename = &v
}

// GetPackagetype returns the Packagetype field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetPackagetype() string {
	if o == nil || IsNil(o.Packagetype) {
		var ret string
		return ret
	}
	return *o.Packagetype
}

// GetPackagetypeOk returns a tuple with the Packagetype field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetPackagetypeOk() (*string, bool) {
	if o == nil || IsNil(o.Packagetype) {
		return nil, false
	}
	return o.Packagetype, true
}

// HasPackagetype returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasPackagetype() bool {
	if o != nil && !IsNil(o.Packagetype) {
		return true
	}

	return false
}

// SetPackagetype gets a reference to the given string and assigns it to the Packagetype field.
func (o *PythonPythonPackageContentResponse) SetPackagetype(v string) {
	o.Packagetype = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *PythonPythonPackageContentResponse) SetName(v string) {
	o.Name = &v
}

// GetVersion returns the Version field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetVersion() string {
	if o == nil || IsNil(o.Version) {
		var ret string
		return ret
	}
	return *o.Version
}

// GetVersionOk returns a tuple with the Version field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetVersionOk() (*string, bool) {
	if o == nil || IsNil(o.Version) {
		return nil, false
	}
	return o.Version, true
}

// HasVersion returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasVersion() bool {
	if o != nil && !IsNil(o.Version) {
		return true
	}

	return false
}

// SetVersion gets a reference to the given string and assigns it to the Version field.
func (o *PythonPythonPackageContentResponse) SetVersion(v string) {
	o.Version = &v
}

// GetSha256 returns the Sha256 field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetSha256() string {
	if o == nil || IsNil(o.Sha256) {
		var ret string
		return ret
	}
	return *o.Sha256
}

// GetSha256Ok returns a tuple with the Sha256 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetSha256Ok() (*string, bool) {
	if o == nil || IsNil(o.Sha256) {
		return nil, false
	}
	return o.Sha256, true
}

// HasSha256 returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasSha256() bool {
	if o != nil && !IsNil(o.Sha256) {
		return true
	}

	return false
}

// SetSha256 gets a reference to the given string and assigns it to the Sha256 field.
func (o *PythonPythonPackageContentResponse) SetSha256(v string) {
	o.Sha256 = &v
}

// GetMetadataVersion returns the MetadataVersion field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetMetadataVersion() string {
	if o == nil || IsNil(o.MetadataVersion) {
		var ret string
		return ret
	}
	return *o.MetadataVersion
}

// GetMetadataVersionOk returns a tuple with the MetadataVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetMetadataVersionOk() (*string, bool) {
	if o == nil || IsNil(o.MetadataVersion) {
		return nil, false
	}
	return o.MetadataVersion, true
}

// HasMetadataVersion returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasMetadataVersion() bool {
	if o != nil && !IsNil(o.MetadataVersion) {
		return true
	}

	return false
}

// SetMetadataVersion gets a reference to the given string and assigns it to the MetadataVersion field.
func (o *PythonPythonPackageContentResponse) SetMetadataVersion(v string) {
	o.MetadataVersion = &v
}

// GetSummary returns the Summary field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetSummary() string {
	if o == nil || IsNil(o.Summary) {
		var ret string
		return ret
	}
	return *o.Summary
}

// GetSummaryOk returns a tuple with the Summary field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetSummaryOk() (*string, bool) {
	if o == nil || IsNil(o.Summary) {
		return nil, false
	}
	return o.Summary, true
}

// HasSummary returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasSummary() bool {
	if o != nil && !IsNil(o.Summary) {
		return true
	}

	return false
}

// SetSummary gets a reference to the given string and assigns it to the Summary field.
func (o *PythonPythonPackageContentResponse) SetSummary(v string) {
	o.Summary = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetDescription() string {
	if o == nil || IsNil(o.Description) {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetDescriptionOk() (*string, bool) {
	if o == nil || IsNil(o.Description) {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasDescription() bool {
	if o != nil && !IsNil(o.Description) {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *PythonPythonPackageContentResponse) SetDescription(v string) {
	o.Description = &v
}

// GetDescriptionContentType returns the DescriptionContentType field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetDescriptionContentType() string {
	if o == nil || IsNil(o.DescriptionContentType) {
		var ret string
		return ret
	}
	return *o.DescriptionContentType
}

// GetDescriptionContentTypeOk returns a tuple with the DescriptionContentType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetDescriptionContentTypeOk() (*string, bool) {
	if o == nil || IsNil(o.DescriptionContentType) {
		return nil, false
	}
	return o.DescriptionContentType, true
}

// HasDescriptionContentType returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasDescriptionContentType() bool {
	if o != nil && !IsNil(o.DescriptionContentType) {
		return true
	}

	return false
}

// SetDescriptionContentType gets a reference to the given string and assigns it to the DescriptionContentType field.
func (o *PythonPythonPackageContentResponse) SetDescriptionContentType(v string) {
	o.DescriptionContentType = &v
}

// GetKeywords returns the Keywords field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetKeywords() string {
	if o == nil || IsNil(o.Keywords) {
		var ret string
		return ret
	}
	return *o.Keywords
}

// GetKeywordsOk returns a tuple with the Keywords field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetKeywordsOk() (*string, bool) {
	if o == nil || IsNil(o.Keywords) {
		return nil, false
	}
	return o.Keywords, true
}

// HasKeywords returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasKeywords() bool {
	if o != nil && !IsNil(o.Keywords) {
		return true
	}

	return false
}

// SetKeywords gets a reference to the given string and assigns it to the Keywords field.
func (o *PythonPythonPackageContentResponse) SetKeywords(v string) {
	o.Keywords = &v
}

// GetHomePage returns the HomePage field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetHomePage() string {
	if o == nil || IsNil(o.HomePage) {
		var ret string
		return ret
	}
	return *o.HomePage
}

// GetHomePageOk returns a tuple with the HomePage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetHomePageOk() (*string, bool) {
	if o == nil || IsNil(o.HomePage) {
		return nil, false
	}
	return o.HomePage, true
}

// HasHomePage returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasHomePage() bool {
	if o != nil && !IsNil(o.HomePage) {
		return true
	}

	return false
}

// SetHomePage gets a reference to the given string and assigns it to the HomePage field.
func (o *PythonPythonPackageContentResponse) SetHomePage(v string) {
	o.HomePage = &v
}

// GetDownloadUrl returns the DownloadUrl field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetDownloadUrl() string {
	if o == nil || IsNil(o.DownloadUrl) {
		var ret string
		return ret
	}
	return *o.DownloadUrl
}

// GetDownloadUrlOk returns a tuple with the DownloadUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetDownloadUrlOk() (*string, bool) {
	if o == nil || IsNil(o.DownloadUrl) {
		return nil, false
	}
	return o.DownloadUrl, true
}

// HasDownloadUrl returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasDownloadUrl() bool {
	if o != nil && !IsNil(o.DownloadUrl) {
		return true
	}

	return false
}

// SetDownloadUrl gets a reference to the given string and assigns it to the DownloadUrl field.
func (o *PythonPythonPackageContentResponse) SetDownloadUrl(v string) {
	o.DownloadUrl = &v
}

// GetAuthor returns the Author field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetAuthor() string {
	if o == nil || IsNil(o.Author) {
		var ret string
		return ret
	}
	return *o.Author
}

// GetAuthorOk returns a tuple with the Author field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetAuthorOk() (*string, bool) {
	if o == nil || IsNil(o.Author) {
		return nil, false
	}
	return o.Author, true
}

// HasAuthor returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasAuthor() bool {
	if o != nil && !IsNil(o.Author) {
		return true
	}

	return false
}

// SetAuthor gets a reference to the given string and assigns it to the Author field.
func (o *PythonPythonPackageContentResponse) SetAuthor(v string) {
	o.Author = &v
}

// GetAuthorEmail returns the AuthorEmail field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetAuthorEmail() string {
	if o == nil || IsNil(o.AuthorEmail) {
		var ret string
		return ret
	}
	return *o.AuthorEmail
}

// GetAuthorEmailOk returns a tuple with the AuthorEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetAuthorEmailOk() (*string, bool) {
	if o == nil || IsNil(o.AuthorEmail) {
		return nil, false
	}
	return o.AuthorEmail, true
}

// HasAuthorEmail returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasAuthorEmail() bool {
	if o != nil && !IsNil(o.AuthorEmail) {
		return true
	}

	return false
}

// SetAuthorEmail gets a reference to the given string and assigns it to the AuthorEmail field.
func (o *PythonPythonPackageContentResponse) SetAuthorEmail(v string) {
	o.AuthorEmail = &v
}

// GetMaintainer returns the Maintainer field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetMaintainer() string {
	if o == nil || IsNil(o.Maintainer) {
		var ret string
		return ret
	}
	return *o.Maintainer
}

// GetMaintainerOk returns a tuple with the Maintainer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetMaintainerOk() (*string, bool) {
	if o == nil || IsNil(o.Maintainer) {
		return nil, false
	}
	return o.Maintainer, true
}

// HasMaintainer returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasMaintainer() bool {
	if o != nil && !IsNil(o.Maintainer) {
		return true
	}

	return false
}

// SetMaintainer gets a reference to the given string and assigns it to the Maintainer field.
func (o *PythonPythonPackageContentResponse) SetMaintainer(v string) {
	o.Maintainer = &v
}

// GetMaintainerEmail returns the MaintainerEmail field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetMaintainerEmail() string {
	if o == nil || IsNil(o.MaintainerEmail) {
		var ret string
		return ret
	}
	return *o.MaintainerEmail
}

// GetMaintainerEmailOk returns a tuple with the MaintainerEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetMaintainerEmailOk() (*string, bool) {
	if o == nil || IsNil(o.MaintainerEmail) {
		return nil, false
	}
	return o.MaintainerEmail, true
}

// HasMaintainerEmail returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasMaintainerEmail() bool {
	if o != nil && !IsNil(o.MaintainerEmail) {
		return true
	}

	return false
}

// SetMaintainerEmail gets a reference to the given string and assigns it to the MaintainerEmail field.
func (o *PythonPythonPackageContentResponse) SetMaintainerEmail(v string) {
	o.MaintainerEmail = &v
}

// GetLicense returns the License field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetLicense() string {
	if o == nil || IsNil(o.License) {
		var ret string
		return ret
	}
	return *o.License
}

// GetLicenseOk returns a tuple with the License field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetLicenseOk() (*string, bool) {
	if o == nil || IsNil(o.License) {
		return nil, false
	}
	return o.License, true
}

// HasLicense returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasLicense() bool {
	if o != nil && !IsNil(o.License) {
		return true
	}

	return false
}

// SetLicense gets a reference to the given string and assigns it to the License field.
func (o *PythonPythonPackageContentResponse) SetLicense(v string) {
	o.License = &v
}

// GetRequiresPython returns the RequiresPython field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetRequiresPython() string {
	if o == nil || IsNil(o.RequiresPython) {
		var ret string
		return ret
	}
	return *o.RequiresPython
}

// GetRequiresPythonOk returns a tuple with the RequiresPython field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetRequiresPythonOk() (*string, bool) {
	if o == nil || IsNil(o.RequiresPython) {
		return nil, false
	}
	return o.RequiresPython, true
}

// HasRequiresPython returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasRequiresPython() bool {
	if o != nil && !IsNil(o.RequiresPython) {
		return true
	}

	return false
}

// SetRequiresPython gets a reference to the given string and assigns it to the RequiresPython field.
func (o *PythonPythonPackageContentResponse) SetRequiresPython(v string) {
	o.RequiresPython = &v
}

// GetProjectUrl returns the ProjectUrl field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetProjectUrl() string {
	if o == nil || IsNil(o.ProjectUrl) {
		var ret string
		return ret
	}
	return *o.ProjectUrl
}

// GetProjectUrlOk returns a tuple with the ProjectUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetProjectUrlOk() (*string, bool) {
	if o == nil || IsNil(o.ProjectUrl) {
		return nil, false
	}
	return o.ProjectUrl, true
}

// HasProjectUrl returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasProjectUrl() bool {
	if o != nil && !IsNil(o.ProjectUrl) {
		return true
	}

	return false
}

// SetProjectUrl gets a reference to the given string and assigns it to the ProjectUrl field.
func (o *PythonPythonPackageContentResponse) SetProjectUrl(v string) {
	o.ProjectUrl = &v
}

// GetProjectUrls returns the ProjectUrls field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetProjectUrls() map[string]interface{} {
	if o == nil || IsNil(o.ProjectUrls) {
		var ret map[string]interface{}
		return ret
	}
	return o.ProjectUrls
}

// GetProjectUrlsOk returns a tuple with the ProjectUrls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetProjectUrlsOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.ProjectUrls) {
		return map[string]interface{}{}, false
	}
	return o.ProjectUrls, true
}

// HasProjectUrls returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasProjectUrls() bool {
	if o != nil && !IsNil(o.ProjectUrls) {
		return true
	}

	return false
}

// SetProjectUrls gets a reference to the given map[string]interface{} and assigns it to the ProjectUrls field.
func (o *PythonPythonPackageContentResponse) SetProjectUrls(v map[string]interface{}) {
	o.ProjectUrls = v
}

// GetPlatform returns the Platform field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetPlatform() string {
	if o == nil || IsNil(o.Platform) {
		var ret string
		return ret
	}
	return *o.Platform
}

// GetPlatformOk returns a tuple with the Platform field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetPlatformOk() (*string, bool) {
	if o == nil || IsNil(o.Platform) {
		return nil, false
	}
	return o.Platform, true
}

// HasPlatform returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasPlatform() bool {
	if o != nil && !IsNil(o.Platform) {
		return true
	}

	return false
}

// SetPlatform gets a reference to the given string and assigns it to the Platform field.
func (o *PythonPythonPackageContentResponse) SetPlatform(v string) {
	o.Platform = &v
}

// GetSupportedPlatform returns the SupportedPlatform field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetSupportedPlatform() string {
	if o == nil || IsNil(o.SupportedPlatform) {
		var ret string
		return ret
	}
	return *o.SupportedPlatform
}

// GetSupportedPlatformOk returns a tuple with the SupportedPlatform field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetSupportedPlatformOk() (*string, bool) {
	if o == nil || IsNil(o.SupportedPlatform) {
		return nil, false
	}
	return o.SupportedPlatform, true
}

// HasSupportedPlatform returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasSupportedPlatform() bool {
	if o != nil && !IsNil(o.SupportedPlatform) {
		return true
	}

	return false
}

// SetSupportedPlatform gets a reference to the given string and assigns it to the SupportedPlatform field.
func (o *PythonPythonPackageContentResponse) SetSupportedPlatform(v string) {
	o.SupportedPlatform = &v
}

// GetRequiresDist returns the RequiresDist field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetRequiresDist() map[string]interface{} {
	if o == nil || IsNil(o.RequiresDist) {
		var ret map[string]interface{}
		return ret
	}
	return o.RequiresDist
}

// GetRequiresDistOk returns a tuple with the RequiresDist field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetRequiresDistOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.RequiresDist) {
		return map[string]interface{}{}, false
	}
	return o.RequiresDist, true
}

// HasRequiresDist returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasRequiresDist() bool {
	if o != nil && !IsNil(o.RequiresDist) {
		return true
	}

	return false
}

// SetRequiresDist gets a reference to the given map[string]interface{} and assigns it to the RequiresDist field.
func (o *PythonPythonPackageContentResponse) SetRequiresDist(v map[string]interface{}) {
	o.RequiresDist = v
}

// GetProvidesDist returns the ProvidesDist field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetProvidesDist() map[string]interface{} {
	if o == nil || IsNil(o.ProvidesDist) {
		var ret map[string]interface{}
		return ret
	}
	return o.ProvidesDist
}

// GetProvidesDistOk returns a tuple with the ProvidesDist field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetProvidesDistOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.ProvidesDist) {
		return map[string]interface{}{}, false
	}
	return o.ProvidesDist, true
}

// HasProvidesDist returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasProvidesDist() bool {
	if o != nil && !IsNil(o.ProvidesDist) {
		return true
	}

	return false
}

// SetProvidesDist gets a reference to the given map[string]interface{} and assigns it to the ProvidesDist field.
func (o *PythonPythonPackageContentResponse) SetProvidesDist(v map[string]interface{}) {
	o.ProvidesDist = v
}

// GetObsoletesDist returns the ObsoletesDist field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetObsoletesDist() map[string]interface{} {
	if o == nil || IsNil(o.ObsoletesDist) {
		var ret map[string]interface{}
		return ret
	}
	return o.ObsoletesDist
}

// GetObsoletesDistOk returns a tuple with the ObsoletesDist field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetObsoletesDistOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.ObsoletesDist) {
		return map[string]interface{}{}, false
	}
	return o.ObsoletesDist, true
}

// HasObsoletesDist returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasObsoletesDist() bool {
	if o != nil && !IsNil(o.ObsoletesDist) {
		return true
	}

	return false
}

// SetObsoletesDist gets a reference to the given map[string]interface{} and assigns it to the ObsoletesDist field.
func (o *PythonPythonPackageContentResponse) SetObsoletesDist(v map[string]interface{}) {
	o.ObsoletesDist = v
}

// GetRequiresExternal returns the RequiresExternal field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetRequiresExternal() map[string]interface{} {
	if o == nil || IsNil(o.RequiresExternal) {
		var ret map[string]interface{}
		return ret
	}
	return o.RequiresExternal
}

// GetRequiresExternalOk returns a tuple with the RequiresExternal field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetRequiresExternalOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.RequiresExternal) {
		return map[string]interface{}{}, false
	}
	return o.RequiresExternal, true
}

// HasRequiresExternal returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasRequiresExternal() bool {
	if o != nil && !IsNil(o.RequiresExternal) {
		return true
	}

	return false
}

// SetRequiresExternal gets a reference to the given map[string]interface{} and assigns it to the RequiresExternal field.
func (o *PythonPythonPackageContentResponse) SetRequiresExternal(v map[string]interface{}) {
	o.RequiresExternal = v
}

// GetClassifiers returns the Classifiers field value if set, zero value otherwise.
func (o *PythonPythonPackageContentResponse) GetClassifiers() map[string]interface{} {
	if o == nil || IsNil(o.Classifiers) {
		var ret map[string]interface{}
		return ret
	}
	return o.Classifiers
}

// GetClassifiersOk returns a tuple with the Classifiers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *PythonPythonPackageContentResponse) GetClassifiersOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Classifiers) {
		return map[string]interface{}{}, false
	}
	return o.Classifiers, true
}

// HasClassifiers returns a boolean if a field has been set.
func (o *PythonPythonPackageContentResponse) HasClassifiers() bool {
	if o != nil && !IsNil(o.Classifiers) {
		return true
	}

	return false
}

// SetClassifiers gets a reference to the given map[string]interface{} and assigns it to the Classifiers field.
func (o *PythonPythonPackageContentResponse) SetClassifiers(v map[string]interface{}) {
	o.Classifiers = v
}

func (o PythonPythonPackageContentResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PythonPythonPackageContentResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.PulpHref) {
		toSerialize["pulp_href"] = o.PulpHref
	}
	if !IsNil(o.PulpCreated) {
		toSerialize["pulp_created"] = o.PulpCreated
	}
	if !IsNil(o.Artifact) {
		toSerialize["artifact"] = o.Artifact
	}
	if !IsNil(o.Filename) {
		toSerialize["filename"] = o.Filename
	}
	if !IsNil(o.Packagetype) {
		toSerialize["packagetype"] = o.Packagetype
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if !IsNil(o.Version) {
		toSerialize["version"] = o.Version
	}
	if !IsNil(o.Sha256) {
		toSerialize["sha256"] = o.Sha256
	}
	if !IsNil(o.MetadataVersion) {
		toSerialize["metadata_version"] = o.MetadataVersion
	}
	if !IsNil(o.Summary) {
		toSerialize["summary"] = o.Summary
	}
	if !IsNil(o.Description) {
		toSerialize["description"] = o.Description
	}
	if !IsNil(o.DescriptionContentType) {
		toSerialize["description_content_type"] = o.DescriptionContentType
	}
	if !IsNil(o.Keywords) {
		toSerialize["keywords"] = o.Keywords
	}
	if !IsNil(o.HomePage) {
		toSerialize["home_page"] = o.HomePage
	}
	if !IsNil(o.DownloadUrl) {
		toSerialize["download_url"] = o.DownloadUrl
	}
	if !IsNil(o.Author) {
		toSerialize["author"] = o.Author
	}
	if !IsNil(o.AuthorEmail) {
		toSerialize["author_email"] = o.AuthorEmail
	}
	if !IsNil(o.Maintainer) {
		toSerialize["maintainer"] = o.Maintainer
	}
	if !IsNil(o.MaintainerEmail) {
		toSerialize["maintainer_email"] = o.MaintainerEmail
	}
	if !IsNil(o.License) {
		toSerialize["license"] = o.License
	}
	if !IsNil(o.RequiresPython) {
		toSerialize["requires_python"] = o.RequiresPython
	}
	if !IsNil(o.ProjectUrl) {
		toSerialize["project_url"] = o.ProjectUrl
	}
	if !IsNil(o.ProjectUrls) {
		toSerialize["project_urls"] = o.ProjectUrls
	}
	if !IsNil(o.Platform) {
		toSerialize["platform"] = o.Platform
	}
	if !IsNil(o.SupportedPlatform) {
		toSerialize["supported_platform"] = o.SupportedPlatform
	}
	if !IsNil(o.RequiresDist) {
		toSerialize["requires_dist"] = o.RequiresDist
	}
	if !IsNil(o.ProvidesDist) {
		toSerialize["provides_dist"] = o.ProvidesDist
	}
	if !IsNil(o.ObsoletesDist) {
		toSerialize["obsoletes_dist"] = o.ObsoletesDist
	}
	if !IsNil(o.RequiresExternal) {
		toSerialize["requires_external"] = o.RequiresExternal
	}
	if !IsNil(o.Classifiers) {
		toSerialize["classifiers"] = o.Classifiers
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PythonPythonPackageContentResponse) UnmarshalJSON(bytes []byte) (err error) {
	varPythonPythonPackageContentResponse := _PythonPythonPackageContentResponse{}

	if err = json.Unmarshal(bytes, &varPythonPythonPackageContentResponse); err == nil {
		*o = PythonPythonPackageContentResponse(varPythonPythonPackageContentResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "pulp_href")
		delete(additionalProperties, "pulp_created")
		delete(additionalProperties, "artifact")
		delete(additionalProperties, "filename")
		delete(additionalProperties, "packagetype")
		delete(additionalProperties, "name")
		delete(additionalProperties, "version")
		delete(additionalProperties, "sha256")
		delete(additionalProperties, "metadata_version")
		delete(additionalProperties, "summary")
		delete(additionalProperties, "description")
		delete(additionalProperties, "description_content_type")
		delete(additionalProperties, "keywords")
		delete(additionalProperties, "home_page")
		delete(additionalProperties, "download_url")
		delete(additionalProperties, "author")
		delete(additionalProperties, "author_email")
		delete(additionalProperties, "maintainer")
		delete(additionalProperties, "maintainer_email")
		delete(additionalProperties, "license")
		delete(additionalProperties, "requires_python")
		delete(additionalProperties, "project_url")
		delete(additionalProperties, "project_urls")
		delete(additionalProperties, "platform")
		delete(additionalProperties, "supported_platform")
		delete(additionalProperties, "requires_dist")
		delete(additionalProperties, "provides_dist")
		delete(additionalProperties, "obsoletes_dist")
		delete(additionalProperties, "requires_external")
		delete(additionalProperties, "classifiers")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePythonPythonPackageContentResponse struct {
	value *PythonPythonPackageContentResponse
	isSet bool
}

func (v NullablePythonPythonPackageContentResponse) Get() *PythonPythonPackageContentResponse {
	return v.value
}

func (v *NullablePythonPythonPackageContentResponse) Set(val *PythonPythonPackageContentResponse) {
	v.value = val
	v.isSet = true
}

func (v NullablePythonPythonPackageContentResponse) IsSet() bool {
	return v.isSet
}

func (v *NullablePythonPythonPackageContentResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePythonPythonPackageContentResponse(val *PythonPythonPackageContentResponse) *NullablePythonPythonPackageContentResponse {
	return &NullablePythonPythonPackageContentResponse{value: val, isSet: true}
}

func (v NullablePythonPythonPackageContentResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePythonPythonPackageContentResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


