/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"reflect"
)


// PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPI service
type PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService service

type PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService
	dependency *string
	deprecated *bool
	distribution *[]string
	distributionBasePath *[]string
	highest *bool
	isDeprecated *bool
	isHighest *bool
	isSigned *bool
	keywords *string
	limit *int32
	name *string
	namespace *string
	offset *int32
	orderBy *[]string
	q *string
	repository *[]string
	repositoryLabel *string
	repositoryName *[]string
	repositoryVersion *string
	signed *bool
	tags *string
	version *string
	versionRange *string
	fields *[]string
	excludeFields *[]string
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Dependency(dependency string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.dependency = &dependency
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Deprecated(deprecated bool) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.deprecated = &deprecated
	return r
}

// Filter collectionversions that are in these distrubtion ids.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Distribution(distribution []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.distribution = &distribution
	return r
}

// Filter collectionversions that are in these base paths.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) DistributionBasePath(distributionBasePath []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.distributionBasePath = &distributionBasePath
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Highest(highest bool) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.highest = &highest
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) IsDeprecated(isDeprecated bool) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.isDeprecated = &isDeprecated
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) IsHighest(isHighest bool) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.isHighest = &isHighest
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) IsSigned(isSigned bool) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.isSigned = &isSigned
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Keywords(keywords string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.keywords = &keywords
	return r
}

// Number of results to return per page.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Limit(limit int32) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.limit = &limit
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Name(name string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.name = &name
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Namespace(namespace string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.namespace = &namespace
	return r
}

// The initial index from which to return the results.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Offset(offset int32) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_created&#x60; - by CV created * &#x60;-pulp_created&#x60; - by CV created (descending) * &#x60;namespace&#x60; - by CV namespace * &#x60;-namespace&#x60; - by CV namespace (descending) * &#x60;name&#x60; - by CV name * &#x60;-name&#x60; - by CV name (descending) * &#x60;version&#x60; - by CV version * &#x60;-version&#x60; - by CV version (descending)
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) OrderBy(orderBy []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.orderBy = &orderBy
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Q(q string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.q = &q
	return r
}

// Filter collectionversions that are in these repository ids.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Repository(repository []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.repository = &repository
	return r
}

// Filter labels by search string
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) RepositoryLabel(repositoryLabel string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.repositoryLabel = &repositoryLabel
	return r
}

// Filter collectionversions that are in these repositories.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) RepositoryName(repositoryName []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.repositoryName = &repositoryName
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) RepositoryVersion(repositoryVersion string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Signed(signed bool) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.signed = &signed
	return r
}

// Filter by comma separate list of tags that must all be matched
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Tags(tags string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.tags = &tags
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Version(version string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.version = &version
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) VersionRange(versionRange string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.versionRange = &versionRange
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Fields(fields []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) Execute() (*PaginatedCollectionVersionSearchListResponseList, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsList Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsList

A viewset for cross-repo searches.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsList(ctx context.Context) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedCollectionVersionSearchListResponseList
func (a *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListExecute(r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsListRequest) (*PaginatedCollectionVersionSearchListResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedCollectionVersionSearchListResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/search/collection-versions/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.dependency != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "dependency", r.dependency, "")
	}
	if r.deprecated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "deprecated", r.deprecated, "")
	}
	if r.distribution != nil {
		t := *r.distribution
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "distribution", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "distribution", t, "multi")
		}
	}
	if r.distributionBasePath != nil {
		t := *r.distributionBasePath
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "distribution_base_path", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "distribution_base_path", t, "multi")
		}
	}
	if r.highest != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "highest", r.highest, "")
	}
	if r.isDeprecated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_deprecated", r.isDeprecated, "")
	}
	if r.isHighest != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_highest", r.isHighest, "")
	}
	if r.isSigned != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "is_signed", r.isSigned, "")
	}
	if r.keywords != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "keywords", r.keywords, "")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.namespace != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace", r.namespace, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.orderBy != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "order_by", r.orderBy, "csv")
	}
	if r.q != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "q", r.q, "")
	}
	if r.repository != nil {
		t := *r.repository
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "repository", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "repository", t, "multi")
		}
	}
	if r.repositoryLabel != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_label", r.repositoryLabel, "")
	}
	if r.repositoryName != nil {
		t := *r.repositoryName
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "repository_name", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "repository_name", t, "multi")
		}
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.signed != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "signed", r.signed, "")
	}
	if r.tags != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "tags", r.tags, "")
	}
	if r.version != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version", r.version, "")
	}
	if r.versionRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "version_range", r.versionRange, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService
	collectionVersionSearchList *CollectionVersionSearchList
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest) CollectionVersionSearchList(collectionVersionSearchList CollectionVersionSearchList) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest {
	r.collectionVersionSearchList = &collectionVersionSearchList
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest) Execute() (*CollectionVersionSearchListResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuild Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuild

A viewset for cross-repo searches.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuild(ctx context.Context) PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return CollectionVersionSearchListResponse
func (a *PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildExecute(r PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuildRequest) (*CollectionVersionSearchListResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *CollectionVersionSearchListResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleSearchCollectionVersionsAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleSearchCollectionVersionsRebuild")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/search/collection-versions/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.collectionVersionSearchList == nil {
		return localVarReturnValue, nil, reportError("collectionVersionSearchList is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.collectionVersionSearchList
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
