; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer -mtriple=riscv64 -mattr=+v \
; RUN: -riscv-v-vector-bits-min=128 -riscv-v-slp-max-vf=0 -S | FileCheck %s --check-prefixes=CHECK,CHECK-128
; RUN: opt < %s -passes=slp-vectorizer -mtriple=riscv64 -mattr=+v \
; RUN: -riscv-v-vector-bits-min=256 -riscv-v-slp-max-vf=0 -S | FileCheck %s --check-prefixes=CHECK,CHECK-256
; RUN: opt < %s -passes=slp-vectorizer -mtriple=riscv64 -mattr=+v \
; RUN: -riscv-v-vector-bits-min=512 -riscv-v-slp-max-vf=0 -S | FileCheck %s --check-prefixes=CHECK,CHECK-512

target datalayout = "e-m:e-p:64:64-i64:64-i128:128-n64-S128"
target triple = "riscv64"

define void @foo(ptr nocapture writeonly %da) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store <4 x i64> zeroinitializer, ptr [[DA:%.*]], align 8
; CHECK-NEXT:    ret void
;
entry:
  store i64 0, ptr %da, align 8
  %arrayidx1 = getelementptr inbounds i64, ptr %da, i64 1
  store i64 0, ptr %arrayidx1, align 8
  %arrayidx2 = getelementptr inbounds i64, ptr %da, i64 2
  store i64 0, ptr %arrayidx2, align 8
  %arrayidx3 = getelementptr inbounds i64, ptr %da, i64 3
  store i64 0, ptr %arrayidx3, align 8
  ret void
}

define void @foo8(ptr nocapture writeonly %da) {
; CHECK-LABEL: @foo8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i8 0, ptr [[DA:%.*]], align 8
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, ptr [[DA]], i8 1
; CHECK-NEXT:    store i8 0, ptr [[ARRAYIDX1]], align 8
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i8, ptr [[DA]], i8 2
; CHECK-NEXT:    ret void
;
entry:
  store i8 0, ptr %da, align 8
  %arrayidx1 = getelementptr inbounds i8, ptr %da, i8 1
  store i8 0, ptr %arrayidx1, align 8
  %arrayidx2 = getelementptr inbounds i8, ptr %da, i8 2
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-128: {{.*}}
; CHECK-256: {{.*}}
; CHECK-512: {{.*}}
