/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPTLSSocketFactory;
import netscape.ldap.LDAPUrl;

class LDAPConnSetupMgr
implements Serializable {
    static final long serialVersionUID = 1519402748245755307L;
    private static final int SERIAL = 0;
    private static final int PARALLEL = 1;
    private static final int CONNECTED = 0;
    private static final int DISCONNECTED = 1;
    private static final int NEVER_USED = 2;
    private static final int INTERRUPTED = 3;
    private static final int FAILED = 4;
    private Socket m_socket = null;
    private Socket m_origSocket = null;
    private LDAPException m_connException = null;
    ServerEntry[] m_dsList;
    private int m_dsIdx = -1;
    LDAPSocketFactory m_factory;
    int m_policy = 0;
    int m_connSetupDelay = -1;
    int m_connectTimeout = 0;
    private transient int m_attemptCnt = 0;

    LDAPConnSetupMgr(String[] hosts, int[] ports, LDAPSocketFactory factory) throws LDAPException {
        this.m_dsList = new ServerEntry[hosts.length];
        boolean secure = factory != null;
        for (int i = 0; i < hosts.length; ++i) {
            Object url = secure ? "ldaps://" : "ldap://";
            url = (String)url + hosts[i] + ":" + ports[i];
            try {
                this.m_dsList[i] = new ServerEntry(new LDAPUrl((String)url), 2);
                continue;
            }
            catch (MalformedURLException ex) {
                throw new LDAPException("Invalid host:port " + hosts[i] + ":" + ports[i], 89);
            }
        }
        this.m_factory = factory;
    }

    LDAPConnSetupMgr(String[] urls, LDAPSocketFactory factory) throws LDAPException {
        this.m_dsList = new ServerEntry[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                LDAPUrl url = new LDAPUrl(urls[i]);
                this.m_dsList[i] = new ServerEntry(url, 2);
                continue;
            }
            catch (MalformedURLException ex) {
                throw new LDAPException("Malformed LDAP URL " + urls[i], 89);
            }
        }
        this.m_factory = factory;
    }

    LDAPConnSetupMgr(LDAPUrl[] urls, LDAPSocketFactory factory) throws LDAPException {
        this.m_dsList = new ServerEntry[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            this.m_dsList[i] = new ServerEntry(urls[i], 2);
        }
        this.m_factory = factory;
    }

    synchronized Socket openConnection() throws LDAPException {
        long tcur = 0L;
        long tmax = Long.MAX_VALUE;
        Thread th = null;
        this.reset();
        this.sortDsList();
        if (this.m_connectTimeout == 0) {
            this.connect();
        } else {
            tmax = System.currentTimeMillis() + (long)this.m_connectTimeout;
            th = new Thread(new Runnable(){

                @Override
                public void run() {
                    LDAPConnSetupMgr.this.connect();
                }
            }, "ConnSetupMgr");
            th.setDaemon(true);
            th.start();
            while (this.m_socket == null && this.m_attemptCnt < this.m_dsList.length && (tcur = System.currentTimeMillis()) < tmax) {
                try {
                    this.wait(tmax - tcur);
                }
                catch (InterruptedException e) {
                    th.interrupt();
                    this.cleanup();
                    throw new LDAPInterruptedException("Interrupted connect operation");
                }
            }
        }
        if (this.m_socket != null) {
            return this.m_socket;
        }
        if (th != null && (tcur = System.currentTimeMillis()) >= tmax) {
            th.interrupt();
            this.cleanup();
            throw new LDAPException("Connect timeout, " + this.getServerList() + " might be unreachable", 91);
        }
        if (this.m_connException != null && this.m_dsList.length == 1) {
            throw this.m_connException;
        }
        throw new LDAPException("Failed to connect to server " + this.getServerList(), 91);
    }

    private void reset() {
        this.m_socket = null;
        this.m_origSocket = null;
        this.m_connException = null;
        this.m_attemptCnt = 0;
        for (int i = 0; i < this.m_dsList.length; ++i) {
            this.m_dsList[i].connSetupThread = null;
        }
    }

    private String getServerList() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.m_dsList.length; ++i) {
            sb.append(i == 0 ? "" : " ");
            sb.append(this.m_dsList[i].url.getHost());
            sb.append(":");
            sb.append(this.m_dsList[i].url.getPort());
        }
        return sb.toString();
    }

    private void connect() {
        if (this.m_policy == 0 || this.m_dsList.length == 1) {
            this.openSerial();
        } else {
            this.openParallel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void invalidateConnection() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 4;
            int srvCnt = this.m_dsList.length;
            int j = 0;
            ServerEntry[] newDsList = new ServerEntry[this.m_dsList.length];
            for (int i = 0; i < srvCnt; ++i) {
                if (i == this.m_dsIdx) continue;
                newDsList[j++] = this.m_dsList[i];
            }
            newDsList[j] = this.m_dsList[this.m_dsIdx];
            this.m_dsList = newDsList;
            this.m_dsIdx = j;
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_socket = null;
            }
        }
        if (this.m_origSocket != null) {
            try {
                this.m_origSocket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_origSocket = null;
            }
        }
    }

    void closeConnection() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 1;
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_socket = null;
            }
        }
        if (this.m_origSocket != null) {
            try {
                this.m_origSocket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_origSocket = null;
            }
        }
    }

    Socket getSocket() {
        return this.m_socket;
    }

    void layerSocket(LDAPTLSSocketFactory factory) throws LDAPException {
        Socket s = factory.makeSocket(this.m_socket);
        this.m_origSocket = this.m_socket;
        this.m_socket = s;
    }

    String getHost() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].url.getHost();
        }
        return this.m_dsList[0].url.getHost();
    }

    int getPort() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].url.getPort();
        }
        return this.m_dsList[0].url.getPort();
    }

    boolean isSecure() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].url.isSecure();
        }
        return this.m_dsList[0].url.isSecure();
    }

    LDAPUrl getLDAPUrl() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].url;
        }
        return this.m_dsList[0].url;
    }

    int getConnSetupDelay() {
        return this.m_connSetupDelay / 1000;
    }

    void setConnSetupDelay(int delay) {
        this.m_policy = delay < 0 ? 0 : 1;
        this.m_connSetupDelay = delay * 1000;
    }

    int getConnectTimeout() {
        return this.m_connectTimeout / 1000;
    }

    void setConnectTimeout(int timeout) {
        this.m_connectTimeout = timeout * 1000;
    }

    boolean isUserDisconnected() {
        return this.m_dsIdx >= 0 && this.m_dsList[this.m_dsIdx].connSetupStatus == 1;
    }

    private void openSerial() {
        for (int i = 0; i < this.m_dsList.length; ++i) {
            this.m_dsList[i].connSetupThread = Thread.currentThread();
            this.connectServer(i);
            if (this.m_socket == null) continue;
            return;
        }
    }

    private synchronized void openParallel() {
        for (int i = 0; this.m_socket == null && i < this.m_dsList.length; ++i) {
            Thread t;
            final int dsIdx = i;
            String threadName = "ConnSetupMgr " + this.m_dsList[dsIdx].url;
            this.m_dsList[dsIdx].connSetupThread = t = new Thread(new Runnable(){

                @Override
                public void run() {
                    LDAPConnSetupMgr.this.connectServer(dsIdx);
                }
            }, threadName);
            t.setDaemon(true);
            t.start();
            if (this.m_connSetupDelay == 0 || i >= this.m_dsList.length - 1) continue;
            try {
                this.wait(this.m_connSetupDelay);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
        }
        while (this.m_socket == null && this.m_attemptCnt < this.m_dsList.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectServer(int idx) {
        ServerEntry entry = this.m_dsList[idx];
        Thread currThread = Thread.currentThread();
        Socket sock = null;
        LDAPException conex = null;
        try {
            if (!entry.url.isSecure()) {
                sock = new Socket(entry.url.getHost(), entry.url.getPort());
            } else {
                LDAPSocketFactory factory = this.m_factory;
                if (factory == null) {
                    factory = LDAPUrl.getSocketFactory();
                }
                if (factory == null) {
                    throw new LDAPException("Can not connect, no socket factory " + entry.url, 80);
                }
                sock = factory.makeSocket(entry.url.getHost(), entry.url.getPort());
            }
            sock.setTcpNoDelay(true);
        }
        catch (IOException e) {
            conex = new LDAPException("failed to connect to server " + entry.url, 91);
        }
        catch (LDAPException e) {
            conex = e;
        }
        if (currThread.isInterrupted()) {
            return;
        }
        LDAPConnSetupMgr lDAPConnSetupMgr = this;
        synchronized (lDAPConnSetupMgr) {
            if (this.m_socket == null && entry.connSetupThread == currThread) {
                entry.connSetupThread = null;
                if (sock != null) {
                    entry.connSetupStatus = 0;
                    this.m_socket = sock;
                    this.m_dsIdx = idx;
                    this.cleanup();
                } else {
                    entry.connSetupStatus = 4;
                    this.m_connException = conex;
                }
                ++this.m_attemptCnt;
                this.notifyAll();
            }
        }
    }

    private synchronized void cleanup() {
        Thread currThread = Thread.currentThread();
        for (int i = 0; i < this.m_dsList.length; ++i) {
            ServerEntry entry = this.m_dsList[i];
            if (entry.connSetupThread == null || entry.connSetupThread == currThread) continue;
            entry.connSetupStatus = 3;
            entry.connSetupThread.interrupt();
            entry.connSetupThread = null;
        }
    }

    private void sortDsList() {
        int srvCnt = this.m_dsList.length;
        for (int i = 1; i < srvCnt; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.m_dsList[i].connSetupStatus >= this.m_dsList[j].connSetupStatus) continue;
                ServerEntry entry = this.m_dsList[j];
                this.m_dsList[j] = this.m_dsList[i];
                this.m_dsList[i] = entry;
            }
        }
    }

    boolean breakConnection() {
        try {
            this.m_socket.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        String str = "dsIdx=" + this.m_dsIdx + " dsList=";
        for (int i = 0; i < this.m_dsList.length; ++i) {
            str = str + this.m_dsList[i] + " ";
        }
        return str;
    }

    class ServerEntry {
        LDAPUrl url;
        int connSetupStatus;
        Thread connSetupThread;

        ServerEntry(LDAPUrl url, int status) {
            this.url = url;
            this.connSetupStatus = status;
            this.connSetupThread = null;
        }

        public String toString() {
            return "{" + this.url + " status=" + this.connSetupStatus + "}";
        }
    }
}

