/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.mozilla.jss.netscape.security.util.ASN1CharStrConvMap;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.BitArray;
import org.mozilla.jss.netscape.security.util.ByteArrayLexOrder;
import org.mozilla.jss.netscape.security.util.ByteArrayTagOrder;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();
    private Calendar gmtGregorianCalendar = null;

    public DerOutputStream(int size) {
        super(size);
    }

    public DerOutputStream() {
    }

    public void write(byte tag, byte[] buf) throws IOException {
        this.write(tag);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void write(byte tag, DerOutputStream out) throws IOException {
        this.write(tag);
        this.putLength(out.count);
        this.write(out.buf, 0, out.count);
    }

    public void writeImplicit(byte tag, DerOutputStream value) throws IOException {
        this.write(tag);
        this.write(value.buf, 1, value.count - 1);
    }

    public void putDerValue(DerValue val) throws IOException {
        val.encode(this);
    }

    public void putBoolean(boolean val) throws IOException {
        this.write(1);
        this.putLength(1);
        if (val) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putInteger(BigInt i) throws IOException {
        this.putUnsignedInteger(i.toByteArray());
    }

    public void putUnsignedInteger(byte[] integerBytes) throws IOException {
        this.write(2);
        if ((integerBytes[0] & 0x80) != 0) {
            this.putLength(integerBytes.length + 1);
            this.write(0);
        } else {
            this.putLength(integerBytes.length);
        }
        this.write(integerBytes, 0, integerBytes.length);
    }

    public void putEnumerated(int i) throws IOException {
        this.write(10);
        int bytemask = -16777216;
        int signmask = Integer.MIN_VALUE;
        if ((i & Integer.MIN_VALUE) != 0) {
            int length;
            for (length = 4; length > 1 && (i & bytemask) == bytemask; --length) {
                bytemask >>>= 8;
                signmask >>>= 8;
            }
            if ((i & signmask) == 0) {
                this.putLength(length + 1);
                this.write(255);
            } else {
                this.putLength(length);
            }
            switch (length) {
                case 4: {
                    this.write((byte)(i >>> 24));
                }
                case 3: {
                    this.write((byte)(i >>> 16));
                }
                case 2: {
                    this.write((byte)(i >>> 8));
                }
                case 1: {
                    this.write((byte)i);
                }
            }
        } else {
            int length;
            for (length = 4; length > 1 && (i & bytemask) == 0; --length) {
                bytemask >>>= 8;
                signmask >>>= 8;
            }
            if ((i & signmask) != 0) {
                this.putLength(length + 1);
                this.write(0);
            } else {
                this.putLength(length);
            }
            switch (length) {
                case 4: {
                    this.write((byte)(i >>> 24));
                }
                case 3: {
                    this.write((byte)(i >>> 16));
                }
                case 2: {
                    this.write((byte)(i >>> 8));
                }
                case 1: {
                    this.write((byte)i);
                }
            }
        }
    }

    public void putBitString(byte[] bits) throws IOException {
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(0);
        this.write(bits);
    }

    private static BitArray toBitArray(boolean[] bitString) {
        int i;
        if (bitString.length == 0) {
            return new BitArray(bitString);
        }
        for (i = bitString.length - 1; i >= 0 && !bitString[i]; --i) {
        }
        int length = i + 1;
        if (length != bitString.length) {
            boolean[] newBitString = new boolean[length];
            System.arraycopy(bitString, 0, newBitString, 0, length);
            bitString = newBitString;
        }
        return new BitArray(bitString);
    }

    private static BitArray toBitArray(byte[] bitString) {
        int i;
        int maxIndex = 0;
        if (bitString.length == 0) {
            return new BitArray(0, bitString);
        }
        for (i = 0; i < bitString.length; ++i) {
            if (bitString[i] == 0) continue;
            maxIndex = i;
        }
        byte lastByte = bitString[maxIndex];
        int length = (maxIndex + 1) * 8;
        for (i = 1; i <= 128 && (lastByte & i) == 0; i <<= 1) {
            --length;
        }
        return new BitArray(length, bitString);
    }

    public void putUnalignedBitString(BitArray ba) throws IOException {
        byte[] bits = ba.toByteArray();
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(bits.length * 8 - ba.length());
        this.write(bits);
    }

    public void putUnalignedBitString(byte[] bitString) throws IOException {
        this.putUnalignedBitString(DerOutputStream.toBitArray(bitString));
    }

    public void putUnalignedBitString(boolean[] bitString) throws IOException {
        this.putUnalignedBitString(DerOutputStream.toBitArray(bitString));
    }

    public void putOctetString(byte[] octets) throws IOException {
        this.write((byte)4, octets);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier oid) throws IOException {
        oid.encode(this);
    }

    public void putSequence(DerValue[] seq) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < seq.length; ++i) {
            seq[i].encode(bytes);
        }
        this.write((byte)48, bytes);
    }

    public void putSet(DerValue[] set) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < set.length; ++i) {
            set[i].encode(bytes);
        }
        this.write((byte)49, bytes);
    }

    public void putSet(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, null);
    }

    public void putOrderedSetOf(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, lexOrder);
    }

    public void putOrderedSet(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, tagOrder);
    }

    private void putOrderedSet(byte tag, DerEncoder[] set, Comparator<byte[]> order) throws IOException {
        DerOutputStream[] streams = new DerOutputStream[set.length];
        for (int i = 0; i < set.length; ++i) {
            streams[i] = new DerOutputStream();
            set[i].derEncode(streams[i]);
        }
        byte[][] bufs = new byte[streams.length][];
        for (int i = 0; i < streams.length; ++i) {
            bufs[i] = streams[i].toByteArray();
        }
        if (order != null) {
            Arrays.sort(bufs, order);
        }
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < streams.length; ++i) {
            bytes.write(bufs[i]);
        }
        this.write(tag, bytes);
    }

    public void putPrintableString(String s) throws IOException {
        this.putStringType((byte)19, s);
    }

    public void putVisibleString(String s) throws IOException {
        this.putStringType((byte)26, s);
    }

    public void putBMPString(String s) throws IOException {
        this.putStringType((byte)30, s);
    }

    public void putGeneralString(String s) throws IOException {
        this.putStringType((byte)27, s);
    }

    public void putIA5String(String s) throws IOException {
        this.putStringType((byte)22, s);
    }

    public void putUTF8String(String s) throws IOException {
        this.putStringType((byte)12, s);
    }

    public void putStringType(byte tag, String s) throws IOException {
        try {
            CharsetEncoder encoder = ASN1CharStrConvMap.getDefault().getEncoder(tag);
            if (encoder == null) {
                throw new IOException("No encoder for tag");
            }
            CharBuffer charBuffer = CharBuffer.wrap(s.toCharArray());
            ByteBuffer byteBuffer = encoder.encode(charBuffer);
            this.write(tag);
            this.putLength(byteBuffer.limit());
            this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
        }
        catch (CharacterCodingException e) {
            throw new IOException("Not a valid string type " + tag, e);
        }
    }

    private void put2DateBytes(byte[] buffer, int value, int offset) {
        int upper = value / 10;
        int lower = value % 10;
        buffer[offset] = (byte)((byte)upper + 48);
        buffer[offset + 1] = (byte)((byte)lower + 48);
    }

    private Calendar getGMTGregorianCalendar() {
        if (this.gmtGregorianCalendar == null) {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            this.gmtGregorianCalendar = new GregorianCalendar(tz);
        }
        return (Calendar)this.gmtGregorianCalendar.clone();
    }

    public byte[] getDateBytes(Date d, boolean UTC) {
        byte[] datebytes = UTC ? new byte[13] : new byte[15];
        Calendar cal = this.getGMTGregorianCalendar();
        cal.setTime(d);
        int i = 0;
        if (!UTC) {
            this.put2DateBytes(datebytes, cal.get(1) / 100, i);
            i += 2;
        }
        this.put2DateBytes(datebytes, cal.get(1) % 100, i);
        this.put2DateBytes(datebytes, cal.get(2) + 1, i += 2);
        this.put2DateBytes(datebytes, cal.get(5), i += 2);
        this.put2DateBytes(datebytes, cal.get(11), i += 2);
        this.put2DateBytes(datebytes, cal.get(12), i += 2);
        this.put2DateBytes(datebytes, cal.get(13), i += 2);
        datebytes[i += 2] = 90;
        return datebytes;
    }

    public void putUTCTime(Date d) throws IOException {
        byte[] datebytes = this.getDateBytes(d, true);
        this.write(23);
        this.putLength(datebytes.length);
        this.write(datebytes);
    }

    public void putGeneralizedTime(Date d) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyyyMMddHHmmss'Z'";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(tz);
        byte[] gt = sdf.format(d).getBytes();
        this.write(24);
        this.putLength(gt.length);
        this.write(gt);
    }

    public void putLength(int len) throws IOException {
        if (len < 128) {
            this.write((byte)len);
        } else if (len < 256) {
            this.write(-127);
            this.write((byte)len);
        } else if (len < 65536) {
            this.write(-126);
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else if (len < 0x1000000) {
            this.write(-125);
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else {
            this.write(-124);
            this.write((byte)(len >> 24));
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        }
    }

    public void putTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        this.write(tag);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }
}

