"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeExceptionsAPI = void 0;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var const_1 = require("./const");
function initializeExceptionsAPI(config, transports, metas, tracesApi) {
    var pushError = function (error, options) {
        var _a;
        if (options === void 0) { options = {}; }
        var type = options.type || error.name || const_1.defaultExceptionType;
        var stackFrames = (_a = options.stackFrames) !== null && _a !== void 0 ? _a : (error.stack && config.parseStacktrace ? config.parseStacktrace(error).frames : undefined);
        var item = {
            meta: metas.value,
            payload: {
                type: type,
                value: error.message,
                timestamp: (0, utils_1.getCurrentTimestamp)(),
                trace: tracesApi.getTraceContext(),
            },
            type: transports_1.TransportItemType.EXCEPTION,
        };
        if (stackFrames === null || stackFrames === void 0 ? void 0 : stackFrames.length) {
            item.payload.stacktrace = {
                frames: stackFrames,
            };
        }
        transports.execute(item);
    };
    return {
        pushError: pushError,
    };
}
exports.initializeExceptionsAPI = initializeExceptionsAPI;
//# sourceMappingURL=initialize.js.map