var React = require('react');
var data = require('@grafana/data');
var ReactDOM = require('react-dom');
var e2eSelectors = require('@grafana/e2e-selectors');
var tty = require('tty');
var util$2 = require('util');
var os$1 = require('os');
var moment = require('moment');
var crypto = require('crypto');
var $ = require('jquery');
var awsSdk = require('@grafana/aws-sdk');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () {
            return e[k];
          }
        });
      }
    });
  }
  n['default'] = e;
  return Object.freeze(n);
}

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var React__namespace = /*#__PURE__*/_interopNamespace(React);
var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);
var tty__default = /*#__PURE__*/_interopDefaultLegacy(tty);
var util__default = /*#__PURE__*/_interopDefaultLegacy(util$2);
var os__default = /*#__PURE__*/_interopDefaultLegacy(os$1);
var moment__default = /*#__PURE__*/_interopDefaultLegacy(moment);
var crypto__default = /*#__PURE__*/_interopDefaultLegacy(crypto);
var $__default = /*#__PURE__*/_interopDefaultLegacy($);

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

var inheritsLoose = _inheritsLoose;

/*

Based off glamor's StyleSheet, thanks Sunil ❤️

high performance StyleSheet for css-in-js systems

- uses multiple style tags behind the scenes for millions of rules
- uses `insertRule` for appending in production for *much* faster performance

// usage

import { StyleSheet } from '@emotion/sheet'

let styleSheet = new StyleSheet({ key: '', container: document.head })

styleSheet.insert('#box { border: 1px solid red; }')
- appends a css rule into the stylesheet

styleSheet.flush()
- empties the stylesheet of all its contents

*/
// $FlowFixMe
function sheetForTag(tag) {
  if (tag.sheet) {
    // $FlowFixMe
    return tag.sheet;
  } // this weirdness brought to you by firefox

  /* istanbul ignore next */


  for (var i = 0; i < document.styleSheets.length; i++) {
    if (document.styleSheets[i].ownerNode === tag) {
      // $FlowFixMe
      return document.styleSheets[i];
    }
  }
}

function createStyleElement(options) {
  var tag = document.createElement('style');
  tag.setAttribute('data-emotion', options.key);

  if (options.nonce !== undefined) {
    tag.setAttribute('nonce', options.nonce);
  }

  tag.appendChild(document.createTextNode(''));
  return tag;
}

var StyleSheet =
/*#__PURE__*/
function () {
  function StyleSheet(options) {
    this.isSpeedy = options.speedy === undefined ? process.env.NODE_ENV === 'production' : options.speedy;
    this.tags = [];
    this.ctr = 0;
    this.nonce = options.nonce; // key is the value of the data-emotion attribute, it's used to identify different sheets

    this.key = options.key;
    this.container = options.container;
    this.before = null;
  }

  var _proto = StyleSheet.prototype;

  _proto.insert = function insert(rule) {
    // the max length is how many rules we have per style tag, it's 65000 in speedy mode
    // it's 1 in dev because we insert source maps that map a single rule to a location
    // and you can only have one source map per style tag
    if (this.ctr % (this.isSpeedy ? 65000 : 1) === 0) {
      var _tag = createStyleElement(this);

      var before;

      if (this.tags.length === 0) {
        before = this.before;
      } else {
        before = this.tags[this.tags.length - 1].nextSibling;
      }

      this.container.insertBefore(_tag, before);
      this.tags.push(_tag);
    }

    var tag = this.tags[this.tags.length - 1];

    if (this.isSpeedy) {
      var sheet = sheetForTag(tag);

      try {
        // this is a really hot path
        // we check the second character first because having "i"
        // as the second character will happen less often than
        // having "@" as the first character
        var isImportRule = rule.charCodeAt(1) === 105 && rule.charCodeAt(0) === 64; // this is the ultrafast version, works across browsers
        // the big drawback is that the css won't be editable in devtools

        sheet.insertRule(rule, // we need to insert @import rules before anything else
        // otherwise there will be an error
        // technically this means that the @import rules will
        // _usually_(not always since there could be multiple style tags)
        // be the first ones in prod and generally later in dev
        // this shouldn't really matter in the real world though
        // @import is generally only used for font faces from google fonts and etc.
        // so while this could be technically correct then it would be slower and larger
        // for a tiny bit of correctness that won't matter in the real world
        isImportRule ? 0 : sheet.cssRules.length);
      } catch (e) {
        if (process.env.NODE_ENV !== 'production') {
          console.warn("There was a problem inserting the following rule: \"" + rule + "\"", e);
        }
      }
    } else {
      tag.appendChild(document.createTextNode(rule));
    }

    this.ctr++;
  };

  _proto.flush = function flush() {
    // $FlowFixMe
    this.tags.forEach(function (tag) {
      return tag.parentNode.removeChild(tag);
    });
    this.tags = [];
    this.ctr = 0;
  };

  return StyleSheet;
}();

function stylis_min (W) {
  function M(d, c, e, h, a) {
    for (var m = 0, b = 0, v = 0, n = 0, q, g, x = 0, K = 0, k, u = k = q = 0, l = 0, r = 0, I = 0, t = 0, B = e.length, J = B - 1, y, f = '', p = '', F = '', G = '', C; l < B;) {
      g = e.charCodeAt(l);
      l === J && 0 !== b + n + v + m && (0 !== b && (g = 47 === b ? 10 : 47), n = v = m = 0, B++, J++);

      if (0 === b + n + v + m) {
        if (l === J && (0 < r && (f = f.replace(N, '')), 0 < f.trim().length)) {
          switch (g) {
            case 32:
            case 9:
            case 59:
            case 13:
            case 10:
              break;

            default:
              f += e.charAt(l);
          }

          g = 59;
        }

        switch (g) {
          case 123:
            f = f.trim();
            q = f.charCodeAt(0);
            k = 1;

            for (t = ++l; l < B;) {
              switch (g = e.charCodeAt(l)) {
                case 123:
                  k++;
                  break;

                case 125:
                  k--;
                  break;

                case 47:
                  switch (g = e.charCodeAt(l + 1)) {
                    case 42:
                    case 47:
                      a: {
                        for (u = l + 1; u < J; ++u) {
                          switch (e.charCodeAt(u)) {
                            case 47:
                              if (42 === g && 42 === e.charCodeAt(u - 1) && l + 2 !== u) {
                                l = u + 1;
                                break a;
                              }

                              break;

                            case 10:
                              if (47 === g) {
                                l = u + 1;
                                break a;
                              }

                          }
                        }

                        l = u;
                      }

                  }

                  break;

                case 91:
                  g++;

                case 40:
                  g++;

                case 34:
                case 39:
                  for (; l++ < J && e.charCodeAt(l) !== g;) {
                  }

              }

              if (0 === k) break;
              l++;
            }

            k = e.substring(t, l);
            0 === q && (q = (f = f.replace(ca, '').trim()).charCodeAt(0));

            switch (q) {
              case 64:
                0 < r && (f = f.replace(N, ''));
                g = f.charCodeAt(1);

                switch (g) {
                  case 100:
                  case 109:
                  case 115:
                  case 45:
                    r = c;
                    break;

                  default:
                    r = O;
                }

                k = M(c, r, k, g, a + 1);
                t = k.length;
                0 < A && (r = X(O, f, I), C = H(3, k, r, c, D, z, t, g, a, h), f = r.join(''), void 0 !== C && 0 === (t = (k = C.trim()).length) && (g = 0, k = ''));
                if (0 < t) switch (g) {
                  case 115:
                    f = f.replace(da, ea);

                  case 100:
                  case 109:
                  case 45:
                    k = f + '{' + k + '}';
                    break;

                  case 107:
                    f = f.replace(fa, '$1 $2');
                    k = f + '{' + k + '}';
                    k = 1 === w || 2 === w && L('@' + k, 3) ? '@-webkit-' + k + '@' + k : '@' + k;
                    break;

                  default:
                    k = f + k, 112 === h && (k = (p += k, ''));
                } else k = '';
                break;

              default:
                k = M(c, X(c, f, I), k, h, a + 1);
            }

            F += k;
            k = I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
            break;

          case 125:
          case 59:
            f = (0 < r ? f.replace(N, '') : f).trim();
            if (1 < (t = f.length)) switch (0 === u && (q = f.charCodeAt(0), 45 === q || 96 < q && 123 > q) && (t = (f = f.replace(' ', ':')).length), 0 < A && void 0 !== (C = H(1, f, c, d, D, z, p.length, h, a, h)) && 0 === (t = (f = C.trim()).length) && (f = '\x00\x00'), q = f.charCodeAt(0), g = f.charCodeAt(1), q) {
              case 0:
                break;

              case 64:
                if (105 === g || 99 === g) {
                  G += f + e.charAt(l);
                  break;
                }

              default:
                58 !== f.charCodeAt(t - 1) && (p += P(f, q, g, f.charCodeAt(2)));
            }
            I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
        }
      }

      switch (g) {
        case 13:
        case 10:
          47 === b ? b = 0 : 0 === 1 + q && 107 !== h && 0 < f.length && (r = 1, f += '\x00');
          0 < A * Y && H(0, f, c, d, D, z, p.length, h, a, h);
          z = 1;
          D++;
          break;

        case 59:
        case 125:
          if (0 === b + n + v + m) {
            z++;
            break;
          }

        default:
          z++;
          y = e.charAt(l);

          switch (g) {
            case 9:
            case 32:
              if (0 === n + m + b) switch (x) {
                case 44:
                case 58:
                case 9:
                case 32:
                  y = '';
                  break;

                default:
                  32 !== g && (y = ' ');
              }
              break;

            case 0:
              y = '\\0';
              break;

            case 12:
              y = '\\f';
              break;

            case 11:
              y = '\\v';
              break;

            case 38:
              0 === n + b + m && (r = I = 1, y = '\f' + y);
              break;

            case 108:
              if (0 === n + b + m + E && 0 < u) switch (l - u) {
                case 2:
                  112 === x && 58 === e.charCodeAt(l - 3) && (E = x);

                case 8:
                  111 === K && (E = K);
              }
              break;

            case 58:
              0 === n + b + m && (u = l);
              break;

            case 44:
              0 === b + v + n + m && (r = 1, y += '\r');
              break;

            case 34:
            case 39:
              0 === b && (n = n === g ? 0 : 0 === n ? g : n);
              break;

            case 91:
              0 === n + b + v && m++;
              break;

            case 93:
              0 === n + b + v && m--;
              break;

            case 41:
              0 === n + b + m && v--;
              break;

            case 40:
              if (0 === n + b + m) {
                if (0 === q) switch (2 * x + 3 * K) {
                  case 533:
                    break;

                  default:
                    q = 1;
                }
                v++;
              }

              break;

            case 64:
              0 === b + v + n + m + u + k && (k = 1);
              break;

            case 42:
            case 47:
              if (!(0 < n + m + v)) switch (b) {
                case 0:
                  switch (2 * g + 3 * e.charCodeAt(l + 1)) {
                    case 235:
                      b = 47;
                      break;

                    case 220:
                      t = l, b = 42;
                  }

                  break;

                case 42:
                  47 === g && 42 === x && t + 2 !== l && (33 === e.charCodeAt(t + 2) && (p += e.substring(t, l + 1)), y = '', b = 0);
              }
          }

          0 === b && (f += y);
      }

      K = x;
      x = g;
      l++;
    }

    t = p.length;

    if (0 < t) {
      r = c;
      if (0 < A && (C = H(2, p, r, d, D, z, t, h, a, h), void 0 !== C && 0 === (p = C).length)) return G + p + F;
      p = r.join(',') + '{' + p + '}';

      if (0 !== w * E) {
        2 !== w || L(p, 2) || (E = 0);

        switch (E) {
          case 111:
            p = p.replace(ha, ':-moz-$1') + p;
            break;

          case 112:
            p = p.replace(Q, '::-webkit-input-$1') + p.replace(Q, '::-moz-$1') + p.replace(Q, ':-ms-input-$1') + p;
        }

        E = 0;
      }
    }

    return G + p + F;
  }

  function X(d, c, e) {
    var h = c.trim().split(ia);
    c = h;
    var a = h.length,
        m = d.length;

    switch (m) {
      case 0:
      case 1:
        var b = 0;

        for (d = 0 === m ? '' : d[0] + ' '; b < a; ++b) {
          c[b] = Z(d, c[b], e).trim();
        }

        break;

      default:
        var v = b = 0;

        for (c = []; b < a; ++b) {
          for (var n = 0; n < m; ++n) {
            c[v++] = Z(d[n] + ' ', h[b], e).trim();
          }
        }

    }

    return c;
  }

  function Z(d, c, e) {
    var h = c.charCodeAt(0);
    33 > h && (h = (c = c.trim()).charCodeAt(0));

    switch (h) {
      case 38:
        return c.replace(F, '$1' + d.trim());

      case 58:
        return d.trim() + c.replace(F, '$1' + d.trim());

      default:
        if (0 < 1 * e && 0 < c.indexOf('\f')) return c.replace(F, (58 === d.charCodeAt(0) ? '' : '$1') + d.trim());
    }

    return d + c;
  }

  function P(d, c, e, h) {
    var a = d + ';',
        m = 2 * c + 3 * e + 4 * h;

    if (944 === m) {
      d = a.indexOf(':', 9) + 1;
      var b = a.substring(d, a.length - 1).trim();
      b = a.substring(0, d).trim() + b + ';';
      return 1 === w || 2 === w && L(b, 1) ? '-webkit-' + b + b : b;
    }

    if (0 === w || 2 === w && !L(a, 1)) return a;

    switch (m) {
      case 1015:
        return 97 === a.charCodeAt(10) ? '-webkit-' + a + a : a;

      case 951:
        return 116 === a.charCodeAt(3) ? '-webkit-' + a + a : a;

      case 963:
        return 110 === a.charCodeAt(5) ? '-webkit-' + a + a : a;

      case 1009:
        if (100 !== a.charCodeAt(4)) break;

      case 969:
      case 942:
        return '-webkit-' + a + a;

      case 978:
        return '-webkit-' + a + '-moz-' + a + a;

      case 1019:
      case 983:
        return '-webkit-' + a + '-moz-' + a + '-ms-' + a + a;

      case 883:
        if (45 === a.charCodeAt(8)) return '-webkit-' + a + a;
        if (0 < a.indexOf('image-set(', 11)) return a.replace(ja, '$1-webkit-$2') + a;
        break;

      case 932:
        if (45 === a.charCodeAt(4)) switch (a.charCodeAt(5)) {
          case 103:
            return '-webkit-box-' + a.replace('-grow', '') + '-webkit-' + a + '-ms-' + a.replace('grow', 'positive') + a;

          case 115:
            return '-webkit-' + a + '-ms-' + a.replace('shrink', 'negative') + a;

          case 98:
            return '-webkit-' + a + '-ms-' + a.replace('basis', 'preferred-size') + a;
        }
        return '-webkit-' + a + '-ms-' + a + a;

      case 964:
        return '-webkit-' + a + '-ms-flex-' + a + a;

      case 1023:
        if (99 !== a.charCodeAt(8)) break;
        b = a.substring(a.indexOf(':', 15)).replace('flex-', '').replace('space-between', 'justify');
        return '-webkit-box-pack' + b + '-webkit-' + a + '-ms-flex-pack' + b + a;

      case 1005:
        return ka.test(a) ? a.replace(aa, ':-webkit-') + a.replace(aa, ':-moz-') + a : a;

      case 1e3:
        b = a.substring(13).trim();
        c = b.indexOf('-') + 1;

        switch (b.charCodeAt(0) + b.charCodeAt(c)) {
          case 226:
            b = a.replace(G, 'tb');
            break;

          case 232:
            b = a.replace(G, 'tb-rl');
            break;

          case 220:
            b = a.replace(G, 'lr');
            break;

          default:
            return a;
        }

        return '-webkit-' + a + '-ms-' + b + a;

      case 1017:
        if (-1 === a.indexOf('sticky', 9)) break;

      case 975:
        c = (a = d).length - 10;
        b = (33 === a.charCodeAt(c) ? a.substring(0, c) : a).substring(d.indexOf(':', 7) + 1).trim();

        switch (m = b.charCodeAt(0) + (b.charCodeAt(7) | 0)) {
          case 203:
            if (111 > b.charCodeAt(8)) break;

          case 115:
            a = a.replace(b, '-webkit-' + b) + ';' + a;
            break;

          case 207:
          case 102:
            a = a.replace(b, '-webkit-' + (102 < m ? 'inline-' : '') + 'box') + ';' + a.replace(b, '-webkit-' + b) + ';' + a.replace(b, '-ms-' + b + 'box') + ';' + a;
        }

        return a + ';';

      case 938:
        if (45 === a.charCodeAt(5)) switch (a.charCodeAt(6)) {
          case 105:
            return b = a.replace('-items', ''), '-webkit-' + a + '-webkit-box-' + b + '-ms-flex-' + b + a;

          case 115:
            return '-webkit-' + a + '-ms-flex-item-' + a.replace(ba, '') + a;

          default:
            return '-webkit-' + a + '-ms-flex-line-pack' + a.replace('align-content', '').replace(ba, '') + a;
        }
        break;

      case 973:
      case 989:
        if (45 !== a.charCodeAt(3) || 122 === a.charCodeAt(4)) break;

      case 931:
      case 953:
        if (!0 === la.test(d)) return 115 === (b = d.substring(d.indexOf(':') + 1)).charCodeAt(0) ? P(d.replace('stretch', 'fill-available'), c, e, h).replace(':fill-available', ':stretch') : a.replace(b, '-webkit-' + b) + a.replace(b, '-moz-' + b.replace('fill-', '')) + a;
        break;

      case 962:
        if (a = '-webkit-' + a + (102 === a.charCodeAt(5) ? '-ms-' + a : '') + a, 211 === e + h && 105 === a.charCodeAt(13) && 0 < a.indexOf('transform', 10)) return a.substring(0, a.indexOf(';', 27) + 1).replace(ma, '$1-webkit-$2') + a;
    }

    return a;
  }

  function L(d, c) {
    var e = d.indexOf(1 === c ? ':' : '{'),
        h = d.substring(0, 3 !== c ? e : 10);
    e = d.substring(e + 1, d.length - 1);
    return R(2 !== c ? h : h.replace(na, '$1'), e, c);
  }

  function ea(d, c) {
    var e = P(c, c.charCodeAt(0), c.charCodeAt(1), c.charCodeAt(2));
    return e !== c + ';' ? e.replace(oa, ' or ($1)').substring(4) : '(' + c + ')';
  }

  function H(d, c, e, h, a, m, b, v, n, q) {
    for (var g = 0, x = c, w; g < A; ++g) {
      switch (w = S[g].call(B, d, x, e, h, a, m, b, v, n, q)) {
        case void 0:
        case !1:
        case !0:
        case null:
          break;

        default:
          x = w;
      }
    }

    if (x !== c) return x;
  }

  function T(d) {
    switch (d) {
      case void 0:
      case null:
        A = S.length = 0;
        break;

      default:
        if ('function' === typeof d) S[A++] = d;else if ('object' === typeof d) for (var c = 0, e = d.length; c < e; ++c) {
          T(d[c]);
        } else Y = !!d | 0;
    }

    return T;
  }

  function U(d) {
    d = d.prefix;
    void 0 !== d && (R = null, d ? 'function' !== typeof d ? w = 1 : (w = 2, R = d) : w = 0);
    return U;
  }

  function B(d, c) {
    var e = d;
    33 > e.charCodeAt(0) && (e = e.trim());
    V = e;
    e = [V];

    if (0 < A) {
      var h = H(-1, c, e, e, D, z, 0, 0, 0, 0);
      void 0 !== h && 'string' === typeof h && (c = h);
    }

    var a = M(O, e, c, 0, 0);
    0 < A && (h = H(-2, a, e, e, D, z, a.length, 0, 0, 0), void 0 !== h && (a = h));
    V = '';
    E = 0;
    z = D = 1;
    return a;
  }

  var ca = /^\0+/g,
      N = /[\0\r\f]/g,
      aa = /: */g,
      ka = /zoo|gra/,
      ma = /([,: ])(transform)/g,
      ia = /,\r+?/g,
      F = /([\t\r\n ])*\f?&/g,
      fa = /@(k\w+)\s*(\S*)\s*/,
      Q = /::(place)/g,
      ha = /:(read-only)/g,
      G = /[svh]\w+-[tblr]{2}/,
      da = /\(\s*(.*)\s*\)/g,
      oa = /([\s\S]*?);/g,
      ba = /-self|flex-/g,
      na = /[^]*?(:[rp][el]a[\w-]+)[^]*/,
      la = /stretch|:\s*\w+\-(?:conte|avail)/,
      ja = /([^-])(image-set\()/,
      z = 1,
      D = 1,
      E = 0,
      w = 1,
      O = [],
      S = [],
      A = 0,
      R = null,
      Y = 0,
      V = '';
  B.use = T;
  B.set = U;
  void 0 !== W && U(W);
  return B;
}

var weakMemoize = function weakMemoize(func) {
  // $FlowFixMe flow doesn't include all non-primitive types as allowed for weakmaps
  var cache = new WeakMap();
  return function (arg) {
    if (cache.has(arg)) {
      // $FlowFixMe
      return cache.get(arg);
    }

    var ret = func(arg);
    cache.set(arg, ret);
    return ret;
  };
};

// https://github.com/thysultan/stylis.js/tree/master/plugins/rule-sheet
// inlined to avoid umd wrapper and peerDep warnings/installing stylis
// since we use stylis after closure compiler
var delimiter = '/*|*/';
var needle = delimiter + '}';

function toSheet(block) {
  if (block) {
    Sheet.current.insert(block + '}');
  }
}

var Sheet = {
  current: null
};
var ruleSheet = function ruleSheet(context, content, selectors, parents, line, column, length, ns, depth, at) {
  switch (context) {
    // property
    case 1:
      {
        switch (content.charCodeAt(0)) {
          case 64:
            {
              // @import
              Sheet.current.insert(content + ';');
              return '';
            }
          // charcode for l

          case 108:
            {
              // charcode for b
              // this ignores label
              if (content.charCodeAt(2) === 98) {
                return '';
              }
            }
        }

        break;
      }
    // selector

    case 2:
      {
        if (ns === 0) return content + delimiter;
        break;
      }
    // at-rule

    case 3:
      {
        switch (ns) {
          // @font-face, @page
          case 102:
          case 112:
            {
              Sheet.current.insert(selectors[0] + content);
              return '';
            }

          default:
            {
              return content + (at === 0 ? delimiter : '');
            }
        }
      }

    case -2:
      {
        content.split(needle).forEach(toSheet);
      }
  }
};
var removeLabel = function removeLabel(context, content) {
  if (context === 1 && // charcode for l
  content.charCodeAt(0) === 108 && // charcode for b
  content.charCodeAt(2) === 98 // this ignores label
  ) {
      return '';
    }
};

var isBrowser = typeof document !== 'undefined';
var rootServerStylisCache = {};
var getServerStylisCache = isBrowser ? undefined : weakMemoize(function () {
  var getCache = weakMemoize(function () {
    return {};
  });
  var prefixTrueCache = {};
  var prefixFalseCache = {};
  return function (prefix) {
    if (prefix === undefined || prefix === true) {
      return prefixTrueCache;
    }

    if (prefix === false) {
      return prefixFalseCache;
    }

    return getCache(prefix);
  };
});

var createCache = function createCache(options) {
  if (options === undefined) options = {};
  var key = options.key || 'css';
  var stylisOptions;

  if (options.prefix !== undefined) {
    stylisOptions = {
      prefix: options.prefix
    };
  }

  var stylis = new stylis_min(stylisOptions);

  if (process.env.NODE_ENV !== 'production') {
    // $FlowFixMe
    if (/[^a-z-]/.test(key)) {
      throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
    }
  }

  var inserted = {}; // $FlowFixMe

  var container;

  if (isBrowser) {
    container = options.container || document.head;
    var nodes = document.querySelectorAll("style[data-emotion-" + key + "]");
    Array.prototype.forEach.call(nodes, function (node) {
      var attrib = node.getAttribute("data-emotion-" + key); // $FlowFixMe

      attrib.split(' ').forEach(function (id) {
        inserted[id] = true;
      });

      if (node.parentNode !== container) {
        container.appendChild(node);
      }
    });
  }

  var _insert;

  if (isBrowser) {
    stylis.use(options.stylisPlugins)(ruleSheet);

    _insert = function insert(selector, serialized, sheet, shouldCache) {
      var name = serialized.name;
      Sheet.current = sheet;

      if (process.env.NODE_ENV !== 'production' && serialized.map !== undefined) {
        var map = serialized.map;
        Sheet.current = {
          insert: function insert(rule) {
            sheet.insert(rule + map);
          }
        };
      }

      stylis(selector, serialized.styles);

      if (shouldCache) {
        cache.inserted[name] = true;
      }
    };
  } else {
    stylis.use(removeLabel);
    var serverStylisCache = rootServerStylisCache;

    if (options.stylisPlugins || options.prefix !== undefined) {
      stylis.use(options.stylisPlugins); // $FlowFixMe

      serverStylisCache = getServerStylisCache(options.stylisPlugins || rootServerStylisCache)(options.prefix);
    }

    var getRules = function getRules(selector, serialized) {
      var name = serialized.name;

      if (serverStylisCache[name] === undefined) {
        serverStylisCache[name] = stylis(selector, serialized.styles);
      }

      return serverStylisCache[name];
    };

    _insert = function _insert(selector, serialized, sheet, shouldCache) {
      var name = serialized.name;
      var rules = getRules(selector, serialized);

      if (cache.compat === undefined) {
        // in regular mode, we don't set the styles on the inserted cache
        // since we don't need to and that would be wasting memory
        // we return them so that they are rendered in a style tag
        if (shouldCache) {
          cache.inserted[name] = true;
        }

        if ( // using === development instead of !== production
        // because if people do ssr in tests, the source maps showing up would be annoying
        process.env.NODE_ENV === 'development' && serialized.map !== undefined) {
          return rules + serialized.map;
        }

        return rules;
      } else {
        // in compat mode, we put the styles on the inserted cache so
        // that emotion-server can pull out the styles
        // except when we don't want to cache it which was in Global but now
        // is nowhere but we don't want to do a major right now
        // and just in case we're going to leave the case here
        // it's also not affecting client side bundle size
        // so it's really not a big deal
        if (shouldCache) {
          cache.inserted[name] = rules;
        } else {
          return rules;
        }
      }
    };
  }

  if (process.env.NODE_ENV !== 'production') {
    // https://esbench.com/bench/5bf7371a4cd7e6009ef61d0a
    var commentStart = /\/\*/g;
    var commentEnd = /\*\//g;
    stylis.use(function (context, content) {
      switch (context) {
        case -1:
          {
            while (commentStart.test(content)) {
              commentEnd.lastIndex = commentStart.lastIndex;

              if (commentEnd.test(content)) {
                commentStart.lastIndex = commentEnd.lastIndex;
                continue;
              }

              throw new Error('Your styles have an unterminated comment ("/*" without corresponding "*/").');
            }

            commentStart.lastIndex = 0;
            break;
          }
      }
    });
    stylis.use(function (context, content, selectors) {
      switch (context) {
        case -1:
          {
            var flag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';
            var unsafePseudoClasses = content.match(/(:first|:nth|:nth-last)-child/g);

            if (unsafePseudoClasses && cache.compat !== true) {
              unsafePseudoClasses.forEach(function (unsafePseudoClass) {
                var ignoreRegExp = new RegExp(unsafePseudoClass + ".*\\/\\* " + flag + " \\*\\/");
                var ignore = ignoreRegExp.test(content);

                if (unsafePseudoClass && !ignore) {
                  console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
                }
              });
            }

            break;
          }
      }
    });
  }

  var cache = {
    key: key,
    sheet: new StyleSheet({
      key: key,
      container: container,
      nonce: options.nonce,
      speedy: options.speedy
    }),
    nonce: options.nonce,
    inserted: inserted,
    registered: {},
    insert: _insert
  };
  return cache;
};

var isBrowser$1 = typeof document !== 'undefined';
function getRegisteredStyles(registered, registeredStyles, classNames) {
  var rawClassName = '';
  classNames.split(' ').forEach(function (className) {
    if (registered[className] !== undefined) {
      registeredStyles.push(registered[className]);
    } else {
      rawClassName += className + " ";
    }
  });
  return rawClassName;
}
var insertStyles = function insertStyles(cache, serialized, isStringTag) {
  var className = cache.key + "-" + serialized.name;

  if ( // we only need to add the styles to the registered cache if the
  // class name could be used further down
  // the tree but if it's a string tag, we know it won't
  // so we don't have to add it to registered cache.
  // this improves memory usage since we can avoid storing the whole style string
  (isStringTag === false || // we need to always store it if we're in compat mode and
  // in node since emotion-server relies on whether a style is in
  // the registered cache to know whether a style is global or not
  // also, note that this check will be dead code eliminated in the browser
  isBrowser$1 === false && cache.compat !== undefined) && cache.registered[className] === undefined) {
    cache.registered[className] = serialized.styles;
  }

  if (cache.inserted[serialized.name] === undefined) {
    var stylesForSSR = '';
    var current = serialized;

    do {
      var maybeStyles = cache.insert("." + className, current, cache.sheet, true);

      if (!isBrowser$1 && maybeStyles !== undefined) {
        stylesForSSR += maybeStyles;
      }

      current = current.next;
    } while (current !== undefined);

    if (!isBrowser$1 && stylesForSSR.length !== 0) {
      return stylesForSSR;
    }
  }
};

/* eslint-disable */
// murmurhash2 via https://github.com/garycourt/murmurhash-js/blob/master/murmurhash2_gc.js
function murmurhash2_32_gc(str) {
  var l = str.length,
      h = l ^ l,
      i = 0,
      k;

  while (l >= 4) {
    k = str.charCodeAt(i) & 0xff | (str.charCodeAt(++i) & 0xff) << 8 | (str.charCodeAt(++i) & 0xff) << 16 | (str.charCodeAt(++i) & 0xff) << 24;
    k = (k & 0xffff) * 0x5bd1e995 + (((k >>> 16) * 0x5bd1e995 & 0xffff) << 16);
    k ^= k >>> 24;
    k = (k & 0xffff) * 0x5bd1e995 + (((k >>> 16) * 0x5bd1e995 & 0xffff) << 16);
    h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16) ^ k;
    l -= 4;
    ++i;
  }

  switch (l) {
    case 3:
      h ^= (str.charCodeAt(i + 2) & 0xff) << 16;

    case 2:
      h ^= (str.charCodeAt(i + 1) & 0xff) << 8;

    case 1:
      h ^= str.charCodeAt(i) & 0xff;
      h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16);
  }

  h ^= h >>> 13;
  h = (h & 0xffff) * 0x5bd1e995 + (((h >>> 16) * 0x5bd1e995 & 0xffff) << 16);
  h ^= h >>> 15;
  return (h >>> 0).toString(36);
}

var unitlessKeys = {
  animationIterationCount: 1,
  borderImageOutset: 1,
  borderImageSlice: 1,
  borderImageWidth: 1,
  boxFlex: 1,
  boxFlexGroup: 1,
  boxOrdinalGroup: 1,
  columnCount: 1,
  columns: 1,
  flex: 1,
  flexGrow: 1,
  flexPositive: 1,
  flexShrink: 1,
  flexNegative: 1,
  flexOrder: 1,
  gridRow: 1,
  gridRowEnd: 1,
  gridRowSpan: 1,
  gridRowStart: 1,
  gridColumn: 1,
  gridColumnEnd: 1,
  gridColumnSpan: 1,
  gridColumnStart: 1,
  msGridRow: 1,
  msGridRowSpan: 1,
  msGridColumn: 1,
  msGridColumnSpan: 1,
  fontWeight: 1,
  lineHeight: 1,
  opacity: 1,
  order: 1,
  orphans: 1,
  tabSize: 1,
  widows: 1,
  zIndex: 1,
  zoom: 1,
  WebkitLineClamp: 1,
  // SVG-related properties
  fillOpacity: 1,
  floodOpacity: 1,
  stopOpacity: 1,
  strokeDasharray: 1,
  strokeDashoffset: 1,
  strokeMiterlimit: 1,
  strokeOpacity: 1,
  strokeWidth: 1
};

function memoize(fn) {
  var cache = {};
  return function (arg) {
    if (cache[arg] === undefined) cache[arg] = fn(arg);
    return cache[arg];
  };
}

var ILLEGAL_ESCAPE_SEQUENCE_ERROR = "You have illegal escape sequence in your template literal, most likely inside content's property value.\nBecause you write your CSS inside a JavaScript string you actually have to do double escaping, so for example \"content: '\\00d7';\" should become \"content: '\\\\00d7';\".\nYou can read more about this here:\nhttps://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Template_literals#ES2018_revision_of_illegal_escape_sequences";
var UNDEFINED_AS_OBJECT_KEY_ERROR = "You have passed in falsy value as style object's key (can happen when in example you pass unexported component as computed key).";
var hyphenateRegex = /[A-Z]|^ms/g;
var animationRegex = /_EMO_([^_]+?)_([^]*?)_EMO_/g;

var isCustomProperty = function isCustomProperty(property) {
  return property.charCodeAt(1) === 45;
};

var isProcessableValue = function isProcessableValue(value) {
  return value != null && typeof value !== 'boolean';
};

var processStyleName = memoize(function (styleName) {
  return isCustomProperty(styleName) ? styleName : styleName.replace(hyphenateRegex, '-$&').toLowerCase();
});

var processStyleValue = function processStyleValue(key, value) {
  switch (key) {
    case 'animation':
    case 'animationName':
      {
        if (typeof value === 'string') {
          return value.replace(animationRegex, function (match, p1, p2) {
            cursor = {
              name: p1,
              styles: p2,
              next: cursor
            };
            return p1;
          });
        }
      }
  }

  if (unitlessKeys[key] !== 1 && !isCustomProperty(key) && typeof value === 'number' && value !== 0) {
    return value + 'px';
  }

  return value;
};

if (process.env.NODE_ENV !== 'production') {
  var contentValuePattern = /(attr|calc|counters?|url)\(/;
  var contentValues = ['normal', 'none', 'counter', 'open-quote', 'close-quote', 'no-open-quote', 'no-close-quote', 'initial', 'inherit', 'unset'];
  var oldProcessStyleValue = processStyleValue;
  var msPattern = /^-ms-/;
  var hyphenPattern = /-(.)/g;
  var hyphenatedCache = {};

  processStyleValue = function processStyleValue(key, value) {
    if (key === 'content') {
      if (typeof value !== 'string' || contentValues.indexOf(value) === -1 && !contentValuePattern.test(value) && (value.charAt(0) !== value.charAt(value.length - 1) || value.charAt(0) !== '"' && value.charAt(0) !== "'")) {
        console.error("You seem to be using a value for 'content' without quotes, try replacing it with `content: '\"" + value + "\"'`");
      }
    }

    var processed = oldProcessStyleValue(key, value);

    if (processed !== '' && !isCustomProperty(key) && key.indexOf('-') !== -1 && hyphenatedCache[key] === undefined) {
      hyphenatedCache[key] = true;
      console.error("Using kebab-case for css properties in objects is not supported. Did you mean " + key.replace(msPattern, 'ms-').replace(hyphenPattern, function (str, _char) {
        return _char.toUpperCase();
      }) + "?");
    }

    return processed;
  };
}

var shouldWarnAboutInterpolatingClassNameFromCss = true;

function handleInterpolation(mergedProps, registered, interpolation, couldBeSelectorInterpolation) {
  if (interpolation == null) {
    return '';
  }

  if (interpolation.__emotion_styles !== undefined) {
    if (process.env.NODE_ENV !== 'production' && interpolation.toString() === 'NO_COMPONENT_SELECTOR') {
      throw new Error('Component selectors can only be used in conjunction with babel-plugin-emotion.');
    }

    return interpolation;
  }

  switch (typeof interpolation) {
    case 'boolean':
      {
        return '';
      }

    case 'object':
      {
        if (interpolation.anim === 1) {
          cursor = {
            name: interpolation.name,
            styles: interpolation.styles,
            next: cursor
          };
          return interpolation.name;
        }

        if (interpolation.styles !== undefined) {
          var next = interpolation.next;

          if (next !== undefined) {
            // not the most efficient thing ever but this is a pretty rare case
            // and there will be very few iterations of this generally
            while (next !== undefined) {
              cursor = {
                name: next.name,
                styles: next.styles,
                next: cursor
              };
              next = next.next;
            }
          }

          var styles = interpolation.styles + ";";

          if (process.env.NODE_ENV !== 'production' && interpolation.map !== undefined) {
            styles += interpolation.map;
          }

          return styles;
        }

        return createStringFromObject(mergedProps, registered, interpolation);
      }

    case 'function':
      {
        if (mergedProps !== undefined) {
          var previousCursor = cursor;
          var result = interpolation(mergedProps);
          cursor = previousCursor;
          return handleInterpolation(mergedProps, registered, result, couldBeSelectorInterpolation);
        } else if (process.env.NODE_ENV !== 'production') {
          console.error('Functions that are interpolated in css calls will be stringified.\n' + 'If you want to have a css call based on props, create a function that returns a css call like this\n' + 'let dynamicStyle = (props) => css`color: ${props.color}`\n' + 'It can be called directly with props or interpolated in a styled call like this\n' + "let SomeComponent = styled('div')`${dynamicStyle}`");
        }

        break;
      }

    case 'string':
      if (process.env.NODE_ENV !== 'production') {
        var matched = [];
        var replaced = interpolation.replace(animationRegex, function (match, p1, p2) {
          var fakeVarName = "animation" + matched.length;
          matched.push("const " + fakeVarName + " = keyframes`" + p2.replace(/^@keyframes animation-\w+/, '') + "`");
          return "${" + fakeVarName + "}";
        });

        if (matched.length) {
          console.error('`keyframes` output got interpolated into plain string, please wrap it with `css`.\n\n' + 'Instead of doing this:\n\n' + [].concat(matched, ["`" + replaced + "`"]).join('\n') + '\n\nYou should wrap it with `css` like this:\n\n' + ("css`" + replaced + "`"));
        }
      }

      break;
  } // finalize string values (regular strings and functions interpolated into css calls)


  if (registered == null) {
    return interpolation;
  }

  var cached = registered[interpolation];

  if (process.env.NODE_ENV !== 'production' && couldBeSelectorInterpolation && shouldWarnAboutInterpolatingClassNameFromCss && cached !== undefined) {
    console.error('Interpolating a className from css`` is not recommended and will cause problems with composition.\n' + 'Interpolating a className from css`` will be completely unsupported in a future major version of Emotion');
    shouldWarnAboutInterpolatingClassNameFromCss = false;
  }

  return cached !== undefined && !couldBeSelectorInterpolation ? cached : interpolation;
}

function createStringFromObject(mergedProps, registered, obj) {
  var string = '';

  if (Array.isArray(obj)) {
    for (var i = 0; i < obj.length; i++) {
      string += handleInterpolation(mergedProps, registered, obj[i], false);
    }
  } else {
    for (var _key in obj) {
      var value = obj[_key];

      if (typeof value !== 'object') {
        if (registered != null && registered[value] !== undefined) {
          string += _key + "{" + registered[value] + "}";
        } else if (isProcessableValue(value)) {
          string += processStyleName(_key) + ":" + processStyleValue(_key, value) + ";";
        }
      } else {
        if (_key === 'NO_COMPONENT_SELECTOR' && process.env.NODE_ENV !== 'production') {
          throw new Error('Component selectors can only be used in conjunction with babel-plugin-emotion.');
        }

        if (Array.isArray(value) && typeof value[0] === 'string' && (registered == null || registered[value[0]] === undefined)) {
          for (var _i = 0; _i < value.length; _i++) {
            if (isProcessableValue(value[_i])) {
              string += processStyleName(_key) + ":" + processStyleValue(_key, value[_i]) + ";";
            }
          }
        } else {
          var interpolated = handleInterpolation(mergedProps, registered, value, false);

          switch (_key) {
            case 'animation':
            case 'animationName':
              {
                string += processStyleName(_key) + ":" + interpolated + ";";
                break;
              }

            default:
              {
                if (process.env.NODE_ENV !== 'production' && _key === 'undefined') {
                  console.error(UNDEFINED_AS_OBJECT_KEY_ERROR);
                }

                string += _key + "{" + interpolated + "}";
              }
          }
        }
      }
    }
  }

  return string;
}

var labelPattern = /label:\s*([^\s;\n{]+)\s*;/g;
var sourceMapPattern;

if (process.env.NODE_ENV !== 'production') {
  sourceMapPattern = /\/\*#\ssourceMappingURL=data:application\/json;\S+\s+\*\//;
} // this is the cursor for keyframes
// keyframes are stored on the SerializedStyles object as a linked list


var cursor;
var serializeStyles = function serializeStyles(args, registered, mergedProps) {
  if (args.length === 1 && typeof args[0] === 'object' && args[0] !== null && args[0].styles !== undefined) {
    return args[0];
  }

  var stringMode = true;
  var styles = '';
  cursor = undefined;
  var strings = args[0];

  if (strings == null || strings.raw === undefined) {
    stringMode = false;
    styles += handleInterpolation(mergedProps, registered, strings, false);
  } else {
    if (process.env.NODE_ENV !== 'production' && strings[0] === undefined) {
      console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
    }

    styles += strings[0];
  } // we start at 1 since we've already handled the first arg


  for (var i = 1; i < args.length; i++) {
    styles += handleInterpolation(mergedProps, registered, args[i], styles.charCodeAt(styles.length - 1) === 46);

    if (stringMode) {
      if (process.env.NODE_ENV !== 'production' && strings[i] === undefined) {
        console.error(ILLEGAL_ESCAPE_SEQUENCE_ERROR);
      }

      styles += strings[i];
    }
  }

  var sourceMap;

  if (process.env.NODE_ENV !== 'production') {
    styles = styles.replace(sourceMapPattern, function (match) {
      sourceMap = match;
      return '';
    });
  } // using a global regex with .exec is stateful so lastIndex has to be reset each time


  labelPattern.lastIndex = 0;
  var identifierName = '';
  var match; // https://esbench.com/bench/5b809c2cf2949800a0f61fb5

  while ((match = labelPattern.exec(styles)) !== null) {
    identifierName += '-' + // $FlowFixMe we know it's not null
    match[1];
  }

  var name = murmurhash2_32_gc(styles) + identifierName;

  if (process.env.NODE_ENV !== 'production') {
    // $FlowFixMe SerializedStyles type doesn't have toString property (and we don't want to add it)
    return {
      name: name,
      styles: styles,
      map: sourceMap,
      next: cursor,
      toString: function toString() {
        return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop).";
      }
    };
  }

  return {
    name: name,
    styles: styles,
    next: cursor
  };
};

function css() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return serializeStyles(args);
}

var isBrowser$2 = typeof document !== 'undefined';

var EmotionCacheContext = React.createContext( // we're doing this to avoid preconstruct's dead code elimination in this one case
// because this module is primarily intended for the browser and node
// but it's also required in react native and similar environments sometimes
// and we could have a special build just for that
// but this is much easier and the native packages
// might use a different theme context in the future anyway
typeof HTMLElement !== 'undefined' ? createCache() : null);
var ThemeContext = React.createContext({});
var CacheProvider = EmotionCacheContext.Provider;

var withEmotionCache = function withEmotionCache(func) {
  var render = function render(props, ref) {
    return React.createElement(EmotionCacheContext.Consumer, null, function (cache) {
      return func(props, cache, ref);
    });
  }; // $FlowFixMe


  return React.forwardRef(render);
};

if (!isBrowser$2) {
  var BasicProvider =
  /*#__PURE__*/
  function (_React$Component) {
    inheritsLoose(BasicProvider, _React$Component);

    function BasicProvider(props, context, updater) {
      var _this;

      _this = _React$Component.call(this, props, context, updater) || this;
      _this.state = {
        value: createCache()
      };
      return _this;
    }

    var _proto = BasicProvider.prototype;

    _proto.render = function render() {
      return React.createElement(EmotionCacheContext.Provider, this.state, this.props.children(this.state.value));
    };

    return BasicProvider;
  }(React.Component);

  withEmotionCache = function withEmotionCache(func) {
    return function (props) {
      return React.createElement(EmotionCacheContext.Consumer, null, function (context) {
        if (context === null) {
          return React.createElement(BasicProvider, null, function (newContext) {
            return func(props, newContext);
          });
        } else {
          return func(props, context);
        }
      });
    };
  };
}

var typePropName = '__EMOTION_TYPE_PLEASE_DO_NOT_USE__';
var labelPropName = '__EMOTION_LABEL_PLEASE_DO_NOT_USE__';
var hasOwnProperty = Object.prototype.hasOwnProperty;

var render = function render(cache, props, theme, ref) {
  var cssProp = theme === null ? props.css : props.css(theme); // so that using `css` from `emotion` and passing the result to the css prop works
  // not passing the registered cache to serializeStyles because it would
  // make certain babel optimisations not possible

  if (typeof cssProp === 'string' && cache.registered[cssProp] !== undefined) {
    cssProp = cache.registered[cssProp];
  }

  var type = props[typePropName];
  var registeredStyles = [cssProp];
  var className = '';

  if (typeof props.className === 'string') {
    className = getRegisteredStyles(cache.registered, registeredStyles, props.className);
  } else if (props.className != null) {
    className = props.className + " ";
  }

  var serialized = serializeStyles(registeredStyles);

  if (process.env.NODE_ENV !== 'production' && serialized.name.indexOf('-') === -1) {
    var labelFromStack = props[labelPropName];

    if (labelFromStack) {
      serialized = serializeStyles([serialized, 'label:' + labelFromStack + ';']);
    }
  }

  var rules = insertStyles(cache, serialized, typeof type === 'string');
  className += cache.key + "-" + serialized.name;
  var newProps = {};

  for (var key in props) {
    if (hasOwnProperty.call(props, key) && key !== 'css' && key !== typePropName && (process.env.NODE_ENV === 'production' || key !== labelPropName)) {
      newProps[key] = props[key];
    }
  }

  newProps.ref = ref;
  newProps.className = className;
  var ele = React.createElement(type, newProps);

  if (!isBrowser$2 && rules !== undefined) {
    var _ref;

    var serializedNames = serialized.name;
    var next = serialized.next;

    while (next !== undefined) {
      serializedNames += ' ' + next.name;
      next = next.next;
    }

    return React.createElement(React.Fragment, null, React.createElement("style", (_ref = {}, _ref["data-emotion-" + cache.key] = serializedNames, _ref.dangerouslySetInnerHTML = {
      __html: rules
    }, _ref.nonce = cache.sheet.nonce, _ref)), ele);
  }

  return ele;
};

var Emotion =
/* #__PURE__ */
withEmotionCache(function (props, cache, ref) {
  // use Context.read for the theme when it's stable
  if (typeof props.css === 'function') {
    return React.createElement(ThemeContext.Consumer, null, function (theme) {
      return render(cache, props, theme, ref);
    });
  }

  return render(cache, props, null, ref);
});

if (process.env.NODE_ENV !== 'production') {
  Emotion.displayName = 'EmotionCssPropInternal';
} // $FlowFixMe

var warnedAboutCssPropForGlobal = false;
var Global =
/* #__PURE__ */
withEmotionCache(function (props, cache) {
  if (process.env.NODE_ENV !== 'production' && !warnedAboutCssPropForGlobal && ( // check for className as well since the user is
  // probably using the custom createElement which
  // means it will be turned into a className prop
  // $FlowFixMe I don't really want to add it to the type since it shouldn't be used
  props.className || props.css)) {
    console.error("It looks like you're using the css prop on Global, did you mean to use the styles prop instead?");
    warnedAboutCssPropForGlobal = true;
  }

  var styles = props.styles;

  if (typeof styles === 'function') {
    return React.createElement(ThemeContext.Consumer, null, function (theme) {
      var serialized = serializeStyles([styles(theme)]);
      return React.createElement(InnerGlobal, {
        serialized: serialized,
        cache: cache
      });
    });
  }

  var serialized = serializeStyles([styles]);
  return React.createElement(InnerGlobal, {
    serialized: serialized,
    cache: cache
  });
});

// maintain place over rerenders.
// initial render from browser, insertBefore context.sheet.tags[0] or if a style hasn't been inserted there yet, appendChild
// initial client-side render from SSR, use place of hydrating tag
var InnerGlobal =
/*#__PURE__*/
function (_React$Component) {
  inheritsLoose(InnerGlobal, _React$Component);

  function InnerGlobal(props, context, updater) {
    return _React$Component.call(this, props, context, updater) || this;
  }

  var _proto = InnerGlobal.prototype;

  _proto.componentDidMount = function componentDidMount() {
    this.sheet = new StyleSheet({
      key: this.props.cache.key + "-global",
      nonce: this.props.cache.sheet.nonce,
      container: this.props.cache.sheet.container
    }); // $FlowFixMe

    var node = document.querySelector("style[data-emotion-" + this.props.cache.key + "=\"" + this.props.serialized.name + "\"]");

    if (node !== null) {
      this.sheet.tags.push(node);
    }

    if (this.props.cache.sheet.tags.length) {
      this.sheet.before = this.props.cache.sheet.tags[0];
    }

    this.insertStyles();
  };

  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {
    if (prevProps.serialized.name !== this.props.serialized.name) {
      this.insertStyles();
    }
  };

  _proto.insertStyles = function insertStyles$1() {
    if (this.props.serialized.next !== undefined) {
      // insert keyframes
      insertStyles(this.props.cache, this.props.serialized.next, true);
    }

    if (this.sheet.tags.length) {
      // if this doesn't exist then it will be null so the style element will be appended
      var element = this.sheet.tags[this.sheet.tags.length - 1].nextElementSibling;
      this.sheet.before = element;
      this.sheet.flush();
    }

    this.props.cache.insert("", this.props.serialized, this.sheet, false);
  };

  _proto.componentWillUnmount = function componentWillUnmount() {
    this.sheet.flush();
  };

  _proto.render = function render() {
    if (!isBrowser$2) {
      var serialized = this.props.serialized;
      var serializedNames = serialized.name;
      var serializedStyles = serialized.styles;
      var next = serialized.next;

      while (next !== undefined) {
        serializedNames += ' ' + next.name;
        serializedStyles += next.styles;
        next = next.next;
      }

      var shouldCache = this.props.cache.compat === true;
      var rules = this.props.cache.insert("", {
        name: serializedNames,
        styles: serializedStyles
      }, this.sheet, shouldCache);

      if (!shouldCache) {
        var _ref;

        return React.createElement("style", (_ref = {}, _ref["data-emotion-" + this.props.cache.key] = serializedNames, _ref.dangerouslySetInnerHTML = {
          __html: rules
        }, _ref.nonce = this.props.cache.sheet.nonce, _ref));
      }
    }

    return null;
  };

  return InnerGlobal;
}(React.Component);

var classnames = function classnames(args) {
  var len = args.length;
  var i = 0;
  var cls = '';

  for (; i < len; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};

function merge(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = getRegisteredStyles(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var ClassNames = withEmotionCache(function (props, context) {
  return React.createElement(ThemeContext.Consumer, null, function (theme) {
    var rules = '';
    var serializedHashes = '';
    var hasRendered = false;

    var css = function css() {
      if (hasRendered && process.env.NODE_ENV !== 'production') {
        throw new Error('css can only be used during render');
      }

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var serialized = serializeStyles(args, context.registered);

      if (isBrowser$2) {
        insertStyles(context, serialized, false);
      } else {
        var res = insertStyles(context, serialized, false);

        if (res !== undefined) {
          rules += res;
        }
      }

      if (!isBrowser$2) {
        serializedHashes += " " + serialized.name;
      }

      return context.key + "-" + serialized.name;
    };

    var cx = function cx() {
      if (hasRendered && process.env.NODE_ENV !== 'production') {
        throw new Error('cx can only be used during render');
      }

      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return merge(context.registered, css, classnames(args));
    };

    var content = {
      css: css,
      cx: cx,
      theme: theme
    };
    var ele = props.children(content);
    hasRendered = true;

    if (!isBrowser$2 && rules.length !== 0) {
      var _ref;

      return React.createElement(React.Fragment, null, React.createElement("style", (_ref = {}, _ref["data-emotion-" + context.key] = serializedHashes.substring(1), _ref.dangerouslySetInnerHTML = {
        __html: rules
      }, _ref.nonce = context.sheet.nonce, _ref)), ele);
    }

    return ele;
  });
});

/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

exports.__assign = function() {
    exports.__assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return exports.__assign.apply(this, arguments);
};

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
}

function stylis_min$1 (W) {
  function M(d, c, e, h, a) {
    for (var m = 0, b = 0, v = 0, n = 0, q, g, x = 0, K = 0, k, u = k = q = 0, l = 0, r = 0, I = 0, t = 0, B = e.length, J = B - 1, y, f = '', p = '', F = '', G = '', C; l < B;) {
      g = e.charCodeAt(l);
      l === J && 0 !== b + n + v + m && (0 !== b && (g = 47 === b ? 10 : 47), n = v = m = 0, B++, J++);

      if (0 === b + n + v + m) {
        if (l === J && (0 < r && (f = f.replace(N, '')), 0 < f.trim().length)) {
          switch (g) {
            case 32:
            case 9:
            case 59:
            case 13:
            case 10:
              break;

            default:
              f += e.charAt(l);
          }

          g = 59;
        }

        switch (g) {
          case 123:
            f = f.trim();
            q = f.charCodeAt(0);
            k = 1;

            for (t = ++l; l < B;) {
              switch (g = e.charCodeAt(l)) {
                case 123:
                  k++;
                  break;

                case 125:
                  k--;
                  break;

                case 47:
                  switch (g = e.charCodeAt(l + 1)) {
                    case 42:
                    case 47:
                      a: {
                        for (u = l + 1; u < J; ++u) {
                          switch (e.charCodeAt(u)) {
                            case 47:
                              if (42 === g && 42 === e.charCodeAt(u - 1) && l + 2 !== u) {
                                l = u + 1;
                                break a;
                              }

                              break;

                            case 10:
                              if (47 === g) {
                                l = u + 1;
                                break a;
                              }

                          }
                        }

                        l = u;
                      }

                  }

                  break;

                case 91:
                  g++;

                case 40:
                  g++;

                case 34:
                case 39:
                  for (; l++ < J && e.charCodeAt(l) !== g;) {
                  }

              }

              if (0 === k) break;
              l++;
            }

            k = e.substring(t, l);
            0 === q && (q = (f = f.replace(ca, '').trim()).charCodeAt(0));

            switch (q) {
              case 64:
                0 < r && (f = f.replace(N, ''));
                g = f.charCodeAt(1);

                switch (g) {
                  case 100:
                  case 109:
                  case 115:
                  case 45:
                    r = c;
                    break;

                  default:
                    r = O;
                }

                k = M(c, r, k, g, a + 1);
                t = k.length;
                0 < A && (r = X(O, f, I), C = H(3, k, r, c, D, z, t, g, a, h), f = r.join(''), void 0 !== C && 0 === (t = (k = C.trim()).length) && (g = 0, k = ''));
                if (0 < t) switch (g) {
                  case 115:
                    f = f.replace(da, ea);

                  case 100:
                  case 109:
                  case 45:
                    k = f + '{' + k + '}';
                    break;

                  case 107:
                    f = f.replace(fa, '$1 $2');
                    k = f + '{' + k + '}';
                    k = 1 === w || 2 === w && L('@' + k, 3) ? '@-webkit-' + k + '@' + k : '@' + k;
                    break;

                  default:
                    k = f + k, 112 === h && (k = (p += k, ''));
                } else k = '';
                break;

              default:
                k = M(c, X(c, f, I), k, h, a + 1);
            }

            F += k;
            k = I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
            break;

          case 125:
          case 59:
            f = (0 < r ? f.replace(N, '') : f).trim();
            if (1 < (t = f.length)) switch (0 === u && (q = f.charCodeAt(0), 45 === q || 96 < q && 123 > q) && (t = (f = f.replace(' ', ':')).length), 0 < A && void 0 !== (C = H(1, f, c, d, D, z, p.length, h, a, h)) && 0 === (t = (f = C.trim()).length) && (f = '\x00\x00'), q = f.charCodeAt(0), g = f.charCodeAt(1), q) {
              case 0:
                break;

              case 64:
                if (105 === g || 99 === g) {
                  G += f + e.charAt(l);
                  break;
                }

              default:
                58 !== f.charCodeAt(t - 1) && (p += P(f, q, g, f.charCodeAt(2)));
            }
            I = r = u = q = 0;
            f = '';
            g = e.charCodeAt(++l);
        }
      }

      switch (g) {
        case 13:
        case 10:
          47 === b ? b = 0 : 0 === 1 + q && 107 !== h && 0 < f.length && (r = 1, f += '\x00');
          0 < A * Y && H(0, f, c, d, D, z, p.length, h, a, h);
          z = 1;
          D++;
          break;

        case 59:
        case 125:
          if (0 === b + n + v + m) {
            z++;
            break;
          }

        default:
          z++;
          y = e.charAt(l);

          switch (g) {
            case 9:
            case 32:
              if (0 === n + m + b) switch (x) {
                case 44:
                case 58:
                case 9:
                case 32:
                  y = '';
                  break;

                default:
                  32 !== g && (y = ' ');
              }
              break;

            case 0:
              y = '\\0';
              break;

            case 12:
              y = '\\f';
              break;

            case 11:
              y = '\\v';
              break;

            case 38:
              0 === n + b + m && (r = I = 1, y = '\f' + y);
              break;

            case 108:
              if (0 === n + b + m + E && 0 < u) switch (l - u) {
                case 2:
                  112 === x && 58 === e.charCodeAt(l - 3) && (E = x);

                case 8:
                  111 === K && (E = K);
              }
              break;

            case 58:
              0 === n + b + m && (u = l);
              break;

            case 44:
              0 === b + v + n + m && (r = 1, y += '\r');
              break;

            case 34:
            case 39:
              0 === b && (n = n === g ? 0 : 0 === n ? g : n);
              break;

            case 91:
              0 === n + b + v && m++;
              break;

            case 93:
              0 === n + b + v && m--;
              break;

            case 41:
              0 === n + b + m && v--;
              break;

            case 40:
              if (0 === n + b + m) {
                if (0 === q) switch (2 * x + 3 * K) {
                  case 533:
                    break;

                  default:
                    q = 1;
                }
                v++;
              }

              break;

            case 64:
              0 === b + v + n + m + u + k && (k = 1);
              break;

            case 42:
            case 47:
              if (!(0 < n + m + v)) switch (b) {
                case 0:
                  switch (2 * g + 3 * e.charCodeAt(l + 1)) {
                    case 235:
                      b = 47;
                      break;

                    case 220:
                      t = l, b = 42;
                  }

                  break;

                case 42:
                  47 === g && 42 === x && t + 2 !== l && (33 === e.charCodeAt(t + 2) && (p += e.substring(t, l + 1)), y = '', b = 0);
              }
          }

          0 === b && (f += y);
      }

      K = x;
      x = g;
      l++;
    }

    t = p.length;

    if (0 < t) {
      r = c;
      if (0 < A && (C = H(2, p, r, d, D, z, t, h, a, h), void 0 !== C && 0 === (p = C).length)) return G + p + F;
      p = r.join(',') + '{' + p + '}';

      if (0 !== w * E) {
        2 !== w || L(p, 2) || (E = 0);

        switch (E) {
          case 111:
            p = p.replace(ha, ':-moz-$1') + p;
            break;

          case 112:
            p = p.replace(Q, '::-webkit-input-$1') + p.replace(Q, '::-moz-$1') + p.replace(Q, ':-ms-input-$1') + p;
        }

        E = 0;
      }
    }

    return G + p + F;
  }

  function X(d, c, e) {
    var h = c.trim().split(ia);
    c = h;
    var a = h.length,
        m = d.length;

    switch (m) {
      case 0:
      case 1:
        var b = 0;

        for (d = 0 === m ? '' : d[0] + ' '; b < a; ++b) {
          c[b] = Z(d, c[b], e).trim();
        }

        break;

      default:
        var v = b = 0;

        for (c = []; b < a; ++b) {
          for (var n = 0; n < m; ++n) {
            c[v++] = Z(d[n] + ' ', h[b], e).trim();
          }
        }

    }

    return c;
  }

  function Z(d, c, e) {
    var h = c.charCodeAt(0);
    33 > h && (h = (c = c.trim()).charCodeAt(0));

    switch (h) {
      case 38:
        return c.replace(F, '$1' + d.trim());

      case 58:
        return d.trim() + c.replace(F, '$1' + d.trim());

      default:
        if (0 < 1 * e && 0 < c.indexOf('\f')) return c.replace(F, (58 === d.charCodeAt(0) ? '' : '$1') + d.trim());
    }

    return d + c;
  }

  function P(d, c, e, h) {
    var a = d + ';',
        m = 2 * c + 3 * e + 4 * h;

    if (944 === m) {
      d = a.indexOf(':', 9) + 1;
      var b = a.substring(d, a.length - 1).trim();
      b = a.substring(0, d).trim() + b + ';';
      return 1 === w || 2 === w && L(b, 1) ? '-webkit-' + b + b : b;
    }

    if (0 === w || 2 === w && !L(a, 1)) return a;

    switch (m) {
      case 1015:
        return 97 === a.charCodeAt(10) ? '-webkit-' + a + a : a;

      case 951:
        return 116 === a.charCodeAt(3) ? '-webkit-' + a + a : a;

      case 963:
        return 110 === a.charCodeAt(5) ? '-webkit-' + a + a : a;

      case 1009:
        if (100 !== a.charCodeAt(4)) break;

      case 969:
      case 942:
        return '-webkit-' + a + a;

      case 978:
        return '-webkit-' + a + '-moz-' + a + a;

      case 1019:
      case 983:
        return '-webkit-' + a + '-moz-' + a + '-ms-' + a + a;

      case 883:
        if (45 === a.charCodeAt(8)) return '-webkit-' + a + a;
        if (0 < a.indexOf('image-set(', 11)) return a.replace(ja, '$1-webkit-$2') + a;
        break;

      case 932:
        if (45 === a.charCodeAt(4)) switch (a.charCodeAt(5)) {
          case 103:
            return '-webkit-box-' + a.replace('-grow', '') + '-webkit-' + a + '-ms-' + a.replace('grow', 'positive') + a;

          case 115:
            return '-webkit-' + a + '-ms-' + a.replace('shrink', 'negative') + a;

          case 98:
            return '-webkit-' + a + '-ms-' + a.replace('basis', 'preferred-size') + a;
        }
        return '-webkit-' + a + '-ms-' + a + a;

      case 964:
        return '-webkit-' + a + '-ms-flex-' + a + a;

      case 1023:
        if (99 !== a.charCodeAt(8)) break;
        b = a.substring(a.indexOf(':', 15)).replace('flex-', '').replace('space-between', 'justify');
        return '-webkit-box-pack' + b + '-webkit-' + a + '-ms-flex-pack' + b + a;

      case 1005:
        return ka.test(a) ? a.replace(aa, ':-webkit-') + a.replace(aa, ':-moz-') + a : a;

      case 1e3:
        b = a.substring(13).trim();
        c = b.indexOf('-') + 1;

        switch (b.charCodeAt(0) + b.charCodeAt(c)) {
          case 226:
            b = a.replace(G, 'tb');
            break;

          case 232:
            b = a.replace(G, 'tb-rl');
            break;

          case 220:
            b = a.replace(G, 'lr');
            break;

          default:
            return a;
        }

        return '-webkit-' + a + '-ms-' + b + a;

      case 1017:
        if (-1 === a.indexOf('sticky', 9)) break;

      case 975:
        c = (a = d).length - 10;
        b = (33 === a.charCodeAt(c) ? a.substring(0, c) : a).substring(d.indexOf(':', 7) + 1).trim();

        switch (m = b.charCodeAt(0) + (b.charCodeAt(7) | 0)) {
          case 203:
            if (111 > b.charCodeAt(8)) break;

          case 115:
            a = a.replace(b, '-webkit-' + b) + ';' + a;
            break;

          case 207:
          case 102:
            a = a.replace(b, '-webkit-' + (102 < m ? 'inline-' : '') + 'box') + ';' + a.replace(b, '-webkit-' + b) + ';' + a.replace(b, '-ms-' + b + 'box') + ';' + a;
        }

        return a + ';';

      case 938:
        if (45 === a.charCodeAt(5)) switch (a.charCodeAt(6)) {
          case 105:
            return b = a.replace('-items', ''), '-webkit-' + a + '-webkit-box-' + b + '-ms-flex-' + b + a;

          case 115:
            return '-webkit-' + a + '-ms-flex-item-' + a.replace(ba, '') + a;

          default:
            return '-webkit-' + a + '-ms-flex-line-pack' + a.replace('align-content', '').replace(ba, '') + a;
        }
        break;

      case 973:
      case 989:
        if (45 !== a.charCodeAt(3) || 122 === a.charCodeAt(4)) break;

      case 931:
      case 953:
        if (!0 === la.test(d)) return 115 === (b = d.substring(d.indexOf(':') + 1)).charCodeAt(0) ? P(d.replace('stretch', 'fill-available'), c, e, h).replace(':fill-available', ':stretch') : a.replace(b, '-webkit-' + b) + a.replace(b, '-moz-' + b.replace('fill-', '')) + a;
        break;

      case 962:
        if (a = '-webkit-' + a + (102 === a.charCodeAt(5) ? '-ms-' + a : '') + a, 211 === e + h && 105 === a.charCodeAt(13) && 0 < a.indexOf('transform', 10)) return a.substring(0, a.indexOf(';', 27) + 1).replace(ma, '$1-webkit-$2') + a;
    }

    return a;
  }

  function L(d, c) {
    var e = d.indexOf(1 === c ? ':' : '{'),
        h = d.substring(0, 3 !== c ? e : 10);
    e = d.substring(e + 1, d.length - 1);
    return R(2 !== c ? h : h.replace(na, '$1'), e, c);
  }

  function ea(d, c) {
    var e = P(c, c.charCodeAt(0), c.charCodeAt(1), c.charCodeAt(2));
    return e !== c + ';' ? e.replace(oa, ' or ($1)').substring(4) : '(' + c + ')';
  }

  function H(d, c, e, h, a, m, b, v, n, q) {
    for (var g = 0, x = c, w; g < A; ++g) {
      switch (w = S[g].call(B, d, x, e, h, a, m, b, v, n, q)) {
        case void 0:
        case !1:
        case !0:
        case null:
          break;

        default:
          x = w;
      }
    }

    if (x !== c) return x;
  }

  function T(d) {
    switch (d) {
      case void 0:
      case null:
        A = S.length = 0;
        break;

      default:
        if ('function' === typeof d) S[A++] = d;else if ('object' === typeof d) for (var c = 0, e = d.length; c < e; ++c) {
          T(d[c]);
        } else Y = !!d | 0;
    }

    return T;
  }

  function U(d) {
    d = d.prefix;
    void 0 !== d && (R = null, d ? 'function' !== typeof d ? w = 1 : (w = 2, R = d) : w = 0);
    return U;
  }

  function B(d, c) {
    var e = d;
    33 > e.charCodeAt(0) && (e = e.trim());
    V = e;
    e = [V];

    if (0 < A) {
      var h = H(-1, c, e, e, D, z, 0, 0, 0, 0);
      void 0 !== h && 'string' === typeof h && (c = h);
    }

    var a = M(O, e, c, 0, 0);
    0 < A && (h = H(-2, a, e, e, D, z, a.length, 0, 0, 0), void 0 !== h && (a = h));
    V = '';
    E = 0;
    z = D = 1;
    return a;
  }

  var ca = /^\0+/g,
      N = /[\0\r\f]/g,
      aa = /: */g,
      ka = /zoo|gra/,
      ma = /([,: ])(transform)/g,
      ia = /,\r+?/g,
      F = /([\t\r\n ])*\f?&/g,
      fa = /@(k\w+)\s*(\S*)\s*/,
      Q = /::(place)/g,
      ha = /:(read-only)/g,
      G = /[svh]\w+-[tblr]{2}/,
      da = /\(\s*(.*)\s*\)/g,
      oa = /([\s\S]*?);/g,
      ba = /-self|flex-/g,
      na = /[^]*?(:[rp][el]a[\w-]+)[^]*/,
      la = /stretch|:\s*\w+\-(?:conte|avail)/,
      ja = /([^-])(image-set\()/,
      z = 1,
      D = 1,
      E = 0,
      w = 1,
      O = [],
      S = [],
      A = 0,
      R = null,
      Y = 0,
      V = '';
  B.use = T;
  B.set = U;
  void 0 !== W && U(W);
  return B;
}

// https://github.com/thysultan/stylis.js/tree/master/plugins/rule-sheet
// inlined to avoid umd wrapper and peerDep warnings/installing stylis
// since we use stylis after closure compiler
var delimiter$1 = '/*|*/';
var needle$1 = delimiter$1 + '}';

function toSheet$1(block) {
  if (block) {
    Sheet$1.current.insert(block + '}');
  }
}

var Sheet$1 = {
  current: null
};
var ruleSheet$1 = function ruleSheet(context, content, selectors, parents, line, column, length, ns, depth, at) {
  switch (context) {
    // property
    case 1:
      {
        switch (content.charCodeAt(0)) {
          case 64:
            {
              // @import
              Sheet$1.current.insert(content + ';');
              return '';
            }
          // charcode for l

          case 108:
            {
              // charcode for b
              // this ignores label
              if (content.charCodeAt(2) === 98) {
                return '';
              }
            }
        }

        break;
      }
    // selector

    case 2:
      {
        if (ns === 0) return content + delimiter$1;
        break;
      }
    // at-rule

    case 3:
      {
        switch (ns) {
          // @font-face, @page
          case 102:
          case 112:
            {
              Sheet$1.current.insert(selectors[0] + content);
              return '';
            }

          default:
            {
              return content + (at === 0 ? delimiter$1 : '');
            }
        }
      }

    case -2:
      {
        content.split(needle$1).forEach(toSheet$1);
      }
  }
};
var removeLabel$1 = function removeLabel(context, content) {
  if (context === 1 && // charcode for l
  content.charCodeAt(0) === 108 && // charcode for b
  content.charCodeAt(2) === 98 // this ignores label
  ) {
      return '';
    }
};

var isBrowser$3 = typeof document !== 'undefined';
var rootServerStylisCache$1 = {};
var getServerStylisCache$1 = isBrowser$3 ? undefined : weakMemoize(function () {
  var getCache = weakMemoize(function () {
    return {};
  });
  var prefixTrueCache = {};
  var prefixFalseCache = {};
  return function (prefix) {
    if (prefix === undefined || prefix === true) {
      return prefixTrueCache;
    }

    if (prefix === false) {
      return prefixFalseCache;
    }

    return getCache(prefix);
  };
});

var createCache$1 = function createCache(options) {
  if (options === undefined) options = {};
  var key = options.key || 'css';
  var stylisOptions;

  if (options.prefix !== undefined) {
    stylisOptions = {
      prefix: options.prefix
    };
  }

  var stylis = new stylis_min$1(stylisOptions);

  if (process.env.NODE_ENV !== 'production') {
    // $FlowFixMe
    if (/[^a-z-]/.test(key)) {
      throw new Error("Emotion key must only contain lower case alphabetical characters and - but \"" + key + "\" was passed");
    }
  }

  var inserted = {}; // $FlowFixMe

  var container;

  if (isBrowser$3) {
    container = options.container || document.head;
    var nodes = document.querySelectorAll("style[data-emotion-" + key + "]");
    Array.prototype.forEach.call(nodes, function (node) {
      var attrib = node.getAttribute("data-emotion-" + key); // $FlowFixMe

      attrib.split(' ').forEach(function (id) {
        inserted[id] = true;
      });

      if (node.parentNode !== container) {
        container.appendChild(node);
      }
    });
  }

  var _insert;

  if (isBrowser$3) {
    stylis.use(options.stylisPlugins)(ruleSheet$1);

    _insert = function insert(selector, serialized, sheet, shouldCache) {
      var name = serialized.name;
      Sheet$1.current = sheet;

      if (process.env.NODE_ENV !== 'production' && serialized.map !== undefined) {
        var map = serialized.map;
        Sheet$1.current = {
          insert: function insert(rule) {
            sheet.insert(rule + map);
          }
        };
      }

      stylis(selector, serialized.styles);

      if (shouldCache) {
        cache.inserted[name] = true;
      }
    };
  } else {
    stylis.use(removeLabel$1);
    var serverStylisCache = rootServerStylisCache$1;

    if (options.stylisPlugins || options.prefix !== undefined) {
      stylis.use(options.stylisPlugins); // $FlowFixMe

      serverStylisCache = getServerStylisCache$1(options.stylisPlugins || rootServerStylisCache$1)(options.prefix);
    }

    var getRules = function getRules(selector, serialized) {
      var name = serialized.name;

      if (serverStylisCache[name] === undefined) {
        serverStylisCache[name] = stylis(selector, serialized.styles);
      }

      return serverStylisCache[name];
    };

    _insert = function _insert(selector, serialized, sheet, shouldCache) {
      var name = serialized.name;
      var rules = getRules(selector, serialized);

      if (cache.compat === undefined) {
        // in regular mode, we don't set the styles on the inserted cache
        // since we don't need to and that would be wasting memory
        // we return them so that they are rendered in a style tag
        if (shouldCache) {
          cache.inserted[name] = true;
        }

        if ( // using === development instead of !== production
        // because if people do ssr in tests, the source maps showing up would be annoying
        process.env.NODE_ENV === 'development' && serialized.map !== undefined) {
          return rules + serialized.map;
        }

        return rules;
      } else {
        // in compat mode, we put the styles on the inserted cache so
        // that emotion-server can pull out the styles
        // except when we don't want to cache it which was in Global but now
        // is nowhere but we don't want to do a major right now
        // and just in case we're going to leave the case here
        // it's also not affecting client side bundle size
        // so it's really not a big deal
        if (shouldCache) {
          cache.inserted[name] = rules;
        } else {
          return rules;
        }
      }
    };
  }

  if (process.env.NODE_ENV !== 'production') {
    // https://esbench.com/bench/5bf7371a4cd7e6009ef61d0a
    var commentStart = /\/\*/g;
    var commentEnd = /\*\//g;
    stylis.use(function (context, content) {
      switch (context) {
        case -1:
          {
            while (commentStart.test(content)) {
              commentEnd.lastIndex = commentStart.lastIndex;

              if (commentEnd.test(content)) {
                commentStart.lastIndex = commentEnd.lastIndex;
                continue;
              }

              throw new Error('Your styles have an unterminated comment ("/*" without corresponding "*/").');
            }

            commentStart.lastIndex = 0;
            break;
          }
      }
    });
    stylis.use(function (context, content, selectors) {
      switch (context) {
        case -1:
          {
            var flag = 'emotion-disable-server-rendering-unsafe-selector-warning-please-do-not-use-this-the-warning-exists-for-a-reason';
            var unsafePseudoClasses = content.match(/(:first|:nth|:nth-last)-child/g);

            if (unsafePseudoClasses && cache.compat !== true) {
              unsafePseudoClasses.forEach(function (unsafePseudoClass) {
                var ignoreRegExp = new RegExp(unsafePseudoClass + ".*\\/\\* " + flag + " \\*\\/");
                var ignore = ignoreRegExp.test(content);

                if (unsafePseudoClass && !ignore) {
                  console.error("The pseudo class \"" + unsafePseudoClass + "\" is potentially unsafe when doing server-side rendering. Try changing it to \"" + unsafePseudoClass.split('-child')[0] + "-of-type\".");
                }
              });
            }

            break;
          }
      }
    });
  }

  var cache = {
    key: key,
    sheet: new StyleSheet({
      key: key,
      container: container,
      nonce: options.nonce,
      speedy: options.speedy
    }),
    nonce: options.nonce,
    inserted: inserted,
    registered: {},
    insert: _insert
  };
  return cache;
};

function insertWithoutScoping(cache, serialized) {
  if (cache.inserted[serialized.name] === undefined) {
    return cache.insert('', serialized, cache.sheet, true);
  }
}

function merge$1(registered, css, className) {
  var registeredStyles = [];
  var rawClassName = getRegisteredStyles(registered, registeredStyles, className);

  if (registeredStyles.length < 2) {
    return className;
  }

  return rawClassName + css(registeredStyles);
}

var createEmotion = function createEmotion(options) {
  var cache = createCache$1(options); // $FlowFixMe

  cache.sheet.speedy = function (value) {
    if (process.env.NODE_ENV !== 'production' && this.ctr !== 0) {
      throw new Error('speedy must be changed before any rules are inserted');
    }

    this.isSpeedy = value;
  };

  cache.compat = true;

  var css = function css() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var serialized = serializeStyles(args, cache.registered, undefined);
    insertStyles(cache, serialized, false);
    return cache.key + "-" + serialized.name;
  };

  var keyframes = function keyframes() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    var serialized = serializeStyles(args, cache.registered);
    var animation = "animation-" + serialized.name;
    insertWithoutScoping(cache, {
      name: serialized.name,
      styles: "@keyframes " + animation + "{" + serialized.styles + "}"
    });
    return animation;
  };

  var injectGlobal = function injectGlobal() {
    for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    var serialized = serializeStyles(args, cache.registered);
    insertWithoutScoping(cache, serialized);
  };

  var cx = function cx() {
    for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return merge$1(cache.registered, css, classnames$1(args));
  };

  return {
    css: css,
    cx: cx,
    injectGlobal: injectGlobal,
    keyframes: keyframes,
    hydrate: function hydrate(ids) {
      ids.forEach(function (key) {
        cache.inserted[key] = true;
      });
    },
    flush: function flush() {
      cache.registered = {};
      cache.inserted = {};
      cache.sheet.flush();
    },
    // $FlowFixMe
    sheet: cache.sheet,
    cache: cache,
    getRegisteredStyles: getRegisteredStyles.bind(null, cache.registered),
    merge: merge$1.bind(null, cache.registered, css)
  };
};

var classnames$1 = function classnames(args) {
  var cls = '';

  for (var i = 0; i < args.length; i++) {
    var arg = args[i];
    if (arg == null) continue;
    var toAdd = void 0;

    switch (typeof arg) {
      case 'boolean':
        break;

      case 'object':
        {
          if (Array.isArray(arg)) {
            toAdd = classnames(arg);
          } else {
            toAdd = '';

            for (var k in arg) {
              if (arg[k] && k) {
                toAdd && (toAdd += ' ');
                toAdd += k;
              }
            }
          }

          break;
        }

      default:
        {
          toAdd = arg;
        }
    }

    if (toAdd) {
      cls && (cls += ' ');
      cls += toAdd;
    }
  }

  return cls;
};

var _createEmotion = createEmotion(),
    cx = _createEmotion.cx,
    css$1 = _createEmotion.css;

function areInputsEqual(newInputs, lastInputs) {
    if (newInputs.length !== lastInputs.length) {
        return false;
    }
    for (var i = 0; i < newInputs.length; i++) {
        if (newInputs[i] !== lastInputs[i]) {
            return false;
        }
    }
    return true;
}

function memoizeOne(resultFn, isEqual) {
    if (isEqual === void 0) { isEqual = areInputsEqual; }
    var lastThis;
    var lastArgs = [];
    var lastResult;
    var calledOnce = false;
    function memoized() {
        var newArgs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            newArgs[_i] = arguments[_i];
        }
        if (calledOnce && lastThis === this && isEqual(newArgs, lastArgs)) {
            return lastResult;
        }
        lastResult = resultFn.apply(this, newArgs);
        calledOnce = true;
        lastThis = this;
        lastArgs = newArgs;
        return lastResult;
    }
    return memoized;
}

// import { KeyValue } from '@grafana/data';
/**
 *  Creates memoized version of styles creator
 * @param stylesCreator function accepting dependencies based on which styles are created
 */
function stylesFactory(stylesCreator) {
    return memoizeOne(stylesCreator);
}

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, basedir, module) {
	return module = {
		path: basedir,
		exports: {},
		require: function (path, base) {
			return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);
		}
	}, fn(module, module.exports), module.exports;
}

function getAugmentedNamespace(n) {
	if (n.__esModule) return n;
	var a = Object.defineProperty({}, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

function commonjsRequire () {
	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
}

var reactIs_production_min = createCommonjsModule(function (module, exports) {
Object.defineProperty(exports,"__esModule",{value:!0});
var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?Symbol.for("react.suspense_list"):
60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.fundamental"):60117,w=b?Symbol.for("react.responder"):60118,x=b?Symbol.for("react.scope"):60119;function y(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case h:return a;default:return u}}case t:case r:case d:return u}}}function z(a){return y(a)===m}
exports.typeOf=y;exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;exports.Fragment=e;exports.Lazy=t;exports.Memo=r;exports.Portal=d;exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;
exports.isValidElementType=function(a){return "string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===v||a.$$typeof===w||a.$$typeof===x)};exports.isAsyncMode=function(a){return z(a)||y(a)===l};exports.isConcurrentMode=z;exports.isContextConsumer=function(a){return y(a)===k};exports.isContextProvider=function(a){return y(a)===h};
exports.isElement=function(a){return "object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return y(a)===n};exports.isFragment=function(a){return y(a)===e};exports.isLazy=function(a){return y(a)===t};exports.isMemo=function(a){return y(a)===r};exports.isPortal=function(a){return y(a)===d};exports.isProfiler=function(a){return y(a)===g};exports.isStrictMode=function(a){return y(a)===f};exports.isSuspense=function(a){return y(a)===p};
});

var reactIs_development = createCommonjsModule(function (module, exports) {



if (process.env.NODE_ENV !== "production") {
  (function() {

Object.defineProperty(exports, '__esModule', { value: true });

// The Symbol used to tag the ReactElement-like types. If there is no native Symbol
// nor polyfill, then a plain number is used for performance.
var hasSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
// (unstable) APIs that have been removed. Can we remove the symbols?

var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

function isValidElementType(type) {
  return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE);
}

/**
 * Forked from fbjs/warning:
 * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js
 *
 * Only change is we use console.warn instead of console.error,
 * and do nothing when 'console' is not supported.
 * This really simplifies the code.
 * ---
 * Similar to invariant but only logs a warning if the condition is not met.
 * This can be used to log issues in development environments in critical
 * paths. Removing the logging code for production environments will keep the
 * same logic and follow the same code paths.
 */
var lowPriorityWarningWithoutStack = function () {};

{
  var printWarning = function (format) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var argIndex = 0;
    var message = 'Warning: ' + format.replace(/%s/g, function () {
      return args[argIndex++];
    });

    if (typeof console !== 'undefined') {
      console.warn(message);
    }

    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };

  lowPriorityWarningWithoutStack = function (condition, format) {
    if (format === undefined) {
      throw new Error('`lowPriorityWarningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');
    }

    if (!condition) {
      for (var _len2 = arguments.length, args = new Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
        args[_key2 - 2] = arguments[_key2];
      }

      printWarning.apply(void 0, [format].concat(args));
    }
  };
}

var lowPriorityWarningWithoutStack$1 = lowPriorityWarningWithoutStack;

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;

    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_ASYNC_MODE_TYPE:
          case REACT_CONCURRENT_MODE_TYPE:
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
            return type;

          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;

              default:
                return $$typeof;
            }

        }

      case REACT_LAZY_TYPE:
      case REACT_MEMO_TYPE:
      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
} // AsyncMode is deprecated along with isAsyncMode

var AsyncMode = REACT_ASYNC_MODE_TYPE;
var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;
var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true;
      lowPriorityWarningWithoutStack$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
    }
  }

  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
}
function isConcurrentMode(object) {
  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}

exports.typeOf = typeOf;
exports.AsyncMode = AsyncMode;
exports.ConcurrentMode = ConcurrentMode;
exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.isValidElementType = isValidElementType;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
  })();
}
});

var reactIs = createCommonjsModule(function (module) {

if (process.env.NODE_ENV === 'production') {
  module.exports = reactIs_production_min;
} else {
  module.exports = reactIs_development;
}
});

/**
 * Copyright 2015, Yahoo! Inc.
 * Copyrights licensed under the New BSD License. See the accompanying LICENSE file for terms.
 */
var REACT_STATICS = {
  childContextTypes: true,
  contextType: true,
  contextTypes: true,
  defaultProps: true,
  displayName: true,
  getDefaultProps: true,
  getDerivedStateFromError: true,
  getDerivedStateFromProps: true,
  mixins: true,
  propTypes: true,
  type: true
};
var KNOWN_STATICS = {
  name: true,
  length: true,
  prototype: true,
  caller: true,
  callee: true,
  arguments: true,
  arity: true
};
var FORWARD_REF_STATICS = {
  '$$typeof': true,
  render: true,
  defaultProps: true,
  displayName: true,
  propTypes: true
};
var MEMO_STATICS = {
  '$$typeof': true,
  compare: true,
  defaultProps: true,
  displayName: true,
  propTypes: true,
  type: true
};
var TYPE_STATICS = {};
TYPE_STATICS[reactIs.ForwardRef] = FORWARD_REF_STATICS;
TYPE_STATICS[reactIs.Memo] = MEMO_STATICS;

function getStatics(component) {
  // React v16.11 and below
  if (reactIs.isMemo(component)) {
    return MEMO_STATICS;
  } // React v16.12 and above


  return TYPE_STATICS[component['$$typeof']] || REACT_STATICS;
}

var defineProperty = Object.defineProperty;
var getOwnPropertyNames = Object.getOwnPropertyNames;
var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var getPrototypeOf = Object.getPrototypeOf;
var objectPrototype = Object.prototype;
function hoistNonReactStatics(targetComponent, sourceComponent, blacklist) {
  if (typeof sourceComponent !== 'string') {
    // don't hoist over string (html) components
    if (objectPrototype) {
      var inheritedComponent = getPrototypeOf(sourceComponent);

      if (inheritedComponent && inheritedComponent !== objectPrototype) {
        hoistNonReactStatics(targetComponent, inheritedComponent, blacklist);
      }
    }

    var keys = getOwnPropertyNames(sourceComponent);

    if (getOwnPropertySymbols) {
      keys = keys.concat(getOwnPropertySymbols(sourceComponent));
    }

    var targetStatics = getStatics(targetComponent);
    var sourceStatics = getStatics(sourceComponent);

    for (var i = 0; i < keys.length; ++i) {
      var key = keys[i];

      if (!KNOWN_STATICS[key] && !(blacklist && blacklist[key]) && !(sourceStatics && sourceStatics[key]) && !(targetStatics && targetStatics[key])) {
        var descriptor = getOwnPropertyDescriptor(sourceComponent, key);

        try {
          // Avoid failures from read-only properties
          defineProperty(targetComponent, key, descriptor);
        } catch (e) {}
      }
    }
  }

  return targetComponent;
}

var hoistNonReactStatics_cjs = hoistNonReactStatics;

var commonColorsPalette = {
    // New greys palette used by next-gen form elements
    gray98: '#f7f8fa',
    gray97: '#f1f5f9',
    gray95: '#e9edf2',
    gray90: '#dce1e6',
    gray85: '#c7d0d9',
    gray70: '#9fa7b3',
    gray60: '#7b8087',
    gray33: '#464c54',
    gray25: '#2c3235',
    gray15: '#202226',
    gray10: '#141619',
    gray05: '#0b0c0e',
    // New blues palette used by next-gen form elements
    blue95: '#5794f2',
    blue85: '#33a2e5',
    blue80: '#3274d9',
    blue77: '#1f60c4',
    // New reds palette used by next-gen form elements
    red88: '#e02f44',
};
var SPACING_BASE = 8;
var theme = {
    name: 'Grafana Default',
    typography: {
        fontFamily: {
            sansSerif: "'Roboto', 'Helvetica Neue', Arial, sans-serif",
            monospace: "Menlo, Monaco, Consolas, 'Courier New', monospace",
        },
        size: {
            base: '14px',
            xs: '10px',
            sm: '12px',
            md: '14px',
            lg: '18px',
        },
        heading: {
            h1: '28px',
            h2: '24px',
            h3: '21px',
            h4: '18px',
            h5: '16px',
            h6: '14px',
        },
        weight: {
            light: 300,
            regular: 400,
            semibold: 500,
            bold: 600,
        },
        lineHeight: {
            xs: 1,
            sm: 1.1,
            md: 1.5,
            lg: 2,
        },
        link: {
            decoration: 'none',
            hoverDecoration: 'none',
        },
    },
    breakpoints: {
        xs: '0',
        sm: '544px',
        md: '769px',
        lg: '992px',
        xl: '1200px',
        xxl: '1440px',
    },
    spacing: {
        base: SPACING_BASE,
        insetSquishMd: '4px 8px',
        d: '16px',
        xxs: '2px',
        xs: '4px',
        sm: '8px',
        md: '16px',
        lg: '24px',
        xl: '32px',
        gutter: '30px',
        // Next-gen forms spacing variables
        // TODO: Move variables definition to respective components when implementing
        formSpacingBase: SPACING_BASE,
        formMargin: SPACING_BASE * 4 + "px",
        formFieldsetMargin: SPACING_BASE * 2 + "px",
        formInputHeight: SPACING_BASE * 4,
        formButtonHeight: SPACING_BASE * 4,
        formInputPaddingHorizontal: SPACING_BASE + "px",
        // Used for icons do define spacing between icon and input field
        // Applied on the right(prefix) or left(suffix)
        formInputAffixPaddingHorizontal: SPACING_BASE / 2 + "px",
        formInputMargin: SPACING_BASE * 2 + "px",
        formLabelPadding: '0 0 0 2px',
        formLabelMargin: "0 0 " + (SPACING_BASE / 2 + 'px') + " 0",
        formValidationMessagePadding: '4px 8px',
        formValidationMessageMargin: '4px 0 0 0',
        inlineFormMargin: '4px',
    },
    border: {
        radius: {
            sm: '2px',
            md: '3px',
            lg: '5px',
        },
        width: {
            sm: '1px',
        },
    },
    height: {
        sm: 24,
        md: 32,
        lg: 48,
    },
    panelPadding: 8,
    panelHeaderHeight: 28,
    zIndex: {
        navbarFixed: 1000,
        sidemenu: 1020,
        dropdown: 1030,
        typeahead: 1030,
        tooltip: 1040,
        modalBackdrop: 1050,
        modal: 1060,
    },
};

var basicColors = exports.__assign(exports.__assign({}, commonColorsPalette), { black: '#000000', white: '#ffffff', dark1: '#141414', dark2: '#161719', dark3: '#1f1f20', dark4: '#212124', dark5: '#222426', dark6: '#262628', dark7: '#292a2d', dark8: '#2f2f32', dark9: '#343436', dark10: '#424345', gray1: '#555555', gray2: '#8e8e8e', gray3: '#b3b3b3', gray4: '#d8d9da', gray5: '#ececec', gray6: '#f4f5f8', gray7: '#fbfbfb', redBase: '#e02f44', redShade: '#c4162a', greenBase: '#299c46', greenShade: '#23843b', red: '#d44a3a', yellow: '#ecbb13', purple: '#9933cc', variable: '#32d1df', orange: '#eb7b18', orangeDark: '#ff780a' });
var backgrounds = {
    bg1: basicColors.gray10,
    bg2: basicColors.gray15,
    bg3: basicColors.gray25,
    dashboardBg: basicColors.gray05,
    bgBlue1: basicColors.blue80,
    bgBlue2: basicColors.blue77,
};
var borders = {
    border1: basicColors.gray15,
    border2: basicColors.gray25,
    border3: basicColors.gray33,
};
var textColors = {
    textStrong: basicColors.gray98,
    textHeading: basicColors.gray4,
    text: basicColors.gray85,
    textSemiWeak: basicColors.gray70,
    textWeak: basicColors.gray60,
    textFaint: basicColors.gray33,
    textBlue: basicColors.blue85,
};
var form = {
    // Next-gen forms functional colors
    formLabel: textColors.textSemiWeak,
    formDescription: basicColors.gray60,
    formInputBg: basicColors.gray05,
    formInputBgDisabled: basicColors.gray10,
    formInputBorder: borders.border2,
    formInputBorderHover: basicColors.gray33,
    formInputBorderActive: basicColors.blue95,
    formInputBorderInvalid: basicColors.red88,
    formInputPlaceholderText: textColors.textFaint,
    formInputText: basicColors.gray85,
    formInputDisabledText: basicColors.gray70,
    formFocusOutline: basicColors.blue77,
    formValidationMessageText: basicColors.white,
    formValidationMessageBg: basicColors.red88,
    formSwitchBg: basicColors.gray25,
    formSwitchBgActive: basicColors.blue95,
    formSwitchBgHover: basicColors.gray33,
    formSwitchBgActiveHover: basicColors.blue80,
    formSwitchBgDisabled: basicColors.gray25,
    formSwitchDot: basicColors.gray15,
    formCheckboxBgChecked: basicColors.blue95,
    formCheckboxBgCheckedHover: basicColors.blue80,
    formCheckboxCheckmark: basicColors.gray25,
};
var darkTheme = exports.__assign(exports.__assign({}, theme), { type: data.GrafanaThemeType.Dark, isDark: true, isLight: false, name: 'Grafana Dark', palette: exports.__assign(exports.__assign({}, basicColors), { brandPrimary: basicColors.orange, brandSuccess: basicColors.greenBase, brandWarning: basicColors.orange, brandDanger: basicColors.redBase, queryRed: basicColors.redBase, queryGreen: '#74e680', queryPurple: '#fe85fc', queryOrange: basicColors.orange, online: basicColors.greenBase, warn: '#f79520', critical: basicColors.redBase }), colors: exports.__assign(exports.__assign(exports.__assign(exports.__assign(exports.__assign({}, backgrounds), borders), form), textColors), { bodyBg: backgrounds.bg1, panelBg: backgrounds.bg1, pageHeaderBg: backgrounds.bg2, pageHeaderBorder: borders.border1, panelBorder: borders.border1, dropdownBg: form.formInputBg, dropdownShadow: basicColors.black, dropdownOptionHoverBg: backgrounds.bg2, link: basicColors.gray4, linkDisabled: basicColors.gray2, linkHover: basicColors.white, linkExternal: basicColors.blue85 }), shadows: {
        listItem: 'none',
    } });

var basicColors$1 = exports.__assign(exports.__assign({}, commonColorsPalette), { black: '#000000', white: '#ffffff', dark1: '#1e2028', dark2: '#41444b', dark3: '#303133', dark4: '#35373f', dark5: '#41444b', dark6: '#41444b', dark7: '#41444b', dark8: '#2f2f32', dark9: '#343436', dark10: '#424345', gray1: '#52545c', gray2: '#767980', gray3: '#acb6bf', gray4: '#c7d0d9', gray5: '#dde4ed', gray6: '#e9edf2', gray7: '#f7f8fa', redBase: '#e02f44', redShade: '#c4162a', greenBase: '#3eb15b', greenShade: '#369b4f', red: '#d44939', yellow: '#ff851b', purple: '#9954bb', orange: '#ff7941', orangeDark: '#ed5700' });
var backgrounds$1 = {
    bg1: basicColors$1.white,
    bg2: basicColors$1.gray97,
    bg3: basicColors$1.gray90,
    dashboardBg: basicColors$1.gray98,
    bgBlue1: basicColors$1.blue80,
    bgBlue2: basicColors$1.blue77,
};
var borders$1 = {
    border1: basicColors$1.gray90,
    border2: basicColors$1.gray85,
    border3: basicColors$1.gray70,
};
var textColors$1 = {
    // Text colors
    textStrong: basicColors$1.gray15,
    text: basicColors$1.gray33,
    textSemiWeak: basicColors$1.gray33,
    textWeak: basicColors$1.gray60,
    textFaint: basicColors$1.gray70,
    textBlue: basicColors$1.blue85,
};
var form$1 = {
    formLabel: textColors$1.text,
    formDescription: textColors$1.textWeak,
    formLegend: basicColors$1.gray25,
    formInputBg: basicColors$1.white,
    formInputBgDisabled: basicColors$1.gray95,
    formInputBorder: basicColors$1.gray85,
    formInputBorderHover: basicColors$1.gray70,
    formInputBorderActive: basicColors$1.blue77,
    formInputBorderInvalid: basicColors$1.red88,
    formInputText: textColors$1.text,
    formInputPlaceholderText: textColors$1.textFaint,
    formInputDisabledText: textColors$1.textWeak,
    formFocusOutline: basicColors$1.blue95,
    formValidationMessageText: basicColors$1.white,
    formValidationMessageBg: basicColors$1.red88,
    formSwitchBg: basicColors$1.gray85,
    formSwitchBgActive: basicColors$1.blue77,
    formSwitchBgHover: basicColors$1.gray3,
    formSwitchBgActiveHover: basicColors$1.blue80,
    formSwitchBgDisabled: basicColors$1.gray4,
    formSwitchDot: basicColors$1.white,
    formCheckboxBgChecked: basicColors$1.blue77,
    formCheckboxBgCheckedHover: basicColors$1.blue80,
    formCheckboxCheckmark: basicColors$1.white,
};
var lightTheme = exports.__assign(exports.__assign({}, theme), { type: data.GrafanaThemeType.Light, isDark: false, isLight: true, name: 'Grafana Light', palette: exports.__assign(exports.__assign({}, basicColors$1), { brandPrimary: basicColors$1.orange, brandSuccess: basicColors$1.greenBase, brandWarning: basicColors$1.orange, brandDanger: basicColors$1.redBase, queryRed: basicColors$1.redBase, queryGreen: basicColors$1.greenBase, queryPurple: basicColors$1.purple, queryOrange: basicColors$1.orange, online: basicColors$1.greenShade, warn: '#f79520', critical: basicColors$1.redShade }), colors: exports.__assign(exports.__assign(exports.__assign(exports.__assign(exports.__assign({}, backgrounds$1), borders$1), textColors$1), form$1), { bodyBg: backgrounds$1.bg1, panelBg: backgrounds$1.bg1, pageHeaderBg: backgrounds$1.bg2, pageHeaderBorder: borders$1.border1, panelBorder: borders$1.border1, dropdownBg: form$1.formInputBg, dropdownShadow: basicColors$1.gray3, dropdownOptionHoverBg: backgrounds$1.bg2, 
        // Link colors
        link: textColors$1.text, linkDisabled: textColors$1.textWeak, linkHover: textColors$1.textStrong, linkExternal: basicColors$1.blue85, textHeading: basicColors$1.gray25 }), shadows: {
        listItem: 'none',
    } });

var themeMock;
var getTheme = function (name) {
    return (themeMock && themeMock(name)) || (name === 'light' ? lightTheme : darkTheme);
};
var mockTheme = function (mock) {
    themeMock = mock;
    return function () {
        themeMock = null;
    };
};

/**
 * Mock used in tests
 */
var ThemeContextMock = null;
// Used by useStyles()
var memoizedStyleCreators = new WeakMap();
// Use Grafana Dark theme by default
var ThemeContext$1 = React__default['default'].createContext(getTheme(data.GrafanaThemeType.Dark));
ThemeContext$1.displayName = 'ThemeContext';
var withTheme = function (Component) {
    var WithTheme = function (props) {
        /**
         * If theme context is mocked, let's use it instead of the original context
         * This is used in tests when mocking theme using mockThemeContext function defined below
         */
        var ContextComponent = ThemeContextMock || ThemeContext$1;
        // @ts-ignore
        return React__default['default'].createElement(ContextComponent.Consumer, null, function (theme) { return React__default['default'].createElement(Component, exports.__assign({}, props, { theme: theme })); });
    };
    WithTheme.displayName = "WithTheme(" + Component.displayName + ")";
    hoistNonReactStatics_cjs(WithTheme, Component);
    return WithTheme;
};
function useTheme() {
    return React.useContext(ThemeContextMock || ThemeContext$1);
}
/**
 * Hook for using memoized styles with access to the theme.
 *
 * NOTE: For memoization to work, you need to ensure that the function
 * you pass in doesn't change, or only if it needs to. (i.e. declare
 * your style creator outside of a function component or use `useCallback()`.)
 * */
function useStyles(getStyles) {
    var theme = useTheme();
    var memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
    if (!memoizedStyleCreator) {
        memoizedStyleCreator = stylesFactory(getStyles);
        memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
    }
    React.useEffect(function () {
        return function () {
            memoizedStyleCreators.delete(getStyles);
        };
    }, [getStyles]);
    return memoizedStyleCreator(theme);
}
/**
 * Enables theme context  mocking
 */
var mockThemeContext = function (theme) {
    ThemeContextMock = React__default['default'].createContext(theme);
    return function () {
        ThemeContextMock = null;
    };
};

/*
object-assign
(c) Sindre Sorhus
@license MIT
*/
/* eslint-disable no-unused-vars */
var getOwnPropertySymbols$1 = Object.getOwnPropertySymbols;
var hasOwnProperty$1 = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
	if (val === null || val === undefined) {
		throw new TypeError('Object.assign cannot be called with null or undefined');
	}

	return Object(val);
}

function shouldUseNative() {
	try {
		if (!Object.assign) {
			return false;
		}

		// Detect buggy property enumeration order in older V8 versions.

		// https://bugs.chromium.org/p/v8/issues/detail?id=4118
		var test1 = new String('abc');  // eslint-disable-line no-new-wrappers
		test1[5] = 'de';
		if (Object.getOwnPropertyNames(test1)[0] === '5') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test2 = {};
		for (var i = 0; i < 10; i++) {
			test2['_' + String.fromCharCode(i)] = i;
		}
		var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
			return test2[n];
		});
		if (order2.join('') !== '0123456789') {
			return false;
		}

		// https://bugs.chromium.org/p/v8/issues/detail?id=3056
		var test3 = {};
		'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
			test3[letter] = letter;
		});
		if (Object.keys(Object.assign({}, test3)).join('') !==
				'abcdefghijklmnopqrst') {
			return false;
		}

		return true;
	} catch (err) {
		// We don't expect any of the above to throw, but better to be safe.
		return false;
	}
}

var objectAssign = shouldUseNative() ? Object.assign : function (target, source) {
	var from;
	var to = toObject(target);
	var symbols;

	for (var s = 1; s < arguments.length; s++) {
		from = Object(arguments[s]);

		for (var key in from) {
			if (hasOwnProperty$1.call(from, key)) {
				to[key] = from[key];
			}
		}

		if (getOwnPropertySymbols$1) {
			symbols = getOwnPropertySymbols$1(from);
			for (var i = 0; i < symbols.length; i++) {
				if (propIsEnumerable.call(from, symbols[i])) {
					to[symbols[i]] = from[symbols[i]];
				}
			}
		}
	}

	return to;
};

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';

var ReactPropTypesSecret_1 = ReactPropTypesSecret;

var printWarning = function() {};

if (process.env.NODE_ENV !== 'production') {
  var ReactPropTypesSecret$1 = ReactPropTypesSecret_1;
  var loggedTypeFailures = {};
  var has = Function.call.bind(Object.prototype.hasOwnProperty);

  printWarning = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */
function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (process.env.NODE_ENV !== 'production') {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error;
        // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.
        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error(
              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +
              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'
            );
            err.name = 'Invariant Violation';
            throw err;
          }
          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret$1);
        } catch (ex) {
          error = ex;
        }
        if (error && !(error instanceof Error)) {
          printWarning(
            (componentName || 'React class') + ': type specification of ' +
            location + ' `' + typeSpecName + '` is invalid; the type checker ' +
            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +
            'You may have forgotten to pass an argument to the type checker ' +
            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +
            'shape all require an argument).'
          );
        }
        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;

          var stack = getStack ? getStack() : '';

          printWarning(
            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')
          );
        }
      }
    }
  }
}

/**
 * Resets warning cache when testing.
 *
 * @private
 */
checkPropTypes.resetWarningCache = function() {
  if (process.env.NODE_ENV !== 'production') {
    loggedTypeFailures = {};
  }
};

var checkPropTypes_1 = checkPropTypes;

var has$1 = Function.call.bind(Object.prototype.hasOwnProperty);
var printWarning$1 = function() {};

if (process.env.NODE_ENV !== 'production') {
  printWarning$1 = function(text) {
    var message = 'Warning: ' + text;
    if (typeof console !== 'undefined') {
      console.error(message);
    }
    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

function emptyFunctionThatReturnsNull() {
  return null;
}

var factoryWithTypeCheckers = function(isValidElement, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */
  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);
    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }

  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */

  var ANONYMOUS = '<<anonymous>>';

  // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.
  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),

    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    elementType: createElementTypeTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker,
  };

  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */
  /*eslint-disable no-self-compare*/
  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */
  function PropTypeError(message) {
    this.message = message;
    this.stack = '';
  }
  // Make `instanceof Error` still work for returned errors.
  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (process.env.NODE_ENV !== 'production') {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }
    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret_1) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          var err = new Error(
            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
            'Use `PropTypes.checkPropTypes()` to call them. ' +
            'Read more at http://fb.me/use-check-prop-types'
          );
          err.name = 'Invariant Violation';
          throw err;
        } else if (process.env.NODE_ENV !== 'production' && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;
          if (
            !manualPropTypeCallCache[cacheKey] &&
            // Avoid spamming the console because they are often not actionable except for lib authors
            manualPropTypeWarningCount < 3
          ) {
            printWarning$1(
              'You are manually calling a React.PropTypes validation ' +
              'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +
              'and will throw in the standalone `prop-types` package. ' +
              'You may be seeing this warning due to a third-party PropTypes ' +
              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'
            );
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }
      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }
          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }
        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);

    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);

        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunctionThatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }
      var propValue = props[propName];
      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }
      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret_1);
        if (error instanceof Error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!isValidElement(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createElementTypeTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      if (!reactIs.isValidElementType(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      if (process.env.NODE_ENV !== 'production') {
        if (arguments.length > 1) {
          printWarning$1(
            'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +
            'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'
          );
        } else {
          printWarning$1('Invalid argument supplied to oneOf, expected an array.');
        }
      }
      return emptyFunctionThatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
        var type = getPreciseType(value);
        if (type === 'symbol') {
          return String(value);
        }
        return value;
      });
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }
      for (var key in propValue) {
        if (has$1(propValue, key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
          if (error instanceof Error) {
            return error;
          }
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
      process.env.NODE_ENV !== 'production' ? printWarning$1('Invalid argument supplied to oneOfType, expected an instance of array.') : void 0;
      return emptyFunctionThatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];
      if (typeof checker !== 'function') {
        printWarning$1(
          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +
          'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'
        );
        return emptyFunctionThatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret_1) == null) {
          return null;
        }
      }

      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));
    }
    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      for (var key in shapeTypes) {
        var checker = shapeTypes[key];
        if (!checker) {
          continue;
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
        if (error) {
          return error;
        }
      }
      return null;
    }
    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);
      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }
      // We need to check all keys in case some are required but missing from
      // props.
      var allKeys = objectAssign({}, props[propName], shapeTypes);
      for (var key in allKeys) {
        var checker = shapeTypes[key];
        if (!checker) {
          return new PropTypeError(
            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +
            '\nBad object: ' + JSON.stringify(props[propName], null, '  ') +
            '\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')
          );
        }
        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret_1);
        if (error) {
          return error;
        }
      }
      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;
      case 'boolean':
        return !propValue;
      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }
        if (propValue === null || isValidElement(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);
        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;
          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;
              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;
      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    }

    // falsy value can't be a Symbol
    if (!propValue) {
      return false;
    }

    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'
    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    }

    // Fallback for non-spec compliant Symbols which are polyfilled.
    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  }

  // Equivalent of `typeof` but with special handling for array and regexp.
  function getPropType(propValue) {
    var propType = typeof propValue;
    if (Array.isArray(propValue)) {
      return 'array';
    }
    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }
    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }
    return propType;
  }

  // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.
  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }
    var propType = getPropType(propValue);
    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }
    return propType;
  }

  // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"
  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);
    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;
      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;
      default:
        return type;
    }
  }

  // Returns class name of the object, if any.
  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }
    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes_1;
  ReactPropTypes.resetWarningCache = checkPropTypes_1.resetWarningCache;
  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

var factoryWithThrowingShims = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret_1) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  }  shim.isRequired = shim;
  function getShim() {
    return shim;
  }  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};

var propTypes = createCommonjsModule(function (module) {
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (process.env.NODE_ENV !== 'production') {
  var ReactIs = reactIs;

  // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod
  var throwOnDirectAccess = true;
  module.exports = factoryWithTypeCheckers(ReactIs.isElement, throwOnDirectAccess);
} else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = factoryWithThrowingShims();
}
});

const Uil0Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM12.5,6h-1a3,3,0,0,0-3,3v6a3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V9A3,3,0,0,0,12.5,6Zm1,9a1,1,0,0,1-1,1h-1a1,1,0,0,1-1-1V9a1,1,0,0,1,1-1h1a1,1,0,0,1,1,1Zm8.1-6a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9Z'
  }));
};

Uil0Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil0Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil10Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM11,9v6a3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V9a3,3,0,0,0-3-3H14A3,3,0,0,0,11,9Zm5,0v6a1,1,0,0,1-1,1H14a1,1,0,0,1-1-1V9a1,1,0,0,1,1-1h1A1,1,0,0,1,16,9Zm5.6,0a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9ZM7,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,7,7Z'
  }));
};

Uil10Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil10Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil12Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,9a1,1,0,0,0,2,0,1,1,0,0,1,1-1h1a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1H14a3,3,0,0,0-3,3v3a1,1,0,0,0,1,1h5a1,1,0,0,0,0-2H13V14a1,1,0,0,1,1-1h1a3,3,0,0,0,3-3V9a3,3,0,0,0-3-3H14A3,3,0,0,0,11,9Zm7-4h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM7,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,7,7ZM21.6,9a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9Z'
  }));
};

Uil12Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil12Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil13Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM11,9a1,1,0,0,0,2,0,1,1,0,0,1,1-1h1a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1h-.5a1,1,0,0,0,0,2H15a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1H14a1,1,0,0,1-1-1,1,1,0,0,0-2,0,3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V14a3,3,0,0,0-.78-2A3,3,0,0,0,18,10V9a3,3,0,0,0-3-3H14A3,3,0,0,0,11,9ZM7,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,7,7ZM21.6,9a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9Z'
  }));
};

Uil13Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil13Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil16Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2Zm3.6,4a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9ZM7,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,7,7Zm4,2v6a3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V14a3,3,0,0,0-3-3H13V9a1,1,0,0,1,1-1h1a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H14A3,3,0,0,0,11,9Zm4,4a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1H14a1,1,0,0,1-1-1V13Z'
  }));
};

Uil16Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil16Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil17Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,7V9a1,1,0,0,0,2,0V8h2.78L14,16.8A1,1,0,0,0,14.8,18l.2,0a1,1,0,0,0,1-.8l2-10a1,1,0,0,0-.21-.83A1,1,0,0,0,17,6H12A1,1,0,0,0,11,7Zm7-2h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM7,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,7,7ZM21.6,9a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9Z'
  }));
};

Uil17Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil17Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil18Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM7,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,7,7ZM21.6,9a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9ZM11,9v1a3,3,0,0,0,.78,2A3,3,0,0,0,11,14v1a3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V14a3,3,0,0,0-.78-2A3,3,0,0,0,18,10V9a3,3,0,0,0-3-3H14A3,3,0,0,0,11,9Zm5,6a1,1,0,0,1-1,1H14a1,1,0,0,1-1-1V14a1,1,0,0,1,1-1h1a1,1,0,0,1,1,1Zm0-6v1a1,1,0,0,1-1,1H14a1,1,0,0,1-1-1V9a1,1,0,0,1,1-1h1A1,1,0,0,1,16,9Z'
  }));
};

Uil18Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil18Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil21Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,18a1,1,0,0,0,1-1V7a1,1,0,0,0-2,0V17A1,1,0,0,0,17,18ZM18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2Zm3.6,4a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9ZM10,13h1a3,3,0,0,0,3-3V9a3,3,0,0,0-3-3H10A3,3,0,0,0,7,9,1,1,0,0,0,9,9a1,1,0,0,1,1-1h1a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1H10a3,3,0,0,0-3,3v3a1,1,0,0,0,1,1h5a1,1,0,0,0,0-2H9V14A1,1,0,0,1,10,13Z'
  }));
};

Uil21Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil21Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil3Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM15.5,9a3,3,0,0,0-3-3h-1a3,3,0,0,0-3,3,1,1,0,0,0,2,0,1,1,0,0,1,1-1h1a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1H12a1,1,0,0,0,0,2h.5a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1h-1a1,1,0,0,1-1-1,1,1,0,0,0-2,0,3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V14a3,3,0,0,0-.78-2,3,3,0,0,0,.78-2Zm6.1,0a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9Z'
  }));
};

Uil3Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil3Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil500px = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,15.14a1.41,1.41,0,0,0,.17.44,6.28,6.28,0,0,0,1.39,2.08,6.67,6.67,0,0,0,2.09,1.4,6.21,6.21,0,0,0,2.54.52,6.29,6.29,0,0,0,2.55-.52,6.63,6.63,0,0,0,2.08-1.4,6.39,6.39,0,0,0,1.41-2.08A6.55,6.55,0,0,0,19.69,13a6.76,6.76,0,0,0-.51-2.56,6.35,6.35,0,0,0-1.41-2.07,6.46,6.46,0,0,0-4.63-1.92A6.63,6.63,0,0,0,10.56,7a7.09,7.09,0,0,0-1.2.68,7.14,7.14,0,0,0-1.14.94h0V3.23h9.05c.22,0,.34-.21.34-.62S17.48,2,17.26,2H7.47a.37.37,0,0,0-.3.13.4.4,0,0,0-.12.29V10a.39.39,0,0,0,.17.3,1.09,1.09,0,0,0,.41.18.73.73,0,0,0,.43,0,.92.92,0,0,0,.24-.11,1,1,0,0,0,.14-.17l0,0a6.9,6.9,0,0,1,.86-1,5.15,5.15,0,0,1,3.79-1.56A5.15,5.15,0,0,1,16.9,9.25,5.17,5.17,0,0,1,18.48,13a5.31,5.31,0,0,1-.41,2A5.36,5.36,0,0,1,15.17,18a5.4,5.4,0,0,1-2.06.4,5.09,5.09,0,0,1-2.7-.75V13a2.66,2.66,0,0,1,.71-1.79,2.53,2.53,0,0,1,2-.89,2.65,2.65,0,0,1,2,.79A2.55,2.55,0,0,1,15.87,13a2.73,2.73,0,0,1-2.77,2.74l-.34,0-.37-.07-.15,0c-.21-.06-.37.1-.49.48s-.07.6.14.68a4.34,4.34,0,0,0,1.25.18,3.84,3.84,0,0,0,2.8-1.16A3.81,3.81,0,0,0,17.1,13a3.73,3.73,0,0,0-1.16-2.78,3.8,3.8,0,0,0-2.8-1.15,3.86,3.86,0,0,0-2.82,1.15,3.57,3.57,0,0,0-1.14,2.59v3.8h0a5.63,5.63,0,0,1-1.08-1.86c-.08-.21-.3-.25-.67-.13s-.55.29-.48.49Zm6.25-11a8.16,8.16,0,0,0-3.34.64A.25.25,0,0,0,9.68,5a1.26,1.26,0,0,0,.09.43c.14.35.3.48.5.41a8.09,8.09,0,0,1,2.93-.55,7.54,7.54,0,0,1,3.08.63A8.67,8.67,0,0,1,18.59,7.4a.25.25,0,0,0,.18.08c.09,0,.24-.1.43-.29L19.39,7a.37.37,0,0,0,.06-.21.3.3,0,0,0-.1-.2,8.62,8.62,0,0,0-2.62-1.69A9,9,0,0,0,13.2,4.14Zm-1.61,9.91a.46.46,0,0,0,.2.33l0,0a.52.52,0,0,0,.35.18.24.24,0,0,0,.17-.06l.73-.73.7.68a.28.28,0,0,0,.21.11.58.58,0,0,0,.36-.19c.2-.21.23-.39.07-.55l-.7-.7.74-.74c.12-.12.08-.29-.13-.49s-.4-.27-.53-.14l-.73.72-.72-.74a.3.3,0,0,0-.15-.05.56.56,0,0,0-.34.2c-.23.22-.28.38-.16.5l.74.74-.74.72A.35.35,0,0,0,11.59,14.05Zm7.93,4.57a1.24,1.24,0,0,0-.37-.25.28.28,0,0,0-.28.07l-.07.07a8,8,0,0,1-2.51,1.69,7.94,7.94,0,0,1-8.68-1.69A7.48,7.48,0,0,1,5.91,16a9.33,9.33,0,0,1-.51-1.77.1.1,0,0,0,0,0c0-.21-.25-.29-.63-.23s-.56.2-.53.4a8.52,8.52,0,0,0,.6,2.11,8.84,8.84,0,0,0,2,2.88,9,9,0,0,0,2.89,2,9.13,9.13,0,0,0,3.54.71,9.28,9.28,0,0,0,3.54-.71,9,9,0,0,0,2.89-2l.06-.06C19.85,19.11,19.78,18.89,19.52,18.62Z'
  }));
};

Uil500px.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil500px.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const Uil6Plus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,5h1V6a1,1,0,0,0,2,0V5h1a1,1,0,0,0,0-2H21V2a1,1,0,0,0-2,0V3H18a1,1,0,0,0,0,2ZM11.5,8h1a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3h-1a3,3,0,0,0-3,3v6a3,3,0,0,0,3,3h1a3,3,0,0,0,3-3V14a3,3,0,0,0-3-3h-2V9A1,1,0,0,1,11.5,8Zm1,5a1,1,0,0,1,1,1v1a1,1,0,0,1-1,1h-1a1,1,0,0,1-1-1V13Zm9.1-4a1,1,0,0,0-.78,1.18,9,9,0,1,1-7-7,1,1,0,1,0,.4-2A10.8,10.8,0,0,0,12,1,11,11,0,1,0,23,12a10.8,10.8,0,0,0-.22-2.2A1,1,0,0,0,21.6,9Z'
  }));
};

Uil6Plus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

Uil6Plus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAbacus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2a1,1,0,0,0-1,1V6H16V5a1,1,0,0,0-2,0V6H12V5a1,1,0,0,0-2,0V6H8V5A1,1,0,0,0,6,5V6H4V3A1,1,0,0,0,2,3V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V3A1,1,0,0,0,21,2ZM20,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V16H6v1a1,1,0,0,0,2,0V16h2v1a1,1,0,0,0,2,0V16h4v1a1,1,0,0,0,2,0V16h2Zm0-5H18V13a1,1,0,0,0-2,0v1H12V13a1,1,0,0,0-2,0v1H8V13a1,1,0,0,0-2,0v1H4V8H6V9A1,1,0,0,0,8,9V8h2V9a1,1,0,0,0,2,0V8h2V9a1,1,0,0,0,2,0V8h4Z'
  }));
};

UilAbacus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAbacus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAccessibleIconAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,7a2,2,0,1,0-2-2A2,2,0,0,0,16,7ZM12.7,18.4A4,4,0,1,1,9.05,12a1,1,0,1,0-.22-2A6,6,0,0,0,9.5,22a6,6,0,0,0,4.8-2.4,1,1,0,0,0-1.6-1.2ZM19.5,20h-1V15a1,1,0,0,0-1-1H12.93l1.69-4.66s0-.07,0-.11l0-.2a1.1,1.1,0,0,0,0-.18,1.06,1.06,0,0,0,0-.19,1.4,1.4,0,0,0-.09-.17.72.72,0,0,0-.11-.15.64.64,0,0,0-.15-.13s0-.06-.08-.08L9.71,5.55l-.12,0a1.06,1.06,0,0,0-.19-.06H9a.8.8,0,0,0-.2.07l-.11,0L6,7.13A1,1,0,0,0,6.48,9,1,1,0,0,0,7,8.87l2.23-1.3,3.24,1.88-1.89,5.21a.88.88,0,0,0,0,.16.58.58,0,0,0,0,.18,0,0,0,0,0,0,0,3,3,0,0,0,.08.38l.11.15a.57.57,0,0,0,.11.16.67.67,0,0,0,.14.09,1.22,1.22,0,0,0,.19.12h0a1,1,0,0,0,.34.06h5v5a1,1,0,0,0,1,1h2a1,1,0,0,0,0-2Z'
  }));
};

UilAccessibleIconAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAccessibleIconAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAdjust = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2ZM11,19.93A8,8,0,0,1,11,4.07Zm2,0V4.07a8,8,0,0,1,0,15.86Z'
  }));
};

UilAdjust.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAdjust.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAdjustAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.83,7.32h0a.2.2,0,0,0,0-.08,10,10,0,0,0-3.38-3.65l0,0h0A9.89,9.89,0,0,0,12,2a1,1,0,0,0-1,1V21a1,1,0,0,0,1,1h.28A10,10,0,0,0,20.83,7.32ZM13,4.06a8,8,0,0,1,2.49.74L13,9.12Zm0,9.06L17.17,5.9a7.89,7.89,0,0,1,1.58,1.83L13,17.69Zm1.16,6.57L19.75,10A8.36,8.36,0,0,1,20,12,7.94,7.94,0,0,1,14.16,19.69Z'
  }));
};

UilAdjustAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAdjustAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAdjustCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,7A7.74,7.74,0,1,0,7,17,7.74,7.74,0,1,0,17,7Zm-1.6,1.6a6.12,6.12,0,0,1,.11,1.14,5.92,5.92,0,0,1-.16,1.34L12.91,8.66a5.92,5.92,0,0,1,1.34-.16A6.12,6.12,0,0,1,15.39,8.61ZM14.46,13A6,6,0,0,1,13,14.46L9.54,11A6,6,0,0,1,11,9.54Zm-8,1.46a5.75,5.75,0,1,1,8-8h-.25A7.76,7.76,0,0,0,6.5,14.25C6.5,14.33,6.51,14.42,6.51,14.5Zm2.1.89a6.12,6.12,0,0,1-.11-1.14,5.92,5.92,0,0,1,.16-1.34l2.43,2.43a5.92,5.92,0,0,1-1.34.16A6.12,6.12,0,0,1,8.61,15.39ZM14.25,20A5.77,5.77,0,0,1,9.5,17.49h.25A7.76,7.76,0,0,0,17.5,9.75c0-.08,0-.17,0-.25A5.75,5.75,0,0,1,14.25,20Z'
  }));
};

UilAdjustCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAdjustCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAdjustHalf = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.83,7.32h0a10.11,10.11,0,0,0-3.44-3.73l0,0h0A10,10,0,1,0,12,22h.29A10,10,0,0,0,20.83,7.32ZM11,19.93A8,8,0,0,1,11,4.07ZM13,4.07a8.07,8.07,0,0,1,2.49.74L13,9.12Zm0,9L17.17,5.9a8.14,8.14,0,0,1,1.58,1.83L13,17.69Zm1.15,6.58L19.74,10A8.16,8.16,0,0,1,20,12,8,8,0,0,1,14.15,19.7Z'
  }));
};

UilAdjustHalf.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAdjustHalf.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAdobe = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.07,17.28h2.78l1.75,3.44h2.54L12,9.87ZM2,3V21L9.42,3ZM14.48,3,22,20.81V3Z'
  }));
};

UilAdobe.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAdobe.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAdobeAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.24707,2.40278a.99893.99893,0,0,0-.83057-.44336H1.9917a.99974.99974,0,0,0-1,1v18.082a1.00015,1.00015,0,0,0,1.92529.37989l7.42481-18.082A1.00042,1.00042,0,0,0,10.24707,2.40278ZM2.9917,15.97309V3.95942H7.9248Zm19-14.01367H14.47412a1,1,0,0,0-.92139,1.3877l7.51758,17.84961a.99894.99894,0,0,0,.9209.6123,1.04879,1.04879,0,0,0,.19824-.01953,1.001,1.001,0,0,0,.80225-.98047V2.95942A.99974.99974,0,0,0,21.9917,1.95942Zm-1,13.89844L15.98047,3.95942H20.9917ZM12.94922,9.52a.99993.99993,0,0,0-.92578-.64648h-.00977a.99988.99988,0,0,0-.92822.62793L8.02637,17.13227a1,1,0,0,0,.92822,1.37207H11.209l1.52247,2.99024a.999.999,0,0,0,.89111.54687h2.61279a1.00015,1.00015,0,0,0,.93555-1.35351Zm1.28662,10.52148-1.52246-2.99023a.99905.99905,0,0,0-.89111-.54688H10.43262l1.55371-3.875,2.80176,7.41211Z'
  }));
};

UilAdobeAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAdobeAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAirplay = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.83,13.45a1,1,0,0,0-1.66,0l-4,6a1,1,0,0,0,0,1A1,1,0,0,0,8,21h8a1,1,0,0,0,.88-.53,1,1,0,0,0-.05-1ZM9.87,19,12,15.8,14.13,19ZM19,3H5A3,3,0,0,0,2,6v9a3,3,0,0,0,3,3h.85a1,1,0,1,0,0-2H5a1,1,0,0,1-1-1V6A1,1,0,0,1,5,5H19a1,1,0,0,1,1,1v9a1,1,0,0,1-1,1h-.85a1,1,0,0,0,0,2H19a3,3,0,0,0,3-3V6A3,3,0,0,0,19,3Z'
  }));
};

UilAirplay.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAirplay.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlign = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,15H13a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2Zm0-4H13a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2ZM3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7ZM21,17H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM19.64,9.57a1,1,0,1,0-1.28,1.53l1.08.9-1.08.9a1,1,0,0,0-.13,1.41,1,1,0,0,0,.77.36,1,1,0,0,0,.64-.24l2-1.66a1,1,0,0,0,0-1.54Z'
  }));
};

UilAlign.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlign.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,11H3a1,1,0,0,0,0,2h7a1,1,0,0,0,0-2Zm0,8H3a1,1,0,0,0,0,2h7a1,1,0,0,0,0-2ZM14,5h7a1,1,0,0,0,0-2H14a1,1,0,0,0,0,2ZM10,7H3A1,1,0,0,0,3,9h7a1,1,0,0,0,0-2Zm0,8H3a1,1,0,0,0,0,2h7a1,1,0,0,0,0-2ZM10,3H7A1,1,0,0,0,7,5h3a1,1,0,0,0,0-2ZM21,7H14a1,1,0,0,0,0,2h7a1,1,0,0,0,0-2Zm0,4H14a1,1,0,0,0,0,2h7a1,1,0,0,0,0-2Zm-4,8H14a1,1,0,0,0,0,2h3a1,1,0,0,0,0-2Zm4-4H14a1,1,0,0,0,0,2h7a1,1,0,0,0,0-2Z'
  }));
};

UilAlignAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignCenter = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7ZM7,9a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Zm14,4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm-4,4H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Z'
  }));
};

UilAlignCenter.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignCenter.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignCenterAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,8H19a1,1,0,0,0,0-2H5A1,1,0,0,0,5,8Zm16,3H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm-2,5H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2Z'
  }));
};

UilAlignCenterAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignCenterAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignCenterH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,11.62a1,1,0,0,0-.21-.33l-2.5-2.5a1,1,0,0,0-1.42,1.42l.8.79H16a1,1,0,0,0,0,2h2.59l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62ZM8,11H5.41l.8-.79A1,1,0,0,0,4.79,8.79l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H8a1,1,0,0,0,0-2Zm4-4a1,1,0,0,0-1,1v8a1,1,0,0,0,2,0V8A1,1,0,0,0,12,7Z'
  }));
};

UilAlignCenterH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignCenterH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignCenterJustify = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,15H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM3,5H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,5ZM17,19H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2ZM21,7H3A1,1,0,0,0,3,9H21a1,1,0,0,0,0-2Zm0,4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilAlignCenterJustify.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignCenterJustify.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignCenterV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.21,6.21l.79-.8V8a1,1,0,0,0,2,0V5.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42ZM16,11H8a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Zm-2.21,6.79-.79.8V16a1,1,0,0,0-2,0v2.59l-.79-.8a1,1,0,0,0-1.42,1.42l2.5,2.5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilAlignCenterV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignCenterV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignJustify = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7ZM21,17H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilAlignJustify.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignJustify.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7Zm0,4H17a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2Zm18,2H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm-4,4H3a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Z'
  }));
};

UilAlignLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignLeftJustify = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,5H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,5ZM15,19H3a1,1,0,0,0,0,2H15a1,1,0,0,0,0-2Zm6-8H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-4H3A1,1,0,0,0,3,9H21a1,1,0,0,0,0-2Zm0,8H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilAlignLeftJustify.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignLeftJustify.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignLetterRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,4H21a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2ZM21,20H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM21,6H3A1,1,0,0,0,3,8H21a1,1,0,0,0,0-2Zm0,10H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-6H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilAlignLetterRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignLetterRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7ZM21,17H7a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-8H7a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0,4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilAlignRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAlignRightJustify = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,5H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,5ZM21,19H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-8H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0,4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-8H3A1,1,0,0,0,3,9H21a1,1,0,0,0,0-2Z'
  }));
};

UilAlignRightJustify.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAlignRightJustify.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAmazon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M1.04,17.52q.1-.16.32-.02a21.3078,21.3078,0,0,0,10.88,2.9,21.52431,21.52431,0,0,0,7.74-1.46q.1-.04.29-.12t.27-.12a.35611.35611,0,0,1,.47.12q.17.24-.11.44-.36.26-.92.6a14.99023,14.99023,0,0,1-3.84,1.58A16.1749,16.1749,0,0,1,12,22a16.01714,16.01714,0,0,1-5.9-1.09,16.24638,16.24638,0,0,1-4.98-3.07.273.273,0,0,1-.12-.2A.215.215,0,0,1,1.04,17.52Zm6.02-5.7a4.03628,4.03628,0,0,1,.68-2.36A4.19676,4.19676,0,0,1,9.6,7.98a10.06288,10.06288,0,0,1,2.66-.66q.54-.06,1.76-.16V6.82a3.56151,3.56151,0,0,0-.28-1.72,1.49917,1.49917,0,0,0-1.32-.6h-.16a2.18852,2.18852,0,0,0-1.14.42,1.63936,1.63936,0,0,0-.62,1,.50779.50779,0,0,1-.4.46L7.8,6.1q-.34-.08-.34-.36a.58734.58734,0,0,1,.02-.14A3.83352,3.83352,0,0,1,9.15,2.96,6.26811,6.26811,0,0,1,12.26,2h.5a5.05441,5.05441,0,0,1,3.56,1.18,3.81,3.81,0,0,1,.37.43,3.8746,3.8746,0,0,1,.27.41,2.09844,2.09844,0,0,1,.18.52q.08.34.12.47a2.85611,2.85611,0,0,1,.06.56q.02.43.02.51v4.84a2.86841,2.86841,0,0,0,.15.95,2.47465,2.47465,0,0,0,.29.62q.14.19.46.61a.59856.59856,0,0,1,.12.32.346.346,0,0,1-.16.28q-1.66,1.44-1.8,1.56a.557.557,0,0,1-.58.04q-.28-.24-.49-.46t-.3-.32a4.46629,4.46629,0,0,1-.29-.39q-.2-.29-.28-.39a4.91083,4.91083,0,0,1-2.2,1.52,6.03757,6.03757,0,0,1-1.68.2,3.50454,3.50454,0,0,1-2.53-.95A3.553,3.553,0,0,1,7.06,11.82Zm3.44-.4a1.89505,1.89505,0,0,0,.39,1.25,1.29375,1.29375,0,0,0,1.05.47,1.022,1.022,0,0,0,.17-.02,1.02168,1.02168,0,0,1,.15-.02,2.03262,2.03262,0,0,0,1.3-1.08,3.13045,3.13045,0,0,0,.33-.83,3.80062,3.80062,0,0,0,.12-.73q.01-.28.01-.92v-.5a7.28689,7.28689,0,0,0-1.76.16A2.1441,2.1441,0,0,0,10.5,11.42Zm8.4,6.44a.62647.62647,0,0,1,.12-.16,3.13921,3.13921,0,0,1,.96-.46,6.52032,6.52032,0,0,1,1.48-.22,1.19457,1.19457,0,0,1,.38.02q.9.08,1.08.3a.65471.65471,0,0,1,.08.36v.14a4.55955,4.55955,0,0,1-.38,1.65,3.84046,3.84046,0,0,1-1.06,1.53.302.302,0,0,1-.18.08.17736.17736,0,0,1-.08-.02q-.12-.06-.06-.22a7.63215,7.63215,0,0,0,.74-2.42.51274.51274,0,0,0-.08-.32q-.2-.24-1.12-.24-.34,0-.8.04-.5.06-.92.12A.23166.23166,0,0,1,18.9,18a.06531.06531,0,0,1-.02-.08A.15332.15332,0,0,1,18.9,17.86Z'
  }));
};

UilAmazon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAmazon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAmbulance = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.5,9.5h-1v-1a1,1,0,0,0-2,0v1h-1a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h1a1,1,0,0,0,0-2Zm12.43,2.15-.06-.11a.61.61,0,0,0-.07-.14L20.4,8.2A3,3,0,0,0,18,7H16V6a3,3,0,0,0-3-3H4A3,3,0,0,0,1,6V17a1,1,0,0,0,1,1H3a3,3,0,0,0,6,0h6a3,3,0,0,0,6,0h1a1,1,0,0,0,1-1V12A1,1,0,0,0,22.93,11.65ZM6,19a1,1,0,1,1,1-1A1,1,0,0,1,6,19Zm8-3H8.22a3,3,0,0,0-4.44,0H3V6A1,1,0,0,1,4,5h9a1,1,0,0,1,1,1Zm2-7h2a1,1,0,0,1,.8.4L20,11H16Zm2,10a1,1,0,1,1,1-1A1,1,0,0,1,18,19Zm3-3h-.78A3,3,0,0,0,16,15.78V13h5Z'
  }));
};

UilAmbulance.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAmbulance.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAnalysis = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,7.29a1,1,0,0,0-1.42,0L14,13.59,9.71,9.29a1,1,0,0,0-1.42,0l-6,6a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L9,11.41l4.29,4.3a1,1,0,0,0,1.42,0l7-7A1,1,0,0,0,21.71,7.29Z'
  }));
};

UilAnalysis.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAnalysis.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAnalytics = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,12a1,1,0,0,0-1,1v8a1,1,0,0,0,2,0V13A1,1,0,0,0,5,12ZM10,2A1,1,0,0,0,9,3V21a1,1,0,0,0,2,0V3A1,1,0,0,0,10,2ZM20,16a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V17A1,1,0,0,0,20,16ZM15,8a1,1,0,0,0-1,1V21a1,1,0,0,0,2,0V9A1,1,0,0,0,15,8Z'
  }));
};

UilAnalytics.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAnalytics.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAnchor = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,13H17a1,1,0,0,0,0,2h.91A6,6,0,0,1,13,19.91V11h1a1,1,0,0,0,0-2H13V7.82a3,3,0,1,0-2,0V9H10a1,1,0,0,0,0,2h1v8.91A6,6,0,0,1,6.09,15H7a1,1,0,0,0,0-2H5a1,1,0,0,0-1,1,8,8,0,0,0,16,0A1,1,0,0,0,19,13ZM12,6a1,1,0,1,1,1-1A1,1,0,0,1,12,6Z'
  }));
};

UilAnchor.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAnchor.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAndroid = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.97535,3.01886l.95982-1.73159a.19342.19342,0,0,0-.33833-.18756l-.97045,1.75078a6.54141,6.54141,0,0,0-5.25275,0L8.40316,1.09971a.19342.19342,0,0,0-.33833.18756l.95985,1.7316A5.54614,5.54614,0,0,0,5.93152,7.89522h12.137A5.54615,5.54615,0,0,0,14.97535,3.01886ZM9.19911,5.67446a.5068.5068,0,1,1,.5068-.5068A.50737.50737,0,0,1,9.19911,5.67446Zm5.60178,0a.5068.5068,0,1,1,.5068-.5068A.50737.50737,0,0,1,14.80089,5.67446Zm-8.86946,11.497a1.46713,1.46713,0,0,0,1.46713,1.46713h.9736v3.00095a1.36046,1.36046,0,1,0,2.72091,0V18.63859h1.81386v3.00095a1.36046,1.36046,0,1,0,2.72091,0V18.63859h.97364a1.46713,1.46713,0,0,0,1.46713-1.46713V8.37532H5.93143ZM4.06415,8.14191A1.362,1.362,0,0,0,2.7037,9.50237v5.66846a1.36046,1.36046,0,1,0,2.72091,0V9.50237A1.362,1.362,0,0,0,4.06415,8.14191Zm15.8717,0a1.362,1.362,0,0,0-1.36046,1.36046v5.66846a1.36046,1.36046,0,1,0,2.72091,0V9.50237A1.362,1.362,0,0,0,19.93585,8.14191Z'
  }));
};

UilAndroid.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAndroid.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAndroidAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M2.9917,9.00044a.99973.99973,0,0,0-1,1v4a1,1,0,0,0,2,0v-4A.99973.99973,0,0,0,2.9917,9.00044Zm18,0a.99973.99973,0,0,0-1,1v4a1,1,0,0,0,2,0v-4A.99973.99973,0,0,0,20.9917,9.00044Zm-4.13428-5.5a.99974.99974,0,1,0-1.73144-1l-.61414,1.06238a5.92782,5.92782,0,0,0-5.04028,0L8.85742,2.50044a.99974.99974,0,1,0-1.73144,1l.6925,1.19794A5.97889,5.97889,0,0,0,5.9917,9.00044v8a.99974.99974,0,0,0,1,1h2v3a1,1,0,0,0,2,0v-3h2v3a1,1,0,0,0,2,0v-3h2a.99974.99974,0,0,0,1-1v-8a5.97889,5.97889,0,0,0-1.82678-4.30206Zm-.86572,12.5h-8v-5h8Zm-8-7a4,4,0,0,1,8,0Z'
  }));
};

UilAndroidAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAndroidAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAndroidPhoneSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,17.71a1,1,0,0,0,1.42,0,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76,1.15,1.15,0,0,0-.21-.33,1,1,0,0,0-1.42,0,1.15,1.15,0,0,0-.21.33.94.94,0,0,0,0,.76A1.15,1.15,0,0,0,11.29,17.71ZM8.66,4H16a1,1,0,0,1,1,1v7.34a1,1,0,0,0,2,0V5a3,3,0,0,0-3-3H8.66a1,1,0,0,0,0,2ZM21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71L5,6.41V19a3,3,0,0,0,3,3h8a3,3,0,0,0,2.76-1.83l1.53,1.54a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM17,19a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V8.41l10,10Z'
  }));
};

UilAndroidPhoneSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAndroidPhoneSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleDoubleDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,11.46a1,1,0,0,0,1.42,0l3-3A1,1,0,1,0,14.29,7L12,9.34,9.71,7A1,1,0,1,0,8.29,8.46Zm3,1.08L12,14.84l-2.29-2.3A1,1,0,0,0,8.29,14l3,3a1,1,0,0,0,1.42,0l3-3a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilAngleDoubleDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleDoubleDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleDoubleLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.46,8.29a1,1,0,0,0-1.42,0l-3,3a1,1,0,0,0,0,1.42l3,3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L9.16,12l2.3-2.29A1,1,0,0,0,11.46,8.29ZM14.66,12,17,9.71a1,1,0,0,0-1.42-1.42l-3,3a1,1,0,0,0,0,1.42l3,3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z'
  }));
};

UilAngleDoubleLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleDoubleLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleDoubleRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.46,8.29A1,1,0,1,0,7,9.71L9.34,12,7,14.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,0-1.42Zm8.5,3-3-3a1,1,0,0,0-1.42,1.42L14.84,12l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3A1,1,0,0,0,17,11.29Z'
  }));
};

UilAngleDoubleRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleDoubleRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleDoubleUp = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,12.54a1,1,0,0,0-1.42,0l-3,3A1,1,0,0,0,9.71,17L12,14.66,14.29,17a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm-3-1.08L12,9.16l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-3-3a1,1,0,0,0-1.42,0l-3,3a1,1,0,0,0,1.42,1.42Z'
  }));
};

UilAngleDoubleUp.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleDoubleUp.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,9.17a1,1,0,0,0-1.41,0L12,12.71,8.46,9.17a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l4.24,4.24a1,1,0,0,0,1.42,0L17,10.59A1,1,0,0,0,17,9.17Z'
  }));
};

UilAngleDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,12l3.54-3.54a1,1,0,0,0,0-1.41,1,1,0,0,0-1.42,0L9.17,11.29a1,1,0,0,0,0,1.42L13.41,17a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41Z'
  }));
};

UilAngleLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleLeftB = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,12.8l5.7,5.6c0.4,0.4,1,0.4,1.4,0c0,0,0,0,0,0c0.4-0.4,0.4-1,0-1.4l-4.9-5l4.9-5c0.4-0.4,0.4-1,0-1.4c-0.2-0.2-0.4-0.3-0.7-0.3c-0.3,0-0.5,0.1-0.7,0.3l-5.7,5.6C8.1,11.7,8.1,12.3,8.5,12.8C8.5,12.7,8.5,12.7,8.5,12.8z'
  }));
};

UilAngleLeftB.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleLeftB.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.83,11.29,10.59,7.05a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41L12.71,12,9.17,15.54a1,1,0,0,0,0,1.41,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l4.24-4.24A1,1,0,0,0,14.83,11.29Z'
  }));
};

UilAngleRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleRightB = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.54,11.29,9.88,5.64a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l4.95,5L8.46,17a1,1,0,0,0,0,1.41,1,1,0,0,0,.71.3,1,1,0,0,0,.71-.3l5.66-5.65A1,1,0,0,0,15.54,11.29Z'
  }));
};

UilAngleRightB.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleRightB.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngleUp = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,13.41,12.71,9.17a1,1,0,0,0-1.42,0L7.05,13.41a1,1,0,0,0,0,1.42,1,1,0,0,0,1.41,0L12,11.29l3.54,3.54a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29A1,1,0,0,0,17,13.41Z'
  }));
};

UilAngleUp.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngleUp.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAngry = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,11a1,1,0,0,0,.89-.55,1,1,0,0,0-.44-1.34l-2-1a1,1,0,1,0-.9,1.78l2,1A.93.93,0,0,0,10,11Zm2-9A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM8.36,15.33a1,1,0,0,0-.13,1.4,1,1,0,0,0,1.41.13,3.76,3.76,0,0,1,4.72,0,1,1,0,0,0,.64.23,1,1,0,0,0,.64-1.76A5.81,5.81,0,0,0,8.36,15.33Zm7.19-7.22-2,1a1,1,0,0,0-.44,1.34A1,1,0,0,0,14,11a.93.93,0,0,0,.45-.11l2-1a1,1,0,0,0-.9-1.78Z'
  }));
};

UilAngry.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAngry.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAnkh = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,12H14.91A7.23,7.23,0,0,0,17,7,5,5,0,0,0,7,7a7.23,7.23,0,0,0,2.09,5H6a1,1,0,0,0,0,2h5v7a1,1,0,0,0,2,0V14h5a1,1,0,0,0,0-2Zm-6-.16C11.07,11.22,9,9.58,9,7a3,3,0,0,1,6,0C15,9.58,12.93,11.23,12,11.84Z'
  }));
};

UilAnkh.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAnkh.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAnnoyed = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,9a1,1,0,1,0,1,1A1,1,0,0,0,9,9Zm6,4a5,5,0,0,0-4.37,2.57A1,1,0,0,0,11,16.93a1,1,0,0,0,.49.13,1,1,0,0,0,.87-.51A3,3,0,0,1,15,15a1,1,0,0,0,0-2Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,15,9ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilAnnoyed.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAnnoyed.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAnnoyedAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.66,13.56l-4.19,1.5A1,1,0,0,0,10.8,17a1,1,0,0,0,.34-.06l4.2-1.5a1,1,0,1,0-.68-1.88Zm-4-5a1,1,0,0,0-1.41,0,1,1,0,0,1-1.42,0,1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42,3,3,0,0,0,4.24,0A1,1,0,0,0,10.62,8.54Zm7,0a1,1,0,0,0-1.41,0,1,1,0,0,1-1.42,0,1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42,3,3,0,0,0,4.24,0A1,1,0,0,0,17.62,8.54ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilAnnoyedAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAnnoyedAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilApple = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.94,5.19A4.38,4.38,0,0,0,16,2,4.44,4.44,0,0,0,13,3.52,4.17,4.17,0,0,0,12,6.61,3.69,3.69,0,0,0,14.94,5.19Zm2.52,7.44a4.51,4.51,0,0,1,2.16-3.81,4.66,4.66,0,0,0-3.66-2c-1.56-.16-3,.91-3.83.91s-2-.89-3.3-.87A4.92,4.92,0,0,0,4.69,9.39C2.93,12.45,4.24,17,6,19.47,6.8,20.68,7.8,22.05,9.12,22s1.75-.82,3.28-.82,2,.82,3.3.79,2.22-1.24,3.06-2.45a11,11,0,0,0,1.38-2.85A4.41,4.41,0,0,1,17.46,12.63Z'
  }));
};

UilApple.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilApple.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAppleAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.50439,15.7436a3.38641,3.38641,0,0,1-2.05468-3.127,3.49747,3.49747,0,0,1,1.6875-2.94629.99994.99994,0,0,0,.2998-1.415A5.57386,5.57386,0,0,0,16.4209,5.86958,6.422,6.422,0,0,0,17.38574,1.893a.98411.98411,0,0,0-1.0332-.8916,6.69083,6.69083,0,0,0-4.44336,2.26074,6.84216,6.84216,0,0,0-1.47949,2.89941,5.2637,5.2637,0,0,0-1.62012-.27734A5.92528,5.92528,0,0,0,3.81885,8.892c-1.8877,3.27734-.73291,8.18848,1.312,11.14453.82031,1.18457,2.05127,2.96289,3.9082,2.96289.03662,0,.07373,0,.11084-.002a4.74,4.74,0,0,0,1.79248-.46387,3.274,3.274,0,0,1,1.44532-.35351,3.04472,3.04472,0,0,1,1.35742.33789,4.75244,4.75244,0,0,0,1.96191.45605c1.91309-.03613,3.043-1.68652,3.86817-2.89258a12.04214,12.04214,0,0,0,1.51269-3.1084A1.00325,1.00325,0,0,0,20.50439,15.7436ZM13.42334,4.56782a4.94131,4.94131,0,0,1,1.91943-1.32226,4.85545,4.85545,0,0,1-1.03662,2.15136A4.39075,4.39075,0,0,1,13.042,6.437l-.00293.001c-.02832.01172-.05664.02246-.085.03418-.18652.07324-.417.16406-.59472.22265A4.825,4.825,0,0,1,13.42334,4.56782ZM17.9248,18.95259c-.80371,1.17383-1.436,2.00683-2.25439,2.02148a2.36658,2.36658,0,0,1-1.13135-.292,4.96942,4.96942,0,0,0-2.15136-.502,5.21424,5.21424,0,0,0-2.22852.51269,2.88493,2.88493,0,0,1-1.08594.30664H9.04346c-.813,0-1.6875-1.26269-2.26807-2.10156-1.45264-2.09961-2.79248-6.2832-1.22314-9.00781A3.917,3.917,0,0,1,8.84277,7.88423l.03369-.001a4.75808,4.75808,0,0,1,1.64112.44434c.13135.05175.26074.10351.38916.15136.03271.01368.0664.02637.10058.03711a3.31547,3.31547,0,0,0,1.11719.23731,4.436,4.436,0,0,0,1.564-.4209,4.95643,4.95643,0,0,1,2.22265-.49707,3.787,3.787,0,0,1,2.25049.85352,5.31025,5.31025,0,0,0-1.71191,3.94531v.001a5.30031,5.30031,0,0,0,2.45117,4.50293A10.19829,10.19829,0,0,1,17.9248,18.95259Z'
  }));
};

UilAppleAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAppleAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilApps = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,13H3a1,1,0,0,0-1,1v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V14A1,1,0,0,0,10,13ZM9,20H4V15H9ZM21,2H14a1,1,0,0,0-1,1v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,9H15V4h5Zm1,4H14a1,1,0,0,0-1,1v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V14A1,1,0,0,0,21,13Zm-1,7H15V15h5ZM10,2H3A1,1,0,0,0,2,3v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V3A1,1,0,0,0,10,2ZM9,9H4V4H9Z'
  }));
};

UilApps.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilApps.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArchive = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,14h4a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2ZM19,3H5A3,3,0,0,0,2,6V9a1,1,0,0,0,1,1H4v8a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V10h1a1,1,0,0,0,1-1V6A3,3,0,0,0,19,3ZM18,18a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V10H18ZM20,8H4V6A1,1,0,0,1,5,5H19a1,1,0,0,1,1,1Z'
  }));
};

UilArchive.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArchive.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArchiveAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,13h4a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2ZM19,3H5A3,3,0,0,0,4,8.82V18a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V8.82A3,3,0,0,0,19,3ZM18,18a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V9H18ZM19,7H5A1,1,0,0,1,5,5H19a1,1,0,0,1,0,2Z'
  }));
};

UilArchiveAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArchiveAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArchway = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,20H21V8h1a1,1,0,0,0,0-2H21V3a1,1,0,0,0-1-1H4A1,1,0,0,0,3,3V6H2A1,1,0,0,0,2,8H3V20H2a1,1,0,0,0,0,2H22a1,1,0,0,0,0-2Zm-7,0H9V16.47a6.21,6.21,0,0,1,3-5.33,6.21,6.21,0,0,1,3,5.33Zm4,0H17V16.47a8.17,8.17,0,0,0-4.55-7.36,1,1,0,0,0-.9,0A8.17,8.17,0,0,0,7,16.47V20H5V8H19ZM19,6H5V4H19Z'
  }));
};

UilArchway.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArchway.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrow = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.71,6.29a1,1,0,0,0-1.42,0l-5,5a1,1,0,0,0,0,1.42l5,5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,12l4.3-4.29A1,1,0,0,0,9.71,6.29Zm11,5-5-5a1,1,0,0,0-1.42,1.42L18.59,12l-4.3,4.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l5-5A1,1,0,0,0,20.71,11.29Z'
  }));
};

UilArrow.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrow.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowBreak = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,11H17a1,1,0,0,0,0-2H13V5.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42l.79-.8V9H7a1,1,0,0,0,0,2Zm10,2H7a1,1,0,0,0,0,2h4v3.59l-.79-.8a1,1,0,0,0-1.42,1.42l2.5,2.5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,0,0-1.42-1.42l-.79.8V15h4a1,1,0,0,0,0-2Z'
  }));
};

UilArrowBreak.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowBreak.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowCircleDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,15.71a1,1,0,0,0,.33.21,1,1,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3a1,1,0,0,0-1.42-1.42L13,12.59V9a1,1,0,0,0-2,0v3.59l-1.29-1.3a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.42ZM12,22A10,10,0,1,0,2,12,10,10,0,0,0,12,22ZM12,4a8,8,0,1,1-8,8A8,8,0,0,1,12,4Z'
  }));
};

UilArrowCircleDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowCircleDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowCircleLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.29,11.29a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l3,3a1,1,0,0,0,1.42-1.42L11.41,13H15a1,1,0,0,0,0-2H11.41l1.3-1.29a1,1,0,0,0,0-1.42,1,1,0,0,0-1.42,0ZM2,12A10,10,0,1,0,12,2,10,10,0,0,0,2,12Zm18,0a8,8,0,1,1-8-8A8,8,0,0,1,20,12Z'
  }));
};

UilArrowCircleLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowCircleLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowCircleRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.71,12.71a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L12.59,11H9a1,1,0,0,0,0,2h3.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0ZM22,12A10,10,0,1,0,12,22,10,10,0,0,0,22,12ZM4,12a8,8,0,1,1,8,8A8,8,0,0,1,4,12Z'
  }));
};

UilArrowCircleRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowCircleRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowCircleUp = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,8.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3a1,1,0,0,0,1.42,1.42L11,11.41V15a1,1,0,0,0,2,0V11.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilArrowCircleUp.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowCircleUp.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowCompressH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,5a1,1,0,0,0-1,1V18a1,1,0,0,0,2,0V6A1,1,0,0,0,12,5Zm-1.29,6.29-2.5-2.5a1,1,0,1,0-1.42,1.42l.8.79H3a1,1,0,0,0,0,2H7.59l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33.94.94,0,0,0,0-.76A1,1,0,0,0,10.71,11.29ZM21,11H16.41l.8-.79a1,1,0,0,0-1.42-1.42l-2.5,2.5a1,1,0,0,0,0,1.42l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-.8-.79H21a1,1,0,0,0,0-2Z'
  }));
};

UilArrowCompressH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowCompressH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.71,11.29a1,1,0,0,0-1.42,0L13,14.59V7a1,1,0,0,0-2,0v7.59l-3.29-3.3a1,1,0,0,0-1.42,1.42l5,5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l5-5A1,1,0,0,0,17.71,11.29Z'
  }));
};

UilArrowDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowDownLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,16H9.41l8.3-8.29a1,1,0,1,0-1.42-1.42L8,14.59V7A1,1,0,0,0,6,7V17a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54A1,1,0,0,0,7,18H17a1,1,0,0,0,0-2Z'
  }));
};

UilArrowDownLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowDownLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowDownRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,6a1,1,0,0,0-1,1v7.59L7.71,6.29A1,1,0,0,0,6.29,7.71L14.59,16H7a1,1,0,0,0,0,2H17a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,18,17V7A1,1,0,0,0,17,6Z'
  }));
};

UilArrowDownRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowDownRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowFromRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,4A1,1,0,0,0,2,5V19a1,1,0,0,0,2,0V5A1,1,0,0,0,3,4Zm18.92,7.62a1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L18.59,11H7a1,1,0,0,0,0,2H18.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62Z'
  }));
};

UilArrowFromRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowFromRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowFromTop = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.29,16.29,13,18.59V7a1,1,0,0,0-2,0V18.59l-2.29-2.3a1,1,0,1,0-1.42,1.42l4,4a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4-4a1,1,0,0,0-1.42-1.42ZM19,2H5A1,1,0,0,0,5,4H19a1,1,0,0,0,0-2Z'
  }));
};

UilArrowFromTop.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowFromTop.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowGrowth = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,6.62a1,1,0,0,0-.54-.54A1,1,0,0,0,21,6H16a1,1,0,0,0,0,2h2.59L13,13.59l-3.29-3.3a1,1,0,0,0-1.42,0l-6,6a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L9,12.41l3.29,3.3a1,1,0,0,0,1.42,0L20,9.41V12a1,1,0,0,0,2,0V7A1,1,0,0,0,21.92,6.62Z'
  }));
};

UilArrowGrowth.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowGrowth.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,11H9.41l3.3-3.29a1,1,0,1,0-1.42-1.42l-5,5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l5,5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L9.41,13H17a1,1,0,0,0,0-2Z'
  }));
};

UilArrowLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowRandom = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.7,10a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41L3.84,2.29A1,1,0,0,0,2.42,3.71ZM21,14a1,1,0,0,0-1,1v3.59L15.44,14A1,1,0,0,0,14,15.44L18.59,20H15a1,1,0,0,0,0,2h6a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V15A1,1,0,0,0,21,14Zm.92-11.38a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H15a1,1,0,0,0,0,2h3.59L2.29,20.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z'
  }));
};

UilArrowRandom.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowRandom.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowResizeDiagonal = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,2.62a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H15a1,1,0,0,0,0,2h3.59L4,18.59V15a1,1,0,0,0-2,0v6a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54A1,1,0,0,0,3,22H9a1,1,0,0,0,0-2H5.41L20,5.41V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z'
  }));
};

UilArrowResizeDiagonal.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowResizeDiagonal.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.92,11.62a1,1,0,0,0-.21-.33l-5-5a1,1,0,0,0-1.42,1.42L14.59,11H7a1,1,0,0,0,0,2h7.59l-3.3,3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l5-5a1,1,0,0,0,.21-.33A1,1,0,0,0,17.92,11.62Z'
  }));
};

UilArrowRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowToBottom = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,20H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2Zm-7.71-2.29a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4-4a1,1,0,0,0-1.42-1.42L13,14.59V3a1,1,0,0,0-2,0V14.59l-2.29-2.3a1,1,0,1,0-1.42,1.42Z'
  }));
};

UilArrowToBottom.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowToBottom.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowToRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.71,11.29l-4-4a1,1,0,1,0-1.42,1.42L14.59,11H3a1,1,0,0,0,0,2H14.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76A1,1,0,0,0,17.71,11.29ZM21,4a1,1,0,0,0-1,1V19a1,1,0,0,0,2,0V5A1,1,0,0,0,21,4Z'
  }));
};

UilArrowToRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowToRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowUp = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.71,11.29l-5-5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-5,5a1,1,0,0,0,1.42,1.42L11,9.41V17a1,1,0,0,0,2,0V9.41l3.29,3.3a1,1,0,0,0,1.42,0A1,1,0,0,0,17.71,11.29Z'
  }));
};

UilArrowUp.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowUp.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowUpLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.41,8H17a1,1,0,0,0,0-2H7a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,6,7V17a1,1,0,0,0,2,0V9.41l8.29,8.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z'
  }));
};

UilArrowUpLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowUpLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowUpRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.92,6.62a1,1,0,0,0-.54-.54A1,1,0,0,0,17,6H7A1,1,0,0,0,7,8h7.59l-8.3,8.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L16,9.41V17a1,1,0,0,0,2,0V7A1,1,0,0,0,17.92,6.62Z'
  }));
};

UilArrowUpRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowUpRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,11.62a1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L18.59,11H5.41l2.3-2.29A1,1,0,1,0,6.29,7.29l-4,4a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H18.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62Z'
  }));
};

UilArrowsH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsHAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,11.62a1,1,0,0,0-.21-.33l-2.5-2.5a1,1,0,0,0-1.42,1.42l.8.79H14a1,1,0,0,0,0,2h4.59l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62ZM10,11H5.41l.8-.79A1,1,0,0,0,4.79,8.79l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H10a1,1,0,0,0,0-2Z'
  }));
};

UilArrowsHAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsHAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsLeftDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,16.29a1,1,0,0,0-1.42,0L18,18.59V9a3,3,0,0,0-3-3H5.41l2.3-2.29A1,1,0,0,0,6.29,2.29l-4,4a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,8H15a1,1,0,0,1,1,1v9.59l-2.29-2.3a1,1,0,0,0-1.42,1.42l4,4a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4-4A1,1,0,0,0,21.71,16.29Z'
  }));
};

UilArrowsLeftDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsLeftDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsMaximize = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14a1,1,0,0,0-1,1v3.59L5.41,4H9A1,1,0,0,0,9,2H3a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,2,3V9A1,1,0,0,0,4,9V5.41L18.59,20H15a1,1,0,0,0,0,2h6a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V15A1,1,0,0,0,21,14Z'
  }));
};

UilArrowsMaximize.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsMaximize.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsMerge = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.71,11.29l-2.5-2.5a1,1,0,1,0-1.42,1.42l.8.79H4V7A1,1,0,0,0,2,7V17a1,1,0,0,0,2,0V13H7.59l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76A1,1,0,0,0,10.71,11.29ZM21,6a1,1,0,0,0-1,1v4H16.41l.8-.79a1,1,0,0,0-1.42-1.42l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-.8-.79H20v4a1,1,0,0,0,2,0V7A1,1,0,0,0,21,6Z'
  }));
};

UilArrowsMerge.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsMerge.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsResize = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,11.62a1,1,0,0,0-.21-.33l-2.5-2.5a1,1,0,0,0-1.42,1.42l.8.79H13V8a1,1,0,0,0-2,0v3H5.41l.8-.79A1,1,0,0,0,4.79,8.79l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H11v3a1,1,0,0,0,2,0V13h5.59l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62Z'
  }));
};

UilArrowsResize.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsResize.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsResizeH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,6A1,1,0,0,0,9,7v4H5.41l.8-.79A1,1,0,0,0,4.79,8.79l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H9v4a1,1,0,0,0,2,0V7A1,1,0,0,0,10,6Zm11.92,5.62a1,1,0,0,0-.21-.33l-2.5-2.5a1,1,0,0,0-1.42,1.42l.8.79H15V7a1,1,0,0,0-2,0V17a1,1,0,0,0,2,0V13h3.59l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62Z'
  }));
};

UilArrowsResizeH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsResizeH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsResizeV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,11H13V5.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42l.79-.8V11H8a1,1,0,0,0,0,2h3v5.59l-.79-.8a1,1,0,0,0-1.42,1.42l2.5,2.5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,0,0-1.42-1.42l-.79.8V13h3a1,1,0,0,0,0-2Z'
  }));
};

UilArrowsResizeV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsResizeV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsRightDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.92,6.62a1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L17.59,6H9A3,3,0,0,0,6,9v8.59l-1.29-1.3a1,1,0,0,0-1.42,1.42l3,3a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3a1,1,0,0,0-1.42-1.42L8,17.59V9A1,1,0,0,1,9,8h8.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,.21-.33A1,1,0,0,0,20.92,6.62Z'
  }));
};

UilArrowsRightDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsRightDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsShrinkH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.71,11.29l-2.5-2.5a1,1,0,0,0-1.42,1.42l.8.79H9.41l.8-.79A1,1,0,0,0,8.79,8.79l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2.5,2.5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L9.41,13h5.18l-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2.5-2.5a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76A1,1,0,0,0,17.71,11.29ZM3,6A1,1,0,0,0,2,7V17a1,1,0,0,0,2,0V7A1,1,0,0,0,3,6ZM21,6a1,1,0,0,0-1,1V17a1,1,0,0,0,2,0V7A1,1,0,0,0,21,6Z'
  }));
};

UilArrowsShrinkH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsShrinkH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsShrinkV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.79,10.21a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42l.79-.8v5.18l-.79-.8a1,1,0,0,0-1.42,1.42l2.5,2.5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,0,0-1.42-1.42l-.79.8V9.41ZM7,4H17a1,1,0,0,0,0-2H7A1,1,0,0,0,7,4ZM17,20H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Z'
  }));
};

UilArrowsShrinkV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsShrinkV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsUpRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.92,16.62a1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L17.59,16H9a1,1,0,0,1-1-1V6.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-3-3a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3A1,1,0,0,0,4.71,7.71L6,6.41V15a3,3,0,0,0,3,3h8.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,.21-.33A1,1,0,0,0,20.92,16.62Z'
  }));
};

UilArrowsUpRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsUpRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.29,16.29,13,18.59V5.41l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-4-4a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-4,4A1,1,0,1,0,8.71,7.71L11,5.41V18.59l-2.29-2.3a1,1,0,1,0-1.42,1.42l4,4a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4-4a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilArrowsV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilArrowsVAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.21,6.21l.79-.8V10a1,1,0,0,0,2,0V5.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42Zm3.58,11.58-.79.8V14a1,1,0,0,0-2,0v4.59l-.79-.8a1,1,0,0,0-1.42,1.42l2.5,2.5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilArrowsVAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilArrowsVAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAssistiveListeningSystems = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,3a7,7,0,0,0-7,7,1,1,0,0,0,2,0,5,5,0,0,1,10,0,5.07,5.07,0,0,1-.71,2.57L11.73,20A2,2,0,0,1,10,21a2,2,0,0,1-2-2,1,1,0,0,0-2,0,4,4,0,0,0,4,4,4,4,0,0,0,3.5-2.07l3.56-7.43A6.93,6.93,0,0,0,18,10,7,7,0,0,0,11,3ZM4,15a1,1,0,1,0,1,1A1,1,0,0,0,4,15ZM17.59,1.2a1,1,0,1,0-1.2,1.6A9,9,0,0,1,20,10a1,1,0,0,0,2,0A11.06,11.06,0,0,0,17.59,1.2ZM11,9a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-6,0,3,3,0,0,0,.51,1.68,3.5,3.5,0,0,0,.47.54l.2.22a1,1,0,0,1,0,1.11,1,1,0,0,0,.25,1.39,1,1,0,0,0,.57.18,1,1,0,0,0,.82-.43,3,3,0,0,0,0-3.39,3.39,3.39,0,0,0-.35-.42l-.14-.14a1.37,1.37,0,0,1-.16-.18A1,1,0,0,1,10,10,1,1,0,0,1,11,9ZM7,15a1,1,0,1,0-1-1A1,1,0,0,0,7,15Z'
  }));
};

UilAssistiveListeningSystems.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAssistiveListeningSystems.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAsterisk = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.562,14.63379,14.00031,12,18.562,9.36621a1.00016,1.00016,0,0,0-1-1.73242L13,10.26776V5a1,1,0,0,0-2,0v5.26776l-4.562-2.634a1.00016,1.00016,0,0,0-1,1.73242L9.99969,12,5.438,14.63379a1.00016,1.00016,0,0,0,1,1.73242L11,13.73224V19a1,1,0,0,0,2,0V13.73224l4.562,2.634a1.00016,1.00016,0,0,0,1-1.73242Z'
  }));
};

UilAsterisk.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAsterisk.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2a10,10,0,1,0,5,18.66,1,1,0,1,0-1-1.73A8,8,0,1,1,20,12v.75a1.75,1.75,0,0,1-3.5,0V8.5a1,1,0,0,0-1-1,1,1,0,0,0-1,.79A4.45,4.45,0,0,0,12,7.5,4.5,4.5,0,1,0,15.3,15,3.74,3.74,0,0,0,22,12.75V12A10,10,0,0,0,12,2Zm0,12.5A2.5,2.5,0,1,1,14.5,12,2.5,2.5,0,0,1,12,14.5Z'
  }));
};

UilAt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAtom = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,11a1,1,0,1,0,1,1A1,1,0,0,0,12,11Zm7.62,1,.11-.14C21.08,10,21.4,8.29,20.66,7S18.26,5.14,16,5.37l-.18,0C14.91,3.3,13.56,2,12,2S9.09,3.3,8.19,5.4L8,5.37C5.74,5.14,4.08,5.71,3.34,7s-.42,3,.93,4.86l.11.14-.11.14C2.92,14,2.6,15.71,3.34,17,4,18.1,5.27,18.68,7,18.68c.31,0,.63,0,1-.05l.18,0C9.09,20.7,10.44,22,12,22s2.91-1.3,3.81-3.4l.18,0c.34,0,.66.05,1,.05,1.77,0,3.07-.58,3.7-1.68.74-1.29.42-3-.93-4.86ZM5.07,8c.25-.44,1-.68,2-.68l.49,0a14.78,14.78,0,0,0-.35,1.87,15,15,0,0,0-1.45,1.25C5,9.44,4.78,8.5,5.07,8Zm0,8c-.29-.5,0-1.44.67-2.47a15,15,0,0,0,1.45,1.25,14.94,14.94,0,0,0,.35,1.88C6.3,16.74,5.36,16.5,5.07,16ZM12,4c.56,0,1.23.66,1.8,1.83a17.6,17.6,0,0,0-1.8.63,17.6,17.6,0,0,0-1.8-.63C10.77,4.66,11.44,4,12,4Zm0,16c-.56,0-1.23-.66-1.8-1.83a17.6,17.6,0,0,0,1.8-.63,17.6,17.6,0,0,0,1.8.63C13.23,19.34,12.56,20,12,20Zm2.93-6.31c-.46.32-.93.62-1.43.91s-1,.55-1.5.78q-.75-.35-1.5-.78c-.5-.29-1-.59-1.43-.91C9,13.15,9,12.59,9,12s0-1.15.07-1.69c.46-.32.93-.62,1.43-.91s1-.55,1.5-.78q.75.35,1.5.78c.5.29,1,.59,1.43.91,0,.54.07,1.1.07,1.69S15,13.15,14.93,13.69Zm4,2.31c-.29.5-1.23.75-2.47.66a14.94,14.94,0,0,0,.35-1.88,15,15,0,0,0,1.45-1.25C19,14.56,19.22,15.5,18.93,16Zm-.67-5.53a15,15,0,0,0-1.45-1.25,14.78,14.78,0,0,0-.35-1.87l.49,0c1,0,1.73.24,2,.68S19,9.44,18.26,10.47Z'
  }));
};

UilAtom.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAtom.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAutoFlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.87,8.6A1,1,0,0,0,17,8H12.42l1.27-4.74a1,1,0,0,0-.17-.87,1,1,0,0,0-.8-.39h-7a1,1,0,0,0-1,.74l-2.68,10a1,1,0,0,0,1,1.26H6.89L5.08,20.74a1,1,0,0,0,1.71.93l10.9-12A1,1,0,0,0,17.87,8.6ZM8.08,17.28l1.08-4A1,1,0,0,0,9,12.39,1,1,0,0,0,8.19,12H4.35L6.49,4h4.93L10.15,8.74a1,1,0,0,0,1,1.26h3.57ZM19,13H18a3,3,0,0,0-3,3v5a1,1,0,0,0,2,0V19h3v2a1,1,0,0,0,2,0V16A3,3,0,0,0,19,13Zm1,4H17V16a1,1,0,0,1,1-1h1a1,1,0,0,1,1,1Z'
  }));
};

UilAutoFlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAutoFlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAward = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.87,17.25l-2.71-4.68A6.9,6.9,0,0,0,19,9.25a7,7,0,0,0-14,0,6.9,6.9,0,0,0,.84,3.32L3.13,17.25A1,1,0,0,0,4,18.75l2.87,0,1.46,2.46a1,1,0,0,0,.18.22,1,1,0,0,0,.69.28h.14a1,1,0,0,0,.73-.49L12,17.9l1.93,3.35a1,1,0,0,0,.73.48h.14a1,1,0,0,0,.7-.28.87.87,0,0,0,.17-.21l1.46-2.46,2.87,0a1,1,0,0,0,.87-.5A1,1,0,0,0,20.87,17.25ZM9.19,18.78,8.3,17.29a1,1,0,0,0-.85-.49l-1.73,0,1.43-2.48a7,7,0,0,0,3.57,1.84ZM12,14.25a5,5,0,1,1,5-5A5,5,0,0,1,12,14.25Zm4.55,2.55a1,1,0,0,0-.85.49l-.89,1.49-1.52-2.65a7.06,7.06,0,0,0,3.56-1.84l1.43,2.48Z'
  }));
};

UilAward.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAward.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilAwardAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,1A7,7,0,0,0,7,12.89V22a1,1,0,0,0,1.45.89L12,21.12l3.55,1.77A1,1,0,0,0,16,23a1,1,0,0,0,.53-.15A1,1,0,0,0,17,22V12.89A7,7,0,0,0,12,1Zm3,19.38-2.55-1.27a1,1,0,0,0-.9,0L9,20.38V14.32a7,7,0,0,0,2,.6V16a1,1,0,0,0,2,0V14.92a7,7,0,0,0,2-.6ZM12,13a5,5,0,1,1,5-5A5,5,0,0,1,12,13Z'
  }));
};

UilAwardAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilAwardAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBabyCarriage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,16a3,3,0,1,0,3,3A3,3,0,0,0,19,16Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,19,20ZM9,16a3,3,0,1,0,3,3A3,3,0,0,0,9,16Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,9,20ZM22,8.5A6.51,6.51,0,0,0,15.5,2H15a1,1,0,0,0-1,1V8H7.52L6.27,4.65A1,1,0,0,0,5.33,4H3A1,1,0,0,0,3,6H4.64L5.89,9.37l0,0,.51,1.37,0,.09A6.44,6.44,0,0,0,12.5,15h3A6.49,6.49,0,0,0,22,8.5Zm-3.32,3.18A4.47,4.47,0,0,1,15.5,13h-3a4.47,4.47,0,0,1-4.16-2.8.14.14,0,0,1,0-.06L8.26,10H19.74A4.32,4.32,0,0,1,18.68,11.68ZM16,8V4A4.49,4.49,0,0,1,20,8Z'
  }));
};

UilBabyCarriage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBabyCarriage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBackpack = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,10H11a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Zm5,0a4,4,0,0,0-3-3.86V5A3,3,0,0,0,9,5V6.14A4,4,0,0,0,6,10a4,4,0,0,0-4,4v3a3,3,0,0,0,3,3H6.18A3,3,0,0,0,9,22h6a3,3,0,0,0,2.82-2H19a3,3,0,0,0,3-3V14A4,4,0,0,0,18,10ZM6,18H5a1,1,0,0,1-1-1V14a2,2,0,0,1,2-2ZM11,5a1,1,0,0,1,2,0V6H11Zm5,14a1,1,0,0,1-1,1H9a1,1,0,0,1-1-1V18a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2Zm0-4.44A3.91,3.91,0,0,0,14,14H10a3.91,3.91,0,0,0-2,.56V10a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2ZM20,17a1,1,0,0,1-1,1H18V12a2,2,0,0,1,2,2Z'
  }));
};

UilBackpack.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBackpack.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBackspace = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,5H9.83a3,3,0,0,0-2.12.88L2.29,11.29a1,1,0,0,0,0,1.42l5.42,5.41A3,3,0,0,0,9.83,19H19a3,3,0,0,0,3-3V8A3,3,0,0,0,19,5Zm1,11a1,1,0,0,1-1,1H9.83a1.05,1.05,0,0,1-.71-.29L4.41,12,9.12,7.29A1.05,1.05,0,0,1,9.83,7H19a1,1,0,0,1,1,1ZM16.71,9.29a1,1,0,0,0-1.42,0L14,10.59l-1.29-1.3a1,1,0,0,0-1.42,1.42L12.59,12l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L14,13.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L15.41,12l1.3-1.29A1,1,0,0,0,16.71,9.29Z'
  }));
};

UilBackspace.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBackspace.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBackward = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.67,5.85a2.63,2.63,0,0,0-2.67,0L14,8.15h0a2.67,2.67,0,0,0-4-2.31L3.33,9.69a2.67,2.67,0,0,0,0,4.62L10,18.16a2.66,2.66,0,0,0,2.67,0A2.65,2.65,0,0,0,14,15.85h0l4,2.31a2.69,2.69,0,0,0,1.33.36,2.61,2.61,0,0,0,1.34-.37A2.63,2.63,0,0,0,22,15.85V8.15A2.63,2.63,0,0,0,20.67,5.85ZM12,15.85a.66.66,0,0,1-.33.58.69.69,0,0,1-.67,0L4.33,12.58a.67.67,0,0,1,0-1.16L11,7.57a.67.67,0,0,1,.67,0,.66.66,0,0,1,.33.58Zm8,0a.67.67,0,0,1-1,.57l-5-2.88V10.46l5-2.88a.67.67,0,0,1,1,.57Z'
  }));
};

UilBackward.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBackward.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBag = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6H16V5a2,2,0,0,0-2-2H10A2,2,0,0,0,8,5V6H5A3,3,0,0,0,2,9v9a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V9A3,3,0,0,0,19,6ZM10,5h4V6H10ZM20,18a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V12.39L8.68,14A1.19,1.19,0,0,0,9,14h6a1.19,1.19,0,0,0,.32-.05L20,12.39Zm0-7.72L14.84,12H9.16L4,10.28V9A1,1,0,0,1,5,8H19a1,1,0,0,1,1,1Z'
  }));
};

UilBag.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBag.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBagAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6.5H16v-1a3,3,0,0,0-3-3H11a3,3,0,0,0-3,3v1H5a3,3,0,0,0-3,3v9a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-9A3,3,0,0,0,19,6.5Zm-9-1a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1v1H10Zm10,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V13a21.71,21.71,0,0,0,8,1.53A21.75,21.75,0,0,0,20,13Zm0-7.69a19.89,19.89,0,0,1-16,0V9.5a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1Z'
  }));
};

UilBagAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBagAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBagSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6H16V5a2,2,0,0,0-2-2H10a1.86,1.86,0,0,0-.61.1,1,1,0,0,0-.64,1.27A1,1,0,0,0,10,5h4V6H12.66a1,1,0,0,0,0,2H19a1,1,0,0,1,1,1v1.28l-2.57.86a1,1,0,0,0-.63,1.27,1,1,0,0,0,.95.68,1.19,1.19,0,0,0,.32-.05L20,12.39v2.95a1,1,0,1,0,2,0V9A3,3,0,0,0,19,6ZM3.71,2.29A1,1,0,0,0,2.29,3.71L4.62,6A3,3,0,0,0,2,9v9a3,3,0,0,0,3,3H19a3.07,3.07,0,0,0,.53-.06l.76.77a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM4,9A1,1,0,0,1,5,8H6.59l4,4H9.16L4,10.28ZM5,19a1,1,0,0,1-1-1V12.39L8.68,14A1.19,1.19,0,0,0,9,14h3.59l5,5Z'
  }));
};

UilBagSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBagSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBalanceScale = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.96423,13.82263a.94762.94762,0,0,0-.02819-.17419L20.63135,7.51135A2.99558,2.99558,0,0,0,22,5a1,1,0,0,0-2,0,1.00037,1.00037,0,0,1-1.88184.47266A2.8934,2.8934,0,0,0,15.54,4H13V3a1,1,0,0,0-2,0V4H8.46A2.8934,2.8934,0,0,0,5.88184,5.47266,1.00037,1.00037,0,0,1,4,5,1,1,0,0,0,2,5,2.99558,2.99558,0,0,0,3.36865,7.51135L1.064,13.64844a.94762.94762,0,0,0-.02819.17419A.94855.94855,0,0,0,1,14c0,.00928.00269.01782.00275.0271.0003.01318.003.02533.0039.03845a3.99379,3.99379,0,0,0,7.9867,0c.00085-.01312.0036-.02527.0039-.03845C8.99731,14.01782,9,14.00928,9,14a.94855.94855,0,0,0-.03577-.17737.94762.94762,0,0,0-.02819-.17419L6.62866,7.50421A2.98961,2.98961,0,0,0,7.64258,6.41992.917.917,0,0,1,8.46,6H11V20H8a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2H13V6h2.54a.917.917,0,0,1,.81738.41992,2.98961,2.98961,0,0,0,1.01392,1.08429L15.064,13.64844a.94762.94762,0,0,0-.02819.17419A.94855.94855,0,0,0,15,14c0,.00928.00269.01782.00275.0271.0003.01318.003.02533.0039.03845a3.99379,3.99379,0,0,0,7.9867,0c.00085-.01312.0036-.02527.0039-.03845C22.99731,14.01782,23,14.00928,23,14A.94855.94855,0,0,0,22.96423,13.82263ZM5,8.85553,6.5564,13H3.4436ZM6.72266,15A2.02306,2.02306,0,0,1,5,16a2.00023,2.00023,0,0,1-1.73145-1ZM19,8.85553,20.5564,13H17.4436ZM19,16a2.00023,2.00023,0,0,1-1.73145-1h3.45411A2.02306,2.02306,0,0,1,19,16Z'
  }));
};

UilBalanceScale.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBalanceScale.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBan = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,0,1-8-8A7.92,7.92,0,0,1,5.69,7.1L16.9,18.31A7.92,7.92,0,0,1,12,20Zm6.31-3.1L7.1,5.69A7.92,7.92,0,0,1,12,4a8,8,0,0,1,8,8A7.92,7.92,0,0,1,18.31,16.9Z'
  }));
};

UilBan.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBan.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBandAid = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.82,11.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.42A1,1,0,0,0,8.82,11.29Zm2.47,2.48a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41A1,1,0,0,0,11.29,13.77Zm9-10A6,6,0,0,0,12,3.55a6,6,0,0,0-8.24.2h0A6,6,0,0,0,3.57,12,6,6,0,0,0,8,22a5.92,5.92,0,0,0,4-1.55,6,6,0,0,0,8.25-.2A6,6,0,0,0,20.43,12,6,6,0,0,0,20.25,3.75ZM18.83,5.17A4,4,0,0,1,19,10.56L13.44,5A4.07,4.07,0,0,1,18.83,5.17ZM5.17,18.83A4,4,0,0,1,5,13.44l5.6,5.6A4.08,4.08,0,0,1,5.17,18.83Zm13.66,0a4.08,4.08,0,0,1-5.64,0l-8-8a4,4,0,0,1,0-5.64h0a4,4,0,0,1,5.64,0l8,8A4,4,0,0,1,18.83,18.83Zm-5.06-7.54a1,1,0,0,0,0,1.42,1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.42A1,1,0,0,0,13.77,11.29ZM11.29,8.82a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41A1,1,0,0,0,11.29,8.82Z'
  }));
};

UilBandAid.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBandAid.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBars = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,8H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,8Zm18,8H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-5H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilBars.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBars.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBaseballBall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.92188,6.44043a1.00009,1.00009,0,0,0-1.70313,1.04883q.26514.4292.56543.84375a.99994.99994,0,0,0,1.61914-1.17383Q14.147,6.80616,13.92188,6.44043Zm-2.7295,9.22168A1,1,0,1,0,9.583,16.84961c.16992.22949.32715.4668.47558.709a1.0004,1.0004,0,1,0,1.70508-1.04687C11.58594,16.22266,11.39551,15.93848,11.19238,15.66211Zm-3.707-3.42871a.99989.99989,0,0,0-1.04492,1.70508q.36329.22264.71289.47851A1.00029,1.00029,0,1,0,8.33105,12.7998Q7.91651,12.498,7.48535,12.2334Zm10.06055-2.167q-.36475-.22413-.71582-.4795a1.0003,1.0003,0,0,0-1.17774,1.61719q.41456.30176.84668.56738a1.0004,1.0004,0,1,0,1.04688-1.70507ZM18.99219,5.001a9.90088,9.90088,0,1,0,0,14.001A9.91268,9.91268,0,0,0,18.99219,5.001ZM17.71875,17.72852a8.02918,8.02918,0,0,1-4.51563,2.27374.97071.97071,0,0,0-1.74633.07324,8.0616,8.0616,0,0,1-7.535-7.53155.97507.97507,0,0,0,.07282-1.74714,8.0395,8.0395,0,0,1,6.78479-6.79174.99669.99669,0,0,0,.85632.49786,1.02809,1.02809,0,0,0,.22949-.02637.98194.98194,0,0,0,.65912-.54583,8.05437,8.05437,0,0,1,7.53772,7.53869.97244.97244,0,0,0-.07385,1.74085A8.046,8.046,0,0,1,17.71875,17.72852Z'
  }));
};

UilBaseballBall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBaseballBall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBasketball = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,3.6,6.59l0,0A10,10,0,0,0,18.26,19.79l0,0A10,10,0,0,0,12,2Zm2,2.26A8,8,0,0,1,19.74,10,9.78,9.78,0,0,0,15,11.38a15.7,15.7,0,0,0-2.4-2.21A10.06,10.06,0,0,0,14,4.26ZM12,4a7.9,7.9,0,0,1-1.14,4.07c-.15-.08-.29-.17-.44-.24A15.52,15.52,0,0,0,6.33,6.36,8,8,0,0,1,12,4ZM5,8.16A13.75,13.75,0,0,1,9.49,9.6l.13.08A7.93,7.93,0,0,1,4,12,8,8,0,0,1,5,8.16Zm5,11.58A8,8,0,0,1,4.26,14a9.9,9.9,0,0,0,7.08-3.21,14,14,0,0,1,2,1.8A10,10,0,0,0,10,19.74ZM12,20a8,8,0,0,1,2.56-5.85c.06.08.12.15.17.23a14,14,0,0,1,1.84,4.18A7.93,7.93,0,0,1,12,20Zm6.21-3a16,16,0,0,0-1.8-3.75L16.2,13A7.93,7.93,0,0,1,20,12,8,8,0,0,1,18.21,17Z'
  }));
};

UilBasketball.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBasketball.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBasketballHoop = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,10H6a1,1,0,0,0,0,2H7v9a1,1,0,0,0,2,0V20h2v1a1,1,0,0,0,2,0V20h2v1a1,1,0,0,0,2,0V12h1a1,1,0,0,0,0-2Zm-7,8H9V16h2Zm0-4H9V12h2Zm4,4H13V16h2Zm0-4H13V12h2ZM20,2H4A3,3,0,0,0,1,5v8a3,3,0,0,0,3,3,1,1,0,0,0,0-2,1,1,0,0,1-1-1V5A1,1,0,0,1,4,4H20a1,1,0,0,1,1,1v8a1,1,0,0,1-1,1,1,1,0,0,0,0,2,3,3,0,0,0,3-3V5A3,3,0,0,0,20,2ZM14,8a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2Z'
  }));
};

UilBasketballHoop.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBasketballHoop.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBath = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,12H5V6.41016A1.97474,1.97474,0,0,1,6.04,4.65137a1.99474,1.99474,0,0,1,1.14764-.2312,3.49114,3.49114,0,0,0,.83771,3.55444L9.08594,9.03516a.99965.99965,0,0,0,1.41406,0L14.03516,5.5a.99964.99964,0,0,0,0-1.41406L12.97461,3.02539a3.494,3.494,0,0,0-4.52972-.34253A3.99247,3.99247,0,0,0,3,6.41016V12H2a1,1,0,0,0,0,2H3v3a2.995,2.995,0,0,0,2,2.81567V21a1,1,0,0,0,2,0V20H17v1a1,1,0,0,0,2,0V19.81573A2.99507,2.99507,0,0,0,21,17V14h1a1,1,0,0,0,0-2ZM9.43945,4.43945a1.50184,1.50184,0,0,1,2.1211,0l.35351.35352L9.793,6.91406l-.35352-.35351A1.50123,1.50123,0,0,1,9.43945,4.43945ZM19,17a1.00067,1.00067,0,0,1-1,1H6a1.00067,1.00067,0,0,1-1-1V14H19Z'
  }));
};

UilBath.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBath.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBatteryBolt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.69,15H4V9H6.31a1,1,0,0,0,0-2H4A2,2,0,0,0,2,9v6a2,2,0,0,0,2,2H6.69a1,1,0,1,0,0-2Zm7.2-2.56a1.27,1.27,0,0,0,.06-.18,1.42,1.42,0,0,0,0-.2s0,0,0-.06,0-.08,0-.12a.65.65,0,0,0-.05-.2.89.89,0,0,0-.08-.17.86.86,0,0,0-.1-.16l-.16-.13-.09-.09-.06,0-.18-.06-.2,0H9.73l1.45-2.5a1,1,0,1,0-1.74-1l-2.31,4s0,0,0,.06a1.27,1.27,0,0,0-.06.18,1.42,1.42,0,0,0,0,.2S7,12,7,12s0,.08,0,.12a.65.65,0,0,0,.05.2.89.89,0,0,0,.08.17.86.86,0,0,0,.1.16l.16.13a.76.76,0,0,0,.09.09l.07,0,.09,0A1,1,0,0,0,8,13h3.27L9.82,15.5a1,1,0,0,0,1.74,1l2.31-4S13.88,12.46,13.89,12.44ZM21,10a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V11A1,1,0,0,0,21,10ZM17,7H14.31a1,1,0,0,0,0,2H17v6H14.69a1,1,0,1,0,0,2H17a2,2,0,0,0,2-2V9A2,2,0,0,0,17,7Z'
  }));
};

UilBatteryBolt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBatteryBolt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBatteryEmpty = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,7H4A2,2,0,0,0,2,9v6a2,2,0,0,0,2,2H17a2,2,0,0,0,2-2V9A2,2,0,0,0,17,7Zm0,8H4V9H17Zm4-5a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V11A1,1,0,0,0,21,10Z'
  }));
};

UilBatteryEmpty.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBatteryEmpty.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBed = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,12.5a3,3,0,1,0-3-3A3,3,0,0,0,7,12.5Zm0-4a1,1,0,1,1-1,1A1,1,0,0,1,7,8.5Zm13-2H12a1,1,0,0,0-1,1v6H3v-8a1,1,0,0,0-2,0v13a1,1,0,0,0,2,0v-3H21v3a1,1,0,0,0,2,0v-9A3,3,0,0,0,20,6.5Zm1,7H13v-5h7a1,1,0,0,1,1,1Z'
  }));
};

UilBed.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBed.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBedDouble = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,3.5H4a3,3,0,0,0-3,3v13a1,1,0,0,0,1,1H6a1,1,0,0,0,.83-.45L8.54,17.5h6.92l1.71,2.55a1,1,0,0,0,.83.45h4a1,1,0,0,0,1-1V6.5A3,3,0,0,0,20,3.5Zm1,15H18.54L16.83,16A1,1,0,0,0,16,15.5H8a1,1,0,0,0-.83.45L5.46,18.5H3v-5H21Zm-14-7v-1a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1v1Zm6,0v-1a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1v1Zm8,0H19v-1a3,3,0,0,0-3-3H14a3,3,0,0,0-2,.78,3,3,0,0,0-2-.78H8a3,3,0,0,0-3,3v1H3v-5a1,1,0,0,1,1-1H20a1,1,0,0,1,1,1Z'
  }));
};

UilBedDouble.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBedDouble.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBehance = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.07,6.35H15V7.76h5.09ZM19,16.05a2.23,2.23,0,0,1-1.3.37A2.23,2.23,0,0,1,16,15.88a2.49,2.49,0,0,1-.62-1.76H22a6.47,6.47,0,0,0-.17-2,5.08,5.08,0,0,0-.8-1.73,4.17,4.17,0,0,0-1.42-1.21,4.37,4.37,0,0,0-2-.45,4.88,4.88,0,0,0-1.9.37,4.51,4.51,0,0,0-1.47,1,4.4,4.4,0,0,0-.95,1.52,5.4,5.4,0,0,0-.33,1.91,5.52,5.52,0,0,0,.32,1.94A4.46,4.46,0,0,0,14.16,17a4,4,0,0,0,1.46,1,5.2,5.2,0,0,0,1.94.34,4.77,4.77,0,0,0,2.64-.7,4.21,4.21,0,0,0,1.63-2.35H19.62A1.54,1.54,0,0,1,19,16.05Zm-3.43-4.12a1.87,1.87,0,0,1,1-1.14,2.28,2.28,0,0,1,1-.2,1.73,1.73,0,0,1,1.36.49,2.91,2.91,0,0,1,.63,1.45H15.41A3,3,0,0,1,15.52,11.93Zm-5.29-.48a3.06,3.06,0,0,0,1.28-1,2.72,2.72,0,0,0,.43-1.58,3.28,3.28,0,0,0-.29-1.48,2.4,2.4,0,0,0-.82-1,3.24,3.24,0,0,0-1.27-.52,7.54,7.54,0,0,0-1.64-.16H2V18.29H8.1a6.55,6.55,0,0,0,1.65-.21,4.55,4.55,0,0,0,1.43-.65,3.13,3.13,0,0,0,1-1.14,3.41,3.41,0,0,0,.37-1.65,3.47,3.47,0,0,0-.57-2A3,3,0,0,0,10.23,11.45ZM4.77,7.86H7.36a4.17,4.17,0,0,1,.71.06,1.64,1.64,0,0,1,.61.22,1.05,1.05,0,0,1,.42.44,1.42,1.42,0,0,1,.16.72,1.36,1.36,0,0,1-.47,1.15,2,2,0,0,1-1.22.35H4.77ZM9.61,15.3a1.28,1.28,0,0,1-.45.5,2,2,0,0,1-.65.26,3.33,3.33,0,0,1-.78.08h-3V12.69h3a2.4,2.4,0,0,1,1.45.41,1.65,1.65,0,0,1,.54,1.39A1.77,1.77,0,0,1,9.61,15.3Z'
  }));
};

UilBehance.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBehance.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBehanceAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.1084,15.03169a.99748.99748,0,0,0-1.21582.72265,2.99839,2.99839,0,0,1-5.90088-.7539v-1h7a.99974.99974,0,0,0,1-1,5,5,0,1,0-10,0v2a4.99837,4.99837,0,0,0,9.83935,1.24609A.999.999,0,0,0,22.1084,15.03169Zm-4.1167-5.03125a3.01119,3.01119,0,0,1,2.11816.87207,3.04438,3.04438,0,0,1,.69867,1.12793H15.176A2.99509,2.99509,0,0,1,17.9917,10.00044Zm-2-3h4a1,1,0,0,0,0-2h-4a1,1,0,0,0,0,2Zm-6.082,4.71716a3.98653,3.98653,0,0,0-2.918-6.71716h-5a.99973.99973,0,0,0-1,1v13a.99974.99974,0,0,0,1,1h5.5a4.492,4.492,0,0,0,2.418-8.28284ZM2.9917,7.00044h4a2,2,0,1,1,0,4h-4Zm4.5,11h-4.5v-5h4.5a2.5,2.5,0,0,1,0,5Z'
  }));
};

UilBehanceAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBehanceAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBell = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,13.18V10a6,6,0,0,0-5-5.91V3a1,1,0,0,0-2,0V4.09A6,6,0,0,0,6,10v3.18A3,3,0,0,0,4,16v2a1,1,0,0,0,1,1H8.14a4,4,0,0,0,7.72,0H19a1,1,0,0,0,1-1V16A3,3,0,0,0,18,13.18ZM8,10a4,4,0,0,1,8,0v3H8Zm4,10a2,2,0,0,1-1.72-1h3.44A2,2,0,0,1,12,20Zm6-3H6V16a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z'
  }));
};

UilBell.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBell.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBellSchool = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,8a2,2,0,1,0-2.27,2,4.49,4.49,0,0,1-3,5.85,3,3,0,0,0-1.3-1.43,7,7,0,1,0-10.9,0A3,3,0,0,0,2,17v1a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3v-.19a6.47,6.47,0,0,0,4.58-8.59A2,2,0,0,0,21,8ZM14,18a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V17a1,1,0,0,1,1-1h.41a6.94,6.94,0,0,0,7.18,0H13a1,1,0,0,1,1,1ZM9,15a5,5,0,1,1,5-5A5,5,0,0,1,9,15ZM9,9a1,1,0,1,0,1,1A1,1,0,0,0,9,9Z'
  }));
};

UilBellSchool.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBellSchool.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBellSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.07,6.12A3.48,3.48,0,0,1,12,6a4,4,0,0,1,4,4v1.34a1,1,0,0,0,2,0V10a6,6,0,0,0-5-5.91V3a1,1,0,0,0-2,0V4.1l-.45.08a1,1,0,0,0,.52,1.94ZM21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71L6.41,7.82A6,6,0,0,0,6,10v3.18A3,3,0,0,0,4,16v2a1,1,0,0,0,1,1H8.14a4,4,0,0,0,7.72,0h1.73l2.7,2.71a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM8,10a3.31,3.31,0,0,1,0-.55L11.59,13H8Zm4,10a2,2,0,0,1-1.72-1h3.44A2,2,0,0,1,12,20ZM6,17V16a1,1,0,0,1,1-1h6.59l2,2Z'
  }));
};

UilBellSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBellSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBill = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.5,10.5H12a1,1,0,0,0,0-2H11V8A1,1,0,0,0,9,8v.55a2.5,2.5,0,0,0,.5,4.95h1a.5.5,0,0,1,0,1H8a1,1,0,0,0,0,2H9V17a1,1,0,0,0,2,0v-.55a2.5,2.5,0,0,0-.5-4.95h-1a.5.5,0,0,1,0-1ZM21,12H18V3a1,1,0,0,0-.5-.87,1,1,0,0,0-1,0l-3,1.72-3-1.72a1,1,0,0,0-1,0l-3,1.72-3-1.72a1,1,0,0,0-1,0A1,1,0,0,0,2,3V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V13A1,1,0,0,0,21,12ZM5,20a1,1,0,0,1-1-1V4.73L6,5.87a1.08,1.08,0,0,0,1,0l3-1.72,3,1.72a1.08,1.08,0,0,0,1,0l2-1.14V19a3,3,0,0,0,.18,1Zm15-1a1,1,0,0,1-2,0V14h2Z'
  }));
};

UilBill.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBill.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBing = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.1,8.6l1.7,4.3l2.8,1.3L9,17.5V3.4L5,2v17.8L9,22l10-5.8v-4.5L10.1,8.6z'
  }));
};

UilBing.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBing.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBitcoin = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.136,12.11664l-.59577,2.41528c.73542.18469,3.00373.92127,3.33893-.44122C14.22961,12.66974,11.8714,12.30225,11.136,12.11664Zm.81262-3.29621-.5401,2.19056c.61243.15442,2.5003.78405,2.80621-.45526C14.53339,9.26294,12.5611,8.97479,11.94867,8.82043ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm4.358,8.57538a1.74286,1.74286,0,0,1-1.38525,1.611,1.93285,1.93285,0,0,1,.99682,2.66089c-.58551,1.69214-1.97662,1.835-3.82653,1.48089l-.449,1.81971-1.08484-.27344.44312-1.79529c-.28119-.07062-.56855-.14563-.86457-.22687L9.7431,17.65594l-1.08362-.27343.449-1.82312c-.25342-.06562-.5108-.13532-.77344-.20185l-1.41174-.35595.53857-1.25592s.79932.215.78852.19909a.39446.39446,0,0,0,.49719-.26062L9.965,8.74634a.583.583,0,0,0-.5055-.63812c.017-.01154-.788-.19812-.788-.19812l.28863-1.17188,1.4961.37781L10.455,7.1217c.22491.05652.45666.11029.69275.16468l.44464-1.80188,1.08423.27343L12.241,7.52448c.29107.06719.584.135.8692.2069l.43255-1.755,1.0849.27344-.44433,1.80249C15.553,8.52948,16.55475,9.24481,16.358,10.57538Z'
  }));
};

UilBitcoin.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBitcoin.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBitcoinAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16.30426,11.24115A3.99779,3.99779,0,0,0,12.9917,5.002v-1a1,1,0,1,0-2,0v1h-2v-1a1,1,0,1,0-2,0v1h-1a1,1,0,0,0,0,2h1v10h-1a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h2v1a1,1,0,0,0,2,0v-1h2a3.98966,3.98966,0,0,0,1.31256-7.7608ZM8.9917,7.002h4a2,2,0,0,1,0,4h-4Zm6,10h-6v-4h6a2,2,0,1,1,0,4Z'
  }));
};

UilBitcoinAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBitcoinAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBitcoinCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,20a9,9,0,1,1,9-9A9,9,0,0,1,12,21ZM14,7V6a1,1,0,0,0-2,0V7H11V6A1,1,0,0,0,9,6V7H8A1,1,0,0,0,8,9H9v6H8a1,1,0,0,0,0,2H9v1a1,1,0,0,0,2,0V17h1v1a1,1,0,0,0,2,0V17a3,3,0,0,0,3-3,3,3,0,0,0-.77-2A3,3,0,0,0,17,10,3,3,0,0,0,14,7Zm0,8H11V13h3a1,1,0,0,1,0,2Zm0-4H11V9h3a1,1,0,0,1,0,2Z'
  }));
};

UilBitcoinCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBitcoinCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBitcoinSign = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,9a4,4,0,0,0-4-4V3a1,1,0,0,0-2,0V5H11V3A1,1,0,0,0,9,3V5H6A1,1,0,0,0,6,7H7V17H6a1,1,0,0,0,0,2H9v2a1,1,0,0,0,2,0V19h2v2a1,1,0,0,0,2,0V19a4,4,0,0,0,2.62-7A4,4,0,0,0,19,9Zm-4,8H9V13h6a2,2,0,0,1,0,4Zm0-6H9V7h6a2,2,0,0,1,0,4Z'
  }));
};

UilBitcoinSign.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBitcoinSign.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBlackBerry = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2ZM7.19,13.35H5.27l.52-2.41H7.63c1.2,0,1.48.58,1.48,1.05C9.11,12.64,8.68,13.35,7.19,13.35Zm.66-3.64H5.94L6.46,7.3H8.3c1.19,0,1.47.59,1.47,1C9.77,9,9.35,9.71,7.85,9.71Zm3.75,7.43H9.68l.53-2.42h1.84c1.19,0,1.47.59,1.47,1.06C13.52,16.43,13.1,17.14,11.6,17.14Zm.71-3.79H10.4l.52-2.41h1.84c1.19,0,1.47.58,1.47,1.05C14.23,12.64,13.81,13.35,12.31,13.35ZM13,9.71H11.06l.52-2.41h1.84c1.2,0,1.48.59,1.48,1C14.9,9,14.47,9.71,13,9.71Zm3.74,5.61H14.81l.52-2.42h1.84c1.19,0,1.48.59,1.48,1.06C18.65,14.61,18.22,15.32,16.72,15.32Zm.72-3.44H15.52L16,9.46h1.84c1.2,0,1.48.59,1.48,1C19.36,11.17,18.93,11.88,17.44,11.88Z'
  }));
};

UilBlackBerry.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBlackBerry.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBlogger = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.71008,10.46008h2.23883a.77084.77084,0,1,0,0-1.54168H9.71008a.77084.77084,0,1,0,0,1.54168Zm9.71826-8.45837H4.555A2.57277,2.57277,0,0,0,1.9917,4.56506V19.43829A2.57278,2.57278,0,0,0,4.555,22.00171H19.42822a2.57268,2.57268,0,0,0,2.56348-2.56329V4.56506A2.57267,2.57267,0,0,0,19.42834,2.00171ZM18.35577,11.6795l-.01965,2.67542a4.0515,4.0515,0,0,1-4.03857,4.02179h-4.639a4.04922,4.04922,0,0,1-4.04181-4.0249V9.65747A4.05258,4.05258,0,0,1,9.65851,5.62671h2.82373a4.45954,4.45954,0,0,1,3.1203,2.19971,3.15646,3.15646,0,0,1,.36182,1.36767c.06738.50556.10284.88123.33007,1.08942.31934.28949,1.50727.09448,1.74219.27844l.17883.13983.10889.22168.036.17755Zm-4.097,1.8639H9.71008a.75035.75035,0,1,0,0,1.5h4.54871a.75024.75024,0,1,0,0-1.5Z'
  }));
};

UilBlogger.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBlogger.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBloggerAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.99121,13.00044h-4a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm-4-2h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm6-1.001v-.999a4.004,4.004,0,0,0-4-4h-2a5.00589,5.00589,0,0,0-5,5v4a5.00589,5.00589,0,0,0,5,5h4a5.00589,5.00589,0,0,0,5-5v-1A3.00474,3.00474,0,0,0,15.99121,9.99946Zm0,.001v.001l-1-.001Zm1,4a3.00328,3.00328,0,0,1-3,3h-4a3.00328,3.00328,0,0,1-3-3v-4a3.00328,3.00328,0,0,1,3-3h2a2.0026,2.0026,0,0,1,2,2v1a2.0026,2.0026,0,0,0,2,2,1.00067,1.00067,0,0,1,1,1Zm3-13h-16a3.00328,3.00328,0,0,0-3,3v16a3.00328,3.00328,0,0,0,3,3h16a3.00328,3.00328,0,0,0,3-3v-16A3.00328,3.00328,0,0,0,19.99121,1.00044Zm1,19a1.00067,1.00067,0,0,1-1,1h-16a1.00067,1.00067,0,0,1-1-1v-16a1.00067,1.00067,0,0,1,1-1h16a1.00067,1.00067,0,0,1,1,1Z'
  }));
};

UilBloggerAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBloggerAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBluetoothB = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.41,12l3.8-3.79a1,1,0,0,0,0-1.42l-4.5-4.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.54.54A1,1,0,0,0,11,3V9.59L8.21,6.79A1,1,0,1,0,6.79,8.21L10.59,12l-3.8,3.79a1,1,0,1,0,1.42,1.42L11,14.41V21a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4.5-4.5a1,1,0,0,0,0-1.42ZM13,5.41,15.09,7.5,13,9.59Zm0,13.18V14.41l2.09,2.09Z'
  }));
};

UilBluetoothB.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBluetoothB.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBold = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16.5,9.5A3.5,3.5,0,0,0,13,6H8.5a1,1,0,0,0-1,1V17a1,1,0,0,0,1,1H13a3.49,3.49,0,0,0,2.44-6A3.5,3.5,0,0,0,16.5,9.5ZM13,16H9.5V13H13a1.5,1.5,0,0,1,0,3Zm0-5H9.5V8H13a1.5,1.5,0,0,1,0,3Z'
  }));
};

UilBold.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBold.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBolt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.87,8.6A1,1,0,0,0,19,8H14.42l1.27-4.74a1,1,0,0,0-.17-.87A1,1,0,0,0,14.73,2h-7a1,1,0,0,0-1,.74l-2.68,10a1,1,0,0,0,.17.87,1,1,0,0,0,.8.39H8.89L7.08,20.74a1,1,0,0,0,1.71.93l10.9-12A1,1,0,0,0,19.87,8.6Zm-9.79,8.68,1.07-4a1,1,0,0,0-.17-.87,1,1,0,0,0-.79-.39H6.35L8.49,4h4.93L12.15,8.74a1,1,0,0,0,1,1.26h3.57Z'
  }));
};

UilBolt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBolt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBoltAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.89,9.55A1,1,0,0,0,19,9H14V3a1,1,0,0,0-.69-1,1,1,0,0,0-1.12.36l-8,11a1,1,0,0,0-.08,1A1,1,0,0,0,5,15h5v6a1,1,0,0,0,.69.95A1.12,1.12,0,0,0,11,22a1,1,0,0,0,.81-.41l8-11A1,1,0,0,0,19.89,9.55ZM12,17.92V14a1,1,0,0,0-1-1H7l5-6.92V10a1,1,0,0,0,1,1h4Z'
  }));
};

UilBoltAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBoltAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBoltSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.67,4.23A1,1,0,0,0,9.6,4h5.1L13.43,8.74a1,1,0,0,0,.17.87,1,1,0,0,0,.79.39H18l-1.13,1.24a1,1,0,0,0,.07,1.41,1,1,0,0,0,.67.26,1,1,0,0,0,.74-.33L21,9.67A1,1,0,0,0,20.23,8H15.69L17,3.26a1,1,0,0,0-.18-.87A1,1,0,0,0,16,2H9a1,1,0,0,0-1,.74L8,3A1,1,0,0,0,8.67,4.23Zm13,16.06-18-18A1,1,0,0,0,2.29,3.71L6.61,8,5.35,12.74a1,1,0,0,0,.18.87,1,1,0,0,0,.79.39h3.84L8.35,20.74a1,1,0,0,0,.49,1.14,1,1,0,0,0,.48.12,1,1,0,0,0,.74-.33l4.85-5.34,5.38,5.38a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM7.62,12l.63-2.34L10.59,12Zm3.73,5.28,1-3.56,1.2,1.19Z'
  }));
};

UilBoltSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBoltSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBook = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,6H9A1,1,0,0,0,8,7v4a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V7A1,1,0,0,0,15,6Zm-1,4H10V8h4Zm3-8H5A1,1,0,0,0,4,3V21a1,1,0,0,0,1,1H17a3,3,0,0,0,3-3V5A3,3,0,0,0,17,2Zm1,17a1,1,0,0,1-1,1H6V4H17a1,1,0,0,1,1,1Z'
  }));
};

UilBook.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBook.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBookAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,2H8A4,4,0,0,0,4,6V18a4,4,0,0,0,4,4H18a2,2,0,0,0,2-2V4A2,2,0,0,0,18,2ZM6,6A2,2,0,0,1,8,4H18V14H8a3.91,3.91,0,0,0-2,.56ZM8,20a2,2,0,0,1,0-4H18v4ZM10,8h4a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2Z'
  }));
};

UilBookAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBookAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBookMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,9H11V7A1,1,0,0,0,9,7V9H7a1,1,0,0,0,0,2H9v2a1,1,0,0,0,2,0V11h2a1,1,0,0,0,0-2Zm5,6V5a3,3,0,0,0-3-3H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H15A3,3,0,0,0,18,15ZM4,15V5A1,1,0,0,1,5,4H15a1,1,0,0,1,1,1V15a1,1,0,0,1-1,1H5A1,1,0,0,1,4,15ZM21,6a1,1,0,0,0-1,1V17a3,3,0,0,1-3,3H7a1,1,0,0,0,0,2H17a5,5,0,0,0,5-5V7A1,1,0,0,0,21,6Z'
  }));
};

UilBookMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBookMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBookOpen = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.17,2.06A13.1,13.1,0,0,0,19,1.87a12.94,12.94,0,0,0-7,2.05,12.94,12.94,0,0,0-7-2,13.1,13.1,0,0,0-2.17.19,1,1,0,0,0-.83,1v12a1,1,0,0,0,1.17,1,10.9,10.9,0,0,1,8.25,1.91l.12.07.11,0a.91.91,0,0,0,.7,0l.11,0,.12-.07A10.9,10.9,0,0,1,20.83,16a1,1,0,0,0,1.17-1v-12A1,1,0,0,0,21.17,2.06ZM11,15.35a12.87,12.87,0,0,0-6-1.48c-.33,0-.66,0-1,0v-10a8.69,8.69,0,0,1,1,0,10.86,10.86,0,0,1,6,1.8Zm9-1.44c-.34,0-.67,0-1,0a12.87,12.87,0,0,0-6,1.48V5.67a10.86,10.86,0,0,1,6-1.8,8.69,8.69,0,0,1,1,0Zm1.17,4.15A13.1,13.1,0,0,0,19,17.87a12.94,12.94,0,0,0-7,2.05,12.94,12.94,0,0,0-7-2.05,13.1,13.1,0,0,0-2.17.19A1,1,0,0,0,2,19.21,1,1,0,0,0,3.17,20a10.9,10.9,0,0,1,8.25,1.91,1,1,0,0,0,1.16,0A10.9,10.9,0,0,1,20.83,20,1,1,0,0,0,22,19.21,1,1,0,0,0,21.17,18.06Z'
  }));
};

UilBookOpen.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBookOpen.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBookReader = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.18,10.19A11.9,11.9,0,0,0,18,10c-.42,0-.83,0-1.24.08a5.91,5.91,0,0,0-1.91-1.65,3.81,3.81,0,0,0,1-2.57,3.86,3.86,0,0,0-7.72,0,3.81,3.81,0,0,0,1,2.57,6.11,6.11,0,0,0-1.91,1.64C6.83,10,6.42,10,6,10a11.9,11.9,0,0,0-2.18.21,1,1,0,0,0-.82,1v8.25a1,1,0,0,0,.36.77,1,1,0,0,0,.82.22A9.75,9.75,0,0,1,6,20.23a9.89,9.89,0,0,1,5.45,1.63h0l0,0,.13.05h0A1.09,1.09,0,0,0,12,22a.87.87,0,0,0,.28-.05l.07,0,.13-.05,0,0h0A9.89,9.89,0,0,1,18,20.23a9.75,9.75,0,0,1,1.82.18,1,1,0,0,0,.82-.22,1,1,0,0,0,.36-.77V11.17A1,1,0,0,0,20.18,10.19ZM12,4a1.86,1.86,0,0,1,0,3.71h0A1.86,1.86,0,0,1,12,4ZM11,19.33a11.92,11.92,0,0,0-5-1.1c-.33,0-.66,0-1,.05V12a9.63,9.63,0,0,1,2.52.05l.11,0A10,10,0,0,1,11,13.33Zm1-7.73a11.77,11.77,0,0,0-1.38-.68l-.06,0c-.33-.13-.66-.26-1-.36A4,4,0,0,1,12,9.69h0a4,4,0,0,1,2.44.85A12.43,12.43,0,0,0,12,11.6Zm7,6.68a11.6,11.6,0,0,0-6,1v-6a9.76,9.76,0,0,1,3.37-1.22l.2,0A9.39,9.39,0,0,1,19,12Z'
  }));
};

UilBookReader.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBookReader.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBookmark = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,2H8A3,3,0,0,0,5,5V21a1,1,0,0,0,.5.87,1,1,0,0,0,1,0L12,18.69l5.5,3.18A1,1,0,0,0,18,22a1,1,0,0,0,.5-.13A1,1,0,0,0,19,21V5A3,3,0,0,0,16,2Zm1,17.27-4.5-2.6a1,1,0,0,0-1,0L7,19.27V5A1,1,0,0,1,8,4h8a1,1,0,0,1,1,1Z'
  }));
};

UilBookmark.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBookmark.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBookmarkFull = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,2H6A1,1,0,0,0,5,3V21a1,1,0,0,0,1.65.76L12,17.27l5.29,4.44A1,1,0,0,0,18,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,19,21V3A1,1,0,0,0,18,2ZM17,18.86,12.64,15.2a1,1,0,0,0-1.28,0L7,18.86V4H17Z'
  }));
};

UilBookmarkFull.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBookmarkFull.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBooks = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.47,18.82l-1-3.86h0L18.32,3.37a1,1,0,0,0-1.22-.71l-3.87,1a1,1,0,0,0-.73-.33H2.5a1,1,0,0,0-1,1v16a1,1,0,0,0,1,1h10a1,1,0,0,0,1-1v-8l2.2,8.22a1,1,0,0,0,1,.74,1.15,1.15,0,0,0,.26,0l4.83-1.29a1,1,0,0,0,.61-.47A1.05,1.05,0,0,0,22.47,18.82Zm-16,.55h-3v-2h3Zm0-4h-3v-6h3Zm0-8h-3v-2h3Zm5,12h-3v-2h3Zm0-4h-3v-6h3Zm0-8h-3v-2h3Zm2.25-1.74,2.9-.78.52,1.93-2.9.78Zm2.59,9.66-1.55-5.8,2.9-.78,1.55,5.8Zm1,3.86-.52-1.93,2.9-.78.52,1.93Z'
  }));
};

UilBooks.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBooks.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBoombox = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V5A3,3,0,0,0,17,2Zm1,17a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4H17a1,1,0,0,1,1,1Zm-3.62-8.2A3,3,0,0,0,15,9,3,3,0,0,0,9,9a3,3,0,0,0,.62,1.8,4,4,0,1,0,4.76,0ZM12,8a1,1,0,1,1-1,1A1,1,0,0,1,12,8Zm0,8a2,2,0,1,1,2-2A2,2,0,0,1,12,16Z'
  }));
};

UilBoombox.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBoombox.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.5,18.5a1,1,0,1,0,1,1A1,1,0,0,0,11.5,18.5Zm9-15a1,1,0,0,0-1-1H3.5a1,1,0,0,0-1,1v16a1,1,0,0,0,2,0V4.5h15A1,1,0,0,0,20.5,3.5Zm-5,15a1,1,0,1,0,1,1A1,1,0,0,0,15.5,18.5Zm-8,0a1,1,0,1,0,1,1A1,1,0,0,0,7.5,18.5Zm12-12a1,1,0,1,0,1,1A1,1,0,0,0,19.5,6.5Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,19.5,10.5Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,19.5,14.5Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,19.5,18.5Z'
  }));
};

UilBorderAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderBottom = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,13.5a1,1,0,1,0-1-1A1,1,0,0,0,12,13.5Zm0,4a1,1,0,1,0-1-1A1,1,0,0,0,12,17.5Zm0-8a1,1,0,1,0-1-1A1,1,0,0,0,12,9.5Zm-4-4a1,1,0,1,0-1-1A1,1,0,0,0,8,5.5Zm0,8a1,1,0,1,0-1-1A1,1,0,0,0,8,13.5Zm12-8a1,1,0,1,0-1-1A1,1,0,0,0,20,5.5Zm-4,8a1,1,0,1,0-1-1A1,1,0,0,0,16,13.5Zm-4-8a1,1,0,1,0-1-1A1,1,0,0,0,12,5.5Zm4,0a1,1,0,1,0-1-1A1,1,0,0,0,16,5.5Zm4,10a1,1,0,1,0,1,1A1,1,0,0,0,20,15.5Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,20,11.5Zm0,8H4a1,1,0,0,0,0,2H20a1,1,0,0,0,0-2Zm0-12a1,1,0,1,0,1,1A1,1,0,0,0,20,7.5Zm-16,6a1,1,0,1,0-1-1A1,1,0,0,0,4,13.5Zm0-4a1,1,0,1,0-1-1A1,1,0,0,0,4,9.5Zm0,8a1,1,0,1,0-1-1A1,1,0,0,0,4,17.5Zm0-12a1,1,0,1,0-1-1A1,1,0,0,0,4,5.5Z'
  }));
};

UilBorderBottom.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderBottom.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderClear = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,11a1,1,0,1,0,1,1A1,1,0,0,0,8,11Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,8,19Zm4,0a1,1,0,1,0,1,1A1,1,0,0,0,12,19ZM4,3A1,1,0,1,0,5,4,1,1,0,0,0,4,3Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,4,11ZM20,5a1,1,0,1,0-1-1A1,1,0,0,0,20,5ZM4,19a1,1,0,1,0,1,1A1,1,0,0,0,4,19Zm8-4a1,1,0,1,0,1,1A1,1,0,0,0,12,15ZM4,15a1,1,0,1,0,1,1A1,1,0,0,0,4,15ZM4,7A1,1,0,1,0,5,8,1,1,0,0,0,4,7ZM8,3A1,1,0,1,0,9,4,1,1,0,0,0,8,3ZM20,15a1,1,0,1,0,1,1A1,1,0,0,0,20,15Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,20,19ZM20,7a1,1,0,1,0,1,1A1,1,0,0,0,20,7Zm-8,4a1,1,0,1,0,1,1A1,1,0,0,0,12,11Zm8,0a1,1,0,1,0,1,1A1,1,0,0,0,20,11ZM16,3a1,1,0,1,0,1,1A1,1,0,0,0,16,3ZM12,3a1,1,0,1,0,1,1A1,1,0,0,0,12,3Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,12,7Zm4,12a1,1,0,1,0,1,1A1,1,0,0,0,16,19Zm0-8a1,1,0,1,0,1,1A1,1,0,0,0,16,11Z'
  }));
};

UilBorderClear.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderClear.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderHorizontal = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,5A1,1,0,1,0,7,4,1,1,0,0,0,8,5ZM4,9A1,1,0,1,0,3,8,1,1,0,0,0,4,9Zm8,0a1,1,0,1,0-1-1A1,1,0,0,0,12,9ZM4,5A1,1,0,1,0,3,4,1,1,0,0,0,4,5ZM16,5a1,1,0,1,0-1-1A1,1,0,0,0,16,5ZM12,5a1,1,0,1,0-1-1A1,1,0,0,0,12,5Zm8,0a1,1,0,1,0-1-1A1,1,0,0,0,20,5ZM4,19a1,1,0,1,0,1,1A1,1,0,0,0,4,19Zm16,0a1,1,0,1,0,1,1A1,1,0,0,0,20,19Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,20,15Zm0-4H4a1,1,0,0,0,0,2H20a1,1,0,0,0,0-2Zm-4,8a1,1,0,1,0,1,1A1,1,0,0,0,16,19ZM4,15a1,1,0,1,0,1,1A1,1,0,0,0,4,15ZM20,7a1,1,0,1,0,1,1A1,1,0,0,0,20,7ZM8,19a1,1,0,1,0,1,1A1,1,0,0,0,8,19Zm4,0a1,1,0,1,0,1,1A1,1,0,0,0,12,19Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,12,15Z'
  }));
};

UilBorderHorizontal.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderHorizontal.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderInner = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,5A1,1,0,1,0,7,4,1,1,0,0,0,8,5ZM4,9A1,1,0,1,0,3,8,1,1,0,0,0,4,9ZM4,5A1,1,0,1,0,3,4,1,1,0,0,0,4,5ZM4,19a1,1,0,1,0,1,1A1,1,0,0,0,4,19ZM20,5a1,1,0,1,0-1-1A1,1,0,0,0,20,5Zm0,4a1,1,0,1,0-1-1A1,1,0,0,0,20,9ZM16,5a1,1,0,1,0-1-1A1,1,0,0,0,16,5Zm4,14a1,1,0,1,0,1,1A1,1,0,0,0,20,19ZM4,15a1,1,0,1,0,1,1A1,1,0,0,0,4,15Zm16,0a1,1,0,1,0,1,1A1,1,0,0,0,20,15Zm-4,4a1,1,0,1,0,1,1A1,1,0,0,0,16,19Zm5-7a1,1,0,0,0-1-1H13V4a1,1,0,0,0-2,0v7H4a1,1,0,0,0,0,2h7v7a1,1,0,0,0,2,0V13h7A1,1,0,0,0,21,12ZM8,19a1,1,0,1,0,1,1A1,1,0,0,0,8,19Z'
  }));
};

UilBorderInner.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderInner.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.5,19a1,1,0,1,0,1,1A1,1,0,0,0,11.5,19Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,11.5,15Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,11.5,11Zm-8-8a1,1,0,0,0-1,1V20a1,1,0,0,0,2,0V4A1,1,0,0,0,3.5,3Zm16,2a1,1,0,1,0-1-1A1,1,0,0,0,19.5,5Zm-8,2a1,1,0,1,0,1,1A1,1,0,0,0,11.5,7Zm-4,4a1,1,0,1,0,1,1A1,1,0,0,0,7.5,11Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,7.5,19Zm0-16a1,1,0,1,0,1,1A1,1,0,0,0,7.5,3Zm12,8a1,1,0,1,0,1,1A1,1,0,0,0,19.5,11Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,19.5,15Zm-8-12a1,1,0,1,0,1,1A1,1,0,0,0,11.5,3Zm8,16a1,1,0,1,0,1,1A1,1,0,0,0,19.5,19Zm0-12a1,1,0,1,0,1,1A1,1,0,0,0,19.5,7Zm-4-4a1,1,0,1,0,1,1A1,1,0,0,0,15.5,3Zm0,16a1,1,0,1,0,1,1A1,1,0,0,0,15.5,19Zm0-8a1,1,0,1,0,1,1A1,1,0,0,0,15.5,11Z'
  }));
};

UilBorderLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderOut = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,9a1,1,0,1,0-1-1A1,1,0,0,0,12,9Zm0,4a1,1,0,1,0-1-1A1,1,0,0,0,12,13Zm4,0a1,1,0,1,0-1-1A1,1,0,0,0,16,13Zm-4,4a1,1,0,1,0-1-1A1,1,0,0,0,12,17ZM20,3H4A1,1,0,0,0,3,4V20a1,1,0,0,0,1,1H20a1,1,0,0,0,1-1V4A1,1,0,0,0,20,3ZM19,19H5V5H19ZM8,13a1,1,0,1,0-1-1A1,1,0,0,0,8,13Z'
  }));
};

UilBorderOut.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderOut.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.5,7a1,1,0,1,0,1,1A1,1,0,0,0,4.5,7Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,4.5,3Zm4,16a1,1,0,1,0,1,1A1,1,0,0,0,8.5,19Zm-4,0a1,1,0,1,0,1,1A1,1,0,0,0,4.5,19Zm4-8a1,1,0,1,0,1,1A1,1,0,0,0,8.5,11Zm0-8a1,1,0,1,0,1,1A1,1,0,0,0,8.5,3Zm-4,8a1,1,0,1,0,1,1A1,1,0,0,0,4.5,11Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,4.5,15Zm12-12a1,1,0,1,0,1,1A1,1,0,0,0,16.5,3Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,16.5,11Zm-4,8a1,1,0,1,0,1,1A1,1,0,0,0,12.5,19Zm0-16a1,1,0,1,0,1,1A1,1,0,0,0,12.5,3Zm8,0a1,1,0,0,0-1,1V20a1,1,0,0,0,2,0V4A1,1,0,0,0,20.5,3Zm-4,16a1,1,0,1,0,1,1A1,1,0,0,0,16.5,19Zm-4-12a1,1,0,1,0,1,1A1,1,0,0,0,12.5,7Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,12.5,15Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,12.5,11Z'
  }));
};

UilBorderRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderTop = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,18.5a1,1,0,1,0,1,1A1,1,0,0,0,8,18.5Zm0-8a1,1,0,1,0,1,1A1,1,0,0,0,8,10.5Zm4,8a1,1,0,1,0,1,1A1,1,0,0,0,12,18.5ZM4,6.5a1,1,0,1,0,1,1A1,1,0,0,0,4,6.5Zm0,12a1,1,0,1,0,1,1A1,1,0,0,0,4,18.5Zm0-14H20a1,1,0,0,0,0-2H4a1,1,0,0,0,0,2Zm0,10a1,1,0,1,0,1,1A1,1,0,0,0,4,14.5Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,4,10.5Zm8-4a1,1,0,1,0,1,1A1,1,0,0,0,12,6.5Zm8,8a1,1,0,1,0,1,1A1,1,0,0,0,20,14.5Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,20,18.5Zm-8-4a1,1,0,1,0,1,1A1,1,0,0,0,12,14.5Zm8-8a1,1,0,1,0,1,1A1,1,0,0,0,20,6.5Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,20,10.5Zm-8,0a1,1,0,1,0,1,1A1,1,0,0,0,12,10.5Zm4,0a1,1,0,1,0,1,1A1,1,0,0,0,16,10.5Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,16,18.5Z'
  }));
};

UilBorderTop.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderTop.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBorderVertical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,3A1,1,0,1,0,4,4,1,1,0,0,0,3,3ZM3,7A1,1,0,1,0,4,8,1,1,0,0,0,3,7ZM19,5a1,1,0,1,0-1-1A1,1,0,0,0,19,5ZM7,11a1,1,0,1,0,1,1A1,1,0,0,0,7,11Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,7,19ZM7,3A1,1,0,1,0,8,4,1,1,0,0,0,7,3ZM3,15a1,1,0,1,0,1,1A1,1,0,0,0,3,15Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,3,11Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,3,19Zm16-4a1,1,0,1,0,1,1A1,1,0,0,0,19,15Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,19,11Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,19,19ZM19,7a1,1,0,1,0,1,1A1,1,0,0,0,19,7ZM15,3a1,1,0,1,0,1,1A1,1,0,0,0,15,3ZM11,3a1,1,0,0,0-1,1V20a1,1,0,0,0,2,0V4A1,1,0,0,0,11,3Zm4,16a1,1,0,1,0,1,1A1,1,0,0,0,15,19Zm0-8a1,1,0,1,0,1,1A1,1,0,0,0,15,11Z'
  }));
};

UilBorderVertical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBorderVertical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBowlingBall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.9917,8.00171a1,1,0,1,0,1,1A1,1,0,0,0,7.9917,8.00171ZM11.99121,2.002a10,10,0,1,0,10,10A10.01177,10.01177,0,0,0,11.99121,2.002Zm0,18a8,8,0,1,1,8-8A8.00916,8.00916,0,0,1,11.99121,20.002ZM10.9917,10.00171a1,1,0,1,0,1,1A1,1,0,0,0,10.9917,10.00171Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,10.9917,6.00171Z'
  }));
};

UilBowlingBall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBowlingBall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBox = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.49,7.52a.19.19,0,0,1,0-.08.17.17,0,0,1,0-.07l0-.09-.06-.15,0,0h0l0,0,0,0a.48.48,0,0,0-.09-.11l-.09-.08h0l-.05,0,0,0L16.26,4.45h0l-3.72-2.3A.85.85,0,0,0,12.25,2h-.08a.82.82,0,0,0-.27,0h-.1a1.13,1.13,0,0,0-.33.13L4,6.78l-.09.07-.09.08L3.72,7l-.05.06,0,0-.06.15,0,.09v.06a.69.69,0,0,0,0,.2v8.73a1,1,0,0,0,.47.85l7.5,4.64h0l0,0,.15.06.08,0a.86.86,0,0,0,.52,0l.08,0,.15-.06,0,0h0L20,17.21a1,1,0,0,0,.47-.85V7.63S20.49,7.56,20.49,7.52ZM12,4.17l1.78,1.1L8.19,8.73,6.4,7.63Zm-1,15L5.5,15.81V9.42l5.5,3.4Zm1-8.11L10.09,9.91l5.59-3.47L17.6,7.63Zm6.5,4.72L13,19.2V12.82l5.5-3.4Z'
  }));
};

UilBox.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBox.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBracketsCurly = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6,6A2,2,0,0,1,8,4,1,1,0,0,0,8,2,4,4,0,0,0,4,6V9a2,2,0,0,1-2,2,1,1,0,0,0,0,2,2,2,0,0,1,2,2v3a4,4,0,0,0,4,4,1,1,0,0,0,0-2,2,2,0,0,1-2-2V15a4,4,0,0,0-1.38-3A4,4,0,0,0,6,9Zm16,5a2,2,0,0,1-2-2V6a4,4,0,0,0-4-4,1,1,0,0,0,0,2,2,2,0,0,1,2,2V9a4,4,0,0,0,1.38,3A4,4,0,0,0,18,15v3a2,2,0,0,1-2,2,1,1,0,0,0,0,2,4,4,0,0,0,4-4V15a2,2,0,0,1,2-2,1,1,0,0,0,0-2Z'
  }));
};

UilBracketsCurly.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBracketsCurly.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrain = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,11A4,4,0,0,0,20,7.52,3,3,0,0,0,20,7a3,3,0,0,0-3-3l-.18,0A3,3,0,0,0,12,2.78,3,3,0,0,0,7.18,4L7,4A3,3,0,0,0,4,7a3,3,0,0,0,0,.52,4,4,0,0,0-.55,6.59A4,4,0,0,0,7,20l.18,0A3,3,0,0,0,12,21.22,3,3,0,0,0,16.82,20L17,20a4,4,0,0,0,3.5-5.89A4,4,0,0,0,22,11ZM11,8.55a4.72,4.72,0,0,0-.68-.32,1,1,0,0,0-.64,1.9A2,2,0,0,1,11,12v1.55a4.72,4.72,0,0,0-.68-.32,1,1,0,0,0-.64,1.9A2,2,0,0,1,11,17v2a1,1,0,0,1-1,1,1,1,0,0,1-.91-.6,4.07,4.07,0,0,0,.48-.33,1,1,0,1,0-1.28-1.54A2,2,0,0,1,7,18a2,2,0,0,1-2-2,2,2,0,0,1,.32-1.06A3.82,3.82,0,0,0,6,15a1,1,0,0,0,0-2,1.84,1.84,0,0,1-.69-.13A2,2,0,0,1,5,9.25a3.1,3.1,0,0,0,.46.35,1,1,0,1,0,1-1.74.9.9,0,0,1-.34-.33A.92.92,0,0,1,6,7,1,1,0,0,1,7,6a.76.76,0,0,1,.21,0,3.85,3.85,0,0,0,.19.47,1,1,0,0,0,1.37.37A1,1,0,0,0,9.13,5.5,1.06,1.06,0,0,1,9,5a1,1,0,0,1,2,0Zm7.69,4.32A1.84,1.84,0,0,1,18,13a1,1,0,0,0,0,2,3.82,3.82,0,0,0,.68-.06A2,2,0,0,1,19,16a2,2,0,0,1-2,2,2,2,0,0,1-1.29-.47,1,1,0,0,0-1.28,1.54,4.07,4.07,0,0,0,.48.33A1,1,0,0,1,14,20a1,1,0,0,1-1-1V17a2,2,0,0,1,1.32-1.87,1,1,0,0,0-.64-1.9,4.72,4.72,0,0,0-.68.32V12a2,2,0,0,1,1.32-1.87,1,1,0,0,0-.64-1.9,4.72,4.72,0,0,0-.68.32V5a1,1,0,0,1,2,0,1.06,1.06,0,0,1-.13.5,1,1,0,0,0,.36,1.37A1,1,0,0,0,16.6,6.5,3.85,3.85,0,0,0,16.79,6,.76.76,0,0,1,17,6a1,1,0,0,1,1,1,1,1,0,0,1-.17.55.9.9,0,0,1-.33.31,1,1,0,0,0,1,1.74A2.66,2.66,0,0,0,19,9.25a2,2,0,0,1-.27,3.62Z'
  }));
};

UilBrain.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrain.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBriefcase = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,6H17V5a3,3,0,0,0-3-3H10A3,3,0,0,0,7,5V6H3A1,1,0,0,0,2,7v4a3,3,0,0,0,1,2.22V19a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V13.22A3,3,0,0,0,22,11V7A1,1,0,0,0,21,6ZM9,5a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1V6H9ZM19,19a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V14H7v1a1,1,0,0,0,2,0V14h6v1a1,1,0,0,0,2,0V14h2Zm1-8a1,1,0,0,1-1,1H17V11a1,1,0,0,0-2,0v1H9V11a1,1,0,0,0-2,0v1H5a1,1,0,0,1-1-1V8H20Z'
  }));
};

UilBriefcase.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBriefcase.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBriefcaseAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6.5H16v-1a3,3,0,0,0-3-3H11a3,3,0,0,0-3,3v1H5a3,3,0,0,0-3,3v9a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-9A3,3,0,0,0,19,6.5Zm-9-1a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1v1H10Zm10,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V13a21.27,21.27,0,0,0,3,.94v.59a1,1,0,0,0,2,0v-.21a23,23,0,0,0,3,.21,23,23,0,0,0,3-.21v.21a1,1,0,0,0,2,0v-.59A21.27,21.27,0,0,0,20,13Zm0-7.69a20.39,20.39,0,0,1-3,1V11.5a1,1,0,0,0-2,0v.74a20.11,20.11,0,0,1-6,0V11.5a1,1,0,0,0-2,0v.33a20.39,20.39,0,0,1-3-1V9.5a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1Z'
  }));
};

UilBriefcaseAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBriefcaseAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBright = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14Zm9.71-2.71L19.36,9V5.64a1,1,0,0,0-1-1H15.05L12.71,2.29a1,1,0,0,0-1.42,0L9,4.64H5.64a1,1,0,0,0-1,1V9L2.29,11.29a1,1,0,0,0,0,1.42l2.35,2.34v3.31a1,1,0,0,0,1,1H9l2.34,2.35a1,1,0,0,0,1.42,0l2.34-2.35h3.31a1,1,0,0,0,1-1V15.05l2.35-2.34A1,1,0,0,0,21.71,11.29Zm-4.05,2.64a1,1,0,0,0-.3.71v2.72H14.64a1,1,0,0,0-.71.3L12,19.59l-1.93-1.93a1,1,0,0,0-.71-.3H6.64V14.64a1,1,0,0,0-.3-.71L4.41,12l1.93-1.93a1,1,0,0,0,.3-.71V6.64H9.36a1,1,0,0,0,.71-.3L12,4.41l1.93,1.93a1,1,0,0,0,.71.3h2.72V9.36a1,1,0,0,0,.3.71L19.59,12Z'
  }));
};

UilBright.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBright.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrightness = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,12a1,1,0,0,0-1-1H3a1,1,0,0,0,0,2H4A1,1,0,0,0,5,12ZM5.64,17l-.71.71a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0l.71-.71A1,1,0,0,0,5.64,17ZM12,5a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4A1,1,0,0,0,12,5Zm5.66,2.34a1,1,0,0,0,.7-.29l.71-.71a1,1,0,1,0-1.41-1.41L17,5.64a1,1,0,0,0,0,1.41A1,1,0,0,0,17.66,7.34Zm-12-.29a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-.71-.71A1,1,0,0,0,4.93,6.34ZM21,11H20a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM18.36,17A1,1,0,0,0,17,18.36l.71.71a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41ZM12,6.5A5.5,5.5,0,1,0,17.5,12,5.51,5.51,0,0,0,12,6.5Zm0,9A3.5,3.5,0,1,1,15.5,12,3.5,3.5,0,0,1,12,15.5ZM12,19a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V20A1,1,0,0,0,12,19Z'
  }));
};

UilBrightness.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrightness.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrightnessEmpty = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,11.29,19.36,9V5.64a1,1,0,0,0-1-1H15.05L12.71,2.29a1,1,0,0,0-1.42,0L9,4.64H5.64a1,1,0,0,0-1,1V9L2.29,11.29a1,1,0,0,0,0,1.42l2.35,2.34v3.31a1,1,0,0,0,1,1H9l2.34,2.35a1,1,0,0,0,1.42,0l2.34-2.35h3.31a1,1,0,0,0,1-1V15.05l2.35-2.34A1,1,0,0,0,21.71,11.29Zm-4.05,2.64a1,1,0,0,0-.3.71v2.72H14.64a1,1,0,0,0-.71.3L12,19.59l-1.93-1.93a1,1,0,0,0-.71-.3H6.64V14.64a1,1,0,0,0-.3-.71L4.41,12l1.93-1.93a1,1,0,0,0,.3-.71V6.64H9.36a1,1,0,0,0,.71-.3L12,4.41l1.93,1.93a1,1,0,0,0,.71.3h2.72V9.36a1,1,0,0,0,.3.71L19.59,12Z'
  }));
};

UilBrightnessEmpty.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrightnessEmpty.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrightnessHalf = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,8a1,1,0,0,0,0,2,2,2,0,0,1,0,4,1,1,0,0,0,0,2,4,4,0,0,0,0-8Zm9.71,3.29L19.36,9V5.64a1,1,0,0,0-1-1H15.05L12.71,2.29a1,1,0,0,0-1.42,0L9,4.64H5.64a1,1,0,0,0-1,1V9L2.29,11.29a1,1,0,0,0,0,1.42l2.35,2.34v3.31a1,1,0,0,0,1,1H9l2.34,2.35a1,1,0,0,0,1.42,0l2.34-2.35h3.31a1,1,0,0,0,1-1V15.05l2.35-2.34A1,1,0,0,0,21.71,11.29Zm-4.05,2.64a1,1,0,0,0-.3.71v2.72H14.64a1,1,0,0,0-.71.3L12,19.59l-1.93-1.93a1,1,0,0,0-.71-.3H6.64V14.64a1,1,0,0,0-.3-.71L4.41,12l1.93-1.93a1,1,0,0,0,.3-.71V6.64H9.36a1,1,0,0,0,.71-.3L12,4.41l1.93,1.93a1,1,0,0,0,.71.3h2.72V9.36a1,1,0,0,0,.3.71L19.59,12Z'
  }));
};

UilBrightnessHalf.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrightnessHalf.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrightnessLow = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,11a1,1,0,1,0,1,1A1,1,0,0,0,3,11Zm1.93,6.66a1,1,0,1,0,1.41,0A1,1,0,0,0,4.93,17.66ZM6.34,6.34a1,1,0,1,0-1.41,0A1,1,0,0,0,6.34,6.34ZM12,4a1,1,0,1,0-1-1A1,1,0,0,0,12,4Zm5.66,13.66a1,1,0,1,0,1.41,0A1,1,0,0,0,17.66,17.66ZM21,11a1,1,0,1,0,1,1A1,1,0,0,0,21,11ZM17.66,4.93a1,1,0,1,0,1.41,0A1,1,0,0,0,17.66,4.93ZM12,20a1,1,0,1,0,1,1A1,1,0,0,0,12,20ZM12,6a6,6,0,1,0,6,6A6,6,0,0,0,12,6Zm0,10a4,4,0,1,1,4-4A4,4,0,0,1,12,16Z'
  }));
};

UilBrightnessLow.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrightnessLow.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrightnessMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm7.71.29L19.36,9V5.64a1,1,0,0,0-1-1H15.05L12.71,2.29a1,1,0,0,0-1.42,0L9,4.64H5.64a1,1,0,0,0-1,1V9L2.29,11.29a1,1,0,0,0,0,1.42l2.35,2.34v3.31a1,1,0,0,0,1,1H9l2.34,2.35a1,1,0,0,0,1.42,0l2.34-2.35h3.31a1,1,0,0,0,1-1V15.05l2.35-2.34A1,1,0,0,0,21.71,11.29Zm-4.05,2.64a1,1,0,0,0-.3.71v2.72H14.64a1,1,0,0,0-.71.3L12,19.59l-1.93-1.93a1,1,0,0,0-.71-.3H6.64V14.64a1,1,0,0,0-.3-.71L4.41,12l1.93-1.93a1,1,0,0,0,.3-.71V6.64H9.36a1,1,0,0,0,.71-.3L12,4.41l1.93,1.93a1,1,0,0,0,.71.3h2.72V9.36a1,1,0,0,0,.3.71L19.59,12Z'
  }));
};

UilBrightnessMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrightnessMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrightnessPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11H13V10a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V13h1a1,1,0,0,0,0-2Zm7.71.29L19.36,9V5.64a1,1,0,0,0-1-1H15.05L12.71,2.29a1,1,0,0,0-1.42,0L9,4.64H5.64a1,1,0,0,0-1,1V9L2.29,11.29a1,1,0,0,0,0,1.42l2.35,2.34v3.31a1,1,0,0,0,1,1H9l2.34,2.35a1,1,0,0,0,1.42,0l2.34-2.35h3.31a1,1,0,0,0,1-1V15.05l2.35-2.34A1,1,0,0,0,21.71,11.29Zm-4.05,2.64a1,1,0,0,0-.3.71v2.72H14.64a1,1,0,0,0-.71.3L12,19.59l-1.93-1.93a1,1,0,0,0-.71-.3H6.64V14.64a1,1,0,0,0-.3-.71L4.41,12l1.93-1.93a1,1,0,0,0,.3-.71V6.64H9.36a1,1,0,0,0,.71-.3L12,4.41l1.93,1.93a1,1,0,0,0,.71.3h2.72V9.36a1,1,0,0,0,.3.71L19.59,12Z'
  }));
};

UilBrightnessPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrightnessPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBringBottom = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14H19a1,1,0,1,0,0,2h1v4H4V16h7a1,1,0,0,0,0-2H10V9A1,1,0,0,0,9,8H3A1,1,0,0,0,2,9v6H2v6a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V15A1,1,0,0,0,21,14ZM4,10H8v4H4ZM12.71,6.7,14,5.41V17a1,1,0,1,0,2,0V5.41L17.29,6.7A1,1,0,0,0,18,7a1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-3-3a1,1,0,0,0-1.42,0l-3,3a1,1,0,0,0,0,1.41A1,1,0,0,0,12.71,6.7Z'
  }));
};

UilBringBottom.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBringBottom.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBringFront = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,17.3,10,18.59V7A1,1,0,0,0,8,7v11.6L6.71,17.3a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l3,3a1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,0-1.41A1,1,0,0,0,11.29,17.3ZM22,3a1,1,0,0,0-1-1H3A1,1,0,0,0,2,3V9a1,1,0,0,0,1,1H5A1,1,0,0,0,5,8H4V4H20V8H13a1,1,0,0,0,0,2h1v5a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V9h0ZM20,14H16V10h4Z'
  }));
};

UilBringFront.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBringFront.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrowser = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H9A3,3,0,0,0,6,5V6H5A3,3,0,0,0,2,9V19a3,3,0,0,0,3,3H15a3,3,0,0,0,3-3V18h1a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM16,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V12H16Zm0-9H4V9A1,1,0,0,1,5,8H15a1,1,0,0,1,1,1Zm4,5a1,1,0,0,1-1,1H18V9a3,3,0,0,0-.18-1H20Zm0-9H8V5A1,1,0,0,1,9,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilBrowser.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrowser.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBrushAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,18a1,1,0,1,0,1,1A1,1,0,0,0,12,18ZM18,1H6A1,1,0,0,0,5,2v9a3,3,0,0,0,3,3H9v2.37a4,4,0,1,0,6,0V14h1a3,3,0,0,0,3-3V2A1,1,0,0,0,18,1ZM12,21a2,2,0,0,1-1.33-3.48,1,1,0,0,0,.33-.74V14h2v2.78a1,1,0,0,0,.33.74A2,2,0,0,1,12,21Zm5-10a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V10H17Zm0-3H7V3H17Z'
  }));
};

UilBrushAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBrushAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBug = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,14h2a1,1,0,0,0,0-2H19V11a5.15,5.15,0,0,0-.21-1.36A5,5,0,0,0,22,5a1,1,0,0,0-2,0,3,3,0,0,1-2.14,2.87A5,5,0,0,0,16,6.4,2.58,2.58,0,0,0,16,6,4,4,0,0,0,8,6a2.58,2.58,0,0,0,0,.4,5,5,0,0,0-1.9,1.47A3,3,0,0,1,4,5,1,1,0,0,0,2,5,5,5,0,0,0,5.21,9.64,5.15,5.15,0,0,0,5,11v1H3a1,1,0,0,0,0,2H5v1a7,7,0,0,0,.14,1.38A5,5,0,0,0,2,21a1,1,0,0,0,2,0,3,3,0,0,1,1.81-2.74,7,7,0,0,0,12.38,0A3,3,0,0,1,20,21a1,1,0,0,0,2,0,5,5,0,0,0-3.14-4.62A7,7,0,0,0,19,15Zm-8,5.9A5,5,0,0,1,7,15V11a3,3,0,0,1,3-3h1ZM10,6a2,2,0,0,1,4,0Zm7,9a5,5,0,0,1-4,4.9V8h1a3,3,0,0,1,3,3Z'
  }));
};

UilBug.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBug.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBuilding = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,8h1a1,1,0,0,0,0-2H14a1,1,0,0,0,0,2Zm0,4h1a1,1,0,0,0,0-2H14a1,1,0,0,0,0,2ZM9,8h1a1,1,0,0,0,0-2H9A1,1,0,0,0,9,8Zm0,4h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm12,8H20V3a1,1,0,0,0-1-1H5A1,1,0,0,0,4,3V20H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm-8,0H11V16h2Zm5,0H15V15a1,1,0,0,0-1-1H10a1,1,0,0,0-1,1v5H6V4H18Z'
  }));
};

UilBuilding.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBuilding.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBullseye = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,5a7,7,0,1,0,7,7A7,7,0,0,0,12,5Zm0,12a5,5,0,1,1,5-5A5,5,0,0,1,12,17Zm0-8a3,3,0,1,0,3,3A3,3,0,0,0,12,9Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,13ZM12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,20a9,9,0,1,1,9-9A9,9,0,0,1,12,21Z'
  }));
};

UilBullseye.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBullseye.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,17a1,1,0,0,0,1-1,1.36,1.36,0,0,0,0-.2.64.64,0,0,0-.06-.18.76.76,0,0,0-.09-.18l-.12-.15a1,1,0,0,0-.33-.21A1,1,0,0,0,8.3,15l-.18.06-.18.09a1.58,1.58,0,0,0-.15.12l-.12.15a.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2,1,1,0,0,0,1,1Zm8,0a1,1,0,0,0,1-1,1.36,1.36,0,0,0,0-.2.64.64,0,0,0-.06-.18.76.76,0,0,0-.09-.18l-.12-.15a1.15,1.15,0,0,0-.33-.21,1,1,0,0,0-.76,0,1.15,1.15,0,0,0-.33.21l-.12.15a.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2,1,1,0,0,0,.29.7A1,1,0,0,0,16.5,17Zm-3-12h-2a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Zm5-3H6.5a3,3,0,0,0-3,3V17a3,3,0,0,0,2,2.82V21a1,1,0,0,0,2,0V20h10v1a1,1,0,0,0,2,0V19.82a3,3,0,0,0,2-2.82V5A3,3,0,0,0,18.5,2Zm1,15a1,1,0,0,1-1,1H6.5a1,1,0,0,1-1-1V14h14Zm0-5H5.5V5a1,1,0,0,1,1-1h12a1,1,0,0,1,1,1Z'
  }));
};

UilBus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBusAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.5,2H6.5a3,3,0,0,0-3,3V17a3,3,0,0,0,2,2.82V21a1,1,0,0,0,2,0V20h10v1a1,1,0,0,0,2,0V19.82a3,3,0,0,0,2-2.82V5A3,3,0,0,0,18.5,2ZM5.5,8h6v4h-6Zm14,9a1,1,0,0,1-1,1H6.5a1,1,0,0,1-1-1V14h14Zm0-5h-6V8h6Zm0-6H5.5V5a1,1,0,0,1,1-1h12a1,1,0,0,1,1,1ZM16.12,16.92a1,1,0,0,0,.38.08,1,1,0,0,0,1-1,1.36,1.36,0,0,0,0-.2.64.64,0,0,0-.06-.18.76.76,0,0,0-.09-.18,1.58,1.58,0,0,0-.12-.15l-.15-.12a.76.76,0,0,0-.18-.09A.64.64,0,0,0,16.7,15a1,1,0,0,0-.91.27,1.58,1.58,0,0,0-.12.15.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2,1,1,0,0,0,.29.7A1,1,0,0,0,16.12,16.92Zm-8,0A1,1,0,0,0,8.5,17a1,1,0,0,0,1-1,1.36,1.36,0,0,0,0-.2.64.64,0,0,0-.06-.18.76.76,0,0,0-.09-.18,1.58,1.58,0,0,0-.12-.15l-.15-.12-.18-.09L8.7,15a1,1,0,0,0-.91.27,1.58,1.58,0,0,0-.12.15.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2,1,1,0,0,0,.29.7A1,1,0,0,0,8.12,16.92Z'
  }));
};

UilBusAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBusAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilBusSchool = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M1,12.5v4a1,1,0,0,0,1,1H3a3,3,0,0,0,6,0h6a3,3,0,0,0,6,0h1a1,1,0,0,0,1-1V6.5a3,3,0,0,0-3-3H8.44A3,3,0,0,0,5.6,5.55L4.16,9.86,1.45,11.67A1,1,0,0,0,1,12.5Zm20-3H19v-4h1a1,1,0,0,1,1,1Zm-4,8a1,1,0,1,1,1,1A1,1,0,0,1,17,17.5Zm-2-6h6v4h-.78a3,3,0,0,0-4.44,0H15Zm0-6h2v4H15Zm-4,6h2v4H11Zm0-6h2v4H11Zm-2,4H6.39l1.1-3.32a1,1,0,0,1,.95-.68H9Zm-4,8a1,1,0,1,1,1,1A1,1,0,0,1,5,17.5ZM3,13,5.3,11.5H9v4H8.22a3,3,0,0,0-4.44,0H3Z'
  }));
};

UilBusSchool.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilBusSchool.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCalculator = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,17.29a1,1,0,0,0-.16-.12.56.56,0,0,0-.17-.09.6.6,0,0,0-.19-.06.93.93,0,0,0-.57.06.9.9,0,0,0-.54.54A.84.84,0,0,0,11,18a1,1,0,0,0,.07.38,1.46,1.46,0,0,0,.22.33A1,1,0,0,0,12,19a.84.84,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,13,18a1,1,0,0,0-.08-.38A1,1,0,0,0,12.71,17.29ZM8.55,13.17a.56.56,0,0,0-.17-.09A.6.6,0,0,0,8.19,13a.86.86,0,0,0-.39,0l-.18.06-.18.09-.15.12A1.05,1.05,0,0,0,7,14a1,1,0,0,0,.29.71,1.15,1.15,0,0,0,.33.21A1,1,0,0,0,9,14a1.05,1.05,0,0,0-.29-.71Zm.16,4.12a1,1,0,0,0-.33-.21A1,1,0,0,0,7.8,17l-.18.06a.76.76,0,0,0-.18.09,1.58,1.58,0,0,0-.15.12,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,8,19a.84.84,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76A1,1,0,0,0,8.71,17.29Zm2.91-4.21a1,1,0,0,0-.33.21A1.05,1.05,0,0,0,11,14a1,1,0,0,0,1.38.92,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,13,14a1.05,1.05,0,0,0-.29-.71A1,1,0,0,0,11.62,13.08Zm5.09,4.21a1.15,1.15,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,16,19a.84.84,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1,1,0,0,0,16.71,17.29ZM16,5H8A1,1,0,0,0,7,6v4a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V6A1,1,0,0,0,16,5ZM15,9H9V7h6Zm3-8H6A3,3,0,0,0,3,4V20a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V4A3,3,0,0,0,18,1Zm1,19a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V4A1,1,0,0,1,6,3H18a1,1,0,0,1,1,1Zm-2.45-6.83a.56.56,0,0,0-.17-.09.6.6,0,0,0-.19-.06.86.86,0,0,0-.39,0l-.18.06-.18.09-.15.12A1.05,1.05,0,0,0,15,14a1,1,0,0,0,1.38.92,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,17,14a1.05,1.05,0,0,0-.29-.71Z'
  }));
};

UilCalculator.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCalculator.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCalculatorAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5.5,8H6v.5a1,1,0,0,0,2,0V8h.5a1,1,0,0,0,0-2H8V5.5a1,1,0,0,0-2,0V6H5.5a1,1,0,0,0,0,2ZM4.88,19.12a1,1,0,0,0,1.41,0L7,18.41l.71.71a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41L8.41,17l.71-.71a1,1,0,0,0-1.41-1.41L7,15.59l-.71-.71a1,1,0,0,0-1.41,1.41l.71.71-.71.71A1,1,0,0,0,4.88,19.12ZM20,1H4A3,3,0,0,0,1,4V20a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V4A3,3,0,0,0,20,1ZM11,21H4a1,1,0,0,1-1-1V13h8Zm0-10H3V4A1,1,0,0,1,4,3h7Zm10,9a1,1,0,0,1-1,1H13V13h8Zm0-9H13V3h7a1,1,0,0,1,1,1Zm-5.5,5.5h3a1,1,0,0,0,0-2h-3a1,1,0,0,0,0,2ZM18.5,6h-3a1,1,0,0,0,0,2h3a1,1,0,0,0,0-2Zm-3,13.5h3a1,1,0,0,0,0-2h-3a1,1,0,0,0,0,2Z'
  }));
};

UilCalculatorAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCalculatorAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCalendarAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,19a1,1,0,1,0-1-1A1,1,0,0,0,12,19Zm5,0a1,1,0,1,0-1-1A1,1,0,0,0,17,19Zm0-4a1,1,0,1,0-1-1A1,1,0,0,0,17,15Zm-5,0a1,1,0,1,0-1-1A1,1,0,0,0,12,15ZM19,3H18V2a1,1,0,0,0-2,0V3H8V2A1,1,0,0,0,6,2V3H5A3,3,0,0,0,2,6V20a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V6A3,3,0,0,0,19,3Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V11H20ZM20,9H4V6A1,1,0,0,1,5,5H6V6A1,1,0,0,0,8,6V5h8V6a1,1,0,0,0,2,0V5h1a1,1,0,0,1,1,1ZM7,15a1,1,0,1,0-1-1A1,1,0,0,0,7,15Zm0,4a1,1,0,1,0-1-1A1,1,0,0,0,7,19Z'
  }));
};

UilCalendarAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCalendarAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCalendarSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.66,7H15V8a1,1,0,0,0,2,0V7h1a1,1,0,0,1,1,1v3H17.66a1,1,0,0,0,0,2H19v1.34a1,1,0,1,0,2,0V8a3,3,0,0,0-3-3H17V4a1,1,0,0,0-2,0V5H11.66a1,1,0,0,0,0,2ZM21.71,20.29l-1.6-1.6h0L3.71,2.29A1,1,0,0,0,2.29,3.71L4.2,5.61A3,3,0,0,0,3,8V18a3,3,0,0,0,3,3H18a3,3,0,0,0,1.29-.3l1,1a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM5,8a1,1,0,0,1,.66-.93L9.59,11H5ZM6,19a1,1,0,0,1-1-1V13h6.59l6,6Z'
  }));
};

UilCalendarSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCalendarSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCalender = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,4H17V3a1,1,0,0,0-2,0V4H9V3A1,1,0,0,0,7,3V4H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4Zm1,15a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V12H20Zm0-9H4V7A1,1,0,0,1,5,6H7V7A1,1,0,0,0,9,7V6h6V7a1,1,0,0,0,2,0V6h2a1,1,0,0,1,1,1Z'
  }));
};

UilCalender.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCalender.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCalling = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.47,9a1,1,0,1,0-1-1A1,1,0,0,0,20.47,9Zm-3,0a1,1,0,1,0-1-1A1,1,0,0,0,17.47,9Zm-3,0a1,1,0,1,0-1-1A1,1,0,0,0,14.47,9ZM18.91,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.48,12.48,0,0,1-2.67-2,12.83,12.83,0,0,1-2-2.66L10,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.23-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-2.24,1,3,3,0,0,0-.73,2.39A19,19,0,0,0,18,21.91a2.56,2.56,0,0,0,.39,0,3,3,0,0,0,3-3v-3A3,3,0,0,0,18.91,13Zm.49,6a1,1,0,0,1-1.15,1,17.12,17.12,0,0,1-9.87-4.85A17.14,17.14,0,0,1,3.54,5.22a1,1,0,0,1,.25-.82,1,1,0,0,1,.74-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.56-.52l.63-1.4a13.69,13.69,0,0,0,1.58.46c.26.06.54.11.81.15a1,1,0,0,1,.78,1Z'
  }));
};

UilCalling.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCalling.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCamera = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6.5H17.72l-.32-1a3,3,0,0,0-2.84-2H9.44A3,3,0,0,0,6.6,5.55l-.32,1H5a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-8A3,3,0,0,0,19,6.5Zm1,11a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1v-8a1,1,0,0,1,1-1H7a1,1,0,0,0,1-.68l.54-1.64a1,1,0,0,1,.95-.68h5.12a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,17,8.5h2a1,1,0,0,1,1,1Zm-8-9a4,4,0,1,0,4,4A4,4,0,0,0,12,8.5Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14.5Z'
  }));
};

UilCamera.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCamera.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCameraChange = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.29,5.21l1.5,1.5a1,1,0,0,0,1.42,0,1,1,0,0,0,.13-1.21H19a1,1,0,0,0,0-2H15.34a1,1,0,0,0-.13-1.21,1,1,0,0,0-1.42,0l-1.5,1.5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76A1,1,0,0,0,12.29,5.21ZM22.92,9.12a1,1,0,0,0-.21-.33l-1.5-1.5a1,1,0,0,0-1.42,0,1,1,0,0,0-.13,1.21H16a1,1,0,0,0,0,2h3.66a1,1,0,0,0,.13,1.21,1,1,0,0,0,1.42,0l1.5-1.5a1,1,0,0,0,.21-.33A1,1,0,0,0,22.92,9.12ZM11,10a4,4,0,1,0,4,4A4,4,0,0,0,11,10Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,11,16Zm9-3a1,1,0,0,0-1,1v5a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V11a1,1,0,0,1,1-1H6a1,1,0,0,0,1-.69l.54-1.62A1,1,0,0,1,8.44,7H10a1,1,0,0,0,0-2H8.44A3,3,0,0,0,5.59,7.06L5.28,8H4a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V14A1,1,0,0,0,20,13Z'
  }));
};

UilCameraChange.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCameraChange.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCameraPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,10.5a1,1,0,0,0-1,1v7a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1v-8a1,1,0,0,1,1-1H6a1,1,0,0,0,1-.68l.54-1.64a1,1,0,0,1,.95-.68H14a1,1,0,0,0,0-2H8.44A3,3,0,0,0,5.6,6.55l-.32,1H4a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3v-7A1,1,0,0,0,20,10.5Zm-9-1a4,4,0,1,0,4,4A4,4,0,0,0,11,9.5Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,11,15.5Zm11-11H21v-1a1,1,0,0,0-2,0v1H18a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h1a1,1,0,0,0,0-2Z'
  }));
};

UilCameraPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCameraPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCameraSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3.71,2.29A1,1,0,0,0,2.29,3.71L5.09,6.5H5a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H19.08l1.21,1.22a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm6.49,9.33,2.68,2.68a2,2,0,0,1-.88.2,2,2,0,0,1-2-2A2,2,0,0,1,10.2,11.62ZM5,18.5a1,1,0,0,1-1-1v-8a1,1,0,0,1,1-1H7.07l1.7,1.69A3.92,3.92,0,0,0,8,12.5a4,4,0,0,0,4,4,3.92,3.92,0,0,0,2.32-.77l2.77,2.77Zm14-12H17.72l-.31-1a3,3,0,0,0-2.85-2h-4.4a1,1,0,0,0,0,2h4.4a1,1,0,0,1,.95.68l.54,1.63A1,1,0,0,0,17,8.5h2a1,1,0,0,1,1,1v5.84a1,1,0,1,0,2,0V9.5A3,3,0,0,0,19,6.5Z'
  }));
};

UilCameraSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCameraSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCancel = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.77,11.36l-5-6A1,1,0,0,0,16,5H5A3,3,0,0,0,2,8v8a3,3,0,0,0,3,3H16a1,1,0,0,0,.77-.36l5-6A1,1,0,0,0,21.77,11.36ZM15.53,17H5a1,1,0,0,1-1-1V8A1,1,0,0,1,5,7H15.53l4.17,5ZM12.71,9.29a1,1,0,0,0-1.42,0L10,10.59,8.71,9.29a1,1,0,1,0-1.42,1.42L8.59,12l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L10,13.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L11.41,12l1.3-1.29A1,1,0,0,0,12.71,9.29Z'
  }));
};

UilCancel.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCancel.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCapsule = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.5,4.5a5.12,5.12,0,0,0-7.24,0L4.5,12.26a5.12,5.12,0,1,0,7.24,7.24l7.76-7.76A5.12,5.12,0,0,0,19.5,4.5ZM10.32,18.09a3.21,3.21,0,0,1-4.41,0,3.13,3.13,0,0,1,0-4.41L9.09,10.5l4.41,4.41Zm7.77-7.77L14.91,13.5,10.5,9.09l3.18-3.18a3.12,3.12,0,0,1,4.41,4.41Z'
  }));
};

UilCapsule.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCapsule.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCapture = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,9A1,1,0,0,0,4,8V5A1,1,0,0,1,5,4H8A1,1,0,0,0,8,2H5A3,3,0,0,0,2,5V8A1,1,0,0,0,3,9ZM8,20H5a1,1,0,0,1-1-1V16a1,1,0,0,0-2,0v3a3,3,0,0,0,3,3H8a1,1,0,0,0,0-2ZM12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14ZM19,2H16a1,1,0,0,0,0,2h3a1,1,0,0,1,1,1V8a1,1,0,0,0,2,0V5A3,3,0,0,0,19,2Zm2,13a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H16a1,1,0,0,0,0,2h3a3,3,0,0,0,3-3V16A1,1,0,0,0,21,15Z'
  }));
};

UilCapture.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCapture.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCar = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.62,13.08a.9.9,0,0,0-.54.54,1,1,0,0,0,1.3,1.3,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33A.84.84,0,0,0,8,14a1.05,1.05,0,0,0-.29-.71A1,1,0,0,0,6.62,13.08Zm13.14-4L18.4,5.05a3,3,0,0,0-2.84-2H8.44A3,3,0,0,0,5.6,5.05L4.24,9.11A3,3,0,0,0,2,12v4a3,3,0,0,0,2,2.82V20a1,1,0,0,0,2,0V19H18v1a1,1,0,0,0,2,0V18.82A3,3,0,0,0,22,16V12A3,3,0,0,0,19.76,9.11ZM7.49,5.68A1,1,0,0,1,8.44,5h7.12a1,1,0,0,1,1,.68L17.61,9H6.39ZM20,16a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1Zm-3.38-2.92a.9.9,0,0,0-.54.54,1,1,0,0,0,1.3,1.3.9.9,0,0,0,.54-.54A.84.84,0,0,0,18,14a1.05,1.05,0,0,0-.29-.71A1,1,0,0,0,16.62,13.08ZM13,13H11a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Z'
  }));
};

UilCar.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCar.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCarSideview = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,9.5h-.32L17.43,6.38A3,3,0,0,0,14.65,4.5h-6A3,3,0,0,0,5.7,6.91L5.18,9.5H5a3,3,0,0,0-3,3v3a1,1,0,0,0,1,1H4a3,3,0,0,0,6,0h4a3,3,0,0,0,6,0h1a1,1,0,0,0,1-1v-3A3,3,0,0,0,19,9.5Zm-6-3h1.65a1,1,0,0,1,.92.63l.95,2.37H13Zm-5.34.8a1,1,0,0,1,1-.8H11v3H7.22ZM7,17.5a1,1,0,1,1,1-1A1,1,0,0,1,7,17.5Zm10,0a1,1,0,1,1,1-1A1,1,0,0,1,17,17.5Zm3-3h-.78a3,3,0,0,0-4.44,0H9.22a3,3,0,0,0-4.44,0H4v-2a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1Z'
  }));
};

UilCarSideview.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCarSideview.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCarSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,13a1,1,0,1,0,1,1A1,1,0,0,0,7,13ZM19.76,9.11,18.41,5.05a3,3,0,0,0-2.85-2H9.66a1,1,0,0,0,0,2h5.9a1,1,0,0,1,1,.69L17.61,9H15.66a1,1,0,0,0,0,2H19a1,1,0,0,1,1,1v3.34a1,1,0,1,0,2,0V12A3,3,0,0,0,19.76,9.11Zm-16-6.82A1,1,0,0,0,2.29,3.71L5.11,6.52,4.24,9.11A3,3,0,0,0,2,12v4a3,3,0,0,0,2,2.82V20a1,1,0,0,0,2,0V19H17.59l.41.41V20a1,1,0,0,0,1,1,.91.91,0,0,0,.46-.13l.83.84a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm3,5.81.9.9H6.39ZM5,17a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H9.59l2,2H11a1,1,0,0,0,0,2h2a.91.91,0,0,0,.46-.13L15.59,17Z'
  }));
};

UilCarSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCarSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCarWash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.5,4a1,1,0,0,0,.71-.29l1-1A1,1,0,0,0,7.79,1.29l-1,1a1,1,0,0,0,0,1.42A1,1,0,0,0,7.5,4Zm4,0a1,1,0,0,0,.71-.29l1-1a1,1,0,1,0-1.42-1.42l-1,1a1,1,0,0,0,0,1.42A1,1,0,0,0,11.5,4Zm4,0a1,1,0,0,0,.71-.29l1-1a1,1,0,1,0-1.42-1.42l-1,1a1,1,0,0,0,0,1.42A1,1,0,0,0,15.5,4Zm2.42,11.62a.76.76,0,0,0-.09-.18l-.12-.15-.15-.12a.76.76,0,0,0-.18-.09.6.6,0,0,0-.19-.06,1,1,0,0,0-.9.27,1.58,1.58,0,0,0-.12.15.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2,1,1,0,0,0,.29.7.91.91,0,0,0,.33.22A1,1,0,0,0,17,17a1,1,0,0,0,1-1,1.36,1.36,0,0,0,0-.2A.64.64,0,0,0,17.92,15.62Zm1.84-4.51L18.4,7.05a3,3,0,0,0-2.84-2H8.44A3,3,0,0,0,5.6,7.05L4.24,11.11A3,3,0,0,0,2,14v4a3,3,0,0,0,2,2.82V22a1,1,0,0,0,2,0V21H18v1a1,1,0,0,0,2,0V20.82A3,3,0,0,0,22,18V14A3,3,0,0,0,19.76,11.11ZM7.49,7.68A1,1,0,0,1,8.44,7h7.12a1,1,0,0,1,1,.68L17.61,11H6.39ZM20,18a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V14a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1Zm-7-3H11a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Zm-5.08.62a.76.76,0,0,0-.09-.18l-.12-.15a1,1,0,0,0-1.09-.21,1,1,0,0,0-.33.21,1.58,1.58,0,0,0-.12.15.76.76,0,0,0-.09.18A.64.64,0,0,0,6,15.8,1.36,1.36,0,0,0,6,16a1,1,0,0,0,1.71.7A1,1,0,0,0,8,16a1.36,1.36,0,0,0,0-.2A.64.64,0,0,0,7.92,15.62Z'
  }));
};

UilCarWash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCarWash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCardAtm = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,4.5H5a3,3,0,0,0-3,3v9a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-9A3,3,0,0,0,19,4.5Zm1,12a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1v-9a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1Zm-4-6a3,3,0,0,0-1.51.42,3,3,0,1,0,0,5.16A3,3,0,1,0,16,10.5Zm-2.83,4a1,1,0,0,1-.17,0,1,1,0,0,1,0-2,1,1,0,0,1,.17,0,2.8,2.8,0,0,0,0,1.92Zm2.83,0a1,1,0,1,1,1-1A1,1,0,0,1,16,14.5Z'
  }));
};

UilCardAtm.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCardAtm.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCaretRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.5,11.13,5.5,3.05a1,1,0,0,0-1,0,1,1,0,0,0-.5.87V20.08a1,1,0,0,0,.5.87,1,1,0,0,0,1,0l14-8.08a1,1,0,0,0,0-1.74ZM6,18.35V5.65L17,12Z'
  }));
};

UilCaretRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCaretRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCell = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.49,4.73,17,2.17a1,1,0,0,0-1,0L12,4.45,8,2.17a1,1,0,0,0-1,0L2.51,4.73A1,1,0,0,0,2,5.6v5.12a1,1,0,0,0,.51.87l4,2.27V18.4a1,1,0,0,0,.51.87l4.5,2.56a1,1,0,0,0,1,0L17,19.27a1,1,0,0,0,.51-.87V13.86l4-2.27a1,1,0,0,0,.51-.87V5.6A1,1,0,0,0,21.49,4.73ZM4,10.14v-4l3.5-2,3.5,2v4l-3.5,2Zm11.5,7.68-3.5,2-3.5-2v-4l3.5-2,3.5,2ZM20,10.14l-3.5,2-3.5-2v-4l3.5-2,3.5,2Z'
  }));
};

UilCell.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCell.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCelsius = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,19H15a3,3,0,0,1-3-3V8a3,3,0,0,1,3-3h6a1,1,0,0,0,0-2H15a5,5,0,0,0-5,5v8a5,5,0,0,0,5,5h6a1,1,0,0,0,0-2ZM5,3A3,3,0,1,0,8,6,3,3,0,0,0,5,3ZM5,7A1,1,0,1,1,6,6,1,1,0,0,1,5,7Z'
  }));
};

UilCelsius.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCelsius.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChannel = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,16a3,3,0,0,0-1.73.56l-2.45-1.45A3.74,3.74,0,0,0,16,14a4,4,0,0,0-3-3.86V7.82a3,3,0,1,0-2,0v2.32A4,4,0,0,0,8,14a3.74,3.74,0,0,0,.18,1.11L5.73,16.56A3,3,0,0,0,4,16a3,3,0,1,0,3,3,3,3,0,0,0-.12-.8l2.3-1.37a4,4,0,0,0,5.64,0l2.3,1.37A3,3,0,1,0,20,16ZM4,20a1,1,0,1,1,1-1A1,1,0,0,1,4,20ZM12,4a1,1,0,1,1-1,1A1,1,0,0,1,12,4Zm0,12a2,2,0,1,1,2-2A2,2,0,0,1,12,16Zm8,4a1,1,0,1,1,1-1A1,1,0,0,1,20,20Z'
  }));
};

UilChannel.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChannel.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChannelAdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,7h1V8a1,1,0,0,0,2,0V7h1a1,1,0,0,0,0-2H21V4a1,1,0,0,0-2,0V5H18a1,1,0,0,0,0,2Zm2,9a3,3,0,0,0-1.73.56l-2.45-1.45A3.74,3.74,0,0,0,16,14a4,4,0,0,0-3-3.86V7.82a3,3,0,1,0-2,0v2.32A4,4,0,0,0,8,14a3.74,3.74,0,0,0,.18,1.11L5.73,16.56A3,3,0,0,0,4,16a3,3,0,1,0,3,3,3,3,0,0,0-.12-.8l2.3-1.37a4,4,0,0,0,5.64,0l2.3,1.37A3,3,0,1,0,20,16ZM4,20a1,1,0,1,1,1-1A1,1,0,0,1,4,20ZM12,4a1,1,0,1,1-1,1A1,1,0,0,1,12,4Zm0,12a2,2,0,1,1,2-2A2,2,0,0,1,12,16Zm8,4a1,1,0,1,1,1-1A1,1,0,0,1,20,20Z'
  }));
};

UilChannelAdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChannelAdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6a1,1,0,0,0-1,1V17a1,1,0,0,0,2,0V7A1,1,0,0,0,12,6ZM7,12a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V13A1,1,0,0,0,7,12Zm10-2a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V11A1,1,0,0,0,17,10Zm2-8H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilChart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartBar = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H20V5a1,1,0,0,0-2,0V20H16V13a1,1,0,0,0-2,0v7H12V9a1,1,0,0,0-2,0V20H8V17a1,1,0,0,0-2,0v3H4V3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,0-2Z'
  }));
};

UilChartBar.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartBar.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartBarAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H4V18H7a1,1,0,0,0,0-2H4V14H15a1,1,0,0,0,0-2H4V10h7a1,1,0,0,0,0-2H4V6H19a1,1,0,0,0,0-2H4V3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,0-2Z'
  }));
};

UilChartBarAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartBarAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11a1,1,0,0,0-1,1v2.59l-6.29-6.3a1,1,0,0,0-1.42,0L9,11.59,3.71,6.29A1,1,0,0,0,2.29,7.71l6,6a1,1,0,0,0,1.42,0L13,10.41,18.59,16H16a1,1,0,0,0,0,2h5a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,17V12A1,1,0,0,0,21,11Z'
  }));
};

UilChartDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartGrowth = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H20V5a1,1,0,0,0-2,0V20H16V9a1,1,0,0,0-2,0V20H12V13a1,1,0,0,0-2,0v7H8V17a1,1,0,0,0-2,0v3H4V3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,0-2Z'
  }));
};

UilChartGrowth.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartGrowth.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartGrowthAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H4V18H7a1,1,0,0,0,0-2H4V14h7a1,1,0,0,0,0-2H4V10H15a1,1,0,0,0,0-2H4V6H19a1,1,0,0,0,0-2H4V3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,0-2Z'
  }));
};

UilChartGrowthAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartGrowthAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartLine = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,16a1.5,1.5,0,0,0,1.5-1.5.77.77,0,0,0,0-.15l2.79-2.79.23,0,.23,0,1.61,1.61s0,.05,0,.08a1.5,1.5,0,1,0,3,0v-.08L20,9.5h0A1.5,1.5,0,1,0,18.5,8a.77.77,0,0,0,0,.15l-3.61,3.61h-.16L13,10a1.49,1.49,0,0,0-3,0L7,13H7a1.5,1.5,0,0,0,0,3Zm13.5,4H3.5V3a1,1,0,0,0-2,0V21a1,1,0,0,0,1,1h18a1,1,0,0,0,0-2Z'
  }));
};

UilChartLine.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartLine.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartPie = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2a10,10,0,1,0,4.93,18.69l.07,0,.05,0A10,10,0,0,0,12,2Zm1,2.07A8,8,0,0,1,19.93,11H13ZM12,20A8,8,0,0,1,11,4.07V12a1.09,1.09,0,0,0,.07.35l0,.08,0,.07,4,6.87A7.81,7.81,0,0,1,12,20Zm4.83-1.64L13.73,13h6.2A8,8,0,0,1,16.83,18.36Z'
  }));
};

UilChartPie.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartPie.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChartPieAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,12h-7V5c0-0.6-0.4-1-1-1c-5,0-9,4-9,9s4,9,9,9s9-4,9-9C20,12.4,19.6,12,19,12z M12,19.9c-3.8,0.6-7.4-2.1-7.9-5.9C3.5,10.2,6.2,6.6,10,6.1V13c0,0.6,0.4,1,1,1h6.9C17.5,17.1,15.1,19.5,12,19.9z M15,2c-0.6,0-1,0.4-1,1v6c0,0.6,0.4,1,1,1h6c0.6,0,1-0.4,1-1C22,5.1,18.9,2,15,2z M16,8V4.1C18,4.5,19.5,6,19.9,8H16z'
  }));
};

UilChartPieAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChartPieAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChat = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,2H6A3,3,0,0,0,3,5V16a3,3,0,0,0,3,3H8.59l2.7,2.71A1,1,0,0,0,12,22a1,1,0,0,0,.65-.24L15.87,19H18a3,3,0,0,0,3-3V5A3,3,0,0,0,18,2Zm1,14a1,1,0,0,1-1,1H15.5a1,1,0,0,0-.65.24l-2.8,2.4L9.71,17.29A1,1,0,0,0,9,17H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4H18a1,1,0,0,1,1,1Z'
  }));
};

UilChat.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChat.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChatBubbleUser = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.58,11.3a3.24,3.24,0,0,0,.71-2,3.29,3.29,0,0,0-6.58,0,3.24,3.24,0,0,0,.71,2,5,5,0,0,0-2,2.31,1,1,0,1,0,1.84.78A3,3,0,0,1,12,12.57h0a3,3,0,0,1,2.75,1.82,1,1,0,0,0,.92.61,1.09,1.09,0,0,0,.39-.08,1,1,0,0,0,.53-1.31A5,5,0,0,0,14.58,11.3ZM12,10.57h0a1.29,1.29,0,1,1,1.29-1.28A1.29,1.29,0,0,1,12,10.57ZM18,2H6A3,3,0,0,0,3,5V16a3,3,0,0,0,3,3H8.59l2.7,2.71A1,1,0,0,0,12,22a1,1,0,0,0,.65-.24L15.87,19H18a3,3,0,0,0,3-3V5A3,3,0,0,0,18,2Zm1,14a1,1,0,0,1-1,1H15.5a1,1,0,0,0-.65.24l-2.8,2.4L9.71,17.29A1,1,0,0,0,9,17H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4H18a1,1,0,0,1,1,1Z'
  }));
};

UilChatBubbleUser.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChatBubbleUser.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilChatInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.29,3.71a1,1,0,0,0,1.42,0,1.15,1.15,0,0,0,.21-.33A1,1,0,0,0,21,3a1,1,0,0,0-.29-.71l-.15-.12a.76.76,0,0,0-.18-.09,1,1,0,0,0-1.09.21A1,1,0,0,0,19,3a1,1,0,0,0,.08.38A1.15,1.15,0,0,0,19.29,3.71ZM20,5a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V6A1,1,0,0,0,20,5Zm.06,8a1,1,0,0,0-1.11.87A7,7,0,0,1,12,20H6.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,12,6a6.91,6.91,0,0,1,3.49.94,1,1,0,0,0,1-1.72A8.84,8.84,0,0,0,12,4,9,9,0,0,0,5,18.62L3.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,4,22h8a9,9,0,0,0,8.93-7.88A1,1,0,0,0,20.06,13Z'
  }));
};

UilChatInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilChatInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.71,7.21a1,1,0,0,0-1.42,0L9.84,14.67,6.71,11.53A1,1,0,1,0,5.29,13l3.84,3.84a1,1,0,0,0,1.42,0l8.16-8.16A1,1,0,0,0,18.71,7.21Z'
  }));
};

UilCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCheckCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.72,8.79l-4.29,4.3L8.78,11.44a1,1,0,1,0-1.41,1.41l2.35,2.36a1,1,0,0,0,.71.29,1,1,0,0,0,.7-.29l5-5a1,1,0,0,0,0-1.42A1,1,0,0,0,14.72,8.79ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilCheckCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCheckCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCheckSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.21,14.75a1,1,0,0,0,1.42,0l4.08-4.08a1,1,0,0,0-1.42-1.42l-3.37,3.38L9.71,11.41a1,1,0,0,0-1.42,1.42ZM21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,20H4V4H20Z'
  }));
};

UilCheckSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCheckSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCircleLayer = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,2A7,7,0,0,0,8.12,7.74,6,6,0,0,0,5,12.41,5,5,0,1,0,11.59,19a6,6,0,0,0,4.67-3.09A7,7,0,0,0,15,2ZM10,17.43c0,.1,0,.2-.07.31h0a3,3,0,1,1-3.64-3.64h0L6.57,14A2.94,2.94,0,0,1,10,17.43Zm5-3.67a1.8,1.8,0,0,1-.05.19,3.74,3.74,0,0,1-.17.54,4,4,0,0,1-2.7,2.4c0-.18,0-.35-.06-.53s0-.27,0-.4-.12-.38-.18-.57-.07-.24-.12-.36a4.21,4.21,0,0,0-.3-.55c0-.09-.09-.19-.15-.28a5.3,5.3,0,0,0-.6-.73l-.2-.17a5.52,5.52,0,0,0-.53-.43,2.9,2.9,0,0,0-.34-.19,4,4,0,0,0-.5-.27,2.34,2.34,0,0,0-.4-.13,3.13,3.13,0,0,0-.52-.16c-.14,0-.29,0-.44-.06L7.13,12A4,4,0,0,1,9.52,9.3a3.27,3.27,0,0,1,.53-.17l.2-.05A3.74,3.74,0,0,1,11,9a4,4,0,0,1,4,4A3.84,3.84,0,0,1,14.92,13.76Zm2-.16q0-.3,0-.6a6,6,0,0,0-6-6q-.3,0-.6,0A5,5,0,1,1,17,13.6Z'
  }));
};

UilCircleLayer.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCircleLayer.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCircuit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,13a1,1,0,1,0,1,1A1,1,0,0,0,10,13Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,10,9Zm4,0a1,1,0,1,0,1,1A1,1,0,0,0,14,9Zm7,4a1,1,0,0,0,0-2H19V9h2a1,1,0,0,0,0-2H18.82A3,3,0,0,0,17,5.18V3a1,1,0,0,0-2,0V5H13V3a1,1,0,0,0-2,0V5H9V3A1,1,0,0,0,7,3V5.18A3,3,0,0,0,5.18,7H3A1,1,0,0,0,3,9H5v2H3a1,1,0,0,0,0,2H5v2H3a1,1,0,0,0,0,2H5.18A3,3,0,0,0,7,18.82V21a1,1,0,0,0,2,0V19h2v2a1,1,0,0,0,2,0V19h2v2a1,1,0,0,0,2,0V18.82A3,3,0,0,0,18.82,17H21a1,1,0,0,0,0-2H19V13Zm-4,3a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V8A1,1,0,0,1,8,7h8a1,1,0,0,1,1,1Zm-3-3a1,1,0,1,0,1,1A1,1,0,0,0,14,13Z'
  }));
};

UilCircuit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCircuit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClapperBoard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM16.09,4l-4,4H7.91l4-4ZM4,5A1,1,0,0,1,5,4H9.09l-4,4H4ZM20,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V10H20ZM20,8H14.91l4-4H19a1,1,0,0,1,1,1Z'
  }));
};

UilClapperBoard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClapperBoard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClinicMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,12v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V15h1a1,1,0,0,0,0-2H13V12a1,1,0,0,0-2,0Zm10.66406-1.74756-9-8a.99893.99893,0,0,0-1.32812,0l-9,8a.99991.99991,0,0,0,1.32812,1.49512L4,11.449V21a.99974.99974,0,0,0,1,1H19a.99974.99974,0,0,0,1-1V11.449l.33594.29859a.99991.99991,0,0,0,1.32812-1.49512ZM18,20H6V9.6712l6-5.33331L18,9.6712Z'
  }));
};

UilClinicMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClinicMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClipboard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,4H15.82A3,3,0,0,0,13,2H11A3,3,0,0,0,8.18,4H7A3,3,0,0,0,4,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V7A3,3,0,0,0,17,4ZM10,5a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V6H10Zm8,14a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V7A1,1,0,0,1,7,6H8V7A1,1,0,0,0,9,8h6a1,1,0,0,0,1-1V6h1a1,1,0,0,1,1,1Z'
  }));
};

UilClipboard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClipboard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClipboardAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,14H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0-4H11a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm2-6H15.82A3,3,0,0,0,13,2H11A3,3,0,0,0,8.18,4H7A3,3,0,0,0,4,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V7A3,3,0,0,0,17,4ZM10,5a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V6H10Zm8,14a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V7A1,1,0,0,1,7,6H8V7A1,1,0,0,0,9,8h6a1,1,0,0,0,1-1V6h1a1,1,0,0,1,1,1Z'
  }));
};

UilClipboardAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClipboardAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClipboardBlank = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,4H16a2,2,0,0,0-2-2H10A2,2,0,0,0,8,4H7A3,3,0,0,0,4,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V7A3,3,0,0,0,17,4ZM10,4h4V5h0V6H10V4Zm8,15a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V7A1,1,0,0,1,7,6H8a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2h1a1,1,0,0,1,1,1Z'
  }));
};

UilClipboardBlank.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClipboardBlank.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClipboardNotes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,14H9a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2ZM17,4H15.82A3,3,0,0,0,13,2H11A3,3,0,0,0,8.18,4H7A3,3,0,0,0,4,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V7A3,3,0,0,0,17,4ZM10,5a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V6H10Zm8,14a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V7A1,1,0,0,1,7,6H8V7A1,1,0,0,0,9,8h6a1,1,0,0,0,1-1V6h1a1,1,0,0,1,1,1Zm-3-9H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilClipboardNotes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClipboardNotes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.09814,12.63379,13,11.42285V7a1,1,0,0,0-2,0v5a.99985.99985,0,0,0,.5.86621l2.59814,1.5a1.00016,1.00016,0,1,0,1-1.73242ZM12,2A10,10,0,1,0,22,12,10.01114,10.01114,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilClock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockEight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6a.99974.99974,0,0,0-1,1v4.38379L8.56934,12.60693a.99968.99968,0,1,0,.89843,1.78614l2.98145-1.5A.99874.99874,0,0,0,13,12V7A.99974.99974,0,0,0,12,6Zm0-4A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilClockEight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockEight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockFive = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Zm1-8.251V7a1,1,0,0,0-2,0v5a1.00586,1.00586,0,0,0,.11816.47217l1.5,2.79883a1.00029,1.00029,0,0,0,1.76368-.94434Z'
  }));
};

UilClockFive.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockFive.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockNine = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6a.99974.99974,0,0,0-1,1v4H9a1,1,0,0,0,0,2h3a.99974.99974,0,0,0,1-1V7A.99974.99974,0,0,0,12,6Zm0-4A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilClockNine.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockNine.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockSeven = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20ZM12,6a.99974.99974,0,0,0-1,1v4.749L9.61816,14.32666a1.00029,1.00029,0,0,0,1.76368.94434l1.5-2.79883A1.00586,1.00586,0,0,0,13,12V7A.99974.99974,0,0,0,12,6Z'
  }));
};

UilClockSeven.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockSeven.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockTen = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6a.99974.99974,0,0,0-1,1v3.26758L9.90234,9.63379a1.00016,1.00016,0,0,0-1,1.73242l2.59766,1.5A1,1,0,0,0,13,12V7A.99974.99974,0,0,0,12,6Zm0-4A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilClockTen.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockTen.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockThree = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,11H13V7a1,1,0,0,0-2,0v5a1,1,0,0,0,1,1h3a1,1,0,0,0,0-2ZM12,2A10,10,0,1,0,22,12,10.01114,10.01114,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilClockThree.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockThree.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClockTwo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10.01114,10.01114,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20ZM14.09814,9.63379,13,10.26807V7a1,1,0,0,0-2,0v5a1.00025,1.00025,0,0,0,1.5.86621l2.59814-1.5a1.00016,1.00016,0,1,0-1-1.73242Z'
  }));
};

UilClockTwo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClockTwo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClosedCaptioning = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.24,13.14a1,1,0,0,0-1.37.36,1,1,0,0,1-1.58.19A.93.93,0,0,1,8,13V11a1,1,0,0,1,1.88-.48,1,1,0,0,0,1.37.34,1,1,0,0,0,.34-1.38,3.08,3.08,0,0,0-.46-.59A3,3,0,0,0,9,8a3,3,0,0,0-3,3v2a3,3,0,0,0,5.59,1.5A1,1,0,0,0,11.24,13.14Zm6,0a1,1,0,0,0-1.37.36,1,1,0,0,1-1.58.19A.93.93,0,0,1,14,13V11a1,1,0,0,1,1.88-.48,1,1,0,0,0,1.37.34,1,1,0,0,0,.34-1.38,3.08,3.08,0,0,0-.46-.59A3,3,0,0,0,15,8a3,3,0,0,0-3,3v2a3,3,0,0,0,5.59,1.5A1,1,0,0,0,17.24,13.14ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilClosedCaptioning.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClosedCaptioning.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClosedCaptioningSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,0,1-8-8A7.92,7.92,0,0,1,5.69,7.1L7.2,8.61A3,3,0,0,0,6,11v2a3,3,0,0,0,5.59,1.5,1,1,0,1,0-1.72-1,1,1,0,0,1-1.58.19A.93.93,0,0,1,8,13V11a1,1,0,0,1,.67-.92L12,13.46A3,3,0,0,0,14.54,16l2.36,2.36A7.92,7.92,0,0,1,12,20Zm6.31-3.1-1.52-1.52a2.94,2.94,0,0,0,.8-.88,1,1,0,1,0-1.72-1,1,1,0,0,1-.55.41L14,12.59V11a1,1,0,0,1,1.88-.48,1,1,0,0,0,1.37.34,1,1,0,0,0,.34-1.38,3.08,3.08,0,0,0-.46-.59A3,3,0,0,0,12,10.62l-.35-.35a1,1,0,0,0-.1-.79,3.08,3.08,0,0,0-.46-.59,2.94,2.94,0,0,0-1.67-.84L7.1,5.69A7.92,7.92,0,0,1,12,4a8,8,0,0,1,8,8A7.92,7.92,0,0,1,18.31,16.9Z'
  }));
};

UilClosedCaptioningSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClosedCaptioningSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloud = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,9.21a7,7,0,0,0-13.36,1.9A4,4,0,0,0,6,19H17a5,5,0,0,0,1.42-9.79ZM17,17H6a2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.66A3,3,0,0,1,17,17Z'
  }));
};

UilCloud.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloud.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudBlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,7.72A7,7,0,0,0,5.06,9.61a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,13.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12.5,5,5,0,0,0,18.42,7.72Zm-9.25,6a4,4,0,1,0,5.66,0A4.1,4.1,0,0,0,9.17,13.67ZM10,16.5a2,2,0,0,1,2-2,2.09,2.09,0,0,1,.51.07L10.07,17A2.09,2.09,0,0,1,10,16.5Zm3.41,1.41a2,2,0,0,1-1.91.5L13.93,16a2.09,2.09,0,0,1,.07.51A2,2,0,0,1,13.41,17.91Z'
  }));
};

UilCloudBlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudBlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudBookmark = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,11H10a1,1,0,0,0-1,1v8a1,1,0,0,0,1.56.83l1.94-1.3,1.89,1.26A1,1,0,0,0,15,21a1,1,0,0,0,.44-.1A1,1,0,0,0,16,20V12A1,1,0,0,0,15,11Zm-1,7.12-.94-.63a1,1,0,0,0-1.12,0l-.94.64V13h3Zm4.42-10.9A7,7,0,0,0,5.06,9.11,4,4,0,0,0,6,17a1,1,0,0,0,0-2,2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12,5,5,0,0,0,18.42,7.22Z'
  }));
};

UilCloudBookmark.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudBookmark.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.29,14.19,11,17.48,9.71,16.19a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l2,2a1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,0-1.41A1,1,0,0,0,14.29,14.19Zm4.13-5.87a7,7,0,0,0-13.36,1.9,4,4,0,0,0-.38,7.65A1,1,0,1,0,5.32,16,2,2,0,0,1,4,14.1a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.6,1,1,0,0,0,.78.66A3,3,0,0,1,17.75,16,1,1,0,0,0,18,18l.25,0a5,5,0,0,0,.17-9.62Z'
  }));
};

UilCloudCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudComputing = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H18a1,1,0,0,1-1-1V16a5,5,0,0,0,1.42-9.78A7,7,0,0,0,5.06,8.11,4,4,0,0,0,6,16H7v3a1,1,0,0,1-1,1H3a1,1,0,0,0,0,2H6a3,3,0,0,0,3-3V16h2v5a1,1,0,0,0,2,0V16h2v3a3,3,0,0,0,3,3h3a1,1,0,0,0,0-2ZM6,14a2,2,0,0,1,0-4A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,11a3,3,0,0,1-3,3Z'
  }));
};

UilCloudComputing.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudComputing.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudDataConnection = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,18.5H14.82A3,3,0,0,0,13,16.68V13.5h3.17A4.33,4.33,0,0,0,17.47,5,6,6,0,0,0,6.06,6.63,3.5,3.5,0,0,0,7,13.5h4v3.18A3,3,0,0,0,9.18,18.5H3a1,1,0,0,0,0,2H9.18a3,3,0,0,0,5.64,0H21a1,1,0,0,0,0-2Zm-14-7a1.5,1.5,0,0,1,0-3,1,1,0,0,0,1-1,4,4,0,0,1,7.79-1.29,1,1,0,0,0,.78.67A2.31,2.31,0,0,1,18.5,9.17a2.34,2.34,0,0,1-2.33,2.33Zm5,9a1,1,0,1,1,1-1A1,1,0,0,1,12,20.5Z'
  }));
};

UilCloudDataConnection.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudDataConnection.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudDatabaseTree = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.5,14.5a2,2,0,0,0-2-2h-6a2,2,0,0,0-2,2h-3v-3h2.33A3.66,3.66,0,0,0,13,4.37,5,5,0,0,0,3.57,5.65,3,3,0,0,0,4.5,11.5h3v8a1,1,0,0,0,1,1h4a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2v-2a2,2,0,0,0-.28-1,2,2,0,0,0,.28-1Zm-18-5a1,1,0,0,1,0-2,1,1,0,0,0,1-1,3,3,0,0,1,5.84-1,1,1,0,0,0,.78.66A1.65,1.65,0,0,1,13.5,7.83,1.67,1.67,0,0,1,11.83,9.5Zm8,9h-3v-2h3a2,2,0,0,0,.28,1A2,2,0,0,0,12.5,18.5Zm2,2v-2h6v2Zm0-4v-2h6v2Z'
  }));
};

UilCloudDatabaseTree.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudDatabaseTree.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.29,17.29,13,18.59V13a1,1,0,0,0-2,0v5.59l-1.29-1.3a1,1,0,0,0-1.42,1.42l3,3a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3a1,1,0,0,0-1.42-1.42ZM18.42,6.22A7,7,0,0,0,5.06,8.11,4,4,0,0,0,6,16a1,1,0,0,0,0-2,2,2,0,0,1,0-4A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,.24,5.84,1,1,0,1,0,.5,1.94,5,5,0,0,0,.17-9.62Z'
  }));
};

UilCloudDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudDrizzle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,19a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V20A1,1,0,0,0,12,19ZM8,11a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V12A1,1,0,0,0,8,11Zm0,5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V17A1,1,0,0,0,8,16Zm4-2a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V15A1,1,0,0,0,12,14Zm6.42-7.78A7,7,0,0,0,5.06,8.11,4,4,0,0,0,2,12a4,4,0,0,0,1.34,3,1,1,0,1,0,1.32-1.5A2,2,0,0,1,4,12a2,2,0,0,1,2-2A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,11a2.91,2.91,0,0,1-.74,2,1,1,0,0,0,1.48,1.34,5,5,0,0,0-2.32-8.08ZM16,11a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V12A1,1,0,0,0,16,11Zm0,5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V17A1,1,0,0,0,16,16ZM12,9a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V10A1,1,0,0,0,12,9Z'
  }));
};

UilCloudDrizzle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudDrizzle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,18.79a1.15,1.15,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1.05,1.05,0,0,0-.29.71,1,1,0,0,0,.29.71,1.15,1.15,0,0,0,.33.21,1,1,0,0,0,1.3-1.3A1,1,0,0,0,12.71,18.79ZM12,12.5a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0v-3A1,1,0,0,0,12,12.5Zm6.42-4.79A7,7,0,0,0,5.06,9.61,4,4,0,0,0,6,17.5H8a1,1,0,0,0,0-2H6a2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.66A3,3,0,0,1,17,15.5H16a1,1,0,0,0,0,2h1a5,5,0,0,0,1.42-9.79Z'
  }));
};

UilCloudExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudHail = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,17a1,1,0,1,0,1,1A1,1,0,0,0,12,17ZM8,11a1,1,0,1,0,1,1A1,1,0,0,0,8,11Zm4,2a1,1,0,1,0,1,1A1,1,0,0,0,12,13ZM8,19a1,1,0,1,0,1,1A1,1,0,0,0,8,19Zm0-4a1,1,0,1,0,1,1A1,1,0,0,0,8,15Zm8,0a1,1,0,1,0,1,1A1,1,0,0,0,16,15ZM12,9a1,1,0,1,0,1,1A1,1,0,0,0,12,9Zm4,2a1,1,0,1,0,1,1A1,1,0,0,0,16,11Zm2.42-4.78A7,7,0,0,0,5.06,8.11,4,4,0,0,0,2,12a4,4,0,0,0,1.34,3,1,1,0,1,0,1.32-1.5A2,2,0,0,1,4,12a2,2,0,0,1,2-2A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,11a2.91,2.91,0,0,1-.74,2,1,1,0,0,0,1.48,1.34,5,5,0,0,0-2.32-8.08ZM16,19a1,1,0,1,0,1,1A1,1,0,0,0,16,19Z'
  }));
};

UilCloudHail.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudHail.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,7.72A7,7,0,0,0,5.06,9.61a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,13.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12.5,5,5,0,0,0,18.42,7.72ZM12,12.83a2.94,2.94,0,0,0-3.43.53,2.93,2.93,0,0,0,0,4.13l2.72,2.72a1,1,0,0,0,1.42,0l2.72-2.72a2.93,2.93,0,0,0,0-4.13A2.94,2.94,0,0,0,12,12.83Zm2,3.24-2,2-2-2a.88.88,0,0,1-.27-.65.89.89,0,0,1,.27-.65.92.92,0,0,1,1.3,0,1,1,0,0,0,1.42,0,.94.94,0,0,1,1.3,0,.89.89,0,0,1,.27.65A.88.88,0,0,1,14,16.07Z'
  }));
};

UilCloudHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,12.29A1,1,0,0,0,12,14l.19,0a.6.6,0,0,0,.19-.06.56.56,0,0,0,.17-.09l.15-.12a1,1,0,0,0,0-1.42A1,1,0,0,0,11.29,12.29ZM12,15a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V16A1,1,0,0,0,12,15Zm6.42-6.78A7,7,0,0,0,5.06,10.11,4,4,0,0,0,6,18H8a1,1,0,0,0,0-2H6a2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,13a3,3,0,0,1-3,3H16a1,1,0,0,0,0,2h1a5,5,0,0,0,1.42-9.78Z'
  }));
};

UilCloudInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,6.72A7,7,0,0,0,5.06,8.61a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,12.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,11.5,5,5,0,0,0,18.42,6.72Zm-3.42,9V14.5a3,3,0,0,0-6,0v1.18a3,3,0,0,0,1,5.82h4a3,3,0,0,0,1-5.82ZM11,14.5a1,1,0,0,1,2,0v1H11Zm3,5H10a1,1,0,0,1,0-2h4a1,1,0,0,1,0,2Z'
  }));
};

UilCloudLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudMeatball = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.5,15.92h-.77l.39-.67a1,1,0,0,0-1.74-1l-.38.67-.38-.67a1,1,0,0,0-1.74,1l.39.67H9.5a1,1,0,0,0,0,2h.77l-.39.66a1,1,0,0,0,1.74,1l.38-.66.38.66a1,1,0,0,0,1.74-1l-.39-.66h.77a1,1,0,0,0,0-2Zm3.92-7.79A7,7,0,0,0,5.06,10,4,4,0,0,0,2,13.92a4,4,0,0,0,3.34,3.93l.16,0a1,1,0,0,0,.16-2,2,2,0,0,1-1.66-2,2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.66,3,3,0,0,1,.62,5.72,1,1,0,1,0,.74,1.85,5,5,0,0,0-.45-9.41Z'
  }));
};

UilCloudMeatball.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudMeatball.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudMoon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.7,9.07a1,1,0,0,0-.93-.26,3.13,3.13,0,0,1-.66.08,3,3,0,0,1-3-3,3.13,3.13,0,0,1,.08-.66,1,1,0,0,0-.26-.93A1,1,0,0,0,16,4a4.93,4.93,0,0,0-3.83,4.21A6.24,6.24,0,0,0,10.5,8a6,6,0,0,0-5.94,5.13A3.5,3.5,0,0,0,5.5,20h9.17A4.33,4.33,0,0,0,19,15.67a4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,10,1,1,0,0,0,21.7,9.07Zm-7,8.93H5.5a1.5,1.5,0,0,1,0-3,1,1,0,0,0,1-1,4,4,0,0,1,6.18-3.34l0,0a3.94,3.94,0,0,1,1.57,2,1,1,0,0,0,.78.67A2.33,2.33,0,0,1,14.67,18Zm2.44-6.11a2.61,2.61,0,0,1-.42,0,4.6,4.6,0,0,0-.72-.31,6.06,6.06,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.23A3,3,0,0,1,17.11,11.89Z'
  }));
};

UilCloudMoon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudMoon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudMoonHail = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.21,16.29a1,1,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1.15,1.15,0,0,0-.21.33A.84.84,0,0,0,7.5,17a1,1,0,0,0,1.38.92,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1.15,1.15,0,0,0,9.21,16.29Zm0,4a1.15,1.15,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1.15,1.15,0,0,0-.21.33,1,1,0,1,0,1.84,0A1.15,1.15,0,0,0,9.21,20.29Zm3.85-6.12-.18-.09L12.7,14a1,1,0,0,0-.58.06.93.93,0,0,0-.33.21,1,1,0,0,0-.29.71,1,1,0,0,0,.29.71,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,13.5,15a1.05,1.05,0,0,0-.29-.71Zm.15,4.12a1,1,0,0,0-1.09-.21.9.9,0,0,0-.54.54,1,1,0,0,0,.21,1.09,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1.15,1.15,0,0,0,13.21,18.29ZM21.7,7.07a1,1,0,0,0-.94-.26,3,3,0,0,1-.65.08,3,3,0,0,1-3-3,3,3,0,0,1,.08-.65A1,1,0,0,0,16,2a4.93,4.93,0,0,0-3.83,4.21A6.24,6.24,0,0,0,10.5,6a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,14.5,1.5,1.5,0,0,1,5.5,13a1,1,0,0,0,1-1,4,4,0,0,1,4-4,4.06,4.06,0,0,1,2.19.66h0a4,4,0,0,1,1.58,2,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,15.61a1,1,0,0,0,1.1,1.68A4.34,4.34,0,0,0,19,13.67a4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,8,1,1,0,0,0,21.7,7.07ZM17.11,9.89a2.72,2.72,0,0,1-.42,0A4.6,4.6,0,0,0,16,9.54a6.06,6.06,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.23A3,3,0,0,1,17.11,9.89Z'
  }));
};

UilCloudMoonHail.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudMoonHail.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudMoonMeatball = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.7,8a1,1,0,0,0-.94-.26,3,3,0,0,1-.65.08,3,3,0,0,1-3-3,3.05,3.05,0,0,1,.08-.66,1,1,0,0,0-.26-.94A1,1,0,0,0,16,2.94a5,5,0,0,0-3.83,4.22,5.86,5.86,0,0,0-1.67-.24A6,6,0,0,0,4.56,12,3.52,3.52,0,0,0,2,15.42a3.47,3.47,0,0,0,1.41,2.79A1,1,0,1,0,4.59,16.6,1.46,1.46,0,0,1,4,15.42a1.5,1.5,0,0,1,1.5-1.5,1,1,0,0,0,1-1,4,4,0,0,1,6.17-3.35l0,0a3.9,3.9,0,0,1,1.57,2,1,1,0,0,0,.78.66,2.33,2.33,0,0,1,.54,4.44,1,1,0,0,0-.52,1.32,1,1,0,0,0,.92.6,1,1,0,0,0,.4-.09,4.33,4.33,0,0,0,2.6-4,4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,8.92,1,1,0,0,0,21.7,8Zm-4.59,2.82a2.72,2.72,0,0,1-.42,0,4.6,4.6,0,0,0-.72-.31,5.91,5.91,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.22A3,3,0,0,1,17.11,10.81ZM12.5,16.92h-.77l.39-.67a1,1,0,0,0-1.74-1l-.38.67-.38-.67a1,1,0,0,0-1.74,1l.39.67H7.5a1,1,0,0,0,0,2h.77l-.39.66a1,1,0,0,0,1.74,1l.38-.66.38.66a1,1,0,1,0,1.74-1l-.39-.66h.77a1,1,0,0,0,0-2Z'
  }));
};

UilCloudMoonMeatball.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudMoonMeatball.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudMoonRain = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,14a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V15A1,1,0,0,0,8.5,14Zm0,5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V20A1,1,0,0,0,8.5,19ZM21.7,7.07a1,1,0,0,0-.94-.26,3,3,0,0,1-.65.08,3,3,0,0,1-3-3,3.13,3.13,0,0,1,.08-.66,1,1,0,0,0-.26-.93A1,1,0,0,0,16,2a4.93,4.93,0,0,0-3.83,4.21A6.24,6.24,0,0,0,10.5,6a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,14.5,1.5,1.5,0,0,1,5.5,13a1,1,0,0,0,1-1,4,4,0,0,1,4-4,3.91,3.91,0,0,1,2.17.66l0,0a3.94,3.94,0,0,1,1.57,2,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,15.61a1,1,0,0,0,1.1,1.68A4.32,4.32,0,0,0,19,13.67a4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,8,1,1,0,0,0,21.7,7.07ZM17.11,9.89a2.72,2.72,0,0,1-.42,0A4.6,4.6,0,0,0,16,9.54a6.06,6.06,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.23A3,3,0,0,1,17.11,9.89ZM12.5,13a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V14A1,1,0,0,0,12.5,13Zm0,5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V19A1,1,0,0,0,12.5,18Z'
  }));
};

UilCloudMoonRain.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudMoonRain.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudMoonShowers = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,14a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V15A1,1,0,0,0,8.5,14Zm4-1a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V14A1,1,0,0,0,12.5,13Zm9.2-5.93a1,1,0,0,0-.94-.26,3,3,0,0,1-.65.08,3,3,0,0,1-3-3,3.13,3.13,0,0,1,.08-.66,1,1,0,0,0-.26-.93A1,1,0,0,0,16,2a4.93,4.93,0,0,0-3.83,4.21A6.24,6.24,0,0,0,10.5,6a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,14.5,1.5,1.5,0,0,1,5.5,13a1,1,0,0,0,1-1,4,4,0,0,1,4-4,3.91,3.91,0,0,1,2.17.66l0,0a3.94,3.94,0,0,1,1.57,2,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,15.61a1,1,0,0,0,1.1,1.68A4.32,4.32,0,0,0,19,13.67a4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,8,1,1,0,0,0,21.7,7.07ZM17.11,9.89a2.72,2.72,0,0,1-.42,0A4.6,4.6,0,0,0,16,9.54a6.06,6.06,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.23A3,3,0,0,1,17.11,9.89Z'
  }));
};

UilCloudMoonShowers.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudMoonShowers.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,8.22A7,7,0,0,0,5.06,10.11,4,4,0,0,0,6,18H8a1,1,0,0,0,0-2H6a2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,13a3,3,0,0,1-3,3,1,1,0,0,0,0,2,5,5,0,0,0,1.42-9.78Zm-5.5,10.4a.56.56,0,0,0-.09-.17l-.12-.16a1.15,1.15,0,0,0-.33-.21,1,1,0,0,0-1.09.21l-.12.16a.56.56,0,0,0-.09.17.64.64,0,0,0-.06.18,1.5,1.5,0,0,0,0,.2,1.23,1.23,0,0,0,0,.19.6.6,0,0,0,.06.19.56.56,0,0,0,.09.17l.12.16A1.05,1.05,0,0,0,12,20a1,1,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21l.12-.16a.56.56,0,0,0,.09-.17.6.6,0,0,0,.06-.19A1.23,1.23,0,0,0,13,19a1.5,1.5,0,0,0,0-.2A.64.64,0,0,0,12.92,18.62ZM12,11a3,3,0,0,0-2.6,1.5,1,1,0,0,0,.37,1.37,1,1,0,0,0,1.36-.37A1,1,0,0,1,12,13a1,1,0,0,1,0,2,1,1,0,0,0,0,2,3,3,0,0,0,0-6Z'
  }));
};

UilCloudQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudRain = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.56,12.67a1,1,0,0,0-1.12,0c-.11.08-2.69,1.86-2.69,4.58a3.25,3.25,0,0,0,6.5,0C15.25,14.5,12.67,12.74,12.56,12.67ZM12,18.5a1.25,1.25,0,0,1-1.25-1.25A3.66,3.66,0,0,1,12,14.8a3.61,3.61,0,0,1,1.25,2.45A1.25,1.25,0,0,1,12,18.5ZM18.42,7.72A7,7,0,0,0,5.06,9.61a4,4,0,0,0,.61,7.87h.08a1,1,0,0,0,1-.92,1,1,0,0,0-.92-1.08A2,2,0,0,1,4,13.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,.43,5.79,1,1,0,0,0,.62,1.9,5,5,0,0,0-.14-9.53Z'
  }));
};

UilCloudRain.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudRain.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudRainSun = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,7h-.8a4.25,4.25,0,0,0-.52-1.27l.56-.56a1,1,0,0,0-1.41-1.41l-.56.56A4.25,4.25,0,0,0,17,3.8V3a1,1,0,0,0-2,0v.8a4.1,4.1,0,0,0-1.26.52l-.57-.56a1,1,0,0,0-1.41,1.41l.56.57c-.09.15-.16.32-.24.48A5.85,5.85,0,0,0,10.5,6a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,14.5,1.5,1.5,0,0,1,5.5,13a1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,15.61a1,1,0,0,0,1.1,1.68A4.34,4.34,0,0,0,19,13.67a4.19,4.19,0,0,0-.3-1.55l.13.12a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-.56-.56A4.25,4.25,0,0,0,20.2,9H21a1,1,0,0,0,0-2ZM17.66,9.65h0a2.09,2.09,0,0,1-.6.42A4.17,4.17,0,0,0,16,9.54a6.12,6.12,0,0,0-2.09-2.49,2.42,2.42,0,0,1,.46-.7h0a2.43,2.43,0,0,1,3.3,0h0a2.37,2.37,0,0,1,0,3.3ZM8.5,14a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V15A1,1,0,0,0,8.5,14Zm4-1a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V14A1,1,0,0,0,12.5,13Z'
  }));
};

UilCloudRainSun.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudRainSun.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudRedo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,12.5a1,1,0,0,0-.91.6,4,4,0,1,0,.55,6.4A1,1,0,1,0,13.32,18a2,2,0,0,1-1.32.5,2,2,0,1,1,1-3.75h-.22a1,1,0,0,0,0,2H15a1,1,0,0,0,1-1V13.5A1,1,0,0,0,15,12.5Zm3.42-4.78A7,7,0,0,0,5.06,9.61a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,13.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12.5,5,5,0,0,0,18.42,7.72Z'
  }));
};

UilCloudRedo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudRedo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudShare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.5,15a2,2,0,1,0-2-2l-1.9.87a2,2,0,0,0-1.1-.33,2,2,0,0,0,0,4,1.88,1.88,0,0,0,.92-.24l2.1,1a2,2,0,1,0,.8-1.84l-1.75-.8,1.91-.88A2,2,0,0,0,14.5,15Zm3.92-7.78A7,7,0,0,0,5.06,9.11a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,13a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12,5,5,0,0,0,18.42,7.22Z'
  }));
};

UilCloudShare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudShare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudShield = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,7.22A7,7,0,0,0,5.06,9.11a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,13a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,12,5,5,0,0,0,18.42,7.22Zm-3.63,4.44a2.73,2.73,0,0,1-2.2-.47,1,1,0,0,0-1.18,0,2.72,2.72,0,0,1-2.2.47,1,1,0,0,0-.84.2,1,1,0,0,0-.37.77V16a4.63,4.63,0,0,0,1.84,3.7l1.57,1.15a1,1,0,0,0,1.18,0l1.57-1.16A4.6,4.6,0,0,0,16,16V12.63a1,1,0,0,0-.37-.77A1,1,0,0,0,14.79,11.66ZM14,16A2.62,2.62,0,0,1,13,18l-1,.72L11,18A2.62,2.62,0,0,1,10,16V13.72a4.68,4.68,0,0,0,2-.55,4.68,4.68,0,0,0,2,.55Z'
  }));
};

UilCloudShield.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudShield.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudShowers = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,11a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V12A1,1,0,0,0,8,11Zm4,6a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V18A1,1,0,0,0,12,17ZM8,17a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V18A1,1,0,0,0,8,17ZM18.42,6.22A7,7,0,0,0,5.06,8.11,4,4,0,0,0,2,12a4,4,0,0,0,1.34,3,1,1,0,1,0,1.32-1.5A2,2,0,0,1,4,12a2,2,0,0,1,2-2A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,11a2.91,2.91,0,0,1-.74,2,1,1,0,0,0,1.48,1.34,5,5,0,0,0-2.32-8.08ZM12,11a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V12A1,1,0,0,0,12,11Zm4,0a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V12A1,1,0,0,0,16,11Zm0,6a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V18A1,1,0,0,0,16,17Z'
  }));
};

UilCloudShowers.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudShowers.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudShowersAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,13a1,1,0,0,0-1,1v5a1,1,0,0,0,2,0V14A1,1,0,0,0,8,13Zm4-2a1,1,0,0,0-1,1v9a1,1,0,0,0,2,0V12A1,1,0,0,0,12,11Zm6.42-4.78A7,7,0,0,0,5.06,8.11,4,4,0,0,0,2,12a4,4,0,0,0,1.34,3,1,1,0,1,0,1.32-1.5A2,2,0,0,1,4,12a2,2,0,0,1,2-2A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,11a2.91,2.91,0,0,1-.74,2,1,1,0,0,0,1.48,1.34,5,5,0,0,0-2.32-8.08ZM16,13a1,1,0,0,0-1,1v5a1,1,0,0,0,2,0V14A1,1,0,0,0,16,13Z'
  }));
};

UilCloudShowersAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudShowersAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudShowersHeavy = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.89,18.06a1,1,0,0,0-1.28.6l-.73,2a1,1,0,0,0,.6,1.28,1,1,0,0,0,.34.06,1,1,0,0,0,.94-.66l.73-2A1,1,0,0,0,12.89,18.06Zm-4,0a1,1,0,0,0-1.28.6l-.73,2a1,1,0,0,0,.6,1.28,1,1,0,0,0,.34.06,1,1,0,0,0,.94-.66l.73-2A1,1,0,0,0,8.89,18.06Zm0-7a1,1,0,0,0-1.28.6l-1.1,3A1,1,0,0,0,7.45,16a1,1,0,0,0,.94-.66l1.1-3A1,1,0,0,0,8.89,11.06Zm4,0a1,1,0,0,0-1.28.6l-1.1,3A1,1,0,0,0,11.45,16a1,1,0,0,0,.94-.66l1.1-3A1,1,0,0,0,12.89,11.06Zm5.53-4.84A7,7,0,0,0,5.06,8.11,4,4,0,0,0,2,12a4,4,0,0,0,1.34,3,1,1,0,1,0,1.32-1.5A2,2,0,0,1,4,12a2,2,0,0,1,2-2A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67A3,3,0,0,1,20,11a2.91,2.91,0,0,1-.74,2,1,1,0,0,0,1.48,1.34,5,5,0,0,0-2.32-8.08ZM16.89,18.06a1,1,0,0,0-1.28.6l-.73,2a1,1,0,0,0,.6,1.28,1,1,0,0,0,.34.06,1,1,0,0,0,.94-.66l.73-2A1,1,0,0,0,16.89,18.06Zm0-7a1,1,0,0,0-1.28.6l-1.1,3A1,1,0,0,0,15.45,16a1,1,0,0,0,.94-.66l1.1-3A1,1,0,0,0,16.89,11.06Z'
  }));
};

UilCloudShowersHeavy.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudShowersHeavy.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16.71,16.29h0l-13-13A1,1,0,0,0,2.29,4.71L5.65,8.06a7,7,0,0,0-.59,2A4,4,0,0,0,6,18h9.59l2.7,2.71a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM6,16a2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,.2-1.39L13.59,16ZM18.42,8.22A7,7,0,0,0,12,4a6.74,6.74,0,0,0-2.32.4,1,1,0,0,0,.66,1.88A4.91,4.91,0,0,1,12,6a5,5,0,0,1,4.73,3.39,1,1,0,0,0,.78.67,3,3,0,0,1,1.85,4.79,1,1,0,0,0,.16,1.4,1,1,0,0,0,.62.22,1,1,0,0,0,.78-.38,5,5,0,0,0-2.5-7.87Z'
  }));
};

UilCloudSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSun = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,9h-.8a4.25,4.25,0,0,0-.52-1.27l.56-.56a1,1,0,0,0-1.41-1.41l-.56.56A4.25,4.25,0,0,0,17,5.8V5a1,1,0,0,0-2,0v.8a4.1,4.1,0,0,0-1.26.52l-.57-.56a1,1,0,0,0-1.41,1.41l.56.57c-.09.15-.16.32-.24.48A5.85,5.85,0,0,0,10.5,8a6,6,0,0,0-5.94,5.13A3.5,3.5,0,0,0,5.5,20h9.17A4.33,4.33,0,0,0,19,15.67a4.19,4.19,0,0,0-.3-1.55l.13.12a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-.56-.56A4.25,4.25,0,0,0,20.2,11H21a1,1,0,0,0,0-2Zm-6.33,9H5.5a1.5,1.5,0,0,1,0-3,1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.33,2.33,0,0,1,14.67,18Zm3-6.35h0a2.17,2.17,0,0,1-.6.4A4.49,4.49,0,0,0,16,11.54a6.12,6.12,0,0,0-2.09-2.49,2.25,2.25,0,0,1,.46-.69h0a2.42,2.42,0,0,1,3.29,0h0a2.37,2.37,0,0,1,0,3.3Z'
  }));
};

UilCloudSun.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSun.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSunHail = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.21,20.29a1,1,0,0,0-1.09-.21.93.93,0,0,0-.33.21,1.15,1.15,0,0,0-.21.33.94.94,0,0,0,0,.76.9.9,0,0,0,.54.54.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,9.5,21a.84.84,0,0,0-.08-.38A1.15,1.15,0,0,0,9.21,20.29Zm4-2a.93.93,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1.15,1.15,0,0,0-.21.33,1,1,0,0,0,1.3,1.3,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1.15,1.15,0,0,0,13.21,18.29Zm-4-2a1,1,0,0,0-1.09-.21,1,1,0,0,0-.33.21,1.15,1.15,0,0,0-.21.33,1,1,0,0,0,.21,1.09,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,9.5,17a.84.84,0,0,0-.08-.38A1.15,1.15,0,0,0,9.21,16.29Zm2.91-2.21a1,1,0,0,0-.33.21,1.05,1.05,0,0,0-.29.71,1,1,0,0,0,.29.71,1.15,1.15,0,0,0,.33.21.84.84,0,0,0,.38.08,1,1,0,0,0,1-1,1.05,1.05,0,0,0-.29-.71A1,1,0,0,0,12.12,14.08ZM21,7h-.8a4.25,4.25,0,0,0-.52-1.27l.56-.56a1,1,0,0,0-1.41-1.41l-.56.56A4.25,4.25,0,0,0,17,3.8V3a1,1,0,0,0-2,0v.8a4.1,4.1,0,0,0-1.26.52l-.57-.56a1,1,0,0,0-1.41,1.41l.56.57c-.09.15-.16.32-.24.48A5.85,5.85,0,0,0,10.5,6a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,14.5,1.5,1.5,0,0,1,5.5,13a1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,15.61a1,1,0,0,0,1.1,1.68A4.34,4.34,0,0,0,19,13.67a4.19,4.19,0,0,0-.3-1.55l.13.12a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-.56-.56A4.25,4.25,0,0,0,20.2,9H21a1,1,0,0,0,0-2ZM17.66,9.65h0a2.09,2.09,0,0,1-.6.42A4.17,4.17,0,0,0,16,9.54a6.12,6.12,0,0,0-2.09-2.49,2.42,2.42,0,0,1,.46-.7h0a2.43,2.43,0,0,1,3.3,0h0a2.37,2.37,0,0,1,0,3.3Z'
  }));
};

UilCloudSunHail.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSunHail.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSunMeatball = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.5,16.92h-.77l.39-.67a1,1,0,0,0-1.74-1l-.38.67-.38-.67a1,1,0,0,0-1.74,1l.39.67H7.5a1,1,0,0,0,0,2h.77l-.39.66a1,1,0,0,0,1.74,1l.38-.66.38.66a1,1,0,1,0,1.74-1l-.39-.66h.77a1,1,0,0,0,0-2Zm8.5-9h-.8a4.25,4.25,0,0,0-.52-1.27l.56-.56a1,1,0,0,0-1.41-1.41l-.56.56A4.25,4.25,0,0,0,17,4.72v-.8a1,1,0,0,0-2,0v.8a4.1,4.1,0,0,0-1.26.52l-.57-.56a1,1,0,0,0-1.41,1.41l.56.56c-.09.16-.16.33-.24.49a5.85,5.85,0,0,0-1.58-.22A6,6,0,0,0,4.56,12,3.52,3.52,0,0,0,2,15.42a3.47,3.47,0,0,0,1.41,2.79A1,1,0,1,0,4.59,16.6,1.46,1.46,0,0,1,4,15.42a1.5,1.5,0,0,1,1.5-1.5,1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.66,2.33,2.33,0,0,1,.54,4.44,1,1,0,0,0-.52,1.32,1,1,0,0,0,.92.6.93.93,0,0,0,.4-.09,4.33,4.33,0,0,0,2.6-4A4.29,4.29,0,0,0,18.7,13l.13.13a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42l-.56-.56a4.2,4.2,0,0,0,.52-1.26H21a1,1,0,0,0,0-2Zm-3.34,2.64h0a1.89,1.89,0,0,1-.6.41A4.15,4.15,0,0,0,16,10.46,6,6,0,0,0,13.88,8a2.18,2.18,0,0,1,.46-.7h0a2.42,2.42,0,0,1,3.3,0h0a2.34,2.34,0,0,1,0,3.29Z'
  }));
};

UilCloudSunMeatball.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSunMeatball.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSunRain = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.5,15a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V16A1,1,0,0,0,7.5,15ZM22,7H20.9a5.22,5.22,0,0,0-.73-1.76L21,4.47a1,1,0,1,0-1.42-1.42l-.77.78A5,5,0,0,0,17,3.1V2a1,1,0,0,0-2,0V3.1a5.22,5.22,0,0,0-1.76.73l-.77-.78a1,1,0,0,0-1.42,1.42l.78.77a5.06,5.06,0,0,0-.77,2A5.76,5.76,0,0,0,9.5,7a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,3,15.5,1.5,1.5,0,0,1,4.5,14a1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,15,16.61a1,1,0,0,0,1.1,1.68A4.34,4.34,0,0,0,18,14.67a4.41,4.41,0,0,0-.45-1.92,5.17,5.17,0,0,0,1.21-.58l.77.78A1,1,0,0,0,21,13a1,1,0,0,0,0-1.42l-.78-.77A5,5,0,0,0,20.9,9H22a1,1,0,0,0,0-2Zm-3.87,3.12A3,3,0,0,1,16,11h-.06a4.12,4.12,0,0,0-1-.46,5.93,5.93,0,0,0-2-2.38c0-.06,0-.1,0-.16a3,3,0,0,1,.87-2.12,3.1,3.1,0,0,1,4.25,0,3,3,0,0,1,0,4.25ZM7.5,20a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V21A1,1,0,0,0,7.5,20Zm4-1a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V20A1,1,0,0,0,11.5,19Zm0-5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V15A1,1,0,0,0,11.5,14Z'
  }));
};

UilCloudSunRain.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSunRain.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSunRainAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,19a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V20A1,1,0,0,0,8.5,19Zm0-5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V15A1,1,0,0,0,8.5,14ZM21,7h-.8a4.25,4.25,0,0,0-.52-1.27l.56-.56a1,1,0,0,0-1.41-1.41l-.56.56A4.25,4.25,0,0,0,17,3.8V3a1,1,0,0,0-2,0v.8a4.1,4.1,0,0,0-1.26.52l-.57-.56a1,1,0,0,0-1.41,1.41l.56.57c-.09.15-.16.32-.24.48A5.85,5.85,0,0,0,10.5,6a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,14.5,1.5,1.5,0,0,1,5.5,13a1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,15.61a1,1,0,0,0,1.1,1.68A4.34,4.34,0,0,0,19,13.67a4.19,4.19,0,0,0-.3-1.55l.13.12a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-.56-.56A4.25,4.25,0,0,0,20.2,9H21a1,1,0,0,0,0-2ZM17.66,9.65h0a2.09,2.09,0,0,1-.6.42A4.17,4.17,0,0,0,16,9.54a6.12,6.12,0,0,0-2.09-2.49,2.42,2.42,0,0,1,.46-.7h0a2.43,2.43,0,0,1,3.3,0h0a2.37,2.37,0,0,1,0,3.3ZM12.5,18a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V19A1,1,0,0,0,12.5,18Zm0-5a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V14A1,1,0,0,0,12.5,13Z'
  }));
};

UilCloudSunRainAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSunRainAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudSunTear = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.05,14.33a1,1,0,0,0-1.11,0C9.84,14.41,7.5,16,7.5,18.5a3,3,0,0,0,6,0C13.5,16,11.16,14.4,11.05,14.33ZM10.5,19.5a1,1,0,0,1-1-1,3,3,0,0,1,1-2,3,3,0,0,1,1,2A1,1,0,0,1,10.5,19.5ZM21,7.5h-.8a4.25,4.25,0,0,0-.52-1.27l.56-.56a1,1,0,0,0-1.41-1.41l-.56.56A4.25,4.25,0,0,0,17,4.3V3.5a1,1,0,0,0-2,0v.8a4.1,4.1,0,0,0-1.26.52l-.57-.56a1,1,0,0,0-1.41,1.41l.56.57c-.09.15-.16.32-.24.48A5.85,5.85,0,0,0,10.5,6.5a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,15a1.5,1.5,0,0,1,1.5-1.5,1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,16.11a1,1,0,0,0,1.1,1.68,4.3,4.3,0,0,0,1.65-5.18l.13.13a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41l-.56-.56A4.25,4.25,0,0,0,20.2,9.5H21a1,1,0,0,0,0-2Zm-3.34,2.65h0a2.45,2.45,0,0,1-.6.41A4.17,4.17,0,0,0,16,10a6.12,6.12,0,0,0-2.09-2.49,2.25,2.25,0,0,1,.46-.69h0a2.42,2.42,0,0,1,3.29,0h0a2.37,2.37,0,0,1,0,3.3Z'
  }));
};

UilCloudSunTear.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudSunTear.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,8.22A7,7,0,0,0,5.06,10.11,4,4,0,0,0,6,18a1,1,0,0,0,0-2,2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,.24,5.84,1,1,0,0,0,.5,1.94,5,5,0,0,0,.17-9.62Zm-3.71,6.07a1,1,0,0,0-1.42,0L12,15.59l-1.29-1.3a1,1,0,0,0-1.42,1.42L10.59,17l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L12,18.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L13.41,17l1.3-1.29A1,1,0,0,0,14.71,14.29Z'
  }));
};

UilCloudTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudUnlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,15.5H11v-1A1,1,0,0,1,12.88,14a1,1,0,0,0,1.37.34A1,1,0,0,0,14.59,13a3.08,3.08,0,0,0-.46-.59A3,3,0,0,0,12,11.5a3,3,0,0,0-3,3v1.18a3,3,0,0,0,1,5.82h4a3,3,0,0,0,0-6Zm0,4H10a1,1,0,0,1,0-2h4a1,1,0,0,1,0,2ZM18.42,6.72A7,7,0,0,0,5.06,8.61a4,4,0,0,0-.38,7.66,1.13,1.13,0,0,0,.32.05,1,1,0,0,0,.32-2A2,2,0,0,1,4,12.5a2,2,0,0,1,2-2,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,1,5.53,1,1,0,1,0,1,1.74A5,5,0,0,0,22,11.5,5,5,0,0,0,18.42,6.72Z'
  }));
};

UilCloudUnlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudUnlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.42,8.22A7,7,0,0,0,5.06,10.11,4,4,0,0,0,6,18a1,1,0,0,0,0-2,2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,.24,5.84,1,1,0,0,0,.5,1.94,5,5,0,0,0,.17-9.62Zm-5.71,2.07a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3a1,1,0,0,0,1.42,1.42L11,13.41V19a1,1,0,0,0,2,0V13.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z'
  }));
};

UilCloudUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudWifi = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,5.94a7.1,7.1,0,0,1,7,0,1,1,0,0,0,1.37-.37,1,1,0,0,0-.37-1.36,9.14,9.14,0,0,0-9,0,1,1,0,0,0-.37,1.36A1,1,0,0,0,8.5,5.94Zm9.92,5.27a5.91,5.91,0,0,0-.36-.71,1,1,0,0,0-1.38-.33,1,1,0,0,0-.33,1.37,4.58,4.58,0,0,1,.38.84,1,1,0,0,0,.78.67A3,3,0,0,1,20,16a3,3,0,0,1-3,3L5.66,19A2,2,0,0,1,4,17.4,2,2,0,0,1,6,15a1,1,0,0,0,1-1,4.92,4.92,0,0,1,.67-2.49,1,1,0,0,0-.37-1.37,1,1,0,0,0-1.36.37,6.75,6.75,0,0,0-.88,2.6,4,4,0,0,0-2.13,1.33A4,4,0,0,0,5.46,21h.13L17,21a5,5,0,0,0,1.42-9.79ZM14.87,9s0,0,0-.06A.92.92,0,0,0,15,8.74a1,1,0,0,0-.57-1.29,6.36,6.36,0,0,0-1.74-.38c-.1,0-.2,0-.3,0a5.47,5.47,0,0,0-.81,0,3,3,0,0,0-.31,0,6.36,6.36,0,0,0-1.74.38A1,1,0,0,0,9,8.74a1.22,1.22,0,0,0,.12.19.61.61,0,0,0,0,.11,1,1,0,0,0,1.37.36,3.08,3.08,0,0,1,3,0A1,1,0,0,0,14.87,9ZM11,12a1,1,0,1,0,1-1A1,1,0,0,0,11,12Z'
  }));
};

UilCloudWifi.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudWifi.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCloudWind = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,18a1,1,0,1,0,1,1A1,1,0,0,0,5,18Zm14-4H12a1,1,0,0,0,0,2h7a1,1,0,0,1,0,2,1,1,0,0,0,0,2,3,3,0,0,0,0-6Zm-5-3a1,1,0,0,0,1,1h4a3,3,0,0,0,3-3,1,1,0,0,0-2,0,1,1,0,0,1-1,1H15A1,1,0,0,0,14,11Zm-4,4a1,1,0,0,0-1-1H6a2,2,0,0,1,0-4A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,1,0,1.9-.64A7,7,0,0,0,5.06,8.11,4,4,0,0,0,6,16H9A1,1,0,0,0,10,15Zm0-4a1,1,0,1,0,1-1A1,1,0,0,0,10,11Zm4,7H9a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1,1,1,0,0,0,2,0A3,3,0,0,0,14,18Z'
  }));
};

UilCloudWind.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCloudWind.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClouds = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.47,10.54A6,6,0,0,0,14,7a5.82,5.82,0,0,0-1.39.18,5,5,0,0,0-9,2A3,3,0,0,0,4.5,15h1a4,4,0,0,0,0,.5A3.5,3.5,0,0,0,9,19h9.17a4.33,4.33,0,0,0,1.3-8.46ZM4.5,13a1,1,0,0,1,0-2,1,1,0,0,0,1-1,3,3,0,0,1,3-3,3,3,0,0,1,2.22,1,6,6,0,0,0-2.66,4.13,3.49,3.49,0,0,0-1.5.87Zm13.67,4H9a1.5,1.5,0,0,1,0-3,1,1,0,0,0,1-1,4,4,0,0,1,7.78-1.29,1,1,0,0,0,.78.67A2.33,2.33,0,0,1,18.17,17Z'
  }));
};

UilClouds.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClouds.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilClub = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,12.5a5.52,5.52,0,0,0-3.51-5.12,5.49,5.49,0,0,0-11,0A5.5,5.5,0,0,0,8.5,18l.2,0a6.91,6.91,0,0,1-1.24,2.39A1,1,0,0,0,8.24,22h7.52a1,1,0,0,0,.78-1.63A6.91,6.91,0,0,1,15.3,18l.2,0A5.51,5.51,0,0,0,21,12.5ZM10.06,20a8.89,8.89,0,0,0,.81-2.56,5.47,5.47,0,0,0,1.13-.7,5.47,5.47,0,0,0,1.13.7A8.89,8.89,0,0,0,13.94,20Zm2.72-5.3-.08-.08-.08-.08-.07,0-.18-.09-.18-.06h-.38l-.18.06a.56.56,0,0,0-.17.09l-.08,0-.08.08-.08.08A3.5,3.5,0,1,1,7.75,9.08,1.11,1.11,0,0,0,7.91,9a1.42,1.42,0,0,0,.18-.08.83.83,0,0,0,.14-.13.62.62,0,0,0,.21-.31.61.61,0,0,0,.07-.17.69.69,0,0,0,0-.2,1,1,0,0,0,0-.17,3.4,3.4,0,0,1,0-.45,3.5,3.5,0,0,1,7,0,3.4,3.4,0,0,1,0,.45.81.81,0,0,0,0,.16.74.74,0,0,0,0,.21.61.61,0,0,0,.07.17.62.62,0,0,0,.21.31.83.83,0,0,0,.14.13,1.42,1.42,0,0,0,.18.08,1.11,1.11,0,0,0,.16.07,3.5,3.5,0,1,1-3.47,5.62Z'
  }));
};

UilClub.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilClub.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCodeBranch = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,6.06a3,3,0,0,0-1.15,5.77A2,2,0,0,1,14,13.06H10a3.91,3.91,0,0,0-2,.56V7.88a3,3,0,1,0-2,0v8.36a3,3,0,1,0,2.16.05A2,2,0,0,1,10,15.06h4a4,4,0,0,0,3.91-3.16A3,3,0,0,0,17,6.06Zm-10-2a1,1,0,1,1-1,1A1,1,0,0,1,7,4.06Zm0,16a1,1,0,1,1,1-1A1,1,0,0,1,7,20.06Zm10-10a1,1,0,1,1,1-1A1,1,0,0,1,17,10.06Z'
  }));
};

UilCodeBranch.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCodeBranch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCoffee = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,17h4a5,5,0,0,0,5-5V11h1a3,3,0,0,0,0-6H18V4a1,1,0,0,0-1-1H5A1,1,0,0,0,4,4v8A5,5,0,0,0,9,17ZM18,7h1a1,1,0,0,1,0,2H18ZM6,5H16v7a3,3,0,0,1-3,3H9a3,3,0,0,1-3-3ZM21,19H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilCoffee.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCoffee.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCog = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.32,9.55l-1.89-.63.89-1.78A1,1,0,0,0,20.13,6L18,3.87a1,1,0,0,0-1.15-.19l-1.78.89-.63-1.89A1,1,0,0,0,13.5,2h-3a1,1,0,0,0-.95.68L8.92,4.57,7.14,3.68A1,1,0,0,0,6,3.87L3.87,6a1,1,0,0,0-.19,1.15l.89,1.78-1.89.63A1,1,0,0,0,2,10.5v3a1,1,0,0,0,.68.95l1.89.63-.89,1.78A1,1,0,0,0,3.87,18L6,20.13a1,1,0,0,0,1.15.19l1.78-.89.63,1.89a1,1,0,0,0,.95.68h3a1,1,0,0,0,.95-.68l.63-1.89,1.78.89A1,1,0,0,0,18,20.13L20.13,18a1,1,0,0,0,.19-1.15l-.89-1.78,1.89-.63A1,1,0,0,0,22,13.5v-3A1,1,0,0,0,21.32,9.55ZM20,12.78l-1.2.4A2,2,0,0,0,17.64,16l.57,1.14-1.1,1.1L16,17.64a2,2,0,0,0-2.79,1.16l-.4,1.2H11.22l-.4-1.2A2,2,0,0,0,8,17.64l-1.14.57-1.1-1.1L6.36,16A2,2,0,0,0,5.2,13.18L4,12.78V11.22l1.2-.4A2,2,0,0,0,6.36,8L5.79,6.89l1.1-1.1L8,6.36A2,2,0,0,0,10.82,5.2l.4-1.2h1.56l.4,1.2A2,2,0,0,0,16,6.36l1.14-.57,1.1,1.1L17.64,8a2,2,0,0,0,1.16,2.79l1.2.4ZM12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14Z'
  }));
};

UilCog.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCog.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCoins = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.22,12A3,3,0,0,0,22,10a3,3,0,0,0-3-3H13.82A3,3,0,0,0,11,3H5A3,3,0,0,0,2,6a3,3,0,0,0,.78,2,3,3,0,0,0,0,4,3,3,0,0,0,0,4A3,3,0,0,0,2,18a3,3,0,0,0,3,3H19a3,3,0,0,0,2.22-5,3,3,0,0,0,0-4ZM11,19H5a1,1,0,0,1,0-2h6a1,1,0,0,1,0,2Zm0-4H5a1,1,0,0,1,0-2h6a1,1,0,0,1,0,2Zm0-4H5A1,1,0,0,1,5,9h6a1,1,0,0,1,0,2Zm0-4H5A1,1,0,0,1,5,5h6a1,1,0,0,1,0,2Zm8.69,11.71A.93.93,0,0,1,19,19H13.82a2.87,2.87,0,0,0,0-2H19a1,1,0,0,1,1,1A1,1,0,0,1,19.69,18.71Zm0-4A.93.93,0,0,1,19,15H13.82a2.87,2.87,0,0,0,0-2H19a1,1,0,0,1,1,1A1,1,0,0,1,19.69,14.71Zm0-4A.93.93,0,0,1,19,11H13.82a2.87,2.87,0,0,0,0-2H19a1,1,0,0,1,1,1A1,1,0,0,1,19.69,10.71Z'
  }));
};

UilCoins.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCoins.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilColumns = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM11,20H4V4h7Zm9,0H13V4h7Z'
  }));
};

UilColumns.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilColumns.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilComment = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Z'
  }));
};

UilComment.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilComment.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,8A1,1,0,0,0,7,8V7H8A1,1,0,0,0,8,5H7V4A1,1,0,0,0,5,4V5H4A1,1,0,0,0,4,7H5ZM18,5H12a1,1,0,0,0,0,2h6a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H8a1,1,0,0,1-1-1V12a1,1,0,0,0-2,0v3a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,20,21a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,21,20V8A3,3,0,0,0,18,5Z'
  }));
};

UilCommentAdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltBlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6H15a1,1,0,0,0,0,2h4a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,21,22a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,22,21V9A3,3,0,0,0,19,6Zm-8.46,4.54A5,5,0,1,0,7,12,5,5,0,0,0,10.54,10.54ZM4,7A3,3,0,0,1,7,4a3,3,0,0,1,1.28.3l-4,4A3,3,0,0,1,4,7ZM9.7,5.71A3,3,0,0,1,10,7,3,3,0,0,1,5.72,9.7Z'
  }));
};

UilCommentAltBlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltBlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltChartLines = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,8a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V9A1,1,0,0,0,12,8ZM8,11a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V12A1,1,0,0,0,8,11ZM19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1ZM16,6a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V7A1,1,0,0,0,16,6Z'
  }));
};

UilCommentAltChartLines.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltChartLines.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.77,9.15l5.44-5.44a1,1,0,1,0-1.42-1.42L6.06,7,4.21,5.17A1,1,0,0,0,2.79,6.59L5.35,9.15a1,1,0,0,0,1.42,0ZM18.5,6H13a1,1,0,0,0,0,2h5.5a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H8.5a1,1,0,0,1-1-1V12.5a1,1,0,0,0-2,0V16a3,3,0,0,0,3,3h8.36l3,2.73a1,1,0,0,0,.68.27,1.1,1.1,0,0,0,.4-.08,1,1,0,0,0,.6-.92V9A3,3,0,0,0,18.5,6Z'
  }));
};

UilCommentAltCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltDots = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,9a1,1,0,1,0,1,1A1,1,0,0,0,12,9Zm7-7H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1ZM8,9a1,1,0,1,0,1,1A1,1,0,0,0,8,9Zm8,0a1,1,0,1,0,1,1A1,1,0,0,0,16,9Z'
  }));
};

UilCommentAltDots.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltDots.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.12,11.92a.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3A1,1,0,1,0,8.79,7.29L7.5,8.59V3a1,1,0,0,0-2,0V8.59L4.21,7.29A1,1,0,1,0,2.79,8.71l3,3A1,1,0,0,0,6.12,11.92ZM18.5,6h-5a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H8.5a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73a1,1,0,0,0,.68.27,1.1,1.1,0,0,0,.4-.08,1,1,0,0,0,.6-.92V9A3,3,0,0,0,18.5,6Z'
  }));
};

UilCommentAltDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.5,5.5h-4a1,1,0,0,0,0,2h4a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H8.5a1,1,0,0,1-1-1v-1a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73a1,1,0,0,0,.68.27,1.1,1.1,0,0,0,.4-.08,1,1,0,0,0,.6-.92V8.5A3,3,0,0,0,18.5,5.5Zm-9.42,7H11.5a1,1,0,0,0,1-1V9.08a1,1,0,0,0-.29-.71L6.63,2.79a1,1,0,0,0-1.41,0L2.79,5.22a1,1,0,0,0,0,1.41l5.58,5.58A1,1,0,0,0,9.08,12.5ZM5.92,4.91,10.5,9.49v1h-1L4.91,5.92Z'
  }));
};

UilCommentAltEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1ZM12,12a1,1,0,1,0,1,1A1,1,0,0,0,12,12Zm0-6a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V7A1,1,0,0,0,12,6Z'
  }));
};

UilCommentAltExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6.35a3.07,3.07,0,0,0-3.54.53,3,3,0,0,0,0,4.24L11.29,14a1,1,0,0,0,1.42,0l2.83-2.83a3,3,0,0,0,0-4.24A3.07,3.07,0,0,0,12,6.35Zm2.12,3.36L12,11.83,9.88,9.71a1,1,0,0,1,0-1.42,1,1,0,0,1,1.41,0,1,1,0,0,0,1.42,0,1,1,0,0,1,1.41,0A1,1,0,0,1,14.12,9.71ZM19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltImage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2ZM5.77,16H5a1,1,0,0,1-1-1v-.42l3.3-3.29a1,1,0,0,1,1.41,0l.87.87ZM20,18.59l-2.29-2.3A1,1,0,0,0,17,16H8.59L15.3,9.29a1,1,0,0,1,1.4,0L20,12.58Zm0-8.83L18.12,7.89a3,3,0,0,0-4.24,0L11,10.76l-.88-.87a3.06,3.06,0,0,0-4.24,0L4,11.76V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltImage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltImage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,11a1,1,0,0,0,1-1V6A1,1,0,0,0,4,6v4A1,1,0,0,0,5,11ZM4.29,3.71a1,1,0,0,0,1.09.21,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33A.84.84,0,0,0,6,3a1,1,0,0,0-.29-.71,1,1,0,0,0-1.09-.21,1,1,0,0,0-.33.21A1,1,0,0,0,4,3a1,1,0,0,0,.08.38A1.15,1.15,0,0,0,4.29,3.71ZM17,6H9A1,1,0,0,0,9,8h8a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H7a1,1,0,0,1-1-1V14a1,1,0,0,0-2,0v2a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,19,22a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,20,21V9A3,3,0,0,0,17,6Z'
  }));
};

UilCommentAltInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltLines = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,11H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm4-4H7A1,1,0,0,0,7,9H17a1,1,0,0,0,0-2Zm2-5H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltLines.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltLines.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,10V8a3,3,0,0,0-2-2.82V4A3,3,0,0,0,4,4V5.18A3,3,0,0,0,2,8v2a3,3,0,0,0,3,3H9A3,3,0,0,0,12,10ZM6,4A1,1,0,0,1,8,4V5H6ZM4,10V8A1,1,0,0,1,5,7H9a1,1,0,0,1,1,1v2a1,1,0,0,1-1,1H5A1,1,0,0,1,4,10ZM19,7H15a1,1,0,0,0,0,2h4a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9a1,1,0,0,1-1-1V16a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,21,23a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,22,22V10A3,3,0,0,0,19,7Z'
  }));
};

UilCommentAltLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,9H13V8a1,1,0,0,0-2,0V9H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V11h1a1,1,0,0,0,0-2Zm5-7H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltMessage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,7H7A1,1,0,0,0,7,9H17a1,1,0,0,0,0-2Zm0,4H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Zm2-9H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltMessage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltMessage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltNotes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,7A1,1,0,1,0,8,8,1,1,0,0,0,7,7Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,7,11Zm10,0H11a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0-4H11a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm2-5H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltNotes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltNotes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,9H13V7a1,1,0,0,0-2,0V9H9a1,1,0,0,0,0,2h2v2a1,1,0,0,0,2,0V11h2a1,1,0,0,0,0-2Zm4-7H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.29,10.3a1,1,0,0,0,1.09,1.63,1.19,1.19,0,0,0,.33-.22,1,1,0,0,0,.21-.32A.85.85,0,0,0,8,11a1,1,0,0,0-.29-.7A1,1,0,0,0,6.29,10.3ZM7,5A1,1,0,0,1,7,7,1,1,0,0,0,7,9,3,3,0,1,0,4.4,4.5a1,1,0,0,0,.37,1.37A1,1,0,0,0,6.13,5.5,1,1,0,0,1,7,5ZM19,6H13a1,1,0,0,0,0,2h6a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,21,22a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,22,21V9A3,3,0,0,0,19,6Z'
  }));
};

UilCommentAltQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltRedo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.3,10.75A1,1,0,1,0,9,9.25,3,3,0,1,1,7,4,3,3,0,0,1,9.23,5H8A1,1,0,0,0,8,7h3a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0h0a5,5,0,1,0,.3,7.75ZM19,6H15a1,1,0,0,0,0,2h4a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,21,22a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,22,21V9A3,3,0,0,0,19,6Z'
  }));
};

UilCommentAltRedo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltRedo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltSearch = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6H14a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9a1,1,0,0,1-1-1V14a1,1,0,0,0-2,0v2a3,3,0,0,0,3,3h8.36l3,2.73A1,1,0,0,0,21,22a1.1,1.1,0,0,0,.4-.08A1,1,0,0,0,22,21V9A3,3,0,0,0,19,6ZM8.57,10l1.72,1.73a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L10,8.57a4.37,4.37,0,0,0,.65-2.26A4.32,4.32,0,1,0,2,6.31a4.32,4.32,0,0,0,4.31,4.32A4.35,4.35,0,0,0,8.57,10ZM4,6.31a2.29,2.29,0,0,1,.68-1.63A2.32,2.32,0,0,1,8,4.68,2.31,2.31,0,0,1,8,8,2.32,2.32,0,0,1,4,6.31Z'
  }));
};

UilCommentAltSearch.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltSearch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltShare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.5,6.5h-5a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9.5a1,1,0,0,1-1-1v-2a1,1,0,0,0-2,0v2a3,3,0,0,0,3,3h8.36l3,2.73a1,1,0,0,0,.68.27,1.1,1.1,0,0,0,.4-.08,1,1,0,0,0,.6-.92V9.5A3,3,0,0,0,19.5,6.5Zm-10,5A2,2,0,1,0,8.32,7.89l-1.75-.8,1.91-.88a2,2,0,0,0,1,.29,2,2,0,1,0-2-2l-1.9.87A2,2,0,0,0,4.5,5a2,2,0,0,0,0,4,2,2,0,0,0,.93-.24l2.09,1A2,2,0,0,0,9.5,11.5Z'
  }));
};

UilCommentAltShare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltShare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltShield = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.57,12a1,1,0,0,0,.58-.19l1.62-1.16A4.56,4.56,0,0,0,10.68,7V3.63a1,1,0,0,0-.37-.77,1,1,0,0,0-.84-.2,3,3,0,0,1-2.33-.48A1,1,0,0,0,6,2.18a3,3,0,0,1-2.33.48,1,1,0,0,0-1.2,1V7a4.55,4.55,0,0,0,1.9,3.7L6,11.81A.94.94,0,0,0,6.57,12ZM4.46,7V4.72a5.16,5.16,0,0,0,2.11-.55,5.12,5.12,0,0,0,2.11.55V7A2.57,2.57,0,0,1,7.61,9l-1,.74L5.53,9A2.57,2.57,0,0,1,4.46,7ZM18.54,6h-5a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v9.72L18,17.27a.94.94,0,0,0-.68-.27H8.54a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3H16.9l3,2.73a1,1,0,0,0,.67.27,1.15,1.15,0,0,0,.41-.08,1,1,0,0,0,.59-.92V9A3,3,0,0,0,18.54,6Z'
  }));
};

UilCommentAltShield.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltShield.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.66,6H17a1,1,0,0,1,1,1v6.34a1,1,0,1,0,2,0V7a3,3,0,0,0-3-3H10.66a1,1,0,0,0,0,2ZM21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71l2,2A3,3,0,0,0,4,7V19a1,1,0,0,0,.62.92A.84.84,0,0,0,5,20a1,1,0,0,0,.71-.29L8.41,17h7.18l4.7,4.71a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM8,15a1,1,0,0,0-.71.29L6,16.59V7.41L13.59,15Z'
  }));
};

UilCommentAltSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5.5,11a1,1,0,0,0,2,0V5.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-3-3a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3A1,1,0,0,0,4.21,6.71L5.5,5.41Zm13-5h-5a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H8.5a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v1a3,3,0,0,0,3,3h8.36l3,2.73a1,1,0,0,0,.68.27,1.1,1.1,0,0,0,.4-.08,1,1,0,0,0,.6-.92V9A3,3,0,0,0,18.5,6Z'
  }));
};

UilCommentAltUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentAltVerify = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.71,6.29l-5.3,5.3L8.29,9.47a1,1,0,1,0-1.41,1.41l2.83,2.83a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29l6-6a1,1,0,0,0,0-1.42A1,1,0,0,0,15.71,6.29ZM19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilCommentAltVerify.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentAltVerify.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentBlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,14a1,1,0,0,0-1.22.72A7,7,0,0,1,11,20H5.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,9.25,6.22a1,1,0,0,0-.5-1.94A9,9,0,0,0,4,18.62L2.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h8a9,9,0,0,0,8.72-6.75A1,1,0,0,0,19,14ZM20.54,3.46A5,5,0,1,0,22,7,5,5,0,0,0,20.54,3.46ZM14,7a3,3,0,0,1,3-3,3,3,0,0,1,1.29.3l-4,4A3,3,0,0,1,14,7Zm5.12,2.12a3.08,3.08,0,0,1-3.4.57l4-4A3,3,0,0,1,20,7,3,3,0,0,1,19.12,9.12Z'
  }));
};

UilCommentBlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentBlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentChartLine = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,10a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V11A1,1,0,0,0,12,10ZM8,13a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V14A1,1,0,0,0,8,13ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,.3-.71,1,1,0,0,0-.3-.7A8,8,0,1,1,12,20ZM16,8a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V9A1,1,0,0,0,16,8Z'
  }));
};

UilCommentChartLine.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentChartLine.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.29,7.13a1,1,0,0,0,0,1.42l1.92,1.92a1,1,0,0,0,1.42,0l4.08-4.08A1,1,0,1,0,19.29,5L15.92,8.35,14.71,7.13A1,1,0,0,0,13.29,7.13Zm6.62,3.51A1,1,0,0,0,19,11.72,2.62,2.62,0,0,1,19,12a7,7,0,0,1-7,7H6.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,10.53,5.15a7.14,7.14,0,0,1,2.8,0,1,1,0,1,0,.4-2,9.15,9.15,0,0,0-3.61,0A9.05,9.05,0,0,0,3,12a9,9,0,0,0,2,5.62L3.29,19.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,4,21h8a9,9,0,0,0,9-9c0-.15,0-.29,0-.44A1,1,0,0,0,19.91,10.64Z'
  }));
};

UilCommentCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentDots = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,11a1,1,0,1,0,1,1A1,1,0,0,0,8,11Zm4,0a1,1,0,1,0,1,1A1,1,0,0,0,12,11Zm4,0a1,1,0,1,0,1,1A1,1,0,0,0,16,11ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,.3-.71,1,1,0,0,0-.3-.7A8,8,0,1,1,12,20Z'
  }));
};

UilCommentDots.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentDots.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,14a1,1,0,0,0-1.22.72A7,7,0,0,1,11,20H5.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,11,6a8.49,8.49,0,0,1,.88,0,1,1,0,1,0,.24-2A8.32,8.32,0,0,0,11,4,9,9,0,0,0,4,18.62L2.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h8a9,9,0,0,0,8.72-6.75A1,1,0,0,0,19,14Zm2.71-6.74a1,1,0,0,0-1.42,0L19,8.59V3a1,1,0,0,0-2,0V8.59l-1.29-1.3a1,1,0,1,0-1.42,1.42l3,3a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3A1,1,0,0,0,21.71,7.29Z'
  }));
};

UilCommentDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,4.72,19.28,2.29a1,1,0,0,0-1.41,0L12.29,7.87a1,1,0,0,0-.29.71V11a1,1,0,0,0,1,1h2.42a1,1,0,0,0,.71-.29l5.58-5.58A1,1,0,0,0,21.71,4.72ZM15,10H14V9l4.58-4.58,1,1Zm4,2h0a1,1,0,0,0-1,1,7,7,0,0,1-7,7H5.41l.64-.63a1,1,0,0,0,0-1.42A7,7,0,0,1,11,6a1,1,0,0,0,0-2h0A9,9,0,0,0,4,18.62L2.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h8a9,9,0,0,0,9-9A1,1,0,0,0,19,12Z'
  }));
};

UilCommentEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,14a1,1,0,1,0,1,1A1,1,0,0,0,12,14ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,.3-.71,1,1,0,0,0-.3-.7A8,8,0,1,1,12,20ZM12,8a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V9A1,1,0,0,0,12,8Z'
  }));
};

UilCommentExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,8.35a3.07,3.07,0,0,0-3.54.53,3,3,0,0,0,0,4.24L11.29,16a1,1,0,0,0,1.42,0l2.83-2.83a3,3,0,0,0,0-4.24A3.07,3.07,0,0,0,12,8.35Zm2.12,3.36L12,13.83,9.88,11.71a1,1,0,0,1,0-1.42,1,1,0,0,1,1.41,0,1,1,0,0,0,1.42,0,1,1,0,0,1,1.41,0A1,1,0,0,1,14.12,11.71ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Z'
  }));
};

UilCommentHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentImage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,2.44,14.91a.29.29,0,0,0,0,.1,9.83,9.83,0,0,0,1.79,3.32l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9a10,10,0,0,0,9.46-6.78l0-.08A9.89,9.89,0,0,0,22,12,10,10,0,0,0,12,2Zm0,18H5.41l.3-.29,8.41-8.42a1,1,0,0,1,1.4,0l3.62,3.6.23.22A8,8,0,0,1,12,20ZM4.54,14.87l1.58-1.58a1,1,0,0,1,1.41,0l.87.87L5.68,16.9A7.67,7.67,0,0,1,4.54,14.87Zm15.41-2-3-3a3,3,0,0,0-4.24,0L9.82,12.76l-.88-.87a3,3,0,0,0-4.23,0L4,12.56A5.25,5.25,0,0,1,4,12a8,8,0,0,1,16,0A8.27,8.27,0,0,1,20,12.86Z'
  }));
};

UilCommentImage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentImage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,11a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V12A1,1,0,0,0,12,11Zm0-3a1,1,0,1,0,1,1A1,1,0,0,0,12,8Zm0-6A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,.3-.71,1,1,0,0,0-.3-.7A8,8,0,1,1,12,20Z'
  }));
};

UilCommentInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentInfoAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,9a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V10A1,1,0,0,0,12,9Zm7-7H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1ZM12,6a1,1,0,1,0,1,1A1,1,0,0,0,12,6Z'
  }));
};

UilCommentInfoAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentInfoAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentLines = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,9H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Zm-4,4H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Z'
  }));
};

UilCommentLines.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentLines.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.92,16.13a1,1,0,0,0-1.37.37A7,7,0,0,1,11.5,20H5.91l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,10.62,6.05a1,1,0,1,0-.24-2A9,9,0,0,0,4.47,18.62L2.79,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3.5,22h8a9,9,0,0,0,7.79-4.5A1,1,0,0,0,18.92,16.13Zm.58-9.95V5a3,3,0,0,0-6,0V6.18A3,3,0,0,0,11.5,9v2a3,3,0,0,0,3,3h4a3,3,0,0,0,3-3V9A3,3,0,0,0,19.5,6.18ZM15.5,5a1,1,0,0,1,2,0V6h-2Zm4,6a1,1,0,0,1-1,1h-4a1,1,0,0,1-1-1V9a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1Z'
  }));
};

UilCommentLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Zm2-9H13V10a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V13h1a1,1,0,0,0,0-2Z'
  }));
};

UilCommentMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentMessage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Zm5-9H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Zm-2,4H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM9,9h6a1,1,0,0,0,0-2H9A1,1,0,0,0,9,9Z'
  }));
};

UilCommentMessage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentMessage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentNotes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,11h6a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2ZM7,9a1,1,0,1,0,1,1A1,1,0,0,0,7,9Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,7,13ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,.3-.71,1,1,0,0,0-.3-.7A8,8,0,1,1,12,20Zm5-7H11a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilCommentNotes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentNotes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Zm3-9H13V9a1,1,0,0,0-2,0v2H9a1,1,0,0,0,0,2h2v2a1,1,0,0,0,2,0V13h2a1,1,0,0,0,0-2Z'
  }));
};

UilCommentPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.77,5.87a1,1,0,0,0,1.36-.37A1,1,0,0,1,18,6a1,1,0,0,1-1,1,1,1,0,0,0,0,2,3,3,0,1,0-2.6-4.5A1,1,0,0,0,14.77,5.87ZM19.07,13a1,1,0,0,0-1.12.86A7,7,0,0,1,11,20H5.41l.65-.65a1,1,0,0,0,0-1.41A7,7,0,0,1,11,6a1,1,0,0,0,0-2A9,9,0,0,0,4,18.61L2.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h8a9,9,0,0,0,8.93-7.87A1,1,0,0,0,19.07,13Zm-1.69-2.93A1,1,0,0,0,16.8,10l-.18.06-.18.09-.15.13a1,1,0,0,0-.21.32A.84.84,0,0,0,16,11a1,1,0,0,0,.07.39,1,1,0,0,0,.22.32A1,1,0,0,0,17,12a1,1,0,0,0,1-1,.84.84,0,0,0-.08-.38,1.07,1.07,0,0,0-.54-.54Z'
  }));
};

UilCommentQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentRedo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,14a1,1,0,0,0-1.22.72A7,7,0,0,1,11,20H5.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,9.25,6.22a1,1,0,0,0-.5-1.94A9,9,0,0,0,4,18.62L2.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h8a9,9,0,0,0,8.72-6.75A1,1,0,0,0,19,14ZM21,2a1,1,0,0,0-1,1h0a5,5,0,1,0,.3,7.75A1,1,0,1,0,19,9.25,3,3,0,1,1,17,4a3,3,0,0,1,2.23,1H18a1,1,0,0,0,0,2h3a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2Z'
  }));
};

UilCommentRedo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentRedo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentSearch = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.21,10.29,19.48,8.57a4.37,4.37,0,0,0,.65-2.26,4.31,4.31,0,1,0-4.32,4.32A4.35,4.35,0,0,0,18.07,10l1.72,1.73a1,1,0,0,0,1.42,0A1,1,0,0,0,21.21,10.29ZM17.45,8A2.32,2.32,0,0,1,13.5,6.31a2.29,2.29,0,0,1,.68-1.63,2.32,2.32,0,0,1,3.27,0,2.31,2.31,0,0,1,0,3.27ZM19.5,14a1,1,0,0,0-1.22.72A7,7,0,0,1,11.5,20H5.91l.64-.63a1,1,0,0,0,0-1.41,7,7,0,0,1-2-5A7,7,0,0,1,8.87,6.52a1,1,0,1,0-.74-1.86,9,9,0,0,0-3.66,14L2.79,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3.5,22h8a9,9,0,0,0,8.72-6.75A1,1,0,0,0,19.5,14Z'
  }));
};

UilCommentSearch.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentSearch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentShare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.06,13.51a1,1,0,0,0-1.11.87A7,7,0,0,1,11,20.5H5.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,9.25,6.72a1,1,0,0,0-.5-1.94A9,9,0,0,0,4,19.12L2.29,20.79a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22.5h8a9,9,0,0,0,8.93-7.88A1,1,0,0,0,19.06,13.51ZM19,7.5a2,2,0,0,0-1.18.39l-1.75-.8L18,6.21a2,2,0,0,0,1,.29,2,2,0,1,0-2-2l-1.9.87A2,2,0,0,0,14,5a2,2,0,0,0,0,4,2,2,0,0,0,.93-.24l2.09,1A2,2,0,1,0,19,7.5Z'
  }));
};

UilCommentShare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentShare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentShield = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.7,2.86a1,1,0,0,0-.84-.2,3,3,0,0,1-2.33-.48,1,1,0,0,0-1.15,0,3,3,0,0,1-2.33.48,1,1,0,0,0-.84.2,1,1,0,0,0-.37.77V7a4.56,4.56,0,0,0,1.91,3.7l1.62,1.16a1,1,0,0,0,1.17,0l1.62-1.16A4.56,4.56,0,0,0,22.07,7V3.63A1,1,0,0,0,21.7,2.86ZM20.07,7A2.57,2.57,0,0,1,19,9l-1,.74L16.91,9A2.57,2.57,0,0,1,15.84,7V4.72A5.17,5.17,0,0,0,18,4.17a5.12,5.12,0,0,0,2.11.55ZM18.93,14a1,1,0,0,0-1.21.72A7,7,0,0,1,10.93,20H5.35L6,19.37A1,1,0,0,0,6,18,7,7,0,0,1,10.93,6a1,1,0,0,0,0-2,9,9,0,0,0-7,14.62L2.23,20.29A1,1,0,0,0,2.93,22h8a9,9,0,0,0,8.72-6.75A1,1,0,0,0,18.93,14Z'
  }));
};

UilCommentShield.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentShield.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.19,5.23A7.12,7.12,0,0,1,12,5a7,7,0,0,1,7,7,7.12,7.12,0,0,1-.23,1.81,1,1,0,0,0,.7,1.23,1.15,1.15,0,0,0,.26,0,1,1,0,0,0,1-.74A8.91,8.91,0,0,0,21,12a9,9,0,0,0-9-9,8.91,8.91,0,0,0-2.33.3A1,1,0,0,0,9,4.53,1,1,0,0,0,10.19,5.23ZM21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71L5,6.38A9,9,0,0,0,5,17.62L3.29,19.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,4,21h8a9,9,0,0,0,5.62-2l2.67,2.68a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM12,19H6.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,6.4,7.81l9.79,9.79A7,7,0,0,1,12,19Z'
  }));
};

UilCommentSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,14a1,1,0,0,0-1.22.72A7,7,0,0,1,11,20H5.41l.64-.63a1,1,0,0,0,0-1.41A7,7,0,0,1,11,6a1,1,0,0,0,0-2A9,9,0,0,0,4,18.62L2.29,20.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h8a9,9,0,0,0,8.72-6.75A1,1,0,0,0,19,14Zm2.71-8.74-3-3a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3a1,1,0,0,0,1.42,1.42L17,5.41V11a1,1,0,0,0,2,0V5.41l1.29,1.3a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,5.29Z'
  }));
};

UilCommentUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentVerify = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.29,8.85l-4.73,4.74L8.71,11.73a1,1,0,0,0-1.42,1.42l2.56,2.56a1,1,0,0,0,1.42,0l5.44-5.44a1,1,0,1,0-1.42-1.42ZM12,2A10,10,0,0,0,2,12a9.89,9.89,0,0,0,2.26,6.33l-2,2a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,22h9A10,10,0,0,0,12,2Zm0,18H5.41l.93-.93a1,1,0,0,0,0-1.41A8,8,0,1,1,12,20Z'
  }));
};

UilCommentVerify.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentVerify.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilComments = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.61,19.19A7,7,0,0,0,17.87,8.62,8,8,0,1,0,3.68,14.91L2.29,16.29a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,18H8.69A7,7,0,0,0,15,22h6a1,1,0,0,0,.92-.62,1,1,0,0,0-.21-1.09ZM8,15a6.63,6.63,0,0,0,.08,1H5.41l.35-.34a1,1,0,0,0,0-1.42A5.93,5.93,0,0,1,4,10a6,6,0,0,1,6-6,5.94,5.94,0,0,1,5.65,4c-.22,0-.43,0-.65,0A7,7,0,0,0,8,15ZM18.54,20l.05.05H15a5,5,0,1,1,3.54-1.46,1,1,0,0,0-.3.7A1,1,0,0,0,18.54,20Z'
  }));
};

UilComments.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilComments.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCommentsAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,8H18V5a3,3,0,0,0-3-3H5A3,3,0,0,0,2,5V17a1,1,0,0,0,.62.92A.84.84,0,0,0,3,18a1,1,0,0,0,.71-.29l2.81-2.82H8v1.44a3,3,0,0,0,3,3h6.92l2.37,2.38A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V11A3,3,0,0,0,19,8ZM8,11v1.89H6.11a1,1,0,0,0-.71.29L4,14.59V5A1,1,0,0,1,5,4H15a1,1,0,0,1,1,1V8H11A3,3,0,0,0,8,11Zm12,7.59-1-1a1,1,0,0,0-.71-.3H11a1,1,0,0,1-1-1V11a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1Z'
  }));
};

UilCommentsAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCommentsAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompactDisc = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM12,9a3,3,0,1,0,3,3A3,3,0,0,0,12,9Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,13Z'
  }));
};

UilCompactDisc.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompactDisc.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilComparison = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H4v-.54l5-5,3.8,3.8a1,1,0,0,0,1.41,0l7.5-7.5a1,1,0,0,0,0-1.42,1,1,0,0,0-1.41,0l-6.8,6.8-3.79-3.8a1,1,0,0,0-1.41,0L4,16.63V11.46l5-5,2.8,2.8a1,1,0,0,0,1.41,0L18,4.47l2.19,2.19a1,1,0,0,0,1.41-1.42L18.69,2.35a1,1,0,0,0-1.41,0l-4.8,4.8L9.69,4.35a1,1,0,0,0-1.41,0L4,8.63V3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,0-2Z'
  }));
};

UilComparison.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilComparison.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompass = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm1,17.93V19a1,1,0,0,0-2,0v.93A8,8,0,0,1,4.07,13H5a1,1,0,0,0,0-2H4.07A8,8,0,0,1,11,4.07V5a1,1,0,0,0,2,0V4.07A8,8,0,0,1,19.93,11H19a1,1,0,0,0,0,2h.93A8,8,0,0,1,13,19.93ZM15.14,7.55l-5,2.12a1,1,0,0,0-.52.52l-2.12,5a1,1,0,0,0,.21,1.1,1,1,0,0,0,.7.3.93.93,0,0,0,.4-.09l5-2.12a1,1,0,0,0,.52-.52l2.12-5a1,1,0,0,0-1.31-1.31Zm-2.49,5.1-2.28,1,1-2.28,2.28-1Z'
  }));
};

UilCompass.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompass.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompress = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,9h5a1,1,0,0,0,0-2H17V3a1,1,0,0,0-2,0V8A1,1,0,0,0,16,9ZM8,15H3a1,1,0,0,0,0,2H7v4a1,1,0,0,0,2,0V16A1,1,0,0,0,8,15ZM8,2A1,1,0,0,0,7,3V7H3A1,1,0,0,0,3,9H8A1,1,0,0,0,9,8V3A1,1,0,0,0,8,2ZM21,15H16a1,1,0,0,0-1,1v5a1,1,0,0,0,2,0V17h4a1,1,0,0,0,0-2Z'
  }));
};

UilCompress.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompress.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompressAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,2.29a1,1,0,0,0-1.42,0L14.5,8.09V6.5a1,1,0,0,0-2,0v4a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54,1,1,0,0,0,.38.08h4a1,1,0,0,0,0-2H15.91l5.8-5.79A1,1,0,0,0,21.71,2.29ZM10.88,12.58a1,1,0,0,0-.38-.08h-4a1,1,0,0,0,0,2H8.09l-5.8,5.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l5.79-5.8V17.5a1,1,0,0,0,2,0v-4a1,1,0,0,0-.08-.38A1,1,0,0,0,10.88,12.58Z'
  }));
};

UilCompressAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompressAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompressAltLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.5,5.5a1,1,0,0,0-1,1V8.09L3.71,2.29A1,1,0,0,0,2.29,3.71L8.09,9.5H6.5a1,1,0,0,0,0,2h4a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54,1,1,0,0,0,.08-.38v-4A1,1,0,0,0,10.5,5.5ZM21.71,20.29l-5.8-5.79H17.5a1,1,0,0,0,0-2h-4a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54,1,1,0,0,0-.08.38v4a1,1,0,0,0,2,0V15.91l5.79,5.8a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29Z'
  }));
};

UilCompressAltLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompressAltLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompressArrows = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.38,13.08A1,1,0,0,0,10,13H6a1,1,0,0,0,0,2H7.59l-5.3,5.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L9,16.41V18a1,1,0,0,0,2,0V14a1,1,0,0,0-.08-.38A1,1,0,0,0,10.38,13.08ZM10,5A1,1,0,0,0,9,6V7.59L3.71,2.29A1,1,0,0,0,2.29,3.71L7.59,9H6a1,1,0,0,0,0,2h4a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,11,10V6A1,1,0,0,0,10,5Zm3.62,5.92A1,1,0,0,0,14,11h4a1,1,0,0,0,0-2H16.41l5.3-5.29a1,1,0,1,0-1.42-1.42L15,7.59V6a1,1,0,0,0-2,0v4a1,1,0,0,0,.08.38A1,1,0,0,0,13.62,10.92ZM16.41,15H18a1,1,0,0,0,0-2H14a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,13,14v4a1,1,0,0,0,2,0V16.41l5.29,5.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z'
  }));
};

UilCompressArrows.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompressArrows.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompressLines = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,20H13V16.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42l.79-.8V20H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2ZM7,4h4V7.59l-.79-.8A1,1,0,1,0,8.79,8.21l2.5,2.5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,1,0-1.42-1.42l-.79.8V4h4a1,1,0,0,0,0-2H7A1,1,0,0,0,7,4Z'
  }));
};

UilCompressLines.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompressLines.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompressPoint = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,20.29,15.41,14H17a1,1,0,0,0,0-2H13.41l5.66-5.66a1,1,0,1,0-1.41-1.41L12,10.59V7a1,1,0,0,0-2,0V8.59L3.71,2.29A1,1,0,0,0,2.29,3.71L8.59,10H7a1,1,0,0,0,0,2h3.59L4.93,17.66a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0L12,13.41V17a1,1,0,0,0,2,0V15.41l6.29,6.3a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29Z'
  }));
};

UilCompressPoint.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompressPoint.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCompressV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,13.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42l.79-.8V21a1,1,0,0,0,2,0V16.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm-1.42-2.58a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2.5-2.5a1,1,0,1,0-1.42-1.42l-.79.8V3a1,1,0,0,0-2,0V7.59l-.79-.8A1,1,0,1,0,8.79,8.21Z'
  }));
};

UilCompressV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCompressV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilConfused = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,9a1,1,0,1,0,1,1A1,1,0,0,0,9,9Zm5.66,4.56-4.19,1.5A1,1,0,0,0,10.8,17a1,1,0,0,0,.34-.06l4.2-1.5a1,1,0,1,0-.68-1.88ZM15,9a1,1,0,1,0,1,1A1,1,0,0,0,15,9ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilConfused.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilConfused.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilConstructor = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,9.67V9.5a7.95,7.95,0,0,0-5.59-7.62l-.06,0a8.32,8.32,0,0,0-2.59-.36A8.21,8.21,0,0,0,4,9.67a3,3,0,0,0,0,5.66,8,8,0,0,0,8,7.17h.23a8.13,8.13,0,0,0,7.68-7.16A3,3,0,0,0,20,9.67ZM12.18,20.5a6,6,0,0,1-6.09-5H17.86A6.09,6.09,0,0,1,12.18,20.5Zm6.82-7H5a1,1,0,0,1,0-2H7a1,1,0,0,0,0-2H6A6.4,6.4,0,0,1,9,4.35V7.5a1,1,0,0,0,2,0V3.59a7.34,7.34,0,0,1,.82-.09H12a6.64,6.64,0,0,1,1,.09V7.5a1,1,0,0,0,2,0V4.32a6.65,6.65,0,0,1,1.18.87A6,6,0,0,1,18,9.5H17a1,1,0,0,0,0,2h2a1,1,0,0,1,0,2Z'
  }));
};

UilConstructor.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilConstructor.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCopy = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,14.05,2H10A3,3,0,0,0,7,5V6H6A3,3,0,0,0,3,9V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V18h1a3,3,0,0,0,3-3V9S21,9,21,8.94ZM15,5.41,17.59,8H16a1,1,0,0,1-1-1ZM15,19a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V9A1,1,0,0,1,6,8H7v7a3,3,0,0,0,3,3h5Zm4-4a1,1,0,0,1-1,1H10a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h3V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilCopy.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCopy.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCopyAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,20H8a3,3,0,0,1-3-3V7A1,1,0,0,0,3,7V17a5,5,0,0,0,5,5h8a1,1,0,0,0,0-2ZM21,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0L14.06,2H10A3,3,0,0,0,7,5V15a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V9S21,9,21,8.94ZM15,5.41,17.59,8H16a1,1,0,0,1-1-1ZM19,15a1,1,0,0,1-1,1H10a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h3V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilCopyAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCopyAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCopyLandscape = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,19H6a3,3,0,0,1-3-3V8A1,1,0,0,0,1,8v8a5,5,0,0,0,5,5H18a1,1,0,0,0,0-2Zm5-9.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0L16.06,3H8A3,3,0,0,0,5,6v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V10S23,10,23,9.94ZM17,6.41,19.59,9H18a1,1,0,0,1-1-1ZM21,14a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V6A1,1,0,0,1,8,5h7V8a3,3,0,0,0,3,3h3Z'
  }));
};

UilCopyLandscape.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCopyLandscape.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCopyright = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,9h2a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H11a3,3,0,0,0-3,3v4a3,3,0,0,0,3,3h2a3,3,0,0,0,3-3,1,1,0,0,0-2,0,1,1,0,0,1-1,1H11a1,1,0,0,1-1-1V10A1,1,0,0,1,11,9Zm1-7A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilCopyright.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCopyright.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerDownLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.69,2a1,1,0,0,0-1,1V13.37a2,2,0,0,1-2,2h-8l2.92-2.92A1,1,0,0,0,9.24,11L4.61,15.66a1.19,1.19,0,0,0-.22.33,1,1,0,0,0,0,.76,1,1,0,0,0,.22.33l4.63,4.63a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42L7.73,17.37h8a4,4,0,0,0,4-4V3A1,1,0,0,0,18.69,2Z'
  }));
};

UilCornerDownLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerDownLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerDownRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.61,16a1.19,1.19,0,0,0-.22-.33L14.76,11a1,1,0,0,0-1.41,1.41l2.92,2.92h-7a3,3,0,0,1-3-3V3a1,1,0,1,0-2,0v9.37a5,5,0,0,0,5,5h7l-2.92,2.92a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29,1,1,0,0,0,.7-.29l4.63-4.63a1,1,0,0,0,.22-.33A1,1,0,0,0,19.61,16Z'
  }));
};

UilCornerDownRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerDownRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerDownRightAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.92,12.62a1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L17.59,12H8a1,1,0,0,1-1-1V7A1,1,0,0,0,5,7v4a3,3,0,0,0,3,3h9.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,.21-.33A1,1,0,0,0,20.92,12.62Z'
  }));
};

UilCornerDownRightAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerDownRightAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerLeftDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,4.31H11.63a5,5,0,0,0-5,5v7L3.71,13.35a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l4.63,4.63a1,1,0,0,0,.33.22.94.94,0,0,0,.76,0,1.19,1.19,0,0,0,.33-.22L13,14.76a1,1,0,0,0-1.41-1.41L8.63,16.27v-7a3,3,0,0,1,3-3H21a1,1,0,0,0,0-2Z'
  }));
};

UilCornerLeftDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerLeftDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerRightDown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,13.35a1,1,0,0,0-1.42,0l-2.92,2.92v-8a4,4,0,0,0-4-4H3a1,1,0,1,0,0,2H13.37a2,2,0,0,1,2,2v8l-2.92-2.92A1,1,0,0,0,11,14.76l4.62,4.63a1.19,1.19,0,0,0,.33.22.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.22l4.63-4.63A1,1,0,0,0,21.71,13.35Z'
  }));
};

UilCornerRightDown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerRightDown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerUpLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.69,6.63h-7l2.92-2.92a1,1,0,0,0,0-1.42,1,1,0,0,0-1.41,0L4.61,6.92a1,1,0,0,0-.22.33,1,1,0,0,0,0,.76,1.19,1.19,0,0,0,.22.33L9.24,13a1,1,0,0,0,.7.3,1,1,0,0,0,.71-1.71L7.73,8.63h7a3,3,0,0,1,3,3V21a1,1,0,0,0,2,0V11.63A5,5,0,0,0,14.69,6.63Z'
  }));
};

UilCornerUpLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerUpLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerUpLeftAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,9.5H7.41l1.3-1.29A1,1,0,0,0,7.29,6.79l-3,3a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l3,3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L7.41,11.5H17a1,1,0,0,1,1,1v4a1,1,0,0,0,2,0v-4A3,3,0,0,0,17,9.5Z'
  }));
};

UilCornerUpLeftAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerUpLeftAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerUpRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.61,7.25a1,1,0,0,0-.22-.33L14.76,2.29a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l2.92,2.92h-8a4,4,0,0,0-4,4V21a1,1,0,0,0,2,0V10.63a2,2,0,0,1,2-2h8l-2.92,2.92a1,1,0,0,0,.71,1.71,1,1,0,0,0,.7-.3l4.63-4.62A1.19,1.19,0,0,0,19.61,8,1,1,0,0,0,19.61,7.25Z'
  }));
};

UilCornerUpRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerUpRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCornerUpRightAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.92,10.12a1,1,0,0,0-.21-.33l-3-3a1,1,0,1,0-1.42,1.42l1.3,1.29H7a3,3,0,0,0-3,3v4a1,1,0,0,0,2,0v-4a1,1,0,0,1,1-1h9.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,.21-.33A1,1,0,0,0,19.92,10.12Z'
  }));
};

UilCornerUpRightAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCornerUpRightAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCoronavirus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.5,9A1.5,1.5,0,1,0,11,10.5,1.5,1.5,0,0,0,9.5,9ZM9,14a1,1,0,1,0,1,1A1,1,0,0,0,9,14Zm6-6a1,1,0,1,0,1,1A1,1,0,0,0,15,8Zm-.5,4A1.5,1.5,0,1,0,16,13.5,1.5,1.5,0,0,0,14.5,12ZM22,11H20.941a8.95168,8.95168,0,0,0-1.916-4.6109l.75336-.75336a.99989.99989,0,0,0-1.41406-1.41406L17.6109,4.975A8.95168,8.95168,0,0,0,13,3.059V2a1,1,0,0,0-2,0V3.059A8.95168,8.95168,0,0,0,6.3891,4.975l-.75336-.75336A.99989.99989,0,0,0,4.22168,5.63574L4.975,6.3891A8.95168,8.95168,0,0,0,3.059,11H2a1,1,0,0,0,0,2H3.059a8.95168,8.95168,0,0,0,1.916,4.6109l-.75336.75336a.99989.99989,0,1,0,1.41406,1.41406L6.3891,19.025A8.95168,8.95168,0,0,0,11,20.941V22a1,1,0,0,0,2,0V20.941a8.95168,8.95168,0,0,0,4.6109-1.916l.75336.75336a.99989.99989,0,0,0,1.41406-1.41406L19.025,17.6109A8.95168,8.95168,0,0,0,20.941,13H22a1,1,0,0,0,0-2Zm-4,2h.92017A7.00413,7.00413,0,0,1,13,18.92017V17a1,1,0,0,0-2,0v1.92017A7.00413,7.00413,0,0,1,5.07983,13H6a1,1,0,0,0,0-2H5.07983A7.00413,7.00413,0,0,1,11,5.07983V7a1,1,0,0,0,2,0V5.07983A7.00413,7.00413,0,0,1,18.92017,11H18a1,1,0,0,0,0,2Z'
  }));
};

UilCoronavirus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCoronavirus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCreateDashboard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,13H4a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V14A1,1,0,0,0,10,13ZM9,19H5V15H9ZM20,3H14a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V4A1,1,0,0,0,20,3ZM19,9H15V5h4Zm1,7H18V14a1,1,0,0,0-2,0v2H14a1,1,0,0,0,0,2h2v2a1,1,0,0,0,2,0V18h2a1,1,0,0,0,0-2ZM10,3H4A1,1,0,0,0,3,4v6a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V4A1,1,0,0,0,10,3ZM9,9H5V5H9Z'
  }));
};

UilCreateDashboard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCreateDashboard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCreativeCommonsPd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,0,1-8-8A7.92,7.92,0,0,1,5.69,7.1L8.05,9.47A3.07,3.07,0,0,0,8,10v4a3,3,0,0,0,3,3h2a3,3,0,0,0,1.89-.69l2,2A7.92,7.92,0,0,1,12,20Zm-2-6V11.41l3.46,3.46A.91.91,0,0,1,13,15H11A1,1,0,0,1,10,14Zm8.31,2.9L16,14.53A3.07,3.07,0,0,0,16,14a1,1,0,0,0-1-1,.91.91,0,0,0-.46.13l-4-4A.91.91,0,0,1,11,9h2a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H11a3,3,0,0,0-1.89.69l-2-2A7.92,7.92,0,0,1,12,4a8,8,0,0,1,8,8A7.92,7.92,0,0,1,18.31,16.9Z'
  }));
};

UilCreativeCommonsPd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCreativeCommonsPd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCreditCard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,15h3a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2ZM19,5H5A3,3,0,0,0,2,8v9a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8A3,3,0,0,0,19,5Zm1,12a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V11H20Zm0-8H4V8A1,1,0,0,1,5,7H19a1,1,0,0,1,1,1Z'
  }));
};

UilCreditCard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCreditCard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCreditCardSearch = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,17.57a4.3,4.3,0,1,0-3.67,2.06A4.37,4.37,0,0,0,18.57,19l1.72,1.73a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM18,17a2.37,2.37,0,0,1-3.27,0,2.32,2.32,0,0,1,0-3.27,2.31,2.31,0,0,1,3.27,0A2.32,2.32,0,0,1,18,17ZM19,3H5A3,3,0,0,0,2,6v9a3,3,0,0,0,3,3H9a1,1,0,0,0,0-2H5a1,1,0,0,1-1-1V9H20v1a1,1,0,0,0,2,0V6A3,3,0,0,0,19,3Zm1,4H4V6A1,1,0,0,1,5,5H19a1,1,0,0,1,1,1ZM10,11H7a1,1,0,0,0,0,2h3a1,1,0,0,0,0-2Z'
  }));
};

UilCreditCardSearch.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCreditCardSearch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCrockery = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,12.15V3a1,1,0,0,0-2,0v9.15a4.16,4.16,0,0,0-3,4c0,2.05,1.52,5.8,4,5.8s4-3.75,4-5.8A4.16,4.16,0,0,0,18,12.15ZM17,20c-.8,0-2-2.27-2-3.8A2.11,2.11,0,0,1,17,14a2.11,2.11,0,0,1,2,2.2C19,17.73,17.8,20,17,20ZM10,2A1,1,0,0,0,9,3V8.46L8,9.13V3A1,1,0,0,0,6,3V9.13L5,8.46V3A1,1,0,0,0,3,3V9a1,1,0,0,0,.45.83L6,11.54V21a1,1,0,0,0,2,0V11.54l2.55-1.71A1,1,0,0,0,11,9V3A1,1,0,0,0,10,2Z'
  }));
};

UilCrockery.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCrockery.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCropAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,16H18V7a1,1,0,0,0-1-1H8V5A1,1,0,0,0,6,5V6H5A1,1,0,0,0,5,8H6v9a1,1,0,0,0,1,1h9v1a1,1,0,0,0,2,0V18h1a1,1,0,0,0,0-2Zm-3,0H8V8h8Z'
  }));
};

UilCropAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCropAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCropAltRotateLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.71,16.29a1,1,0,0,0-1.42,1.42l.3.29H8a3,3,0,0,1-3-3V13a1,1,0,0,0-2,0v2a5,5,0,0,0,5,5h.59l-.3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2-2a1,1,0,0,0,0-1.42ZM20,12H19V5a1,1,0,0,0-1-1H11V3A1,1,0,0,0,9,3V4H8A1,1,0,0,0,8,6H9v7a1,1,0,0,0,1,1h7v1a1,1,0,0,0,2,0V14h1a1,1,0,0,0,0-2Zm-3,0H11V6h6Z'
  }));
};

UilCropAltRotateLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCropAltRotateLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCropAltRotateRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,4h-.59l.3-.29a1,1,0,1,0-1.42-1.42l-2,2a1,1,0,0,0,0,1.42l2,2a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L15.41,6H16a3,3,0,0,1,3,3v2a1,1,0,0,0,2,0V9A5,5,0,0,0,16,4Zm0,14H15V11a1,1,0,0,0-1-1H7V9A1,1,0,0,0,5,9v1H4a1,1,0,0,0,0,2H5v7a1,1,0,0,0,1,1h7v1a1,1,0,0,0,2,0V20h1a1,1,0,0,0,0-2Zm-3,0H7V12h6Z'
  }));
};

UilCropAltRotateRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCropAltRotateRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCrosshair = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11H19.93A8,8,0,0,0,13,4.07V3a1,1,0,0,0-2,0V4.07A8,8,0,0,0,4.07,11H3a1,1,0,0,0,0,2H4.07A8,8,0,0,0,11,19.93V21a1,1,0,0,0,2,0V19.93A8,8,0,0,0,19.93,13H21a1,1,0,0,0,0-2Zm-4,2h.91A6,6,0,0,1,13,17.91V17a1,1,0,0,0-2,0v.91A6,6,0,0,1,6.09,13H7a1,1,0,0,0,0-2H6.09A6,6,0,0,1,11,6.09V7a1,1,0,0,0,2,0V6.09A6,6,0,0,1,17.91,11H17a1,1,0,0,0,0,2Zm-5-2a1,1,0,1,0,1,1A1,1,0,0,0,12,11Z'
  }));
};

UilCrosshair.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCrosshair.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCrosshairAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,11a1,1,0,1,0,1,1A1,1,0,0,0,12,11Zm0-9A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm1,17.93V17a1,1,0,0,0-2,0v2.93A8,8,0,0,1,4.07,13H7a1,1,0,0,0,0-2H4.07A8,8,0,0,1,11,4.07V7a1,1,0,0,0,2,0V4.07A8,8,0,0,1,19.93,11H17a1,1,0,0,0,0,2h2.93A8,8,0,0,1,13,19.93Z'
  }));
};

UilCrosshairAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCrosshairAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCrosshairs = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11H19.93A8,8,0,0,0,13,4.07V3a1,1,0,0,0-2,0V4.07A8,8,0,0,0,4.07,11H3a1,1,0,0,0,0,2H4.07A8,8,0,0,0,11,19.93V21a1,1,0,0,0,2,0V19.93A8,8,0,0,0,19.93,13H21a1,1,0,0,0,0-2Zm-9,7a6,6,0,1,1,6-6A6,6,0,0,1,12,18Zm0-9a3,3,0,1,0,3,3A3,3,0,0,0,12,9Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,13Z'
  }));
};

UilCrosshairs.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCrosshairs.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCss3Simple = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.772,3.36426A1.00062,1.00062,0,0,0,20,3H6A1,1,0,0,0,6,5H18.78613l-.78094,4H5a1,1,0,0,0,0,2H17.61475l-1.1626,5.95508-6.32324,1.99658L4.71875,17.25244l.20361-1.06494a1.00015,1.00015,0,0,0-1.96484-.375L2.5874,17.75244A1.00059,1.00059,0,0,0,3.27,18.894L9.83008,20.9541a1.00175,1.00175,0,0,0,.60107-.00049l7.18994-2.27a1.00064,1.00064,0,0,0,.68018-.7622l2.68018-13.73A1.00008,1.00008,0,0,0,20.772,3.36426Z'
  }));
};

UilCss3Simple.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCss3Simple.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilCube = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.47,7.37s0,0,0-.08l-.06-.15a.71.71,0,0,0-.07-.09.94.94,0,0,0-.09-.12l-.09-.07L20,6.78l-7.5-4.63a1,1,0,0,0-1.06,0L4,6.78l-.09.08-.09.07a.94.94,0,0,0-.09.12.71.71,0,0,0-.07.09l-.06.15s0,0,0,.08a1.15,1.15,0,0,0,0,.26v8.74a1,1,0,0,0,.47.85l7.5,4.63h0a.47.47,0,0,0,.15.06s.05,0,.08,0a.86.86,0,0,0,.52,0s.05,0,.08,0a.47.47,0,0,0,.15-.06h0L20,17.22a1,1,0,0,0,.47-.85V7.63A1.15,1.15,0,0,0,20.47,7.37ZM11,19.21l-5.5-3.4V9.43L11,12.82Zm1-8.12L6.4,7.63,12,4.18l5.6,3.45Zm6.5,4.72L13,19.21V12.82l5.5-3.39Z'
  }));
};

UilCube.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilCube.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDashboard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.088,4.95453c-.00732-.00781-.00952-.01819-.01715-.02582s-.01819-.00995-.02606-.01733a9.97886,9.97886,0,0,0-14.08948,0c-.00787.00738-.01837.00964-.02606.01733s-.00983.018-.01715.02582a10,10,0,1,0,14.1759,0ZM12,20a7.9847,7.9847,0,0,1-6.235-3H9.78027a2.9636,2.9636,0,0,0,4.43946,0h4.01532A7.9847,7.9847,0,0,1,12,20Zm-1-5a1,1,0,1,1,1,1A1.001,1.001,0,0,1,11,15Zm8.41022.00208L19.3999,15H15a2.99507,2.99507,0,0,0-2-2.81573V9a1,1,0,0,0-2,0v3.18427A2.99507,2.99507,0,0,0,9,15H4.6001l-.01032.00208A7.93083,7.93083,0,0,1,4.06946,13H5a1,1,0,0,0,0-2H4.06946A7.95128,7.95128,0,0,1,5.68854,7.10211l.65472.65473A.99989.99989,0,1,0,7.75732,6.34277l-.65466-.65466A7.95231,7.95231,0,0,1,11,4.06946V5a1,1,0,0,0,2,0V4.06946a7.95231,7.95231,0,0,1,3.89734,1.61865l-.65466.65466a.99989.99989,0,1,0,1.41406,1.41407l.65472-.65473A7.95128,7.95128,0,0,1,19.93054,11H19a1,1,0,0,0,0,2h.93054A7.93083,7.93083,0,0,1,19.41022,15.00208Z'
  }));
};

UilDashboard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDashboard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDataSharing = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.52,3.87A5,5,0,0,0,11.44,4H7A3,3,0,0,0,4,7v4a1,1,0,0,0,2,0V7A1,1,0,0,1,7,6H9.78A3,3,0,0,0,9,8a3,3,0,0,0,3,3h7.33a3.66,3.66,0,0,0,1.19-7.13ZM19.33,9H12a1,1,0,0,1,0-2,1,1,0,0,0,1-1,3,3,0,0,1,5.84-1,1,1,0,0,0,.78.67A1.65,1.65,0,0,1,21,7.33,1.67,1.67,0,0,1,19.33,9ZM19,13a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H14.74a3.66,3.66,0,0,0-2.22-2.13,5,5,0,0,0-9.45,1.28A3,3,0,0,0,4,23h7.33a3.66,3.66,0,0,0,3.6-3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13Zm-7.67,8H4a1,1,0,0,1,0-2,1,1,0,0,0,1-1,3,3,0,0,1,5.84-1,1,1,0,0,0,.78.67A1.65,1.65,0,0,1,13,19.33,1.67,1.67,0,0,1,11.33,21Z'
  }));
};

UilDataSharing.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDataSharing.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDatabase = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,16.5a1,1,0,1,0,1,1A1,1,0,0,0,8,16.5ZM12,2C8,2,4,3.37,4,6V18c0,2.63,4,4,8,4s8-1.37,8-4V6C20,3.37,16,2,12,2Zm6,16c0,.71-2.28,2-6,2s-6-1.29-6-2V14.73A13.16,13.16,0,0,0,12,16a13.16,13.16,0,0,0,6-1.27Zm0-6c0,.71-2.28,2-6,2s-6-1.29-6-2V8.73A13.16,13.16,0,0,0,12,10a13.16,13.16,0,0,0,6-1.27ZM12,8C8.28,8,6,6.71,6,6s2.28-2,6-2,6,1.29,6,2S15.72,8,12,8ZM8,10.5a1,1,0,1,0,1,1A1,1,0,0,0,8,10.5Z'
  }));
};

UilDatabase.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDatabase.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDatabaseAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,17a1,1,0,1,0,1,1A1,1,0,0,0,8,17Zm0-6a1,1,0,1,0,1,1A1,1,0,0,0,8,11Zm8-9H8A4,4,0,0,0,4,6V18a4,4,0,0,0,4,4h8a4,4,0,0,0,4-4V6A4,4,0,0,0,16,2Zm2,16a2,2,0,0,1-2,2H8a2,2,0,0,1-2-2V15.44A3.91,3.91,0,0,0,8,16h8a3.91,3.91,0,0,0,2-.56Zm0-6a2,2,0,0,1-2,2H8a2,2,0,0,1-2-2V9.44A3.91,3.91,0,0,0,8,10h8a3.91,3.91,0,0,0,2-.56ZM16,8H8A2,2,0,0,1,8,4h8a2,2,0,0,1,0,4Z'
  }));
};

UilDatabaseAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDatabaseAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDesert = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,2a4,4,0,1,0,4,4A4,4,0,0,0,18,2Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,18,8ZM15,20H13V18a1,1,0,0,0-2,0v2H9V16.62l3.45-1.73A1,1,0,0,0,13,14V10a1,1,0,0,0-2,0v3.38l-2,1V8A1,1,0,0,0,7,8v8.38l-2-1V13a1,1,0,0,0-2,0v3a1,1,0,0,0,.55.89L7,18.62V20H3a1,1,0,0,0,0,2H15a1,1,0,0,0,0-2Z'
  }));
};

UilDesert.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDesert.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDesktop = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,3H5A3,3,0,0,0,2,6v8a3,3,0,0,0,3,3h6v2H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2H13V17h6a3,3,0,0,0,3-3V6A3,3,0,0,0,19,3Zm1,11a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V6A1,1,0,0,1,5,5H19a1,1,0,0,1,1,1Z'
  }));
};

UilDesktop.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDesktop.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDesktopAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H8v2H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2H16V18h3a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM14,20H10V18h4Zm6-5a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V14H20Zm0-3H4V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilDesktopAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDesktopAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDesktopAltSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71l1,1A3,3,0,0,0,3,6v8a3,3,0,0,0,3,3H9v2H6a1,1,0,0,0,0,2H18a1,1,0,0,0,.93-.66l1.36,1.37a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM5,6.41,9.59,11H5ZM13,19H11V17h2ZM6,15a1,1,0,0,1-1-1V13h6.59l2,2Zm9,4V17h.59l2,2ZM9.66,5H18a1,1,0,0,1,1,1v5H17.66a1,1,0,0,0,0,2H19v1a.37.37,0,0,1,0,.11,1,1,0,0,0,.78,1.18l.2,0a1,1,0,0,0,1-.8A2.84,2.84,0,0,0,21,14V6a3,3,0,0,0-3-3H9.66a1,1,0,0,0,0,2Z'
  }));
};

UilDesktopAltSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDesktopAltSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDesktopCloudAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.5,10H10a3,3,0,0,0,1.07-5.8,4,4,0,0,0-7.48,1A2.5,2.5,0,0,0,4.5,10Zm0-3a1,1,0,0,0,1-1,2,2,0,0,1,3.89-.64,1,1,0,0,0,.78.66A1,1,0,0,1,11,7a1,1,0,0,1-1,1H4.5a.5.5,0,0,1,0-1ZM19,2H14a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v7H3a1,1,0,0,0-1,1v2a3,3,0,0,0,3,3H8v2H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2H16V18h3a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM14,20H10V18h4Zm6-5a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V14H20Z'
  }));
};

UilDesktopCloudAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDesktopCloudAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDesktopSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.66,6H18a1,1,0,0,1,1,1v6a.94.94,0,0,1-.14.5,1,1,0,0,0,.31,1.38.94.94,0,0,0,.53.16,1,1,0,0,0,.84-.46A2.94,2.94,0,0,0,21,13V7a3,3,0,0,0-3-3H10.66a1,1,0,0,0,0,2ZM21.71,20.29,5.86,4.45h0L3.71,2.29A1,1,0,0,0,2.29,3.71L3.69,5.1A3,3,0,0,0,3,7v6a3,3,0,0,0,3,3h5v2H7a1,1,0,0,0,0,2H17a1,1,0,0,0,.93-.66l2.36,2.37a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM6,14a1,1,0,0,1-1-1V7a1,1,0,0,1,.12-.46L12.59,14Zm7,4V16h1.59l2,2Z'
  }));
};

UilDesktopSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDesktopSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDialpad = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,2.25H3A.76.76,0,0,0,2.25,3V7A.76.76,0,0,0,3,7.75H7A.76.76,0,0,0,7.75,7V3A.76.76,0,0,0,7,2.25Zm-.75,4H3.75V3.75h2.5ZM21,2.25H17a.76.76,0,0,0-.75.75V7a.76.76,0,0,0,.75.75h4A.76.76,0,0,0,21.75,7V3A.76.76,0,0,0,21,2.25Zm-.75,4h-2.5V3.75h2.5ZM14,2.25H10A.76.76,0,0,0,9.25,3V7a.76.76,0,0,0,.75.75h4A.76.76,0,0,0,14.75,7V3A.76.76,0,0,0,14,2.25Zm-.75,4h-2.5V3.75h2.5ZM7,9.25H3a.76.76,0,0,0-.75.75v4a.76.76,0,0,0,.75.75H7A.76.76,0,0,0,7.75,14V10A.76.76,0,0,0,7,9.25Zm-.75,4H3.75v-2.5h2.5Zm7.75-4H10a.76.76,0,0,0-.75.75v4a.76.76,0,0,0,.75.75h4a.76.76,0,0,0,.75-.75V10A.76.76,0,0,0,14,9.25Zm-.75,4h-2.5v-2.5h2.5Zm7.75-4H17a.76.76,0,0,0-.75.75v4a.76.76,0,0,0,.75.75h4a.76.76,0,0,0,.75-.75V10A.76.76,0,0,0,21,9.25Zm-.75,4h-2.5v-2.5h2.5Zm-6.25,3H10a.76.76,0,0,0-.75.75v4a.76.76,0,0,0,.75.75h4a.76.76,0,0,0,.75-.75V17A.76.76,0,0,0,14,16.25Zm-.75,4h-2.5v-2.5h2.5Z'
  }));
};

UilDialpad.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDialpad.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDialpadAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,9.25A2.75,2.75,0,1,0,7.75,12,2.75,2.75,0,0,0,5,9.25Zm0,4A1.25,1.25,0,1,1,6.25,12,1.25,1.25,0,0,1,5,13.25Zm7-4A2.75,2.75,0,1,0,14.75,12,2.75,2.75,0,0,0,12,9.25Zm0,4A1.25,1.25,0,1,1,13.25,12,1.25,1.25,0,0,1,12,13.25Zm7-5.5A2.75,2.75,0,1,0,16.25,5,2.75,2.75,0,0,0,19,7.75Zm0-4A1.25,1.25,0,1,1,17.75,5,1.25,1.25,0,0,1,19,3.75Zm0,5.5A2.75,2.75,0,1,0,21.75,12,2.75,2.75,0,0,0,19,9.25Zm0,4A1.25,1.25,0,1,1,20.25,12,1.25,1.25,0,0,1,19,13.25ZM5,2.25A2.75,2.75,0,1,0,7.75,5,2.75,2.75,0,0,0,5,2.25Zm0,4A1.25,1.25,0,1,1,6.25,5,1.25,1.25,0,0,1,5,6.25Zm7,10A2.75,2.75,0,1,0,14.75,19,2.75,2.75,0,0,0,12,16.25Zm0,4A1.25,1.25,0,1,1,13.25,19,1.25,1.25,0,0,1,12,20.25Zm0-18A2.75,2.75,0,1,0,14.75,5,2.75,2.75,0,0,0,12,2.25Zm0,4A1.25,1.25,0,1,1,13.25,5,1.25,1.25,0,0,1,12,6.25Z'
  }));
};

UilDialpadAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDialpadAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiamond = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,10.35,14.22,2.94A3.06,3.06,0,0,0,9.75,3L4,10.35A3.05,3.05,0,0,0,3.51,12,3.09,3.09,0,0,0,4,13.58l.06.07,5.74,7.41A3,3,0,0,0,12,22a3.06,3.06,0,0,0,2.26-1L20,13.65a3,3,0,0,0-.06-3.3Zm-1.57,2.14-5.67,7.22a1.11,1.11,0,0,1-1.42.07L5.65,12.47A1,1,0,0,1,5.51,12a1.11,1.11,0,0,1,.1-.45l5.67-7.22a1.11,1.11,0,0,1,1.42-.07l5.63,7.28a1,1,0,0,1,.16.54A1.11,1.11,0,0,1,18.39,12.49Z'
  }));
};

UilDiamond.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiamond.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiary = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,2H5A1,1,0,0,0,4,3V19a1,1,0,0,0,1,1H6v1a1,1,0,0,0,1,1H7a1,1,0,0,0,1-1V20h9a3,3,0,0,0,3-3V5A3,3,0,0,0,17,2ZM14,18H6V4h8Zm4-1a1,1,0,0,1-1,1H16V4h1a1,1,0,0,1,1,1Z'
  }));
};

UilDiary.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiary.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiaryAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,2H5A1,1,0,0,0,4,3V21a1,1,0,0,0,1,1H17a3,3,0,0,0,3-3V5A3,3,0,0,0,17,2ZM8,20H6V4H8Zm10-1a1,1,0,0,1-1,1H10V4h7a1,1,0,0,1,1,1Z'
  }));
};

UilDiaryAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiaryAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiceFive = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,2H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3ZM8,15a1,1,0,1,0,1,1A1,1,0,0,0,8,15Zm4-4a1,1,0,1,0,1,1A1,1,0,0,0,12,11ZM8,7A1,1,0,1,0,9,8,1,1,0,0,0,8,7Zm8,8a1,1,0,1,0,1,1A1,1,0,0,0,16,15Zm0-8a1,1,0,1,0,1,1A1,1,0,0,0,16,7Z'
  }));
};

UilDiceFive.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiceFive.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiceFour = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,14a1,1,0,1,0,1,1A1,1,0,0,0,15,14ZM9,8a1,1,0,1,0,1,1A1,1,0,0,0,9,8Zm0,6a1,1,0,1,0,1,1A1,1,0,0,0,9,14Zm6-6a1,1,0,1,0,1,1A1,1,0,0,0,15,8Zm2-6H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3Z'
  }));
};

UilDiceFour.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiceFour.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiceOne = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,2H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3Zm-8-6a1,1,0,1,0,1,1A1,1,0,0,0,12,11Z'
  }));
};

UilDiceOne.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiceOne.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiceSix = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,11a1,1,0,1,0,1,1A1,1,0,0,0,9,11Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,9,15ZM9,7a1,1,0,1,0,1,1A1,1,0,0,0,9,7Zm6,0a1,1,0,1,0,1,1A1,1,0,0,0,15,7Zm2-5H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3Zm-5-6a1,1,0,1,0,1,1A1,1,0,0,0,15,11Zm0,4a1,1,0,1,0,1,1A1,1,0,0,0,15,15Z'
  }));
};

UilDiceSix.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiceSix.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiceThree = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,11a1,1,0,1,0,1,1A1,1,0,0,0,12,11ZM8,7A1,1,0,1,0,9,8,1,1,0,0,0,8,7Zm9-5H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3Zm-4-2a1,1,0,1,0,1,1A1,1,0,0,0,16,15Z'
  }));
};

UilDiceThree.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiceThree.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiceTwo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,11a1,1,0,1,0,1,1A1,1,0,0,0,9,11Zm8-9H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3Zm-5-6a1,1,0,1,0,1,1A1,1,0,0,0,15,11Z'
  }));
};

UilDiceTwo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiceTwo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDirection = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.71,10.21,12,7.91l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-3-3a1,1,0,0,0-1.42,0l-3,3a1,1,0,0,0,1.42,1.42Zm4.58,4.58L12,17.09l-2.29-2.3a1,1,0,0,0-1.42,1.42l3,3a1,1,0,0,0,1.42,0l3-3a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilDirection.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDirection.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDirections = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.12,9.88l-7-7a3.08,3.08,0,0,0-4.24,0l-7,7a3,3,0,0,0,0,4.24l7,7a3,3,0,0,0,4.24,0l7-7A3,3,0,0,0,21.12,9.88Zm-1.41,2.83-7,7a1,1,0,0,1-1.42,0h0l-7-7a1,1,0,0,1,0-1.42l7-7a1,1,0,0,1,1.42,0l7,7A1,1,0,0,1,19.71,12.71Zm-5.5-3.42a1,1,0,0,0-1.42,1.42l.3.29H9.5a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V13h2.59l-.3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2-2a1,1,0,0,0,0-1.42Z'
  }));
};

UilDirections.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDirections.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDiscord = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.13831,10.62982h-.00013a1.05288,1.05288,0,1,0,.00013,0Zm3.75427,0a1.14582,1.14582,0,1,0,1.04907,1.14166A1.09586,1.09586,0,0,0,13.89258,10.62982Zm4.99878-8.6297H5.10864A2.11364,2.11364,0,0,0,3,4.119V18.02527A2.11368,2.11368,0,0,0,5.10864,20.1441H16.77258l-.54516-1.90289,1.31653,1.224,1.24462,1.152L21,22.57153V4.119A2.11364,2.11364,0,0,0,18.89136,2.00012ZM14.92114,15.43323v.00006s-.37036-.44232-.67895-.83319a3.2459,3.2459,0,0,0,1.86181-1.224,5.87837,5.87837,0,0,1-1.18286.60681,6.76974,6.76974,0,0,1-1.49145.44232,7.206,7.206,0,0,1-2.66394-.01025,8.64456,8.64456,0,0,1-1.51209-.44226,6.03735,6.03735,0,0,1-.75085-.34973c-.03089-.02063-.06165-.03089-.09253-.05146a.14171.14171,0,0,1-.04114-.03082c-.18506-.10284-.28809-.17487-.28809-.17487A3.19975,3.19975,0,0,0,9.8811,14.57953c-.30847.39093-.68908.8537-.68908.8537a3.72892,3.72892,0,0,1-3.13709-1.56342A13.775,13.775,0,0,1,7.536,7.87323a5.08641,5.08641,0,0,1,2.89026-1.08l.10278.12348A6.93762,6.93762,0,0,0,7.824,8.2641s.22632-.12341.60682-.29828a7.722,7.722,0,0,1,2.335-.64795,1.00465,1.00465,0,0,1,.17492-.02063,8.702,8.702,0,0,1,2.07764-.02051,8.384,8.384,0,0,1,3.096.98737,6.84576,6.84576,0,0,0-2.561-1.30628l.14392-.16449a5.08575,5.08575,0,0,1,2.89026,1.08,13.77368,13.77368,0,0,1,1.4812,5.99652A3.75972,3.75972,0,0,1,14.92114,15.43323Z'
  }));
};

UilDiscord.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDiscord.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDizzyMeh = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,11.71l.29-.3.29.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-.3-.29.3-.29A1,1,0,0,0,9.54,8.29l-.29.3L9,8.29A1,1,0,1,0,7.54,9.71l.3.29-.3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0ZM15,14H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM17,8.29a1,1,0,0,0-1.42,0l-.29.3L15,8.29a1,1,0,0,0-1.42,1.42l.3.29-.3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l.29-.3.29.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-.3-.29.3-.29A1,1,0,0,0,17,8.29Z'
  }));
};

UilDizzyMeh.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDizzyMeh.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDna = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.2,13.73a1,1,0,0,0-1.41-.05A11.18,11.18,0,0,0,4,22a1,1,0,0,0,2,0,9.15,9.15,0,0,1,3.15-6.86A1,1,0,0,0,9.2,13.73Zm10.17,4.64a10.86,10.86,0,0,0-1.6-3A14.31,14.31,0,0,0,14.06,12C16.3,10.57,20,7.4,20,2a1,1,0,0,0-2,0c0,5.4-4.59,8.17-6,8.89A13.42,13.42,0,0,1,9.31,9H12a1,1,0,0,0,0-2H7.55a9.39,9.39,0,0,1-1-2H15a1,1,0,0,0,0-2H6.06A8.14,8.14,0,0,1,6,2,1,1,0,0,0,4,2c0,7.57,7.3,10.79,7.61,10.92h0A12.93,12.93,0,0,1,14.7,15H12a1,1,0,0,0,0,2h4.43a9.07,9.07,0,0,1,1,2H9a1,1,0,0,0,0,2h8.94A8.26,8.26,0,0,1,18,22a1,1,0,0,0,2,0,10.5,10.5,0,0,0-.22-2.19A9.23,9.23,0,0,0,19.37,18.37Z'
  }));
};

UilDna.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDna.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDocumentInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,14a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V15A1,1,0,0,0,12,14Zm.38-2.92A1,1,0,0,0,11.8,11l-.18.06-.18.09-.15.12A1,1,0,0,0,11,12a1,1,0,0,0,.29.71,1,1,0,0,0,.33.21A.84.84,0,0,0,12,13a1,1,0,0,0,.71-.29A1,1,0,0,0,13,12a1,1,0,0,0-.29-.71A1.15,1.15,0,0,0,12.38,11.08ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilDocumentInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDocumentInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDocumentLayoutCenter = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,12h6a1,1,0,0,0,1-1V5a1,1,0,0,0-1-1H9A1,1,0,0,0,8,5v6A1,1,0,0,0,9,12Zm1-6h4v4H10Zm11,4H19a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2ZM19,8h2a1,1,0,0,0,0-2H19a1,1,0,0,0,0,2ZM3,8H5A1,1,0,0,0,5,6H3A1,1,0,0,0,3,8Zm0,4H5a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2Zm18,2H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm-8,4H3a1,1,0,0,0,0,2H13a1,1,0,0,0,0-2Z'
  }));
};

UilDocumentLayoutCenter.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDocumentLayoutCenter.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDocumentLayoutLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,12H9a1,1,0,0,0,1-1V5A1,1,0,0,0,9,4H3A1,1,0,0,0,2,5v6A1,1,0,0,0,3,12ZM4,6H8v4H4Zm9,2h8a1,1,0,0,0,0-2H13a1,1,0,0,0,0,2Zm0,10H3a1,1,0,0,0,0,2H13a1,1,0,0,0,0-2Zm8-4H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-4H13a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Z'
  }));
};

UilDocumentLayoutLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDocumentLayoutLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDocumentLayoutRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,18H3a1,1,0,0,0,0,2H13a1,1,0,0,0,0-2ZM3,8h8a1,1,0,0,0,0-2H3A1,1,0,0,0,3,8Zm0,4h8a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2Zm18,2H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM21,4H15a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V5A1,1,0,0,0,21,4Zm-1,6H16V6h4Z'
  }));
};

UilDocumentLayoutRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDocumentLayoutRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDollarAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11H13V7h2a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H13V3a1,1,0,0,0-2,0V5H10a4,4,0,0,0,0,8h1v4H9a1,1,0,0,1-1-1,1,1,0,0,0-2,0,3,3,0,0,0,3,3h2v2a1,1,0,0,0,2,0V19h1a4,4,0,0,0,0-8Zm-3,0H10a2,2,0,0,1,0-4h1Zm3,6H13V13h1a2,2,0,0,1,0,4Z'
  }));
};

UilDollarAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDollarAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDollarSign = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11H10a2,2,0,0,1,0-4h5a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H13V3a1,1,0,0,0-2,0V5H10a4,4,0,0,0,0,8h4a2,2,0,0,1,0,4H9a1,1,0,0,1-1-1,1,1,0,0,0-2,0,3,3,0,0,0,3,3h2v2a1,1,0,0,0,2,0V19h1a4,4,0,0,0,0-8Z'
  }));
};

UilDollarSign.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDollarSign.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDollarSignAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11H10a2,2,0,0,1,0-4h5a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H13V3a1,1,0,0,0-2,0V5H10a4,4,0,0,0,0,8h4a2,2,0,0,1,0,4H9a1,1,0,0,1-1-1,1,1,0,0,0-2,0,3,3,0,0,0,3,3h2v2a1,1,0,0,0,2,0V19h1a4,4,0,0,0,0-8Z'
  }));
};

UilDollarSignAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDollarSignAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDownloadAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.29,13.29a1,1,0,0,0,0,1.42l3,3a1,1,0,0,0,1.42,0l3-3a1,1,0,0,0-1.42-1.42L13,14.59V3a1,1,0,0,0-2,0V14.59l-1.29-1.3A1,1,0,0,0,8.29,13.29ZM18,9H16a1,1,0,0,0,0,2h2a1,1,0,0,1,1,1v7a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H8A1,1,0,0,0,8,9H6a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V12A3,3,0,0,0,18,9Z'
  }));
};

UilDownloadAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDownloadAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDraggabledots = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,10a2,2,0,1,0,2,2A2,2,0,0,0,8.5,10Zm0,7a2,2,0,1,0,2,2A2,2,0,0,0,8.5,17Zm7-10a2,2,0,1,0-2-2A2,2,0,0,0,15.5,7Zm-7-4a2,2,0,1,0,2,2A2,2,0,0,0,8.5,3Zm7,14a2,2,0,1,0,2,2A2,2,0,0,0,15.5,17Zm0-7a2,2,0,1,0,2,2A2,2,0,0,0,15.5,10Z'
  }));
};

UilDraggabledots.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDraggabledots.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDribbble = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,2a7.94,7.94,0,0,1,5.51,2.22A24.93,24.93,0,0,1,12.68,8.4,29.07,29.07,0,0,0,9.81,4.31,7.94,7.94,0,0,1,12,4ZM7.89,5.15A27.16,27.16,0,0,1,10.7,9a25.11,25.11,0,0,1-6,.74H4.34A8,8,0,0,1,7.89,5.15ZM6,17.31A7.9,7.9,0,0,1,4,12c0-.1,0-.2,0-.29h.68a26.67,26.67,0,0,0,7-1c.32.61.62,1.24.91,1.89a14.3,14.3,0,0,0-4.29,2.41l-.3.24A21,21,0,0,0,6,17.31ZM12,20a7.92,7.92,0,0,1-4.47-1.37,17.92,17.92,0,0,1,1.56-1.58l.32-.27a12.63,12.63,0,0,1,4-2.27,32,32,0,0,1,1.4,5A8.08,8.08,0,0,1,12,20Zm4.63-1.49a34.87,34.87,0,0,0-1.28-4.46l.34,0a.25.25,0,0,1,.12,0h.11l.1,0,.48,0a9.43,9.43,0,0,1,3.09.53A7.94,7.94,0,0,1,16.63,18.51ZM16.5,12c-.21,0-.42,0-.62,0a1.56,1.56,0,0,0-.39,0,6.64,6.64,0,0,0-.81.1h-.1c-.29-.67-.59-1.32-.92-2a26.57,26.57,0,0,0,5.13-2.4A8,8,0,0,1,20,12c0,.17,0,.34,0,.51A11.48,11.48,0,0,0,16.5,12Z'
  }));
};

UilDribbble.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDribbble.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDrill = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,4H9A1,1,0,0,0,8,5V7H3A1,1,0,0,0,3,9H8v4a1,1,0,0,0,2,0V12h4v7a1,1,0,0,0,1,1h2a3,3,0,0,0,3-3V11.82A3,3,0,0,0,22,9V7A3,3,0,0,0,19,4ZM18,17a1,1,0,0,1-1,1H16V12h2Zm2-8a1,1,0,0,1-1,1H10V6h6V7a1,1,0,0,0,2,0V6h1a1,1,0,0,1,1,1Z'
  }));
};

UilDrill.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDrill.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDropbox = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.61,11.81,18.36,9.28l3.26-2.56A1,1,0,0,0,22,5.86a1.06,1.06,0,0,0-.5-.8L16.36,2.13a1,1,0,0,0-1.15.12L12,5.05,8.79,2.25a1,1,0,0,0-1.15-.12L2.5,5.06a1.06,1.06,0,0,0-.5.8,1,1,0,0,0,.38.86L5.64,9.28,2.39,11.77a1,1,0,0,0-.39.86,1,1,0,0,0,.5.8l3.41,2v2.47a1,1,0,0,0,.48.85l5.09,3.13a1,1,0,0,0,1,0l5.09-3.13a1,1,0,0,0,.48-.85V15.42l3.41-1.95a1,1,0,0,0,.5-.8A1,1,0,0,0,21.61,11.81ZM16,4.22l3.23,1.84-2.55,2-3-1.84ZM14.91,9.34l-2.91,2-2.91-2L12,7.55ZM4.79,6.06,8,4.22l2.31,2-3,1.84Zm0,6.39,2.5-1.92,3,2.08L8.07,14.34Zm11.29,4.86L12,19.83,7.91,17.31v-.8a1,1,0,0,0,.85-.18L12,13.83l3.24,2.5a1,1,0,0,0,.61.21,1,1,0,0,0,.24,0Zm-.15-3L13.7,12.61l3-2.08,2.51,1.94Z'
  }));
};

UilDropbox.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDropbox.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilDumbbell = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.48,6.55v0h0L14.64,3.71a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l2.12,2.12-8.1,8.1L5.12,13.22a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l2.81,2.81v0h0l2.81,2.81a1,1,0,0,0,.71.3,1,1,0,0,0,.71-1.71L8.66,16.76l8.1-8.1,2.12,2.12a1,1,0,1,0,1.41-1.42ZM3.71,17.46a1,1,0,0,0-1.42,1.42l2.83,2.83a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42Zm18-12.34L18.88,2.29a1,1,0,0,0-1.42,1.42l2.83,2.83a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,5.12Z'
  }));
};

UilDumbbell.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilDumbbell.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEar = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,8a1.00067,1.00067,0,0,1,1,1,1,1,0,0,0,2,0,2.9995,2.9995,0,1,0-5.01758,2.2207c.01.0091.16113.16992.19336.21485a.9875.9875,0,0,1,0,1.11914.99952.99952,0,1,0,1.64844,1.13086,2.98332,2.98332,0,0,0-.00488-3.38867,7.12392,7.12392,0,0,0-.49122-.55665,1.05523,1.05523,0,0,1-.1582-.18164A1.00072,1.00072,0,0,1,12,8Zm0-6a7.0006,7.0006,0,0,0-6.76172,8.81152A.99989.99989,0,0,0,7.16992,10.294,5.00018,5.00018,0,1,1,17,9a5.11412,5.11412,0,0,1-.70508,2.56738L12.73145,19A2.00462,2.00462,0,0,1,11,20a2.027,2.027,0,0,1-2-2,1.99224,1.99224,0,0,1,.26855-.999,1.00065,1.00065,0,0,0-1.73242-1.002,3.9988,3.9988,0,1,0,6.96289,3.9336L18.0625,12.5A7.00044,7.00044,0,0,0,12,2Z'
  }));
};

UilEar.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEar.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,12a1,1,0,0,0-1,1v6a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4h6a1,1,0,0,0,0-2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V13A1,1,0,0,0,21,12ZM6,12.76V17a1,1,0,0,0,1,1h4.24a1,1,0,0,0,.71-.29l6.92-6.93h0L21.71,8a1,1,0,0,0,0-1.42L17.47,2.29a1,1,0,0,0-1.42,0L13.23,5.12h0L6.29,12.05A1,1,0,0,0,6,12.76ZM16.76,4.41l2.83,2.83L18.17,8.66,15.34,5.83ZM8,13.17l5.93-5.93,2.83,2.83L10.83,16H8Z'
  }));
};

UilEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEditAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5,18H9.24a1,1,0,0,0,.71-.29l6.92-6.93h0L19.71,8a1,1,0,0,0,0-1.42L15.47,2.29a1,1,0,0,0-1.42,0L11.23,5.12h0L4.29,12.05a1,1,0,0,0-.29.71V17A1,1,0,0,0,5,18ZM14.76,4.41l2.83,2.83L16.17,8.66,13.34,5.83ZM6,13.17l5.93-5.93,2.83,2.83L8.83,16H6ZM21,20H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilEditAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEditAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEllipsisH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,10a2,2,0,1,0,2,2A2,2,0,0,0,12,10ZM5,10a2,2,0,1,0,2,2A2,2,0,0,0,5,10Zm14,0a2,2,0,1,0,2,2A2,2,0,0,0,19,10Z'
  }));
};

UilEllipsisH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEllipsisH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEllipsisV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,7a2,2,0,1,0-2-2A2,2,0,0,0,12,7Zm0,10a2,2,0,1,0,2,2A2,2,0,0,0,12,17Zm0-7a2,2,0,1,0,2,2A2,2,0,0,0,12,10Z'
  }));
};

UilEllipsisV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEllipsisV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEmoji = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,11a1,1,0,1,0-1-1A1,1,0,0,0,15,11ZM9,11a1,1,0,1,0-1-1A1,1,0,0,0,9,11Zm3-9A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Zm4.28-7.12a1,1,0,0,0-1.4-.16A2.78,2.78,0,0,0,14,14H10.35a2.81,2.81,0,0,0-.88-1.31,1,1,0,0,0-1.36.2,1,1,0,0,0,.14,1.39A1,1,0,0,1,8.5,15a1.09,1.09,0,0,1-.25.72A1,1,0,1,0,9.5,17.28,2.89,2.89,0,0,0,10.34,16H14a2.72,2.72,0,0,0,.89,1.31,1,1,0,0,0,.57.18,1,1,0,0,0,.78-.38,1,1,0,0,0-.14-1.39,1,1,0,0,1-.25-.72,1.09,1.09,0,0,1,.25-.72A1,1,0,0,0,16.28,12.88Z'
  }));
};

UilEmoji.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEmoji.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnglishToChinese = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.022,7h1a1.0013,1.0013,0,0,1,1,1V9a1,1,0,0,0,2,0V8a3.00328,3.00328,0,0,0-3-3h-1a1,1,0,0,0,0,2Zm-4,9h-1a1.0013,1.0013,0,0,1-1-1V14a1,1,0,0,0-2,0v1a3.00328,3.00328,0,0,0,3,3h1a1,1,0,0,0,0-2Zm11-1a1,1,0,0,0,0-2h-3v-.5a1,1,0,0,0-2,0V13h-3a1,1,0,0,0,0,2h5.18427a6.72756,6.72756,0,0,1-1.22553,2.52667,6.66828,6.66828,0,0,1-.62915-.98272.99972.99972,0,1,0-1.77929.9121,8.67791,8.67791,0,0,0,.9591,1.468A6.6182,6.6182,0,0,1,13.10645,20.023a1.00008,1.00008,0,0,0,.42675,1.9541,8.63506,8.63506,0,0,0,3.445-1.62164,8.72368,8.72368,0,0,0,3.46857,1.62115,1,1,0,1,0,.43066-1.95312,6.72477,6.72477,0,0,1-2.4461-1.09009A8.73637,8.73637,0,0,0,20.24371,15ZM9.05176,11.24268a1.00011,1.00011,0,0,0,1.94043-.48536L9.23486,3.72754a2.28107,2.28107,0,0,0-4.42578,0L3.05176,10.75732a1.00011,1.00011,0,0,0,1.94043.48536L5.5528,9H8.49115ZM6.0528,7l.69671-2.78711a.2913.2913,0,0,1,.54492,0L7.99115,7Z'
  }));
};

UilEnglishToChinese.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnglishToChinese.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnter = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H7.41l1.3-1.29A1,1,0,0,0,7.29,9.29l-3,3a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l3,3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L7.41,14H17a3,3,0,0,0,3-3V7A1,1,0,0,0,19,6Z'
  }));
};

UilEnter.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnter.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelope = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4Zm-.41,2-5.88,5.88a1,1,0,0,1-1.42,0L5.41,6ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V7.41l5.88,5.88a3,3,0,0,0,4.24,0L20,7.41Z'
  }));
};

UilEnvelope.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelope.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeAdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,7h1V8a1,1,0,0,0,2,0V7h1a1,1,0,0,0,0-2H20V4a1,1,0,0,0-2,0V5H17a1,1,0,0,0,0,2Zm4,4a1,1,0,0,0-1,1v6a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.41L9.88,14.3a3,3,0,0,0,4.24,0l2.47-2.47a1,1,0,0,0-1.42-1.42L12.7,12.88a1,1,0,0,1-1.4,0L5.41,7H13a1,1,0,0,0,0-2H5A3,3,0,0,0,2,8V18a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V12A1,1,0,0,0,21,11Z'
  }));
};

UilEnvelopeAdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeAdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4ZM5,6H19a1,1,0,0,1,1,1l-8,4.88L4,7A1,1,0,0,1,5,6ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V9.28l7.48,4.57a1,1,0,0,0,1,0L20,9.28Z'
  }));
};

UilEnvelopeAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeBlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.5,13.26A5,5,0,1,0,14,11.79,5,5,0,0,0,17.5,13.26Zm2.12-2.88a3,3,0,0,1-3.4.58l4-4A3,3,0,0,1,19.62,10.38ZM15.38,6.14a3,3,0,0,1,2.12-.88,3,3,0,0,1,1.28.3l-4,4A3,3,0,0,1,15.38,6.14Zm5.12,8.12a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V9.67l5.88,5.88a3,3,0,0,0,2.11.88,3,3,0,0,0,2.16-.91,1,1,0,0,0,0-1.39,1,1,0,0,0-1.43,0,1,1,0,0,1-1.4,0L4.91,8.26H9.5a1,1,0,0,0,0-2h-5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3v-4A1,1,0,0,0,20.5,14.26Z'
  }));
};

UilEnvelopeBlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeBlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeBookmark = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,15.26a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V9.67l5.88,5.89a3,3,0,0,0,2.1.87,3,3,0,0,0,1.43-.36,1,1,0,0,0,.4-1.36,1,1,0,0,0-1.36-.4,1,1,0,0,1-1.15-.17L5.41,8.26H12a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-3A1,1,0,0,0,21,15.26Zm0-12H16a1,1,0,0,0-1,1v8a1,1,0,0,0,1.57.82l1.93-1.29,1.91,1.28a1.06,1.06,0,0,0,.59.19,1,1,0,0,0,.41-.09,1,1,0,0,0,.59-.91v-8A1,1,0,0,0,21,3.26Zm-1,7.12-.94-.63a1,1,0,0,0-1.12,0l-.94.63V5.26h3Z'
  }));
};

UilEnvelopeBookmark.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeBookmark.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16.29,8.71a1,1,0,0,0,1.42,0l4-4a1,1,0,1,0-1.42-1.42L17,6.59l-1.29-1.3a1,1,0,0,0-1.42,1.42ZM21,8a1,1,0,0,0-1,1v9a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.41L9.88,14.3a3,3,0,0,0,2.11.87,3.08,3.08,0,0,0,2.16-.9l1.72-1.72a1,1,0,1,0-1.42-1.42L12.7,12.88a1,1,0,0,1-1.4,0L5.41,7H11a1,1,0,0,0,0-2H5A3,3,0,0,0,2,8V18a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V9A1,1,0,0,0,21,8Z'
  }));
};

UilEnvelopeCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.5,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V9.41L9.38,15.3a3,3,0,0,0,4.24,0l1.64-1.64a1,1,0,1,0-1.42-1.42L12.2,13.88a1,1,0,0,1-1.4,0L4.91,8H11.5a1,1,0,0,0,0-2h-7a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3V15A1,1,0,0,0,20.5,14Zm1.71-6.71a1,1,0,0,0-1.42,0L19.5,8.59V3a1,1,0,0,0-2,0V8.59l-1.29-1.3a1,1,0,1,0-1.42,1.42l3,3a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3A1,1,0,0,0,22.21,7.29Z'
  }));
};

UilEnvelopeDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeDownloadAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.29,8.79a1,1,0,0,0,1.42,0l2-2a1,1,0,0,0,0-1.41,1,1,0,0,0-1.42,0L13,5.67V2.92a1,1,0,0,0-2,0V5.67l-.29-.29a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41ZM16,11.08H8a3,3,0,0,0-3,3v5a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3v-5A3,3,0,0,0,16,11.08Zm-.42,2L12.7,16a1,1,0,0,1-1.4,0L8.42,13.08Zm1.42,6a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V14.49l2.88,2.88a3,3,0,0,0,4.24,0L17,14.49Z'
  }));
};

UilEnvelopeDownloadAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeDownloadAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11.51h2.42a1,1,0,0,0,.71-.29l4.58-4.58a1,1,0,0,0,0-1.42L19.29,2.8a1,1,0,0,0-1.42,0L13.29,7.38a1.05,1.05,0,0,0-.29.71v2.42A1,1,0,0,0,14,11.51Zm1-3,3.58-3.58,1,1L16,9.51H15Zm6,2a1,1,0,0,0-1,1v7a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.9l5.88,5.89a3,3,0,0,0,4.27,0,1,1,0,0,0,0-1.4,1,1,0,0,0-1.43,0,1,1,0,0,1-1.4,0L5.41,7.49H10a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-7A1,1,0,0,0,21,10.49Z'
  }));
};

UilEnvelopeEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,13.5a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.91l5.88,5.88a3,3,0,0,0,4.24,0l3.59-3.58a1,1,0,0,0-1.42-1.42l-3.58,3.59a1,1,0,0,1-1.42,0L5.41,7.5H17a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-4A1,1,0,0,0,21,13.5Zm0-11a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0v-4A1,1,0,0,0,21,2.5Zm-.2,7a.64.64,0,0,0-.18.06.76.76,0,0,0-.18.09l-.15.12a1.05,1.05,0,0,0-.29.71,1.23,1.23,0,0,0,0,.19.6.6,0,0,0,.06.19.76.76,0,0,0,.09.18,1.58,1.58,0,0,0,.12.15,1,1,0,0,0,1.42,0l.12-.15a.76.76,0,0,0,.09-.18.6.6,0,0,0,.06-.19,1.23,1.23,0,0,0,0-.19,1,1,0,0,0-1.2-1Z'
  }));
};

UilEnvelopeExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.5,13a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V8.41L9.38,14.3a3,3,0,0,0,2.11.87,3,3,0,0,0,2.15-.9l.89-.88A1,1,0,0,0,13.13,12l-.93.91a1,1,0,0,1-1.4,0L4.91,7H9.5a1,1,0,0,0,0-2h-5a3,3,0,0,0-3,3V18a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3V14A1,1,0,0,0,20.5,13Zm1.05-9a3.33,3.33,0,0,0-3.88-.54,3.25,3.25,0,0,0-3.88,5.13L17,11.71a1.05,1.05,0,0,0,.71.29,1,1,0,0,0,.71-.29l3.17-3.17A3.26,3.26,0,0,0,21.55,4ZM20.14,7.12,17.67,9.59,15.21,7.12A1.24,1.24,0,0,1,17,5.36a1,1,0,0,0,1.42,0,1.28,1.28,0,0,1,1.76,0A1.26,1.26,0,0,1,20.14,7.12Z'
  }));
};

UilEnvelopeHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,13.5a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.91l5.88,5.88a3,3,0,0,0,4.24,0l3.59-3.58a1,1,0,0,0-1.42-1.42l-3.58,3.59a1,1,0,0,1-1.42,0L5.41,7.5H17a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-4A1,1,0,0,0,21,13.5Zm0-9a1.05,1.05,0,0,0,.71-.29l.12-.16a.56.56,0,0,0,.09-.17A.64.64,0,0,0,22,3.7a1.36,1.36,0,0,0,0-.2,1.05,1.05,0,0,0-.29-.71,1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.42A1.05,1.05,0,0,0,21,4.5Zm0,1a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0v-4A1,1,0,0,0,21,5.5Z'
  }));
};

UilEnvelopeInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.5,7.44V6.26a3,3,0,1,0-6,0V7.44a3,3,0,0,0-2,2.82v2a3,3,0,0,0,3,3h4a3,3,0,0,0,3-3v-2A3,3,0,0,0,20.5,7.44Zm-4-1.18a1,1,0,1,1,2,0v1h-2Zm4,6a1,1,0,0,1-1,1h-4a1,1,0,0,1-1-1v-2a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1Zm0,5a1,1,0,0,0-1,1v1a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V9.67l5.88,5.88a1,1,0,0,0,1.42-1.41L4.91,8.26H10.5a1,1,0,0,0,0-2h-6a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3v-1A1,1,0,0,0,20.5,17.26Z'
  }));
};

UilEnvelopeLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,8a1,1,0,0,0-1,1v8a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V7.41l5.88,5.88a3,3,0,0,0,4.24,0l3.59-3.58a1,1,0,0,0-1.42-1.42l-3.58,3.59a1,1,0,0,1-1.42,0L5.41,6H13a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V9A1,1,0,0,0,21,8ZM17,6h4a1,1,0,0,0,0-2H17a1,1,0,0,0,0,2Z'
  }));
};

UilEnvelopeMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeOpen = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.21,8.82h0l0,0h0L14,2.78a2.83,2.83,0,0,0-3.9,0l-6.21,6h0v0A2.6,2.6,0,0,0,3,10.71v8.58A2.75,2.75,0,0,0,5.78,22H18.22A2.75,2.75,0,0,0,21,19.29V10.71A2.67,2.67,0,0,0,20.21,8.82Zm-8.77-4.6a.83.83,0,0,1,1.12,0L18,9.5l-5.47,5.28a.83.83,0,0,1-1.12,0L6,9.5ZM19,19.29a.76.76,0,0,1-.78.71H5.78A.76.76,0,0,1,5,19.29V11.35l4.05,3.9-1.66,1.6a1,1,0,0,0,0,1.41,1,1,0,0,0,.72.31,1,1,0,0,0,.69-.28l1.77-1.7a2.8,2.8,0,0,0,2.92,0l1.77,1.7a1,1,0,0,0,.69.28,1,1,0,0,0,.72-.31,1,1,0,0,0,0-1.41L15,15.25l4-3.9Z'
  }));
};

UilEnvelopeOpen.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeOpen.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16.77,5.37A1,1,0,0,0,18.13,5,1,1,0,0,1,19,4.5a1,1,0,0,1,0,2,1,1,0,0,0,0,2A3,3,0,1,0,16.4,4,1,1,0,0,0,16.77,5.37ZM21,13.5a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.91L9.88,14.8a3,3,0,0,0,4.24,0l1.64-1.64a1,1,0,1,0-1.42-1.42L12.7,13.38a1,1,0,0,1-1.4,0L5.41,7.5H13a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-4A1,1,0,0,0,21,13.5ZM18.29,9.79a1,1,0,0,0,0,1.42l.15.12a.76.76,0,0,0,.18.09.64.64,0,0,0,.18.06l.2,0a1,1,0,0,0,.71-1.71A1,1,0,0,0,18.29,9.79Z'
  }));
};

UilEnvelopeQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeReceive = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.29,6.21l2,2a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-.3-.29H15a1,1,0,0,0,0-2H11.41l.3-.29a1,1,0,1,0-1.42-1.42l-2,2a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76A1,1,0,0,0,8.29,6.21ZM16,10.5H8a3,3,0,0,0-3,3v5a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3v-5A3,3,0,0,0,16,10.5Zm-.42,2L12.7,15.38a1,1,0,0,1-1.4,0L8.42,12.5Zm1.42,6a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V13.91l2.88,2.87a2.94,2.94,0,0,0,2.12.89,3,3,0,0,0,2.12-.88L17,13.91Z'
  }));
};

UilEnvelopeReceive.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeReceive.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeRedo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.5,14.26a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V9.67l5.88,5.88a3,3,0,0,0,2.11.88,3,3,0,0,0,2.16-.91,1,1,0,0,0,0-1.39,1,1,0,0,0-1.43,0,1,1,0,0,1-1.4,0L4.91,8.26H9.5a1,1,0,0,0,0-2h-5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3v-4A1,1,0,0,0,20.5,14.26Zm1-11a1,1,0,0,0-1,1h0a5,5,0,1,0-3,9A5,5,0,0,0,20.8,12a1,1,0,0,0-1.32-1.51,3,3,0,1,1,.25-4.24H18.5a1,1,0,0,0,0,2h3a1,1,0,0,0,1-1v-3A1,1,0,0,0,21.5,3.26Z'
  }));
};

UilEnvelopeRedo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeRedo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeSearch = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.21,10.29,20.48,8.57a4.37,4.37,0,0,0,.65-2.26,4.31,4.31,0,1,0-4.32,4.32A4.37,4.37,0,0,0,19.07,10l1.72,1.73a1,1,0,0,0,1.42,0A1,1,0,0,0,22.21,10.29ZM18.45,8a2.37,2.37,0,0,1-3.27,0,2.3,2.3,0,0,1-.68-1.64A2.32,2.32,0,0,1,16.81,4a2.3,2.3,0,0,1,1.64.68,2.28,2.28,0,0,1,.68,1.63A2.3,2.3,0,0,1,18.45,8ZM20.5,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V9.41L9.38,15.3a3,3,0,0,0,4.24,0L15,13.88a1,1,0,0,0-1.42-1.42L12.2,13.88a1,1,0,0,1-1.4,0L4.91,8H9.5a1,1,0,0,0,0-2h-5a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3V15A1,1,0,0,0,20.5,14Z'
  }));
};

UilEnvelopeSearch.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeSearch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeSend = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,10.5H8a3,3,0,0,0-3,3v5a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3v-5A3,3,0,0,0,16,10.5Zm-.42,2L12.7,15.38a1,1,0,0,1-1.4,0L8.42,12.5Zm1.42,6a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V13.91l2.88,2.87a2.94,2.94,0,0,0,2.12.89,3,3,0,0,0,2.12-.88L17,13.91ZM9,6.5h3.59l-.3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2-2a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-2-2a1,1,0,0,0-1.42,1.42l.3.29H9a1,1,0,0,0,0,2Z'
  }));
};

UilEnvelopeSend.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeSend.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeShare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V9.41L8.88,15.3a3,3,0,0,0,2.11.87,3.08,3.08,0,0,0,2.16-.9l1.72-1.72a1,1,0,1,0-1.42-1.42L11.7,13.88a1,1,0,0,1-1.4,0L4.41,8H10a1,1,0,0,0,0-2H4A3,3,0,0,0,1,9V19a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V15A1,1,0,0,0,20,14Zm0-6a2,2,0,0,0-1.18.39l-1.75-.8L19,6.71A2,2,0,0,0,20,7a2,2,0,1,0-2-2l-1.9.87A2,2,0,0,0,15,5.5a2,2,0,0,0,0,4,1.88,1.88,0,0,0,.92-.24l2.1,1A2,2,0,1,0,20,8Z'
  }));
};

UilEnvelopeShare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeShare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeShield = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.63,5.12a1,1,0,0,0-.84-.2,2.74,2.74,0,0,1-2.2-.46,1,1,0,0,0-1.18,0,2.74,2.74,0,0,1-2.2.46A1,1,0,0,0,14,5.9V9.21a4.62,4.62,0,0,0,1.84,3.7l1.57,1.16a1,1,0,0,0,1.18,0l1.57-1.16A4.62,4.62,0,0,0,22,9.21V5.9A1,1,0,0,0,21.63,5.12ZM20,9.21a2.61,2.61,0,0,1-1,2.09L18,12l-1-.72a2.61,2.61,0,0,1-1-2.09V7a4.67,4.67,0,0,0,2-.54A4.67,4.67,0,0,0,20,7Zm1,6a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V9.67l5.88,5.88a3,3,0,0,0,2.11.88,3,3,0,0,0,2.15-.9l-.7-.71-.74-.68a1,1,0,0,1-1.4,0L5.41,8.26H11a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-3A1,1,0,0,0,21,15.26Z'
  }));
};

UilEnvelopeShield.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeShield.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeStar = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.64,9.74l-.29,1.73A1.55,1.55,0,0,0,14,13a1.46,1.46,0,0,0,1.58.09L17,12.28l1.44.79A1.46,1.46,0,0,0,20,13a1.55,1.55,0,0,0,.63-1.51l-.29-1.73,1.2-1.22a1.54,1.54,0,0,0-.85-2.6l-1.62-.24-.73-1.55a1.5,1.5,0,0,0-2.72,0l-.73,1.55-1.62.24a1.54,1.54,0,0,0-.85,2.6Zm1.83-2.13a1.51,1.51,0,0,0,1.14-.85L17,5.93l.39.83a1.55,1.55,0,0,0,1.14.86l1,.14-.73.74a1.57,1.57,0,0,0-.42,1.34l.16,1-.79-.43a1.48,1.48,0,0,0-1.44,0l-.79.43.16-1a1.54,1.54,0,0,0-.42-1.33l-.73-.75ZM21,15.26a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V9.67l5.88,5.88a2.94,2.94,0,0,0,2.1.88l.27,0a1,1,0,0,0,.91-1.08,1,1,0,0,0-1.09-.91.94.94,0,0,1-.77-.28L5.41,8.26H9a1,1,0,0,0,0-2H5a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-3A1,1,0,0,0,21,15.26Z'
  }));
};

UilEnvelopeStar.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeStar.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11a1,1,0,0,0-1,1v6a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8.41L9.88,14.3a3,3,0,0,0,2.11.87,3.08,3.08,0,0,0,2.16-.9l1.72-1.72a1,1,0,1,0-1.42-1.42L12.7,12.88a1,1,0,0,1-1.4,0L5.41,7H13a1,1,0,0,0,0-2H5A3,3,0,0,0,2,8V18a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V12A1,1,0,0,0,21,11Zm-.59-5,1.3-1.29a1,1,0,1,0-1.42-1.42L19,4.59l-1.29-1.3a1,1,0,0,0-1.42,1.42L17.59,6l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L19,7.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z'
  }));
};

UilEnvelopeTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.5,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H4.5a1,1,0,0,1-1-1V9.41L9.38,15.3a3,3,0,0,0,4.24,0l1.64-1.64a1,1,0,1,0-1.42-1.42L12.2,13.88a1,1,0,0,1-1.4,0L4.91,8H11.5a1,1,0,0,0,0-2h-7a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h14a3,3,0,0,0,3-3V15A1,1,0,0,0,20.5,14Zm1.71-8.71-3-3a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3a1,1,0,0,0,1.42,1.42l1.29-1.3V11a1,1,0,0,0,2,0V5.41l1.29,1.3a1,1,0,0,0,1.42,0A1,1,0,0,0,22.21,5.29Z'
  }));
};

UilEnvelopeUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopeUploadAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,11.08H8a3,3,0,0,0-3,3v5a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3v-5A3,3,0,0,0,16,11.08Zm-.42,2L12.7,16a1,1,0,0,1-1.4,0L8.42,13.08Zm1.42,6a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V14.49l2.88,2.88a3,3,0,0,0,4.24,0L17,14.49ZM10.71,5.62,11,5.33V8.08a1,1,0,0,0,2,0V5.33l.29.29a1,1,0,1,0,1.42-1.41l-2-2a1,1,0,0,0-1.42,0l-2,2a1,1,0,0,0,0,1.41A1,1,0,0,0,10.71,5.62Z'
  }));
};

UilEnvelopeUploadAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopeUploadAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEnvelopes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,21.63H5a3,3,0,0,1-3-3v-8a1,1,0,0,0-2,0v8a5,5,0,0,0,5,5H17a1,1,0,0,0,0-2Zm4-18H7a3,3,0,0,0-3,3v10a3,3,0,0,0,3,3H21a3,3,0,0,0,3-3v-10A3,3,0,0,0,21,3.63Zm-.41,2-5.88,5.88a1,1,0,0,1-1.42,0L7.41,5.63Zm1.41,11a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V7l5.88,5.88a3,3,0,0,0,4.24,0L22,7Z'
  }));
};

UilEnvelopes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEnvelopes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEqualCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,13H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0-4H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilEqualCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEqualCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEuro = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.2,17.41A6,6,0,0,1,14.46,20c-2.68,0-5-2-6-5H14a1,1,0,0,0,0-2H8.05c0-.33-.05-.67-.05-1s0-.67.05-1H14a1,1,0,0,0,0-2H8.47c1-3,3.31-5,6-5A6,6,0,0,1,19.2,6.59a1,1,0,1,0,1.6-1.18A7.92,7.92,0,0,0,14.46,2c-3.76,0-7,2.84-8.07,7H4a1,1,0,0,0,0,2H6.05c0,.33,0,.67,0,1s0,.67,0,1H4a1,1,0,0,0,0,2H6.39c1.09,4.16,4.31,7,8.07,7a7.92,7.92,0,0,0,6.34-3.41,1,1,0,0,0-1.6-1.18Z'
  }));
};

UilEuro.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEuro.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEuroCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,20a9,9,0,1,1,9-9A9,9,0,0,1,12,21Zm.59-13.33a3.34,3.34,0,0,1,2.62,1.38,1,1,0,0,0,1.4.19,1,1,0,0,0,.18-1.41,5.32,5.32,0,0,0-4.2-2.16A5.57,5.57,0,0,0,7.46,9.5H6a1,1,0,0,0,0,2H7c0,.17,0,.33,0,.5s0,.33,0,.5H6a1,1,0,0,0,0,2H7.46a5.57,5.57,0,0,0,5.13,3.83,5.32,5.32,0,0,0,4.2-2.16A1,1,0,1,0,15.21,15a3.34,3.34,0,0,1-2.62,1.38A3.42,3.42,0,0,1,9.67,14.5H12a1,1,0,0,0,0-2H9.05A4.23,4.23,0,0,1,9,12a4.23,4.23,0,0,1,.05-.5H12a1,1,0,0,0,0-2H9.67A3.42,3.42,0,0,1,12.59,7.67Z'
  }));
};

UilEuroCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEuroCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExchange = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,10a1,1,0,0,0-1-1H5.41l2.3-2.29A1,1,0,0,0,6.29,5.29l-4,4a1,1,0,0,0-.21,1.09A1,1,0,0,0,3,11H17A1,1,0,0,0,18,10Zm3.92,3.62A1,1,0,0,0,21,13H7a1,1,0,0,0,0,2H18.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4A1,1,0,0,0,21.92,13.62Z'
  }));
};

UilExchange.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExchange.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExchangeAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,9.29l-4-4a1,1,0,0,0-1.42,1.42L18.59,9H7a1,1,0,0,0,0,2H21a1,1,0,0,0,.92-.62A1,1,0,0,0,21.71,9.29ZM17,13H3a1,1,0,0,0-.92.62,1,1,0,0,0,.21,1.09l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,15H17a1,1,0,0,0,0-2Z'
  }));
};

UilExchangeAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExchangeAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,14a1,1,0,0,0,1-1V7a1,1,0,0,0-2,0v6A1,1,0,0,0,12,14Zm0,4a1.25,1.25,0,1,0-1.25-1.25A1.25,1.25,0,0,0,12,18Z'
  }));
};

UilExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExclamationCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,14a1.25,1.25,0,1,0,1.25,1.25A1.25,1.25,0,0,0,12,14Zm0-1.5a1,1,0,0,0,1-1v-3a1,1,0,0,0-2,0v3A1,1,0,0,0,12,12.5ZM12,2A10,10,0,1,0,22,12,10.01114,10.01114,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilExclamationCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExclamationCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExclamationOctagon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,7a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V8A1,1,0,0,0,12,7Zm0,8a1,1,0,1,0,1,1A1,1,0,0,0,12,15Zm9.71-7.44L16.44,2.29A1.05,1.05,0,0,0,15.73,2H8.27a1.05,1.05,0,0,0-.71.29L2.29,7.56A1.05,1.05,0,0,0,2,8.27v7.46a1.05,1.05,0,0,0,.29.71l5.27,5.27a1.05,1.05,0,0,0,.71.29h7.46a1.05,1.05,0,0,0,.71-.29l5.27-5.27a1.05,1.05,0,0,0,.29-.71V8.27A1.05,1.05,0,0,0,21.71,7.56ZM20,15.31,15.31,20H8.69L4,15.31V8.69L8.69,4h6.62L20,8.69Z'
  }));
};

UilExclamationOctagon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExclamationOctagon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExclamationTriangle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,16a1,1,0,1,0,1,1A1,1,0,0,0,12,16Zm10.67,1.47-8.05-14a3,3,0,0,0-5.24,0l-8,14A3,3,0,0,0,3.94,22H20.06a3,3,0,0,0,2.61-4.53Zm-1.73,2a1,1,0,0,1-.88.51H3.94a1,1,0,0,1-.88-.51,1,1,0,0,1,0-1l8-14a1,1,0,0,1,1.78,0l8.05,14A1,1,0,0,1,20.94,19.49ZM12,8a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V9A1,1,0,0,0,12,8Z'
  }));
};

UilExclamationTriangle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExclamationTriangle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExclude = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.54,7.54h-1a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0,1,1,0,1,0,0-2Zm5.92,5.92a1,1,0,0,0-1,1,1,1,0,0,0,0,2h1a1,1,0,0,0,1-1v-1A1,1,0,0,0,15.46,13.46ZM21,7.54H16.46V3a1,1,0,0,0-1-1H3A1,1,0,0,0,2,3V15.46a1,1,0,0,0,1,1H7.54V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V8.54A1,1,0,0,0,21,7.54ZM20,20H9.54V16.46a1,1,0,0,0,0-2,1,1,0,0,0-2,0H4V4H14.46V7.54a1,1,0,0,0,0,2,1,1,0,0,0,2,0H20Z'
  }));
};

UilExclude.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExclude.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExpandAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.79,12.79,4,18.59V17a1,1,0,0,0-2,0v4a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54A1,1,0,0,0,3,22H7a1,1,0,0,0,0-2H5.41l5.8-5.79a1,1,0,0,0-1.42-1.42ZM21.92,2.62a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H17a1,1,0,0,0,0,2h1.59l-5.8,5.79a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V7a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z'
  }));
};

UilExpandAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExpandAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExpandArrows = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,8a1,1,0,0,0,1-1V3a1,1,0,0,0-.08-.38,1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H17a1,1,0,0,0,0,2h1.59L12,10.59,5.41,4H7A1,1,0,0,0,7,2H3a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,2,3V7A1,1,0,0,0,4,7V5.41L10.59,12,4,18.59V17a1,1,0,0,0-2,0v4a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54A1,1,0,0,0,3,22H7a1,1,0,0,0,0-2H5.41L12,13.41,18.59,20H17a1,1,0,0,0,0,2h4a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V17a1,1,0,0,0-2,0v1.59L13.41,12,20,5.41V7A1,1,0,0,0,21,8Z'
  }));
};

UilExpandArrows.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExpandArrows.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExpandArrowsAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.29,13.29,4,18.59V17a1,1,0,0,0-2,0v4a1,1,0,0,0,.08.38,1,1,0,0,0,.54.54A1,1,0,0,0,3,22H7a1,1,0,0,0,0-2H5.41l5.3-5.29a1,1,0,0,0-1.42-1.42ZM5.41,4H7A1,1,0,0,0,7,2H3a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,2,3V7A1,1,0,0,0,4,7V5.41l5.29,5.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM21,16a1,1,0,0,0-1,1v1.59l-5.29-5.3a1,1,0,0,0-1.42,1.42L18.59,20H17a1,1,0,0,0,0,2h4a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V17A1,1,0,0,0,21,16Zm.92-13.38a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H17a1,1,0,0,0,0,2h1.59l-5.3,5.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V7a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z'
  }));
};

UilExpandArrowsAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExpandArrowsAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExpandFromCorner = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,12H3a1,1,0,0,0-1,1v8a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V13A1,1,0,0,0,11,12Zm-1,8H4V14h6ZM21.92,2.62a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H15a1,1,0,0,0,0,2h3.59l-5.3,5.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z'
  }));
};

UilExpandFromCorner.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExpandFromCorner.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExpandLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.17,10.17a1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42L5.41,4H7A1,1,0,0,0,7,2H3a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,2,3V7A1,1,0,0,0,4,7V5.41L8.46,9.88A1,1,0,0,0,9.17,10.17Zm6.37-1.71a1,1,0,0,0-1.42,0L8.46,14.12a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l5.66-5.66A1,1,0,0,0,15.54,8.46ZM21,16a1,1,0,0,0-1,1v1.59l-4.46-4.47a1,1,0,1,0-1.42,1.42L18.59,20H17a1,1,0,0,0,0,2h4a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V17A1,1,0,0,0,21,16Z'
  }));
};

UilExpandLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExpandLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExpandRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.5,14.1L4,18.6V17c0-0.6-0.4-1-1-1s-1,0.4-1,1v4c0,0.1,0,0.3,0.1,0.4c0.1,0.2,0.3,0.4,0.5,0.5C2.7,22,2.9,22,3,22h4c0.6,0,1-0.4,1-1s-0.4-1-1-1H5.4l4.5-4.5c0.4-0.4,0.4-1,0-1.4C9.5,13.7,8.9,13.7,8.5,14.1z M21.7,2.3C21.7,2.3,21.7,2.3,21.7,2.3C21.5,2.1,21.2,2,21,2h-4c-0.6,0-1,0.4-1,1s0.4,1,1,1h1.6l-4.5,4.5c-0.4,0.4-0.4,1,0,1.4l0,0c0.2,0.2,0.4,0.3,0.7,0.3c0.3,0,0.5-0.1,0.7-0.3L20,5.4V7c0,0.6,0.4,1,1,1s1-0.4,1-1V3C22,2.8,21.9,2.5,21.7,2.3z M15.5,14.1L9.9,8.5c-0.4-0.4-1-0.4-1.4,0c-0.4,0.4-0.4,1,0,1.4l5.7,5.7c0.2,0.2,0.4,0.3,0.7,0.3c0.3,0,0.5-0.1,0.7-0.3C15.9,15.2,15.9,14.5,15.5,14.1C15.5,14.1,15.5,14.1,15.5,14.1z'
  }));
};

UilExpandRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExpandRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExport = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.71,7.71,11,5.41V15a1,1,0,0,0,2,0V5.41l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-4-4a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-4,4A1,1,0,1,0,8.71,7.71ZM21,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v4a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V15A1,1,0,0,0,21,14Z'
  }));
};

UilExport.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExport.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExposureAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,6H7A1,1,0,0,0,7,8h4a1,1,0,0,0,0-2Zm8-4H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM4,18.59V5A1,1,0,0,1,5,4H18.59ZM20,19a1,1,0,0,1-1,1H5.41L20,5.41Zm-7-2h1v1a1,1,0,0,0,2,0V17h1a1,1,0,0,0,0-2H16V14a1,1,0,0,0-2,0v1H13a1,1,0,0,0,0,2Z'
  }));
};

UilExposureAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExposureAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExposureIncrease = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,7H10V6A1,1,0,0,0,8,6V7H7A1,1,0,0,0,7,9H8v1a1,1,0,0,0,2,0V9h1a1,1,0,0,0,0-2Zm2,11h4a1,1,0,0,0,0-2H13a1,1,0,0,0,0,2ZM19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM4,18.59V5A1,1,0,0,1,5,4H18.59ZM20,19a1,1,0,0,1-1,1H5.41L20,5.41Z'
  }));
};

UilExposureIncrease.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExposureIncrease.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilExternalLinkAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,10.82a1,1,0,0,0-1,1V19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8A1,1,0,0,1,5,7h7.18a1,1,0,0,0,0-2H5A3,3,0,0,0,2,8V19a3,3,0,0,0,3,3H16a3,3,0,0,0,3-3V11.82A1,1,0,0,0,18,10.82Zm3.92-8.2a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H15a1,1,0,0,0,0,2h3.59L8.29,14.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z'
  }));
};

UilExternalLinkAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilExternalLinkAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEye = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.92,11.6C19.9,6.91,16.1,4,12,4S4.1,6.91,2.08,11.6a1,1,0,0,0,0,.8C4.1,17.09,7.9,20,12,20s7.9-2.91,9.92-7.6A1,1,0,0,0,21.92,11.6ZM12,18c-3.17,0-6.17-2.29-7.9-6C5.83,8.29,8.83,6,12,6s6.17,2.29,7.9,6C18.17,15.71,15.17,18,12,18ZM12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14Z'
  }));
};

UilEye.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEye.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilEyeSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.94,6.08A6.93,6.93,0,0,1,12,6c3.18,0,6.17,2.29,7.91,6a15.23,15.23,0,0,1-.9,1.64,1,1,0,0,0-.16.55,1,1,0,0,0,1.86.5,15.77,15.77,0,0,0,1.21-2.3,1,1,0,0,0,0-.79C19.9,6.91,16.1,4,12,4a7.77,7.77,0,0,0-1.4.12,1,1,0,1,0,.34,2ZM3.71,2.29A1,1,0,0,0,2.29,3.71L5.39,6.8a14.62,14.62,0,0,0-3.31,4.8,1,1,0,0,0,0,.8C4.1,17.09,7.9,20,12,20a9.26,9.26,0,0,0,5.05-1.54l3.24,3.25a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm6.36,9.19,2.45,2.45A1.81,1.81,0,0,1,12,14a2,2,0,0,1-2-2A1.81,1.81,0,0,1,10.07,11.48ZM12,18c-3.18,0-6.17-2.29-7.9-6A12.09,12.09,0,0,1,6.8,8.21L8.57,10A4,4,0,0,0,14,15.43L15.59,17A7.24,7.24,0,0,1,12,18Z'
  }));
};

UilEyeSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilEyeSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFacebook = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.9,2H3.1A1.1,1.1,0,0,0,2,3.1V20.9A1.1,1.1,0,0,0,3.1,22h9.58V14.25h-2.6v-3h2.6V9a3.64,3.64,0,0,1,3.88-4,20.26,20.26,0,0,1,2.33.12v2.7H17.3c-1.26,0-1.5.6-1.5,1.47v1.93h3l-.39,3H15.8V22h5.1A1.1,1.1,0,0,0,22,20.9V3.1A1.1,1.1,0,0,0,20.9,2Z'
  }));
};

UilFacebook.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFacebook.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFacebookF = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.12,5.32H17V2.14A26.11,26.11,0,0,0,14.26,2C11.54,2,9.68,3.66,9.68,6.7V9.32H6.61v3.56H9.68V22h3.68V12.88h3.06l.46-3.56H13.36V7.05C13.36,6,13.64,5.32,15.12,5.32Z'
  }));
};

UilFacebookF.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFacebookF.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFacebookMessenger = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A9.65,9.65,0,0,0,2,11.7a9.51,9.51,0,0,0,3.14,7.18.81.81,0,0,1,.27.56l0,1.78a.81.81,0,0,0,1.13.71l2-.87a.75.75,0,0,1,.53,0,11,11,0,0,0,2.9.38A9.7,9.7,0,1,0,12,2Zm6,7.46-2.93,4.66a1.5,1.5,0,0,1-2.17.4l-2.34-1.75a.6.6,0,0,0-.72,0l-3.16,2.4A.47.47,0,0,1,6,14.54L8.93,9.88a1.5,1.5,0,0,1,2.17-.4l2.34,1.75a.6.6,0,0,0,.72,0l3.16-2.4A.47.47,0,0,1,18,9.46Z'
  }));
};

UilFacebookMessenger.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFacebookMessenger.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFacebookMessengerAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.99121,1.00044a10.61443,10.61443,0,0,0-11,10.70019,10.46132,10.46132,0,0,0,3.41406,7.86524L4.457,21.2563a1.79959,1.79959,0,0,0,1.79883,1.74316,1.81992,1.81992,0,0,0,.72656-.15234l1.9209-.84668a11.89548,11.89548,0,0,0,3.08789.40039,10.61525,10.61525,0,0,0,11.001-10.7002A10.61525,10.61525,0,0,0,11.99121,1.00044Zm0,19.40039a9.86205,9.86205,0,0,1-2.63476-.35059,1.79856,1.79856,0,0,0-1.19629.0918l-1.71387.75586-.04492-1.49316a1.80968,1.80968,0,0,0-.60157-1.27442,8.4876,8.4876,0,0,1-2.80859-6.42969,8.65949,8.65949,0,0,1,9-8.70019,8.70522,8.70522,0,1,1,0,17.40039ZM15.72559,8.5854l-2.3125,2.75488L10.06641,9.28364a.99809.99809,0,0,0-1.28907.21L5.72559,13.13032a.99955.99955,0,1,0,1.53125,1.28516l2.498-2.97559,3.34668,2.05567a.99823.99823,0,0,0,1.28906-.209l2.86622-3.416A.99955.99955,0,1,0,15.72559,8.5854Z'
  }));
};

UilFacebookMessengerAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFacebookMessengerAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFahrenheit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.5,3h-7a3,3,0,0,0-3,3V20a1,1,0,0,0,2,0V13h6a1,1,0,0,0,0-2h-6V6a1,1,0,0,1,1-1h7a1,1,0,0,0,0-2ZM5.5,3a3,3,0,1,0,3,3A3,3,0,0,0,5.5,3Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,5.5,7Z'
  }));
};

UilFahrenheit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFahrenheit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFastMail = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.79,10.5h-2a1,1,0,1,0,0,2h2a1,1,0,0,0,0-2ZM21.57,7.66l0-.06,0,0h0A3,3,0,0,0,19.2,6.5H11.27a3,3,0,0,0-2,.74h0v0A2.93,2.93,0,0,0,8.31,9l-.88,5a3,3,0,0,0,.66,2.45,3,3,0,0,0,2.29,1.07h7.94a3,3,0,0,0,3-2.48l.88-5A3,3,0,0,0,21.57,7.66Zm-2.74.84-3.4,2.76a1,1,0,0,1-1.38-.12L11.72,8.5Zm.48,6.17a1,1,0,0,1-1,.83H10.38a1,1,0,0,1-.76-.36,1,1,0,0,1-.22-.81l.8-4.53,2.35,2.66a3,3,0,0,0,4.14.35L20.13,10ZM5.79,6.5h-3a1,1,0,1,0,0,2h3a1,1,0,0,0,0-2Z'
  }));
};

UilFastMail.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFastMail.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFastMailAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.69,9a2.93,2.93,0,0,0-1-1.71v0h0a3,3,0,0,0-2-.74H4.8A3,3,0,0,0,2.5,7.57h0l0,0,0,.06A3,3,0,0,0,1.84,10l.88,5a3,3,0,0,0,3,2.48h7.94a3,3,0,0,0,2.29-1.07A3,3,0,0,0,16.57,14ZM12.28,8.5,9.94,11.14a1,1,0,0,1-1.38.11L5.17,8.5Zm2.1,6.64a1,1,0,0,1-.76.36H5.68a1,1,0,0,1-1-.83L3.87,10,7.3,12.8a3,3,0,0,0,4.14-.34L13.8,9.8l.8,4.53A1,1,0,0,1,14.38,15.14Zm6.83-4.64h-2a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Zm0-2a1,1,0,0,0,0-2h-3a1,1,0,0,0,0,2Z'
  }));
};

UilFastMailAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFastMailAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFavorite = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,9.67A1,1,0,0,0,21.14,9l-5.69-.83L12.9,3a1,1,0,0,0-1.8,0L8.55,8.16,2.86,9a1,1,0,0,0-.81.68,1,1,0,0,0,.25,1l4.13,4-1,5.68A1,1,0,0,0,6.9,21.44L12,18.77l5.1,2.67a.93.93,0,0,0,.46.12,1,1,0,0,0,.59-.19,1,1,0,0,0,.4-1l-1-5.68,4.13-4A1,1,0,0,0,22,9.67Zm-6.15,4a1,1,0,0,0-.29.88l.72,4.2-3.76-2a1.06,1.06,0,0,0-.94,0l-3.76,2,.72-4.2a1,1,0,0,0-.29-.88l-3-3,4.21-.61a1,1,0,0,0,.76-.55L12,5.7l1.88,3.82a1,1,0,0,0,.76.55l4.21.61Z'
  }));
};

UilFavorite.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFavorite.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFeedback = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,1H15a2.44,2.44,0,0,0-2.41,2l-.92,5.05a2.44,2.44,0,0,0,.53,2,2.47,2.47,0,0,0,1.88.88H17l-.25.66A3.26,3.26,0,0,0,19.75,16a1,1,0,0,0,.92-.59l2.24-5.06A1,1,0,0,0,23,10V2A1,1,0,0,0,22,1ZM21,9.73l-1.83,4.13a1.33,1.33,0,0,1-.45-.4,1.23,1.23,0,0,1-.14-1.16l.38-1a1.68,1.68,0,0,0-.2-1.58A1.7,1.7,0,0,0,17.35,9H14.06a.46.46,0,0,1-.35-.16.5.5,0,0,1-.09-.37l.92-5A.44.44,0,0,1,15,3h6ZM9.94,13.05H7.05l.25-.66A3.26,3.26,0,0,0,4.25,8a1,1,0,0,0-.92.59L1.09,13.65a1,1,0,0,0-.09.4v8a1,1,0,0,0,1,1H9a2.44,2.44,0,0,0,2.41-2l.92-5a2.44,2.44,0,0,0-.53-2A2.47,2.47,0,0,0,9.94,13.05Zm-.48,7.58A.44.44,0,0,1,9,21H3V14.27l1.83-4.13a1.33,1.33,0,0,1,.45.4,1.23,1.23,0,0,1,.14,1.16l-.38,1a1.68,1.68,0,0,0,.2,1.58,1.7,1.7,0,0,0,1.41.74H9.94a.46.46,0,0,1,.35.16.5.5,0,0,1,.09.37Z'
  }));
};

UilFeedback.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFeedback.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFile = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0L13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H14ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V9a1,1,0,0,0,1,1h5Z'
  }));
};

UilFile.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFile.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,10h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm0,2a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-3-3H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilFileAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileBlank = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilFileBlank.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileBlank.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileBlockAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,8a1,1,0,0,0,0,2H8A1,1,0,0,0,8,8Zm5,12H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4h5V7a3,3,0,0,0,3,3h3v1a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0L11.06,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3h7a1,1,0,0,0,0-2ZM12,5.41,14.59,8H13a1,1,0,0,1-1-1Zm8.83,9.76a4.1,4.1,0,0,0-5.66,0,4,4,0,1,0,5.66,0ZM16,18a2,2,0,0,1,2-2,2.09,2.09,0,0,1,.51.07l-2.44,2.44A2.09,2.09,0,0,1,16,18Zm3.41,1.41a2,2,0,0,1-1.91.5l2.43-2.42A2.09,2.09,0,0,1,20,18,2,2,0,0,1,19.41,19.41ZM11,18a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2Zm2-6H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilFileBlockAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileBlockAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileBookmarkAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.5,10h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm4,6h-4a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm0-4h-4a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm6.92-2.62a1,1,0,0,0-.21-1.09l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0L11.56,2H5.5a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h6a1,1,0,0,0,0-2h-6a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h5V7a3,3,0,0,0,3,3h4A1,1,0,0,0,18.42,9.38ZM13.5,8a1,1,0,0,1-1-1V5.41L15.09,8Zm7,4h-5a1,1,0,0,0-1,1v8a1,1,0,0,0,.53.88,1,1,0,0,0,1-.05L18,20.53,20,21.83A1,1,0,0,0,21.5,21V13A1,1,0,0,0,20.5,12Zm-1,7.12-.94-.63a1,1,0,0,0-1.12,0l-.94.63V14h3Z'
  }));
};

UilFileBookmarkAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileBookmarkAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-3.71-6.71L11,15.59l-1.29-1.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,1.42,0l4-4a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilFileCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileCheckAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.5,20h-6a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h5V7a3,3,0,0,0,3,3h3v5a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0A1.1,1.1,0,0,0,11.56,2H5.5a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h6a1,1,0,0,0,0-2Zm1-14.59L15.09,8H13.5a1,1,0,0,1-1-1ZM7.5,14h6a1,1,0,0,0,0-2h-6a1,1,0,0,0,0,2Zm4,2h-4a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm-4-6h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm13.71,6.29a1,1,0,0,0-1.42,0l-3.29,3.3-1.29-1.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,1.42,0l4-4A1,1,0,0,0,21.21,16.29Z'
  }));
};

UilFileCheckAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileCheckAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileContractDollar = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,20.29,20,18.56c0-.11,0-.21,0-.31a2.75,2.75,0,0,0-2.75-2.75h-.34l-1.44-1.44a.67.67,0,0,1,.28-.06H19a1,1,0,0,0,0-2H17.5V11a1,1,0,0,0-2,0v1a2.74,2.74,0,0,0-1.47.59l-1.32-1.33a1,1,0,0,0-1.42,1.42L13,14.44c0,.11,0,.21,0,.31a2.75,2.75,0,0,0,2.75,2.75h.34l1.44,1.44a.67.67,0,0,1-.28.06H14a1,1,0,0,0,0,2h1.5v1a1,1,0,0,0,2,0V21A2.74,2.74,0,0,0,19,20.38l1.32,1.33a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM10,19H5a1,1,0,0,1-1-1V4A1,1,0,0,1,5,3h6V7a1,1,0,0,0,1,1h5a1,1,0,0,0,.92-.62,1,1,0,0,0-.21-1.09l-5-5h0a1.07,1.07,0,0,0-.28-.19l-.09,0A1.31,1.31,0,0,0,12.06,1H5A3,3,0,0,0,2,4V18a3,3,0,0,0,3,3h5a1,1,0,0,0,0-2ZM13,4.41,14.59,6H13Z'
  }));
};

UilFileContractDollar.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileContractDollar.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileCopyAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,20H8a3,3,0,0,1-3-3V7A1,1,0,0,0,3,7V17a5,5,0,0,0,5,5h8a1,1,0,0,0,0-2Zm-6-7a1,1,0,0,0,1,1h5a1,1,0,0,0,0-2H11A1,1,0,0,0,10,13ZM21,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,14.05,2H10A3,3,0,0,0,7,5V15a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V9S21,9,21,8.94ZM15,5.41,17.59,8H16a1,1,0,0,1-1-1ZM19,15a1,1,0,0,1-1,1H10a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h3V7a3,3,0,0,0,.18,1H11a1,1,0,0,0,0,2h8Z'
  }));
};

UilFileCopyAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileCopyAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-4.71-4.71-.29.3V12a1,1,0,0,0-2,0v2.59l-.29-.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2-2a1,1,0,0,0-1.42-1.42Z'
  }));
};

UilFileDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileDownloadAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,8a1,1,0,0,0,0,2H9A1,1,0,0,0,9,8Zm5,12H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v2a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0A1.1,1.1,0,0,0,12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h7a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM14,12H8a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm6.71,6.29a1,1,0,0,0-1.42,0l-.29.3V16a1,1,0,0,0-2,0v2.59l-.29-.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2-2A1,1,0,0,0,20.71,18.29ZM12,18a1,1,0,0,0,0-2H8a1,1,0,0,0,0,2Z'
  }));
};

UilFileDownloadAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileDownloadAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileEditAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.71,16.71l-2.42-2.42a1,1,0,0,0-1.42,0l-3.58,3.58a1,1,0,0,0-.29.71V21a1,1,0,0,0,1,1h2.42a1,1,0,0,0,.71-.29l3.58-3.58A1,1,0,0,0,20.71,16.71ZM16,20H15V19l2.58-2.58,1,1Zm-6,0H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v1a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0L12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h4a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM8,14h6a1,1,0,0,0,0-2H8a1,1,0,0,0,0,2Zm0-4H9A1,1,0,0,0,9,8H8a1,1,0,0,0,0,2Zm2,6H8a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Z'
  }));
};

UilFileEditAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileEditAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.92,16.62a.76.76,0,0,0-.09-.18,1.58,1.58,0,0,0-.12-.15,1,1,0,0,0-1.09-.21,1,1,0,0,0-.33.21,1.58,1.58,0,0,0-.12.15.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.5,1.5,0,0,0,0,.2.84.84,0,0,0,.08.38,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,12,18a.84.84,0,0,0,.38-.08.9.9,0,0,0,.54-.54A.84.84,0,0,0,13,17a1.5,1.5,0,0,0,0-.2A.64.64,0,0,0,12.92,16.62ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-6-8a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V12A1,1,0,0,0,12,11Z'
  }));
};

UilFileExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileExclamationAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,10h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm6,2H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0,4H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm4.71,4.29a1.58,1.58,0,0,0-.15-.12.76.76,0,0,0-.18-.09L19.2,20a1,1,0,0,0-.58.06.9.9,0,0,0-.54.54A.84.84,0,0,0,18,21a1,1,0,1,0,1.92-.38A1.15,1.15,0,0,0,19.71,20.29ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3h8a1,1,0,0,0,0-2H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3v2a1,1,0,0,0,2,0V9S20,9,20,8.94ZM15,8a1,1,0,0,1-1-1V5.41L16.59,8Zm4,7a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V16A1,1,0,0,0,19,15Z'
  }));
};

UilFileExclamationAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileExclamationAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileExport = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.92,15.62a1.15,1.15,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L17.59,15H12a1,1,0,0,0,0,2h5.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a.93.93,0,0,0,.21-.33A1,1,0,0,0,20.92,15.62ZM14,20H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h4a1,1,0,0,0,.92-.62,1,1,0,0,0-.21-1.09l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0L12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h8a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1Z'
  }));
};

UilFileExport.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileExport.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileGraph = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,10h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm5.21045,2.38623-1.67334,2.15186-.86816-.78125a.9997.9997,0,0,0-1.44971.11865l-2,2.5a.9998.9998,0,1,0,1.56152,1.249l1.33789-1.67236.87891.791a.99989.99989,0,0,0,1.45849-.12939l2.3335-3a1.00005,1.00005,0,0,0-1.5791-1.22754Zm5.7771-3.44794a1.0088,1.0088,0,0,0-.27936-.64373l-.00146-.0019L13.70734,2.29327l-.00183-.00146a.99022.99022,0,0,0-.28608-.19281c-.0299-.014-.061-.02191-.09246-.033a.98253.98253,0,0,0-.26667-.05383C13.03925,2.01086,13.02136,2,13,2H7A3.00328,3.00328,0,0,0,4,5V19a3.00328,3.00328,0,0,0,3,3H17a3.00328,3.00328,0,0,0,3-3V9C20,8.97809,19.989,8.95984,19.98755,8.93829ZM14,5.41406,16.58594,8H15a1.0013,1.0013,0,0,1-1-1ZM18,19a1.0013,1.0013,0,0,1-1,1H7a1.0013,1.0013,0,0,1-1-1V5A1.0013,1.0013,0,0,1,7,4h5V7a3.00328,3.00328,0,0,0,3,3h3Z'
  }));
};

UilFileGraph.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileGraph.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-6-7.66A2.92,2.92,0,0,0,8.57,16l2.72,2.72a1,1,0,0,0,1.42,0L15.43,16A2.92,2.92,0,0,0,12,11.34Zm2,1.93a.92.92,0,0,1,0,1.3l-2,2-2-2a.92.92,0,0,1,0-1.3.92.92,0,0,1,1.3,0,1,1,0,0,0,1.42,0A.92.92,0,0,1,14,13.27Z'
  }));
};

UilFileHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileImport = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,20H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v2a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.32,1.32,0,0,0-.19-.29h0l-6-6h0a1.32,1.32,0,0,0-.29-.19.32.32,0,0,0-.09,0L12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h5a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM19,15H13.41l1.3-1.29a1,1,0,0,0-1.42-1.42l-3,3a1.15,1.15,0,0,0-.21.33,1,1,0,0,0,0,.76.93.93,0,0,0,.21.33l3,3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L13.41,17H19a1,1,0,0,0,0-2Z'
  }));
};

UilFileImport.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileImport.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileInfoAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,16H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM9,10h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm6,2H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm4.71,3.29a1,1,0,0,0-.33-.21.92.92,0,0,0-.76,0,1,1,0,0,0-.33.21,1.15,1.15,0,0,0-.21.33,1,1,0,0,0,.21,1.09A1,1,0,0,0,19,17a1,1,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1.15,1.15,0,0,0,19.71,15.29ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3h8a1,1,0,0,0,0-2H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3v2a1,1,0,0,0,2,0V9S20,9,20,8.94ZM15,8a1,1,0,0,1-1-1V5.41L16.59,8Zm4,10a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V19A1,1,0,0,0,19,18Z'
  }));
};

UilFileInfoAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileInfoAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileLandscape = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,10.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,15.06,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V11S22,11,22,10.94ZM16,7.41,18.59,10H17a1,1,0,0,1-1-1ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V7A1,1,0,0,1,5,6h9V9a3,3,0,0,0,3,3h3Z'
  }));
};

UilFileLandscape.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileLandscape.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileLandscapeAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,10.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,15.06,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V11S22,11,22,10.94ZM16,7.41,18.59,10H17a1,1,0,0,1-1-1ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V7A1,1,0,0,1,5,6h9V9a3,3,0,0,0,3,3h3ZM7,12h4a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2Zm0,2a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2Z'
  }));
};

UilFileLandscapeAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileLandscapeAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileLanscapeSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,10.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,15.05,4H10.66a1,1,0,0,0,0,2H14V9a3,3,0,0,0,3,3h3v3.34a1,1,0,1,0,2,0V11S22,11,22,10.94ZM17,10a1,1,0,0,1-1-1V7.41L18.59,10ZM3.71,2.29A1,1,0,0,0,2.29,3.71l.91.9A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H18.59l1.7,1.71a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM5,18a1,1,0,0,1-1-1V7a1,1,0,0,1,.66-.93L16.59,18Z'
  }));
};

UilFileLanscapeSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileLanscapeSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileLockAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,20H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4h5V7a3,3,0,0,0,3,3h4a1,1,0,0,0,.92-.62,1,1,0,0,0-.21-1.09l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0L11.06,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3h5a1,1,0,0,0,0-2ZM12,5.41,14.59,8H13a1,1,0,0,1-1-1ZM13,13a1,1,0,0,0-1-1H7a1,1,0,0,0,0,2h5A1,1,0,0,0,13,13ZM7,10H8A1,1,0,0,0,8,8H7a1,1,0,0,0,0,2Zm0,6a1,1,0,0,0,0,2H9a1,1,0,0,0,0-2Zm13-.82V15a3,3,0,0,0-6,0v.18A3,3,0,0,0,12,18v1a3,3,0,0,0,3,3h4a3,3,0,0,0,3-3V18A3,3,0,0,0,20,15.18ZM17,14a1,1,0,0,1,1,1H16A1,1,0,0,1,17,14Zm3,5a1,1,0,0,1-1,1H15a1,1,0,0,1-1-1V18a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1Z'
  }));
};

UilFileLockAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileLockAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,14H13V13a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V16h1a1,1,0,0,0,0-2Zm6-5.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilFileMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileMedicalAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,18a1,1,0,0,0-1,1,1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v1a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27.32.32,0,0,0,0-.09,1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.14,1.14,0,0,0,12.07,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3H16a3,3,0,0,0,3-3A1,1,0,0,0,18,18ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM20,14H17.5a1,1,0,0,0-.71.29l-1.24,1.25-2.8-3.2a1,1,0,0,0-1.46-.05L9.59,14H8a1,1,0,0,0,0,2h2a1,1,0,0,0,.71-.29L12,14.46l2.8,3.2a1,1,0,0,0,.72.34h0a1,1,0,0,0,.71-.29L17.91,16H20a1,1,0,0,0,0-2Z'
  }));
};

UilFileMedicalAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileMedicalAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,14H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm6-5.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilFileMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileMinusAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,8a1,1,0,0,0,0,2H9A1,1,0,0,0,9,8Zm5,12H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v5a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0A1.1,1.1,0,0,0,12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h7a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM20,18H16a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm-7-2H8a1,1,0,0,0,0,2h5a1,1,0,0,0,0-2Zm1-4H8a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilFileMinusAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileMinusAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileNetwork = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,19H14.82A3,3,0,0,0,13,17.18V15h3a3,3,0,0,0,3-3V8s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,12.05,1H8A3,3,0,0,0,5,4v8a3,3,0,0,0,3,3h3v2.18A3,3,0,0,0,9.18,19H3a1,1,0,0,0,0,2H9.18a3,3,0,0,0,5.64,0H21a1,1,0,0,0,0-2ZM13,4.41,15.59,7H14a1,1,0,0,1-1-1ZM8,13a1,1,0,0,1-1-1V4A1,1,0,0,1,8,3h3V6a3,3,0,0,0,3,3h3v3a1,1,0,0,1-1,1Zm4,8a1,1,0,1,1,1-1A1,1,0,0,1,12,21Z'
  }));
};

UilFileNetwork.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileNetwork.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilePlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-4-5H13V13a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V16h1a1,1,0,0,0,0-2Z'
  }));
};

UilFilePlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilePlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilePlusAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,18H19V17a1,1,0,0,0-2,0v1H16a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V20h1a1,1,0,0,0,0-2Zm-7,2H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v3a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0A1.1,1.1,0,0,0,12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h7a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM8,8a1,1,0,0,0,0,2H9A1,1,0,0,0,9,8Zm5,8H8a1,1,0,0,0,0,2h5a1,1,0,0,0,0-2Zm1-4H8a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilFilePlusAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilePlusAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.57,17.29a1,1,0,0,0-1.41,0,1.06,1.06,0,0,0-.22.33,1.07,1.07,0,0,0,0,.76,1.19,1.19,0,0,0,.22.33,1,1,0,0,0,.32.21,1,1,0,0,0,.39.08,1,1,0,0,0,.92-1.38A.91.91,0,0,0,12.57,17.29ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-6.13-9a3,3,0,0,0-2.6,1.5,1,1,0,1,0,1.73,1,1,1,0,0,1,.87-.5,1,1,0,0,1,0,2,1,1,0,1,0,0,2,3,3,0,0,0,0-6Z'
  }));
};

UilFileQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileQuestionAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.07,12h-5a1,1,0,0,0,0,2h5a1,1,0,0,0,0-2Zm1,8h-8a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h5V7a3,3,0,0,0,3,3h3v1a1,1,0,0,0,2,0V9a.14.14,0,0,0,0-.06A.86.86,0,0,0,19,8.67l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1,1,0,0,0-.29-.19s-.05,0-.08,0A.88.88,0,0,0,12.12,2h-6a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h8a1,1,0,0,0,0-2Zm-1-14.59L15.65,8H14.07a1,1,0,0,1-1-1Zm5.57,14.88a1.58,1.58,0,0,0-.15-.12,1.08,1.08,0,0,0-.36-.15,1,1,0,0,0-.9.27,1,1,0,0,0,0,1.42,1,1,0,0,0,.7.29,1,1,0,0,0,.93-1.38A1.19,1.19,0,0,0,18.64,20.29ZM13.07,16h-5a1,1,0,0,0,0,2h5a1,1,0,0,0,0-2Zm4.86-3a3,3,0,0,0-2.6,1.5,1,1,0,1,0,1.74,1,1,1,0,1,1,.86,1.5,1,1,0,0,0,0,2,3,3,0,0,0,0-6ZM8.07,10h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Z'
  }));
};

UilFileQuestionAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileQuestionAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileRedoAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,13a1,1,0,0,0-1-1H8a1,1,0,0,0,0,2h5A1,1,0,0,0,14,13Zm-3,7H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v1a1,1,0,0,0,2,0V9s0,0,0-.06a1.18,1.18,0,0,0-.06-.27l0-.09a.92.92,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.86.86,0,0,0,12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h5a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM20,14a1,1,0,0,0-.91.6A4.07,4.07,0,0,0,17,14a4,4,0,1,0,2.64,7,1,1,0,0,0-1.32-1.51A2,2,0,0,1,17,20a2,2,0,1,1,1-3.75h-.22a1,1,0,0,0,0,2H20a1,1,0,0,0,1-1V15A1,1,0,0,0,20,14ZM8,10H9A1,1,0,0,0,9,8H8a1,1,0,0,0,0,2Zm0,6a1,1,0,0,0,0,2h2a1,1,0,0,0,0-2Z'
  }));
};

UilFileRedoAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileRedoAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileSearchAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,20H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4h5V7a3,3,0,0,0,3,3h3v1a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,11.05,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3h7a1,1,0,0,0,0-2ZM12,5.41,14.59,8H13a1,1,0,0,1-1-1ZM7,8a1,1,0,0,0,0,2H8A1,1,0,0,0,8,8ZM21.71,20.29l-1.17-1.16A3.44,3.44,0,0,0,20,15h0A3.49,3.49,0,0,0,14,17.49a3.46,3.46,0,0,0,5.13,3.05l1.16,1.17a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29Zm-3.17-1.75a1.54,1.54,0,0,1-2.11,0A1.5,1.5,0,0,1,16,17.49a1.46,1.46,0,0,1,.44-1.06,1.48,1.48,0,0,1,1-.43A1.47,1.47,0,0,1,19,17.49,1.5,1.5,0,0,1,18.54,18.54ZM13,12H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm-2,6a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2Z'
  }));
};

UilFileSearchAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileSearchAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileShareAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.5,12.5a1,1,0,0,0-1-1h-5a1,1,0,0,0,0,2h5A1,1,0,0,0,13.5,12.5Zm5,5a2,2,0,0,0-1.18.39l-1.75-.8,1.91-.88a2,2,0,0,0,1,.29,2,2,0,1,0-2-2l-1.89.87A2,2,0,1,0,13.5,19a1.88,1.88,0,0,0,.92-.24l2.1,1a2,2,0,1,0,2-2.23Zm-8,2h-5a1,1,0,0,1-1-1V4.5a1,1,0,0,1,1-1h5v3a3,3,0,0,0,3,3h3a1,1,0,0,0,2,0v-1s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0,1.1,1.1,0,0,0-.26-.06H5.5a3,3,0,0,0-3,3v14a3,3,0,0,0,3,3h5a1,1,0,0,0,0-2Zm2-14.59L15.09,7.5H13.5a1,1,0,0,1-1-1ZM7.5,15.5a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm0-6h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Z'
  }));
};

UilFileShareAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileShareAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileShieldAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.5,20h-5a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h5V7a3,3,0,0,0,3,3h3a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0L11.56,2H5.5a3,3,0,0,0-3,3V19a3,3,0,0,0,3,3h5a1,1,0,0,0,0-2Zm2-14.59L15.09,8H13.5a1,1,0,0,1-1-1ZM7.5,8a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm13.63,5.86a1,1,0,0,0-.84-.2,2.77,2.77,0,0,1-2.2-.47,1,1,0,0,0-1.18,0,2.78,2.78,0,0,1-2.2.47,1,1,0,0,0-1.21,1V17a4.6,4.6,0,0,0,1.84,3.69L16.9,21.8a1,1,0,0,0,1.2,0l1.56-1.16A4.6,4.6,0,0,0,21.5,17V14.63A1,1,0,0,0,21.13,13.86ZM19.5,17a2.62,2.62,0,0,1-1,2.09l-1,.72-1-.72a2.62,2.62,0,0,1-1-2.09V15.72a4.68,4.68,0,0,0,2-.55,4.68,4.68,0,0,0,2,.55Zm-9-.95h-3a1,1,0,0,0,0,2h3a1,1,0,0,0,0-2Zm1-4h-4a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Z'
  }));
};

UilFileShieldAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileShieldAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71L4,5.41V19a3,3,0,0,0,3,3H17a3,3,0,0,0,2.39-1.2l.9.91a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM17,20H7a1,1,0,0,1-1-1V7.41L17.93,19.34A1,1,0,0,1,17,20ZM8.66,4H12V7a3,3,0,0,0,3,3h3v3.34a1,1,0,1,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0L13.06,2H8.66a1,1,0,0,0,0,2ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1Z'
  }));
};

UilFileSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.71,12.29a1,1,0,0,0-1.42,0L12,13.59l-1.29-1.3a1,1,0,0,0-1.42,1.42L10.59,15l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L12,16.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L13.41,15l1.3-1.29A1,1,0,0,0,14.71,12.29ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilFileTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileTimesAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,12H8a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm5.41,7,1.3-1.29a1,1,0,0,0-1.42-1.42L18,17.59l-1.29-1.3a1,1,0,0,0-1.42,1.42L16.59,19l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L18,20.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM12,20H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v3a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.29.29,0,0,0-.1,0A1.1,1.1,0,0,0,12.06,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h6a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM8,8a1,1,0,0,0,0,2H9A1,1,0,0,0,9,8Zm4,8H8a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Z'
  }));
};

UilFileTimesAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileTimesAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,11.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2,2a1,1,0,0,0,1.42,1.42l.29-.3V17a1,1,0,0,0,2,0V14.41l.29.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z'
  }));
};

UilFileUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFileUploadAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,20H6a1,1,0,0,1-1-1V5A1,1,0,0,1,6,4h5V7a3,3,0,0,0,3,3h3v2a1,1,0,0,0,2,0V9s0,0,0-.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,12.05,2H6A3,3,0,0,0,3,5V19a3,3,0,0,0,3,3h7a1,1,0,0,0,0-2ZM13,5.41,15.59,8H14a1,1,0,0,1-1-1ZM8,8a1,1,0,0,0,0,2H9A1,1,0,0,0,9,8Zm6,4H8a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm6.71,5.29-2-2a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2,2a1,1,0,0,0,1.42,1.42l.29-.3V21a1,1,0,0,0,2,0V18.41l.29.3a1,1,0,0,0,1.42,0A1,1,0,0,0,20.71,17.29ZM12,18a1,1,0,0,0,0-2H8a1,1,0,0,0,0,2Z'
  }));
};

UilFileUploadAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFileUploadAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilesLandscapes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M23,9.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,16.05,3H8A3,3,0,0,0,5,6V7H4a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H16a3,3,0,0,0,3-3V17h1a3,3,0,0,0,3-3V10S23,10,23,9.94ZM17,6.41,19.59,9H18a1,1,0,0,1-1-1ZM17,18a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V10A1,1,0,0,1,4,9H5v5a3,3,0,0,0,3,3h9Zm4-4a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V6A1,1,0,0,1,8,5h7V8a3,3,0,0,0,3,3h3Z'
  }));
};

UilFilesLandscapes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilesLandscapes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilesLandscapesAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,19H6a3,3,0,0,1-3-3V8A1,1,0,0,0,1,8v8a5,5,0,0,0,5,5H18a1,1,0,0,0,0-2Zm-4-8H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm9-1.06a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,16.05,3H8A3,3,0,0,0,5,6v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V10S23,10,23,9.94ZM17,6.41,19.59,9H18a1,1,0,0,1-1-1ZM21,14a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V6A1,1,0,0,1,8,5h7V8a3,3,0,0,0,3,3h3ZM10,9h2a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2Z'
  }));
};

UilFilesLandscapesAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilesLandscapesAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilm = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2a1,1,0,0,0-1,1V5H18V3a1,1,0,0,0-2,0V4H8V3A1,1,0,0,0,6,3V5H4V3A1,1,0,0,0,2,3V21a1,1,0,0,0,2,0V19H6v2a1,1,0,0,0,2,0V20h8v1a1,1,0,0,0,2,0V19h2v2a1,1,0,0,0,2,0V3A1,1,0,0,0,21,2ZM6,17H4V15H6Zm0-4H4V11H6ZM6,9H4V7H6Zm10,9H8V13h8Zm0-7H8V6h8Zm4,6H18V15h2Zm0-4H18V11h2Zm0-4H18V7h2Z'
  }));
};

UilFilm.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilm.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilter = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V6.17a3,3,0,0,0,.25,1.2l0,.06a2.81,2.81,0,0,0,.59.86L9,14.41V21a1,1,0,0,0,.47.85A1,1,0,0,0,10,22a1,1,0,0,0,.45-.11l4-2A1,1,0,0,0,15,19V14.41l6.12-6.12a2.81,2.81,0,0,0,.59-.86l0-.06A3,3,0,0,0,22,6.17V5A3,3,0,0,0,19,2ZM13.29,13.29A1,1,0,0,0,13,14v4.38l-2,1V14a1,1,0,0,0-.29-.71L5.41,8H18.59ZM20,6H4V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilFilter.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilter.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFilterSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.22,6H12.66a1,1,0,0,0,0,2h6.56a.78.78,0,0,1,.78.78v.78H16.22a1,1,0,1,0,0,2h2.37l-.7.69a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l1.88-1.88a2.51,2.51,0,0,0,.54-.8h0l0-.1A2.59,2.59,0,0,0,22,9.82v-1A2.79,2.79,0,0,0,19.22,6ZM3.71,2.29A1,1,0,0,0,2.29,3.71L5.14,6.55A2.73,2.73,0,0,0,4,8.78v1a2.65,2.65,0,0,0,.24,1.1l0,.06a2.61,2.61,0,0,0,.54.81l5.41,5.4V21a1,1,0,0,0,.47.85,1,1,0,0,0,.53.15,1,1,0,0,0,.45-.11l3.56-1.78a1,1,0,0,0,.55-.89v-2h0l4.51,4.52a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM6,8.78a.76.76,0,0,1,.5-.72L6.59,8,8.15,9.56H6Zm8.07,7.29a1,1,0,0,0-.29.71V18.6l-1.56.78v-2.6a1,1,0,0,0-.29-.71L7.41,11.56h2.74l4.22,4.22Z'
  }));
};

UilFilterSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFilterSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFire = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.46777,8.39453l-.00225.00183-.00214.00208ZM18.42188,8.208a1.237,1.237,0,0,0-.23-.17481.99959.99959,0,0,0-1.39941.41114,5.78155,5.78155,0,0,1-1.398,1.77734,8.6636,8.6636,0,0,0,.1333-1.50977,8.71407,8.71407,0,0,0-4.40039-7.582,1.00009,1.00009,0,0,0-1.49121.80567A7.017,7.017,0,0,1,7.165,6.87793l-.23047.1875a8.51269,8.51269,0,0,0-1.9873,1.8623A8.98348,8.98348,0,0,0,8.60254,22.83594.99942.99942,0,0,0,9.98,21.91016a1.04987,1.04987,0,0,0-.0498-.3125,6.977,6.977,0,0,1-.18995-2.58106,9.004,9.004,0,0,0,4.3125,4.0166.997.997,0,0,0,.71534.03809A8.99474,8.99474,0,0,0,18.42188,8.208ZM14.51709,21.03906a6.964,6.964,0,0,1-3.57666-4.40234,8.90781,8.90781,0,0,1-.17969-.96387,1.00025,1.00025,0,0,0-.79931-.84473A.982.982,0,0,0,9.77,14.80957a.99955.99955,0,0,0-.8667.501,8.9586,8.9586,0,0,0-1.20557,4.71777,6.98547,6.98547,0,0,1-1.17529-9.86816,6.55463,6.55463,0,0,1,1.562-1.458.74507.74507,0,0,0,.07422-.05469s.29669-.24548.30683-.2511a8.96766,8.96766,0,0,0,2.89874-4.63269,6.73625,6.73625,0,0,1,1.38623,8.08789,1.00024,1.00024,0,0,0,1.18359,1.418,7.85568,7.85568,0,0,0,3.86231-2.6875,7.00072,7.00072,0,0,1-3.2793,10.457Z'
  }));
};

UilFire.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFire.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlask = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.11,17.49,15,8.73V4h1a1,1,0,0,0,0-2H8A1,1,0,0,0,8,4H9V8.73L3.89,17.49A3,3,0,0,0,6.48,22h11a3,3,0,0,0,2.59-4.51Zm-9.25-8A1,1,0,0,0,11,9V4h2V9a1,1,0,0,0,.14.5L14,11H10Zm7.52,10a1,1,0,0,1-.86.5h-11a1,1,0,0,1-.86-.5,1,1,0,0,1,0-1L8.83,13h6.35l3.2,5.5A1,1,0,0,1,18.38,19.5ZM10,15a1,1,0,1,0,1,1A1,1,0,0,0,10,15Zm4,1a1,1,0,1,0,1,1A1,1,0,0,0,14,16Z'
  }));
};

UilFlask.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlask.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlaskPotion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.93,11.67a.42.42,0,0,0,0-.1A7.4,7.4,0,0,0,15,7.62V4h1a1,1,0,0,0,0-2H8A1,1,0,0,0,8,4H9V7.62a7.4,7.4,0,0,0-3.89,4,.42.42,0,0,0,0,.1,7.5,7.5,0,1,0,13.86,0ZM10.31,9.26A1,1,0,0,0,11,8.31V4h2V8.31a1,1,0,0,0,.69.95A5.43,5.43,0,0,1,16.23,11H7.77A5.43,5.43,0,0,1,10.31,9.26ZM12,20a5.51,5.51,0,0,1-5.5-5.5A5.34,5.34,0,0,1,6.72,13H17.28a5.34,5.34,0,0,1,.22,1.5A5.51,5.51,0,0,1,12,20Zm2-4a1,1,0,1,0,1,1A1,1,0,0,0,14,16Zm-4-1a1,1,0,1,0,1,1A1,1,0,0,0,10,15Z'
  }));
};

UilFlaskPotion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlaskPotion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlipH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM10.93,9h1.5a1,1,0,0,0,0-2h-1.5a1,1,0,0,0,0,2Zm4.5-1a1,1,0,0,0,1,1H17a1,1,0,0,0,.92-.62,1,1,0,0,0-.21-1.09l-.66-.65a1,1,0,0,0-1.41,0,1,1,0,0,0-.19,1.15A1.49,1.49,0,0,0,15.43,8ZM11.65,4.77,12,4.41l.81.81a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41L13.16,2.75a.91.91,0,0,0-.26-.19,1,1,0,0,0-1.61-.27L10.23,3.35a1,1,0,0,0,1.42,1.42ZM17,15H7a1,1,0,0,0-.92.62,1,1,0,0,0,.21,1.09l5,5a1,1,0,0,0,1.42,0l5-5a1,1,0,0,0,.21-1.09A1,1,0,0,0,17,15Zm-5,4.59L9.41,17h5.18ZM7.05,9a1,1,0,0,0,.71-.29L8.82,7.6A1,1,0,0,0,7.4,6.18L6.34,7.24a1,1,0,0,0,0,1.42A1,1,0,0,0,7.05,9Z'
  }));
};

UilFlipH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlipH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlipHAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.21,5.7a1,1,0,0,0,.24,0l1.94-.49A1,1,0,0,0,16.12,4a1,1,0,0,0-1.21-.73L13,3.73a1,1,0,0,0,.24,2ZM9.51,9h-2a1,1,0,1,0,0,2h2a1,1,0,0,0,0-2Zm4,0a1,1,0,1,0,0,2h2a1,1,0,0,0,0-2ZM7.39,7.15l.24,0,1.94-.48A1,1,0,0,0,9.09,4.7l-1.94.48a1,1,0,0,0,.24,2ZM4,10.51a1,1,0,0,0,1-1v-2a1,1,0,0,0-2,0v2A1,1,0,0,0,4,10.51Zm16.62-8.3A1,1,0,0,0,19.76,2l-1,.24a1,1,0,0,0-.73,1.21,1,1,0,0,0,1,.76A1,1,0,0,0,21,4V3A1,1,0,0,0,20.62,2.21ZM20,7a1,1,0,0,0-1,1V9.14A1,1,0,0,0,19.51,11H20a1,1,0,0,0,1-1V8A1,1,0,0,0,20,7Zm0,6H4a1,1,0,0,0-1,1v3a1,1,0,0,0,.76,1l16,4A1,1,0,0,0,20,22a1,1,0,0,0,1-1V14A1,1,0,0,0,20,13Zm-1,6.72L5,16.22V15H19Z'
  }));
};

UilFlipHAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlipHAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlipV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.6,15.18A1,1,0,0,0,6.18,16.6l1.06,1.06a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM3.81,9.78,2.75,10.84a.91.91,0,0,0-.19.26,1,1,0,0,0-.27,1.61l1.06,1.06a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L4.41,12l.81-.81A1,1,0,0,0,3.81,9.78ZM8,10.57a1,1,0,0,0-1,1v1.5a1,1,0,0,0,2,0v-1.5A1,1,0,0,0,8,10.57Zm13.71.72-5-5a1,1,0,0,0-1.09-.21A1,1,0,0,0,15,7V17a1,1,0,0,0,.62.92A.84.84,0,0,0,16,18a1,1,0,0,0,.71-.29l5-5A1,1,0,0,0,21.71,11.29ZM17,14.59V9.41L19.59,12ZM12,2a1,1,0,0,0-1,1V21a1,1,0,0,0,2,0V3A1,1,0,0,0,12,2ZM8.38,6.08a1,1,0,0,0-1.09.21L6.64,7a1,1,0,0,0,0,1.41,1,1,0,0,0,.7.3,1,1,0,0,0,.45-.11A1,1,0,0,0,9,7.57V7A1,1,0,0,0,8.38,6.08Z'
  }));
};

UilFlipV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlipV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlipVAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.94,12.24A1,1,0,0,0,3.73,13l-.49,1.94A1,1,0,0,0,4,16.12a1,1,0,0,0,1.21-.73l.49-1.94A1,1,0,0,0,4.94,12.24Zm17,7.52-4-16A1,1,0,0,0,17,3H14a1,1,0,0,0-1,1V20a1,1,0,0,0,1,1h7a1,1,0,0,0,.79-.38A1,1,0,0,0,22,19.76ZM15,19V5h1.22l3.5,14ZM6.4,6.42a1,1,0,0,0-1.22.73L4.7,9.09a1,1,0,0,0,.73,1.21l.24,0a1,1,0,0,0,1-.76l.48-1.94A1,1,0,0,0,6.4,6.42ZM7.51,5h2a1,1,0,0,0,0-2h-2a1,1,0,0,0,0,2ZM4.24,19a1,1,0,0,0-2-.24l-.24,1a1,1,0,0,0,.18.86A1,1,0,0,0,3,21H4a1,1,0,0,0,.24-2ZM10,6.51a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0v-2A1,1,0,0,0,10,6.51Zm0,6a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0v-2A1,1,0,0,0,10,12.51Zm0,6a1,1,0,0,0-.86.49H8a1,1,0,0,0,0,2h2a1,1,0,0,0,1-1v-.49A1,1,0,0,0,10,18.51Z'
  }));
};

UilFlipVAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlipVAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFlower = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.68,6.88a4.4,4.4,0,0,0-3.31-.32,4.37,4.37,0,0,0-8.73,0,4.48,4.48,0,0,0-3.31.29,4.37,4.37,0,0,0,.61,8,4.4,4.4,0,0,0-.8,2.5,5,5,0,0,0,.07.75A4.34,4.34,0,0,0,8.5,21.73a4.68,4.68,0,0,0,.64,0A4.42,4.42,0,0,0,12,20a4.42,4.42,0,0,0,2.86,1.69,4.68,4.68,0,0,0,.64,0,4.36,4.36,0,0,0,3.56-6.87,4.36,4.36,0,0,0,.62-8ZM10.34,4.94a2.4,2.4,0,0,1,3.32,0,2.43,2.43,0,0,1,.52,2.66l-.26.59-.66.58A4.07,4.07,0,0,0,12,8.55a4,4,0,0,0-1.61.34L9.83,7.6A2.39,2.39,0,0,1,10.34,4.94Zm-6.1,6.84A2.37,2.37,0,0,1,7.94,9l.49.43.35.8A3.92,3.92,0,0,0,8,12.55,2.85,2.85,0,0,0,8,13l-.55,0h0l-.84.08A2.37,2.37,0,0,1,4.24,11.78Zm6.6,6.08a2.38,2.38,0,0,1-4.66-.08,3.07,3.07,0,0,1,0-.42,2.33,2.33,0,0,1,1.17-2L7.86,15l.91-.1a4,4,0,0,0,2.38,1.57ZM12,14.55a2,2,0,1,1,2-2A2,2,0,0,1,12,14.55Zm5.82,3.22a2.36,2.36,0,0,1-2.68,1.94,2.39,2.39,0,0,1-2-1.85l-.14-.6.21-.92a4,4,0,0,0,2.2-1.76l.5.3.09,0,.66.39A2.38,2.38,0,0,1,17.82,17.77Zm1.94-6a2.39,2.39,0,0,1-2.13,1.33h-.24L16.75,13,16,12.59v0a4,4,0,0,0-1-2.64l.43-.37,0,0L16.06,9a2.37,2.37,0,0,1,3.7,2.82Z'
  }));
};

UilFlower.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFlower.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFocus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,2H3A1,1,0,0,0,2,3V8A1,1,0,0,0,4,8V4H8A1,1,0,0,0,8,2ZM8,20H4V16a1,1,0,0,0-2,0v5a1,1,0,0,0,1,1H8a1,1,0,0,0,0-2ZM21,2H16a1,1,0,0,0,0,2h4V8a1,1,0,0,0,2,0V3A1,1,0,0,0,21,2Zm0,13a1,1,0,0,0-1,1v4H16a1,1,0,0,0,0,2h5a1,1,0,0,0,1-1V16A1,1,0,0,0,21,15Z'
  }));
};

UilFocus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFocus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFocusAdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,20H5a1,1,0,0,1-1-1V16a1,1,0,0,0-2,0v3a3,3,0,0,0,3,3H8a1,1,0,0,0,0-2ZM3,9A1,1,0,0,0,4,8V5A1,1,0,0,1,5,4H8A1,1,0,0,0,8,2H5A3,3,0,0,0,2,5V8A1,1,0,0,0,3,9ZM19,2H16a1,1,0,0,0,0,2h3a1,1,0,0,1,1,1V8a1,1,0,0,0,2,0V5A3,3,0,0,0,19,2ZM16,12a1,1,0,0,0-1-1H13V9a1,1,0,0,0-2,0v2H9a1,1,0,0,0,0,2h2v2a1,1,0,0,0,2,0V13h2A1,1,0,0,0,16,12Zm5,3a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H16a1,1,0,0,0,0,2h3a3,3,0,0,0,3-3V16A1,1,0,0,0,21,15Z'
  }));
};

UilFocusAdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFocusAdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFocusTarget = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,9A1,1,0,0,0,4,8V5A1,1,0,0,1,5,4H8A1,1,0,0,0,8,2H5A3,3,0,0,0,2,5V8A1,1,0,0,0,3,9ZM8,20H5a1,1,0,0,1-1-1V16a1,1,0,0,0-2,0v3a3,3,0,0,0,3,3H8a1,1,0,0,0,0-2Zm9-7a1,1,0,0,0,0-2H15.86A4,4,0,0,0,13,8.14V7a1,1,0,0,0-2,0V8.14A4,4,0,0,0,8.14,11H7a1,1,0,0,0,0,2H8.14A4,4,0,0,0,11,15.86V17a1,1,0,0,0,2,0V15.86A4,4,0,0,0,15.86,13Zm-5,1a2,2,0,1,1,2-2A2,2,0,0,1,12,14Zm9,1a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H16a1,1,0,0,0,0,2h3a3,3,0,0,0,3-3V16A1,1,0,0,0,21,15ZM19,2H16a1,1,0,0,0,0,2h3a1,1,0,0,1,1,1V8a1,1,0,0,0,2,0V5A3,3,0,0,0,19,2Z'
  }));
};

UilFocusTarget.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFocusTarget.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolder = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolder.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolder.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.29,10.79,11,14.09l-1.29-1.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,1.42,0l4-4a1,1,0,0,0-1.42-1.42ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.29,13.79l-.29.3V11.5a1,1,0,0,0-2,0v2.59l-.29-.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2-2a1,1,0,0,0-1.42-1.42ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderExclamation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.92,16.12a.76.76,0,0,0-.09-.18,1.58,1.58,0,0,0-.12-.15l-.15-.12-.18-.09a.6.6,0,0,0-.19-.06,1,1,0,0,0-.9.27l-.12.15a.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2,1,1,0,0,0,.08.38,1.15,1.15,0,0,0,.21.33,1,1,0,0,0,1.09.22,1.46,1.46,0,0,0,.33-.22,1.46,1.46,0,0,0,.22-.33A1,1,0,0,0,13,16.5a1.36,1.36,0,0,0,0-.2A.64.64,0,0,0,12.92,16.12ZM12,10.5a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0v-2A1,1,0,0,0,12,10.5Zm7-5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderExclamation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderExclamation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,9.84a2.92,2.92,0,0,0-3.43,4.65l2.72,2.72a1,1,0,0,0,1.42,0l2.72-2.72A2.92,2.92,0,0,0,12,9.84Zm2,3.23-2,2-2-2a.92.92,0,0,1,0-1.3.92.92,0,0,1,1.3,0,1,1,0,0,0,1.42,0,.92.92,0,0,1,1.3,1.3ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,13.5a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0v-2A1,1,0,0,0,12,13.5Zm7-8H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Zm-7.29-7.71a1,1,0,0,0-1.09-.21.93.93,0,0,0-.33.21,1.05,1.05,0,0,0-.29.71,1,1,0,0,0,.29.7,1,1,0,0,0,1.42,0,1,1,0,0,0,.29-.7,1,1,0,0,0-.08-.38A.93.93,0,0,0,12.71,10.79Z'
  }));
};

UilFolderInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4,4H8.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,11,7h7a1,1,0,0,1,1,1,1,1,0,0,0,2,0,3,3,0,0,0-3-3H11.72l-.32-1A3,3,0,0,0,8.56,2H4A3,3,0,0,0,1,5V18a3,3,0,0,0,3,3h6a1,1,0,0,0,0-2H4a1,1,0,0,1-1-1V5A1,1,0,0,1,4,4ZM21,15.18V14a3,3,0,0,0-6,0v1.18A3,3,0,0,0,13,18v2a3,3,0,0,0,3,3h4a3,3,0,0,0,3-3V18A3,3,0,0,0,21,15.18ZM17,14a1,1,0,0,1,2,0v1H17Zm4,6a1,1,0,0,1-1,1H16a1,1,0,0,1-1-1V18a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1Z'
  }));
};

UilFolderLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,12.5H13v-1a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h1a1,1,0,0,0,0-2Zm5-7H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,12.5H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm5-7H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderNetwork = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,18H14.82A3,3,0,0,0,13,16.18V14h3.67A2.34,2.34,0,0,0,19,11.67V6.33A2.34,2.34,0,0,0,16.67,4h-4l-.13-.41A2.34,2.34,0,0,0,10.37,2h-3A2.34,2.34,0,0,0,5,4.33v7.34A2.34,2.34,0,0,0,7.33,14H11v2.18A3,3,0,0,0,9.18,18H3a1,1,0,0,0,0,2H9.18a3,3,0,0,0,5.64,0H21a1,1,0,0,0,0-2ZM7.33,12A.33.33,0,0,1,7,11.67V4.33A.33.33,0,0,1,7.33,4h3a.33.33,0,0,1,.32.23l.36,1.09A1,1,0,0,0,12,6h4.67a.33.33,0,0,1,.33.33v5.34a.33.33,0,0,1-.33.33ZM12,20a1,1,0,1,1,1-1A1,1,0,0,1,12,20Z'
  }));
};

UilFolderNetwork.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderNetwork.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderOpen = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.78,10.37A1,1,0,0,0,22,10H20V9a3,3,0,0,0-3-3H10.72l-.32-1A3,3,0,0,0,7.56,3H4A3,3,0,0,0,1,6V18a3,3,0,0,0,3,3H18.4a3,3,0,0,0,2.92-2.35L23,11.22A1,1,0,0,0,22.78,10.37ZM5.37,18.22a1,1,0,0,1-1,.78H4a1,1,0,0,1-1-1V6A1,1,0,0,1,4,5H7.56a1,1,0,0,1,1,.68l.54,1.64A1,1,0,0,0,10,8h7a1,1,0,0,1,1,1v1H8a1,1,0,0,0-1,.78Zm14,0a1,1,0,0,1-1,.78H7.21a1.42,1.42,0,0,0,.11-.35L8.8,12h12Z'
  }));
};

UilFolderOpen.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderOpen.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,12.5H13v-1a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h1a1,1,0,0,0,0-2Zm5-7H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.57,16.3a.64.64,0,0,0-.15-.13l-.17-.09L12.06,16a1,1,0,0,0-.9.28,1,1,0,0,0-.22.32,1,1,0,0,0-.07.39,1,1,0,0,0,.29.7,1,1,0,0,0,.32.22,1,1,0,0,0,.39.07,1,1,0,0,0,.38-.07,1,1,0,0,0,.32-.22,1,1,0,0,0,.3-.7,1,1,0,0,0-.08-.39A.87.87,0,0,0,12.57,16.3ZM11.87,9a3,3,0,0,0-2.6,1.5,1,1,0,1,0,1.73,1,1,1,0,0,1,1.87.5,1,1,0,0,1-1,1,1,1,0,1,0,0,2,3,3,0,0,0,0-6ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,20.29l-1.6-1.6h0L3.71,2.29A1,1,0,0,0,2.29,3.71L3.69,5.1A3,3,0,0,0,3,7V18a3,3,0,0,0,3,3H18a3,3,0,0,0,1.29-.3l1,1a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM6,19a1,1,0,0,1-1-1V7a1,1,0,0,1,.12-.46L17.59,19ZM10.62,6a1,1,0,0,1,.89.67l.54,1.64A1,1,0,0,0,13,9h5a1,1,0,0,1,1,1v4.34a1,1,0,1,0,2,0V10a3,3,0,0,0-3-3H13.72L13.4,6a3,3,0,0,0-2.68-2,1,1,0,0,0-.1,2Z'
  }));
};

UilFolderSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.71,10.79a1,1,0,0,0-1.42,0L12,12.09l-1.29-1.3a1,1,0,0,0-1.42,1.42l1.3,1.29-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L12,14.91l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-1.3-1.29,1.3-1.29A1,1,0,0,0,14.71,10.79ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFolderUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,10.79a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2,2a1,1,0,0,0,1.42,1.42l.29-.3V16.5a1,1,0,0,0,2,0V13.91l.29.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z'
  }));
};

UilFolderUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFolderUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFont = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H20V3a1,1,0,0,0-1-1H15.5a1,1,0,0,0-.86.5L4.43,20H3a1,1,0,0,0,0,2H7a1,1,0,0,0,0-2H6.74l3.5-6H18v6H17a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm-3-8H11.41l4.66-8H18Z'
  }));
};

UilFont.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFont.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFootball = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.07,6.11a9.85,9.85,0,0,0-4.3-3.36A10,10,0,0,0,2,12c0,.19,0,.38,0,.56A9.94,9.94,0,0,0,3.33,17a10,10,0,0,0,5.89,4.65h0A10.11,10.11,0,0,0,12,22a9.45,9.45,0,0,0,1.88-.18,10,10,0,0,0,8-8.41A9.46,9.46,0,0,0,22,12,9.83,9.83,0,0,0,20.07,6.11Zm-2,.77L17,9.74l-1.62.44L13,8.49V6.64l2.49-1.81A7.81,7.81,0,0,1,18.11,6.88ZM14,11.67,13.22,14H10.77L10,11.67l2-1.43ZM12,4a8,8,0,0,1,1.11.09L12,4.89l-1.11-.8A8,8,0,0,1,12,4ZM4.88,8.37l.4,1.32-1.13.79A7.88,7.88,0,0,1,4.88,8.37Zm1.37,9.17,1.38.05L8,18.92A8.32,8.32,0,0,1,6.25,17.54ZM8,15.6l-3.15-.11A7.83,7.83,0,0,1,4.07,13l2.49-1.74L8,11.88l.89,2.76Zm.86-5.53-1.56-.7-.91-3A7.93,7.93,0,0,1,8.5,4.83L11,6.64V8.49ZM13,19.93a8.08,8.08,0,0,1-2.63-.12l-.83-2.92.83-.89h3.07l.67,1Zm2.41-.7L15.87,18l1.36.07A7.83,7.83,0,0,1,15.38,19.23Zm3.46-3.12L15.76,16l-.71-1.1.89-2.76,1.51-.41,2.36,2A7.84,7.84,0,0,1,18.84,16.11Zm.05-5.83L19.4,9a7.4,7.4,0,0,1,.53,2.13Z'
  }));
};

UilFootball.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFootball.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFootballAmerican = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.84,5.56A4.08,4.08,0,0,0,20.7,3.31h0a4.08,4.08,0,0,0-2.25-1.14,13.65,13.65,0,0,0-5.29.24,1.17,1.17,0,0,0-.2.06,14.44,14.44,0,0,0-6.69,3.8A14.59,14.59,0,0,0,2.45,13c0,.06,0,.12-.05.19a13.7,13.7,0,0,0-.24,5.3A4.08,4.08,0,0,0,3.3,20.69h0a4.08,4.08,0,0,0,2.25,1.14A13.12,13.12,0,0,0,7.63,22a13.8,13.8,0,0,0,3.26-.41l.14,0a14.54,14.54,0,0,0,10.52-10.5c0-.06,0-.12.05-.19A13.7,13.7,0,0,0,21.84,5.56ZM16.37,4a10.44,10.44,0,0,1,1.76.14,1.68,1.68,0,0,1,.24.07L17,5.59,15.46,4.05C15.76,4,16.07,4,16.37,4ZM7.67,7.67a12.72,12.72,0,0,1,5.4-3.19L15.59,7,13.44,9.15l-.73-.73a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l.73.73L10.56,12l-.73-.73a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l.73.73L7,15.59,4.49,13.08A12.67,12.67,0,0,1,7.67,7.67ZM4.21,18.37a1.68,1.68,0,0,1-.07-.24A11.38,11.38,0,0,1,4,15.46L5.59,17Zm1.66,1.49a1.68,1.68,0,0,1-.24-.07L7,18.41,8.54,20A11.38,11.38,0,0,1,5.87,19.86Zm10.46-3.53a12.67,12.67,0,0,1-5.41,3.18L8.41,17l2.15-2.15.73.73a1,1,0,1,0,1.42-1.41L12,13.44,13.44,12l.73.73a1,1,0,0,0,.71.29,1,1,0,0,0,.7-1.71l-.73-.73L17,8.41l2.51,2.51A12.67,12.67,0,0,1,16.33,16.33ZM20,8.54,18.41,7l1.38-1.37a1.68,1.68,0,0,1,.07.24A11.38,11.38,0,0,1,20,8.54Z'
  }));
};

UilFootballAmerican.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFootballAmerican.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFootballBall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.84,5.56A4.08,4.08,0,0,0,20.7,3.31h0a4.08,4.08,0,0,0-2.25-1.14A14.45,14.45,0,0,0,2.16,18.44,4.08,4.08,0,0,0,3.3,20.69h0a4.08,4.08,0,0,0,2.25,1.14A13.12,13.12,0,0,0,7.63,22a14.37,14.37,0,0,0,10.11-4.26A14.23,14.23,0,0,0,21.84,5.56ZM4.21,18.37a1.68,1.68,0,0,1-.07-.24A12.21,12.21,0,0,1,7.67,7.67,12.39,12.39,0,0,1,16.37,4a10.44,10.44,0,0,1,1.76.14,1.68,1.68,0,0,1,.24.07L13.44,9.15l-.73-.73a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41l.73.73L10.56,12l-.73-.73a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l.73.73Zm12.12-2A12.24,12.24,0,0,1,5.87,19.86a1.68,1.68,0,0,1-.24-.07l4.93-4.94.73.73a1,1,0,1,0,1.42-1.41L12,13.44,13.44,12l.73.73a1,1,0,0,0,.71.29,1,1,0,0,0,.7-1.71l-.73-.73,4.94-4.93a1.68,1.68,0,0,1,.07.24A12.21,12.21,0,0,1,16.33,16.33Z'
  }));
};

UilFootballBall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFootballBall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilForecastcloudMoonTear = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.7,7.57a1,1,0,0,0-.93-.26,3.2,3.2,0,0,1-.66.08,3,3,0,0,1-3-3,3,3,0,0,1,.08-.65A1,1,0,0,0,16,2.53a4.93,4.93,0,0,0-3.83,4.21A6.24,6.24,0,0,0,10.5,6.5a6,6,0,0,0-5.94,5.13,3.5,3.5,0,0,0-.46,6.58,1.14,1.14,0,0,0,.4.08,1,1,0,0,0,.4-1.92A1.48,1.48,0,0,1,4,15a1.5,1.5,0,0,1,1.5-1.5,1,1,0,0,0,1-1,4,4,0,0,1,4-4,3.92,3.92,0,0,1,2.18.66h0a4,4,0,0,1,1.57,2,1,1,0,0,0,.78.67A2.32,2.32,0,0,1,16,16.11a1,1,0,0,0,1.1,1.68A4.32,4.32,0,0,0,19,14.17a4.23,4.23,0,0,0-.49-2A4.94,4.94,0,0,0,22,8.5,1,1,0,0,0,21.7,7.57Zm-4.59,2.82a2.61,2.61,0,0,1-.42,0A4.6,4.6,0,0,0,16,10a6,6,0,0,0-1.82-2.28c0-.12,0-.25,0-.37a3,3,0,0,1,1.05-2.28,5,5,0,0,0,4.23,4.23A3,3,0,0,1,17.11,10.39Zm-6,3.94a1,1,0,0,0-1.12,0C9.84,14.41,7.5,16,7.5,18.5a3,3,0,0,0,6,0C13.5,16,11.15,14.4,11.06,14.33ZM10.5,19.5a1,1,0,0,1-1-1,3,3,0,0,1,1-2,3,3,0,0,1,1,2A1,1,0,0,1,10.5,19.5Z'
  }));
};

UilForecastcloudMoonTear.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilForecastcloudMoonTear.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilForwadedCall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.94,6.56h3.58l-.79.8a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0l2.5-2.5a1,1,0,0,0,0-1.41l-2.5-2.5a1,1,0,0,0-1.41,1.41l.79.79H14.94a1,1,0,0,0,0,2ZM19.44,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1.06,1.06,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1Z'
  }));
};

UilForwadedCall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilForwadedCall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilForward = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.67,9.69,14,5.84a2.67,2.67,0,0,0-4,2.31h0L6,5.84A2.67,2.67,0,0,0,2,8.15v7.7a2.63,2.63,0,0,0,1.33,2.3,2.61,2.61,0,0,0,1.34.37A2.69,2.69,0,0,0,6,18.16l4-2.31h0a2.65,2.65,0,0,0,1.33,2.31,2.66,2.66,0,0,0,2.67,0l6.67-3.85a2.67,2.67,0,0,0,0-4.62ZM10,13.54,5,16.42a.67.67,0,0,1-1-.57V8.15a.67.67,0,0,1,1-.57l5,2.88Zm9.67-1L13,16.43a.69.69,0,0,1-.67,0,.66.66,0,0,1-.33-.58V8.15a.66.66,0,0,1,.33-.58.78.78,0,0,1,.34-.09.63.63,0,0,1,.33.09l6.67,3.85a.67.67,0,0,1,0,1.16Z'
  }));
};

UilForward.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilForward.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilFrown = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.36,15.33a1,1,0,0,0-.13,1.4,1,1,0,0,0,1.41.13,3.76,3.76,0,0,1,4.72,0,1,1,0,0,0,1.41-.13,1,1,0,0,0-.13-1.4A5.81,5.81,0,0,0,8.36,15.33ZM9,11a1,1,0,1,0-1-1A1,1,0,0,0,9,11Zm3-9A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM15,9a1,1,0,1,0,1,1A1,1,0,0,0,15,9Z'
  }));
};

UilFrown.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilFrown.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGameStructure = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,18H19V15a1,1,0,0,0-1-1H13V11.29l1.13.59a1,1,0,0,0,1.45-1.05l-.4-2.37L16.9,6.77a1,1,0,0,0,.26-1,1,1,0,0,0-.81-.68L14,4.72,12.9,2.56a1,1,0,0,0-1.8,0L10,4.72l-2.39.35a1,1,0,0,0-.81.68,1,1,0,0,0,.26,1L8.82,8.46l-.4,2.37a1,1,0,0,0,1.45,1.05L11,11.29V14H6a1,1,0,0,0-1,1v3H3a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V20H8v1a1,1,0,0,0,2,0V19a1,1,0,0,0-1-1H7V16H17v2H15a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V20h4v1a1,1,0,0,0,2,0V19A1,1,0,0,0,21,18ZM12,8.63a1,1,0,0,0-.47.12l-.8.42.15-.9a1,1,0,0,0-.29-.88l-.65-.64.9-.13a1,1,0,0,0,.76-.54l.4-.82.4.82a1,1,0,0,0,.76.54l.9.13-.65.64a1,1,0,0,0-.29.88l.15.9-.8-.42A1,1,0,0,0,12,8.63Z'
  }));
};

UilGameStructure.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGameStructure.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGift = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,7h-.35A3.45,3.45,0,0,0,18,5.5a3.49,3.49,0,0,0-6-2.44A3.49,3.49,0,0,0,6,5.5,3.45,3.45,0,0,0,6.35,7H6a3,3,0,0,0-3,3v2a1,1,0,0,0,1,1H5v6a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V13h1a1,1,0,0,0,1-1V10A3,3,0,0,0,18,7ZM11,20H8a1,1,0,0,1-1-1V13h4Zm0-9H5V10A1,1,0,0,1,6,9h5Zm0-4H9.5A1.5,1.5,0,1,1,11,5.5Zm2-1.5A1.5,1.5,0,1,1,14.5,7H13ZM17,19a1,1,0,0,1-1,1H13V13h4Zm2-8H13V9h5a1,1,0,0,1,1,1Z'
  }));
};

UilGift.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGift.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGithub = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2.2467A10.00042,10.00042,0,0,0,8.83752,21.73419c.5.08752.6875-.21247.6875-.475,0-.23749-.01251-1.025-.01251-1.86249C7,19.85919,6.35,18.78423,6.15,18.22173A3.636,3.636,0,0,0,5.125,16.8092c-.35-.1875-.85-.65-.01251-.66248A2.00117,2.00117,0,0,1,6.65,17.17169a2.13742,2.13742,0,0,0,2.91248.825A2.10376,2.10376,0,0,1,10.2,16.65923c-2.225-.25-4.55-1.11254-4.55-4.9375a3.89187,3.89187,0,0,1,1.025-2.6875,3.59373,3.59373,0,0,1,.1-2.65s.83747-.26251,2.75,1.025a9.42747,9.42747,0,0,1,5,0c1.91248-1.3,2.75-1.025,2.75-1.025a3.59323,3.59323,0,0,1,.1,2.65,3.869,3.869,0,0,1,1.025,2.6875c0,3.83747-2.33752,4.6875-4.5625,4.9375a2.36814,2.36814,0,0,1,.675,1.85c0,1.33752-.01251,2.41248-.01251,2.75,0,.26251.1875.575.6875.475A10.0053,10.0053,0,0,0,12,2.2467Z'
  }));
};

UilGithub.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGithub.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGithubAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.07031,20.50291a1.00008,1.00008,0,0,0-1.18115-.9834c-1.30908.24024-2.96191.27637-3.40137-.958a5.70754,5.70754,0,0,0-1.83691-2.415,1.20073,1.20073,0,0,1-.1665-.10938,1,1,0,0,0-.93067-.64551H2.54883a.99965.99965,0,0,0-1,.99512c-.00391.81543.811,1.33789,1.1416,1.51465a4.4408,4.4408,0,0,1,.92383,1.35937c.36426,1.02344,1.42285,2.57617,4.46582,2.376.001.03516.00195.06836.00244.09863l.00439.26758a1,1,0,0,0,2,0l-.00488-.31836C10.07715,21.4951,10.07031,21.22068,10.07031,20.50291Zm10.667-15.126c.03174-.125.063-.26367.09034-.41992a6.27792,6.27792,0,0,0-.40821-3.293,1.002,1.002,0,0,0-.61572-.58007c-.356-.12012-1.67041-.35645-4.18408,1.25a13.86918,13.86918,0,0,0-6.354,0C6.76221.751,5.45459.9658,5.10205,1.07908a.99744.99744,0,0,0-.63135.584,6.3003,6.3003,0,0,0-.40332,3.35644c.02442.12793.05078.2461.07813.35449A6.26928,6.26928,0,0,0,2.89014,9.20311a8.42168,8.42168,0,0,0,.04248.92187c.334,4.60254,3.334,5.98438,5.42431,6.459-.04345.125-.083.25878-.11816.40039a1.00023,1.00023,0,0,0,1.94238.47851,1.6784,1.6784,0,0,1,.46778-.87793.99947.99947,0,0,0-.5459-1.74512c-3.4541-.39453-4.95362-1.80175-5.1792-4.89843a6.61076,6.61076,0,0,1-.03369-.73828,4.25769,4.25769,0,0,1,.91943-2.71289,3.022,3.022,0,0,1,.1958-.23145.99988.99988,0,0,0,.188-1.02441,3.3876,3.3876,0,0,1-.15527-.55567A4.09356,4.09356,0,0,1,6.1167,3.06346a7.54263,7.54263,0,0,1,2.415,1.17968,1.00877,1.00877,0,0,0,.82764.13282,11.77716,11.77716,0,0,1,6.17285.001,1.00549,1.00549,0,0,0,.83056-.13769,7.572,7.572,0,0,1,2.40528-1.19043,4.03977,4.03977,0,0,1,.0874,1.57812,3.205,3.205,0,0,1-.16895.60743.9999.9999,0,0,0,.188,1.02441c.07715.08691.1543.18066.22363.26855A4.12186,4.12186,0,0,1,20,9.20311a7.03888,7.03888,0,0,1-.0376.77734c-.22021,3.05566-1.72558,4.46387-5.1958,4.85937a1,1,0,0,0-.54541,1.7461,1.63079,1.63079,0,0,1,.46631.9082,3.06079,3.06079,0,0,1,.09229.81934v2.334C14.77,21.2949,14.77,21.78025,14.77,22.00291a1,1,0,1,0,2,0c0-.2168,0-.69238.00977-1.33984V18.31346a4.8815,4.8815,0,0,0-.15479-1.31153,4.25638,4.25638,0,0,0-.11621-.416,6.51258,6.51258,0,0,0,5.44531-6.42383A8.69677,8.69677,0,0,0,22,9.20311,6.13062,6.13062,0,0,0,20.7373,5.37693Z'
  }));
};

UilGithubAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGithubAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGlass = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.75,2.33A1,1,0,0,0,19,2H5a1,1,0,0,0-.75.33A1,1,0,0,0,4,3.11l1.8,16.22a3,3,0,0,0,3,2.67h6.42a3,3,0,0,0,3-2.67L20,3.11A1,1,0,0,0,19.75,2.33ZM16.2,19.11a1,1,0,0,1-1,.89H8.79a1,1,0,0,1-1-.89L6.78,10H17.22ZM17.44,8H6.56L6.12,4H17.88Z'
  }));
};

UilGlass.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGlass.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGlassMartini = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,20H13V14.94A9,9,0,0,0,21,6a8.72,8.72,0,0,0-.67-3.39,1,1,0,0,0-.22-.32L20,2.21a.92.92,0,0,0-.21-.13A.94.94,0,0,0,19.51,2l-.1,0H4.59L4.5,2a.94.94,0,0,0-.29.06A2.12,2.12,0,0,0,4,2.2l-.12.09a1,1,0,0,0-.22.32A8.72,8.72,0,0,0,3,6a9,9,0,0,0,8,8.94V20H6a1,1,0,0,0,0,2H18a1,1,0,0,0,0-2ZM5,6a6.91,6.91,0,0,1,.29-2H18.71A6.91,6.91,0,0,1,19,6,7,7,0,0,1,5,6Z'
  }));
};

UilGlassMartini.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGlassMartini.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGlassMartiniAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.78,3.62a1,1,0,0,0,.12-1.05A1,1,0,0,0,21,2H3a1,1,0,0,0-.9.57,1,1,0,0,0,.12,1.05L11,14.6V20H5.25a1,1,0,0,0,0,2h13.5a1,1,0,0,0,0-2H13V14.6ZM5.08,4H18.92l-2.4,3h-9ZM12,12.65,9.08,9h5.84Z'
  }));
};

UilGlassMartiniAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGlassMartiniAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGlassMartiniAltSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.71,16.29l-14-14A1,1,0,0,0,4.29,3.71L6.59,6H5a1,1,0,0,0-.9.57,1,1,0,0,0,.12,1L11,16.1V20H6.75a1,1,0,0,0,0,2h10.5a1,1,0,0,0,0-2H13V16.1l1.64-2,3.65,3.65a1,1,0,0,0,1.42,0A1,1,0,0,0,19.71,16.29ZM7.08,8H8.59l1.89,1.89H8.59ZM12,14.15l-1.81-2.26h2.29l.74.74ZM14.66,8h2.26l-.63.79a1,1,0,0,0,.15,1.4,1,1,0,0,0,.63.22,1,1,0,0,0,.78-.37l1.93-2.42a1,1,0,0,0,.12-1A1,1,0,0,0,19,6H14.66a1,1,0,0,0,0,2Z'
  }));
};

UilGlassMartiniAltSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGlassMartiniAltSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGlassTea = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,3a3,3,0,0,0-2.23-1H7.23a3,3,0,0,0-3,3.33l1.56,14a3,3,0,0,0,3,2.67h6.42a3,3,0,0,0,3-2.67l1.56-14A3,3,0,0,0,19,3ZM16.2,19.11a1,1,0,0,1-1,.89H8.79a1,1,0,0,1-1-.89L6.78,10H17.22ZM17.44,8H6.56L6.24,5.11a1,1,0,0,1,.25-.78A1,1,0,0,1,7.23,4h9.54a1,1,0,0,1,.74.33,1,1,0,0,1,.25.78ZM14,18a1,1,0,0,0,1-1V13a1,1,0,0,0-2,0v4A1,1,0,0,0,14,18Zm-4,0a1,1,0,0,0,1-1V13a1,1,0,0,0-2,0v4A1,1,0,0,0,10,18Z'
  }));
};

UilGlassTea.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGlassTea.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGlobe = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.41,8.64s0,0,0-.05a10,10,0,0,0-18.78,0s0,0,0,.05a9.86,9.86,0,0,0,0,6.72s0,0,0,.05a10,10,0,0,0,18.78,0s0,0,0-.05a9.86,9.86,0,0,0,0-6.72ZM4.26,14a7.82,7.82,0,0,1,0-4H6.12a16.73,16.73,0,0,0,0,4Zm.82,2h1.4a12.15,12.15,0,0,0,1,2.57A8,8,0,0,1,5.08,16Zm1.4-8H5.08A8,8,0,0,1,7.45,5.43,12.15,12.15,0,0,0,6.48,8ZM11,19.7A6.34,6.34,0,0,1,8.57,16H11ZM11,14H8.14a14.36,14.36,0,0,1,0-4H11Zm0-6H8.57A6.34,6.34,0,0,1,11,4.3Zm7.92,0h-1.4a12.15,12.15,0,0,0-1-2.57A8,8,0,0,1,18.92,8ZM13,4.3A6.34,6.34,0,0,1,15.43,8H13Zm0,15.4V16h2.43A6.34,6.34,0,0,1,13,19.7ZM15.86,14H13V10h2.86a14.36,14.36,0,0,1,0,4Zm.69,4.57a12.15,12.15,0,0,0,1-2.57h1.4A8,8,0,0,1,16.55,18.57ZM19.74,14H17.88A16.16,16.16,0,0,0,18,12a16.28,16.28,0,0,0-.12-2h1.86a7.82,7.82,0,0,1,0,4Z'
  }));
};

UilGlobe.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGlobe.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGold = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,11h8a1,1,0,0,0,.77-.37A1,1,0,0,0,17,9.8l-1-5A1,1,0,0,0,15,4H9a1,1,0,0,0-1,.8l-1,5a1,1,0,0,0,.21.83A1,1,0,0,0,8,11ZM9.82,6h4.36l.6,3H9.22ZM22,13.8a1,1,0,0,0-1-.8H15a1,1,0,0,0-1,.8l-1,5a1,1,0,0,0,.21.83A1,1,0,0,0,14,20h8a1,1,0,0,0,.77-.37A1,1,0,0,0,23,18.8ZM15.22,18l.6-3h4.36l.6,3ZM9,13H3a1,1,0,0,0-1,.8l-1,5a1,1,0,0,0,.21.83A1,1,0,0,0,2,20h8a1,1,0,0,0,.77-.37A1,1,0,0,0,11,18.8l-1-5A1,1,0,0,0,9,13ZM3.22,18l.6-3H8.18l.6,3Z'
  }));
};

UilGold.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGold.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGolfBall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,9a1,1,0,1,0,1,1A1,1,0,0,0,14,9Zm0-3a1,1,0,1,0,1,1A1,1,0,0,0,14,6ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM17,8a1,1,0,1,0,1,1A1,1,0,0,0,17,8Z'
  }));
};

UilGolfBall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGolfBall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGoogle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.60229,10.00391a1.00005,1.00005,0,0,0-.98388-.82227H12.2a.99974.99974,0,0,0-1,1V14.0498a.99974.99974,0,0,0,1,1h3.9624a3.65162,3.65162,0,0,1-1.13183,1.1875A5.0604,5.0604,0,0,1,12.2,17.02246a4.93525,4.93525,0,0,1-4.64624-3.4378L7.55347,13.583a4.90382,4.90382,0,0,1,0-3.167l.00024-.00165A4.9356,4.9356,0,0,1,12.2,6.97754,4.37756,4.37756,0,0,1,15.3313,8.19531a1.00053,1.00053,0,0,0,1.39844-.01562L19.5979,5.31152a.99918.99918,0,0,0-.02539-1.43847A10.62342,10.62342,0,0,0,12.2,1,10.949,10.949,0,0,0,2.37134,7.05878l-.00147.00177A10.92175,10.92175,0,0,0,1.2,12a11.07862,11.07862,0,0,0,1.16992,4.93945l.00147.00177A10.949,10.949,0,0,0,12.2,23a10.5255,10.5255,0,0,0,7.29468-2.687l.00073-.00049.00079-.00085.00019-.00013.00006-.00012a10.78575,10.78575,0,0,0,3.30365-8.08386A12.51533,12.51533,0,0,0,22.60229,10.00391ZM12.2,3a8.68219,8.68219,0,0,1,5.2085,1.67285L15.95483,6.126A6.46322,6.46322,0,0,0,12.2,4.97754,6.88648,6.88648,0,0,0,6.21069,8.52832L5.14148,7.69958l-.585-.45367A8.95257,8.95257,0,0,1,12.2,3ZM3.67944,14.90332a9.02957,9.02957,0,0,1,0-5.80664l1.78223,1.38184a6.85381,6.85381,0,0,0,0,3.042ZM12.2,21A8.9528,8.9528,0,0,1,4.5564,16.75391l.37841-.29352,1.27588-.98969A6.88482,6.88482,0,0,0,12.2,19.02246a7.27662,7.27662,0,0,0,3.30573-.75079L17.19739,19.585A8.88989,8.88989,0,0,1,12.2,21Zm6.52588-2.76074-.183-.142L17.16553,17.028a5.60626,5.60626,0,0,0,1.39966-2.79553.9998.9998,0,0,0-.9834-1.18262H13.2V11.18164h7.54883c.03418.3457.05127.69531.05127,1.0459A9.05156,9.05156,0,0,1,18.72583,18.23926Z'
  }));
};

UilGoogle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGoogle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGoogleDrive = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.4231,13.88785,15.33356,3.33792H8.66663l6.09,10.54993ZM8.08917,4.33835,2,14.88736l3.33356,5.77472,6.08911-10.54926Zm1.73273,10.549L6.48877,20.66208H18.66663L22,14.88736Z'
  }));
};

UilGoogleDrive.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGoogleDrive.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGoogleDriveAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,14.44a.62.62,0,0,0,0-.13.61.61,0,0,1,0-.12l-.05-.12h0l-6-10.29A1,1,0,0,0,15,3.29H9a1,1,0,0,0-.5.13l-.11.08a.73.73,0,0,0-.09.08.58.58,0,0,0-.1.12s0,0-.06.08h0l-6,10.33a1,1,0,0,0,0,1l3,5.08h0a.83.83,0,0,0,.11.15l0,.06a1.1,1.1,0,0,0,.44.26h0a.83.83,0,0,0,.22,0H18a1,1,0,0,0,.86-.49l3-5.14h0l.05-.12a.61.61,0,0,1,0-.12.53.53,0,0,0,0-.13.51.51,0,0,0,0-.13A.59.59,0,0,0,22,14.44ZM6,17.73l-1.79-3.1L9,6.27l.87,1.5,1,1.66L7,15.91ZM12,11.41l1.26,2.16H10.72Zm5.43,7.3H7.7l1.84-3.14h9.72Zm-1.86-5.14L10.74,5.29h3.69l4.83,8.28Z'
  }));
};

UilGoogleDriveAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGoogleDriveAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGoogleHangouts = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.44411,9.05505a8.50456,8.50456,0,0,0-2.17292-4.334,8.40344,8.40344,0,0,0-1.62213-1.35748,8.48891,8.48891,0,0,0-3.6405-1.30927A4.15272,4.15272,0,0,1,12.52766,2H11.3932c-.01226.02863-.03857.01819-.05944.02014-.29212.02576-.58283.059-.87116.11365A8.45336,8.45336,0,0,0,5.28615,5.2384a8.35853,8.35853,0,0,0-1.8393,4.7085,8.58926,8.58926,0,0,0,.18476,2.52869,8.1479,8.1479,0,0,0,.62426,1.79c.02448.04871.04859.09742.07349.14606A8.601,8.601,0,0,0,6.1125,16.80835a8.5306,8.5306,0,0,0,5.76313,2.33246c.10015.0014.12744.02606.12683.12848-.00458.87353-.00263,1.74719-.00238,2.62085.00006.03393.00268.06775.00464.10986.02825-.01147.04595-.018.063-.02606A17.98894,17.98894,0,0,0,16.558,19.008q.40055-.36466.76892-.76246c.10529-.11334.20972-.22869.31525-.34191.163-.17432.30407-.36908.45776-.55262.17749-.21173.33679-.43676.494-.66327a11.03342,11.03342,0,0,0,.91852-1.5744c.13195-.27887.25756-.55993.36877-.84759a.09617.09617,0,0,0,.01105-.01612,10.277,10.277,0,0,0,.60058-2.439c.03607-.29126.05945-.58435.07422-.87726A8.14067,8.14067,0,0,0,20.44411,9.05505Zm-9.18994,2.81934a2.5047,2.5047,0,0,1-.84,1.87732c-.02844.02637-.056.05389-.08374.08087a2.68427,2.68427,0,0,1-.93378.48065,3.80048,3.80048,0,0,1-.44757.0849.2109.2109,0,0,1-.23492-.15216l.00116-.96814c.00567-.095-.0326-.19678.04352-.28058A.26578.26578,0,0,1,8.897,12.9129a1.77446,1.77446,0,0,0,.49414-.16845,1.13159,1.13159,0,0,0,.53808-.73169c.01215-.05011.02381-.10053.0354-.15088Q8.9438,11.86,7.92323,11.85852a.65268.65268,0,0,1-.17431-.018.413.413,0,0,1-.30652-.38532q-.00192-1.54339.00152-3.087a.46722.46722,0,0,1,.13837-.436.387.387,0,0,1,.25629-.10205q1.50083-.00027,3.00177-.00055a.41616.41616,0,0,1,.39929.52765.38789.38789,0,0,1,.0166.153C11.25649,9.63147,11.26277,10.75317,11.25417,11.87439Zm5.3031.005a2.55694,2.55694,0,0,1-1.55652,2.32789c-.02338.01-.04566.02294-.06848.03442l-.03815.01068-.02161.01227a4.5917,4.5917,0,0,1-.5888.12933.2158.2158,0,0,1-.26941-.21692c-.00153-.10736-.00232-.215-.00318-.32245l.00556-.57727c-.00086-.04254-.00238-.08471-.00226-.127.00018-.14783.057-.2102.24078-.25214a1.31856,1.31856,0,0,0,.63361-.29693,1.26351,1.26351,0,0,0,.37756-.73963l-1.8858-.0036c-.06836-.00012-.13678.00086-.20526-.0003a.419.419,0,0,1-.43244-.43982q.00047-1.52445.00238-3.04877l-.0017-.02936a.43441.43441,0,0,1,.20385-.45166A.38972.38972,0,0,1,13.16,7.83q1.49094-.00082,2.98187-.00086a.41625.41625,0,0,1,.39917.52771.39178.39178,0,0,1,.01654.15289Q16.55757,10.19455,16.55727,11.87939Z'
  }));
};

UilGoogleHangouts.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGoogleHangouts.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGoogleHangoutsAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.9917,7.69049a2,2,0,0,0,0,4l.01514-.00153v.50147a.501.501,0,0,1-.5.5,1,1,0,0,0,0,2,2.50232,2.50232,0,0,0,2.5-2.5v-2.5A.94144.94144,0,0,0,10.9765,9.54,1.99365,1.99365,0,0,0,8.9917,7.69049Zm2.99951-6.68854a9.78734,9.78734,0,0,0-1,19.52344V22.002a.99911.99911,0,0,0,1.23926.97071A12.53481,12.53481,0,0,0,21.69727,11.998a9.73409,9.73409,0,0,0-9.70606-10.9961ZM19.709,11.78223a10.54778,10.54778,0,0,1-6.71777,8.86035V19.57617a.99942.99942,0,0,0-1-1,7.78711,7.78711,0,1,1,7.78809-7.78711A7.94524,7.94524,0,0,1,19.709,11.78223ZM14.9917,7.69049a2,2,0,1,0,0,4l.01514-.00153v.50147a.501.501,0,0,1-.5.5,1,1,0,0,0,0,2,2.50232,2.50232,0,0,0,2.5-2.5v-2.5A.94144.94144,0,0,0,16.9765,9.54,1.99365,1.99365,0,0,0,14.9917,7.69049Z'
  }));
};

UilGoogleHangoutsAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGoogleHangoutsAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGooglePlay = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.91887,10.653c-.31445-.16992-3.01074-1.73438-4.02246-2.32324l-.00293-.002L4.6386,1.25262a1.679,1.679,0,0,0-1.40711-.1593c-.02618.0094-.05078.01886-.07623.03051a1.41835,1.41835,0,0,0-.17291.06922,1.51864,1.51864,0,0,0-.73828,1.36426V21.54266a1.43542,1.43542,0,0,0,.69238,1.2705,1.30761,1.30761,0,0,0,.15479.06373c.02893.01336.05651.025.08636.03552a1.37893,1.37893,0,0,0,.44635.0824,1.67263,1.67263,0,0,0,.83106-.23145c.38867-.22559,12.43847-7.18262,12.43847-7.18262L20.914,13.25945a1.52522,1.52522,0,0,0,.8418-1.334A1.49078,1.49078,0,0,0,20.91887,10.653ZM4.24407,19.839V4.10186l7.94012,7.85907Zm5.018-2.16168,4.34351-4.30957,1.14954,1.13782C13.49047,15.23583,11.35381,16.4696,9.26207,17.67736Zm4.3418-7.125L9.206,6.19933l5.55365,3.2063ZM16.55065,13.469l-1.52539-1.50977L16.553,10.44341c.72027.41828,1.84283,1.06934,2.6159,1.51429Z'
  }));
};

UilGooglePlay.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGooglePlay.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGraduationCap = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.49,10.19l-1-.55h0l-9-5-.11,0a1.06,1.06,0,0,0-.19-.06l-.19,0-.18,0a1.17,1.17,0,0,0-.2.06l-.11,0-9,5a1,1,0,0,0,0,1.74L4,12.76V17.5a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V12.76l2-1.12V14.5a1,1,0,0,0,2,0V11.06A1,1,0,0,0,21.49,10.19ZM16,17.5a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V13.87l4.51,2.5.15.06.09,0a1,1,0,0,0,.25,0h0a1,1,0,0,0,.25,0l.09,0a.47.47,0,0,0,.15-.06L16,13.87Zm-5-3.14L4.06,10.5,11,6.64l6.94,3.86Z'
  }));
};

UilGraduationCap.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGraduationCap.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGraphBar = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6,13H2a1,1,0,0,0-1,1v8a1,1,0,0,0,1,1H6a1,1,0,0,0,1-1V14A1,1,0,0,0,6,13ZM5,21H3V15H5ZM22,9H18a1,1,0,0,0-1,1V22a1,1,0,0,0,1,1h4a1,1,0,0,0,1-1V10A1,1,0,0,0,22,9ZM21,21H19V11h2ZM14,1H10A1,1,0,0,0,9,2V22a1,1,0,0,0,1,1h4a1,1,0,0,0,1-1V2A1,1,0,0,0,14,1ZM13,21H11V3h2Z'
  }));
};

UilGraphBar.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGraphBar.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGrid = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM11,20H4V16h7Zm0-6H4V10h7Zm9,6H13V16h7Zm0-6H13V10h7Zm0-6H4V4H20Z'
  }));
};

UilGrid.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGrid.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGrids = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM8,20H4V4H8Zm6,0H10V4h4Zm6,0H16V4h4Z'
  }));
};

UilGrids.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGrids.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGrin = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,11a1,1,0,1,0-1-1A1,1,0,0,0,9,11Zm3-9A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Zm3-7H9a1,1,0,0,0-1,1,4,4,0,0,0,8,0A1,1,0,0,0,15,13Zm-3,3a2,2,0,0,1-1.73-1h3.46A2,2,0,0,1,12,16Zm3-7a1,1,0,1,0,1,1A1,1,0,0,0,15,9Z'
  }));
};

UilGrin.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGrin.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGrinTongueWink = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM17.62,9.13a3.08,3.08,0,0,0-4.24,0,1,1,0,0,0,1.41,1.41,1,1,0,0,1,1.42,0,1,1,0,0,0,1.41,0A1,1,0,0,0,17.62,9.13ZM9,11a1,1,0,1,0-1-1A1,1,0,0,0,9,11Zm6,2H9a1,1,0,0,0,0,2,3,3,0,0,0,6,0,1,1,0,0,0,0-2Zm-3,3a1,1,0,0,1-1-1h2A1,1,0,0,1,12,16Z'
  }));
};

UilGrinTongueWink.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGrinTongueWink.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGrinTongueWinkAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.21,10.54a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41,3.08,3.08,0,0,0-4.24,0,1,1,0,1,0,1.41,1.41A1,1,0,0,1,9.21,10.54ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM15,9a1,1,0,1,0,1,1A1,1,0,0,0,15,9Zm0,4H9a1,1,0,0,0,0,2,3,3,0,0,0,6,0,1,1,0,0,0,0-2Zm-3,3a1,1,0,0,1-1-1h2A1,1,0,0,1,12,16Z'
  }));
};

UilGrinTongueWinkAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGrinTongueWinkAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilGripHorizontalLine = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,11H21a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2Zm18,2H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilGripHorizontalLine.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilGripHorizontalLine.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHardHat = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,13.17V13a8,8,0,0,0-2.42-5.74A7.84,7.84,0,0,0,14.4,5.38l-.05,0A8.24,8.24,0,0,0,11.76,5,8.21,8.21,0,0,0,4,13.17,3,3,0,0,0,5,19H19a3,3,0,0,0,1-5.83ZM19,17H5a1,1,0,0,1,0-2H7a1,1,0,0,0,0-2H6A6.41,6.41,0,0,1,9,7.85V11a1,1,0,0,0,2,0V7.09A7.34,7.34,0,0,1,11.82,7H12a5.56,5.56,0,0,1,1,.1V11a1,1,0,0,0,2,0V7.82a6.65,6.65,0,0,1,1.18.87A6,6,0,0,1,18,13H17a1,1,0,0,0,0,2h2a1,1,0,0,1,0,2Z'
  }));
};

UilHardHat.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHardHat.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,14.86a0,0,0,0,1,0,0v-.05a2.61,2.61,0,0,0-.1-.57L20.26,4.51a3,3,0,0,0-3-2.51H6.69A3,3,0,0,0,3.74,4.51L2.12,14.22a2.61,2.61,0,0,0-.1.57v.05a0,0,0,0,1,0,0C2,14.91,2,15,2,15v4a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V15C22,15,22,14.91,22,14.86ZM5.71,4.83a1,1,0,0,1,1-.83H17.31a1,1,0,0,1,1,.83l1.2,7.22A2.63,2.63,0,0,0,19,12H5a2.63,2.63,0,0,0-.49.05ZM20,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V15.08l.08-.46A1,1,0,0,1,5,14H19a1,1,0,0,1,.92.62l.08.46Zm-3-3a1,1,0,1,0,1,1A1,1,0,0,0,17,16Z'
  }));
};

UilHdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeadSide = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.23047,2.00342A7.37247,7.37247,0,0,0,7.77734,4.11719,7.44044,7.44044,0,0,0,5.5,9.5v.03027L3.5957,13.57373A.99944.99944,0,0,0,4.5,15h1v2a2.00229,2.00229,0,0,0,2,2h1v2a1,1,0,0,0,2,0V19a1,1,0,0,0,0-2h-3V14a.99974.99974,0,0,0-1-1H6.07617L7.416,10.15576a.99036.99036,0,0,0,.09472-.46435c0-.01026-.00976-.18116-.01074-.19141A5.45491,5.45491,0,0,1,9.16992,5.55273a5.52688,5.52688,0,0,1,4-1.55029A5.6849,5.6849,0,0,1,18.5,9.77246l-1.9668,7.50488a1.01018,1.01018,0,0,0,.00586.5337l1,3.4663a1.00148,1.00148,0,0,0,.96094.72315,1.01777,1.01777,0,0,0,.27734-.03955,1.00043,1.00043,0,0,0,.6836-1.23828l-.92383-3.2002,1.92969-7.26611A1.03147,1.03147,0,0,0,20.5,10V9.77246A7.698,7.698,0,0,0,13.23047,2.00342Z'
  }));
};

UilHeadSide.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeadSide.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeadSideCough = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.29291,20.29291a1,1,0,1,0,1.41418,0A.99988.99988,0,0,0,4.29291,20.29291Zm-3-3a1,1,0,1,0,1.41418,0A.99988.99988,0,0,0,1.29291,17.29291Zm4-1.00073a1,1,0,1,0,1.41418,0A.99988.99988,0,0,0,5.29291,16.29218ZM16.15039,2.00342a7.06726,7.06726,0,0,0-7.28418,7.063V9.082L7.0957,12.84033A.99943.99943,0,0,0,8,14.2666h.86621v1.79981A1.9355,1.9355,0,0,0,10.7998,18H11.667v1.7998a1,1,0,0,0,2,0V17.98639A.99416.99416,0,0,0,13.59961,16l-.8324.0202A.94008.94008,0,0,0,12.667,16a.94011.94011,0,0,0-.12756.02576l-1.67322.04065V13.2666a.99974.99974,0,0,0-1-1H9.57715l1.20508-2.55908a.99032.99032,0,0,0,.09472-.46729c0-.01074-.00976-.16259-.01074-.17382A5.02527,5.02527,0,0,1,12.4043,5.43066a5.09178,5.09178,0,0,1,3.68554-1.42822A5.23852,5.23852,0,0,1,21,9.32129l-1.833,6.9873a1.0083,1.0083,0,0,0,.00586.53321l.93262,3.23486a1.00046,1.00046,0,0,0,.96094.72363,1.01739,1.01739,0,0,0,.27734-.03955.99991.99991,0,0,0,.68359-1.23779l-.85644-2.96924,1.7959-6.76416A1.03147,1.03147,0,0,0,23,9.5332V9.32129A7.25231,7.25231,0,0,0,16.15039,2.00342Z'
  }));
};

UilHeadSideCough.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeadSideCough.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeadSideMask = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.23047,2.00342A7.36652,7.36652,0,0,0,7.77734,4.11719,7.44119,7.44119,0,0,0,5.5,9.46533L3.65625,12.46289a.995.995,0,0,0-.15625.52v.04053a.99952.99952,0,0,0,.07031.34668l1.43946,3.87256c.01269.03418.02734.06689.043.09912A2.9843,2.9843,0,0,0,7.73633,19H8.5v2a1,1,0,0,0,2,0V19h1.99689l.00311.00049a.99907.99907,0,0,0,.32129-.05371l3.70026-1.25623a.99865.99865,0,0,0,.01751.12049l1,3.4663a1.00148,1.00148,0,0,0,.96094.72315,1.01777,1.01777,0,0,0,.27734-.03955,1.00043,1.00043,0,0,0,.6836-1.23828l-.92383-3.2002,1.92969-7.26611A1.03147,1.03147,0,0,0,20.5,10V9.77246A7.698,7.698,0,0,0,13.23047,2.00342ZM11.5,17H7.73633a.99477.99477,0,0,1-.874-.51318L5.93848,14H11.5Zm5.523-1.59137-3.523,1.196V13.72089l4.34479-1.44831Zm1.41211-5.38843a.973.973,0,0,0-.25147.03107L12.3374,12H6.28906l1.07422-1.74658a.99913.99913,0,0,0,.14746-.562c0-.01026-.00976-.18116-.01074-.19141A5.45491,5.45491,0,0,1,9.16992,5.55273a5.52222,5.52222,0,0,1,4-1.55029A5.6849,5.6849,0,0,1,18.5,9.77246Z'
  }));
};

UilHeadSideMask.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeadSideMask.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeadphoneSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.06934,5.93555a9.94468,9.94468,0,0,0-9.38868-2.6709.99992.99992,0,0,0,.43848,1.95117A8.0193,8.0193,0,0,1,20,13h-.33984a1,1,0,0,0,0,2H20v.33984a1,1,0,1,0,2,0V13A9.88842,9.88842,0,0,0,19.06934,5.93555ZM3.707,2.293A.99989.99989,0,0,0,2.293,3.707L4.72833,6.1424A9.96176,9.96176,0,0,0,2,13v7a1,1,0,0,0,1,1H6a3.00328,3.00328,0,0,0,3-3V16a3.00328,3.00328,0,0,0-3-3H4A7.96344,7.96344,0,0,1,6.14453,7.55859L15,16.41406V18a3.00328,3.00328,0,0,0,3,3h1.58594l.707.707A.99989.99989,0,0,0,21.707,20.293ZM6,15a1.0013,1.0013,0,0,1,1,1v2a1.0013,1.0013,0,0,1-1,1H4V15Z'
  }));
};

UilHeadphoneSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeadphoneSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeadphones = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,3A10,10,0,0,0,2,13v7a1,1,0,0,0,1,1H6a3,3,0,0,0,3-3V16a3,3,0,0,0-3-3H4a8,8,0,0,1,16,0H18a3,3,0,0,0-3,3v2a3,3,0,0,0,3,3h3a1,1,0,0,0,1-1V13A10,10,0,0,0,12,3ZM6,15a1,1,0,0,1,1,1v2a1,1,0,0,1-1,1H4V15Zm14,4H18a1,1,0,0,1-1-1V16a1,1,0,0,1,1-1h2Z'
  }));
};

UilHeadphones.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeadphones.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeadphonesAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,13.18V11A8,8,0,0,0,4,11v2.18A3,3,0,0,0,2,16v2a3,3,0,0,0,3,3H8a1,1,0,0,0,1-1V14a1,1,0,0,0-1-1H6V11a6,6,0,0,1,12,0v2H16a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h3a3,3,0,0,0,3-3V16A3,3,0,0,0,20,13.18ZM7,15v4H5a1,1,0,0,1-1-1V16a1,1,0,0,1,1-1Zm13,3a1,1,0,0,1-1,1H17V15h2a1,1,0,0,1,1,1Z'
  }));
};

UilHeadphonesAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeadphonesAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.16,5A6.29,6.29,0,0,0,12,4.36a6.27,6.27,0,0,0-8.16,9.48l6.21,6.22a2.78,2.78,0,0,0,3.9,0l6.21-6.22A6.27,6.27,0,0,0,20.16,5Zm-1.41,7.46-6.21,6.21a.76.76,0,0,1-1.08,0L5.25,12.43a4.29,4.29,0,0,1,0-6,4.27,4.27,0,0,1,6,0,1,1,0,0,0,1.42,0,4.27,4.27,0,0,1,6,0A4.29,4.29,0,0,1,18.75,12.43Z'
  }));
};

UilHeart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeartAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.16,4.61A6.27,6.27,0,0,0,12,4a6.27,6.27,0,0,0-8.16,9.48l7.45,7.45a1,1,0,0,0,1.42,0l7.45-7.45A6.27,6.27,0,0,0,20.16,4.61Zm-1.41,7.46L12,18.81,5.25,12.07a4.28,4.28,0,0,1,3-7.3,4.25,4.25,0,0,1,3,1.25,1,1,0,0,0,1.42,0,4.27,4.27,0,0,1,6,6.05Z'
  }));
};

UilHeartAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeartAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeartBreak = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.16,4.61A6.27,6.27,0,0,0,12,4a6.27,6.27,0,0,0-8.16,9.48l7.45,7.46a1,1,0,0,0,1.42,0l7.45-7.46A6.27,6.27,0,0,0,20.16,4.61Zm-1.41,7.45L12,18.81,5.25,12.06a4.26,4.26,0,0,1,5.54-6.45l-1.71,4a1,1,0,0,0,0,.83,1,1,0,0,0,.65.53l2.77.7L11.1,14.56a1,1,0,0,0,.46,1.34A1,1,0,0,0,12,16a1,1,0,0,0,.9-.56l2-4a1,1,0,0,0,0-.86,1.05,1.05,0,0,0-.67-.55l-2.83-.71,1.45-3.39a4.26,4.26,0,0,1,5.92,6.13Z'
  }));
};

UilHeartBreak.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeartBreak.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeartMedical = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,11H13V10a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V13h1a1,1,0,0,0,0-2Zm6.16-6A6.29,6.29,0,0,0,12,4.41a6.27,6.27,0,0,0-8.16,9.48l6,6.05a3,3,0,0,0,4.24,0l6-6.05A6.27,6.27,0,0,0,20.16,5Zm-1.41,7.46-6,6a1,1,0,0,1-1.42,0l-6-6a4.29,4.29,0,0,1,0-6,4.27,4.27,0,0,1,6,0,1,1,0,0,0,1.42,0,4.27,4.27,0,0,1,6,0A4.29,4.29,0,0,1,18.75,12.48Z'
  }));
};

UilHeartMedical.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeartMedical.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeartRate = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11H17.06a.78.78,0,0,0-.21,0l-.17,0a1.3,1.3,0,0,0-.15.1,1.67,1.67,0,0,0-.16.12,1,1,0,0,0-.09.13,1.32,1.32,0,0,0-.12.2v0l-1.6,4.41L10.39,4.66a1,1,0,0,0-1.88,0L6.2,11H3a1,1,0,0,0,0,2H6.92L7.15,13l.15,0a.86.86,0,0,0,.16-.1,1.67,1.67,0,0,0,.16-.12l.09-.13a1,1,0,0,0,.12-.2v0L9.45,7.92l4.16,11.42a1,1,0,0,0,.94.66h0a1,1,0,0,0,.94-.66L17.79,13H21a1,1,0,0,0,0-2Z'
  }));
};

UilHeartRate.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeartRate.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeartSign = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.16,5A6.29,6.29,0,0,0,12,4.41a6.27,6.27,0,0,0-8.16,9.48l6,6.05a3,3,0,0,0,4.24,0l6-6.05A6.27,6.27,0,0,0,20.16,5Zm-1.41,7.46-6,6a1,1,0,0,1-1.42,0l-6-6a4.29,4.29,0,0,1,0-6,4.27,4.27,0,0,1,6,0,1,1,0,0,0,1.42,0,4.27,4.27,0,0,1,6,6Z'
  }));
};

UilHeartSign.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeartSign.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHeartbeat = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,10.41H18.5a1,1,0,0,0-.71.3L16.55,12l-2.8-3.19a1,1,0,0,0-1.46,0l-1.7,1.7H9a1,1,0,0,0,0,2h2a1,1,0,0,0,.71-.29L13,10.88l2.8,3.19a1,1,0,0,0,.72.34h0a1,1,0,0,0,.71-.29l1.7-1.71H21a1,1,0,0,0,0-2Zm-7.39,5.3-1.9,1.9a1,1,0,0,1-1.42,0L5.08,12.4a3.69,3.69,0,0,1,0-5.22,3.69,3.69,0,0,1,5.21,0,1,1,0,0,0,1.42,0,3.78,3.78,0,0,1,5.21,0,3.94,3.94,0,0,1,.58.75,1,1,0,0,0,1.72-1,6,6,0,0,0-.88-1.13A5.68,5.68,0,0,0,11,5.17,5.68,5.68,0,0,0,2,9.79a5.62,5.62,0,0,0,1.67,4L8.88,19a3,3,0,0,0,4.24,0L15,17.12a1,1,0,0,0,0-1.41A1,1,0,0,0,13.61,15.71Z'
  }));
};

UilHeartbeat.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHeartbeat.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHindiToChinese = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.022,2h-2a1,1,0,0,0,0,2V6H7.83771A2.96481,2.96481,0,0,0,8.022,5,3,3,0,0,0,2.42383,3.5a1.00016,1.00016,0,1,0,1.73242,1A1.00171,1.00171,0,0,1,5.022,4a1,1,0,0,1,0,2,1,1,0,0,0,0,2,1,1,0,0,1,0,2,1.00171,1.00171,0,0,1-.86572-.5,1.00016,1.00016,0,1,0-1.73242,1A3,3,0,0,0,8.022,9a2.96481,2.96481,0,0,0-.18426-1H9.022v3a1,1,0,0,0,2,0V4a1,1,0,0,0,0-2Zm3,5h1a1.0013,1.0013,0,0,1,1,1V9a1,1,0,0,0,2,0V8a3.00328,3.00328,0,0,0-3-3h-1a1,1,0,0,0,0,2Zm-4,9h-1a1.0013,1.0013,0,0,1-1-1V14a1,1,0,0,0-2,0v1a3.00328,3.00328,0,0,0,3,3h1a1,1,0,0,0,0-2Zm11-1a1,1,0,0,0,0-2h-3v-.5a1,1,0,0,0-2,0V13h-3a1,1,0,0,0,0,2h5.18427a6.72756,6.72756,0,0,1-1.22553,2.52667,6.66828,6.66828,0,0,1-.62915-.98272.99972.99972,0,1,0-1.77929.9121,8.67791,8.67791,0,0,0,.9591,1.468A6.6182,6.6182,0,0,1,13.10645,20.023a1.00008,1.00008,0,0,0,.42675,1.9541,8.63506,8.63506,0,0,0,3.445-1.62164,8.72368,8.72368,0,0,0,3.46857,1.62115,1,1,0,1,0,.43066-1.95312,6.72477,6.72477,0,0,1-2.4461-1.09009A8.73637,8.73637,0,0,0,20.24371,15Z'
  }));
};

UilHindiToChinese.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHindiToChinese.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHistory = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,0,0,5.12,4.77V3a1,1,0,0,0-2,0V7.5a1,1,0,0,0,1,1H8.62a1,1,0,0,0,0-2H6.22A8,8,0,1,1,4,12a1,1,0,0,0-2,0A10,10,0,1,0,12,2Zm0,6a1,1,0,0,0-1,1v3a1,1,0,0,0,1,1h2a1,1,0,0,0,0-2H13V9A1,1,0,0,0,12,8Z'
  }));
};

UilHistory.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHistory.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHistoryAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.44,2A10,10,0,0,0,4.56,4.77V3a1,1,0,0,0-2,0V7.5a1,1,0,0,0,1,1H8.06a1,1,0,0,0,0-2H5.66A8,8,0,1,1,11.44,20a1,1,0,1,0,0,2,10,10,0,1,0,0-20Zm0,6a1,1,0,0,0-1,1v3a1,1,0,0,0,1,1h2a1,1,0,0,0,0-2h-1V9A1,1,0,0,0,11.44,8Z'
  }));
};

UilHistoryAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHistoryAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHome = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.66,10.25l-9-8a1,1,0,0,0-1.32,0l-9,8a1,1,0,0,0-.27,1.11A1,1,0,0,0,3,12H4v9a1,1,0,0,0,1,1H19a1,1,0,0,0,1-1V12h1a1,1,0,0,0,.93-.64A1,1,0,0,0,21.66,10.25ZM13,20H11V17a1,1,0,0,1,2,0Zm5,0H15V17a3,3,0,0,0-6,0v3H6V12H18ZM5.63,10,12,4.34,18.37,10Z'
  }));
};

UilHome.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHome.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHomeAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,8h0L14,2.74a3,3,0,0,0-4,0L4,8a3,3,0,0,0-1,2.26V19a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V10.25A3,3,0,0,0,20,8ZM14,20H10V15a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1Zm5-1a1,1,0,0,1-1,1H16V15a3,3,0,0,0-3-3H11a3,3,0,0,0-3,3v5H6a1,1,0,0,1-1-1V10.25a1,1,0,0,1,.34-.75l6-5.25a1,1,0,0,1,1.32,0l6,5.25a1,1,0,0,1,.34.75Z'
  }));
};

UilHomeAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHomeAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHorizontalAlignCenter = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,10H19V7a1,1,0,0,0-1-1H13V3a1,1,0,0,0-2,0V6H6A1,1,0,0,0,5,7v3H3a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h8v3a1,1,0,0,0,2,0V18h8a1,1,0,0,0,1-1V11A1,1,0,0,0,21,10ZM7,8H17v2H7Zm13,8H4V12H20Z'
  }));
};

UilHorizontalAlignCenter.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHorizontalAlignCenter.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHorizontalAlignLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,10H16V7a1,1,0,0,0-1-1H4V3A1,1,0,0,0,2,3V21a1,1,0,0,0,2,0V18H21a1,1,0,0,0,1-1V11A1,1,0,0,0,21,10ZM4,8H14v2H4Zm16,8H4V12H20Z'
  }));
};

UilHorizontalAlignLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHorizontalAlignLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHorizontalAlignRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2a1,1,0,0,0-1,1V6H9A1,1,0,0,0,8,7v3H3a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1H20v3a1,1,0,0,0,2,0V3A1,1,0,0,0,21,2ZM20,16H4V12H20Zm0-6H10V8H20Z'
  }));
};

UilHorizontalAlignRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHorizontalAlignRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHorizontalDistributionCenter = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,5H18V3a1,1,0,0,0-2,0V5H15a1,1,0,0,0-1,1V18a1,1,0,0,0,1,1h1v2a1,1,0,0,0,2,0V19h1a1,1,0,0,0,1-1V6A1,1,0,0,0,19,5ZM18,17H16V7h2ZM11,4H9V3A1,1,0,0,0,7,3V4H5A1,1,0,0,0,4,5V19a1,1,0,0,0,1,1H7v1a1,1,0,0,0,2,0V20h2a1,1,0,0,0,1-1V5A1,1,0,0,0,11,4ZM10,18H6V6h4Z'
  }));
};

UilHorizontalDistributionCenter.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHorizontalDistributionCenter.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHorizontalDistributionLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,4H6V3A1,1,0,0,0,4,3V21a1,1,0,0,0,2,0V20h5a1,1,0,0,0,1-1V5A1,1,0,0,0,11,4ZM10,18H6V6h4ZM19,5H16V3a1,1,0,0,0-2,0V21a1,1,0,0,0,2,0V19h3a1,1,0,0,0,1-1V6A1,1,0,0,0,19,5ZM18,17H16V7h2Z'
  }));
};

UilHorizontalDistributionLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHorizontalDistributionLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHorizontalDistributionRight = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2a1,1,0,0,0-1,1V4H13a1,1,0,0,0-1,1V19a1,1,0,0,0,1,1h5v1a1,1,0,0,0,2,0V3A1,1,0,0,0,19,2ZM18,18H14V6h4ZM9,2A1,1,0,0,0,8,3V5H5A1,1,0,0,0,4,6V18a1,1,0,0,0,1,1H8v2a1,1,0,0,0,2,0V3A1,1,0,0,0,9,2ZM8,17H6V7H8Z'
  }));
};

UilHorizontalDistributionRight.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHorizontalDistributionRight.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHospital = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.5,16.5h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm0-4h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm-5,4h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm0-4h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm14-6h-3v-4a.99974.99974,0,0,0-1-1H6.5a.99974.99974,0,0,0-1,1v4h-3a.99974.99974,0,0,0-1,1v14a.99974.99974,0,0,0,1,1h19a.99974.99974,0,0,0,1-1V7.5A.99974.99974,0,0,0,21.5,6.5Zm-1,14H3.5V8.5h3a.99974.99974,0,0,0,1-1v-4h9v4a.99974.99974,0,0,0,1,1h3Zm-4-8a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM13.5,7H13V6.5a1,1,0,0,0-2,0V7h-.5a1,1,0,0,0,0,2H11v.5a1,1,0,0,0,2,0V9h.5a1,1,0,0,0,0-2Zm4,9.5h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Z'
  }));
};

UilHospital.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHospital.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHospitalSquareSign = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,6a.99974.99974,0,0,0-1,1v4H10V7A1,1,0,0,0,8,7V17a1,1,0,0,0,2,0V13h4v4a1,1,0,0,0,2,0V7A.99974.99974,0,0,0,15,6Zm4-4H5A3.00328,3.00328,0,0,0,2,5V19a3.00328,3.00328,0,0,0,3,3H19a3.00328,3.00328,0,0,0,3-3V5A3.00328,3.00328,0,0,0,19,2Zm1,17a1.001,1.001,0,0,1-1,1H5a1.001,1.001,0,0,1-1-1V5A1.001,1.001,0,0,1,5,4H19a1.001,1.001,0,0,1,1,1Z'
  }));
};

UilHospitalSquareSign.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHospitalSquareSign.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHospitalSymbol = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,7a.99974.99974,0,0,0-1,1v3H10V8A1,1,0,0,0,8,8v8a1,1,0,0,0,2,0V13h4v3a1,1,0,0,0,2,0V8A.99974.99974,0,0,0,15,7ZM12,2A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z'
  }));
};

UilHospitalSymbol.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHospitalSymbol.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHourglass = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.9917,21.002h-1V19.335a5.00057,5.00057,0,0,0-.29956-1.67773c-.01093-.02936-.0224-.05658-.03589-.08454a4.97694,4.97694,0,0,0-.66455-1.23675l-1.3999-1.86719a3.01933,3.01933,0,0,1-.6001-1.80078V11.6582a3.02108,3.02108,0,0,1,.87842-2.12109l.65722-.65723A4.94566,4.94566,0,0,0,17.92365,6.0415c.00054-.01391.008-.02551.008-.03955l-.00281-.01373a5.01836,5.01836,0,0,0,.06287-.64349V3.002h1a1,1,0,0,0,0-2h-14a1,1,0,0,0,0,2h1V5.34473a5.01836,5.01836,0,0,0,.06287.64349L6.05176,6.002c0,.014.00744.02564.008.03955a4.94571,4.94571,0,0,0,1.3963,2.83838l.65723.65723A3.02108,3.02108,0,0,1,8.9917,11.6582V12.668a3.02212,3.02212,0,0,1-.59961,1.80078L6.99121,16.33594a4.98221,4.98221,0,0,0-.66437,1.23718c-.0133.02771-.02472.05463-.03552.08368A5.00309,5.00309,0,0,0,5.9917,19.335v1.667h-1a1,1,0,0,0,0,2h14a1,1,0,0,0,0-2Zm-11-16v-2h8v2Zm.87842,2.46387A2.97036,2.97036,0,0,1,8.49323,7.002h6.99694a2.97094,2.97094,0,0,1-.37689.46387l-.65723.65723a4.9603,4.9603,0,0,0-1.42187,2.8789h-2.085A4.96025,4.96025,0,0,0,9.52734,8.123ZM9.99219,15.668a5.03688,5.03688,0,0,0,.98828-2.666h2.02246a5.03332,5.03332,0,0,0,.98877,2.666l1.00012,1.334H8.99133Zm5.99951,5.334h-8V19.335a2.954,2.954,0,0,1,.02722-.333h7.94556a2.954,2.954,0,0,1,.02722.333Z'
  }));
};

UilHourglass.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHourglass.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHouseUser = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.66406,10.25244l-9-8a.99893.99893,0,0,0-1.32812,0l-9,8a.99991.99991,0,0,0,1.32812,1.49512L4,11.449V21a.99974.99974,0,0,0,1,1H19a.99974.99974,0,0,0,1-1V11.449l.33594.29859a.99991.99991,0,0,0,1.32812-1.49512ZM9.18427,20a2.98208,2.98208,0,0,1,5.63146,0ZM10.5,14.5A1.5,1.5,0,1,1,12,16,1.50164,1.50164,0,0,1,10.5,14.5ZM18,20H16.89893a5.00092,5.00092,0,0,0-2.25867-3.22821A3.46849,3.46849,0,0,0,15.5,14.5a3.5,3.5,0,0,0-7,0,3.46849,3.46849,0,0,0,.85974,2.27179A5.00092,5.00092,0,0,0,7.10107,20H6V9.6712l6-5.33331L18,9.6712Z'
  }));
};

UilHouseUser.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHouseUser.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHtml3 = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3.19467,2,4.79734,19.99433,11.98947,22l7.2119-2.01315L20.80533,2ZM17.476,6.12274l-.53371,5.99468.00193.03234-.00255.07415v-.00068l-.37922,4.19135-.04178.37236L12,18.03717v.00063l-.00366.00317L7.48367,16.78309l-.30574-3.46518h2.213l.15692,1.76226,2.45276.6644L12,15.74569l2.46141-.6743.26028-2.86933H9.57589L9.53173,11.717l-.10093-1.1364-.05224-.61022h5.53877l.20163-2.2317H6.68232L6.638,7.2542l-.10026-1.137L6.48482,5.507H17.52887Zm0,0'
  }));
};

UilHtml3.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHtml3.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHtml3Alt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.95215,8.00044h6.98633l-.17719,2H9.99121a1,1,0,0,0,0,2h4.59284L14.32031,14.977l-2.3291.52832L9.66309,14.976l-.09571-1.06445a1,1,0,1,0-1.99218.17774l.16015,1.79a1.00142,1.00142,0,0,0,.77442.88672l3.25976.74024a1.0188,1.0188,0,0,0,.44336,0l3.26074-.74024a1.00139,1.00139,0,0,0,.77442-.88769l.43158-4.86792.002-.01-.00079-.00391.34649-3.9082a1.001,1.001,0,0,0-.99609-1.08789H7.95215a1,1,0,0,0,0,2ZM20.6543,2.32563a1.002,1.002,0,0,0-.73828-.32519H4.06641a.99963.99963,0,0,0-.9961,1.08887L4.51367,19.28364a.999.999,0,0,0,.72754.874l6.47266,1.80566a.99028.99028,0,0,0,.53711,0l6.49023-1.8125a.999.999,0,0,0,.72754-.874l1.44336-16.1875A1.00166,1.00166,0,0,0,20.6543,2.32563Zm-3.11621,16.085-5.55567,1.55176L6.44434,18.41743,5.15918,4.00044H18.82324Z'
  }));
};

UilHtml3Alt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHtml3Alt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHtml5 = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3.1825,2.00012,4.78735,20.00079l7.20191,1.99933,7.22168-2.00207L20.8175,2.00012ZM17.32507,7.88739H8.87683l.20178,2.26074h8.04554l-.60584,6.778L12,18.17834v.00043l-.01013.00275L7.46753,16.92615,7.1582,13.45972H9.37439l.1571,1.76074,2.45874.66388.00208-.00049v-.00018l2.46228-.66461.25635-2.86323H7.05957L6.46411,5.67969h11.0586Z'
  }));
};

UilHtml5.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHtml5.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHtml5Alt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.46777,2.3252A1.00007,1.00007,0,0,0,20.73,2H3.27a1.00039,1.00039,0,0,0-.99609,1.08887l1.52,17a.99944.99944,0,0,0,.72851.87451l7.2002,2A.99628.99628,0,0,0,11.99023,23a1.01206,1.01206,0,0,0,.26709-.03613l7.21973-2a1.00055,1.00055,0,0,0,.729-.875l1.52-17A1,1,0,0,0,21.46777,2.3252Zm-3.19238,16.896L11.99072,20.9624,5.72461,19.22168,4.36328,4H19.63672ZM7.81982,13h6.895l-.32714,3.271-2.56788.917L8.65625,16.05811a1.00017,1.00017,0,1,0-.67285,1.88378l3.5,1.25a1.00291,1.00291,0,0,0,.67285,0l3.5-1.25a1.00044,1.00044,0,0,0,.65869-.84228l.5-5A1.00064,1.00064,0,0,0,15.81982,11H8.72461L8.4248,8h7.895a1,1,0,0,0,0-2h-9a1.00064,1.00064,0,0,0-.99511,1.09961l.5,5A1.00012,1.00012,0,0,0,7.81982,13Z'
  }));
};

UilHtml5Alt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHtml5Alt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilHunting = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,9a3,3,0,1,0,3,3A3,3,0,0,0,12,9Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,13Zm9-2H19.93A8,8,0,0,0,13,4.07V3a1,1,0,0,0-2,0V4.07A8,8,0,0,0,4.07,11H3a1,1,0,0,0,0,2H4.07A8,8,0,0,0,11,19.93V21a1,1,0,0,0,2,0V19.93A8,8,0,0,0,19.93,13H21a1,1,0,0,0,0-2Zm-9,7a6,6,0,1,1,6-6A6,6,0,0,1,12,18Z'
  }));
};

UilHunting.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilHunting.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4ZM5,18a1,1,0,0,1-1-1V14.58l3.3-3.29a1,1,0,0,1,1.4,0L15.41,18Zm15-1a1,1,0,0,1-1,1h-.77l-3.81-3.83.88-.88a1,1,0,0,1,1.4,0L20,16.58Zm0-3.24-1.88-1.87a3.06,3.06,0,0,0-4.24,0l-.88.88L10.12,9.89a3.06,3.06,0,0,0-4.24,0L4,11.76V7A1,1,0,0,1,5,6H19a1,1,0,0,1,1,1Z'
  }));
};

UilImage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageAltSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,20.29l-.93-.93-.09-.1-.06-.07-.5-.5L20,18.62l-5.18-5.2-.09-.08-3.2-3.21L11.43,10,3.71,2.29A1,1,0,0,0,2.29,3.71l1,1A3,3,0,0,0,3,6V18a3,3,0,0,0,3,3H18a2.9,2.9,0,0,0,1.27-.31l0,0h0s0,0,.05,0l.95,1a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM5,6.41,8.24,9.65a2.84,2.84,0,0,0-.67.48L5,12.71ZM6,19a1,1,0,0,1-1-1V15.54l4-4a.81.81,0,0,1,1.1,0L17.59,19ZM9.66,5H18a1,1,0,0,1,1,1v5.94l0,0a1,1,0,1,0-1.42,1.42l1.74,1.74a1,1,0,0,0,1.42,0,1,1,0,0,0,.29-.72h0V6a3,3,0,0,0-3-3H9.66a1,1,0,0,0,0,2Z'
  }));
};

UilImageAltSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageAltSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageBlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.54,2.46A5,5,0,1,0,22,6,5,5,0,0,0,20.54,2.46ZM14,6a3,3,0,0,1,3-3,3,3,0,0,1,1.29.3l-4,4A3,3,0,0,1,14,6Zm5.12,2.12a3.08,3.08,0,0,1-3.4.57l4-4A3,3,0,0,1,20,6,3,3,0,0,1,19.12,8.12ZM19,13a1,1,0,0,0-1,1v.39L16.52,12.9a2.87,2.87,0,0,0-3.93,0l-.7.71L9.41,11.12a2.87,2.87,0,0,0-3.93,0L4,12.61V7A1,1,0,0,1,5,6H9A1,1,0,0,0,9,4H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,.95-.17l.09,0A3,3,0,0,0,20,19.44a1.43,1.43,0,0,0,0-.22V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.89a.79.79,0,0,1,1.09,0l3.19,3.18h0L15.46,20Zm13-1a1,1,0,0,1-.18.54L13.3,15l.71-.7a.79.79,0,0,1,1.09,0L18,17.21Z'
  }));
};

UilImageBlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageBlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageBroken = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,14.54,19.21,12a1,1,0,0,0-1.42,0L15,14.84,12.21,12a1,1,0,0,0-1.42,0L8.5,14.34,6.21,12a1,1,0,0,0-1.42,0l-2.5,2.5a1,1,0,0,0-.21.33,1,1,0,0,0-.08.38V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V15.25a1,1,0,0,0-.08-.38A1,1,0,0,0,21.71,14.54ZM20,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V15.66l1.5-1.5,2.29,2.3a1,1,0,0,0,1.42,0l2.29-2.3L14.29,17a1,1,0,0,0,1.42,0l2.79-2.8,1.5,1.5ZM19,2H5A3,3,0,0,0,2,5v5.26a1.17,1.17,0,0,0,0,.27s0,.07,0,.1a1,1,0,0,0,1.66.31L5.5,9.16l2.29,2.3a1,1,0,0,0,1.42,0l2.29-2.3L14.29,12a1,1,0,0,0,1.42,0l2.79-2.8,1.77,1.78a1,1,0,0,0,1.66-.31.28.28,0,0,0,0-.09.88.88,0,0,0,.06-.28V5A3,3,0,0,0,19,2Zm1,5.84L19.21,7a1,1,0,0,0-1.42,0L15,9.84,12.21,7a1,1,0,0,0-1.42,0L8.5,9.34,6.21,7A1,1,0,0,0,4.79,7L4,7.84V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilImageBroken.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageBroken.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,2.3a1,1,0,0,0-1.41,0L16.92,5.6,15.7,4.4a1,1,0,0,0-1.4,1.43l1.92,1.88a1,1,0,0,0,1.4,0l4.08-4A1,1,0,0,0,21.71,2.3ZM19,9a1,1,0,0,0-1,1v4.39l-1.48-1.48a2.77,2.77,0,0,0-3.93,0l-.7.7L9.41,11.12a2.79,2.79,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h6a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V10A1,1,0,0,0,19,9ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.45,20Zm13-1a.89.89,0,0,1-.18.53L13.31,15l.7-.7a.78.78,0,0,1,1.1,0L18,17.22Z'
  }));
};

UilImageCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageDownload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.71,6.29a1,1,0,0,0-1.42,0L20,7.59V2a1,1,0,0,0-2,0V7.59l-1.29-1.3a1,1,0,0,0-1.42,1.42l3,3a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3A1,1,0,0,0,22.71,6.29ZM19,13a1,1,0,0,0-1,1v.38L16.52,12.9a2.79,2.79,0,0,0-3.93,0l-.7.7L9.41,11.12a2.85,2.85,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h8a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.46,20Zm13-1a.89.89,0,0,1-.18.53L13.31,15l.7-.7a.77.77,0,0,1,1.1,0L18,17.21Z'
  }));
};

UilImageDownload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageDownload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.73682,3.751,19.31689,1.33105a.99964.99964,0,0,0-1.41406,0L13.32275,5.91113a1.00013,1.00013,0,0,0-.293.707V9.03809a1.00005,1.00005,0,0,0,1,1H16.4502a1.00014,1.00014,0,0,0,.707-.293L21.73682,5.165A.99964.99964,0,0,0,21.73682,3.751ZM16.03613,8.03809H15.02979V7.03223l3.58007-3.58008L19.61572,4.458ZM19,11a1,1,0,0,0-1,1v2.3916l-1.48047-1.48047a2.78039,2.78039,0,0,0-3.92822,0l-.698.698L9.40723,11.123a2.777,2.777,0,0,0-3.92432,0L4,12.606V7A1.0013,1.0013,0,0,1,5,6h6a1,1,0,0,0,0-2H5A3.00328,3.00328,0,0,0,2,7V19a3.00328,3.00328,0,0,0,3,3H17a3.00328,3.00328,0,0,0,3-3V12A1,1,0,0,0,19,11ZM5,20a1.0013,1.0013,0,0,1-1-1V15.43408l2.897-2.897a.79926.79926,0,0,1,1.09619,0l3.168,3.16711c.00849.00916.0116.02179.02045.03064L15.44714,20Zm13-1a.97137.97137,0,0,1-.17877.53705l-4.51386-4.51386.698-.698a.77979.77979,0,0,1,1.1001,0L18,17.21973Z'
  }));
};

UilImageEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,5.18V4a3,3,0,0,0-6,0V5.18A3,3,0,0,0,12,8v2a3,3,0,0,0,3,3h4a3,3,0,0,0,3-3V8A3,3,0,0,0,20,5.18ZM16,4a1,1,0,0,1,2,0V5H16Zm4,6a1,1,0,0,1-1,1H15a1,1,0,0,1-1-1V8a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1Zm-1,5a1,1,0,0,0-1,1v3a.89.89,0,0,1-.18.53L9.41,11.12a2.86,2.86,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h5a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V16A1,1,0,0,0,19,15ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0L15.46,20Z'
  }));
};

UilImageLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,4.00781H17a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2ZM19,8a1,1,0,0,0-1,1v5.3916l-1.48047-1.48047a2.78039,2.78039,0,0,0-3.92822,0l-.698.698L9.40723,11.123a2.777,2.777,0,0,0-3.92432,0L4,12.606V7A1.0013,1.0013,0,0,1,5,6h8a1,1,0,0,0,0-2H5A3.00328,3.00328,0,0,0,2,7V19a3.00328,3.00328,0,0,0,3,3H17a3.00328,3.00328,0,0,0,3-3V9A1,1,0,0,0,19,8ZM5,20a1.0013,1.0013,0,0,1-1-1V15.43408l2.897-2.897a.79926.79926,0,0,1,1.09619,0l3.168,3.16711c.00849.00916.0116.02179.02045.03064L15.44714,20Zm13-1a.97137.97137,0,0,1-.17877.53705l-4.51386-4.51386.698-.698a.77979.77979,0,0,1,1.1001,0L18,17.21973Z'
  }));
};

UilImageMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImagePlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,10a1,1,0,0,0-1,1v3.38L16.52,12.9a2.79,2.79,0,0,0-3.93,0l-.7.71L9.41,11.12a2.79,2.79,0,0,0-3.93,0L4,12.61V7A1,1,0,0,1,5,6h8a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19.22A2.79,2.79,0,0,0,4.78,22H17.22a2.88,2.88,0,0,0,.8-.12h0a2.74,2.74,0,0,0,2-2.65V11A1,1,0,0,0,19,10ZM5,20a1,1,0,0,1-1-1V15.43l2.89-2.89a.78.78,0,0,1,1.1,0L15.46,20Zm13-1a1,1,0,0,1-.18.54L13.3,15l.71-.7a.77.77,0,0,1,1.1,0L18,17.21ZM21,4H20V3a1,1,0,0,0-2,0V4H17a1,1,0,0,0,0,2h1V7a1,1,0,0,0,2,0V6h1a1,1,0,0,0,0-2Z'
  }));
};

UilImagePlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImagePlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,13a1,1,0,0,0-1,1v.39l-1.48-1.48a2.77,2.77,0,0,0-3.93,0l-.7.7L9.41,11.12a2.86,2.86,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h8a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.45,20Zm13-1a1,1,0,0,1-.18.53L13.31,15l.7-.7a.78.78,0,0,1,1.1,0L18,17.22ZM19,2a3,3,0,0,0-2.6,1.5,1,1,0,0,0,.37,1.37,1,1,0,0,0,1.36-.37A1,1,0,0,1,20,5a1,1,0,0,1-1,1,1,1,0,0,0,0,2,3,3,0,0,0,0-6Zm.38,7.08A1,1,0,0,0,18.8,9l-.18.06-.18.09-.15.13A1,1,0,0,0,18,10a1,1,0,0,0,.29.71,1,1,0,0,0,1.42,0A1,1,0,0,0,20,10a1,1,0,0,0-.62-.92Z'
  }));
};

UilImageQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageRedo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.5,1.5a1,1,0,0,0-1,1h0a5,5,0,1,0,.3,7.75,1,1,0,0,0-1.32-1.51,3,3,0,1,1,.25-4.25H18.5a1,1,0,0,0,0,2h3a1,1,0,0,0,1-1v-3A1,1,0,0,0,21.5,1.5Zm-3,12a1,1,0,0,0-1,1v.39L16,13.41a2.77,2.77,0,0,0-3.93,0l-.7.7L8.91,11.62a2.79,2.79,0,0,0-3.93,0L3.5,13.1V7.5a1,1,0,0,1,1-1h5a1,1,0,0,0,0-2h-5a3,3,0,0,0-3,3v12a3,3,0,0,0,3,3h12a3,3,0,0,0,3-3v-5A1,1,0,0,0,18.5,13.5Zm-14,7a1,1,0,0,1-1-1V15.93L6.4,13a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15,20.5Zm13-1a1,1,0,0,1-.18.53l-4.51-4.51.7-.7a.78.78,0,0,1,1.1,0l2.89,2.9Z'
  }));
};

UilImageRedo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageRedo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageResizeLandscape = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,11H2a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H12.86c.05,0,.09,0,.14,0a1,1,0,0,0,1-1V12A1,1,0,0,0,13,11ZM7.44,20l1.93-1.93a.3.3,0,0,1,.5,0L11.79,20ZM12,17.38l-.72-.71a2.41,2.41,0,0,0-3.33,0L4.61,20H3V13h9ZM2,4.11a1,1,0,0,0,.86-.49A1.05,1.05,0,0,0,3.05,3,1,1,0,0,0,2,2,1,1,0,0,0,1,3v.1A1,1,0,0,0,2,4.11ZM9.91,4h.19a1,1,0,0,0,0-2H9.91a1,1,0,0,0,0,2ZM2,8.78a1,1,0,0,0,1-1V7.56a1,1,0,1,0-2,0v.22A1,1,0,0,0,2,8.78ZM14.09,2H13.9a1,1,0,0,0,0,2h.19a1,1,0,0,0,0-2ZM5.91,4H6.1a1,1,0,0,0,0-2H5.91a1,1,0,0,0,0,2ZM22,6.4a1,1,0,0,0-1,1v.21a1,1,0,0,0,2,0V7.4A1,1,0,0,0,22,6.4ZM17.12,20h-.24a1,1,0,1,0,0,2h.24a1,1,0,0,0,0-2ZM21.9,2A1,1,0,0,0,21,3a1,1,0,0,0,.1.42A1,1,0,0,0,23,3.11V3A1.09,1.09,0,0,0,21.9,2ZM22,10.9a1,1,0,0,0-1,1v.22a1,1,0,0,0,2,0V11.9A1,1,0,0,0,22,10.9ZM18.09,2H17.9a1,1,0,0,0,0,2h.19a1,1,0,0,0,0-2ZM22,20a.93.93,0,0,0-.44.11A1,1,0,0,0,21,21,1,1,0,0,0,22,22a1.09,1.09,0,0,0,1-1.1A1,1,0,0,0,22,20Zm0-4.56a1,1,0,0,0-1,1v.22a1,1,0,1,0,2,0V16.4A1,1,0,0,0,22,15.4Z'
  }));
};

UilImageResizeLandscape.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageResizeLandscape.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageResizeSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,8.1a1,1,0,0,0,1-1V6.91a1,1,0,0,0-2,0V7.1A1,1,0,0,0,3,8.1Zm0-4A1,1,0,0,0,3.42,4,1,1,0,0,0,3.1,2H3A1.09,1.09,0,0,0,2,3.1,1,1,0,0,0,3,4.05Zm17.39-.19A1,1,0,0,0,22,3a1,1,0,0,0-1-1h-.1a1,1,0,0,0-.51,1.86ZM11.89,4h.22a1,1,0,0,0,0-2h-.22a1,1,0,0,0,0,2ZM7.39,4H7.6a1,1,0,0,0,0-2H7.39a1,1,0,0,0,0,2ZM21,20a1,1,0,0,0-.42.1A1,1,0,0,0,20.9,22H21a1.09,1.09,0,0,0,1-1.1A1,1,0,0,0,21,20ZM14,11a1,1,0,0,0-1-1H3.27A1.08,1.08,0,0,0,3,10,1,1,0,0,0,2,11V21a1,1,0,0,0,1,1H13.1a1,1,0,0,0,.9-1.42Zm-2,9H5.52l3.91-3.9a.33.33,0,0,1,.47,0L12,18.19Zm0-4.63-.68-.69a2.35,2.35,0,0,0-3.31,0l-4,4V12h8Zm9,0a1,1,0,0,0-1,1v.21a1,1,0,0,0,2,0V16.4A1,1,0,0,0,21,15.4Zm0-9a1,1,0,0,0-1,1V7.6a1,1,0,1,0,2,0V7.39A1,1,0,0,0,21,6.39Zm0,4.5a1,1,0,0,0-1,1v.22a1,1,0,0,0,2,0v-.22A1,1,0,0,0,21,10.89ZM17.1,20h-.2a1,1,0,1,0,0,2h.2a1,1,0,0,0,0-2ZM16.61,4a1,1,0,0,0,0-2H16.4a1,1,0,1,0,0,2Z'
  }));
};

UilImageResizeSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageResizeSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageSearch = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,13a1,1,0,0,0-1,1v.39l-1.48-1.48a2.79,2.79,0,0,0-3.93,0l-.7.7L9.41,11.12a2.87,2.87,0,0,0-3.93,0L4,12.61V7A1,1,0,0,1,5,6H9A1,1,0,0,0,9,4H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.89a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.45,20Zm13-1a1,1,0,0,1-.18.54L13.31,15l.7-.69a.77.77,0,0,1,1.1,0L18,17.22Zm3.71-8.71L20,8.57a4.31,4.31,0,1,0-6.72.79,4.27,4.27,0,0,0,3,1.26A4.34,4.34,0,0,0,18.57,10l1.72,1.73a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,10.29ZM18,8a2.32,2.32,0,1,1,0-3.27A2.32,2.32,0,0,1,18,8Z'
  }));
};

UilImageSearch.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageSearch.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageShare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,7a2,2,0,0,0-1.18.39l-1.75-.8L19,5.71A2,2,0,0,0,20,6a2,2,0,1,0-2-2l-1.89.87A2,2,0,1,0,15,8.5a1.88,1.88,0,0,0,.92-.24l2.1,1A2,2,0,1,0,20,7Zm-1,6a1,1,0,0,0-1,1v.39l-1.48-1.48a2.77,2.77,0,0,0-3.93,0l-.7.7L9.41,11.12a2.79,2.79,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h5a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.45,20Zm13-1a.89.89,0,0,1-.18.53L13.31,15l.7-.7a.78.78,0,0,1,1.1,0L18,17.22Z'
  }));
};

UilImageShare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageShare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageShield = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.13,2.36a1,1,0,0,0-.84-.2,2.7,2.7,0,0,1-2.2-.47,1,1,0,0,0-1.18,0,2.7,2.7,0,0,1-2.2.47,1,1,0,0,0-.84.2,1,1,0,0,0-.37.78V6.45a4.63,4.63,0,0,0,1.84,3.7l1.57,1.16a1,1,0,0,0,1.18,0l1.57-1.16a4.63,4.63,0,0,0,1.84-3.7V3.14A1,1,0,0,0,22.13,2.36ZM20.5,6.45a2.62,2.62,0,0,1-1,2.09l-1,.72-1-.72a2.62,2.62,0,0,1-1-2.09V4.22a4.81,4.81,0,0,0,2-.54,4.81,4.81,0,0,0,2,.54Zm-2,7.05a1,1,0,0,0-1,1v.39L16,13.41a2.77,2.77,0,0,0-3.93,0l-.7.7L8.91,11.62a2.85,2.85,0,0,0-3.93,0L3.5,13.1V7.5a1,1,0,0,1,1-1h7a1,1,0,0,0,0-2h-7a3,3,0,0,0-3,3v12a3,3,0,0,0,3,3h12a3,3,0,0,0,3-3v-5A1,1,0,0,0,18.5,13.5Zm-14,7a1,1,0,0,1-1-1V15.93L6.4,13a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15,20.5Zm13-1a1,1,0,0,1-.18.53l-4.51-4.51.7-.7a.78.78,0,0,1,1.1,0l2.89,2.9Z'
  }));
};

UilImageShield.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageShield.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.5,4H10a1,1,0,0,0,0,2H19.5a1,1,0,0,1,1,1v6.76l-1.88-1.88a3,3,0,0,0-1.14-.71,1,1,0,1,0-.64,1.9.82.82,0,0,1,.36.23l3.31,3.29a.66.66,0,0,0,0,.15.83.83,0,0,0,0,.15,1.18,1.18,0,0,0,.13.18.48.48,0,0,0,.09.11.9.9,0,0,0,.2.14.6.6,0,0,0,.11.06.91.91,0,0,0,.37.08,1,1,0,0,0,1-1V7A3,3,0,0,0,19.5,4ZM3.21,2.29A1,1,0,0,0,1.79,3.71L3.18,5.1A3,3,0,0,0,2.5,7V17a3,3,0,0,0,3,3H18.09l1.7,1.71a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM4.5,7a1,1,0,0,1,.12-.46L7.34,9.25a3,3,0,0,0-1,.63L4.5,11.76Zm1,11a1,1,0,0,1-1-1V14.58l3.3-3.29a1,1,0,0,1,1.4,0L15.91,18Z'
  }));
};

UilImageSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,10a1,1,0,0,0-1,1v3.39l-1.48-1.48a2.77,2.77,0,0,0-3.93,0l-.7.7L9.41,11.12a2.79,2.79,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h8a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V11A1,1,0,0,0,19,10ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.45,20Zm13-1a.89.89,0,0,1-.18.53L13.31,15l.7-.7a.78.78,0,0,1,1.1,0L18,17.22ZM20.41,5l1.3-1.29a1,1,0,0,0,0-1.41,1,1,0,0,0-1.42,0L19,3.59,17.71,2.3a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41L17.59,5l-1.3,1.3a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0L19,6.42l1.29,1.29a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41Z'
  }));
};

UilImageTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageUpload = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,13a1,1,0,0,0-1,1v.38L16.52,12.9a2.79,2.79,0,0,0-3.93,0l-.7.7L9.41,11.12a2.85,2.85,0,0,0-3.93,0L4,12.6V7A1,1,0,0,1,5,6h7a1,1,0,0,0,0-2H5A3,3,0,0,0,2,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V14A1,1,0,0,0,19,13ZM5,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L15.46,20Zm13-1a.89.89,0,0,1-.18.53L13.31,15l.7-.7a.77.77,0,0,1,1.1,0L18,17.21ZM22.71,4.29l-3-3a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3a1,1,0,0,0,1.42,1.42L18,4.41V10a1,1,0,0,0,2,0V4.41l1.29,1.3a1,1,0,0,0,1.42,0A1,1,0,0,0,22.71,4.29Z'
  }));
};

UilImageUpload.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageUpload.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImageV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a2.81,2.81,0,0,0,.49-.05l.3-.07.07,0h0l.05,0,.37-.14.13-.07c.1-.06.21-.11.31-.18a3.79,3.79,0,0,0,.38-.32l.07-.09a2.69,2.69,0,0,0,.27-.32l.09-.13a2.31,2.31,0,0,0,.18-.35,1,1,0,0,0,.07-.15c.05-.12.08-.25.12-.38l0-.15A2.6,2.6,0,0,0,22,19V5A3,3,0,0,0,19,2ZM5,20a1,1,0,0,1-1-1V14.69l3.29-3.3h0a1,1,0,0,1,1.42,0L17.31,20Zm15-1a1,1,0,0,1-.07.36,1,1,0,0,1-.08.14.94.94,0,0,1-.09.12l-5.35-5.35.88-.88a1,1,0,0,1,1.42,0h0L20,16.69Zm0-5.14L18.12,12a3.08,3.08,0,0,0-4.24,0l-.88.88L10.12,10a3.08,3.08,0,0,0-4.24,0L4,11.86V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilImageV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImageV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImages = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,15V5a3,3,0,0,0-3-3H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H15A3,3,0,0,0,18,15ZM4,5A1,1,0,0,1,5,4H15a1,1,0,0,1,1,1V9.36L14.92,8.27a2.56,2.56,0,0,0-1.81-.75h0a2.58,2.58,0,0,0-1.81.75l-.91.91-.81-.81a2.93,2.93,0,0,0-4.11,0L4,9.85Zm.12,10.45A.94.94,0,0,1,4,15V12.67L6.88,9.79a.91.91,0,0,1,1.29,0L9,10.6Zm8.6-5.76a.52.52,0,0,1,.39-.17h0a.52.52,0,0,1,.39.17L16,12.18V15a1,1,0,0,1-1,1H6.4ZM21,6a1,1,0,0,0-1,1V17a3,3,0,0,1-3,3H7a1,1,0,0,0,0,2H17a5,5,0,0,0,5-5V7A1,1,0,0,0,21,6Z'
  }));
};

UilImages.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImages.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilImport = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v4a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V15A1,1,0,0,0,21,14Zm-9.71,1.71a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4-4a1,1,0,0,0-1.42-1.42L13,12.59V3a1,1,0,0,0-2,0v9.59l-2.29-2.3a1,1,0,1,0-1.42,1.42Z'
  }));
};

UilImport.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilImport.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilInbox = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.05566,2h-14a3.00328,3.00328,0,0,0-3,3V19a3.00328,3.00328,0,0,0,3,3h14a3.00328,3.00328,0,0,0,3-3V5A3.00328,3.00328,0,0,0,19.05566,2Zm-14,2h14a1.001,1.001,0,0,1,1,1v8H17.59082a1.99687,1.99687,0,0,0-1.66406.89062L14.52051,16H9.59082L8.18457,13.89062A1.99687,1.99687,0,0,0,6.52051,13H4.05566V5A1.001,1.001,0,0,1,5.05566,4Zm14,16h-14a1.001,1.001,0,0,1-1-1V15H6.52051l1.40625,2.10938A1.99687,1.99687,0,0,0,9.59082,18h4.92969a1.99687,1.99687,0,0,0,1.66406-.89062L17.59082,15h2.46484v4A1.001,1.001,0,0,1,19.05566,20Z'
  }));
};

UilInbox.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilInbox.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilIncomingCall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.55,9a1.07,1.07,0,0,0,.39.07h4a1,1,0,0,0,0-2H18.35l3.29-3.29a1,1,0,1,0-1.41-1.41L16.94,5.65V4.06a1,1,0,1,0-2,0v4a1.07,1.07,0,0,0,.07.39A1,1,0,0,0,15.55,9Zm3.89,4c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1.06,1.06,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1Z'
  }));
};

UilIncomingCall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilIncomingCall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,10a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V11A1,1,0,0,0,12,10Zm0-4a1.25,1.25,0,1,0,1.25,1.25A1.25,1.25,0,0,0,12,6Z'
  }));
};

UilInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilInfoCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10.01114,10.01114,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Zm0-8.5a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0v-3A1,1,0,0,0,12,11.5Zm0-4a1.25,1.25,0,1,0,1.25,1.25A1.25,1.25,0,0,0,12,7.5Z'
  }));
};

UilInfoCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilInfoCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilInstagram = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.34,5.46h0a1.2,1.2,0,1,0,1.2,1.2A1.2,1.2,0,0,0,17.34,5.46Zm4.6,2.42a7.59,7.59,0,0,0-.46-2.43,4.94,4.94,0,0,0-1.16-1.77,4.7,4.7,0,0,0-1.77-1.15,7.3,7.3,0,0,0-2.43-.47C15.06,2,14.72,2,12,2s-3.06,0-4.12.06a7.3,7.3,0,0,0-2.43.47A4.78,4.78,0,0,0,3.68,3.68,4.7,4.7,0,0,0,2.53,5.45a7.3,7.3,0,0,0-.47,2.43C2,8.94,2,9.28,2,12s0,3.06.06,4.12a7.3,7.3,0,0,0,.47,2.43,4.7,4.7,0,0,0,1.15,1.77,4.78,4.78,0,0,0,1.77,1.15,7.3,7.3,0,0,0,2.43.47C8.94,22,9.28,22,12,22s3.06,0,4.12-.06a7.3,7.3,0,0,0,2.43-.47,4.7,4.7,0,0,0,1.77-1.15,4.85,4.85,0,0,0,1.16-1.77,7.59,7.59,0,0,0,.46-2.43c0-1.06.06-1.4.06-4.12S22,8.94,21.94,7.88ZM20.14,16a5.61,5.61,0,0,1-.34,1.86,3.06,3.06,0,0,1-.75,1.15,3.19,3.19,0,0,1-1.15.75,5.61,5.61,0,0,1-1.86.34c-1,.05-1.37.06-4,.06s-3,0-4-.06A5.73,5.73,0,0,1,6.1,19.8,3.27,3.27,0,0,1,5,19.05a3,3,0,0,1-.74-1.15A5.54,5.54,0,0,1,3.86,16c0-1-.06-1.37-.06-4s0-3,.06-4A5.54,5.54,0,0,1,4.21,6.1,3,3,0,0,1,5,5,3.14,3.14,0,0,1,6.1,4.2,5.73,5.73,0,0,1,8,3.86c1,0,1.37-.06,4-.06s3,0,4,.06a5.61,5.61,0,0,1,1.86.34A3.06,3.06,0,0,1,19.05,5,3.06,3.06,0,0,1,19.8,6.1,5.61,5.61,0,0,1,20.14,8c.05,1,.06,1.37.06,4S20.19,15,20.14,16ZM12,6.87A5.13,5.13,0,1,0,17.14,12,5.12,5.12,0,0,0,12,6.87Zm0,8.46A3.33,3.33,0,1,1,15.33,12,3.33,3.33,0,0,1,12,15.33Z'
  }));
};

UilInstagram.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilInstagram.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilInstagramAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,9.52A2.48,2.48,0,1,0,14.48,12,2.48,2.48,0,0,0,12,9.52Zm9.93-2.45a6.53,6.53,0,0,0-.42-2.26,4,4,0,0,0-2.32-2.32,6.53,6.53,0,0,0-2.26-.42C15.64,2,15.26,2,12,2s-3.64,0-4.93.07a6.53,6.53,0,0,0-2.26.42A4,4,0,0,0,2.49,4.81a6.53,6.53,0,0,0-.42,2.26C2,8.36,2,8.74,2,12s0,3.64.07,4.93a6.86,6.86,0,0,0,.42,2.27,3.94,3.94,0,0,0,.91,1.4,3.89,3.89,0,0,0,1.41.91,6.53,6.53,0,0,0,2.26.42C8.36,22,8.74,22,12,22s3.64,0,4.93-.07a6.53,6.53,0,0,0,2.26-.42,3.89,3.89,0,0,0,1.41-.91,3.94,3.94,0,0,0,.91-1.4,6.6,6.6,0,0,0,.42-2.27C22,15.64,22,15.26,22,12S22,8.36,21.93,7.07Zm-2.54,8A5.73,5.73,0,0,1,19,16.87,3.86,3.86,0,0,1,16.87,19a5.73,5.73,0,0,1-1.81.35c-.79,0-1,0-3.06,0s-2.27,0-3.06,0A5.73,5.73,0,0,1,7.13,19a3.51,3.51,0,0,1-1.31-.86A3.51,3.51,0,0,1,5,16.87a5.49,5.49,0,0,1-.34-1.81c0-.79,0-1,0-3.06s0-2.27,0-3.06A5.49,5.49,0,0,1,5,7.13a3.51,3.51,0,0,1,.86-1.31A3.59,3.59,0,0,1,7.13,5a5.73,5.73,0,0,1,1.81-.35h0c.79,0,1,0,3.06,0s2.27,0,3.06,0A5.73,5.73,0,0,1,16.87,5a3.51,3.51,0,0,1,1.31.86A3.51,3.51,0,0,1,19,7.13a5.73,5.73,0,0,1,.35,1.81c0,.79,0,1,0,3.06S19.42,14.27,19.39,15.06Zm-1.6-7.44a2.38,2.38,0,0,0-1.41-1.41A4,4,0,0,0,15,6c-.78,0-1,0-3,0s-2.22,0-3,0a4,4,0,0,0-1.38.26A2.38,2.38,0,0,0,6.21,7.62,4.27,4.27,0,0,0,6,9c0,.78,0,1,0,3s0,2.22,0,3a4.27,4.27,0,0,0,.26,1.38,2.38,2.38,0,0,0,1.41,1.41A4.27,4.27,0,0,0,9,18.05H9c.78,0,1,0,3,0s2.22,0,3,0a4,4,0,0,0,1.38-.26,2.38,2.38,0,0,0,1.41-1.41A4,4,0,0,0,18.05,15c0-.78,0-1,0-3s0-2.22,0-3A3.78,3.78,0,0,0,17.79,7.62ZM12,15.82A3.81,3.81,0,0,1,8.19,12h0A3.82,3.82,0,1,1,12,15.82Zm4-6.89a.9.9,0,0,1,0-1.79h0a.9.9,0,0,1,0,1.79Z'
  }));
};

UilInstagramAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilInstagramAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilIntercom = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.5,2H4.5A2.5,2.5,0,0,0,2,4.5v15A2.5,2.5,0,0,0,4.5,22h15A2.5,2.5,0,0,0,22,19.5V4.5A2.5,2.5,0,0,0,19.5,2ZM14.67,5.67A.66.66,0,0,1,15.34,5a.68.68,0,0,1,.66.66v8.9a.67.67,0,0,1-1.33,0Zm-3.34-.34A.67.67,0,0,1,12,4.66h0a.67.67,0,0,1,.67.67V15a.67.67,0,0,1-1.34,0ZM8,5.67a.67.67,0,0,1,1.33,0v8.9a.66.66,0,0,1-.67.66A.68.68,0,0,1,8,14.57ZM4.67,7A.67.67,0,0,1,6,7v6a.67.67,0,0,1-.67.66A.67.67,0,0,1,4.67,13ZM19.1,17.17A11.3,11.3,0,0,1,12,19.33a11.3,11.3,0,0,1-7.1-2.16.67.67,0,0,1,.87-1A10.2,10.2,0,0,0,12,18a10.15,10.15,0,0,0,6.23-1.84.67.67,0,0,1,.87,1ZM19.33,13A.67.67,0,0,1,18,13V7a.67.67,0,0,1,.67-.66.66.66,0,0,1,.66.66Z'
  }));
};

UilIntercom.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilIntercom.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilIntercomAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.99121,15.00044a.99942.99942,0,0,0,1-1v-8a1,1,0,1,0-2,0v8A.99943.99943,0,0,0,9.99121,15.00044Zm4,0a.99942.99942,0,0,0,1-1v-8a1,1,0,1,0-2,0v8A.99943.99943,0,0,0,13.99121,15.00044Zm-8-2a.99942.99942,0,0,0,1-1v-4a1,1,0,0,0-2,0v4A.99943.99943,0,0,0,5.99121,13.00044Zm14-12h-16a3.00328,3.00328,0,0,0-3,3v16a3.00328,3.00328,0,0,0,3,3h16a3.00328,3.00328,0,0,0,3-3v-16A3.00328,3.00328,0,0,0,19.99121,1.00044Zm1,19a1.00067,1.00067,0,0,1-1,1h-16a1.00067,1.00067,0,0,1-1-1v-16a1.00067,1.00067,0,0,1,1-1h16a1.00067,1.00067,0,0,1,1,1Zm-3.64355-4.5918a8.82089,8.82089,0,0,1-5.35645,1.5918,8.98692,8.98692,0,0,1-5.35644-1.5918,1.00017,1.00017,0,1,0-1.28711,1.53125,10.79981,10.79981,0,0,0,6.64355,2.06055,10.79989,10.79989,0,0,0,6.64356-2.06055,1.00017,1.00017,0,0,0-1.28711-1.53125Zm.64355-8.4082a.99942.99942,0,0,0-1,1v4a1,1,0,1,0,2,0v-4A.99942.99942,0,0,0,17.99121,7.00044Z'
  }));
};

UilIntercomAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilIntercomAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilInvoice = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,16H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM9,10h2a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm12,2H18V3a1,1,0,0,0-.5-.87,1,1,0,0,0-1,0l-3,1.72-3-1.72a1,1,0,0,0-1,0l-3,1.72-3-1.72a1,1,0,0,0-1,0A1,1,0,0,0,2,3V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V13A1,1,0,0,0,21,12ZM5,20a1,1,0,0,1-1-1V4.73L6,5.87a1.08,1.08,0,0,0,1,0l3-1.72,3,1.72a1.08,1.08,0,0,0,1,0l2-1.14V19a3,3,0,0,0,.18,1Zm15-1a1,1,0,0,1-2,0V14h2Zm-7-7H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilInvoice.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilInvoice.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilItalic = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,6H11a1,1,0,0,0,0,2h1.52l-3.2,8H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2H11.48l3.2-8H17a1,1,0,0,0,0-2Z'
  }));
};

UilItalic.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilItalic.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilJackhammer = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.85,15.69a1,1,0,0,0-1.41,0l-2.06,2.06a1,1,0,0,0,.45,1.67l.26.07-.8.8a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l2-2a1,1,0,0,0,.26-1,1,1,0,0,0-.71-.71L18,17.94l.83-.84A1,1,0,0,0,18.85,15.69ZM7.91,19.49l.26-.07a1,1,0,0,0,.45-1.67L6.56,15.69A1,1,0,0,0,5.15,17.1l.83.84L5.72,18a1,1,0,0,0-.71.71,1,1,0,0,0,.26,1l2,2a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM21,4a1,1,0,0,0-1,1H17a3,3,0,0,0-3-3H10A3,3,0,0,0,7,5H4A1,1,0,0,0,2,5V7A1,1,0,0,0,4,7H7V9a3,3,0,0,0,2,2.83V13a2,2,0,0,0,2,2v6a1,1,0,0,0,2,0V15a2,2,0,0,0,2-2V11.83A3,3,0,0,0,17,9V7h3a1,1,0,0,0,2,0V5A1,1,0,0,0,21,4ZM15,9a1,1,0,0,1-1,1,1,1,0,0,0-1,1v2H11V11a1,1,0,0,0-1-1A1,1,0,0,1,9,9V5a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1ZM12,6a1,1,0,0,0-1,1V8a1,1,0,0,0,2,0V7A1,1,0,0,0,12,6Z'
  }));
};

UilJackhammer.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilJackhammer.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilJavaScript = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.478,14.8829a4.06111,4.06111,0,0,1-2.18725-.39825,1.4389,1.4389,0,0,1-.53547-1.01019.22184.22184,0,0,0-.22662-.21942c-.31659-.00385-.63312-.003-.94965-.00043a.2113.2113,0,0,0-.23138.18628,2.33854,2.33854,0,0,0,.75305,1.84454,3.99135,3.99135,0,0,0,2.22827.8382,8.06151,8.06151,0,0,0,2.53308-.10755,3.12591,3.12591,0,0,0,1.67823-.90442,2.33824,2.33824,0,0,0,.396-2.23077,1.869,1.869,0,0,0-1.2304-1.09454c-1.28077-.4494-2.66431-.41541-3.97-.7569-.22668-.07135-.50366-.1488-.60467-.38879a.85461.85461,0,0,1,.28418-.95478,2.5576,2.5576,0,0,1,1.34875-.33581,4.07051,4.07051,0,0,1,1.88416.26959,1.43564,1.43564,0,0,1,.68677.99219.243.243,0,0,0,.2276.23565c.31433.00641.62878.00171.94311.00214a.22791.22791,0,0,0,.24732-.16772,2.43369,2.43369,0,0,0-1.18665-2.106,5.8791,5.8791,0,0,0-3.2182-.49243V8.08341a3.50546,3.50546,0,0,0-2.17615.87438,2.1746,2.1746,0,0,0-.43438,2.26264,1.92964,1.92964,0,0,0,1.21838,1.06177c1.27649.46106,2.67554.31311,3.96442.72082.25116.08521.54364.21552.6206.49506a.9907.9907,0,0,1-.26965.94616A2.97065,2.97065,0,0,1,14.478,14.8829Zm5.81891-8.44537q-3.73837-2.114-7.47845-4.22418a1.67742,1.67742,0,0,0-1.63733,0Q7.4556,4.31715,3.72968,6.42075a1.54242,1.54242,0,0,0-.8042,1.34271V16.2377a1.55266,1.55266,0,0,0,.8352,1.355c.71351.38837,1.40674.81629,2.13318,1.17884a3.06373,3.06373,0,0,0,2.73822.07525,2.1275,2.1275,0,0,0,.99482-1.92114c.00555-2.79669.00085-5.59351.00213-8.39026a.21981.21981,0,0,0-.20727-.25415c-.31739-.00513-.63526-.003-.95264-.00085a.20935.20935,0,0,0-.228.21368c-.00427,2.77875.00086,5.55829-.00256,8.33746a.94053.94053,0,0,1-.609.88373,1.53242,1.53242,0,0,1-1.23993-.16595q-.99152-.56-1.983-1.11988a.23714.23714,0,0,1-.13464-.23529q0-4.19383,0-8.38726a.2589.2589,0,0,1,.157-.2602Q8.1423,5.4553,11.85419,3.35953a.258.258,0,0,1,.29163.00043Q15.859,5.452,19.57184,7.5455a.262.262,0,0,1,.15613.26142Q19.72733,12,19.72712,16.19376a.242.242,0,0,1-.13294.23828q-3.65643,2.06753-7.31677,4.12909c-.11658.06494-.25458.16943-.39093.09076-.6391-.36176-1.27039-.73755-1.90735-1.10273a.20589.20589,0,0,0-.22968-.01379,5.21834,5.21834,0,0,1-.88208.41162c-.13806.05591-.30792.07184-.40295.19989a1.31566,1.31566,0,0,0,.43127.31061q1.11741.647,2.236,1.29285a1.62967,1.62967,0,0,0,1.65539.046q3.7261-2.101,7.45185-4.20392a1.55627,1.55627,0,0,0,.83563-1.35474V7.76346A1.53956,1.53956,0,0,0,20.29694,6.43753Z'
  }));
};

UilJavaScript.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilJavaScript.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKayak = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.12,16.88a3,3,0,0,0-3.4-.58l-1.15-1.14A24,24,0,0,0,21.78,6.3,3.19,3.19,0,0,0,17.7,2.22,24,24,0,0,0,8.84,7.43L7.7,6.28a3,3,0,1,0-4.82.84A3,3,0,0,0,5,8a3,3,0,0,0,1.28-.3L7.43,8.84A24,24,0,0,0,2.22,17.7,3.24,3.24,0,0,0,3,21,3.17,3.17,0,0,0,5.22,22a3.74,3.74,0,0,0,1.08-.17,24,24,0,0,0,8.86-5.21l1.14,1.15a3,3,0,1,0,4.82-.84ZM5.71,5.7h0A1,1,0,0,1,4.29,4.29,1,1,0,0,1,5.71,5.7Zm12.6-1.57a1.6,1.6,0,0,1,.47-.08,1.16,1.16,0,0,1,.83.34,1.23,1.23,0,0,1,.26,1.3,22.09,22.09,0,0,1-2.13,4.64L13.67,6.26A22.09,22.09,0,0,1,18.31,4.13ZM5.69,19.87a1.2,1.2,0,0,1-1.56-1.56,22.09,22.09,0,0,1,2.13-4.64l4.07,4.07A22.09,22.09,0,0,1,5.69,19.87ZM12,16.59,7.41,12a21.29,21.29,0,0,1,1.43-1.74l4.91,4.91A21.29,21.29,0,0,1,12,16.59Zm3.15-2.84L10.25,8.84A21.29,21.29,0,0,1,12,7.41l4.6,4.6A21.29,21.29,0,0,1,15.16,13.75Zm4.55,6a1,1,0,1,1-1.42-1.41h0a1,1,0,0,1,1.41,0A1,1,0,0,1,19.71,19.71Z'
  }));
};

UilKayak.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKayak.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeySkeleton = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,4.41l.71-.7a1,1,0,1,0-1.42-1.42L18.89,3.7h0L16.06,6.53h0L9.75,12.83a5,5,0,1,0,1.42,1.42l5.59-5.6,2.12,2.13a1,1,0,1,0,1.41-1.42L18.17,7.24l1.42-1.41.7.7a1,1,0,1,0,1.42-1.41ZM7,20a3,3,0,1,1,3-3A3,3,0,0,1,7,20Z'
  }));
};

UilKeySkeleton.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeySkeleton.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeySkeletonAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,6.53,20.29,5.12l1.42-1.41a1,1,0,1,0-1.42-1.42L9.75,12.83a5,5,0,1,0,1.42,1.42l4.88-4.89,1.41,1.42a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42L17.46,8l1.42-1.42L20.29,8a1,1,0,0,0,.71.29A1,1,0,0,0,21.71,8,1,1,0,0,0,21.71,6.53ZM7,20a3,3,0,1,1,3-3A3,3,0,0,1,7,20Z'
  }));
};

UilKeySkeletonAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeySkeletonAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyboard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.21,13.29a.93.93,0,0,0-.33-.21,1,1,0,0,0-.76,0,.9.9,0,0,0-.54.54,1,1,0,1,0,1.84,0A1,1,0,0,0,6.21,13.29ZM13.5,11h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm-4,0h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm-3-2h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM20,5H4A3,3,0,0,0,1,8v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V8A3,3,0,0,0,20,5Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V8A1,1,0,0,1,4,7H20a1,1,0,0,1,1,1Zm-6-3H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm3.5-4h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm.71,4.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,.93.93,0,0,0-.33.21,1,1,0,0,0-.21.33A1,1,0,1,0,19.5,14a.84.84,0,0,0-.08-.38A1,1,0,0,0,19.21,13.29Z'
  }));
};

UilKeyboard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyboard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyboardAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.71,9.29a1,1,0,0,0-1.42,0,1,1,0,0,0-.21.33,1,1,0,0,0,.21,1.09,1.15,1.15,0,0,0,.33.21A.84.84,0,0,0,6,11a1,1,0,0,0,.92-1.38A1,1,0,0,0,6.71,9.29ZM10,11a1,1,0,0,0,.92-1.38,1,1,0,0,0-.21-.33A1,1,0,0,0,9.81,9a.6.6,0,0,0-.19.06l-.18.09-.15.12A1.05,1.05,0,0,0,9,10a1,1,0,0,0,1,1ZM6.38,13.08a1,1,0,0,0-.76,0A1,1,0,0,0,5,14a1,1,0,0,0,1.38.92,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,7,14a1,1,0,0,0-.29-.71A.93.93,0,0,0,6.38,13.08ZM14,13H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm.71-3.71a1,1,0,0,0-1.42,0,1,1,0,0,0-.21.33A1,1,0,1,0,15,10a.84.84,0,0,0-.08-.38A1,1,0,0,0,14.71,9.29Zm3.85,3.88a.76.76,0,0,0-.18-.09,1,1,0,0,0-.76,0,1.15,1.15,0,0,0-.33.21A1.05,1.05,0,0,0,17,14a1,1,0,1,0,2,0,1.05,1.05,0,0,0-.29-.71ZM20,5H4A3,3,0,0,0,1,8v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V8A3,3,0,0,0,20,5Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V8A1,1,0,0,1,4,7H20a1,1,0,0,1,1,1ZM18.71,9.29A1,1,0,0,0,17,10a1,1,0,1,0,1.92-.38A1,1,0,0,0,18.71,9.29Z'
  }));
};

UilKeyboardAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyboardAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyboardHide = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.71,10.29a1.15,1.15,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1,1,0,0,0-.21.33,1,1,0,0,0,.21,1.09,1.15,1.15,0,0,0,.33.21,1,1,0,0,0,1.3-1.3A1,1,0,0,0,6.71,10.29ZM9.29,7.71A1,1,0,0,0,10,8a.84.84,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76,1.15,1.15,0,0,0-.21-.33,1,1,0,0,0-1.42,0,1.15,1.15,0,0,0-.21.33.94.94,0,0,0,0,.76A1.15,1.15,0,0,0,9.29,7.71ZM6.71,6.29A1,1,0,0,0,5,7a1,1,0,0,0,.08.38,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,6,8a.84.84,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76A1.15,1.15,0,0,0,6.71,6.29Zm6.58,12L12,19.59l-1.29-1.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,1.42,0l2-2a1,1,0,0,0-1.42-1.42Zm5.42-12A1,1,0,0,0,17,7a.84.84,0,0,0,.08.38,1.15,1.15,0,0,0,.21.33,1,1,0,0,0,1.42,0,1.15,1.15,0,0,0,.21-.33A.84.84,0,0,0,19,7a1,1,0,0,0-.08-.38A1.15,1.15,0,0,0,18.71,6.29ZM14,10H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm6-8H4A3,3,0,0,0,1,5v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V5A3,3,0,0,0,20,2Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V5A1,1,0,0,1,4,4H20a1,1,0,0,1,1,1Zm-2.29-2.71a1,1,0,0,0-.33-.21.92.92,0,0,0-.76,0,1.15,1.15,0,0,0-.33.21A1.05,1.05,0,0,0,17,11a1,1,0,1,0,1.92-.38A1,1,0,0,0,18.71,10.29ZM13.62,6.08a1.15,1.15,0,0,0-.33.21A1.05,1.05,0,0,0,13,7a1,1,0,0,0,.08.38,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,14,8a.84.84,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33A.84.84,0,0,0,15,7a1.05,1.05,0,0,0-.29-.71A1,1,0,0,0,13.62,6.08Z'
  }));
};

UilKeyboardHide.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyboardHide.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyboardShow = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.71,10.29A1,1,0,0,0,5,11a1,1,0,1,0,1.92-.38A1,1,0,0,0,6.71,10.29ZM9.29,7.71A1,1,0,0,0,10,8a1,1,0,0,0,.71-.29,1.15,1.15,0,0,0,.21-.33A1,1,0,0,0,11,7a1.05,1.05,0,0,0-.29-.71l-.15-.12-.18-.09A.6.6,0,0,0,10.19,6a1,1,0,0,0-.9.27,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76A1.15,1.15,0,0,0,9.29,7.71ZM6.56,6.17a.76.76,0,0,0-.18-.09L6.2,6a1,1,0,0,0-.91.27,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33,1.15,1.15,0,0,0,.33.21A.84.84,0,0,0,6,8a1,1,0,0,0,.71-.29,1.15,1.15,0,0,0,.21-.33A1,1,0,0,0,7,7a1.05,1.05,0,0,0-.29-.71Zm6.15,12.12a1,1,0,0,0-1.42,0l-2,2a1,1,0,0,0,1.42,1.42L12,20.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm6-8a1,1,0,0,0-1.42,0,1,1,0,0,0-.21.33,1,1,0,0,0,1.3,1.3,1.15,1.15,0,0,0,.33-.21A1,1,0,0,0,19,11a.84.84,0,0,0-.08-.38A1,1,0,0,0,18.71,10.29ZM14,10H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm6-8H4A3,3,0,0,0,1,5v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V5A3,3,0,0,0,20,2Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V5A1,1,0,0,1,4,4H20a1,1,0,0,1,1,1ZM17.62,6.08a.93.93,0,0,0-.33.21A1.05,1.05,0,0,0,17,7a1,1,0,0,0,.08.38,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,18,8a1,1,0,0,0,.71-.29,1.15,1.15,0,0,0,.21-.33A1,1,0,0,0,19,7a1.05,1.05,0,0,0-.29-.71A1,1,0,0,0,17.62,6.08Zm-3.06.09-.18-.09L14.2,6a1,1,0,0,0-.58.06.93.93,0,0,0-.33.21,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33A1,1,0,0,0,14,8a1,1,0,0,0,.71-.29,1.15,1.15,0,0,0,.21-.33A1,1,0,0,0,15,7a1.05,1.05,0,0,0-.29-.71Z'
  }));
};

UilKeyboardShow.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyboardShow.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyholeCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,8a2,2,0,0,0-2,2,2,2,0,0,0,1,1.72V15a1,1,0,0,0,2,0V11.72A2,2,0,0,0,14,10,2,2,0,0,0,12,8Zm0-6A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilKeyholeCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyholeCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyholeSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1ZM12,8a2,2,0,0,0-2,2,2,2,0,0,0,1,1.72V15a1,1,0,0,0,2,0V11.72A2,2,0,0,0,14,10,2,2,0,0,0,12,8Z'
  }));
};

UilKeyholeSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyholeSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKeyholeSquareFull = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,11.72V15a1,1,0,0,0,2,0V11.72A2,2,0,0,0,14,10a2,2,0,0,0-4,0A2,2,0,0,0,11,11.72ZM21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,20H4V4H20Z'
  }));
};

UilKeyholeSquareFull.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKeyholeSquareFull.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilKid = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,10a1,1,0,1,0-1,1A1,1,0,0,0,10,10Zm4.5,4.06a1,1,0,0,0-1.37.36,1.3,1.3,0,0,1-2.26,0,1,1,0,0,0-1.37-.36,1,1,0,0,0-.37,1.36,3.31,3.31,0,0,0,5.74,0A1,1,0,0,0,14.5,14.06ZM15,9a1,1,0,1,0,1,1A1,1,0,0,0,15,9ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18A8,8,0,0,1,9,4.57,3,3,0,0,0,9,5a3,3,0,0,0,3,3,1,1,0,0,0,0-2,1,1,0,0,1,0-2,8,8,0,0,1,0,16Z'
  }));
};

UilKid.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilKid.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLabel = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,11.29l-5-5A1,1,0,0,0,16,6H5A3,3,0,0,0,2,9v6a3,3,0,0,0,3,3H16a1,1,0,0,0,.71-.29l5-5A1,1,0,0,0,21.71,11.29ZM15.59,16H5a1,1,0,0,1-1-1V9A1,1,0,0,1,5,8H15.59l4,4Z'
  }));
};

UilLabel.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLabel.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLabelAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15,12a1,1,0,1,0,1-1A1,1,0,0,0,15,12Zm6.71-.71-5-5A1,1,0,0,0,16,6H5A3,3,0,0,0,2,9v6a3,3,0,0,0,3,3H16a1,1,0,0,0,.71-.29l5-5A1,1,0,0,0,21.71,11.29ZM15.59,16H5a1,1,0,0,1-1-1V9A1,1,0,0,1,5,8H15.59l4,4Z'
  }));
};

UilLabelAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLabelAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLamp = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,2.78A1,1,0,0,0,17,2H7a1,1,0,0,0-1,.78l-2,9a1,1,0,0,0,.2.85A1,1,0,0,0,5,13H8.94A8.26,8.26,0,0,1,9,14a8.92,8.92,0,0,1-2.57,6.3A1,1,0,0,0,7.14,22h9.72a1,1,0,0,0,.71-1.7A8.92,8.92,0,0,1,15,14a8.26,8.26,0,0,1,.06-1H16v2a1,1,0,0,0,2,0V13h1a1,1,0,0,0,.78-.37,1,1,0,0,0,.2-.85ZM9.22,20A10.9,10.9,0,0,0,11,14c0-.33,0-.67-.05-1h2.1c0,.33-.05.67-.05,1a10.9,10.9,0,0,0,1.78,6Zm-3-9L7.8,4h8.4l1.55,7Z'
  }));
};

UilLamp.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLamp.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLanguage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.05566,12h-2a1,1,0,0,0,0,2v2H17.8714a2.96481,2.96481,0,0,0,.18426-1A2.99955,2.99955,0,0,0,12.458,13.50049a.99992.99992,0,1,0,1.73242.999A1.0009,1.0009,0,0,1,15.05566,14a1,1,0,0,1,0,2,1,1,0,0,0,0,2,1,1,0,1,1,0,2,1.0009,1.0009,0,0,1-.86523-.49951.99992.99992,0,1,0-1.73242.999A2.99955,2.99955,0,0,0,18.05566,19a2.96481,2.96481,0,0,0-.18426-1h1.18426v3a1,1,0,0,0,2,0V14a1,1,0,1,0,0-2ZM9.08594,11.24268a.99963.99963,0,1,0,1.93945-.48536L9.26855,3.72754a2.28044,2.28044,0,0,0-4.4248,0L3.08594,10.75732a.99963.99963,0,1,0,1.93945.48536L5.58618,9H8.52545ZM6.0863,7l.6969-2.78711a.29222.29222,0,0,1,.5459,0L8.02563,7Zm7.96936,0h1a1.001,1.001,0,0,1,1,1V9a1,1,0,0,0,2,0V8a3.00328,3.00328,0,0,0-3-3h-1a1,1,0,0,0,0,2Zm-4,9h-1a1.001,1.001,0,0,1-1-1V14a1,1,0,0,0-2,0v1a3.00328,3.00328,0,0,0,3,3h1a1,1,0,0,0,0-2Z'
  }));
};

UilLanguage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLanguage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLaptop = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14H20V7a3,3,0,0,0-3-3H7A3,3,0,0,0,4,7v7H3a1,1,0,0,0-1,1v2a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V15A1,1,0,0,0,21,14ZM6,7A1,1,0,0,1,7,6H17a1,1,0,0,1,1,1v7H6ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V16H20Z'
  }));
};

UilLaptop.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLaptop.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLaptopCloud = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.5,10H10a3,3,0,0,0,1.07-5.8,4,4,0,0,0-7.48,1A2.5,2.5,0,0,0,4.5,10Zm0-3a1,1,0,0,0,1-1,2,2,0,0,1,3.89-.64,1,1,0,0,0,.78.66A1,1,0,0,1,11,7a1,1,0,0,1-1,1H4.5a.5.5,0,0,1,0-1ZM21,16H20V9a3,3,0,0,0-3-3H16a1,1,0,0,0,0,2h1a1,1,0,0,1,1,1v7H6V13a1,1,0,0,0-2,0v3H3a1,1,0,0,0-1,1v2a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V17A1,1,0,0,0,21,16Zm-1,3a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V18H20Z'
  }));
};

UilLaptopCloud.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLaptopCloud.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLaptopConnection = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,18H14.82A3,3,0,0,0,13,16.18V13h7a1,1,0,0,0,0-2H19V5a3,3,0,0,0-3-3H8A3,3,0,0,0,5,5v6H4a1,1,0,0,0,0,2h7v3.18A3,3,0,0,0,9.18,18H3a1,1,0,0,0,0,2H9.18a3,3,0,0,0,5.64,0H21a1,1,0,0,0,0-2ZM7,11V5A1,1,0,0,1,8,4h8a1,1,0,0,1,1,1v6Zm5,9a1,1,0,1,1,1-1A1,1,0,0,1,12,20Z'
  }));
};

UilLaptopConnection.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLaptopConnection.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLaughing = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.16,12.21a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42L14.79,10l.79-.79a1,1,0,1,0-1.42-1.42l-1.5,1.5a1,1,0,0,0,0,1.42Zm-5.08,0,1.5-1.5a1,1,0,0,0,0-1.42l-1.5-1.5A1,1,0,0,0,7.66,9.21l.8.79-.8.79a1,1,0,0,0,0,1.42,1,1,0,0,0,.71.29A1,1,0,0,0,9.08,12.21Zm5.28,2a3.76,3.76,0,0,1-4.72,0,1,1,0,0,0-1.28,1.54,5.68,5.68,0,0,0,7.28,0,1,1,0,1,0-1.28-1.54ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilLaughing.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLaughing.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLayerGroup = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M2.5,8.86l9,5.2a1,1,0,0,0,1,0l9-5.2A1,1,0,0,0,22,8a1,1,0,0,0-.5-.87l-9-5.19a1,1,0,0,0-1,0l-9,5.19A1,1,0,0,0,2,8,1,1,0,0,0,2.5,8.86ZM12,4l7,4-7,4L5,8Zm8.5,7.17L12,16,3.5,11.13a1,1,0,0,0-1.37.37,1,1,0,0,0,.37,1.36l9,5.2a1,1,0,0,0,1,0l9-5.2a1,1,0,0,0,.37-1.36A1,1,0,0,0,20.5,11.13Zm0,4L12,20,3.5,15.13a1,1,0,0,0-1.37.37,1,1,0,0,0,.37,1.36l9,5.2a1,1,0,0,0,1,0l9-5.2a1,1,0,0,0,.37-1.36A1,1,0,0,0,20.5,15.13Z'
  }));
};

UilLayerGroup.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLayerGroup.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLayerGroupSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.26,5,12,4l7,4L15.85,9.83a1,1,0,0,0-.37,1.36,1,1,0,0,0,1.37.37L21.5,8.87a1,1,0,0,0,0-1.74l-9-5.2a1,1,0,0,0-1,0L9.26,3.23A1,1,0,0,0,8.89,4.6,1,1,0,0,0,10.26,5ZM3.71,2.29A1,1,0,0,0,2.29,3.71L4.54,6l-2,1.17a1,1,0,0,0,0,1.74l9,5.2a1,1,0,0,0,1,0l.1-.06,1.07,1.07-1.67,1L3.5,11.13a1,1,0,1,0-1,1.74l9,5.2a1,1,0,0,0,.5.13,1,1,0,0,0,.5-.13l2.63-1.52,1.07,1.07L12,20,3.5,15.13a1,1,0,0,0-1,1.74l9,5.2a1,1,0,0,0,1,0l5.17-3,2.62,2.63a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM5,8l1-.58,2.75,2.75Zm15.5,3.13-2.12,1.22a1,1,0,0,0,1,1.74l2.12-1.22a1,1,0,1,0-1-1.74Z'
  }));
};

UilLayerGroupSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLayerGroupSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLayers = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M2.5,10.56l9,5.2a1,1,0,0,0,1,0l9-5.2a1,1,0,0,0,0-1.73l-9-5.2a1,1,0,0,0-1,0l-9,5.2a1,1,0,0,0,0,1.73ZM12,5.65l7,4-7,4.05L5,9.69Zm8.5,7.79L12,18.35,3.5,13.44a1,1,0,0,0-1.37.36,1,1,0,0,0,.37,1.37l9,5.2a1,1,0,0,0,1,0l9-5.2a1,1,0,0,0,.37-1.37A1,1,0,0,0,20.5,13.44Z'
  }));
};

UilLayers.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLayers.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLayersAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2H9A1,1,0,0,0,8,3V7H6A1,1,0,0,0,5,8v4H3a1,1,0,0,0-1,1v8a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V19h4a1,1,0,0,0,1-1V16h4a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM10,20H4V14h6Zm5-3H12V13a1,1,0,0,0-1-1H7V9h8Zm5-3H17V8a1,1,0,0,0-1-1H10V4H20Z'
  }));
};

UilLayersAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLayersAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLayersSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.49,13.94l-.34.2a1,1,0,0,0-.35,1.37,1,1,0,0,0,.86.49,1,1,0,0,0,.51-.14l.34-.2a1,1,0,0,0-1-1.72ZM11.65,6.36,12,6.15l7,4-1.76,1a1,1,0,0,0,.5,1.87,1,1,0,0,0,.5-.13l3.26-1.89a1,1,0,0,0,0-1.74l-9-5.19a1,1,0,0,0-1,0l-.85.49a1,1,0,0,0,1,1.74ZM3.71,2.29A1,1,0,0,0,2.29,3.71L5.93,7.34l-3.43,2a1,1,0,0,0,0,1.74l9,5.2a1.09,1.09,0,0,0,.5.13,1.13,1.13,0,0,0,.5-.13L14,15.4l1.45,1.46-3.44,2L3.5,13.93a1,1,0,0,0-1,1.74l9,5.2a1,1,0,0,0,1,0l4.41-2.55,3.38,3.39a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm8.29,12L5,10.19,7.4,8.81l5.12,5.13Z'
  }));
};

UilLayersSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLayersSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLeftArrowFromLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,11H5.41l2.3-2.29A1,1,0,1,0,6.29,7.29l-4,4a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H17a1,1,0,0,0,0-2Zm4-7a1,1,0,0,0-1,1V19a1,1,0,0,0,2,0V5A1,1,0,0,0,21,4Z'
  }));
};

UilLeftArrowFromLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLeftArrowFromLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLeftArrowToLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,11H9.41l2.3-2.29a1,1,0,1,0-1.42-1.42l-4,4a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L9.41,13H21a1,1,0,0,0,0-2ZM3,3A1,1,0,0,0,2,4V20a1,1,0,0,0,2,0V4A1,1,0,0,0,3,3Z'
  }));
};

UilLeftArrowToLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLeftArrowToLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLeftIndent = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7Zm0,4H13a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2ZM21.77,9.69a1,1,0,0,0-1.41-.12l-2,1.66a1,1,0,0,0,0,1.54l2,1.66a1,1,0,0,0,.64.24,1,1,0,0,0,.77-.36,1,1,0,0,0-.13-1.41L20.56,12l1.08-.9A1,1,0,0,0,21.77,9.69ZM21,17H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM3,15H13a1,1,0,0,0,0-2H3a1,1,0,0,0,0,2Z'
  }));
};

UilLeftIndent.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLeftIndent.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLeftIndentAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,5A1,1,0,0,0,8,6V18a1,1,0,0,0,2,0V6A1,1,0,0,0,9,5Zm4,2h8a1,1,0,0,0,0-2H13a1,1,0,0,0,0,2ZM5.77,9.69a1,1,0,0,0-1.41-.13l-2,1.67a1,1,0,0,0,0,1.54l2,1.67a1,1,0,0,0,1.41-.13,1,1,0,0,0-.13-1.41L4.56,12l1.08-.9A1,1,0,0,0,5.77,9.69ZM21,9H13a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Zm0,4H13a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Zm0,4H13a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Z'
  }));
};

UilLeftIndentAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLeftIndentAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLeftToRightTextDirection = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.42,17.62a1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L18.09,17H3.5a1,1,0,0,0,0,2H18.09l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,.21-.33A1,1,0,0,0,21.42,17.62ZM8.5,10v4a1,1,0,0,0,2,0V4h2V14a1,1,0,0,0,2,0V4h1a1,1,0,0,0,0-2h-7a4,4,0,0,0,0,8Zm0-6V8a2,2,0,0,1,0-4Z'
  }));
};

UilLeftToRightTextDirection.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLeftToRightTextDirection.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLetterChineseA = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,5H13V4a1,1,0,0,0-2,0V5H4A1,1,0,0,0,4,7H15.88214a14.49252,14.49252,0,0,1-3.94067,7.95227A14.42561,14.42561,0,0,1,8.66406,9.67041a1.0002,1.0002,0,0,0-1.88867.65918,16.41412,16.41412,0,0,0,3.68012,5.95825,14.29858,14.29858,0,0,1-5.769,2.73511A1.00015,1.00015,0,0,0,4.89941,21a1.01758,1.01758,0,0,0,.21485-.023,16.297,16.297,0,0,0,6.831-3.31885A16.38746,16.38746,0,0,0,18.78711,20.977a1,1,0,0,0,.42578-1.9541,14.38226,14.38226,0,0,1-5.78955-2.73316A16.4802,16.4802,0,0,0,17.89233,7H20a1,1,0,0,0,0-2Z'
  }));
};

UilLetterChineseA.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLetterChineseA.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLetterEnglishA = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.97021,19.75732,15.34912,5.27246A2.9958,2.9958,0,0,0,12.43848,3h-.877A2.9958,2.9958,0,0,0,8.65088,5.27246L5.02979,19.75732a1.0001,1.0001,0,0,0,1.94042.48536L8.28082,15h7.43836l1.31061,5.24268a1.0001,1.0001,0,0,0,1.94042-.48536ZM8.78082,13l1.81049-7.24219A.99825.99825,0,0,1,11.56152,5h.877a.99825.99825,0,0,1,.97021.75781L15.21918,13Z'
  }));
};

UilLetterEnglishA.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLetterEnglishA.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLetterHindiA = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.022,3h-5a1,1,0,0,0,0,2h1.5v6H11.57208a4.95124,4.95124,0,0,0,1.02558-3A5,5,0,0,0,3.26758,5.5.99974.99974,0,1,0,4.999,6.5,3.00021,3.00021,0,1,1,7.59766,11a1,1,0,0,0,0,2A3,3,0,1,1,4.999,17.5a.99974.99974,0,0,0-1.73144,1A5,5,0,0,0,12.59766,16a4.95124,4.95124,0,0,0-1.02558-3H16.522v7a1,1,0,0,0,2,0V5h1.5a1,1,0,0,0,0-2Z'
  }));
};

UilLetterHindiA.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLetterHindiA.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLetterJapaneseA = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.47168,11.99707a4.86537,4.86537,0,0,0-4.00049-2.2038A5.59215,5.59215,0,0,0,16.34082,8.769a.9997.9997,0,1,0-1.94531.46192,3.55342,3.55342,0,0,1,.0827.60132,13.57729,13.57729,0,0,0-3.257.82189c.02252-1.20385.07678-2.40728.19672-3.60729l.03827-.38221a33.43522,33.43522,0,0,0,3.48224-.66418l.12011-.02979a1,1,0,1,0-.48047-1.9414l-.12207.03027c-.92163.23047-1.85565.40448-2.79394.5506l.15137-1.51056a1.00009,1.00009,0,0,0-1.99024-.19922L9.627,4.85962C8.69312,4.94336,7.75665,5,6.81836,5a1,1,0,0,0,0,2c.87054,0,1.7395-.04639,2.60681-.1142A46.66015,46.66015,0,0,0,9.222,11.58386c-.13421.07324-.26965.14209-.40264.21936a16.4074,16.4074,0,0,0-1.94922,1.31055l-.02246.01807a13.7396,13.7396,0,0,0-2.64844,2.70068,3.00419,3.00419,0,0,0,2.94629,4.71875A9.74034,9.74034,0,0,0,9.98328,19.5379a.99564.99564,0,0,0,1.82141-.70245c-.02423-.1452-.03534-.29193-.05811-.43732a13.83775,13.83775,0,0,0,1.314-1.15545,13.16694,13.16694,0,0,0,2.10168-2.729c.02289-.03949.04212-.0791.06445-.11865.118-.21057.22944-.422.33179-.63495.05383-.11108.1023-.22174.15155-.33282.05994-.13623.11719-.27222.17047-.40882.05646-.14361.10981-.28662.15845-.42968.03235-.09583.06055-.19123.08948-.28693.05133-.16882.10174-.3371.142-.50427l.005-.01776a3.01462,3.01462,0,0,1,2.46582,1.21972c1.01856,1.76709-.96289,4.977-4.417,7.15479a.99976.99976,0,1,0,1.0664,1.6914C19.88965,19.00977,22.07422,14.77734,20.47168,11.99707ZM6.7959,18.58252a1.00469,1.00469,0,0,1-.97949-1.57373,11.89343,11.89343,0,0,1,2.291-2.32275l.02637-.02149c.35388-.27692.742-.539,1.144-.793.0611,1.19537.17285,2.38684.32593,3.57489A8.18484,8.18484,0,0,1,6.7959,18.58252Zm7.32977-6.583a8.16646,8.16646,0,0,1-.31616.78137c-.0556.1189-.118.23774-.18018.35694q-.14419.27851-.3106.55432c-.08466.13953-.17188.27887-.26514.41742a11.48078,11.48078,0,0,1-1.40711,1.719c-.06982.06983-.14343.1333-.2146.201q-.16314-1.5975-.21124-3.20276a12.51276,12.51276,0,0,1,2.94-.93237C14.149,11.9295,14.13794,11.96436,14.12567,11.99951Z'
  }));
};

UilLetterJapaneseA.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLetterJapaneseA.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLifeRing = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,11.05c0-.11,0-.22,0-.33l-.09-.6-.09-.39c0-.17-.08-.34-.13-.51s-.08-.27-.13-.4a2.17,2.17,0,0,1-.07-.24s0,0,0-.05a10.1,10.1,0,0,0-5.9-5.9s0,0-.05,0l-.23-.07-.42-.13c-.15,0-.31-.08-.46-.12l-.46-.1-.46-.07c-.16,0-.31,0-.48-.06s-.35,0-.52,0L12,2l-.39,0c-.17,0-.35,0-.52,0s-.32,0-.48.06l-.46.07-.46.1c-.15,0-.31.07-.46.12l-.42.13-.23.07s0,0-.05,0a10.1,10.1,0,0,0-5.9,5.9s0,0,0,.05a2.17,2.17,0,0,1-.07.24c0,.13-.09.26-.13.4s-.09.34-.13.51l-.09.39-.09.6c0,.11,0,.22,0,.33,0,.31,0,.63,0,.95s0,.64,0,.95c0,.11,0,.22,0,.33l.09.6.09.39c0,.17.08.34.13.51s.08.27.13.4a2.17,2.17,0,0,1,.07.24.43.43,0,0,1,0,.07,10,10,0,0,0,5.89,5.88s0,0,.05,0l.24.07.4.13.51.13.39.09.6.09.33,0c.31,0,.63.05.95.05s.64,0,.95-.05l.33,0,.6-.09.39-.09.51-.13.4-.13.24-.07s0,0,.05,0a10,10,0,0,0,5.89-5.88.43.43,0,0,1,0-.07c0-.08.05-.16.07-.24s.09-.26.13-.4.09-.34.13-.51l.09-.39.09-.6c0-.11,0-.22,0-.33,0-.31.05-.63.05-.95S22,11.36,22,11.05Zm-6.3-6.16a8,8,0,0,1,3.46,3.46l-2.86,1a5.14,5.14,0,0,0-1.64-1.64Zm-5.36-.7c.21-.05.41-.08.61-.11l.24,0a8.24,8.24,0,0,1,1.72,0l.24,0c.2,0,.4.06.61.11h.06l-1,2.86A4.49,4.49,0,0,0,12,7a4.4,4.4,0,0,0-.73.06l-1-2.86Zm-1.94.7,1,2.86A5.14,5.14,0,0,0,7.75,9.39l-2.86-1A8,8,0,0,1,8.35,4.89ZM4.19,13.71a4.17,4.17,0,0,1-.1-.6c0-.09,0-.17,0-.25a7.42,7.42,0,0,1,0-1.72c0-.08,0-.16,0-.25a4.17,4.17,0,0,1,.1-.6s0,0,0-.06l2.86,1a4.47,4.47,0,0,0,0,1.46l-2.86,1S4.19,13.73,4.19,13.71Zm4.16,5.4a8,8,0,0,1-3.46-3.46l2.86-1a5.14,5.14,0,0,0,1.64,1.64Zm5.36.7c-.21.05-.41.08-.61.11l-.24,0a8.24,8.24,0,0,1-1.72,0l-.24,0c-.2,0-.4-.06-.61-.11h-.06l1-2.86a4.47,4.47,0,0,0,1.46,0l1,2.86Zm-.67-5h0c-.17.06-.34.1-.5.14a2.73,2.73,0,0,1-1,0c-.16,0-.33-.08-.5-.14h0A3,3,0,0,1,9.2,13v0a3.23,3.23,0,0,1-.14-.51,2.63,2.63,0,0,1,0-1A3.23,3.23,0,0,1,9.19,11v0A3,3,0,0,1,11,9.2h0c.17-.06.34-.1.5-.14a2.73,2.73,0,0,1,1,0c.16,0,.33.08.5.14h0A3,3,0,0,1,14.8,11v0a3.23,3.23,0,0,1,.14.51,2.63,2.63,0,0,1,0,1,3.23,3.23,0,0,1-.14.51v0A3,3,0,0,1,13,14.8Zm2.61,4.31-1-2.86a5.14,5.14,0,0,0,1.64-1.64l2.86,1A8,8,0,0,1,15.65,19.11ZM20,12.86c0,.08,0,.16,0,.25a4.17,4.17,0,0,1-.1.6s0,0,0,.06l-2.86-1a4.47,4.47,0,0,0,0-1.46l2.86-1s0,0,0,.06a4.17,4.17,0,0,1,.1.6c0,.09,0,.17,0,.25a7.42,7.42,0,0,1,0,1.72Z'
  }));
};

UilLifeRing.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLifeRing.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLightbulb = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.45,12.46a7,7,0,0,0-1-9.83,7.09,7.09,0,0,0-5.92-1.4,7,7,0,0,0-4,11.15,4.76,4.76,0,0,1,1.08,2.86v.29A2,2,0,0,0,7,16.93v2a2,2,0,0,0,2,2v1a1,1,0,0,0,2,0v-1h2v1a1,1,0,0,0,2,0v-1a2,2,0,0,0,2-2v-2a2,2,0,0,0-.57-1.4V15.1A4.26,4.26,0,0,1,17.45,12.46ZM9,18.93v-2h6v2Zm6.89-7.72a6.18,6.18,0,0,0-1.46,3.72H9.56a6.67,6.67,0,0,0-1.5-3.78,5,5,0,0,1,2.84-8A5,5,0,0,1,17,8.07,4.92,4.92,0,0,1,15.89,11.21Z'
  }));
};

UilLightbulb.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLightbulb.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLightbulbAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.09,2.82a8,8,0,0,0-6.68-1.66A8,8,0,0,0,4.14,7.48a8.07,8.07,0,0,0,1.72,6.65A4.54,4.54,0,0,1,7,17v3a3,3,0,0,0,3,3h4a3,3,0,0,0,3-3V17.19A5.17,5.17,0,0,1,18.22,14a8,8,0,0,0-1.13-11.2ZM15,20a1,1,0,0,1-1,1H10a1,1,0,0,1-1-1V19h6Zm1.67-7.24A7.13,7.13,0,0,0,15,17H13V14a1,1,0,0,0-2,0v3H9a6.5,6.5,0,0,0-1.6-4.16,6,6,0,0,1,3.39-9.72A6,6,0,0,1,18,9,5.89,5.89,0,0,1,16.67,12.76Z'
  }));
};

UilLightbulbAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLightbulbAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLine = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.78,9.46h0a.38.38,0,0,0-.38.38v1.67L12,9.65a.4.4,0,0,0-.33-.19h0a.38.38,0,0,0-.38.38v2.84a.38.38,0,0,0,.38.38h0a.38.38,0,0,0,.38-.38V11l1.39,1.91,0,0h0a.27.27,0,0,0,.15.11.32.32,0,0,0,.14,0h0A.33.33,0,0,0,14,13l.1-.07h0a.39.39,0,0,0,.11-.27V9.84A.38.38,0,0,0,13.78,9.46ZM9.2,12.27H8.14V9.84a.38.38,0,0,0-.38-.38h0a.38.38,0,0,0-.38.38v2.84a.38.38,0,0,0,.38.38H9.2a.39.39,0,0,0,.39-.38v0A.39.39,0,0,0,9.2,12.27Zm1.11-2.81h0a.39.39,0,0,0-.39.38v2.84a.39.39,0,0,0,.39.38h0a.38.38,0,0,0,.38-.38V9.84A.38.38,0,0,0,10.31,9.46ZM17.91,2H6.09A4.1,4.1,0,0,0,2,6.09V17.91A4.1,4.1,0,0,0,6.09,22H17.91A4.1,4.1,0,0,0,22,17.91V6.09A4.1,4.1,0,0,0,17.91,2Zm.31,12.28a1.55,1.55,0,0,1-.13.17h0a5.5,5.5,0,0,1-.8.8c-2,1.87-5.36,4.11-5.81,3.76s.64-1.76-.53-2a1,1,0,0,1-.25,0h0c-3.44-.48-6-2.89-6-5.78,0-3.25,3.29-5.88,7.34-5.88s7.34,2.63,7.34,5.88A5,5,0,0,1,18.22,14.28ZM16.51,9.47H15a.38.38,0,0,0-.38.38v2.84a.38.38,0,0,0,.38.38h1.48a.38.38,0,0,0,.38-.38v0a.38.38,0,0,0-.38-.38H15.45v-.6h1.06a.39.39,0,0,0,.38-.39v0a.38.38,0,0,0-.38-.38H15.45v-.61h1.06a.38.38,0,0,0,.38-.38v0A.38.38,0,0,0,16.51,9.47Z'
  }));
};

UilLine.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLine.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLineAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,3.29a1,1,0,0,0-1.42,0l-18,18a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l18-18A1,1,0,0,0,21.71,3.29Z'
  }));
};

UilLineAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLineAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLineSpacing = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6.29,9.71a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2-2a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2,2A1,1,0,0,0,3.71,9.71L4,9.41v5.18l-.29-.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2-2a1,1,0,0,0-1.42-1.42l-.29.3V9.41ZM11,8H21a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm10,3H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0,5H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilLineSpacing.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLineSpacing.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLink = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,17.55,8.23,19.27a2.47,2.47,0,0,1-3.5-3.5l4.54-4.55a2.46,2.46,0,0,1,3.39-.09l.12.1a1,1,0,0,0,1.4-1.43A2.75,2.75,0,0,0,14,9.59a4.46,4.46,0,0,0-6.09.22L3.31,14.36a4.48,4.48,0,0,0,6.33,6.33L11.37,19A1,1,0,0,0,10,17.55ZM20.69,3.31a4.49,4.49,0,0,0-6.33,0L12.63,5A1,1,0,0,0,14,6.45l1.73-1.72a2.47,2.47,0,0,1,3.5,3.5l-4.54,4.55a2.46,2.46,0,0,1-3.39.09l-.12-.1a1,1,0,0,0-1.4,1.43,2.75,2.75,0,0,0,.23.21,4.47,4.47,0,0,0,6.09-.22l4.55-4.55A4.49,4.49,0,0,0,20.69,3.31Z'
  }));
};

UilLink.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLink.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLinkAdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.11,15.39,8.23,19.27a2.47,2.47,0,0,1-3.5,0,2.46,2.46,0,0,1,0-3.5l3.88-3.88a1,1,0,1,0-1.42-1.42L3.31,14.36a4.48,4.48,0,0,0,6.33,6.33l3.89-3.88a1,1,0,0,0-1.42-1.42Zm-3.28-.22a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l4.92-4.92a1,1,0,1,0-1.42-1.42L8.83,13.75A1,1,0,0,0,8.83,15.17ZM21,18H20V17a1,1,0,0,0-2,0v1H17a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0V20h1a1,1,0,0,0,0-2Zm-4.19-4.47,3.88-3.89a4.48,4.48,0,0,0-6.33-6.33L10.47,7.19a1,1,0,1,0,1.42,1.42l3.88-3.88a2.47,2.47,0,0,1,3.5,0,2.46,2.46,0,0,1,0,3.5l-3.88,3.88a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0Z'
  }));
};

UilLinkAdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLinkAdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLinkAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.11,15.39,8.23,19.27a2.52,2.52,0,0,1-3.5,0,2.47,2.47,0,0,1,0-3.5l3.88-3.88a1,1,0,1,0-1.42-1.42L3.31,14.36a4.48,4.48,0,0,0,6.33,6.33l3.89-3.88a1,1,0,0,0-1.42-1.42ZM20.69,3.31a4.49,4.49,0,0,0-6.33,0L10.47,7.19a1,1,0,1,0,1.42,1.42l3.88-3.88a2.52,2.52,0,0,1,3.5,0,2.47,2.47,0,0,1,0,3.5l-3.88,3.88a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3.88-3.89A4.49,4.49,0,0,0,20.69,3.31ZM8.83,15.17a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l4.92-4.92a1,1,0,1,0-1.42-1.42L8.83,13.75A1,1,0,0,0,8.83,15.17Z'
  }));
};

UilLinkAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLinkAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLinkBroken = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.76,10.59a1,1,0,0,0,.26-2L3.26,8.15a1,1,0,1,0-.52,1.93l1.76.47A.78.78,0,0,0,4.76,10.59ZM8.62,5a1,1,0,0,0,1,.74.82.82,0,0,0,.26,0,1,1,0,0,0,.7-1.22l-.47-1.76a1,1,0,1,0-1.93.52Zm4.83,10A1,1,0,0,0,12,15L8.5,18.56a2.21,2.21,0,0,1-3.06,0,2.15,2.15,0,0,1,0-3.06L9,12a1,1,0,1,0-1.41-1.41L4,14.08A4.17,4.17,0,1,0,9.92,20l3.53-3.53A1,1,0,0,0,13.45,15ZM5.18,6.59a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41L5.3,3.89A1,1,0,0,0,3.89,5.3Zm16.08,7.33-1.76-.47A1,1,0,1,0,19,15.38l1.76.47.26,0a1,1,0,0,0,.26-2ZM15.38,19a1,1,0,0,0-1.23-.7,1,1,0,0,0-.7,1.22l.47,1.76a1,1,0,0,0,1,.74,1.15,1.15,0,0,0,.26,0,1,1,0,0,0,.71-1.23Zm3.44-1.57a1,1,0,0,0-1.41,1.41l1.29,1.29a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41ZM21.2,7A4.16,4.16,0,0,0,14.08,4L10.55,7.56A1,1,0,1,0,12,9L15.5,5.44a2.21,2.21,0,0,1,3.06,0,2.15,2.15,0,0,1,0,3.06L15,12a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0L20,9.92A4.19,4.19,0,0,0,21.2,7Z'
  }));
};

UilLinkBroken.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLinkBroken.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLinkH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,12a1,1,0,0,0,1,1h6a1,1,0,0,0,0-2H9A1,1,0,0,0,8,12Zm2,3H7A3,3,0,0,1,7,9h3a1,1,0,0,0,0-2H7A5,5,0,0,0,7,17h3a1,1,0,0,0,0-2Zm7-8H14a1,1,0,0,0,0,2h3a3,3,0,0,1,0,6H14a1,1,0,0,0,0,2h3A5,5,0,0,0,17,7Z'
  }));
};

UilLinkH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLinkH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLinkedin = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.47,2H3.53A1.45,1.45,0,0,0,2.06,3.43V20.57A1.45,1.45,0,0,0,3.53,22H20.47a1.45,1.45,0,0,0,1.47-1.43V3.43A1.45,1.45,0,0,0,20.47,2ZM8.09,18.74h-3v-9h3ZM6.59,8.48h0a1.56,1.56,0,1,1,0-3.12,1.57,1.57,0,1,1,0,3.12ZM18.91,18.74h-3V13.91c0-1.21-.43-2-1.52-2A1.65,1.65,0,0,0,12.85,13a2,2,0,0,0-.1.73v5h-3s0-8.18,0-9h3V11A3,3,0,0,1,15.46,9.5c2,0,3.45,1.29,3.45,4.06Z'
  }));
};

UilLinkedin.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLinkedin.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLinkedinAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.5,8.999a5.41868,5.41868,0,0,0-2.56543.64453A.99918.99918,0,0,0,14,8.999H10a.99943.99943,0,0,0-1,1v12a.99942.99942,0,0,0,1,1h4a.99942.99942,0,0,0,1-1v-5.5a1,1,0,1,1,2,0v5.5a.99942.99942,0,0,0,1,1h4a.99942.99942,0,0,0,1-1v-7.5A5.50685,5.50685,0,0,0,17.5,8.999Zm3.5,12H19v-4.5a3,3,0,1,0-6,0v4.5H11v-10h2v.70313a1.00048,1.00048,0,0,0,1.78125.625A3.48258,3.48258,0,0,1,21,14.499Zm-14-12H3a.99943.99943,0,0,0-1,1v12a.99942.99942,0,0,0,1,1H7a.99942.99942,0,0,0,1-1v-12A.99943.99943,0,0,0,7,8.999Zm-1,12H4v-10H6ZM5.01465,1.542A3.23283,3.23283,0,1,0,4.958,7.999h.02832a3.23341,3.23341,0,1,0,.02832-6.457ZM4.98633,5.999H4.958A1.22193,1.22193,0,0,1,3.58887,4.77051c0-.7461.55957-1.22852,1.42578-1.22852A1.2335,1.2335,0,0,1,6.41113,4.77051C6.41113,5.5166,5.85156,5.999,4.98633,5.999Z'
  }));
};

UilLinkedinAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLinkedinAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLiraSign = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,12a1,1,0,0,0-1,1,7.00787,7.00787,0,0,1-7,7V11.13538l5.2168-1.15931a.99986.99986,0,0,0-.4336-1.95214L10,9.08685V7.13538l5.2168-1.15931a.99986.99986,0,1,0-.4336-1.95214L10,5.08685V3A1,1,0,0,0,8,3V5.53131l-2.2168.49262a.99986.99986,0,1,0,.4336,1.95214L8,7.57983V9.53131l-2.2168.49262a.99986.99986,0,1,0,.4336,1.95214L8,11.57983V21a1,1,0,0,0,1,1h1a9.01047,9.01047,0,0,0,9-9A1,1,0,0,0,18,12Z'
  }));
};

UilLiraSign.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLiraSign.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilListUiAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3.5,6a1,1,0,1,0,1,1A1,1,0,0,0,3.5,6Zm4,2h14a1,1,0,0,0,0-2H7.5a1,1,0,0,0,0,2Zm0,3a1,1,0,1,0,1,1A1,1,0,0,0,7.5,11Zm4,5a1,1,0,1,0,1,1A1,1,0,0,0,11.5,16Zm10-5h-10a1,1,0,0,0,0,2h10a1,1,0,0,0,0-2Zm0,5h-6a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z'
  }));
};

UilListUiAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilListUiAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilListUl = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M3.71,16.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21,1,1,0,0,0-.21.33,1,1,0,0,0,.21,1.09,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1,1,0,0,0,3.71,16.29ZM7,8H21a1,1,0,0,0,0-2H7A1,1,0,0,0,7,8ZM3.71,11.29a1,1,0,0,0-1.09-.21,1.15,1.15,0,0,0-.33.21,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76A1,1,0,0,0,3.71,11.29ZM21,11H7a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM3.71,6.29a1,1,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1.15,1.15,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33,1.15,1.15,0,0,0,.33.21,1,1,0,0,0,1.09-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76A1.15,1.15,0,0,0,3.71,6.29ZM21,16H7a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilListUl.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilListUl.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLocationArrow = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.15,2.86a2.89,2.89,0,0,0-3-.71L4,6.88a2.9,2.9,0,0,0-.12,5.47l5.24,2h0a.93.93,0,0,1,.53.52l2,5.25A2.87,2.87,0,0,0,14.36,22h.07a2.88,2.88,0,0,0,2.69-2L21.85,5.83A2.89,2.89,0,0,0,21.15,2.86ZM20,5.2,15.22,19.38a.88.88,0,0,1-.84.62.92.92,0,0,1-.87-.58l-2-5.25a2.91,2.91,0,0,0-1.67-1.68l-5.25-2A.9.9,0,0,1,4,9.62a.88.88,0,0,1,.62-.84L18.8,4.05A.91.91,0,0,1,20,5.2Z'
  }));
};

UilLocationArrow.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLocationArrow.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLocationArrowAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.68,17.65l-7-14a3,3,0,0,0-5.36,0l-7,14a3,3,0,0,0,3.9,4.08l5.37-2.4h0a1.06,1.06,0,0,1,.82,0l5.37,2.4a3,3,0,0,0,3.9-4.08Zm-2,2a1,1,0,0,1-1.13.22l-5.37-2.39a3,3,0,0,0-2.44,0L5.41,19.9a1,1,0,0,1-1.3-1.35l7-14a1,1,0,0,1,1.78,0l7,14A1,1,0,0,1,19.72,19.68Z'
  }));
};

UilLocationArrowAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLocationArrowAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLocationPinAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,10.8a2,2,0,1,0-2-2A2,2,0,0,0,12,10.8Zm-.71,6.91a1,1,0,0,0,1.42,0l4.09-4.1a6.79,6.79,0,1,0-9.6,0ZM7.23,8.34A4.81,4.81,0,0,1,9.36,4.79a4.81,4.81,0,0,1,5.28,0,4.82,4.82,0,0,1,.75,7.41L12,15.59,8.61,12.2A4.77,4.77,0,0,1,7.23,8.34ZM19,20H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2Z'
  }));
};

UilLocationPinAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLocationPinAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLocationPoint = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,4.48a8.45,8.45,0,0,0-12,12l5.27,5.28a1,1,0,0,0,1.42,0L18,16.43A8.45,8.45,0,0,0,18,4.48ZM16.57,15,12,19.59,7.43,15a6.46,6.46,0,1,1,9.14,0ZM9,7.41a4.32,4.32,0,0,0,0,6.1,4.31,4.31,0,0,0,7.36-3,4.24,4.24,0,0,0-1.26-3.05A4.3,4.3,0,0,0,9,7.41Zm4.69,4.68a2.33,2.33,0,1,1,.67-1.63A2.33,2.33,0,0,1,13.64,12.09Z'
  }));
};

UilLocationPoint.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLocationPoint.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,9V7A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9ZM9,7a3,3,0,0,1,6,0V9H9Zm9,12a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z'
  }));
};

UilLock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLockAccess = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2H15a1,1,0,0,0,0,2h5V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21,2Zm0,12a1,1,0,0,0-1,1v5H15a1,1,0,0,0,0,2h6a1,1,0,0,0,1-1V15A1,1,0,0,0,21,14ZM12,6A3,3,0,0,0,9,9v1a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2V9A3,3,0,0,0,12,6ZM11,9a1,1,0,0,1,2,0v1H11Zm4,7H9V12h6ZM3,10A1,1,0,0,0,4,9V4H9A1,1,0,0,0,9,2H3A1,1,0,0,0,2,3V9A1,1,0,0,0,3,10ZM9,20H4V15a1,1,0,0,0-2,0v6a1,1,0,0,0,1,1H9a1,1,0,0,0,0-2Z'
  }));
};

UilLockAccess.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLockAccess.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLockAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,13a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V14A1,1,0,0,0,12,13Zm5-4V7A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9ZM9,7a3,3,0,0,1,6,0V9H9Zm9,12a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z'
  }));
};

UilLockAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLockAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLockOpenAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,13a1.49,1.49,0,0,0-1,2.61V17a1,1,0,0,0,2,0V15.61A1.49,1.49,0,0,0,12,13Zm5-4H9V7a3,3,0,0,1,5.12-2.13,3.08,3.08,0,0,1,.78,1.38,1,1,0,1,0,1.94-.5,5.09,5.09,0,0,0-1.31-2.29A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9Zm1,10a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z'
  }));
};

UilLockOpenAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLockOpenAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLockSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.84,5.38a2,2,0,0,1,2.57.21A2,2,0,0,1,14,7v3a1,1,0,0,0,1,1h1a1,1,0,0,1,1,1v.34a1,1,0,0,0,2,0V12a3,3,0,0,0-3-3V7a4,4,0,0,0-1.17-2.83,4.06,4.06,0,0,0-5.19-.39,1,1,0,1,0,1.2,1.6ZM21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71L7.62,9A3,3,0,0,0,5,12v6a3,3,0,0,0,3,3h8a3,3,0,0,0,2.39-1.2l1.9,1.91a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM16,19H8a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H9.59l2.07,2.07A1,1,0,0,0,11,14v2a1,1,0,0,0,2,0V14.41l3.93,3.93A1,1,0,0,1,16,19Z'
  }));
};

UilLockSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLockSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilLuggageCart = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M2,13.5v2a1,1,0,0,0,1,1H13a3,3,0,0,0,6,0h2a1,1,0,0,0,1-1v-8a3,3,0,0,0-3-3H9a3,3,0,0,0-3,3v7H4v-1a1,1,0,0,0-2,0Zm13,3a1,1,0,1,1,1,1A1,1,0,0,1,15,16.5Zm-7-6H20v4H18.22a3,3,0,0,0-4.44,0H8Zm0-3a1,1,0,0,1,1-1H19a1,1,0,0,1,1,1v1H8Z'
  }));
};

UilLuggageCart.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilLuggageCart.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMailbox = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8,12h2a1,1,0,0,0,0-2H8a1,1,0,0,0,0,2Zm9-6H12V4h1a1,1,0,0,0,0-2H11a1,1,0,0,0-1,1V6H7a4,4,0,0,0-4,4v6a1,1,0,0,0,1,1h6v4a1,1,0,0,0,2,0V17h8a1,1,0,0,0,1-1V10A4,4,0,0,0,17,6Zm-4,4v5H5V10A2,2,0,0,1,7,8h6.56A3.91,3.91,0,0,0,13,10Zm6,5H15V10a2,2,0,0,1,4,0Z'
  }));
};

UilMailbox.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMailbox.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMailboxAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,13h2a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm8,7H18V9h1a1,1,0,0,0,0-2H17.91A6,6,0,0,0,6.09,7H5A1,1,0,0,0,5,9H6V20H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2ZM12,4a4,4,0,0,1,3.86,3H8.14A4,4,0,0,1,12,4Zm4,16H8V18h8Zm0-4H8V9h8Z'
  }));
};

UilMailboxAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMailboxAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMap = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.32,5.05l-6-2h-.07a.7.7,0,0,0-.14,0h-.23l-.13,0h-.07L9,5,3.32,3.05a1,1,0,0,0-.9.14A1,1,0,0,0,2,4V18a1,1,0,0,0,.68.95l6,2h0a1,1,0,0,0,.62,0h0L15,19.05,20.68,21A1.19,1.19,0,0,0,21,21a.94.94,0,0,0,.58-.19A1,1,0,0,0,22,20V6A1,1,0,0,0,21.32,5.05ZM8,18.61,4,17.28V5.39L8,6.72Zm6-1.33-4,1.33V6.72l4-1.33Zm6,1.33-4-1.33V5.39l4,1.33Z'
  }));
};

UilMap.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMap.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarker = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2a8,8,0,0,0-8,8c0,5.4,7.05,11.5,7.35,11.76a1,1,0,0,0,1.3,0C13,21.5,20,15.4,20,10A8,8,0,0,0,12,2Zm0,17.65c-2.13-2-6-6.31-6-9.65a6,6,0,0,1,12,0C18,13.34,14.13,17.66,12,19.65ZM12,6a4,4,0,1,0,4,4A4,4,0,0,0,12,6Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,12Z'
  }));
};

UilMapMarker.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarker.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.46,9.63A8.5,8.5,0,0,0,7.3,3.36,8.56,8.56,0,0,0,3.54,9.63,8.46,8.46,0,0,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05ZM12,6a4.5,4.5,0,1,0,4.5,4.5A4.51,4.51,0,0,0,12,6Zm0,7a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,12,13Z'
  }));
};

UilMapMarkerAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.46,9.63A8.5,8.5,0,1,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05Zm-2.81-8.8a1,1,0,0,0-1.42,0L8.79,9.83a1,1,0,0,0-.29.7V13a1,1,0,0,0,1,1h2.42a1,1,0,0,0,.71-.29l3.58-3.58a1,1,0,0,0,0-1.41ZM11.51,12h-1V11l2.58-2.58,1,1Z'
  }));
};

UilMapMarkerEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerInfo = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,10a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V11A1,1,0,0,0,12,10Zm8.46-.32A8.5,8.5,0,0,0,7.3,3.36,8.56,8.56,0,0,0,3.54,9.63,8.46,8.46,0,0,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05ZM12.92,7.57a.56.56,0,0,0-.09-.17l-.12-.15A1,1,0,0,0,11.8,7L11.62,7l-.18.09-.15.13-.12.15a.56.56,0,0,0-.09.17.6.6,0,0,0-.06.19A1.23,1.23,0,0,0,11,8a.88.88,0,0,0,.08.39,1.11,1.11,0,0,0,.21.32,1.06,1.06,0,0,0,.33.22,1.07,1.07,0,0,0,.76,0,1.19,1.19,0,0,0,.33-.22,1.11,1.11,0,0,0,.21-.32A1,1,0,0,0,13,8a1.23,1.23,0,0,0,0-.19A.6.6,0,0,0,12.92,7.57Z'
  }));
};

UilMapMarkerInfo.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerInfo.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,9.45H10a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm6.46.18A8.5,8.5,0,1,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05Z'
  }));
};

UilMapMarkerMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14,9.45H13v-1a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h1a1,1,0,0,0,0-2Zm6.46.18A8.5,8.5,0,1,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05Z'
  }));
};

UilMapMarkerPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerQuestion = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.44,13.11,12.27,13a1,1,0,0,0-1.09.22.87.87,0,0,0-.22.32,1,1,0,0,0-.08.39,1,1,0,0,0,.08.38,1.07,1.07,0,0,0,.54.54,1,1,0,0,0,.38.08,1.09,1.09,0,0,0,.39-.08,1,1,0,0,0,.32-.22,1,1,0,0,0,0-1.41ZM11.88,6A2.75,2.75,0,0,0,9.5,7.32a1,1,0,1,0,1.73,1A.77.77,0,0,1,11.88,8a.75.75,0,1,1,0,1.5,1,1,0,1,0,0,2,2.75,2.75,0,1,0,0-5.5Zm8.58,3.68A8.5,8.5,0,0,0,7.3,3.36,8.56,8.56,0,0,0,3.54,9.63,8.46,8.46,0,0,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05Z'
  }));
};

UilMapMarkerQuestion.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerQuestion.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerShield = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M14.41,6.53a2.24,2.24,0,0,1-1.82-.39,1,1,0,0,0-1.18,0,2.24,2.24,0,0,1-1.82.39,1,1,0,0,0-.84.2,1,1,0,0,0-.37.78v2.9A4.14,4.14,0,0,0,10,13.74l1.37,1a1,1,0,0,0,1.18,0l1.37-1a4.14,4.14,0,0,0,1.66-3.33V7.51a1,1,0,0,0-.37-.78A1,1,0,0,0,14.41,6.53Zm-.79,3.88a2.15,2.15,0,0,1-.85,1.73l-.77.57-.77-.57a2.15,2.15,0,0,1-.85-1.73V8.57A4.22,4.22,0,0,0,12,8.12a4.22,4.22,0,0,0,1.62.45Zm6.84-.78A8.5,8.5,0,0,0,7.3,3.36,8.56,8.56,0,0,0,3.54,9.63,8.46,8.46,0,0,0,6,16.46l5.3,5.31a1,1,0,0,0,1.42,0L18,16.46A8.46,8.46,0,0,0,20.46,9.63ZM16.6,15.05,12,19.65l-4.6-4.6A6.49,6.49,0,0,1,5.53,9.83,6.57,6.57,0,0,1,8.42,5a6.47,6.47,0,0,1,7.16,0,6.57,6.57,0,0,1,2.89,4.81A6.49,6.49,0,0,1,16.6,15.05Z'
  }));
};

UilMapMarkerShield.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerShield.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapMarkerSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.63,5.49a6,6,0,0,1,7.21,7.2,1,1,0,0,0,.74,1.21.9.9,0,0,0,.23,0,1,1,0,0,0,1-.76,8,8,0,0,0-9.61-9.62,1,1,0,0,0,.46,2ZM21.71,20.07,17.44,15.8h0L3.71,2.07a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41L5.5,6.69A8,8,0,0,0,6.34,17l4.95,4.95a1,1,0,0,0,1.42,0l4-4,3.56,3.56a1,1,0,0,0,1.42-1.41Zm-9.59-6.76a2,2,0,0,1-1.53-.57A2,2,0,0,1,10,11.21ZM12,19.81,7.76,15.57a6,6,0,0,1-.82-7.44L8.41,9.6a4,4,0,0,0,.76,4.55A4,4,0,0,0,12,15.33a3.93,3.93,0,0,0,1.73-.41l1.58,1.58Z'
  }));
};

UilMapMarkerSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapMarkerSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapPin = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16.37,12.79a1,1,0,0,0-.74,1.86C17.09,15.23,18,16.13,18,17c0,1.42-2.46,3-6,3s-6-1.58-6-3c0-.87.91-1.77,2.37-2.35a1,1,0,0,0-.74-1.86C5.36,13.69,4,15.26,4,17c0,2.8,3.51,5,8,5s8-2.2,8-5C20,15.26,18.64,13.69,16.37,12.79ZM11,9.86V17a1,1,0,0,0,2,0V9.86a4,4,0,1,0-2,0ZM12,4a2,2,0,1,1-2,2A2,2,0,0,1,12,4Z'
  }));
};

UilMapPin.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapPin.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMapPinAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,11.9V17a1,1,0,0,0,2,0V11.9a5,5,0,1,0-2,0ZM12,4A3,3,0,1,1,9,7,3,3,0,0,1,12,4Zm4.21,10.42a1,1,0,1,0-.42,2C18.06,16.87,19,17.68,19,18c0,.58-2.45,2-7,2s-7-1.42-7-2c0-.32.94-1.13,3.21-1.62a1,1,0,1,0-.42-2C4.75,15.08,3,16.39,3,18c0,2.63,4.53,4,9,4s9-1.37,9-4C21,16.39,19.25,15.08,16.21,14.42Z'
  }));
};

UilMapPinAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMapPinAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMars = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.42,4.12a1,1,0,0,0-.54-.54,1,1,0,0,0-.38-.08h-4a1,1,0,0,0,0,2h1.59l-2.4,2.4A7,7,0,1,0,16.1,9.31l2.4-2.4V8.5a1,1,0,0,0,2,0v-4A1,1,0,0,0,20.42,4.12ZM14,17A5,5,0,1,1,14,10h0A5,5,0,0,1,14,17Z'
  }));
};

UilMars.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMars.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMasterCard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M15.26465,5.27441a6.68141,6.68141,0,0,0-3.27295.85505,6.72754,6.72754,0,1,0,0,11.745,6.72551,6.72551,0,1,0,3.27295-12.6ZM10.23712,16.457a4.66714,4.66714,0,0,1-1.51837.27252,4.72754,4.72754,0,0,1,0-9.45508,4.66688,4.66688,0,0,1,1.51837.27253,6.68737,6.68737,0,0,0,0,8.91ZM11.9917,15.3996a4.69542,4.69542,0,0,1,0-6.79529,4.69542,4.69542,0,0,1,0,6.79529Zm3.27295,1.32989a4.66709,4.66709,0,0,1-1.51837-.27252,6.68737,6.68737,0,0,0,0-8.91,4.66683,4.66683,0,0,1,1.51837-.27253,4.72754,4.72754,0,0,1,0,9.45508Z'
  }));
};

UilMasterCard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMasterCard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMaximizeLeft = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M5.41,4H7A1,1,0,0,0,7,2H3a1,1,0,0,0-.38.08,1,1,0,0,0-.54.54A1,1,0,0,0,2,3V7A1,1,0,0,0,4,7V5.41l5.79,5.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM21,16a1,1,0,0,0-1,1v1.59l-5.79-5.8a1,1,0,0,0-1.42,1.42L18.59,20H17a1,1,0,0,0,0,2h4a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V17A1,1,0,0,0,21,16Z'
  }));
};

UilMaximizeLeft.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMaximizeLeft.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMedal = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.38,5.76a1,1,0,0,0-.47-.61l-5.2-3a1,1,0,0,0-1.37.36L12,6.57,9.66,2.51a1,1,0,0,0-1.37-.36l-5.2,3a1,1,0,0,0-.47.61,1,1,0,0,0,.1.75l4,6.83A5.91,5.91,0,0,0,6,16a6,6,0,1,0,11.34-2.72l3.9-6.76A1,1,0,0,0,21.38,5.76ZM5,6.38l3.46-2L11.68,10A5.94,5.94,0,0,0,8,11.58ZM12,20a4,4,0,0,1-4-4,4,4,0,0,1,4-4,4,4,0,1,1,0,8Zm4-8.45a5.9,5.9,0,0,0-1.86-1.15L13.16,8.57l2.42-4.19,3.46,2Z'
  }));
};

UilMedal.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMedal.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMedicalDrip = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,6H15V4h2a1,1,0,0,0,0-2H9A5,5,0,0,0,4,7V21a1,1,0,0,0,2,0V7A3,3,0,0,1,9,4h4V6H11A3,3,0,0,0,8,9v4.93a3,3,0,0,0,1.34,2.5L11,17.54V18a2,2,0,0,0,2,2v1a1,1,0,0,0,2,0V20a2,2,0,0,0,2-2v-.46l1.66-1.11A3,3,0,0,0,20,13.93V9A3,3,0,0,0,17,6Zm-1,5h2v1H17a1,1,0,0,0,0,2h1a1,1,0,0,1-.44.76l-2.1,1.41A1,1,0,0,0,15,17v1H13V17a1,1,0,0,0-.45-.83l-2.1-1.41a1,1,0,0,1-.45-.83V9a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1H16a1,1,0,0,0,0,2Z'
  }));
};

UilMedicalDrip.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMedicalDrip.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMedicalSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1ZM17,9H15V7a1,1,0,0,0-1-1H10A1,1,0,0,0,9,7V9H7a1,1,0,0,0-1,1v4a1,1,0,0,0,1,1H9v2a1,1,0,0,0,1,1h4a1,1,0,0,0,1-1V15h2a1,1,0,0,0,1-1V10A1,1,0,0,0,17,9Zm-1,4H14a1,1,0,0,0-1,1v2H11V14a1,1,0,0,0-1-1H8V11h2a1,1,0,0,0,1-1V8h2v2a1,1,0,0,0,1,1h2Z'
  }));
};

UilMedicalSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMedicalSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMedicalSquareFull = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,20H4V4H20ZM7,14.79H9v2a1,1,0,0,0,1,1h4a1,1,0,0,0,1-1v-2h2a1,1,0,0,0,1-1v-4a1,1,0,0,0-1-1H15v-2a1,1,0,0,0-1-1H10a1,1,0,0,0-1,1v2H7a1,1,0,0,0-1,1v4A1,1,0,0,0,7,14.79Zm1-4h2a1,1,0,0,0,1-1v-2h2v2a1,1,0,0,0,1,1h2v2H14a1,1,0,0,0-1,1v2H11v-2a1,1,0,0,0-1-1H8Z'
  }));
};

UilMedicalSquareFull.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMedicalSquareFull.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMediumM = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.20905,6.41669H22V4.08331H14.51978l-2.48584,9.16663h-.068L9.50269,4.08331H2V6.41663h.76837A.89578.89578,0,0,1,3.5,7.11139v9.83032a.84093.84093,0,0,1-.73163.6416H2v2.33338H8V17.58331H6.5V7.25h.08752L10.0451,19.91669h2.712L16.25989,7.25h.07355V17.58331H14.83337v2.33338H22V17.58331h-.79095a.83931.83931,0,0,1-.70905-.6416V7.11145A.8976.8976,0,0,1,21.20905,6.41669Z'
  }));
};

UilMediumM.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMediumM.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMedkit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,17h1v1a1,1,0,0,0,2,0V17h1a1,1,0,0,0,0-2H13V14a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2ZM19,6H17V5a3,3,0,0,0-3-3H10A3,3,0,0,0,7,5V6H5A3,3,0,0,0,2,9V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V9A3,3,0,0,0,19,6ZM9,5a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1V6H9ZM20,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V12H20Zm0-9H4V9A1,1,0,0,1,5,8H19a1,1,0,0,1,1,1Z'
  }));
};

UilMedkit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMedkit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMeetingBoard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,10H9A1,1,0,0,0,9,8H7a1,1,0,0,0,0,2ZM21,4H13V3a1,1,0,0,0-2,0V4H3A1,1,0,0,0,2,5V15a3,3,0,0,0,3,3H9.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L11,19.41V21a1,1,0,0,0,2,0V19.41l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L14.41,18H19a3,3,0,0,0,3-3V5A1,1,0,0,0,21,4ZM20,15a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V6H20ZM7,14h6a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2Z'
  }));
};

UilMeetingBoard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMeetingBoard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMegaphone = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.99121,2.002a.99943.99943,0,0,0-1,1v.63672a9.03617,9.03617,0,0,1-7,3.36328h-6a3.00328,3.00328,0,0,0-3,3v2a3.00328,3.00328,0,0,0,3,3H6.475L4.07227,20.6084A.99931.99931,0,0,0,4.99121,22.002h4a.99857.99857,0,0,0,.91895-.60644L12.63391,15.04a9.02805,9.02805,0,0,1,6.3573,3.32507V19.002a1,1,0,0,0,2,0v-16A.99942.99942,0,0,0,19.99121,2.002Zm-14,11a1.00067,1.00067,0,0,1-1-1v-2a1.00068,1.00068,0,0,1,1-1h1v4Zm2.34082,7H6.50781l2.14258-5h1.82422ZM18.99121,15.5238a11.052,11.052,0,0,0-7-2.52185h-3v-4h3a11.05281,11.05281,0,0,0,7-2.52234Z'
  }));
};

UilMegaphone.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMegaphone.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMeh = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,11a1,1,0,1,0-1-1A1,1,0,0,0,9,11Zm6,3H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0-5a1,1,0,1,0,1,1A1,1,0,0,0,15,9ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilMeh.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMeh.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMehAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,11h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm6,3H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0-5H14a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilMehAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMehAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMehClosedEye = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.21,10.54a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41,3.08,3.08,0,0,0-4.24,0,1,1,0,1,0,1.41,1.41A1,1,0,0,1,9.21,10.54ZM15,14H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm2.62-4.87a3.08,3.08,0,0,0-4.24,0,1,1,0,0,0,1.41,1.41,1,1,0,0,1,1.42,0,1,1,0,0,0,1.41,0A1,1,0,0,0,17.62,9.13ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilMehClosedEye.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMehClosedEye.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMessage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.34,9.32l-14-7a3,3,0,0,0-4.08,3.9l2.4,5.37h0a1.06,1.06,0,0,1,0,.82l-2.4,5.37A3,3,0,0,0,5,22a3.14,3.14,0,0,0,1.35-.32l14-7a3,3,0,0,0,0-5.36Zm-.89,3.57-14,7a1,1,0,0,1-1.35-1.3l2.39-5.37A2,2,0,0,0,6.57,13h6.89a1,1,0,0,0,0-2H6.57a2,2,0,0,0-.08-.22L4.1,5.41a1,1,0,0,1,1.35-1.3l14,7a1,1,0,0,1,0,1.78Z'
  }));
};

UilMessage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMessage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMetro = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.71,14.29a1.00157,1.00157,0,0,0-1.08984-.21.90087.90087,0,0,0-.54.54,1.00008,1.00008,0,1,0,1.83984,0A1.14718,1.14718,0,0,0,8.71,14.29Zm8,0a1.04669,1.04669,0,0,0-1.41992,0,1.14718,1.14718,0,0,0-.21.33008A.98919.98919,0,0,0,15.29,15.71a1.14718,1.14718,0,0,0,.33008.21.94107.94107,0,0,0,.75976,0,1.16044,1.16044,0,0,0,.33008-.21.98919.98919,0,0,0,.21-1.08984A1.14718,1.14718,0,0,0,16.71,14.29Zm2.59943,4.60528a4.97014,4.97014,0,0,0,1.78436-4.8172l-1.5-8A5.00038,5.00038,0,0,0,14.68066,2H9.31934A5.00038,5.00038,0,0,0,4.40625,6.07812l-1.5,8a4.97014,4.97014,0,0,0,1.78436,4.8172L3.293,20.293A.99989.99989,0,1,0,4.707,21.707l1.86914-1.86914A5.00576,5.00576,0,0,0,7.81934,20h8.36132a5.00576,5.00576,0,0,0,1.24317-.16211L19.293,21.707A.99989.99989,0,0,0,20.707,20.293ZM6.37109,6.44727A3.0021,3.0021,0,0,1,9.31934,4h5.36132a3.0021,3.0021,0,0,1,2.94825,2.44727l.34668,1.84893a7.95514,7.95514,0,0,1-11.95118,0ZM18.48828,16.916A2.9899,2.9899,0,0,1,16.18066,18H7.81934a3.00057,3.00057,0,0,1-2.94825-3.55273l.71106-3.79236a9.95447,9.95447,0,0,0,12.8357,0l.71106,3.79236A2.99028,2.99028,0,0,1,18.48828,16.916Z'
  }));
};

UilMetro.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMetro.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMicrophone = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,15a4,4,0,0,0,4-4V5A4,4,0,0,0,8,5v6A4,4,0,0,0,12,15ZM10,5a2,2,0,0,1,4,0v6a2,2,0,0,1-4,0Zm10,6a1,1,0,0,0-2,0A6,6,0,0,1,6,11a1,1,0,0,0-2,0,8,8,0,0,0,7,7.93V21H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2H13V18.93A8,8,0,0,0,20,11Z'
  }));
};

UilMicrophone.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMicrophone.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMicrophoneSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.5,3.73a2,2,0,0,1,2.95-.14A2,2,0,0,1,14,5V8.41a1,1,0,0,0,2,0V5A4,4,0,0,0,9,2.47,1,1,0,1,0,10.5,3.73Zm8.22,9.54.2,0a1,1,0,0,0,1-.81A7.91,7.91,0,0,0,20,11a1,1,0,0,0-2,0,5.54,5.54,0,0,1-.11,1.1A1,1,0,0,0,18.72,13.27Zm3,6.06-18-18a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41L8,8.48V11a4,4,0,0,0,6,3.46l1.46,1.46A6,6,0,0,1,6,11a1,1,0,0,0-2,0,8,8,0,0,0,7,7.93V21H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2H13V18.93a7.87,7.87,0,0,0,3.85-1.59l3.4,3.4a1,1,0,0,0,1.42-1.41ZM12,13a2,2,0,0,1-2-2v-.52l2.45,2.46A1.74,1.74,0,0,1,12,13Z'
  }));
};

UilMicrophoneSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMicrophoneSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMicroscope = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,21.00537H14.81573a2.96355,2.96355,0,0,0,.143-.59173A8.04382,8.04382,0,0,0,20,13.00537a7.94487,7.94487,0,0,0-2.12744-5.42248l.63721-.63758a.99138.99138,0,0,0,.24121-.39062l.708-2.12207a.9997.9997,0,0,0-.24121-1.02344L17.0957,1.2876a.99874.99874,0,0,0-1.02343-.2417l-2.1211.70752a.99655.99655,0,0,0-.39062.2417L7.19824,8.35791a.9995.9995,0,0,0-.00006,1.41394L5.78223,11.1875a.99963.99963,0,0,0,0,1.41406l2.12207,2.1211a.99965.99965,0,0,0,1.41406,0l1.41406-1.41407.002.002a.99963.99963,0,0,0,1.41406,0l4.30945-4.31208A5.95544,5.95544,0,0,1,18,13.00537a6.048,6.048,0,0,1-3.45483,5.43085,2.97642,2.97642,0,0,0-5.12458.063,6.822,6.822,0,0,1-1.119-.55469A.98851.98851,0,0,0,9,17.00537a.99974.99974,0,0,0-1-1H4a1,1,0,0,0,0,2H5.33142A8.81386,8.81386,0,0,0,9.04779,20.478a2.95521,2.95521,0,0,0,.13654.5274H4a1,1,0,0,0,0,2H20a1,1,0,0,0,0-2ZM8.61133,12.60156l-.708-.707.708-.70752.707.70752Zm8.31738-6.90332L11.44141,11.189l-2.12207-2.124,5.48828-5.48877,1.31152-.4375,1.24707,1.24756ZM12,21.00537a1,1,0,1,1,1-1A1.001,1.001,0,0,1,12,21.00537Z'
  }));
};

UilMicroscope.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMicroscope.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,11H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2Z'
  }));
};

UilMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMinusCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Zm4-9H8a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Z'
  }));
};

UilMinusCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMinusCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMinusPath = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.18,4h2.1a1,1,0,0,0,0-2H8.18a1,1,0,0,0,0,2ZM3,11.28a1,1,0,0,0,1-1V8.18a1,1,0,0,0-2,0v2.1A1,1,0,0,0,3,11.28ZM14.46,4a1,1,0,0,0,2,0V3a1,1,0,0,0-1-1h-1a1,1,0,0,0,0,2ZM21,7.54H16.46a1,1,0,1,0-2,0H8.54a1,1,0,0,0-1,1v5.92a1,1,0,1,0,0,2V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V8.54A1,1,0,0,0,21,7.54ZM20,20H9.54V15.47h0V9.54H20ZM4,2H3A1,1,0,0,0,2,3V4A1,1,0,0,0,4,4,1,1,0,0,0,4,2ZM4,14.46a1,1,0,0,0-2,0v1a1,1,0,0,0,1,1H4a1,1,0,0,0,0-2Z'
  }));
};

UilMinusPath.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMinusPath.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMinusSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Zm-4-8H8a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Z'
  }));
};

UilMinusSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMinusSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMinusSquareFull = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,13h6a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2ZM21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,20H4V4H20Z'
  }));
};

UilMinusSquareFull.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMinusSquareFull.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMissedCall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6,7.49a1,1,0,0,0,1-1V5.9L9.88,8.78a3,3,0,0,0,4.24,0l4.59-4.59a1,1,0,0,0,0-1.41,1,1,0,0,0-1.42,0L12.71,7.36a1,1,0,0,1-1.42,0L8.41,4.49H9a1,1,0,0,0,0-2H6a1,1,0,0,0-.92.61A1.09,1.09,0,0,0,5,3.49v3A1,1,0,0,0,6,7.49Zm15.94,7.36a16.27,16.27,0,0,0-19.88,0,2.69,2.69,0,0,0-1,2,2.66,2.66,0,0,0,.78,2.07L3.6,20.72A2.68,2.68,0,0,0,7.06,21l.47-.32a8.13,8.13,0,0,1,1-.55,1.85,1.85,0,0,0,1-2.3l-.09-.24a10.49,10.49,0,0,1,5.22,0l-.09.24a1.85,1.85,0,0,0,1,2.3,8.13,8.13,0,0,1,1,.55l.47.32a2.58,2.58,0,0,0,1.54.5,2.72,2.72,0,0,0,1.92-.79l1.81-1.82A2.66,2.66,0,0,0,23,16.83,2.69,2.69,0,0,0,21.94,14.85ZM20.8,17.49,19,19.3a.68.68,0,0,1-.86.1c-.19-.14-.38-.27-.59-.4a11.65,11.65,0,0,0-1.09-.61l.4-1.09a1,1,0,0,0-.6-1.28,12.42,12.42,0,0,0-8.5,0,1,1,0,0,0-.6,1.28l.4,1.1a9.8,9.8,0,0,0-1.1.6l-.58.4A.66.66,0,0,1,5,19.3L3.2,17.49A.67.67,0,0,1,3,17a.76.76,0,0,1,.28-.53,14.29,14.29,0,0,1,17.44,0A.76.76,0,0,1,21,17,.67.67,0,0,1,20.8,17.49Z'
  }));
};

UilMissedCall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMissedCall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMobileAndroid = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12.71,16.29l-.15-.12a.76.76,0,0,0-.18-.09L12.2,16a1,1,0,0,0-.91.27,1.15,1.15,0,0,0-.21.33,1,1,0,0,0,1.3,1.31,1.46,1.46,0,0,0,.33-.22,1,1,0,0,0,.21-1.09A1,1,0,0,0,12.71,16.29ZM16,2H8A3,3,0,0,0,5,5V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V5A3,3,0,0,0,16,2Zm1,17a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V5A1,1,0,0,1,8,4h8a1,1,0,0,1,1,1Z'
  }));
};

UilMobileAndroid.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMobileAndroid.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMobileAndroidAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,2H8A3,3,0,0,0,5,5V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V5A3,3,0,0,0,16,2Zm1,17a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V18H17Zm0-3H7V5A1,1,0,0,1,8,4h8a1,1,0,0,1,1,1Z'
  }));
};

UilMobileAndroidAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMobileAndroidAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMobileVibrate = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.88,14.12,9.73,14l-.18-.1-.18-.05a1,1,0,0,0-.9.27.83.83,0,0,0-.22.33.94.94,0,0,0,0,.76,1.07,1.07,0,0,0,.54.54,1,1,0,0,0,.38.08,1.09,1.09,0,0,0,.39-.08.87.87,0,0,0,.32-.22,1,1,0,0,0,.22-.32,1,1,0,0,0,.07-.38.84.84,0,0,0-.08-.38A.93.93,0,0,0,9.88,14.12ZM3.51,8.76a1,1,0,0,0,.71-.3L8.46,4.22a1,1,0,0,0,0-1.41,1,1,0,0,0-1.41,0L2.81,7.05a1,1,0,0,0,0,1.41A1,1,0,0,0,3.51,8.76Zm17.68,6.78a1,1,0,0,0-1.41,0l-4.24,4.24a1,1,0,0,0,.7,1.71,1,1,0,0,0,.71-.3L21.19,17A1,1,0,0,0,21.19,15.54Zm.17-5.66a3,3,0,0,0-.87-2.12L16.24,3.51a3.08,3.08,0,0,0-4.24,0L3.51,12a3,3,0,0,0,0,4.24l4.25,4.25h0a3,3,0,0,0,4.24,0L20.49,12A3,3,0,0,0,21.36,9.88Zm-2.29.71-8.48,8.48a1,1,0,0,1-1.42,0h0L4.93,14.83a1,1,0,0,1,0-1.42l8.48-8.48a1,1,0,0,1,1.42,0l4.24,4.24a1,1,0,0,1,0,1.42Z'
  }));
};

UilMobileVibrate.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMobileVibrate.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilModem = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.48,13.13a.65.65,0,0,0-.05-.2.89.89,0,0,0-.08-.17.86.86,0,0,0-.1-.16l-.16-.13L21,12.38,6.28,3.88a1,1,0,0,0-1,1.74l11.49,6.63H3.5a1,1,0,0,0-1,1v4a3,3,0,0,0,3,3h13a3,3,0,0,0,3-3v-4S21.48,13.17,21.48,13.13Zm-2,4.12a1,1,0,0,1-1,1H5.5a1,1,0,0,1-1-1v-3h15Zm-3,0a1,1,0,1,0-1-1A1,1,0,0,0,16.5,17.25Z'
  }));
};

UilModem.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilModem.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyBill = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6,11a1,1,0,1,0,1,1A1,1,0,0,0,6,11Zm12,0a1,1,0,1,0,1,1A1,1,0,0,0,18,11Zm2-6H4A3,3,0,0,0,1,8v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V8A3,3,0,0,0,20,5Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V8A1,1,0,0,1,4,7H20a1,1,0,0,1,1,1ZM12,9a3,3,0,1,0,3,3A3,3,0,0,0,12,9Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,13Z'
  }));
};

UilMoneyBill.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyBill.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyBillSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M6,11a1,1,0,1,0,1,1A1,1,0,0,0,6,11Zm5.86-1.55h0L4.71,2.29A1,1,0,0,0,3.29,3.71L4.59,5H4A3,3,0,0,0,1,8v8a3,3,0,0,0,3,3H18.59l2.7,2.71a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm-.74,2.09,1.34,1.34A1,1,0,0,1,12,13a1,1,0,0,1-1-1A1,1,0,0,1,11.12,11.54ZM4,17a1,1,0,0,1-1-1V8A1,1,0,0,1,4,7H6.59l3.1,3.1A3,3,0,0,0,9,12a3,3,0,0,0,3,3,3,3,0,0,0,1.9-.69L16.59,17ZM20,5H12.66a1,1,0,0,0,0,2H20a1,1,0,0,1,1,1v7.34a1,1,0,1,0,2,0V8A3,3,0,0,0,20,5Zm-1,7a1,1,0,1,0-1,1A1,1,0,0,0,19,12Z'
  }));
};

UilMoneyBillSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyBillSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyBillStack = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,1H4A3,3,0,0,0,1,4V20a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V4A3,3,0,0,0,20,1ZM8,21H4a1,1,0,0,1-1-1V18.82A3,3,0,0,0,4,19H8Zm0-4H4a1,1,0,0,1-1-1V14.82A3,3,0,0,0,4,15H8Zm0-4H4a1,1,0,0,1-1-1V4A1,1,0,0,1,4,3H8Zm6,8H10V15h4Zm0-8H10V3h4Zm7,7a1,1,0,0,1-1,1H16V19h4a3,3,0,0,0,1-.18Zm0-4a1,1,0,0,1-1,1H16V15h4a3,3,0,0,0,1-.18Zm0-4a1,1,0,0,1-1,1H16V3h4a1,1,0,0,1,1,1ZM18,7a1,1,0,1,0,1,1A1,1,0,0,0,18,7ZM6,9A1,1,0,1,0,5,8,1,1,0,0,0,6,9Z'
  }));
};

UilMoneyBillStack.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyBillStack.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyInsert = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.46,6,11,5.41V9a1,1,0,0,0,2,0V5.41l.54.55A1,1,0,0,0,15,6a1,1,0,0,0,0-1.42L12.71,2.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21L9,4.54A1,1,0,0,0,10.46,6ZM12,12a3,3,0,1,0,3,3A3,3,0,0,0,12,12Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,16ZM5,15a1,1,0,1,0,1-1A1,1,0,0,0,5,15Zm14,0a1,1,0,1,0-1,1A1,1,0,0,0,19,15Zm1-7H16a1,1,0,0,0,0,2h4a1,1,0,0,1,1,1v8a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V11a1,1,0,0,1,1-1H8A1,1,0,0,0,8,8H4a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V11A3,3,0,0,0,20,8Z'
  }));
};

UilMoneyInsert.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyInsert.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyStack = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,17H2a1,1,0,0,0,0,2H22a1,1,0,0,0,0-2Zm0,4H2a1,1,0,0,0,0,2H22a1,1,0,0,0,0-2ZM6,7A1,1,0,1,0,7,8,1,1,0,0,0,6,7ZM20,1H4A3,3,0,0,0,1,4v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V4A3,3,0,0,0,20,1Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V4A1,1,0,0,1,4,3H20a1,1,0,0,1,1,1ZM12,5a3,3,0,1,0,3,3A3,3,0,0,0,12,5Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,9Zm6-2a1,1,0,1,0,1,1A1,1,0,0,0,18,7Z'
  }));
};

UilMoneyStack.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyStack.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyWithdraw = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,12a3,3,0,1,0,3,3A3,3,0,0,0,12,12Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,16Zm-.71-6.29a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21L15,7.46A1,1,0,1,0,13.54,6L13,6.59V3a1,1,0,0,0-2,0V6.59L10.46,6A1,1,0,0,0,9,7.46ZM19,15a1,1,0,1,0-1,1A1,1,0,0,0,19,15Zm1-7H17a1,1,0,0,0,0,2h3a1,1,0,0,1,1,1v8a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V11a1,1,0,0,1,1-1H7A1,1,0,0,0,7,8H4a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V11A3,3,0,0,0,20,8ZM5,15a1,1,0,1,0,1-1A1,1,0,0,0,5,15Z'
  }));
};

UilMoneyWithdraw.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyWithdraw.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneyWithdrawal = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,2H2A1,1,0,0,0,1,3v8a1,1,0,0,0,1,1H5v9a1,1,0,0,0,1,1H18a1,1,0,0,0,1-1V12h3a1,1,0,0,0,1-1V3A1,1,0,0,0,22,2ZM7,20V18a2,2,0,0,1,2,2Zm10,0H15a2,2,0,0,1,2-2Zm0-4a4,4,0,0,0-4,4H11a4,4,0,0,0-4-4V8H17Zm4-6H19V7a1,1,0,0,0-1-1H6A1,1,0,0,0,5,7v3H3V4H21Zm-9,5a3,3,0,1,0-3-3A3,3,0,0,0,12,15Zm0-4a1,1,0,1,1-1,1A1,1,0,0,1,12,11Z'
  }));
};

UilMoneyWithdrawal.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneyWithdrawal.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneybag = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,11a3,3,0,1,0,3,3A3,3,0,0,0,12,11Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,15Zm7-9H16V5a3,3,0,0,0-3-3H11A3,3,0,0,0,8,5V6H5A3,3,0,0,0,2,9V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V9A3,3,0,0,0,19,6ZM10,5a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V6H10ZM4,9A1,1,0,0,1,5,8H6a2,2,0,0,1-2,2ZM5,20a1,1,0,0,1-1-1V18a2,2,0,0,1,2,2Zm15-1a1,1,0,0,1-1,1H18a2,2,0,0,1,2-2Zm0-3a4,4,0,0,0-4,4H8a4,4,0,0,0-4-4V12A4,4,0,0,0,8,8h8a4,4,0,0,0,4,4Zm0-6a2,2,0,0,1-2-2h1a1,1,0,0,1,1,1Z'
  }));
};

UilMoneybag.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneybag.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoneybagAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,7H16V6a3,3,0,0,0-3-3H11A3,3,0,0,0,8,6V7H5a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V10A3,3,0,0,0,19,7ZM10,6a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V7H10ZM4,10A1,1,0,0,1,5,9H6a2,2,0,0,1-2,2Zm1,9a1,1,0,0,1-1-1V17a2,2,0,0,1,2,2Zm15-1a1,1,0,0,1-1,1H18a2,2,0,0,1,2-2Zm0-3a4,4,0,0,0-4,4H8a4,4,0,0,0-4-4V13A4,4,0,0,0,8,9h8a4,4,0,0,0,4,4Zm0-4a2,2,0,0,1-2-2h1a1,1,0,0,1,1,1Zm-8,0a3,3,0,1,0,3,3A3,3,0,0,0,12,11Zm0,4a1,1,0,1,1,1-1A1,1,0,0,1,12,15Z'
  }));
};

UilMoneybagAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoneybagAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMonitor = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H7.64l-.58,1a2,2,0,0,0,0,2,2,2,0,0,0,1.75,1h6.46A2,2,0,0,0,17,21a2,2,0,0,0,0-2l-.59-1H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM8.77,20,10,18H14l1.2,2ZM20,15a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V14H20Zm0-3H4V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilMonitor.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMonitor.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMonitorHeartRate = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,19a1,1,0,0,0,.38-.08,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.12-.16.56.56,0,0,0,.09-.17A.64.64,0,0,0,10,18.2a1.36,1.36,0,0,0,0-.2,1,1,0,0,0-.08-.38.9.9,0,0,0-.54-.54A1,1,0,0,0,8.8,17l-.18.06a.56.56,0,0,0-.17.09,1,1,0,0,0-.16.12,1,1,0,0,0-.21.33A1,1,0,0,0,8,18a1,1,0,0,0,1,1Zm-3.71-.29a1.15,1.15,0,0,0,.33.21A1,1,0,0,0,6,19l.19,0a.6.6,0,0,0,.19-.06.76.76,0,0,0,.18-.09l.15-.12a1.15,1.15,0,0,0,.21-.33A.84.84,0,0,0,7,18a1.36,1.36,0,0,0,0-.2.64.64,0,0,0-.06-.18.56.56,0,0,0-.09-.17,1,1,0,0,0-.12-.16,1,1,0,0,0-1.09-.21,1,1,0,0,0-.33.21,1,1,0,0,0-.12.16.56.56,0,0,0-.09.17A.64.64,0,0,0,5,17.8,1.36,1.36,0,0,0,5,18a1,1,0,0,0,.08.38A1.15,1.15,0,0,0,5.29,18.71ZM19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V16H20Zm0-5H4V10H8a1,1,0,0,0,.71-.29L10,8.46l2.8,3.2a1,1,0,0,0,.72.34h0a1,1,0,0,0,.71-.29L15.91,10H20Zm0-6H15.5a1,1,0,0,0-.71.29L13.55,9.54l-2.8-3.2a1,1,0,0,0-1.46,0L7.59,8H4V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilMonitorHeartRate.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMonitorHeartRate.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.64,13a1,1,0,0,0-1.05-.14,8.05,8.05,0,0,1-3.37.73A8.15,8.15,0,0,1,9.08,5.49a8.59,8.59,0,0,1,.25-2A1,1,0,0,0,8,2.36,10.14,10.14,0,1,0,22,14.05,1,1,0,0,0,21.64,13Zm-9.5,6.69A8.14,8.14,0,0,1,7.08,5.22v.27A10.15,10.15,0,0,0,17.22,15.63a9.79,9.79,0,0,0,2.1-.22A8.11,8.11,0,0,1,12.14,19.73Z'
  }));
};

UilMoon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoonEclipse = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2a10,10,0,0,0-2.14.24l-.12,0a10,10,0,0,0-.1,19.44l.14,0A9.57,9.57,0,0,0,12,22,10,10,0,0,0,12,2ZM10,19.74A8,8,0,0,1,10,4.26a8,8,0,0,1,0,15.48Zm4.53-.16a10,10,0,0,0,0-15.16,8,8,0,0,1,0,15.16Z'
  }));
};

UilMoonEclipse.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoonEclipse.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMoonset = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11,19H8a1,1,0,0,0,0,2h3a1,1,0,0,0,0-2Zm9-4H18.84A8.18,8.18,0,0,0,20,12.05a1,1,0,0,0-.34-.93,1,1,0,0,0-1-.19,6,6,0,0,1-1.92.32,6.06,6.06,0,0,1-6.06-6,6.93,6.93,0,0,1,.1-1,1,1,0,0,0-.35-.92,1,1,0,0,0-1-.18A8.06,8.06,0,0,0,4,10.68,8,8,0,0,0,5.27,15H4a1,1,0,0,0,0,2H20a1,1,0,0,0,0-2Zm-3.72,0H7.83a6,6,0,0,1,.88-9.36,8.06,8.06,0,0,0,8.05,7.61,7,7,0,0,0,.79,0A6.08,6.08,0,0,1,16.28,15ZM16,19H15a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Z'
  }));
};

UilMoonset.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMoonset.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMountains = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.85,17.47l-5-8a1,1,0,0,0-1.7,0l-1,1.63L10.86,5.5a1,1,0,0,0-1.72,0l-7,12A1,1,0,0,0,3,19H21a1,1,0,0,0,.85-1.53ZM10.45,17H4.74L10,8l2.93,5Zm2.35,0L15,13.57h0L16,11.89,19.2,17Z'
  }));
};

UilMountains.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMountains.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMountainsSun = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,10a4,4,0,1,0-4-4A4,4,0,0,0,18,10Zm0-6a2,2,0,1,1-2,2A2,2,0,0,1,18,4Zm-1.15,8.47a1,1,0,0,0-1.7,0l-1,1.63L10.86,8.5a1,1,0,0,0-1.72,0l-7,12A1,1,0,0,0,3,22H21a1,1,0,0,0,.85-1.53ZM10.45,20H4.74L10,11l2.94,5-1.25,2Zm2.35,0,1.49-2.37L15,16.57h0L16,14.89,19.2,20Z'
  }));
};

UilMountainsSun.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMountainsSun.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMouse = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A7,7,0,0,0,5,9v6a7,7,0,0,0,14,0V9A7,7,0,0,0,12,2ZM7,9a5,5,0,0,1,4-4.9V10H7Zm10,6A5,5,0,0,1,7,15V12H17Zm0-5H13V4.1A5,5,0,0,1,17,9Z'
  }));
};

UilMouse.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMouse.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMouseAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6a1,1,0,0,0-1,1V9a1,1,0,0,0,2,0V7A1,1,0,0,0,12,6Zm0-4A7,7,0,0,0,5,9v6a7,7,0,0,0,14,0V9A7,7,0,0,0,12,2Zm5,13A5,5,0,0,1,7,15V9A5,5,0,0,1,17,9Z'
  }));
};

UilMouseAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMouseAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMouseAlt2 = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A7,7,0,0,0,5,9v6a7,7,0,0,0,14,0V9A7,7,0,0,0,12,2Zm5,13A5,5,0,0,1,7,15V9a5,5,0,0,1,4-4.9V12a1,1,0,0,0,2,0V4.1A5,5,0,0,1,17,9Z'
  }));
};

UilMouseAlt2.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMouseAlt2.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMultiply = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.41,12l6.3-6.29a1,1,0,1,0-1.42-1.42L12,10.59,5.71,4.29A1,1,0,0,0,4.29,5.71L10.59,12l-6.3,6.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L12,13.41l6.29,6.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z'
  }));
};

UilMultiply.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMultiply.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMusic = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.65,2.24a1,1,0,0,0-.8-.23l-13,2A1,1,0,0,0,7,5V15.35A3.45,3.45,0,0,0,5.5,15,3.5,3.5,0,1,0,9,18.5V10.86L20,9.17v4.18A3.45,3.45,0,0,0,18.5,13,3.5,3.5,0,1,0,22,16.5V3A1,1,0,0,0,21.65,2.24ZM5.5,20A1.5,1.5,0,1,1,7,18.5,1.5,1.5,0,0,1,5.5,20Zm13-2A1.5,1.5,0,1,1,20,16.5,1.5,1.5,0,0,1,18.5,18ZM20,7.14,9,8.83v-3L20,4.17Z'
  }));
};

UilMusic.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMusic.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMusicNote = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.12,2.21A1,1,0,0,0,18.26,2l-8,2A1,1,0,0,0,9.5,5V15.35A3.45,3.45,0,0,0,8,15a3.5,3.5,0,1,0,3.5,3.5V10.78L18.74,9l.07,0L19,8.85l.15-.1a.93.93,0,0,0,.13-.15.78.78,0,0,0,.1-.15.55.55,0,0,0,.06-.18.58.58,0,0,0,0-.19.24.24,0,0,0,0-.08V3A1,1,0,0,0,19.12,2.21ZM8,20a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,8,20ZM17.5,7.22l-6,1.5V5.78l6-1.5Z'
  }));
};

UilMusicNote.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMusicNote.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilMusicTuneSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,7.33a1,1,0,0,0,1-1V5.78l6-1.5V7.22L14.7,8.3a1,1,0,0,0,.24,2l.24,0L20.24,9l.07,0,.19-.09.15-.1a.93.93,0,0,0,.13-.15.78.78,0,0,0,.1-.15.55.55,0,0,0,.06-.18.65.65,0,0,0,0-.19A.24.24,0,0,0,21,8V3a1,1,0,0,0-1.24-1l-8,2A1,1,0,0,0,11,5V6.33A1,1,0,0,0,12,7.33Zm9.71,13-9-9h0l-9-9A1,1,0,0,0,2.29,3.71L11,12.41v2.94A3.45,3.45,0,0,0,9.5,15,3.5,3.5,0,1,0,13,18.5V14.41l7.29,7.3a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM9.5,20A1.5,1.5,0,1,1,11,18.5,1.5,1.5,0,0,1,9.5,20Z'
  }));
};

UilMusicTuneSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilMusicTuneSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNA = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6H18a3,3,0,0,0-3,3v8a1,1,0,0,0,2,0V13h3v4a1,1,0,0,0,2,0V9A3,3,0,0,0,19,6Zm1,5H17V9a1,1,0,0,1,1-1h1a1,1,0,0,1,1,1ZM8,6A1,1,0,0,0,7,7v5.76L3.89,6.55A1,1,0,0,0,2,7V17a1,1,0,0,0,2,0V11.24l3.11,6.21A1,1,0,0,0,8,18a.91.91,0,0,0,.23,0A1,1,0,0,0,9,17V7A1,1,0,0,0,8,6Zm4-2a1,1,0,0,0-1,1V19a1,1,0,0,0,2,0V5A1,1,0,0,0,12,4Z'
  }));
};

UilNA.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNA.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNavigator = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.17,9.23l-14-5.78a3,3,0,0,0-4,3.7L3.71,12,2.13,16.85A3,3,0,0,0,2.94,20a3,3,0,0,0,2,.8,3,3,0,0,0,1.15-.23l14.05-5.78a3,3,0,0,0,0-5.54ZM5.36,18.7a1,1,0,0,1-1.06-.19,1,1,0,0,1-.27-1L5.49,13H19.22ZM5.49,11,4,6.53a1,1,0,0,1,.27-1A1,1,0,0,1,5,5.22a1,1,0,0,1,.39.08L19.22,11Z'
  }));
};

UilNavigator.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNavigator.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNerd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.41,8.65s0,0,0-.06A10,10,0,0,0,2.63,8.53a.85.85,0,0,0-.08.24A9.87,9.87,0,0,0,2,12,10,10,0,1,0,21.41,8.65ZM12,4a8,8,0,0,1,6.92,4h-1.2a3,3,0,0,0-4.62.22A3.17,3.17,0,0,0,12,8a3.17,3.17,0,0,0-1.1.22A3,3,0,0,0,6.28,8H5.08A8,8,0,0,1,12,4Zm4.5,6a1,1,0,1,1-1-1A1,1,0,0,1,16.5,10Zm-7,0a1,1,0,1,1-1-1A1,1,0,0,1,9.5,10ZM12,20a8,8,0,0,1-8-8,8.24,8.24,0,0,1,.26-2H5.5a3,3,0,0,0,6,.18,1,1,0,0,1,1,0,3,3,0,0,0,6-.18h1.24A8.24,8.24,0,0,1,20,12,8,8,0,0,1,12,20Zm2.36-5.77a3.76,3.76,0,0,1-4.72,0,1,1,0,0,0-1.28,1.54,5.68,5.68,0,0,0,7.28,0,1,1,0,1,0-1.28-1.54Z'
  }));
};

UilNerd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNerd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNewspaper = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,11H16a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm0,4H16a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM11,9h6a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2ZM21,3H7A1,1,0,0,0,6,4V7H3A1,1,0,0,0,2,8V18a3,3,0,0,0,3,3H18a4,4,0,0,0,4-4V4A1,1,0,0,0,21,3ZM6,18a1,1,0,0,1-2,0V9H6Zm14-1a2,2,0,0,1-2,2H7.82A3,3,0,0,0,8,18V5H20Zm-9-4h1a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm0,4h1a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Z'
  }));
};

UilNewspaper.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNewspaper.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNinja = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.44,5.34l-.06-.07a10,10,0,0,0-14.76,0l-.06.07A10,10,0,1,0,22,12,9.93,9.93,0,0,0,19.44,5.34ZM12,4a7.87,7.87,0,0,1,3.86,1H8.14A7.87,7.87,0,0,1,12,4ZM5.76,7H18.24a8,8,0,0,1,1.69,4H4.07A8,8,0,0,1,5.76,7ZM12,20a8,8,0,0,1-7.93-7H19.93A8,8,0,0,1,12,20ZM8,8A1,1,0,1,0,9,9,1,1,0,0,0,8,8Zm6,0a1,1,0,1,0,1,1A1,1,0,0,0,14,8Zm-3,9.93a1,1,0,0,0,.49.13,1,1,0,0,0,.87-.51A3,3,0,0,1,15,16a1,1,0,0,0,0-2,5,5,0,0,0-4.37,2.57A1,1,0,0,0,11,17.93Z'
  }));
};

UilNinja.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNinja.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNoEntry = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,20H19.76L15.37,4.2A3,3,0,0,0,12.48,2h-1A3,3,0,0,0,8.63,4.2L4.24,20H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM10.56,4.73a1,1,0,0,1,1-.73h1a1,1,0,0,1,1,.73L14.35,8H9.65ZM9.09,10h5.82L16,14H8ZM6.32,20l1.11-4h9.14l1.11,4Z'
  }));
};

UilNoEntry.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNoEntry.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNotebooks = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,6a1,1,0,0,0-1,1V17a3,3,0,0,1-3,3H7a1,1,0,0,0,0,2H17a5,5,0,0,0,5-5V7A1,1,0,0,0,21,6Zm-3,9V5a3,3,0,0,0-3-3H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H15A3,3,0,0,0,18,15ZM10,4h2V8.86l-.36-.3a1,1,0,0,0-1.28,0l-.36.3ZM4,15V5A1,1,0,0,1,5,4H8v7a1,1,0,0,0,1.65.76L11,10.63l1.35,1.13A1,1,0,0,0,13,12a1.06,1.06,0,0,0,.42-.09A1,1,0,0,0,14,11V4h1a1,1,0,0,1,1,1V15a1,1,0,0,1-1,1H5A1,1,0,0,1,4,15Z'
  }));
};

UilNotebooks.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNotebooks.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilNotes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,14H8a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Zm0-4H10a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm4-6H17V3a1,1,0,0,0-2,0V4H13V3a1,1,0,0,0-2,0V4H9V3A1,1,0,0,0,7,3V4H4A1,1,0,0,0,3,5V19a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V5A1,1,0,0,0,20,4ZM19,19a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V6H7V7A1,1,0,0,0,9,7V6h2V7a1,1,0,0,0,2,0V6h2V7a1,1,0,0,0,2,0V6h2Z'
  }));
};

UilNotes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilNotes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilObjectGroup = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,10H14V8a1,1,0,0,0-1-1H8A1,1,0,0,0,7,8v5a1,1,0,0,0,1,1h2v2a1,1,0,0,0,1,1h5a1,1,0,0,0,1-1V11A1,1,0,0,0,16,10Zm-6,1v1H9V9h3v1H11A1,1,0,0,0,10,11Zm5,4H12V12h3Zm6,3.28V5.72A2,2,0,1,0,18.28,3H5.72A2,2,0,1,0,3,5.72V18.28A2,2,0,1,0,5.72,21H18.28A2,2,0,1,0,21,18.28Zm-2,0a1.91,1.91,0,0,0-.72.72H5.72A1.91,1.91,0,0,0,5,18.28V5.72A1.91,1.91,0,0,0,5.72,5H18.28a1.91,1.91,0,0,0,.72.72Z'
  }));
};

UilObjectGroup.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilObjectGroup.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilObjectUngroup = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,18.28V11.72A2,2,0,1,0,18.28,9H15V5.72A2,2,0,1,0,12.28,3H5.72A2,2,0,1,0,3,5.72v6.56A2,2,0,1,0,5.72,15H9v3.28A2,2,0,1,0,11.72,21h6.56A2,2,0,1,0,21,18.28ZM8,10a2,2,0,0,0,1,1.72V13H5.72A1.91,1.91,0,0,0,5,12.28V5.72A1.91,1.91,0,0,0,5.72,5h6.56a1.91,1.91,0,0,0,.72.72V9H11.72A2,2,0,0,0,8,10Zm5,1v1.28a1.91,1.91,0,0,0-.72.72H11V11.72a1.91,1.91,0,0,0,.72-.72Zm6,7.28a1.91,1.91,0,0,0-.72.72H11.72a1.91,1.91,0,0,0-.72-.72V15h1.28A2,2,0,1,0,15,12.28V11h3.28a1.91,1.91,0,0,0,.72.72Z'
  }));
};

UilObjectUngroup.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilObjectUngroup.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilOctagon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.71,7.57,16.44,2.29A1.05,1.05,0,0,0,15.73,2H8.27a1.05,1.05,0,0,0-.71.29L2.29,7.57a1,1,0,0,0-.29.7v7.46a1,1,0,0,0,.29.7l5.27,5.28a1.05,1.05,0,0,0,.71.29h7.46a1.05,1.05,0,0,0,.71-.29l5.27-5.28a1,1,0,0,0,.29-.7V8.27A1,1,0,0,0,21.71,7.57ZM20,15.31,15.31,20H8.69L4,15.31V8.69L8.69,4h6.62L20,8.69Z'
  }));
};

UilOctagon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilOctagon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilOpera = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.9963,2c-5.462,0-9.278,3.95814-9.278,9.899,0,5.28991,3.7112,10.101,9.28549,10.101,5.56676,0,9.27787-4.81857,9.27787-10.101C21.28168,5.95814,17.45831,2,11.9963,2Zm0,18.38381c-3.39693,0-3.77107-5.01309-3.77107-8.7093V11.5997c0-3.99549.59858-8.23042,3.74864-8.23042s3.786,4.3621,3.786,8.3576C15.75987,15.42311,15.39318,20.38381,11.9963,20.38381Z'
  }));
};

UilOpera.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilOpera.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilOperaAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M11.9707,5.00044c-3.64355,0-3.64355,5.12207-3.64355,6.85742,0,1.95313,0,7.14258,3.66015,7.14258,3.6543,0,3.6543-5.16211,3.6543-7.10547C15.6416,7.31977,14.40625,5.00044,11.9707,5.00044Zm.0166,12c-1.10156,0-1.66015-1.73047-1.66015-5.19531,0-2.19141.28515-4.80469,1.64355-4.80469,1.4541,0,1.6709,3.0664,1.6709,4.89453C13.6416,15.28267,13.085,17.00044,11.9873,17.00044Zm.001-16C5.93652,1.00044,1.71,5.48188,1.71,11.89888c0,5.457,3.84668,11.10156,10.28516,11.10156,6.43359,0,10.27832-5.64453,10.27832-11.10156C22.27344,5.48188,18.044,1.00044,11.98828,1.00044Zm.00684,20c-5.18653,0-8.28516-4.62793-8.28516-9.10156,0-5.32227,3.32715-8.89844,8.27832-8.89844,4.95606,0,8.28516,3.57617,8.28516,8.89844C20.27344,16.37251,17.17676,21.00044,11.99512,21.00044Z'
  }));
};

UilOperaAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilOperaAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilOutgoingCall = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.44,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1.06,1.06,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1ZM21.86,2.68a1,1,0,0,0-.54-.54,1,1,0,0,0-.38-.08h-4a1,1,0,1,0,0,2h1.58l-3.29,3.3a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0l3.3-3.29V7.06a1,1,0,0,0,2,0v-4A1,1,0,0,0,21.86,2.68Z'
  }));
};

UilOutgoingCall.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilOutgoingCall.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPackage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM10,4h4V7.13l-1.45-1a1,1,0,0,0-1.1,0L10,7.13ZM20,19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H8V9a1,1,0,0,0,.53.88,1,1,0,0,0,1-.05L12,8.2l2.45,1.63A1,1,0,0,0,16,9V4h3a1,1,0,0,1,1,1Z'
  }));
};

UilPackage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPackage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPadlock = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,13a1.49,1.49,0,0,0-1,2.61V17a1,1,0,0,0,2,0V15.61A1.49,1.49,0,0,0,12,13Zm5-4V7A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9ZM9,7a3,3,0,0,1,6,0V9H9Zm9,12a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z'
  }));
};

UilPadlock.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPadlock.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPaintTool = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,1H10A3,3,0,0,0,7,4H6A3,3,0,0,0,3,7v3a3,3,0,0,0,3,3h6a1,1,0,0,1,1,1v1a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h2a2,2,0,0,0,2-2V17a2,2,0,0,0-2-2V14a3,3,0,0,0-3-3H6a1,1,0,0,1-1-1V7A1,1,0,0,1,6,6H7a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V4A3,3,0,0,0,18,1ZM15,17v4H13V17ZM19,6a1,1,0,0,1-1,1H10A1,1,0,0,1,9,6V4a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1Z'
  }));
};

UilPaintTool.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPaintTool.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPalette = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.42,15.54a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41A1,1,0,0,0,7.42,15.54Zm0-8.49a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41A1,1,0,0,0,7.42,7.05Zm4.95,10a1,1,0,1,0,1,1A1,1,0,0,0,12.37,17Zm-6-6a1,1,0,1,0,1,1A1,1,0,0,0,6.37,11Zm6-6a1,1,0,1,0,1,1A1,1,0,0,0,12.37,5Zm3.54,2.05a1,1,0,1,0,1.41,0A1,1,0,0,0,15.91,7.05Zm6.3,0a11,11,0,1,0-7.85,15.74,3.87,3.87,0,0,0,2.5-1.65A4.2,4.2,0,0,0,17.47,18a5.65,5.65,0,0,1-.1-1,5,5,0,0,1,3-4.56,3.84,3.84,0,0,0,2.06-2.25A4,4,0,0,0,22.21,7.08Zm-1.7,2.44a1.9,1.9,0,0,1-1,1.09A7,7,0,0,0,15.37,17a7.3,7.3,0,0,0,.14,1.4,2.16,2.16,0,0,1-.31,1.65,1.79,1.79,0,0,1-1.21.8,8.72,8.72,0,0,1-1.62.15,9,9,0,0,1-9-9.28A9.05,9.05,0,0,1,11.85,3h.51a9,9,0,0,1,8.06,5A2,2,0,0,1,20.51,9.52ZM12.37,11a1,1,0,1,0,1,1A1,1,0,0,0,12.37,11Z'
  }));
};

UilPalette.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPalette.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPanelAdd = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18,10H14V3a1,1,0,0,0-1-1H8A1,1,0,0,0,7,3V8H3A1,1,0,0,0,2,9V21a1,1,0,0,0,1,1H18a1,1,0,0,0,1-1V11A1,1,0,0,0,18,10ZM7,20H4V10H7Zm5,0H9V4h3Zm5,0H14V12h3ZM21,4H20V3a1,1,0,0,0-2,0V4H17a1,1,0,0,0,0,2h1V7a1,1,0,0,0,2,0V6h1a1,1,0,0,0,0-2Z'
  }));
};

UilPanelAdd.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPanelAdd.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPanoramaH = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.54,5.16a1,1,0,0,0-1-.07A21.27,21.27,0,0,1,12,6.73,21.27,21.27,0,0,1,3.42,5.09a1,1,0,0,0-1,.07A1,1,0,0,0,2,6V18a1,1,0,0,0,.46.84,1,1,0,0,0,1,.07A21.27,21.27,0,0,1,12,17.27a21.27,21.27,0,0,1,8.58,1.64A1.06,1.06,0,0,0,21,19a1,1,0,0,0,.54-.16A1,1,0,0,0,22,18V6A1,1,0,0,0,21.54,5.16ZM20,16.52a24.77,24.77,0,0,0-8-1.25,24.77,24.77,0,0,0-8,1.25v-9a24.77,24.77,0,0,0,8,1.25,24.77,24.77,0,0,0,8-1.25Z'
  }));
};

UilPanoramaH.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPanoramaH.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPanoramaHAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.46,5.83A1,1,0,0,0,20.7,5l-.11,0A37.49,37.49,0,0,0,3.41,5L3.3,5a1,1,0,0,0-.76.8,35.52,35.52,0,0,0,0,12.34,1,1,0,0,0,.76.8l.11,0A37.62,37.62,0,0,0,12,20a37.62,37.62,0,0,0,8.59-1l.11,0a1,1,0,0,0,.76-.8A35.52,35.52,0,0,0,21.46,5.83ZM19.6,17.17a35.42,35.42,0,0,1-15.2,0,33.2,33.2,0,0,1,0-10.34,35.42,35.42,0,0,1,15.2,0A33.2,33.2,0,0,1,19.6,17.17Z'
  }));
};

UilPanoramaHAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPanoramaHAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPanoramaV = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17.27,12a21.11,21.11,0,0,1,1.64-8.58,1,1,0,0,0-.07-1A1,1,0,0,0,18,2H6a1,1,0,0,0-.84.46,1,1,0,0,0-.07,1A21.11,21.11,0,0,1,6.73,12a21.11,21.11,0,0,1-1.64,8.58,1,1,0,0,0,.07,1A1,1,0,0,0,6,22H18a1,1,0,0,0,.84-.46,1,1,0,0,0,.07-1A21.11,21.11,0,0,1,17.27,12Zm-.75,8h-9a24.77,24.77,0,0,0,1.25-8A24.77,24.77,0,0,0,7.48,4h9a24.77,24.77,0,0,0-1.25,8A24.77,24.77,0,0,0,16.52,20Z'
  }));
};

UilPanoramaV.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPanoramaV.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPaperclip = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.08,12.42,11.9,18.61a4.25,4.25,0,0,1-6-6l8-8a2.57,2.57,0,0,1,3.54,0,2.52,2.52,0,0,1,0,3.54l-6.9,6.89A.75.75,0,1,1,9.42,14l5.13-5.12a1,1,0,0,0-1.42-1.42L8,12.6a2.74,2.74,0,0,0,0,3.89,2.82,2.82,0,0,0,3.89,0l6.89-6.9a4.5,4.5,0,0,0-6.36-6.36l-8,8A6.25,6.25,0,0,0,13.31,20l6.19-6.18a1,1,0,1,0-1.42-1.42Z'
  }));
};

UilPaperclip.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPaperclip.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilParagraph = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,13.5H3a1,1,0,0,0,0,2H13a1,1,0,0,0,0-2Zm8-5H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z'
  }));
};

UilParagraph.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilParagraph.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilParcel = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7,14H9a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2Zm6,2H7a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM14,4V7.29l-1.51-.84a1,1,0,0,0-1,0L10,7.29V4Zm6,15a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H8V9a1,1,0,0,0,.5.86,1,1,0,0,0,1,0L12,8.47l2.51,1.4A1,1,0,0,0,15,10a1,1,0,0,0,1-1V4h3a1,1,0,0,1,1,1Z'
  }));
};

UilParcel.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilParcel.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilParkingCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13,7H10A1,1,0,0,0,9,8v8a1,1,0,0,0,2,0V14h2a3,3,0,0,0,3-3V10A3,3,0,0,0,13,7Zm1,4a1,1,0,0,1-1,1H11V9h2a1,1,0,0,1,1,1ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilParkingCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilParkingCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilParkingSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,6H9A1,1,0,0,0,8,7V17a1,1,0,0,0,2,0V14h2a4,4,0,0,0,0-8Zm0,6H10V8h2a2,2,0,0,1,0,4ZM19,2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z'
  }));
};

UilParkingSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilParkingSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPathfinder = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4,14.46a1,1,0,0,0-2,0v1a1,1,0,0,0,1,1H4a1,1,0,0,0,0-2ZM8.18,4h2.1a1,1,0,0,0,0-2H8.18a1,1,0,0,0,0,2Zm6.28,0a1,1,0,0,0,2,0V3a1,1,0,0,0-1-1h-1a1,1,0,0,0,0,2ZM4,2H3A1,1,0,0,0,2,3V4A1,1,0,0,0,4,4,1,1,0,0,0,4,2ZM3,11.28a1,1,0,0,0,1-1V8.18a1,1,0,0,0-2,0v2.1A1,1,0,0,0,3,11.28ZM15.82,20h-2.1a1,1,0,1,0,0,2h2.1a1,1,0,0,0,0-2ZM21,7.54H20a1,1,0,0,0,0,2,1,1,0,0,0,2,0v-1A1,1,0,0,0,21,7.54Zm0,5.18a1,1,0,0,0-1,1v2.1a1,1,0,0,0,2,0v-2.1A1,1,0,0,0,21,12.72ZM16.46,7.54a1,1,0,1,0-2,0H8.54a1,1,0,0,0-1,1v5.92a1,1,0,1,0,0,2,1,1,0,0,0,2,0h5.92a1,1,0,0,0,1-1V9.54a1,1,0,1,0,0-2Zm-2,6.92H9.54V9.54h4.92ZM21,19a1,1,0,0,0-1,1,1,1,0,0,0,0,2h1a1,1,0,0,0,1-1V20A1,1,0,0,0,21,19ZM9.54,20a1,1,0,0,0-2,0v1a1,1,0,0,0,1,1h1a1,1,0,0,0,0-2Z'
  }));
};

UilPathfinder.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPathfinder.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPathfinderUnite = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,7.54H16.46V3a1,1,0,0,0-1-1H3A1,1,0,0,0,2,3V15.46a1,1,0,0,0,1,1H7.54V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V8.54A1,1,0,0,0,21,7.54ZM20,20H9.54V15.46a1,1,0,0,0-1-1H4V4H14.46V8.54a1,1,0,0,0,1,1H20Z'
  }));
};

UilPathfinderUnite.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPathfinderUnite.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPause = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,2a3,3,0,0,0-3,3V19a3,3,0,0,0,6,0V5A3,3,0,0,0,16,2Zm1,17a1,1,0,0,1-2,0V5a1,1,0,0,1,2,0ZM8,2A3,3,0,0,0,5,5V19a3,3,0,0,0,6,0V5A3,3,0,0,0,8,2ZM9,19a1,1,0,0,1-2,0V5A1,1,0,0,1,9,5Z'
  }));
};

UilPause.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPause.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPauseCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,7A1,1,0,0,0,9,8v8a1,1,0,0,0,2,0V8A1,1,0,0,0,10,7Zm2-5A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM14,7a1,1,0,0,0-1,1v8a1,1,0,0,0,2,0V8A1,1,0,0,0,14,7Z'
  }));
};

UilPauseCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPauseCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPaypal = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20.43705,7.10449a3.82273,3.82273,0,0,0-.57281-.5238,4.72529,4.72529,0,0,0-1.15766-3.73987C17.6226,1.61914,15.77494,1,13.2144,1H7.00053A1.89234,1.89234,0,0,0,5.13725,2.5918L2.5474,18.99805A1.53317,1.53317,0,0,0,4.063,20.7832H6.72709l-.082.52051A1.46684,1.46684,0,0,0,8.0933,23h3.23438a1.76121,1.76121,0,0,0,1.751-1.46973l.64063-4.03125.01074-.05468h.29883c4.03223,0,6.55078-1.99317,7.28516-5.7627A5.149,5.149,0,0,0,20.43705,7.10449ZM7.84233,13.7041l-.71448,4.53528-.08631.54382H4.606L7.09721,3H13.2144c1.93554,0,3.31738.4043,3.99218,1.16406a2.96675,2.96675,0,0,1,.60791,2.73334l-.01861.11224c-.01215.07648-.0232.15119-.0434.24622a5.84606,5.84606,0,0,1-2.00512,3.67053,6.67728,6.67728,0,0,1-4.21753,1.183H9.70658A1.87969,1.87969,0,0,0,7.84233,13.7041Zm11.50878-2.40527c-.55078,2.82812-2.24218,4.14551-5.32226,4.14551h-.4834a1.76109,1.76109,0,0,0-1.751,1.47265l-.64941,4.07422L8.71733,21l.47815-3.03387.61114-3.85285h1.7193c.1568,0,.29541-.02356.44812-.02893.35883-.01239.71661-.02618,1.05267-.06787.20526-.02557.39362-.07221.59034-.1087.27252-.05036.54522-.10016.80108-.17127.19037-.053.368-.12121.54907-.18561.23926-.0849.4748-.174.69757-.27868.168-.0791.32807-.16706.48658-.25727a6.77125,6.77125,0,0,0,.61236-.39172c.14228-.1026.28192-.20789.415-.321a6.56392,6.56392,0,0,0,.53693-.51892c.113-.12055.2287-.23755.33331-.36725a7.09,7.09,0,0,0,.48-.69263c.07648-.12219.16126-.23523.23163-.36383a8.33175,8.33175,0,0,0,.52075-1.15326c.00867-.02386.02106-.044.02954-.068.004-.01123.00989-.02057.01386-.03186A4.29855,4.29855,0,0,1,19.35111,11.29883Z'
  }));
};

UilPaypal.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPaypal.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPen = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,7.24a1,1,0,0,0-.29-.71L17.47,2.29A1,1,0,0,0,16.76,2a1,1,0,0,0-.71.29L13.22,5.12h0L2.29,16.05a1,1,0,0,0-.29.71V21a1,1,0,0,0,1,1H7.24A1,1,0,0,0,8,21.71L18.87,10.78h0L21.71,8a1.19,1.19,0,0,0,.22-.33,1,1,0,0,0,0-.24.7.7,0,0,0,0-.14ZM6.83,20H4V17.17l9.93-9.93,2.83,2.83ZM18.17,8.66,15.34,5.83l1.42-1.41,2.82,2.82Z'
  }));
};

UilPen.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPen.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPentagon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.59,9.17l-9-6.54a1,1,0,0,0-1.18,0l-9,6.54a1,1,0,0,0-.36,1.12L5.49,20.87a1,1,0,0,0,1,.69H17.56a1,1,0,0,0,1-.69L22,10.29A1,1,0,0,0,21.59,9.17ZM16.84,19.56H7.16l-3-9.2L12,4.68l7.82,5.68Z'
  }));
};

UilPentagon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPentagon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPercentage = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M7.75781,10.75781a3,3,0,1,0-3-3A3.00328,3.00328,0,0,0,7.75781,10.75781Zm0-4a1,1,0,1,1-1,1A1.00067,1.00067,0,0,1,7.75781,6.75781Zm8.48438,6.48438a3,3,0,1,0,3,3A3.00328,3.00328,0,0,0,16.24219,13.24219Zm0,4a1,1,0,1,1,1-1A1.00067,1.00067,0,0,1,16.24219,17.24219ZM19.707,4.293a.99962.99962,0,0,0-1.41406,0l-14,14A.99989.99989,0,1,0,5.707,19.707l14-14A.99962.99962,0,0,0,19.707,4.293Z'
  }));
};

UilPercentage.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPercentage.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPhone = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.44,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1.05,1.05,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1Z'
  }));
};

UilPhone.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPhone.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPhoneAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.44,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1.06,1.06,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1Z'
  }));
};

UilPhoneAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPhoneAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPhonePause = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.44,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1,1,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1ZM19,10a1,1,0,0,0,1-1V5a1,1,0,0,0-2,0V9A1,1,0,0,0,19,10Zm-4,0a1,1,0,0,0,1-1V5a1,1,0,0,0-2,0V9A1,1,0,0,0,15,10Z'
  }));
};

UilPhonePause.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPhonePause.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPhoneSlash = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M4.91,13.1a1,1,0,0,0,.85.47A1,1,0,0,0,6.61,12,17,17,0,0,1,4.14,5.15a1,1,0,0,1,.24-.81A1,1,0,0,1,5.13,4h3a1,1,0,0,1,1,.8c0,.23.08.44.13.67l0,.13a10.33,10.33,0,0,0,.47,1.54L8.34,7.8a1,1,0,0,0-.52.57,1,1,0,0,0,0,.77c.1.21.2.42.32.64a1,1,0,0,0,1.37.37,1,1,0,0,0,.5-.94L10.58,9a2,2,0,0,0,1.05-2.48,9.3,9.3,0,0,1-.39-1.3l0-.1c0-.2-.08-.4-.11-.58A3,3,0,0,0,8.16,2h-3A3,3,0,0,0,2.88,3a3,3,0,0,0-.72,2.39A19.05,19.05,0,0,0,4.91,13.1Zm14.61-.21-.6-.11-.08,0a9.31,9.31,0,0,1-1.33-.39,2,2,0,0,0-2.47,1l-.21.46a12.39,12.39,0,0,1-1.92-1.37l8.8-8.79a1,1,0,1,0-1.42-1.42l-18,18a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4.59-4.6a19.09,19.09,0,0,0,10.29,4.73,2.69,2.69,0,0,0,.4,0,3,3,0,0,0,2-.75,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.52,12.89Zm.48,6a1,1,0,0,1-.34.75,1,1,0,0,1-.81.24A17.07,17.07,0,0,1,9.71,15.7l1.77-1.77a14.69,14.69,0,0,0,3.38,2.21,1,1,0,0,0,.77,0,1,1,0,0,0,.57-.52l.62-1.41a12,12,0,0,0,1.6.47l.11,0,.69.13a1,1,0,0,1,.78,1Z'
  }));
};

UilPhoneSlash.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPhoneSlash.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPhoneTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.85,5.56l1.79-1.79a1,1,0,1,0-1.41-1.41L18.44,4.15l-1.8-1.79a1,1,0,0,0-1.41,1.41L17,5.56l-1.79,1.8a1,1,0,0,0,0,1.41,1,1,0,0,0,1.41,0L18.44,7l1.79,1.79a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41ZM19.44,13c-.22,0-.45-.07-.67-.12a9.44,9.44,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.45a12.18,12.18,0,0,1-2.66-2,12.18,12.18,0,0,1-2-2.66L10.52,9a2,2,0,0,0,1-2.48,10.33,10.33,0,0,1-.39-1.31c-.05-.22-.09-.45-.12-.68a3,3,0,0,0-3-2.49h-3a3,3,0,0,0-3,3.41A19,19,0,0,0,18.53,21.91l.38,0a3,3,0,0,0,2-.76,3,3,0,0,0,1-2.25v-3A3,3,0,0,0,19.44,13Zm.5,6a1,1,0,0,1-.34.75,1.06,1.06,0,0,1-.82.25A17,17,0,0,1,4.07,5.22a1.09,1.09,0,0,1,.25-.82,1,1,0,0,1,.75-.34h3a1,1,0,0,1,1,.79q.06.41.15.81a11.12,11.12,0,0,0,.46,1.55l-1.4.65a1,1,0,0,0-.49,1.33,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.57-.52l.62-1.4a13.69,13.69,0,0,0,1.58.46q.4.09.81.15a1,1,0,0,1,.79,1Z'
  }));
};

UilPhoneTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPhoneTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPhoneVolume = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.41,13c-.22,0-.45-.07-.67-.12a9.86,9.86,0,0,1-1.31-.39,2,2,0,0,0-2.48,1l-.22.46a13.17,13.17,0,0,1-2.67-2,13.17,13.17,0,0,1-2-2.67l.46-.21a2,2,0,0,0,1-2.48,10.47,10.47,0,0,1-.39-1.32c-.05-.22-.09-.45-.12-.67a3,3,0,0,0-3-2.49H5a3,3,0,0,0-2.24,1,3,3,0,0,0-.73,2.4,19.07,19.07,0,0,0,5.41,11,19.07,19.07,0,0,0,11,5.41,2.56,2.56,0,0,0,.39,0,3,3,0,0,0,2-.76,3,3,0,0,0,1-2.24v-3A3,3,0,0,0,19.41,13Zm.49,6a1,1,0,0,1-.33.74,1,1,0,0,1-.82.25,17.16,17.16,0,0,1-9.87-4.84A17.16,17.16,0,0,1,4,5.25a1,1,0,0,1,.25-.82A1,1,0,0,1,5,4.1h3a1,1,0,0,1,1,.78c0,.27.09.55.15.82a11,11,0,0,0,.46,1.54l-1.4.66a1,1,0,0,0-.52.56,1,1,0,0,0,0,.76,14.49,14.49,0,0,0,7,7,1,1,0,0,0,.76,0,1,1,0,0,0,.56-.52l.63-1.4a12.41,12.41,0,0,0,1.58.46c.26.06.54.11.81.15a1,1,0,0,1,.78,1ZM14,2c-.23,0-.47,0-.7,0a1,1,0,0,0,.17,2L14,4a6,6,0,0,1,6,6c0,.18,0,.35,0,.53a1,1,0,0,0,.91,1.08h.08a1,1,0,0,0,1-.91c0-.23,0-.47,0-.7A8,8,0,0,0,14,2Zm2,8a1,1,0,0,0,2,0,4,4,0,0,0-4-4,1,1,0,0,0,0,2A2,2,0,0,1,16,10Z'
  }));
};

UilPhoneVolume.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPhoneVolume.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPicture = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,4a1,1,0,0,0,.71-1.7,1,1,0,0,0-1.42,0,1,1,0,0,0-.21.32A.84.84,0,0,0,19,3a1,1,0,0,0,1,1Zm0,9a1,1,0,0,0-1,1v.39l-1.48-1.48a2.77,2.77,0,0,0-3.93,0l-.7.7-2.48-2.49a2.86,2.86,0,0,0-3.93,0L5,12.6V7A1,1,0,0,1,6,6H16a1,1,0,0,0,0-2H6A3,3,0,0,0,3,7V19a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V14A1,1,0,0,0,20,13ZM6,20a1,1,0,0,1-1-1V15.43l2.9-2.9a.79.79,0,0,1,1.09,0l3.17,3.17,0,0L16.45,20Zm13-1a1,1,0,0,1-.18.53L14.31,15l.7-.7a.78.78,0,0,1,1.1,0L19,17.22ZM20,5a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V6A1,1,0,0,0,20,5Z'
  }));
};

UilPicture.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPicture.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPizzaSlice = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M8.51,12.48a1,1,0,1,0,1,1A1,1,0,0,0,8.51,12.48ZM8.51,8a1,1,0,1,0,1,1A1,1,0,0,0,8.51,8ZM12,10a1,1,0,0,0-1,1v1a1,1,0,0,0,2,0V11A1,1,0,0,0,12,10Zm8.5-1.43,0,0a3,3,0,0,0-2.3-.29,2.9,2.9,0,0,0-1.09.56L5.51,2.13a1,1,0,0,0-1,0A1,1,0,0,0,4,3V16.17A2.94,2.94,0,0,0,2,19H2a3,3,0,0,0,2.92,3h.58a18.57,18.57,0,0,0,16.11-9.41A3,3,0,0,0,20.51,8.57ZM6,4.73l9.89,5.71A12.57,12.57,0,0,1,6,16Zm13.87,6.88A16.58,16.58,0,0,1,5,20a1,1,0,0,1-1-1,1,1,0,0,1,.3-.72A1,1,0,0,1,5,18h.51a14.5,14.5,0,0,0,12.62-7.37.9.9,0,0,1,.58-.44,1,1,0,0,1,.75.09h0A1,1,0,0,1,19.88,11.61Z'
  }));
};

UilPizzaSlice.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPizzaSlice.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlane = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.75,12a1,1,0,0,0-.55-.89L15.08,8.05v-4a3.08,3.08,0,1,0-6.16,0v4L2.8,11.11a1,1,0,0,0-.55.89v3.33a1,1,0,0,0,.43.83,1,1,0,0,0,.92.11l5.32-2V18l-1.82.6a1,1,0,0,0-.68.95V22a1,1,0,0,0,.3.71,1,1,0,0,0,.7.29h9.17a1,1,0,0,0,1-1V19.5a1,1,0,0,0-.68-.95L15.08,18V14.28l5.32,2a1,1,0,0,0,.92-.11,1,1,0,0,0,.43-.83Zm-7.31-.1a1,1,0,0,0-.93.11,1,1,0,0,0-.43.82v5.84a1,1,0,0,0,.69.95l1.81.6V21H8.41v-.78l1.81-.6a1,1,0,0,0,.69-.95V12.83a1,1,0,0,0-.43-.82,1,1,0,0,0-.93-.11l-5.31,2V12.62l6.11-3.06a1,1,0,0,0,.56-.89V4.08a1.08,1.08,0,1,1,2.16,0V8.67a1,1,0,0,0,.56.89l6.11,3.06v1.27Z'
  }));
};

UilPlane.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlane.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlaneArrival = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.12,16.23a5,5,0,0,0-2.3-3L16.71,12l-.48-5.47a1,1,0,0,0-.49-.78l-3-1.72a1,1,0,0,0-1,0,1,1,0,0,0-.52.84l-.15,3.9-1.75-1L6.46,3.92a1,1,0,0,0-1.78.41L3.81,8.94A3,3,0,0,0,5.2,12.23l14.06,8.11A1,1,0,0,0,20.62,20,4.91,4.91,0,0,0,21.12,16.23ZM19.24,18,6.2,10.5a1,1,0,0,1-.44-1.13l.46-2.44,1.66,2.2a1,1,0,0,0,.3.27l3.35,1.94a1,1,0,0,0,1.5-.83l.16-3.9,1.09.63.48,5.47a1,1,0,0,0,.5.78L17.82,15a2.91,2.91,0,0,1,1.36,1.78A2.74,2.74,0,0,1,19.24,18Z'
  }));
};

UilPlaneArrival.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlaneArrival.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlaneDeparture = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22,5.08A3.08,3.08,0,0,0,16.74,2.9L13.93,5.71,7.44,3.55a1,1,0,0,0-1,.24L4.06,6.15a1,1,0,0,0,.29,1.61l5.18,2.35-2.6,2.6-1.71-.86A1,1,0,0,0,4.06,12L2.29,13.81a1,1,0,0,0,0,1.41l6.49,6.49a1,1,0,0,0,1.41,0L12,19.94a1,1,0,0,0,.19-1.16l-.86-1.71,2.6-2.6,2.35,5.18a1,1,0,0,0,1.61.29l2.36-2.36a1,1,0,0,0,.24-1l-2.16-6.49L21.1,7.26A3.05,3.05,0,0,0,22,5.08Zm-2.32.77L16.44,9.09a1,1,0,0,0-.24,1l2.16,6.48-.9.9-2.35-5.17a1,1,0,0,0-.73-.57,1,1,0,0,0-.89.28L9.37,16.17a1,1,0,0,0-.19,1.15L10,19l-.56.56L4.41,14.52,5,14l1.71.86a1,1,0,0,0,1.15-.19L12,10.51a1,1,0,0,0-.29-1.62L6.5,6.54l.9-.9L13.88,7.8a1,1,0,0,0,1-.24l3.24-3.24a1.07,1.07,0,0,1,1.53,0,1,1,0,0,1,.32.76A1.06,1.06,0,0,1,19.68,5.85Z'
  }));
};

UilPlaneDeparture.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlaneDeparture.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlaneFly = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M23,9.32a1.06,1.06,0,0,0-.1-.76,4.93,4.93,0,0,0-6.75-1.8L14,8,9,5.65a1,1,0,0,0-.92,0l-3,1.73a1,1,0,0,0-.5.84,1,1,0,0,0,.46.87l3.3,2.08-1.74,1-4.78.58a1,1,0,0,0-.53,1.75l3.54,3.06a3,3,0,0,0,3.55.44L22.5,9.93A1,1,0,0,0,23,9.32Zm-15.53,7a1,1,0,0,1-1.2-.18L4.37,14.51l2.73-.33a1,1,0,0,0,.38-.13l3.36-1.93a1,1,0,0,0,.5-.85,1,1,0,0,0-.47-.86L7.57,8.32l1.1-.63,5,2.32a1,1,0,0,0,.92,0l2.56-1.48a3,3,0,0,1,3.36.29Z'
  }));
};

UilPlaneFly.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlaneFly.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlay = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M18.54,9,8.88,3.46a3.42,3.42,0,0,0-5.13,3V17.58A3.42,3.42,0,0,0,7.17,21a3.43,3.43,0,0,0,1.71-.46L18.54,15a3.42,3.42,0,0,0,0-5.92Zm-1,4.19L7.88,18.81a1.44,1.44,0,0,1-1.42,0,1.42,1.42,0,0,1-.71-1.23V6.42a1.42,1.42,0,0,1,.71-1.23A1.51,1.51,0,0,1,7.17,5a1.54,1.54,0,0,1,.71.19l9.66,5.58a1.42,1.42,0,0,1,0,2.46Z'
  }));
};

UilPlay.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlay.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlayCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,10.27,11,7.38A2,2,0,0,0,8,9.11v5.78a2,2,0,0,0,1,1.73,2,2,0,0,0,2,0l5-2.89a2,2,0,0,0,0-3.46ZM15,12l-5,2.89V9.11L15,12ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z'
  }));
};

UilPlayCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlayCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlug = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,6H16V3a1,1,0,0,0-2,0V6H10V3A1,1,0,0,0,8,3V6H5A1,1,0,0,0,5,8H6v5a1,1,0,0,0,.29.71L9,16.41V21a1,1,0,0,0,2,0V17h2v4a1,1,0,0,0,2,0V16.41l2.71-2.7A1,1,0,0,0,18,13V8h1a1,1,0,0,0,0-2Zm-3,6.59L13.59,15H10.41L8,12.59V8h8ZM11,13h2a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Z'
  }));
};

UilPlug.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlug.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,11H13V5a1,1,0,0,0-2,0v6H5a1,1,0,0,0,0,2h6v6a1,1,0,0,0,2,0V13h6a1,1,0,0,0,0-2Z'
  }));
};

UilPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlusCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Zm4-9H13V8a1,1,0,0,0-2,0v3H8a1,1,0,0,0,0,2h3v3a1,1,0,0,0,2,0V13h3a1,1,0,0,0,0-2Z'
  }));
};

UilPlusCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlusCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPlusSquare = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9,13h2v2a1,1,0,0,0,2,0V13h2a1,1,0,0,0,0-2H13V9a1,1,0,0,0-2,0v2H9a1,1,0,0,0,0,2ZM21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,20H4V4H20Z'
  }));
};

UilPlusSquare.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPlusSquare.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPodium = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19.79,7.13A1,1,0,0,0,19,6.75H8v-.5A2,2,0,0,1,9.46,4.33a1.5,1.5,0,0,0,1,.42h1a1.5,1.5,0,0,0,0-3h-1a1.49,1.49,0,0,0-1.17.57A4,4,0,0,0,6,6.25v.5H5a1,1,0,0,0-.79.38A1,1,0,0,0,4,8l.62,2.49A3,3,0,0,0,7.1,12.71l.78,7H7a1,1,0,0,0,0,2H17a1,1,0,0,0,0-2h-.88l.78-7a3,3,0,0,0,2.45-2.23L20,8A1,1,0,0,0,19.79,7.13ZM14.1,19.75H9.9l-.78-7h5.76ZM17.41,10a1,1,0,0,1-1,.76H7.56a1,1,0,0,1-1-.76L6.28,8.75H17.72Z'
  }));
};

UilPodium.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPodium.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPolygon = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21.87,11.5l-4.5-7.79a1,1,0,0,0-.87-.5h-9a1,1,0,0,0-.87.5L2.13,11.5a1,1,0,0,0,0,1l4.5,7.79a1,1,0,0,0,.87.5h9a1,1,0,0,0,.87-.5l4.5-7.79A1,1,0,0,0,21.87,11.5Zm-6,7.29H8.08L4.15,12,8.08,5.21h7.84L19.85,12Z'
  }));
};

UilPolygon.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPolygon.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPostStamp = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M22.5,5.5a1,1,0,0,0,1-1v-3a1,1,0,0,0-1-1h-3a1,1,0,0,0-1,1,.5.5,0,0,1-1,0,1,1,0,0,0-1-1h-3a1,1,0,0,0-1,1,.5.5,0,0,1-1,0,1,1,0,0,0-1-1h-3a1,1,0,0,0-1,1,.5.5,0,0,1-1,0,1,1,0,0,0-1-1h-3a1,1,0,0,0-1,1v3a1,1,0,0,0,1,1,.5.5,0,0,1,0,1,1,1,0,0,0-1,1v3a1,1,0,0,0,1,1,.5.5,0,0,1,0,1,1,1,0,0,0-1,1v3a1,1,0,0,0,1,1,.5.5,0,0,1,0,1,1,1,0,0,0-1,1v3a1,1,0,0,0,1,1h3a1,1,0,0,0,1-1,.5.5,0,0,1,1,0,1,1,0,0,0,1,1h3a1,1,0,0,0,1-1,.5.5,0,0,1,1,0,1,1,0,0,0,1,1h3a1,1,0,0,0,1-1,.5.5,0,0,1,1,0,1,1,0,0,0,1,1h3a1,1,0,0,0,1-1v-3a1,1,0,0,0-1-1,.5.5,0,0,1,0-1,1,1,0,0,0,1-1v-3a1,1,0,0,0-1-1,.5.5,0,0,1,0-1,1,1,0,0,0,1-1v-3a1,1,0,0,0-1-1,.5.5,0,0,1,0-1Zm-1-1.79a2.5,2.5,0,0,0,0,4.58V9.71a2.5,2.5,0,0,0,0,4.58v1.42a2.5,2.5,0,0,0,0,4.58V21.5H20.29a2.5,2.5,0,0,0-4.58,0H14.29a2.5,2.5,0,0,0-4.58,0H8.29a2.5,2.5,0,0,0-4.58,0H2.5V20.29a2.5,2.5,0,0,0,0-4.58V14.29a2.5,2.5,0,0,0,0-4.58V8.29a2.5,2.5,0,0,0,0-4.58V2.5H3.71a2.5,2.5,0,0,0,4.58,0H9.71a2.5,2.5,0,0,0,4.58,0h1.42a2.5,2.5,0,0,0,4.58,0H21.5ZM12,5a7,7,0,0,0,0,14,6.93,6.93,0,0,0,3.5-.94,1,1,0,1,0-1-1.73A5,5,0,1,1,17,12v.5a.83.83,0,0,1-.83.83.84.84,0,0,1-.84-.83V9.67a1,1,0,0,0-1.78-.6A3.25,3.25,0,0,0,12,8.67a3.33,3.33,0,0,0,0,6.66,3.28,3.28,0,0,0,2.17-.82,2.84,2.84,0,0,0,4.83-2V12A7,7,0,0,0,12,5Zm0,8.33A1.33,1.33,0,1,1,13.33,12,1.32,1.32,0,0,1,12,13.33Z'
  }));
};

UilPostStamp.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPostStamp.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPostcard = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M17,11h1a1,1,0,0,0,1-1V9a1,1,0,0,0-1-1H17a1,1,0,0,0-1,1v1A1,1,0,0,0,17,11ZM6,12h5a1,1,0,0,0,0-2H6a1,1,0,0,0,0,2ZM22,4H2A1,1,0,0,0,1,5V19a1,1,0,0,0,1,1H22a1,1,0,0,0,1-1V5A1,1,0,0,0,22,4ZM21,18H3V6H21ZM6,16h5a1,1,0,0,0,0-2H6a1,1,0,0,0,0,2Z'
  }));
};

UilPostcard.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPostcard.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPound = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M20,20H8a4.92,4.92,0,0,0,1-3V14h6a1,1,0,0,0,0-2H9V8.89a4.89,4.89,0,0,1,9.13-2.44,1,1,0,0,0,1.37.36,1,1,0,0,0,.37-1.36A6.9,6.9,0,0,0,7,8.89V12H4a1,1,0,0,0,0,2H7v3a3,3,0,0,1-3,3,1,1,0,0,0,0,2H20a1,1,0,0,0,0-2Z'
  }));
};

UilPound.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPound.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPoundCircle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M16,15H10.82A3,3,0,0,0,11,14V13h2.5a1,1,0,0,0,0-2H11V10a1.95,1.95,0,0,1,3.63-1,1,1,0,0,0,1.74-1A4,4,0,0,0,9,10V11H8a1,1,0,0,0,0,2H9v1a1,1,0,0,1-1,1,1,1,0,0,0,0,2h8a1,1,0,0,0,0-2ZM12,1A11,11,0,1,0,23,12,11,11,0,0,0,12,1Zm0,20a9,9,0,1,1,9-9A9,9,0,0,1,12,21Z'
  }));
};

UilPoundCircle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPoundCircle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPower = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.21,6.21l.79-.8V10a1,1,0,0,0,2,0V5.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42ZM18,7.56A1,1,0,1,0,16.56,9,6.45,6.45,0,1,1,7.44,9,1,1,0,1,0,6,7.56a8.46,8.46,0,1,0,12,0Z'
  }));
};

UilPower.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPower.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPrescriptionBottle = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M19,2H5A2,2,0,0,0,3,4V6A2,2,0,0,0,5,8V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V8a2,2,0,0,0,2-2V4A2,2,0,0,0,19,2ZM17,16H11V12h6Zm0-6H10a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h7v1a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V8H17ZM5,6V4H19V6Z'
  }));
};

UilPrescriptionBottle.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPrescriptionBottle.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentation = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentation.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentation.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationCheck = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.29,11.71a1,1,0,0,0,1.42,0l4-4a1,1,0,1,0-1.42-1.42L11,9.59,9.71,8.29A1,1,0,0,0,8.29,9.71ZM21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentationCheck.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationCheck.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationEdit = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.41,13h2.42a1,1,0,0,0,.71-.29l3.58-3.58a1,1,0,0,0,0-1.41L13.7,5.32a1,1,0,0,0-1.41,0L8.71,8.9a1,1,0,0,0-.3.7V12A1,1,0,0,0,9.41,13Zm1-3L13,7.44l1,1L11.42,11h-1ZM21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentationEdit.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationEdit.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationLine = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14H20V3a1,1,0,0,0-1-1H5A1,1,0,0,0,4,3V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18ZM9,12a1,1,0,0,0,.83-.45l1.33-2,1.13,1.14a1,1,0,0,0,.81.29,1,1,0,0,0,.73-.45l2-3a1,1,0,0,0-1.66-1.1l-1.33,2L11.71,7.29A1,1,0,0,0,10.9,7a1,1,0,0,0-.73.45l-2,3a1,1,0,0,0,.28,1.38A.94.94,0,0,0,9,12Z'
  }));
};

UilPresentationLine.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationLine.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationLinesAlt = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10.17,10.55a1,1,0,0,0,.73.45,1,1,0,0,0,.81-.29l1.13-1.14,1.33,2A1,1,0,0,0,15,12a.94.94,0,0,0,.55-.17,1,1,0,0,0,.28-1.38l-2-3A1,1,0,0,0,13.1,7a1,1,0,0,0-.81.29L11.16,8.43l-1.33-2a1,1,0,1,0-1.66,1.1ZM21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentationLinesAlt.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationLinesAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationMinus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M10,10h4a1,1,0,0,0,0-2H10a1,1,0,0,0,0,2Zm11,4H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentationMinus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationMinus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationPlay = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18ZM9.61,12.26a1.73,1.73,0,0,0,1.76,0l3-1.74a1.76,1.76,0,0,0,0-3l-3-1.74a1.73,1.73,0,0,0-1.76,0,1.71,1.71,0,0,0-.87,1.52v3.48A1.71,1.71,0,0,0,9.61,12.26Zm1.13-4.58L13,9l-2.28,1.32Z'
  }));
};

UilPresentationPlay.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationPlay.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationPlus = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Zm-8-4h1v1a1,1,0,0,0,2,0V10h1a1,1,0,0,0,0-2H13V7a1,1,0,0,0-2,0V8H10a1,1,0,0,0,0,2Z'
  }));
};

UilPresentationPlus.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationPlus.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPresentationTimes = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M9.29,11.71a1,1,0,0,0,1.42,0L12,10.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L13.41,9l1.3-1.29a1,1,0,1,0-1.42-1.42L12,7.59l-1.29-1.3A1,1,0,0,0,9.29,7.71L10.59,9l-1.3,1.29A1,1,0,0,0,9.29,11.71ZM21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18Z'
  }));
};

UilPresentationTimes.propTypes = {
  color: propTypes.string,
  size: propTypes.oneOfType([propTypes.string, propTypes.number]),
};

UilPresentationTimes.defaultProps = {
  color: 'currentColor',
  size: '24',
};

const UilPrevious = (props) => {
  const { color, size, ...otherProps } = props;
  return React__default['default'].createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React__default['default'].createElement('path', {
    d: 'M13.41,12l3.3-3.29a1,1,0,1,0-1.42-1.42l-4,4a1,1,0,0,0,0,1.42l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM8,7A1,1,0,0,0,7,8v8a1,1,0,0,0