import React, { Component } from 'react';
import { CSSMotionProps } from 'rc-motion';
import { StretchType, AlignType, TransitionNameType, AnimationType, Point } from './interface';
/**
 * Popup should follow the steps for each component work correctly:
 * measure - check for the current stretch size
 * align - let component align the position
 * aligned - re-align again in case additional className changed the size
 * afterAlign - choice next step is trigger motion or finished
 * beforeMotion - should reset motion to invisible so that CSSMotion can do normal motion
 * motion - play the motion
 * stable - everything is done
 */
declare type PopupStatus = null | 'measure' | 'align' | 'aligned' | 'afterAlign' | 'beforeMotion' | 'motion' | 'AfterMotion' | 'stable';
interface PopupProps {
    visible?: boolean;
    style?: React.CSSProperties;
    getClassNameFromAlign?: (align: AlignType) => string;
    onAlign?: (element: HTMLElement, align: AlignType) => void;
    getRootDomNode?: () => HTMLElement;
    align?: AlignType;
    destroyPopupOnHide?: boolean;
    className?: string;
    prefixCls: string;
    onMouseEnter?: React.MouseEventHandler<HTMLElement>;
    onMouseLeave?: React.MouseEventHandler<HTMLElement>;
    onMouseDown?: React.MouseEventHandler<HTMLElement>;
    onTouchStart?: React.TouchEventHandler<HTMLElement>;
    stretch?: StretchType;
    children?: React.ReactNode;
    point?: Point;
    zIndex?: number;
    mask?: boolean;
    motion: CSSMotionProps;
    maskMotion: CSSMotionProps;
    animation: AnimationType;
    transitionName: TransitionNameType;
    maskAnimation: AnimationType;
    maskTransitionName: TransitionNameType;
}
interface PopupState {
    targetWidth: number;
    targetHeight: number;
    status: PopupStatus;
    prevVisible: boolean;
    alignClassName: string;
    /** Record for CSSMotion is working or not */
    inMotion: boolean;
}
interface AlignRefType {
    forceAlign: () => void;
}
declare class Popup extends Component<PopupProps, PopupState> {
    state: PopupState;
    popupRef: React.RefObject<HTMLDivElement>;
    alignRef: React.RefObject<AlignRefType>;
    private nextFrameState;
    private nextFrameId;
    static getDerivedStateFromProps({ visible, ...props }: PopupProps, { prevVisible, status, inMotion }: PopupState): Partial<PopupState>;
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    onAlign: (popupDomNode: HTMLElement, align: AlignType) => void;
    onMotionEnd: () => void;
    setStateOnNextFrame: (state: Partial<PopupState>) => void;
    getMotion: () => {
        motionName?: import("rc-motion/lib/CSSMotion").MotionName;
        visible?: boolean;
        motionAppear?: boolean;
        motionEnter?: boolean;
        motionLeave?: boolean;
        motionLeaveImmediately?: boolean;
        motionDeadline?: number;
        removeOnLeave?: boolean;
        leavedClassName?: string;
        eventProps?: object;
        onAppearPrepare?: import("rc-motion/lib/interface").MotionPrepareEventHandler;
        onEnterPrepare?: import("rc-motion/lib/interface").MotionPrepareEventHandler;
        onLeavePrepare?: import("rc-motion/lib/interface").MotionPrepareEventHandler;
        onAppearStart?: import("rc-motion").MotionEventHandler;
        onEnterStart?: import("rc-motion").MotionEventHandler;
        onLeaveStart?: import("rc-motion").MotionEventHandler;
        onAppearActive?: import("rc-motion").MotionEventHandler;
        onEnterActive?: import("rc-motion").MotionEventHandler;
        onLeaveActive?: import("rc-motion").MotionEventHandler;
        onAppearEnd?: import("rc-motion").MotionEndEventHandler;
        onEnterEnd?: import("rc-motion").MotionEndEventHandler;
        onLeaveEnd?: import("rc-motion").MotionEndEventHandler;
        internalRef?: React.Ref<any>;
        children?: (props: {
            [key: string]: any;
            className?: string;
            style?: React.CSSProperties;
        }, ref: (node: any) => void) => React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)>) | (new (props: any) => React.Component<any, any, any>)>;
    };
    getAlignTarget: () => Point | (() => HTMLElement);
    getZIndexStyle(): React.CSSProperties;
    cancelFrameState: () => void;
    renderPopupElement: () => JSX.Element;
    renderMaskElement: () => JSX.Element;
    render(): JSX.Element;
}
export default Popup;
