dnl Copyright (C) 1997-2019 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

AC_DEFUN([DEBUGINFOD],
[
# Enable debuginfod
AC_ARG_WITH([debuginfod],
        AC_HELP_STRING([--with-debuginfod],
                       [Enable debuginfo lookups with debuginfod (auto/yes/no)]),
        [], [with_debuginfod=no])
AC_MSG_CHECKING([whether to use debuginfod])
AC_MSG_RESULT([$with_debuginfod])

if test "${with_debuginfod}" != no; then
  AC_CHECK_LIB([debuginfod], [debuginfod_begin], [have_debuginfod_lib=yes])
  AC_CHECK_DECL([debuginfod_begin], [have_debuginfod_h=yes], [],
                [#include <elfutils/debuginfod.h>])
  if test "x$have_debuginfod_lib" = "xyes" \
          -a "x$have_debuginfod_h" = "xyes"; then
    AC_DEFINE([HAVE_LIBDEBUGINFOD], [1],
              [Define to 1 if debuginfod is enabled.])
    AC_SUBST([LIBDEBUGINFOD], ["-ldebuginfod"])
  else
    AC_SUBST([LIBDEBUGINFOD], [])
    if test "$with_debuginfod" = yes; then
      AC_MSG_ERROR([debuginfod is missing or unusable.])
    else
      AC_MSG_WARN([debuginfod is missing or unusable.])
    fi
  fi
fi
AM_CONDITIONAL([HAVE_DEBUGINFOD],
               [test x"$have_debuginfod_lib" == xyes -a x"$have_debuginfod_h" == xyes])
])
