; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ILP32E %s
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -frame-pointer=all -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=ILP32E-WITHFP %s

declare void @llvm.va_start(i8*)
declare void @llvm.va_end(i8*)
declare void @abort()

define i32 @caller(i32 %a) {
; ILP32E-LABEL: caller:
; ILP32E:       # %bb.0: # %entry
; ILP32E-NEXT:    addi sp, sp, -8
; ILP32E-NEXT:    .cfi_def_cfa_offset 8
; ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-NEXT:    sw s0, 0(sp) # 4-byte Folded Spill
; ILP32E-NEXT:    .cfi_offset ra, -4
; ILP32E-NEXT:    .cfi_offset s0, -8
; ILP32E-NEXT:    mv s0, a0
; ILP32E-NEXT:    li a0, 1
; ILP32E-NEXT:    lui a2, 262144
; ILP32E-NEXT:    li a1, 0
; ILP32E-NEXT:    call va_double
; ILP32E-NEXT:    mv a0, s0
; ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-NEXT:    lw s0, 0(sp) # 4-byte Folded Reload
; ILP32E-NEXT:    addi sp, sp, 8
; ILP32E-NEXT:    ret
;
; ILP32E-WITHFP-LABEL: caller:
; ILP32E-WITHFP:       # %bb.0: # %entry
; ILP32E-WITHFP-NEXT:    addi sp, sp, -12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 12
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s1, 0(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -4
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -8
; ILP32E-WITHFP-NEXT:    .cfi_offset s1, -12
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 0
; ILP32E-WITHFP-NEXT:    mv s1, a0
; ILP32E-WITHFP-NEXT:    li a0, 1
; ILP32E-WITHFP-NEXT:    lui a2, 262144
; ILP32E-WITHFP-NEXT:    li a1, 0
; ILP32E-WITHFP-NEXT:    call va_double
; ILP32E-WITHFP-NEXT:    mv a0, s1
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s1, 0(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 12
; ILP32E-WITHFP-NEXT:    ret
entry:
  call void (i32, ...) @va_double(i32 1, double 2.000000e+00)
  ret i32 %a
}

define void @va_double(i32 %n, ...) {
; ILP32E-LABEL: va_double:
; ILP32E:       # %bb.0: # %entry
; ILP32E-NEXT:    addi sp, sp, -32
; ILP32E-NEXT:    .cfi_def_cfa_offset 32
; ILP32E-NEXT:    sw ra, 4(sp) # 4-byte Folded Spill
; ILP32E-NEXT:    .cfi_offset ra, -28
; ILP32E-NEXT:    sw a5, 28(sp)
; ILP32E-NEXT:    sw a4, 24(sp)
; ILP32E-NEXT:    sw a3, 20(sp)
; ILP32E-NEXT:    sw a2, 16(sp)
; ILP32E-NEXT:    sw a1, 12(sp)
; ILP32E-NEXT:    addi a0, sp, 12
; ILP32E-NEXT:    sw a0, 0(sp)
; ILP32E-NEXT:    addi a0, sp, 19
; ILP32E-NEXT:    andi a1, a0, -8
; ILP32E-NEXT:    addi a0, a1, 8
; ILP32E-NEXT:    sw a0, 0(sp)
; ILP32E-NEXT:    lw a0, 0(a1)
; ILP32E-NEXT:    lw a1, 4(a1)
; ILP32E-NEXT:    lui a3, 262144
; ILP32E-NEXT:    li a2, 0
; ILP32E-NEXT:    call __eqdf2
; ILP32E-NEXT:    bnez a0, .LBB1_2
; ILP32E-NEXT:  # %bb.1: # %if.end
; ILP32E-NEXT:    lw ra, 4(sp) # 4-byte Folded Reload
; ILP32E-NEXT:    addi sp, sp, 32
; ILP32E-NEXT:    ret
; ILP32E-NEXT:  .LBB1_2: # %if.then
; ILP32E-NEXT:    call abort
;
; ILP32E-WITHFP-LABEL: va_double:
; ILP32E-WITHFP:       # %bb.0: # %entry
; ILP32E-WITHFP-NEXT:    addi sp, sp, -36
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa_offset 36
; ILP32E-WITHFP-NEXT:    sw ra, 8(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    sw s0, 4(sp) # 4-byte Folded Spill
; ILP32E-WITHFP-NEXT:    .cfi_offset ra, -28
; ILP32E-WITHFP-NEXT:    .cfi_offset s0, -32
; ILP32E-WITHFP-NEXT:    addi s0, sp, 12
; ILP32E-WITHFP-NEXT:    .cfi_def_cfa s0, 24
; ILP32E-WITHFP-NEXT:    sw a5, 20(s0)
; ILP32E-WITHFP-NEXT:    sw a4, 16(s0)
; ILP32E-WITHFP-NEXT:    sw a3, 12(s0)
; ILP32E-WITHFP-NEXT:    sw a2, 8(s0)
; ILP32E-WITHFP-NEXT:    sw a1, 4(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 4
; ILP32E-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32E-WITHFP-NEXT:    addi a0, s0, 11
; ILP32E-WITHFP-NEXT:    andi a1, a0, -8
; ILP32E-WITHFP-NEXT:    addi a0, a1, 8
; ILP32E-WITHFP-NEXT:    sw a0, -12(s0)
; ILP32E-WITHFP-NEXT:    lw a0, 0(a1)
; ILP32E-WITHFP-NEXT:    lw a1, 4(a1)
; ILP32E-WITHFP-NEXT:    lui a3, 262144
; ILP32E-WITHFP-NEXT:    li a2, 0
; ILP32E-WITHFP-NEXT:    call __eqdf2
; ILP32E-WITHFP-NEXT:    bnez a0, .LBB1_2
; ILP32E-WITHFP-NEXT:  # %bb.1: # %if.end
; ILP32E-WITHFP-NEXT:    lw ra, 8(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    lw s0, 4(sp) # 4-byte Folded Reload
; ILP32E-WITHFP-NEXT:    addi sp, sp, 36
; ILP32E-WITHFP-NEXT:    ret
; ILP32E-WITHFP-NEXT:  .LBB1_2: # %if.then
; ILP32E-WITHFP-NEXT:    call abort
entry:
  %args = alloca i8*, align 4
  %args1 = bitcast i8** %args to i8*
  call void @llvm.va_start(i8* %args1)
  %argp.cur = load i8*, i8** %args, align 4
  %0 = ptrtoint i8* %argp.cur to i32
  %1 = add i32 %0, 7
  %2 = and i32 %1, -8
  %argp.cur.aligned = inttoptr i32 %2 to i8*
  %argp.next = getelementptr inbounds i8, i8* %argp.cur.aligned, i32 8
  store i8* %argp.next, i8** %args, align 4
  %3 = bitcast i8* %argp.cur.aligned to double*
  %4 = load double, double* %3, align 8
  %cmp = fcmp une double %4, 2.000000e+00
  br i1 %cmp, label %if.then, label %if.end

if.then:
  call void @abort()
  unreachable

if.end:
  %args2 = bitcast i8** %args to i8*
  call void @llvm.va_end(i8* %args2)
  ret void
}
