"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.agregateTestInfo = exports.agregateCoverageInfo = exports.agregateWorkflowInfo = void 0;
const tslib_1 = require("tslib");
const fs_1 = tslib_1.__importDefault(require("fs"));
const path_1 = tslib_1.__importDefault(require("path"));
const env_1 = require("./env");
const agregateWorkflowInfo = () => {
    const now = Date.now();
    const workflow = {
        jobs: [],
        startTime: now,
        endTime: now,
        workflowId: process.env.CIRCLE_WORKFLOW_ID,
        repo: process.env.CIRCLE_PROJECT_REPONAME,
        user: process.env.CIRCLE_PROJECT_USERNAME,
        buildNumber: (0, env_1.getBuildNumber)(),
        elapsed: 0,
    };
    const jobsFolder = path_1.default.resolve((0, env_1.getCiFolder)(), 'jobs');
    if (fs_1.default.existsSync(jobsFolder)) {
        const files = fs_1.default.readdirSync(jobsFolder);
        if (files && files.length) {
            files.forEach((file) => {
                const p = path_1.default.resolve(jobsFolder, file, 'job.json');
                if (fs_1.default.existsSync(p)) {
                    const job = require(p);
                    workflow.jobs.push(job);
                    if (job.startTime < workflow.startTime) {
                        workflow.startTime = job.startTime;
                    }
                    if (job.endTime > workflow.endTime) {
                        workflow.endTime = job.endTime;
                    }
                }
                else {
                    console.log('Missing Job info: ', p);
                }
            });
        }
        else {
            console.log('NO JOBS IN: ', jobsFolder);
        }
    }
    workflow.elapsed = workflow.endTime - workflow.startTime;
    return workflow;
};
exports.agregateWorkflowInfo = agregateWorkflowInfo;
const agregateCoverageInfo = () => {
    const coverage = [];
    const ciDir = (0, env_1.getCiFolder)();
    const jobsFolder = path_1.default.resolve(ciDir, 'jobs');
    if (fs_1.default.existsSync(jobsFolder)) {
        const files = fs_1.default.readdirSync(jobsFolder);
        if (files && files.length) {
            files.forEach((file) => {
                const dir = path_1.default.resolve(jobsFolder, file, 'coverage');
                if (fs_1.default.existsSync(dir)) {
                    const s = path_1.default.resolve(dir, 'coverage-summary.json');
                    const r = path_1.default.resolve(dir, 'lcov-report', 'index.html');
                    if (fs_1.default.existsSync(s)) {
                        const raw = require(s);
                        const info = {
                            job: file,
                            summary: raw.total,
                        };
                        if (fs_1.default.existsSync(r)) {
                            info.report = r.substring(ciDir.length);
                        }
                        coverage.push(info);
                    }
                }
            });
        }
        else {
            console.log('NO JOBS IN: ', jobsFolder);
        }
    }
    return coverage;
};
exports.agregateCoverageInfo = agregateCoverageInfo;
const agregateTestInfo = () => {
    const tests = [];
    const ciDir = (0, env_1.getCiFolder)();
    const jobsFolder = path_1.default.resolve(ciDir, 'jobs');
    if (fs_1.default.existsSync(jobsFolder)) {
        const files = fs_1.default.readdirSync(jobsFolder);
        if (files && files.length) {
            files.forEach((file) => {
                if (file.startsWith('test')) {
                    const summary = path_1.default.resolve(jobsFolder, file, 'results.json');
                    if (fs_1.default.existsSync(summary)) {
                        tests.push(require(summary));
                    }
                }
            });
        }
        else {
            console.log('NO Jobs IN: ', jobsFolder);
        }
    }
    return tests;
};
exports.agregateTestInfo = agregateTestInfo;
//# sourceMappingURL=workflow.js.map