import { initializeMetas } from '../../metas';
import { initializeTransports, TransportItemType } from '../../transports';
import { mockConfig, MockTransport } from '../../utils/tests';
import { initializeTracesAPI } from '../traces';
import { initializeExceptionsAPI } from './initialize';
describe('api.exceptions', () => {
    function createAPI() {
        const transport = new MockTransport();
        const config = mockConfig({
            transports: [transport],
        });
        const transports = initializeTransports(config);
        const metas = initializeMetas(config);
        const tracesAPI = initializeTracesAPI(transports, metas);
        const api = initializeExceptionsAPI(config, transports, metas, tracesAPI);
        return [api, transport];
    }
    describe('pushError', () => {
        it('error with overrides', () => {
            const [api, transport] = createAPI();
            const frames = [
                {
                    filename: 'foo.js',
                    function: 'FooFn',
                    colno: 4,
                    lineno: 23,
                },
                {
                    filename: 'bar.js',
                    function: 'BarFn',
                    colno: 6,
                    lineno: 52,
                },
            ];
            api.pushError(new Error('test exception'), {
                stackFrames: frames,
                type: 'TestError',
            });
            expect(transport.items).toHaveLength(1);
            const payload = transport.items[0];
            expect(payload === null || payload === void 0 ? void 0 : payload.payload).toBeTruthy();
            expect(payload === null || payload === void 0 ? void 0 : payload.type).toEqual(TransportItemType.EXCEPTION);
            const event = payload === null || payload === void 0 ? void 0 : payload.payload;
            expect(event.type).toEqual('TestError');
            expect(event.value).toEqual('test exception');
            expect(event.stacktrace).toEqual({ frames });
        });
        it('error without overrides', () => {
            var _a, _b;
            const [api, transport] = createAPI();
            const err = new Error('test');
            api.pushError(err);
            expect(transport.items).toHaveLength(1);
            const payload = transport.items[0];
            expect((_a = payload === null || payload === void 0 ? void 0 : payload.meta.app) === null || _a === void 0 ? void 0 : _a.name).toEqual('test');
            expect(payload === null || payload === void 0 ? void 0 : payload.payload).toBeTruthy();
            expect(payload === null || payload === void 0 ? void 0 : payload.type).toEqual(TransportItemType.EXCEPTION);
            const event = payload === null || payload === void 0 ? void 0 : payload.payload;
            expect(event.type).toEqual('Error');
            expect(event.value).toEqual('test');
            expect(event.timestamp).toBeTruthy();
            const stacktrace = event.stacktrace;
            expect(stacktrace).toBeTruthy();
            expect(stacktrace === null || stacktrace === void 0 ? void 0 : stacktrace.frames.length).toBeGreaterThan(3);
            expect((_b = stacktrace === null || stacktrace === void 0 ? void 0 : stacktrace.frames[0]) === null || _b === void 0 ? void 0 : _b.filename).toEqual('Error: test');
        });
    });
});
//# sourceMappingURL=initialize.test.js.map