/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.util.ArrayList;
import jdk.jfr.events.ActiveRecordingEvent;
import jdk.jfr.events.ActiveSettingEvent;
import jdk.jfr.events.ErrorThrownEvent;
import jdk.jfr.events.ExceptionStatisticsEvent;
import jdk.jfr.events.ExceptionThrownEvent;
import jdk.jfr.events.FileForceEvent;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.events.SocketReadEvent;
import jdk.jfr.events.SocketWriteEvent;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.RequestEngine;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.instrument.ConstructorTracerWriter;
import jdk.jfr.internal.instrument.FileChannelImplInstrumentor;
import jdk.jfr.internal.instrument.FileInputStreamInstrumentor;
import jdk.jfr.internal.instrument.FileOutputStreamInstrumentor;
import jdk.jfr.internal.instrument.JIClassInstrumentation;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;
import jdk.jfr.internal.instrument.RandomAccessFileInstrumentor;
import jdk.jfr.internal.instrument.SocketChannelImplInstrumentor;
import jdk.jfr.internal.instrument.SocketInputStreamInstrumentor;
import jdk.jfr.internal.instrument.SocketOutputStreamInstrumentor;
import jdk.jfr.internal.instrument.ThrowableTracer;

public final class JDKEvents {
    private static final Class<?>[] eventClasses = new Class[]{FileForceEvent.class, FileReadEvent.class, FileWriteEvent.class, SocketReadEvent.class, SocketWriteEvent.class, ExceptionThrownEvent.class, ExceptionStatisticsEvent.class, ErrorThrownEvent.class, ActiveSettingEvent.class, ActiveRecordingEvent.class};
    private static final Class<?>[] instrumentationClasses = new Class[]{FileInputStreamInstrumentor.class, FileOutputStreamInstrumentor.class, RandomAccessFileInstrumentor.class, FileChannelImplInstrumentor.class, SocketInputStreamInstrumentor.class, SocketOutputStreamInstrumentor.class, SocketChannelImplInstrumentor.class};
    private static final Class<?>[] targetClasses = new Class[instrumentationClasses.length];
    private static final JVM jvm = JVM.getJVM();
    private static final Runnable emitExceptionStatistics = JDKEvents::emitExceptionStatistics;
    private static boolean initializationTriggered;

    public static synchronized void initialize() {
        try {
            if (!initializationTriggered) {
                for (Class<?> clazz : eventClasses) {
                    SecuritySupport.registerEvent(clazz);
                }
                initializationTriggered = true;
                RequestEngine.addTrustedJDKHook(ExceptionStatisticsEvent.class, emitExceptionStatistics);
            }
        }
        catch (Exception exception) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Could not initialize JDK events. " + exception.getMessage());
        }
    }

    public static void addInstrumentation() {
        try {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < instrumentationClasses.length; ++i) {
                JIInstrumentationTarget jIInstrumentationTarget = instrumentationClasses[i].getAnnotation(JIInstrumentationTarget.class);
                Class<?> clazz = Class.forName(jIInstrumentationTarget.value());
                JDKEvents.targetClasses[i] = clazz;
                arrayList.add(clazz);
            }
            arrayList.add(Throwable.class);
            arrayList.add(Error.class);
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.INFO, "Retransformed JDK classes");
            jvm.retransformClasses(arrayList.toArray(new Class[arrayList.size()]));
        }
        catch (Exception exception) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, "Could not add instrumentation for JDK events. " + exception.getMessage());
        }
    }

    private static void emitExceptionStatistics() {
        ExceptionStatisticsEvent exceptionStatisticsEvent = new ExceptionStatisticsEvent();
        exceptionStatisticsEvent.throwables = ThrowableTracer.numThrowables();
        exceptionStatisticsEvent.commit();
    }

    public static byte[] retransformCallback(Class<?> clazz, byte[] byArray) throws Throwable {
        if (Throwable.class == clazz) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.TRACE, "Instrumenting java.lang.Throwable");
            return ConstructorTracerWriter.generateBytes(Throwable.class, byArray);
        }
        if (Error.class == clazz) {
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.TRACE, "Instrumenting java.lang.Error");
            return ConstructorTracerWriter.generateBytes(Error.class, byArray);
        }
        for (int i = 0; i < targetClasses.length; ++i) {
            if (!targetClasses[i].equals(clazz)) continue;
            Class<?> clazz2 = instrumentationClasses[i];
            Logger.log(LogTag.JFR_SYSTEM, LogLevel.TRACE, () -> "Processing instrumentation class: " + clazz2);
            return new JIClassInstrumentation(instrumentationClasses[i], clazz, byArray).getNewBytes();
        }
        return byArray;
    }

    public static void remove() {
        RequestEngine.removeHook(JDKEvents::emitExceptionStatistics);
    }
}

