/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ext;

import java.io.FileDescriptor;
import java.net.SocketException;
import java.net.SocketOption;
import java.util.Collections;
import java.util.Set;

public abstract class RdmaSocketOptions {
    private final Set<SocketOption<?>> options;
    private static volatile RdmaSocketOptions instance;

    public final boolean isOptionSupported(SocketOption<?> socketOption) {
        return this.options().contains(socketOption);
    }

    public final Set<SocketOption<?>> options() {
        return this.options;
    }

    public abstract void setOption(FileDescriptor var1, SocketOption<?> var2, Object var3) throws SocketException;

    public abstract Object getOption(FileDescriptor var1, SocketOption<?> var2) throws SocketException;

    protected RdmaSocketOptions(Set<SocketOption<?>> set) {
        this.options = set;
    }

    public static final RdmaSocketOptions getInstance() {
        return instance;
    }

    public static final void register(RdmaSocketOptions rdmaSocketOptions) {
        if (instance != null) {
            throw new InternalError("Attempting to reregister RDMA options");
        }
        instance = rdmaSocketOptions;
    }

    static {
        try {
            Class<?> clazz = Class.forName("jdk.net.RdmaSocketOptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            instance = new NoRdmaSocketOptions();
        }
    }

    static final class NoRdmaSocketOptions
    extends RdmaSocketOptions {
        NoRdmaSocketOptions() {
            super(Collections.emptySet());
        }

        @Override
        public void setOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption, Object object) throws SocketException {
            throw new UnsupportedOperationException("no RDMA options: " + socketOption.name());
        }

        @Override
        public Object getOption(FileDescriptor fileDescriptor, SocketOption<?> socketOption) throws SocketException {
            throw new UnsupportedOperationException("no RDMA options: " + socketOption.name());
        }
    }
}

